/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.MatteBorder;
import ucar.unidata.ui.CheckboxCategoryPanel;
import ucar.unidata.ui.DropPanel;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.StringUtil;

public class LegendPanel {
    protected JPanel contents;
    private JButton toggleBtn;
    private JPanel innerPanel;
    private JComponent topLabel;
    private JComponent extraLeft;
    protected JComponent extraRight;
    private boolean innerVisible = true;
    private boolean makeTopBorder = true;

    public LegendPanel() {
        this(null, null, null);
    }

    public LegendPanel(JComponent topLabel, JComponent extraLeft, JComponent extraRight) {
        this(topLabel, true, extraLeft, extraRight);
    }

    public LegendPanel(JComponent topLabel, boolean makeBorder, JComponent extraLeft, JComponent extraRight) {
        this.setComponents(topLabel, extraLeft, extraRight);
        this.makeTopBorder = makeBorder;
        this.innerPanel = new JPanel();
        this.innerPanel.setLayout(new BoxLayout(this.innerPanel, 1));
    }

    public JComponent getExtraRight() {
        return this.extraRight;
    }

    protected void setComponents(JComponent topLabel, JComponent extraLeft, JComponent extraRight) {
        this.topLabel = topLabel;
        this.extraLeft = extraLeft;
        this.extraRight = extraRight;
    }

    public JComponent getContents() {
        if (this.contents == null) {
            this.doMakeContents();
        }
        return this.contents;
    }

    public void reInitialize() {
        if (this.innerPanel != null) {
            this.innerPanel.removeAll();
        }
    }

    public void clear() {
        if (this.innerPanel != null) {
            this.innerPanel.removeAll();
        }
    }

    public static void walkMe(JComponent comp, String tab) {
        List<String> l = StringUtil.split(comp.getClass().getName(), ".");
        String name = l.get(l.size() - 1);
        String extra = " " + comp.getPreferredSize().width + "/" + comp.getPreferredSize().height;
        if (comp instanceof JLabel) {
            extra = extra + " \"" + ((JLabel)comp).getText() + "\"";
        }
        System.err.println(tab + name + extra);
        for (int i = 0; i < comp.getComponentCount(); ++i) {
            JComponent child = (JComponent)comp.getComponent(i);
            LegendPanel.walkMe(child, tab + " ");
        }
    }

    protected void doMakeContents() {
        MouseAdapter visListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                LegendPanel.this.toggleInnerVisible();
            }
        };
        this.toggleBtn = GuiUtils.getImageButton(this.innerVisible ? CheckboxCategoryPanel.categoryOpenIcon : CheckboxCategoryPanel.categoryClosedIcon);
        this.toggleBtn.addMouseListener(visListener);
        JPanel togglePanel = GuiUtils.inset((Component)this.toggleBtn, new Insets(0, 3, 0, 4));
        int labelHeight = this.topLabel.getPreferredSize().height;
        if (GuiUtils.checkHeight(labelHeight)) {
            this.topLabel.setPreferredSize(new Dimension(50, labelHeight));
        }
        JPanel mainPanel = GuiUtils.doLayout(null, new Component[]{togglePanel, this.extraLeft, this.topLabel, this.extraRight}, 4, GuiUtils.WT_NNYN, GuiUtils.WT_N, null, null, new Insets(0, 0, 0, 0));
        if (this.makeTopBorder) {
            mainPanel.setBorder(new LegendBorder());
        }
        this.innerPanel.setVisible(this.innerVisible);
        if (this.makeDropPanel()) {
            DropPanel dropPanel = new DropPanel(){

                @Override
                public void handleDrop(Object object) {
                    LegendPanel.this.doDrop(object);
                }

                @Override
                public boolean okToDrop(Object object) {
                    return LegendPanel.this.dropOk(object);
                }
            };
            dropPanel.add("Center", mainPanel);
            this.contents = GuiUtils.topCenter(dropPanel, this.innerPanel);
        } else {
            this.contents = GuiUtils.topCenter(mainPanel, this.innerPanel);
        }
    }

    public boolean makeDropPanel() {
        return false;
    }

    public boolean dropOk(Object object) {
        return false;
    }

    public void doDrop(Object object) {
    }

    public void add(JComponent c) {
        this.add(c, true);
    }

    public void add(JComponent c, boolean doBorder) {
        JPanel wrapper = GuiUtils.inset((Component)c, new Insets(2, 4, 2, 0));
        if (doBorder && this.innerPanel.getComponentCount() > 0) {
            wrapper.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.gray));
        }
        this.innerPanel.add(wrapper);
        wrapper.setVisible(true);
    }

    protected void setInnerVisible(boolean b) {
        this.innerVisible = b;
        if (this.toggleBtn == null || this.innerPanel == null) {
            return;
        }
        if (this.innerVisible) {
            this.toggleBtn.setIcon(CheckboxCategoryPanel.categoryOpenIcon);
        } else {
            this.toggleBtn.setIcon(CheckboxCategoryPanel.categoryClosedIcon);
        }
        this.innerPanel.setVisible(this.innerVisible);
        this.innerPanel.invalidate();
        this.contents.validate();
    }

    public boolean getInnerVisible() {
        return this.innerVisible;
    }

    protected void toggleInnerVisible() {
        this.setInnerVisible(!this.innerVisible);
    }

    private static class LegendBorder
    extends MatteBorder {
        public LegendBorder() {
            super(2, 0, 2, 0, Color.black);
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.setColor(Color.black);
            g.drawLine(x, y, x + width, y);
            g.setColor(Color.white);
            g.drawLine(x, y + 1, x + width, y + 1);
            g.setColor(Color.black);
            g.drawLine(x, y + height - 2, x + width, y + height - 2);
            g.setColor(Color.white);
            g.drawLine(x, y + height - 1, x + width, y + height - 1);
        }
    }
}

