/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.ui;

import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.text.JTextComponent;
import org.python.core.PyException;
import org.python.core.PyFunction;
import org.python.core.PyJavaPackage;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyReflectedFunction;
import org.python.core.PyStringMap;
import org.python.core.PySystemState;
import org.python.core.PyTuple;
import org.python.util.PythonInterpreter;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataOperand;
import ucar.unidata.data.DataSourceDescriptor;
import ucar.unidata.data.DerivedDataChoice;
import ucar.unidata.idv.ControlDescriptor;
import ucar.unidata.idv.IntegratedDataViewer;
import ucar.unidata.idv.ui.ImageGenerator;
import ucar.unidata.ui.InteractiveShell;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.StringUtil;
import visad.Data;
import visad.MathType;
import visad.jmet.DumpType;

public class JythonShell
extends InteractiveShell {
    public static final String PROP_JYTHON_SHELL_HISTORY = "prop.jython.shell.history";
    private IntegratedDataViewer idv;
    private PythonInterpreter interp;
    private OutputStream outputStream;
    private boolean autoSelect = false;
    ImageGenerator islInterpreter;

    public JythonShell(IntegratedDataViewer theIdv) {
        super("Jython Shell");
        this.idv = theIdv;
        List oldHistory = (List)this.idv.getStore().get(PROP_JYTHON_SHELL_HISTORY);
        if (oldHistory != null) {
            this.history = new ArrayList(oldHistory);
        }
        this.createInterpreter();
        this.init();
    }

    public void listHistory() {
        for (int i = 0; i < this.history.size(); ++i) {
            super.eval((String)this.history.get(i));
        }
    }

    public void saveHistory() {
        this.idv.getStore().put(PROP_JYTHON_SHELL_HISTORY, (Object)this.history);
        this.idv.getStore().save();
    }

    @Override
    protected void makeFrame() {
        super.makeFrame();
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (JythonShell.this.interp != null) {
                    JythonShell.this.idv.getJythonManager().removeInterpreter(JythonShell.this.interp);
                }
            }
        });
    }

    private PythonInterpreter getInterpreter() {
        if (this.interp == null) {
            this.createInterpreter();
        }
        return this.interp;
    }

    public void showProcedurePopup(JTextComponent cmdFld) {
        String t = cmdFld.getText();
        t = null;
        ArrayList<JMenu> items = new ArrayList<JMenu>();
        if (this.history.size() > 0) {
            ArrayList<JMenuItem> historyItems = new ArrayList<JMenuItem>();
            for (int i = this.history.size() - 1; i >= 0; --i) {
                historyItems.add(GuiUtils.makeMenuItem(this.history.get(i).toString(), this, "eval", this.history.get(i)));
            }
            items.add(GuiUtils.makeMenu("History", historyItems));
        }
        items.add(GuiUtils.makeMenu("Insert Procedure Call", this.idv.getJythonManager().makeProcedureMenu(this, "insertText", t)));
        JMenu dataMenu = GuiUtils.makeMenu("Insert Data Source Type", this.getDataMenuItems());
        GuiUtils.limitMenuSize(dataMenu, "Data Source Types", 10);
        items.add(dataMenu);
        items.add(GuiUtils.makeMenu("Insert Display Type", this.getDisplayMenuItems()));
        items.add(GuiUtils.makeMenu("Insert Idv Action", this.idv.getIdvUIManager().makeActionMenu(this, "insertText", true)));
        JPopupMenu popup = GuiUtils.makePopupMenu(items);
        if (popup != null) {
            popup.show(cmdFld, 0, (int)cmdFld.getBounds().getHeight());
        }
    }

    public void listVars() {
        PyStringMap seq = (PyStringMap)this.getInterpreter().getLocals();
        PyList items = seq.items();
        StringBuffer sb = new StringBuffer("Variables:<br>");
        for (int itemIdx = 0; itemIdx < items.__len__(); ++itemIdx) {
            PyTuple pair = (PyTuple)items.__finditem__(itemIdx);
            PyObject obj = pair.__finditem__(1);
            String name = pair.__finditem__(0).toString();
            if (obj instanceof PyFunction || obj instanceof PyReflectedFunction || obj instanceof PyJavaPackage || obj instanceof PySystemState || obj instanceof PyJavaPackage || name.startsWith("__") || name.equals("JyVars")) continue;
            sb.append("&nbsp;&nbsp;&nbsp;" + name + "<br>");
        }
        this.output(sb.toString());
    }

    public void insertAction(String action) {
        this.insertText("idv.handleAction('action:" + action + "')");
    }

    @Override
    protected void handleKeyPress(KeyEvent e, JTextComponent cmdFld) {
        super.handleKeyPress(e, cmdFld);
        if (e.getKeyCode() == 77 && e.isControlDown()) {
            this.showProcedurePopup(cmdFld);
            return;
        }
    }

    public void showHelp() {
        this.idv.getIdvUIManager().showHelp("idv.tools.jythonshell");
    }

    public void exportHistory() {
        if (this.history.size() == 0) {
            LogUtil.userMessage("There are no commands to export");
            return;
        }
        String procedureName = GuiUtils.getInput("Enter optional procedure name", "Procedure name: ", "", " (Leave blank for no procedure)");
        if (procedureName == null) {
            return;
        }
        String s = procedureName.trim().length() == 0 ? StringUtil.join("\n", this.history) : "def " + procedureName + "():\n" + "    " + StringUtil.join("\n    ", this.history);
        s = "#From shell\n" + s + "\n\n";
        this.idv.getJythonManager().appendJython(s);
    }

    private void createInterpreter() {
        if (this.interp != null) {
            this.idv.getJythonManager().removeInterpreter(this.interp);
        }
        try {
            this.interp = this.idv.getJythonManager().createInterpreter();
        }
        catch (Exception exc) {
            LogUtil.logException("An error occurred creating the interpeter", exc);
            return;
        }
        if (this.islInterpreter == null) {
            this.islInterpreter = new ImageGenerator(this.idv);
        }
        this.interp.set("islInterpreter", this.islInterpreter);
        this.interp.set("shell", this);
        this.outputStream = new OutputStream(){

            @Override
            public void write(int b) {
            }

            @Override
            public void write(byte[] b, int off, int len) {
                String s = new String(new String(b, off, len));
                s = StringUtil.replace(s, "\n", "<br>");
                s = StringUtil.replace(s, " ", "&nbsp;");
                s = StringUtil.replace(s, "\t", "&nbsp;&nbsp;&nbsp;&nbsp;");
                JythonShell.this.output(s);
            }
        };
        this.interp.setOut(this.outputStream);
        this.interp.setErr(this.outputStream);
    }

    @Override
    public void clear() {
        try {
            super.clear();
            this.createInterpreter();
        }
        catch (Exception exc) {
            LogUtil.logException("An error occurred clearing the Jython shell", exc);
        }
    }

    @Override
    protected JMenuBar doMakeMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        ArrayList<JMenuItem> items = new ArrayList<JMenuItem>();
        items.add(GuiUtils.makeMenuItem("Export Commands", this, "exportHistory"));
        items.add(GuiUtils.makeMenuItem("Save History", this, "saveHistory"));
        items.add(GuiUtils.makeMenuItem("List History", this, "listHistory"));
        items.add(GuiUtils.makeMenuItem("List Variables", this, "listVars"));
        menuBar.add(GuiUtils.makeMenu("File", items));
        items = new ArrayList();
        items.add(GuiUtils.makeMenuItem("Clear All", this, "clear"));
        items.add(GuiUtils.makeMenuItem("Clear Output", this, "clearOutput"));
        items.add(GuiUtils.makeCheckboxMenuItem("Auto-select Operands", this, "autoSelect", null));
        menuBar.add(GuiUtils.makeMenu("Edit", items));
        items = new ArrayList();
        items.add(GuiUtils.makeMenuItem("Help", this, "showHelp"));
        menuBar.add(GuiUtils.makeMenu("Help", items));
        return menuBar;
    }

    protected List getDisplayMenuItems() {
        ArrayList<JMenu> displayMenuItems = new ArrayList<JMenu>();
        List cds = this.idv.getControlDescriptors();
        Hashtable<String, JMenu> catMenus = new Hashtable<String, JMenu>();
        for (int i = 0; i < cds.size(); ++i) {
            ControlDescriptor cd = (ControlDescriptor)cds.get(i);
            JMenu catMenu = (JMenu)catMenus.get(cd.getDisplayCategory());
            if (catMenu == null) {
                catMenu = new JMenu(cd.getDisplayCategory());
                catMenus.put(cd.getDisplayCategory(), catMenu);
                displayMenuItems.add(catMenu);
            }
            catMenu.add(GuiUtils.makeMenuItem(cd.getDescription(), this, "insert", "'" + cd.getControlId() + "'"));
        }
        return displayMenuItems;
    }

    protected List getDataMenuItems() {
        ArrayList<JMenuItem> items = new ArrayList<JMenuItem>();
        for (DataSourceDescriptor descriptor : this.idv.getDataManager().getDescriptors()) {
            List<String> ids = StringUtil.split(descriptor.getId(), ",", true, true);
            String label = descriptor.getLabel();
            if (label == null || label.trim().length() == 0) {
                label = "" + ids.get(0);
            }
            items.add(GuiUtils.makeMenuItem(label, this, "insert", "'" + ids.get(0) + "'"));
        }
        return items;
    }

    @Override
    protected void handleRightMouseClick(JTextComponent commandFld, MouseEvent e) {
        this.showProcedurePopup(commandFld);
    }

    @Override
    protected String formatCode(String code) {
        String html = StringUtil.replace(code.trim(), "\n", "<br>");
        html = StringUtil.replace(html, " ", "&nbsp;");
        html = StringUtil.replace(html, "\t", "&nbsp;&nbsp;&nbsp;&nbsp;");
        html = html.replace("<", "&lt;");
        html = html.replace(">", "&gt;");
        return html;
    }

    @Override
    public void eval(String jython) {
        try {
            if (jython.trim().length() == 0) {
                return;
            }
            super.eval(jython);
            StringBuffer sb = new StringBuffer();
            List<String> lines = StringUtil.split(jython, "\n", false, false);
            for (int i = 0; i < lines.size(); ++i) {
                String line = lines.get(i);
                if (line.trim().startsWith("?")) {
                    while (!line.startsWith("?")) {
                        sb.append(line.substring(0, 1));
                        line = line.substring(1);
                    }
                    line = "print " + line.trim().substring(1);
                }
                sb.append(line);
                sb.append("\n");
            }
            String code = sb.toString().trim();
            if (this.autoSelect && !code.startsWith("import") && !code.startsWith("from")) {
                int idx;
                while ((idx = code.indexOf("=")) >= 0) {
                    code = code.substring(idx + 1);
                }
                List operands = DerivedDataChoice.parseOperands(code);
                ArrayList<DataOperand> unboundOperands = new ArrayList<DataOperand>();
                for (int i = 0; i < operands.size(); ++i) {
                    DataOperand operand = (DataOperand)operands.get(i);
                    PyObject obj = this.interp.get(operand.getParamName());
                    if (obj != null) continue;
                    unboundOperands.add(operand);
                }
                if (unboundOperands.size() > 0) {
                    List result = this.idv.selectDataChoices(unboundOperands);
                    if (result == null) {
                        return;
                    }
                    for (int i = 0; i < result.size(); ++i) {
                        DataOperand operand = (DataOperand)operands.get(i);
                        Data data = ((DataChoice)result.get(i)).getData(null);
                        this.interp.set(operand.getParamName(), data);
                    }
                }
            }
            PythonInterpreter interp = this.getInterpreter();
            this.startBufferingOutput();
            interp.exec(sb.toString());
            this.endBufferingOutput();
        }
        catch (PyException pse) {
            this.endBufferingOutput();
            this.output("<font color=\"red\">Error: " + pse.toString() + "</font><br>");
        }
        catch (Exception exc) {
            this.endBufferingOutput();
            this.output("<font color=\"red\">Error: " + exc + "</font><br>");
        }
    }

    public void printType(Data d) {
        try {
            this.startBufferingOutput();
            MathType t = d.getType();
            DumpType.dumpMathType(t, this.outputStream);
            this.output("<hr>DataType analysis...");
            DumpType.dumpDataType(d, this.outputStream);
        }
        catch (Exception exc) {
            LogUtil.logException("An error occurred printing types", exc);
        }
        this.endBufferingOutput();
    }

    public void setAutoSelect(boolean value) {
        this.autoSelect = value;
    }

    public boolean getAutoSelect() {
        return this.autoSelect;
    }
}

