/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.ui;

import java.awt.Component;
import java.awt.Insets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ucar.unidata.idv.IdvPersistenceManager;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.xml.XmlUtil;

public class IslDialog {
    private JTabbedPane tabs;
    private JCheckBox offscreenCbx;
    private JCheckBox inlineCbx;
    private JCheckBox imageCbx;
    private JCheckBox debugCbx;
    private JTextField imageFld;
    private List datasetFlds = new ArrayList();
    private JTextField sleepFld;
    private JTextField loopFld;
    private JTextField widthFld;
    private JTextField heightFld;
    private JCheckBox movieCbx;
    private JTextField movieFld;
    private JTextField importFld;
    private JComponent islContents;
    private IdvPersistenceManager persistenceManager;

    public IslDialog(IdvPersistenceManager persistenceManager) {
        this.persistenceManager = persistenceManager;
    }

    public void writeIsl(String islFile, String bundleXml) throws IOException {
        Element imageNode;
        String tail = IOUtil.getFileTail(islFile);
        String xidvFile = IOUtil.stripExtension(islFile) + ".xidv";
        boolean hasMultipleViews = this.persistenceManager.getIdv().getVMManager().getViewManagers().size() > 1;
        String extra = hasMultipleViews ? "_${viewindex}" : "";
        String pngFile = "${islpath}/" + IOUtil.stripExtension(tail) + extra + ".png";
        String movFile = "${islpath}/" + IOUtil.stripExtension(tail) + extra + ".mov";
        if (this.islContents == null) {
            ArrayList<JComponent> comps1 = new ArrayList<JComponent>();
            ArrayList<JComponent> comps2 = new ArrayList<JComponent>();
            this.offscreenCbx = new JCheckBox("Offscreen", true);
            this.debugCbx = new JCheckBox("Debug", true);
            this.inlineCbx = new JCheckBox("Include Bundle Inline", false);
            this.imageCbx = new JCheckBox("", true);
            this.imageFld = new JTextField(pngFile, 30);
            this.imageFld.setToolTipText("<html><b>.png,.gif,.jpg</b> for images<br><b>.kml/kmz</b> for Google Earth<br>Use ${viewindex} for each view<br>Use ${viewname} for view name<br>Use ${loopindex} for each loop iteration");
            comps1.add(GuiUtils.rLabel("Generate an Image:"));
            comps1.add(GuiUtils.leftCenterRight(this.imageCbx, this.imageFld, GuiUtils.makeFileBrowseButton(this.imageFld)));
            this.movieCbx = new JCheckBox("", false);
            this.movieFld = new JTextField(movFile, 30);
            this.movieFld.setToolTipText("<html><b>.mov</b> for Quicktime<br><b>.gif</b> for animated GIF<br><b>.kml/kmz</b> for Google Earth<br><b>.html</b> for AniS Applet<br>Use ${viewindex} for each view<br>Use ${viewname} for view name<br>Use ${loopindex} for each loop iteration");
            comps1.add(GuiUtils.rLabel("Generate a Movie:"));
            comps1.add(GuiUtils.leftCenterRight(this.movieCbx, this.movieFld, GuiUtils.makeFileBrowseButton(this.movieFld)));
            comps2.add(GuiUtils.rLabel("Flags:"));
            List lineComps = Misc.newList(this.offscreenCbx, this.debugCbx, this.inlineCbx);
            comps2.add(GuiUtils.left(GuiUtils.hbox(lineComps, 5)));
            this.loopFld = new JTextField("1", 5);
            this.sleepFld = new JTextField("60", 5);
            this.widthFld = new JTextField("", 4);
            this.heightFld = new JTextField("", 4);
            comps2.add(GuiUtils.rLabel("#Iterations:"));
            comps2.add(GuiUtils.left(GuiUtils.hbox((Component)this.loopFld, (Component)GuiUtils.rLabel("   Sleep Time:  "), (Component)this.sleepFld, new JLabel(" (minutes)"))));
            this.widthFld.setToolTipText("View width");
            this.heightFld.setToolTipText("View height");
            comps2.add(GuiUtils.rLabel("Dimensions:"));
            comps2.add(GuiUtils.left(GuiUtils.hbox((Component)this.widthFld, (Component)new JLabel(" X "), (Component)this.heightFld, new JLabel(" Optional View Dimensions"))));
            this.importFld = new JTextField("", 30);
            comps2.add(GuiUtils.rLabel("Import ISL File:"));
            comps2.add(GuiUtils.centerRight(this.importFld, GuiUtils.makeFileBrowseButton(this.importFld)));
            GuiUtils.tmpInsets = new Insets(5, 5, 5, 5);
            this.tabs = new JTabbedPane();
            JPanel tab1 = GuiUtils.doLayout(comps1, 2, GuiUtils.WT_NY, GuiUtils.WT_N);
            GuiUtils.tmpInsets = new Insets(5, 5, 5, 5);
            JPanel tab2 = GuiUtils.doLayout(comps2, 2, GuiUtils.WT_NY, GuiUtils.WT_N);
            this.tabs.addTab("Product", GuiUtils.top(tab1));
            this.tabs.addTab("Advanced", GuiUtils.top(tab2));
            this.islContents = this.tabs;
        }
        if (!GuiUtils.showOkCancelDialog(null, "ISL Properties", this.islContents, null)) {
            return;
        }
        IOUtil.writeFile(xidvFile, bundleXml);
        Document doc = XmlUtil.makeDocument();
        Element root = doc.createElement("isl");
        root.setAttribute("loop", this.loopFld.getText().trim());
        double sleepMinutes = new Double(this.sleepFld.getText().trim());
        root.setAttribute("sleep", "" + sleepMinutes + "minutes");
        root.setAttribute("offscreen", "" + this.offscreenCbx.isSelected());
        root.setAttribute("debug", "" + this.debugCbx.isSelected());
        Element bundleNode = doc.createElement("bundle");
        root.appendChild(bundleNode);
        if (this.widthFld.getText().trim().length() > 0 && this.heightFld.getText().trim().length() > 0) {
            bundleNode.setAttribute("width", this.widthFld.getText().trim());
            bundleNode.setAttribute("height", this.heightFld.getText().trim());
        }
        if (this.inlineCbx.isSelected()) {
            bundleNode.appendChild(doc.createTextNode(XmlUtil.encodeBase64(bundleXml.getBytes())));
        } else {
            bundleNode.setAttribute("file", "${islpath}/" + IOUtil.getFileTail(xidvFile));
            bundleNode.setAttribute("wait", "true");
            bundleNode.setAttribute("clear", "true");
        }
        if (this.importFld.getText().trim().length() > 0) {
            Element importNode = doc.createElement("import");
            importNode.setAttribute("file", this.importFld.getText().trim());
            root.appendChild(importNode);
        }
        if (this.imageCbx.isSelected()) {
            imageNode = doc.createElement("image");
            root.appendChild(imageNode);
            imageNode.setAttribute("file", this.imageFld.getText().trim());
        }
        if (this.movieCbx.isSelected()) {
            imageNode = doc.createElement("movie");
            root.appendChild(imageNode);
            imageNode.setAttribute("file", this.movieFld.getText().trim());
        }
        IOUtil.writeFile(islFile, XmlUtil.toStringWithHeader(root));
    }
}

