/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.ui;

import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import ucar.unidata.data.GeoLocationInfo;
import visad.DateTime;

public class ImageWrapper {
    private String path;
    private DateTime dttm;
    private GeoLocationInfo bounds;
    private double[] position;
    private Hashtable properties;

    public ImageWrapper(String path) {
        this(path, null, null, null);
    }

    public ImageWrapper(String path, DateTime dttm) {
        this(path, dttm, null, null);
    }

    public ImageWrapper(String path, DateTime dttm, GeoLocationInfo bounds) {
        this(path, dttm, bounds, null);
    }

    public ImageWrapper(String path, DateTime dttm, GeoLocationInfo bounds, double[] position) {
        this.path = path;
        this.dttm = dttm;
        this.bounds = bounds;
        this.position = position;
    }

    public static List<String> makeFileList(List<ImageWrapper> wrappers) {
        ArrayList<String> files = new ArrayList<String>();
        for (ImageWrapper imageWrapper : wrappers) {
            files.add(imageWrapper.path);
        }
        return files;
    }

    public static List<ImageWrapper> makeImageWrappers(List source) {
        ArrayList<ImageWrapper> result = new ArrayList<ImageWrapper>();
        for (int i = 0; i < source.size(); ++i) {
            Object o = source.get(i);
            if (o instanceof ImageWrapper) {
                result.add((ImageWrapper)o);
                continue;
            }
            result.add(new ImageWrapper(o.toString()));
        }
        return result;
    }

    public String toString() {
        return this.path;
    }

    public void deleteFile() {
        new File(this.path).delete();
    }

    public void setPath(String value) {
        this.path = value;
    }

    public String getPath() {
        return this.path;
    }

    public void setDttm(DateTime value) {
        this.dttm = value;
    }

    public DateTime getDttm() {
        return this.dttm;
    }

    public void setBounds(GeoLocationInfo value) {
        this.bounds = value;
    }

    public GeoLocationInfo getBounds() {
        return this.bounds;
    }

    public void setPosition(double[] value) {
        this.position = value;
    }

    public double[] getPosition() {
        return this.position;
    }

    public void setProperties(Hashtable value) {
        this.properties = value;
    }

    public Hashtable getProperties() {
        return this.properties;
    }

    public Object getProperty(Object key) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(key);
    }
}

