/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.ui;

import ij.ImagePlus;
import java.awt.AWTException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ucar.unidata.data.GeoLocationInfo;
import ucar.unidata.data.gis.KmlDataSource;
import ucar.unidata.idv.IdvObjectStore;
import ucar.unidata.idv.IntegratedDataViewer;
import ucar.unidata.idv.MapViewManager;
import ucar.unidata.idv.ViewManager;
import ucar.unidata.idv.flythrough.Flythrough;
import ucar.unidata.idv.ui.ImageGenerator;
import ucar.unidata.idv.ui.ImageWrapper;
import ucar.unidata.ui.AnimatedGifEncoder;
import ucar.unidata.ui.ImagePanel;
import ucar.unidata.ui.ImageUtils;
import ucar.unidata.ui.JpegImagesToMovie;
import ucar.unidata.util.FileManager;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.PatternFileFilter;
import ucar.unidata.util.StringUtil;
import ucar.unidata.xml.XmlUtil;
import ucar.visad.UtcDate;
import ucar.visad.display.Animation;
import ucar.visad.display.AnimationWidget;
import visad.DateTime;
import visad.Real;

public class ImageSequenceGrabber
implements Runnable,
ActionListener {
    public static final String ATTR_ANIS_HEIGHT = "anis_height";
    public static final String ATTR_ANIS_POSTHTML = "anis_posthtml";
    public static final String ATTR_ANIS_PREHTML = "anis_prehtml";
    public static final String ATTR_ANIS_TYPE = "anis_type";
    public static final String ATTR_ANIS_WIDTH = "anis_width";
    public static final String ATTR_APPENDTIME = "appendtime";
    public static final String ATTR_FILENAME = "filename";
    public static final String ATTR_IMAGEDIR = "imagedir";
    public static final String ATTR_IMAGEPREFIX = "imageprefix";
    public static final String ATTR_IMAGESUFFIX = "imagesuffix";
    public static final String ATTR_IMAGETEMPLATE = "imagetemplate";
    public static final String ATTR_KML_DESC = "kml_desc";
    public static final String ATTR_KML_NAME = "kml_name";
    public static final String ATTR_KML_OPEN = "kml_open";
    public static final String ATTR_KML_VISIBILITY = "kml_visibility";
    public static final String ATTR_STEPS = "steps";
    public static final String ATTR_VIEWPOINTFILE = "viewpointfile";
    public static final String CMD_CLEAR = "clear";
    public static final String CMD_GRAB = "grab";
    public static final String CMD_GRAB_ANIMATION = "grab.animation";
    public static final String CMD_PREVIEW_CLOSE = "preview.close";
    public static final String CMD_PREVIEW_DELETE = "preview.delete";
    public static final String CMD_PREVIEW_NEXT = "preview.next";
    public static final String CMD_PREVIEW_PLAY = "preview.play";
    public static final String CMD_PREVIEW_PREV = "preview.prev";
    public static final String CMD_PREVIEW_SHOW = "preview.show";
    public static final String CMD_PUBLISH = "publish";
    public static final String PROP_IMAGEALTDIR = "imagesequencegrabber.altdir";
    public static final String PROP_IMAGETEMPLATE = "imagesequencegrabber.template";
    public static final String PREF_USE_GLOBAL_PALETTE = "idv.capture.gif.useGlobalTable";
    public static final String GLOBAL_PALETTE_TOOLTIP = "<html>Turn off to correct colors for varying color animations.<br/><br/></br/>This option controls whether or not a resulting GIF image will use a color palette<br/>taken from all the frames of the animation.<br/><br/>If the option is turned off, the animation's frames will use their own color palettes.<br/>This can result in the same color value looking different between different frames<br/>in the resulting animated GIF.</html>";
    private static int SLEEP_TIME = 500;
    public static final PatternFileFilter FILTER_ANIS = new PatternFileFilter(".+\\.html|.+\\.htm", "AniS or FlAniS HTML File (*.html)", ".html");
    public static final String TAG_DESCRIPTION = "description";
    public static final String TAG_VISIBILITY = "visibility";
    private static JCheckBox copyCbx;
    private static String dfltAltDir;
    private static String dfltTemplate;
    private static JTextField heightFld;
    private static JTextArea postFld;
    private static JTextArea preFld;
    private static JCheckBox typeCbx;
    private static JTextField widthFld;
    private Object MUTEX = new Object();
    private int captureTimeStamp = 0;
    private boolean capturingAnim = false;
    private boolean capturingAuto = false;
    private JCheckBox beepCbx = new JCheckBox("Beep", false);
    int imageCnt = 0;
    int previewIndex = 0;
    private float quality = 1.0f;
    boolean paused = false;
    private boolean isPlaying = false;
    List<ImageWrapper> images = new ArrayList<ImageWrapper>();
    private int timestamp = 0;
    boolean notifiedForTransparent = false;
    private boolean justCaptureAnimation = false;
    private JCheckBox grabFlythroughCbx = new JCheckBox("Capture Flythrough", false);
    JCheckBox animationResetCbx = new JCheckBox("Reset to start time", true);
    private List alternateComps = new ArrayList();
    private boolean writePositions = false;
    JRadioButton allViewsBtn;
    private JComponent alternateComponent;
    private JCheckBox alternateDirCbx;
    private JTextField alternateDirFld;
    JCheckBox backgroundTransparentBtn;
    JTextField captureRateFld;
    JButton clearButton;
    JButton closeButton;
    JRadioButton contentsBtn;
    JButton createButton;
    JButton deleteFrameButton;
    String directory;
    JTextField displayRateFld;
    JTextField endPauseFld;
    private JTextField fileTemplateFld;
    JLabel frameLbl;
    JRadioButton fullScreenBtn;
    JRadioButton fullWindowBtn;
    JButton grabAnimationBtn;
    JButton grabAutoBtn;
    JButton grabBtn;
    private JRadioButton hiBtn;
    private IntegratedDataViewer idv;
    private ImageGenerator imageGenerator;
    Dimension imageSize;
    String lastPreview;
    private JRadioButton lowBtn;
    JDialog mainDialog;
    JRadioButton mainDisplayBtn;
    private JRadioButton medBtn;
    private String movieFileName;
    JButton nextButton;
    private JCheckBox overwriteCbx;
    JButton playButton;
    private ImageIcon playIcon;
    JButton prevButton;
    JButton previewButton;
    JDialog previewDialog;
    JLabel previewLbl;
    ImagePanel previewPanel;
    JTextField previewRateFld;
    private JComboBox publishCbx;
    private Element scriptingNode;
    private ImageIcon stopIcon;
    private ViewManager viewManager;

    public ImageSequenceGrabber(ViewManager viewManager) {
        this(viewManager, null);
    }

    public ImageSequenceGrabber(ViewManager viewManager, JComponent alternateComponent) {
        this(viewManager, alternateComponent, false);
    }

    public ImageSequenceGrabber(ViewManager viewManager, JComponent alternateComponent, boolean justCaptureAnimation) {
        this.alternateComponent = alternateComponent;
        this.viewManager = viewManager;
        this.idv = viewManager.getIdv();
        this.justCaptureAnimation = justCaptureAnimation;
        this.init();
        if (this.justCaptureAnimation) {
            this.startAnimationCapture();
        }
    }

    public ImageSequenceGrabber(ViewManager viewManager, String filename, IntegratedDataViewer idv) {
        this(viewManager, filename, idv, null, null);
    }

    public ImageSequenceGrabber(ViewManager viewManager, String filename, IntegratedDataViewer idv, ImageGenerator imageGenerator, Element scriptingNode) {
        this.viewManager = viewManager;
        this.imageGenerator = imageGenerator;
        this.scriptingNode = scriptingNode;
        this.movieFileName = filename;
        if (scriptingNode != null) {
            this.movieFileName = imageGenerator.applyMacros(scriptingNode, ATTR_FILENAME, this.movieFileName);
        }
        this.idv = idv;
        this.init();
        this.startAnimationCapture();
    }

    public ImageSequenceGrabber(String filename, IntegratedDataViewer idv, ImageGenerator imageGenerator, Element scriptingNode, List<ImageWrapper> imageFiles, Dimension size, double displayRate) {
        this(filename, idv, imageGenerator, scriptingNode, imageFiles, size, displayRate, -1.0);
    }

    public ImageSequenceGrabber(String filename, IntegratedDataViewer idv, ImageGenerator imageGenerator, Element scriptingNode, List<ImageWrapper> imageFiles, Dimension size, double displayRate, double endPause) {
        this.idv = idv;
        this.imageGenerator = imageGenerator;
        this.scriptingNode = scriptingNode;
        this.images = ImageWrapper.makeImageWrappers(imageFiles);
        this.idv = idv;
        this.movieFileName = filename;
        this.createMovie(this.movieFileName, this.images, size, displayRate, scriptingNode, endPause);
    }

    public void show() {
        this.mainDialog.setVisible(true);
    }

    private JButton makeButton(ImageIcon icon, String cmd, String tooltip) {
        JButton b = GuiUtils.getImageButton(icon);
        b.setActionCommand(cmd);
        b.addActionListener(this);
        b.setToolTipText(tooltip);
        return b;
    }

    private JButton makeButton(String label, String cmd) {
        JButton b = new JButton(label);
        b.setActionCommand(cmd);
        b.addActionListener(this);
        return b;
    }

    private JComponent addAltComp(JComponent comp) {
        this.alternateComps.add(comp);
        GuiUtils.enableTree(comp, false);
        return comp;
    }

    private AnimationWidget getAnimationWidget() {
        Flythrough flythrough;
        if (this.grabFlythroughCbx != null && this.grabFlythroughCbx.isSelected() && this.viewManager instanceof MapViewManager && (flythrough = ((MapViewManager)this.viewManager).getFlythrough()) != null) {
            return flythrough.getAnimationWidget();
        }
        AnimationWidget animationWidget = this.viewManager.getAnimationWidget();
        if (animationWidget == null) {
            animationWidget = this.viewManager.getExternalAnimationWidget();
        }
        return animationWidget;
    }

    private Animation getAnimation() {
        Flythrough flythrough;
        if (this.grabFlythroughCbx != null && this.grabFlythroughCbx.isSelected() && this.viewManager instanceof MapViewManager && (flythrough = ((MapViewManager)this.viewManager).getFlythrough()) != null) {
            return flythrough.getAnimation();
        }
        Animation anime = this.viewManager.getAnimation();
        if (anime == null) {
            anime = this.viewManager.getExternalAnimation();
        }
        return anime;
    }

    private void init() {
        this.directory = IOUtil.joinDir(this.viewManager.getStore().getUserTmpDirectory(), "images_" + System.currentTimeMillis());
        IOUtil.makeDir(this.directory);
        this.mainDialog = GuiUtils.createDialog("Movie Capture", false);
        this.frameLbl = GuiUtils.cLabel("No frames");
        this.displayRateFld = new JTextField("2", 3);
        this.endPauseFld = new JTextField("2", 3);
        this.endPauseFld.setToolTipText("Number of seconds to pause on last frame of animated GIF");
        this.captureRateFld = new JTextField("2", 3);
        String imgp = "/auxdata/ui/icons/";
        this.mainDisplayBtn = new JRadioButton("Current View", true);
        this.allViewsBtn = new JRadioButton("All Views", false);
        this.contentsBtn = new JRadioButton("Current View & Legend", false);
        this.fullWindowBtn = new JRadioButton("Full Window", false);
        this.fullScreenBtn = new JRadioButton("Full Screen", false);
        ButtonGroup bg = GuiUtils.buttonGroup(this.mainDisplayBtn, this.fullWindowBtn);
        bg.add(this.allViewsBtn);
        bg.add(this.contentsBtn);
        bg.add(this.fullScreenBtn);
        this.beepCbx.setToolTipText("Beep when an image is captured");
        List btns = Misc.newList(new Object[]{new JLabel("What to capture:"), this.mainDisplayBtn, this.allViewsBtn, this.contentsBtn, this.fullWindowBtn, this.fullScreenBtn});
        btns.add(this.beepCbx);
        JPanel whatPanel = GuiUtils.vbox(btns);
        if (dfltAltDir == null) {
            dfltAltDir = this.idv.getStore().get(PROP_IMAGEALTDIR, "");
        }
        this.alternateDirFld = new JTextField(dfltAltDir, 30);
        JButton alternateDirBtn = new JButton("Select");
        GuiUtils.setupDirectoryChooser(alternateDirBtn, this.alternateDirFld);
        if (dfltTemplate == null) {
            dfltTemplate = this.idv.getStore().get(PROP_IMAGETEMPLATE, "image_%count%_%time%");
        }
        this.fileTemplateFld = new JTextField(dfltTemplate, 30);
        this.fileTemplateFld.setToolTipText("<html>Enter the file name template to use.<br><b>%count%</b> is the image counter<br><b>%count:decimal format%</b> allows you to format the count. Google 'java decimalformat' for more information.<br><b>%time%</b> is the  animation time in the default format<br><b>%time:some time format string%</b> a macro that begins with &quot;time:&quot;,contains a time format string using the:<br>java SimpleDateFormat formatting (see google).</html>");
        this.overwriteCbx = new JCheckBox("Overwrite", false);
        this.alternateDirCbx = new JCheckBox("Save Files To:", false);
        this.alternateDirCbx.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                for (int i = 0; i < ImageSequenceGrabber.this.alternateComps.size(); ++i) {
                    GuiUtils.enableTree((JComponent)ImageSequenceGrabber.this.alternateComps.get(i), ImageSequenceGrabber.this.alternateDirCbx.isSelected());
                }
            }
        });
        this.hiBtn = new JRadioButton("High", true);
        this.medBtn = new JRadioButton("Better", false);
        this.lowBtn = new JRadioButton("Low", false);
        GuiUtils.buttonGroup(this.hiBtn, this.medBtn).add(this.lowBtn);
        this.grabBtn = this.makeButton("One Image", CMD_GRAB);
        this.grabAutoBtn = this.makeButton("Automatically", GuiUtils.CMD_START);
        this.grabAnimationBtn = this.makeButton("Time Animation", CMD_GRAB_ANIMATION);
        this.grabFlythroughCbx = new JCheckBox("Flythrough", false);
        boolean hasFlythrough = false;
        if (this.viewManager instanceof MapViewManager && ((MapViewManager)this.viewManager).getFlythrough() != null) {
            hasFlythrough = ((MapViewManager)this.viewManager).getFlythrough().hasPoints();
        }
        ArrayList<JButton> frameButtons = new ArrayList<JButton>();
        this.previewButton = this.makeButton("Preview", CMD_PREVIEW_SHOW);
        frameButtons.add(this.previewButton);
        this.clearButton = this.makeButton("Delete All", CMD_CLEAR);
        frameButtons.add(this.clearButton);
        this.createButton = this.makeButton("Save Movie", GuiUtils.CMD_OK);
        frameButtons.add(this.createButton);
        if (this.idv.getPublishManager().isPublishingEnabled()) {
            // empty if block
        }
        this.closeButton = this.makeButton("Close", GuiUtils.CMD_CLOSE);
        JLabel titleLbl = GuiUtils.cLabel("Note: Make sure the view window is not obscured");
        JPanel titlePanel = GuiUtils.inset((Component)titleLbl, 8);
        JPanel runPanel = GuiUtils.hflow(Misc.newList(GuiUtils.rLabel(" Rate: "), this.captureRateFld, new JLabel(" seconds")));
        int maxBtnWidth = Math.max(this.grabAnimationBtn.getPreferredSize().width, Math.max(this.grabBtn.getPreferredSize().width, this.grabAutoBtn.getPreferredSize().width));
        GuiUtils.tmpInsets = new Insets(5, 5, 5, 5);
        JPanel capturePanel = GuiUtils.doLayout(new Component[]{this.grabBtn, GuiUtils.filler(), GuiUtils.top(this.grabAnimationBtn), GuiUtils.vbox(this.animationResetCbx, hasFlythrough ? this.grabFlythroughCbx : GuiUtils.filler()), this.grabAutoBtn, runPanel, GuiUtils.filler(maxBtnWidth + 10, 1), GuiUtils.filler()}, 2, GuiUtils.WT_N, GuiUtils.WT_N);
        this.backgroundTransparentBtn = new JCheckBox("Background Transparent");
        this.backgroundTransparentBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (ImageSequenceGrabber.this.backgroundTransparentBtn.isSelected() && !ImageSequenceGrabber.this.notifiedForTransparent) {
                    LogUtil.userMessage("Note: Only KMZ files can be saved with background transparency on");
                }
                ImageSequenceGrabber.this.notifiedForTransparent = true;
            }
        });
        capturePanel = GuiUtils.hbox((Component)GuiUtils.top(capturePanel), GuiUtils.top(GuiUtils.inset((Component)GuiUtils.vbox((Component)whatPanel, this.backgroundTransparentBtn), new Insets(0, 10, 0, 0))));
        capturePanel = GuiUtils.inset((Component)GuiUtils.left(capturePanel), 5);
        capturePanel.setBorder(BorderFactory.createTitledBorder("Capture"));
        GuiUtils.setHFill();
        JPanel filePanel = GuiUtils.doLayout(null, new Component[]{GuiUtils.rLabel("Image Quality:"), GuiUtils.left(GuiUtils.hbox((Component)this.hiBtn, (Component)this.medBtn, this.lowBtn)), GuiUtils.filler(), GuiUtils.right(this.alternateDirCbx), this.addAltComp(this.alternateDirFld), this.addAltComp(alternateDirBtn), this.addAltComp(GuiUtils.rLabel("Filename Template:")), this.addAltComp(this.fileTemplateFld), this.addAltComp(this.overwriteCbx)}, 3, GuiUtils.WT_NYN, GuiUtils.WT_N, null, null, new Insets(0, 5, 0, 0));
        filePanel = GuiUtils.inset((Component)filePanel, 5);
        filePanel.setBorder(BorderFactory.createTitledBorder("Image Files"));
        JPanel framesPanel = GuiUtils.vbox((Component)GuiUtils.left(this.frameLbl), GuiUtils.hflow(frameButtons, 4, 0));
        framesPanel = GuiUtils.inset((Component)framesPanel, 5);
        framesPanel.setBorder(BorderFactory.createTitledBorder("Frames"));
        JPanel contents = GuiUtils.vbox(capturePanel, filePanel, framesPanel);
        contents = GuiUtils.inset((Component)contents, 5);
        this.mainDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ImageSequenceGrabber.this.close();
            }
        });
        contents = GuiUtils.topCenter(titlePanel, contents);
        this.imagesChanged();
        this.checkEnabled();
        if (!this.justCaptureAnimation && this.movieFileName == null && this.scriptingNode == null) {
            GuiUtils.packDialog(this.mainDialog, GuiUtils.centerBottom(contents, GuiUtils.wrap(GuiUtils.inset((Component)this.closeButton, 4))));
            this.mainDialog.setVisible(true);
        }
    }

    private boolean getGlobalPaletteValue() {
        IdvObjectStore store = this.idv.getStore();
        return store.get(PREF_USE_GLOBAL_PALETTE, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPreviewImage() {
        if (this.previewPanel == null) {
            return;
        }
        Object object = this.MUTEX;
        synchronized (object) {
            if (this.previewIndex >= this.images.size()) {
                this.previewIndex = this.images.size() - 1;
            }
            if (this.previewIndex < 0) {
                this.previewIndex = 0;
            }
            boolean haveImages = this.images.size() > 0;
            this.prevButton.setEnabled(haveImages);
            this.nextButton.setEnabled(haveImages);
            this.playButton.setEnabled(haveImages);
            this.deleteFrameButton.setEnabled(haveImages);
            if (haveImages) {
                String current = this.images.get(this.previewIndex).getPath();
                if (!Misc.equals(current, this.lastPreview)) {
                    this.previewPanel.loadFile(current);
                    this.lastPreview = current;
                }
                this.previewLbl.setText("  Frame: " + (this.previewIndex + 1) + "/" + this.images.size());
            } else {
                this.previewLbl.setText("   No images   ");
                this.previewPanel.setImage(null);
                this.lastPreview = null;
            }
        }
    }

    private void showPreview() {
        if (this.previewDialog == null) {
            this.previewDialog = new JDialog(this.mainDialog, "Movie Preview", false);
            String imgp = "/auxdata/ui/icons/";
            this.playIcon = GuiUtils.getImageIcon(imgp + "Play16.gif");
            this.stopIcon = GuiUtils.getImageIcon(imgp + "Stop16.gif");
            this.previewRateFld = new JTextField("1", 3);
            ChangeListener rateListener = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    JSlider slide = (JSlider)e.getSource();
                    if (slide.getValueIsAdjusting()) {
                        // empty if block
                    }
                    double value = (double)slide.getValue() / 4.0;
                    ImageSequenceGrabber.this.previewRateFld.setText("" + value);
                }
            };
            JComponent[] comps = GuiUtils.makeSliderPopup(1, 20, 4, rateListener);
            JComponent sliderBtn = comps[0];
            this.playButton = this.makeButton(this.playIcon, CMD_PREVIEW_PLAY, "Play/Stop");
            this.nextButton = this.makeButton(GuiUtils.getImageIcon(imgp + "StepForward16.gif"), CMD_PREVIEW_NEXT, "Go to next frame");
            this.prevButton = this.makeButton(GuiUtils.getImageIcon(imgp + "StepBack16.gif"), CMD_PREVIEW_PREV, "Go to previous frame");
            this.deleteFrameButton = this.makeButton("Delete this frame", CMD_PREVIEW_DELETE);
            List buttonList = Misc.newList(this.prevButton, this.playButton, this.nextButton);
            buttonList.add(GuiUtils.filler(20, 5));
            buttonList.add(new JLabel(" Delay: "));
            buttonList.add(this.previewRateFld);
            buttonList.add(new JLabel("(s)  "));
            buttonList.add(sliderBtn);
            JPanel buttons = GuiUtils.hflow(buttonList);
            buttons = GuiUtils.inset((Component)buttons, 5);
            this.previewLbl = new JLabel("  ");
            this.previewPanel = new ImagePanel();
            this.previewPanel.setPreferredSize(new Dimension(640, 480));
            this.lastPreview = null;
            this.previewIndex = 0;
            this.setPreviewImage();
            this.previewPanel.setBorder(BorderFactory.createEtchedBorder());
            JPanel topComp = GuiUtils.leftRight(buttons, GuiUtils.hbox(this.deleteFrameButton, this.previewLbl));
            JPanel contents = GuiUtils.topCenterBottom(topComp, this.previewPanel, GuiUtils.wrap(this.makeButton("Close", CMD_PREVIEW_CLOSE)));
            GuiUtils.packDialog(this.previewDialog, contents);
        }
        this.previewDialog.setVisible(true);
    }

    private void checkEnabled() {
        this.grabAnimationBtn.setEnabled(!this.capturingAuto);
        this.grabBtn.setEnabled(!this.capturingAuto && !this.capturingAnim);
    }

    private void startCapturingAuto() {
        this.grabAutoBtn.setText("Stop");
        if (this.capturingAuto) {
            return;
        }
        this.capturingAuto = true;
        Misc.run(this);
        this.checkEnabled();
    }

    private void stopCapturingAuto() {
        this.grabAutoBtn.setText("Automatically");
        if (!this.capturingAuto) {
            return;
        }
        this.capturingAuto = false;
        this.checkEnabled();
    }

    private void startAnimationCapture() {
        if (this.capturingAnim || this.getAnimation() == null) {
            return;
        }
        this.grabAnimationBtn.setText("Stop animation");
        this.capturingAnim = true;
        this.checkEnabled();
        Misc.run(new Runnable(){

            @Override
            public void run() {
                Misc.sleep(2000L);
                ImageSequenceGrabber.this.runAnimationCapture(++ImageSequenceGrabber.this.captureTimeStamp);
            }
        });
    }

    private boolean keepRunning(int timestamp) {
        return this.capturingAnim && timestamp == this.captureTimeStamp;
    }

    private void runAnimationCapture(int timestamp) {
        try {
            this.getAnimation().setAnimating(false);
            if (this.animationResetCbx != null && this.animationResetCbx.isSelected()) {
                this.getAnimationWidget().gotoBeginning();
            }
            int sleepTime = this.idv.getStateManager().getProperty("idv.capture.sleep", SLEEP_TIME);
            if (this.scriptingNode != null && XmlUtil.hasAttribute(this.scriptingNode, ATTR_STEPS)) {
                String stepsString = this.imageGenerator.applyMacros(this.scriptingNode, ATTR_STEPS);
                int[] steps = Misc.parseInts(stepsString, ",");
                for (int i = 0; i < steps.length && steps[i] <= this.getAnimation().getNumSteps(); ++i) {
                    this.getAnimation().setCurrent(steps[i]);
                    try {
                        Misc.sleep(sleepTime);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (this.keepRunning(timestamp)) {
                        this.grabImageAndBlock();
                        continue;
                    }
                    break;
                }
            } else if (this.scriptingNode != null && this.viewManager != null && XmlUtil.hasAttribute(this.scriptingNode, ATTR_VIEWPOINTFILE)) {
                String viewpointFile = this.imageGenerator.applyMacros(this.scriptingNode, ATTR_VIEWPOINTFILE);
                List viewpoints = (List)this.idv.decodeObject(IOUtil.readContents(viewpointFile, this.getClass()));
                for (int i = 0; i < viewpoints.size(); ++i) {
                    double[] matrix = (double[])viewpoints.get(i);
                    this.viewManager.setDisplayMatrix(matrix);
                    try {
                        Misc.sleep(sleepTime);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (this.keepRunning(timestamp)) {
                        this.grabImageAndBlock();
                        continue;
                    }
                    break;
                }
            } else {
                int current;
                int start = this.getAnimation().getCurrent();
                do {
                    try {
                        Misc.sleep(sleepTime);
                    }
                    catch (Exception viewpoints) {
                        // empty catch block
                    }
                    if (this.getAnimation() == null || !this.keepRunning(timestamp)) break;
                    this.grabImageAndBlock();
                    if (this.getAnimation() == null) break;
                    this.getAnimationWidget().stepForward();
                } while ((current = this.getAnimation().getCurrent()) > start);
            }
            if (!this.keepRunning(timestamp)) {
                return;
            }
            this.stopAnimationCapture(true);
        }
        catch (Exception exc) {
            LogUtil.logException("Creating movie", exc);
        }
    }

    private void stopAnimationCapture(boolean andWrite) {
        if (this.viewManager != null) {
            this.viewManager.useImages(ImageWrapper.makeFileList(this.images), this.justCaptureAnimation);
            if (this.justCaptureAnimation) {
                return;
            }
        }
        this.capturingAnim = false;
        if (andWrite) {
            this.writeMovie();
        }
        if (this.imageGenerator != null) {
            this.imageGenerator.doneCapturingMovie();
        }
        this.grabAnimationBtn.setText("Time Animation");
        this.checkEnabled();
    }

    private float getImageQuality() {
        float quality = 1.0f;
        if (this.medBtn.isSelected()) {
            quality = 0.6f;
        } else if (this.lowBtn.isSelected()) {
            quality = 0.2f;
        }
        return quality;
    }

    private void previewStopPlaying() {
        this.isPlaying = false;
        this.playButton.setIcon(this.playIcon);
    }

    private void previewStartPlaying() {
        this.isPlaying = true;
        this.playButton.setIcon(this.stopIcon);
        Misc.run(new Runnable(){

            @Override
            public void run() {
                ImageSequenceGrabber.this.previewStartPlaying(++ImageSequenceGrabber.this.timestamp);
            }
        });
    }

    private void previewStartPlaying(int ts) {
        while (this.isPlaying && ts == this.timestamp && this.images.size() > 0) {
            this.previewNext();
            try {
                double sleepTime = 1.0;
                try {
                    sleepTime = new Double(this.previewRateFld.getText().trim());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Misc.sleep((long)(sleepTime * 1000.0));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.previewIndex < this.images.size() - 1) continue;
            this.isPlaying = false;
        }
        if (!this.isPlaying) {
            this.previewStopPlaying();
        }
    }

    private void previewNext() {
        ++this.previewIndex;
        if (this.previewIndex >= this.images.size()) {
            this.previewIndex = 0;
        }
        this.setPreviewImage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent ae) {
        String cmd = ae.getActionCommand();
        if (cmd.equals(GuiUtils.CMD_START)) {
            if (!this.capturingAuto) {
                this.startCapturingAuto();
            } else {
                this.stopCapturingAuto();
            }
        } else if (cmd.equals(CMD_CLEAR)) {
            this.capturingAuto = false;
            this.deleteFiles();
            this.imagesChanged();
            this.checkEnabled();
        } else if (cmd.equals(CMD_PREVIEW_PLAY)) {
            if (this.isPlaying) {
                this.previewStopPlaying();
            } else {
                this.previewStartPlaying();
            }
        } else if (cmd.equals(CMD_PREVIEW_SHOW)) {
            this.showPreview();
        } else if (cmd.equals(CMD_PREVIEW_CLOSE)) {
            if (this.previewDialog != null) {
                this.previewDialog.setVisible(false);
            }
        } else if (cmd.equals(CMD_PREVIEW_NEXT)) {
            this.previewNext();
        } else if (cmd.equals(CMD_PREVIEW_PREV)) {
            --this.previewIndex;
            if (this.previewIndex < 0) {
                this.previewIndex = this.images.size() - 1;
            }
            this.setPreviewImage();
        } else if (cmd.equals(CMD_PREVIEW_DELETE)) {
            if (this.images.size() > 0 && this.previewIndex >= 0 && this.previewIndex < this.images.size()) {
                String filename = this.images.get(this.previewIndex).getPath();
                this.images.remove(this.previewIndex);
                --this.previewIndex;
                this.imagesChanged();
                new File(filename).delete();
            }
        } else if (cmd.equals(CMD_GRAB_ANIMATION)) {
            Object object = this.MUTEX;
            synchronized (object) {
                if (this.capturingAnim) {
                    this.stopAnimationCapture(false);
                } else {
                    this.startAnimationCapture();
                }
            }
        } else if (cmd.equals(CMD_GRAB)) {
            Misc.run(new Runnable(){

                @Override
                public void run() {
                    ImageSequenceGrabber.this.grabImageAndBlock();
                }
            });
        } else if (cmd.equals(GuiUtils.CMD_CLOSE)) {
            this.close();
        } else if (cmd.equals(CMD_PUBLISH)) {
            this.publishMovie();
        } else if (cmd.equals(GuiUtils.CMD_OK)) {
            this.writeMovie();
        }
    }

    private boolean isInteractive() {
        return this.scriptingNode == null;
    }

    private void writeMovie() {
        this.stopCapturingAuto();
        String filename = null;
        if (this.isInteractive() && this.movieFileName == null) {
            JCheckBox writePositionsCbx = new JCheckBox("Save viewpoints", this.writePositions);
            writePositionsCbx.setToolTipText("Also save the viewpoint matrices as an 'xidv' file");
            JCheckBox otherGlobalPaletteBox = new JCheckBox("Use constant color palette for GIF", this.getGlobalPaletteValue());
            otherGlobalPaletteBox.setToolTipText(GLOBAL_PALETTE_TOOLTIP);
            otherGlobalPaletteBox.addActionListener(e -> {
                boolean value = otherGlobalPaletteBox.isSelected();
                IdvObjectStore store = this.idv.getStore();
                store.put(PREF_USE_GLOBAL_PALETTE, value);
                store.save();
            });
            ArrayList<JComponent> accessoryComps = new ArrayList<JComponent>(10);
            accessoryComps.add(GuiUtils.leftRight(GuiUtils.rLabel(" Frames per second: "), this.displayRateFld));
            accessoryComps.add(GuiUtils.leftRight(GuiUtils.rLabel(" End Frame Pause: "), this.endPauseFld));
            accessoryComps.add(writePositionsCbx);
            accessoryComps.add(otherGlobalPaletteBox);
            if (this.publishCbx == null) {
                this.publishCbx = this.idv.getPublishManager().makeSelector();
            }
            if (this.publishCbx != null) {
                accessoryComps.add(this.publishCbx);
            }
            JPanel extra = GuiUtils.topCenter(GuiUtils.vbox(accessoryComps), GuiUtils.filler());
            filename = FileManager.getWriteFile(Misc.newList(FileManager.FILTER_MOV, FileManager.FILTER_AVI, FileManager.FILTER_ANIMATEDGIF, FileManager.FILTER_ZIP, FileManager.FILTER_KMZ, FILTER_ANIS), ".mov", (JComponent)extra);
            this.writePositions = writePositionsCbx.isSelected();
        } else {
            filename = this.movieFileName;
        }
        if (filename != null) {
            this.createMovie(filename);
        }
    }

    private void publishMovie() {
        this.stopCapturingAuto();
        String uid = Misc.getUniqueId();
        String tail = uid + ".mov";
        String file = this.idv.getStore().getTmpFile(tail);
        this.createMovie(file);
        this.idv.getPublishManager().doPublish("Publish Quicktime file", file);
    }

    private void close() {
        ++this.captureTimeStamp;
        this.capturingAuto = false;
        if (this.previewDialog != null) {
            this.previewDialog.dispose();
            this.previewDialog = null;
        }
        this.viewManager.clearImageGrabber(this);
        this.mainDialog.dispose();
        try {
            if (!this.alternateDirCbx.isSelected()) {
                this.deleteFiles();
                new File(this.directory).delete();
            }
        }
        catch (Exception exc) {
            LogUtil.logException("Disposing of tmp directory", exc);
        }
    }

    private void deleteFiles() {
        for (int i = 0; i < this.images.size(); ++i) {
            this.images.get(i).deleteFile();
        }
        this.images = new ArrayList<ImageWrapper>();
        if (this.viewManager != null) {
            this.viewManager.useImages(ImageWrapper.makeFileList(this.images), this.justCaptureAnimation);
        }
    }

    @Override
    public void run() {
        this.capturingAuto = true;
        while (this.capturingAuto) {
            this.grabImageAndBlock();
            if (!this.capturingAuto) {
                return;
            }
            double captureRate = 2.0;
            try {
                captureRate = new Double(this.captureRateFld.getText().trim());
            }
            catch (NumberFormatException nfe) {
                this.stopCapturingAuto();
                LogUtil.userErrorMessage("Bad number format for capture rate: " + this.captureRateFld.getText());
                return;
            }
            Misc.sleep((long)(captureRate * 1000.0));
        }
    }

    protected String getFileSuffix() {
        if (this.justCaptureAnimation) {
            return ".png";
        }
        String defSuffix = ".png";
        if (this.scriptingNode != null && this.movieFileName != null) {
            String suffix = IOUtil.getFileExtension(this.movieFileName);
            if (suffix != null) {
                if (suffix.equalsIgnoreCase(".kmz") || suffix.equalsIgnoreCase(".zip") || suffix.equalsIgnoreCase(".kml")) {
                    defSuffix = ".png";
                } else if (suffix.equalsIgnoreCase(".mov")) {
                    defSuffix = ".jpg";
                } else if (suffix.equalsIgnoreCase(".gif")) {
                    defSuffix = ".png";
                }
            }
            if (!(defSuffix = this.imageGenerator.applyMacros(this.scriptingNode, ATTR_IMAGESUFFIX, defSuffix)).startsWith(".")) {
                defSuffix = "." + defSuffix;
            }
        }
        if (this.backgroundTransparentBtn != null && this.backgroundTransparentBtn.isSelected()) {
            defSuffix = ".png";
        }
        return defSuffix;
    }

    private String getFilePrefix(int cnt) {
        String formatString;
        String filename = "";
        String template = "image_%count%_%time%";
        boolean usingDefault = true;
        if (this.scriptingNode != null) {
            if (!XmlUtil.hasAttribute(this.scriptingNode, ATTR_IMAGEPREFIX)) {
                template = this.imageGenerator.applyMacros(this.scriptingNode, ATTR_IMAGETEMPLATE, template);
            } else {
                template = this.imageGenerator.applyMacros(this.scriptingNode, ATTR_IMAGEPREFIX, "image");
                template = template + "_%count%";
                if (this.imageGenerator.applyMacros(this.scriptingNode, ATTR_APPENDTIME, false)) {
                    template = template + "_%time%";
                    usingDefault = false;
                }
            }
        } else if (this.alternateDirCbx.isSelected() && !(template = this.fileTemplateFld.getText().trim()).equals(dfltTemplate)) {
            dfltTemplate = template;
            this.idv.getStore().put(PROP_IMAGETEMPLATE, (Object)dfltTemplate);
            this.idv.getStore().save();
            usingDefault = false;
        }
        while ((formatString = StringUtil.findFormatString("count", "%", template)) != null) {
            System.err.println(formatString);
            DecimalFormat format = new DecimalFormat(formatString);
            String formattedValue = format.format(cnt);
            String tmp = StringUtil.replace(template, "%count:" + formatString + "%", formattedValue);
            if (tmp.equals(template)) {
                throw new IllegalStateException("Bad formatting:" + tmp);
            }
            template = tmp;
        }
        template = StringUtil.replace(template, "%count%", "" + cnt);
        try {
            Real r = this.getAnimation().getAniValue();
            if (r != null) {
                DateTime dttm = new DateTime(r);
                String timeString = "" + dttm;
                timeString = StringUtil.replace(timeString, ":", "_");
                timeString = StringUtil.replace(timeString, "-", "_");
                timeString = StringUtil.replace(timeString, " ", "_");
                template = StringUtil.replace(template, "%time%", timeString);
                template = UtcDate.applyTimeMacro(template, dttm);
            } else {
                String stub = usingDefault ? "_%time%" : "%time%";
                template = StringUtil.replace(template, stub, "");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        template = StringUtil.replace(template, "/", "_");
        template = StringUtil.replace(template, "\\", "_");
        return template;
    }

    private String getFileDirectory() {
        String filename = "";
        if (this.scriptingNode != null) {
            filename = this.imageGenerator.applyMacros(this.scriptingNode, ATTR_IMAGEDIR, filename);
        } else if (this.alternateDirCbx.isSelected()) {
            filename = this.alternateDirFld.getText().trim();
            if (!Misc.equals(filename, dfltAltDir)) {
                dfltAltDir = filename;
                this.idv.getStore().put(PROP_IMAGEALTDIR, (Object)dfltAltDir);
                this.idv.getStore().save();
            }
            if (filename.length() == 0) {
                filename = this.directory;
                this.alternateDirFld.setText(this.directory);
            }
        }
        if (filename.length() == 0) {
            filename = this.directory;
        }
        IOUtil.makeDir(filename);
        return filename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void grabImageAndBlock() {
        if (this.beepCbx != null && this.beepCbx.isSelected()) {
            Toolkit.getDefaultToolkit().beep();
        }
        try {
            Hashtable imageProperties = new Hashtable();
            Object object = this.MUTEX;
            synchronized (object) {
                String filename;
                String tmp;
                if (this.viewManager == null || this.viewManager.useDisplay()) {
                    // empty if block
                }
                if (!((tmp = (filename = this.getFilePrefix(this.images.size())).toLowerCase()).endsWith(".gif") || tmp.endsWith(".png") || tmp.endsWith(".jpg") || tmp.endsWith(".jpeg"))) {
                    filename = filename + this.getFileSuffix();
                }
                String path = IOUtil.joinDir(this.getFileDirectory(), filename);
                if (this.isInteractive() && !this.overwriteCbx.isSelected() && this.alternateDirCbx.isSelected() && new File(path).exists()) {
                    if (JOptionPane.showConfirmDialog(null, "File:" + path + " exists. Do you want to overwrite?", "File exists", 0) == 1) {
                        this.stopCapturingAuto();
                        this.stopAnimationCapture(false);
                        return;
                    }
                    this.overwriteCbx.setSelected(true);
                }
                DateTime time = null;
                time = this.getAnimation() != null && this.getAnimation().getAniValue() != null ? new DateTime(this.getAnimation().getAniValue()) : null;
                GeoLocationInfo bounds = null;
                if (this.viewManager != null) {
                    bounds = this.viewManager.getVisibleGeoBounds();
                }
                System.err.println("image sequence");
                if (this.alternateComponent != null) {
                    System.err.println("image sequence - alt");
                    GuiUtils.toFront(GuiUtils.getFrame(this.alternateComponent));
                    Misc.sleep(50L);
                    ImageUtils.writeImageToFile(this.alternateComponent, path);
                } else {
                    if (!this.idv.getArgsManager().getIsOffScreen()) {
                        this.viewManager.toFront();
                        Misc.sleep(100L);
                    }
                    if (this.imageGenerator != null) {
                        BufferedImage image;
                        boolean combine = XmlUtil.getAttribute((Node)this.scriptingNode, "combine", false);
                        if (combine) {
                            LinkedList<BufferedImage> images = new LinkedList<BufferedImage>();
                            Iterator<ViewManager> iterator = this.viewManager.getVMManager().getViewManagers().iterator();
                            while (iterator.hasNext()) {
                                ViewManager o;
                                ViewManager vm = o = iterator.next();
                                vm.getAnimation().setAniValue(time);
                                images.add(vm.captureIslImage(this.scriptingNode));
                            }
                            int cols = 2;
                            cols = XmlUtil.getAttribute((Node)this.scriptingNode, "columns", cols);
                            image = (BufferedImage)ImageUtils.gridImages2(images, 0, Color.BLACK, cols);
                        } else {
                            image = this.viewManager.captureIslImage(this.scriptingNode);
                        }
                        Hashtable<String, String> props = new Hashtable<String, String>();
                        props.put("imagepath", path);
                        props.put("imagefile", IOUtil.getFileTail(path));
                        this.imageGenerator.putIndex(props, "imageindex", this.images.size());
                        this.imageGenerator.processImage(image, path, this.scriptingNode, props, this.viewManager, imageProperties);
                        ImageSequenceGrabber.subsetBounds(bounds, imageProperties);
                    } else {
                        LinkedList<Component> components = new LinkedList<Component>();
                        if (this.fullWindowBtn.isSelected()) {
                            components.add(this.viewManager.getDisplayWindow().getComponent());
                        } else if (this.mainDisplayBtn.isSelected()) {
                            components.add(this.viewManager.getMaster().getComponent());
                        } else if (this.fullScreenBtn.isSelected()) {
                            components.add(this.viewManager.getMaster().getComponent());
                        } else if (this.allViewsBtn.isSelected()) {
                            for (Object o : this.viewManager.getDisplayWindow().getViewManagers()) {
                                components.add(((MapViewManager)o).getComponent());
                            }
                        } else {
                            components.add(this.viewManager.getContents());
                        }
                        Image image = this.captureImages(components, ImageUtils.getColumnCountFromComps(components));
                        if (this.allViewsBtn.isSelected()) {
                            this.imageSize = new Dimension(image.getWidth(null), image.getHeight(null));
                        }
                        if (this.backgroundTransparentBtn.isSelected()) {
                            image = ImageUtils.makeColorTransparent(image, this.viewManager.getBackground());
                        }
                        ImageUtils.writeImageToFile(image, path, this.getImageQuality());
                    }
                }
                ImageWrapper imageWrapper = this.viewManager != null ? new ImageWrapper(path, time, bounds, this.viewManager.getDisplayMatrix()) : new ImageWrapper(path, time);
                imageWrapper.setProperties(imageProperties);
                this.images.add(imageWrapper);
                this.imagesChanged();
            }
        }
        catch (Throwable exc) {
            this.stopAnimationCapture(false);
            LogUtil.logException("Error capturing image", exc);
        }
    }

    public Image captureImages(List<? extends Component> components, int cols) throws AWTException {
        LinkedList<Image> images = new LinkedList<Image>();
        for (Component component : components) {
            images.add(this.captureImage(component));
        }
        return ImageUtils.gridImages2(images, 0, Color.GRAY, cols);
    }

    public Image captureImage(Component comp) throws AWTException {
        Point loc;
        Dimension dim;
        if (this.fullScreenBtn.isSelected()) {
            dim = Toolkit.getDefaultToolkit().getScreenSize();
            loc = new Point(0, 0);
        } else {
            dim = comp.getSize();
            loc = comp.getLocationOnScreen();
        }
        GraphicsConfiguration gc = comp.getGraphicsConfiguration();
        Robot robot = new Robot(gc.getDevice());
        if (gc.getBounds().x > 0 || gc.getBounds().y > 0) {
            System.err.println("Offsetting location:" + loc + " by gc bounds: " + gc.getBounds().x + " " + gc.getBounds().y);
            loc.x -= gc.getBounds().x;
            loc.y -= gc.getBounds().y;
            System.err.println("new location:" + loc);
        }
        this.imageSize = new Dimension(dim.width, dim.height);
        return robot.createScreenCapture(new Rectangle(loc.x, loc.y, dim.width, dim.height));
    }

    public static void subsetBounds(GeoLocationInfo bounds, Hashtable returnProps) {
        if (bounds == null) {
            return;
        }
        Double d = (Double)returnProps.get("north");
        if (d != null) {
            bounds.setMaxLat(d);
        }
        if ((d = (Double)returnProps.get("south")) != null) {
            bounds.setMinLat(d);
        }
        if ((d = (Double)returnProps.get("west")) != null) {
            bounds.setMinLon(d);
        }
        if ((d = (Double)returnProps.get("east")) != null) {
            bounds.setMaxLon(d);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void imagesChanged() {
        Object object = this.MUTEX;
        synchronized (object) {
            if (this.images.size() == 0) {
                this.lastPreview = null;
            }
            if (this.images.size() == 0) {
                this.frameLbl.setText("No frames");
            } else if (this.images.size() == 1) {
                this.frameLbl.setText(this.images.size() + " frame");
            } else {
                this.frameLbl.setText(this.images.size() + " frames");
            }
            this.createButton.setEnabled(this.images.size() > 0);
            this.clearButton.setEnabled(this.images.size() > 0);
            this.previewButton.setEnabled(this.images.size() > 0);
            this.setPreviewImage();
        }
    }

    private void createMovie(String movieFile) {
        Dimension size = this.imageSize;
        if (size == null && this.viewManager != null) {
            Component comp = this.viewManager.getMaster().getDisplayComponent();
            size = comp.getSize();
        }
        if (size == null) {
            size = new Dimension(600, 400);
        }
        double displayRate = new Double(this.displayRateFld.getText());
        double endPause = new Double(this.endPauseFld.getText());
        if (this.scriptingNode != null) {
            displayRate = this.imageGenerator.applyMacros(this.scriptingNode, "framerate", displayRate);
            endPause = this.imageGenerator.applyMacros(this.scriptingNode, "endframepause", -1);
        }
        this.createMovie(movieFile, this.images, size, displayRate, this.scriptingNode, endPause);
    }

    private void createPanel(String file, List<ImageWrapper> images, Element scriptingNode) {
        try {
            this.imageGenerator.debug("Making image panel:" + file);
            int width = this.imageGenerator.applyMacros(scriptingNode, "width", 100);
            int columns = this.imageGenerator.applyMacros(scriptingNode, "columns", 1);
            int space = this.imageGenerator.applyMacros(scriptingNode, "space", 0);
            Color background = this.imageGenerator.applyMacros(scriptingNode, "background", (Color)null);
            ArrayList<Image> sizedImages = new ArrayList<Image>();
            for (ImageWrapper imageWrapper : images) {
                String imageFile = imageWrapper.getPath();
                Image image = ImageUtils.readImage(imageFile);
                BufferedImage bufferedImage = ImageUtils.toBufferedImage(image);
                image = this.imageGenerator.resize(bufferedImage, scriptingNode);
                sizedImages.add(image);
            }
            Image image = ImageUtils.gridImages(sizedImages, space, background, columns);
            ImageUtils.writeImageToFile(image, file);
        }
        catch (Exception exc) {
            LogUtil.logException("Writing panel", exc);
        }
    }

    private void createMovie(String commaSeparatedFiles, List<ImageWrapper> images, Dimension size, double displayRate, Element scriptingNode) {
        this.createMovie(commaSeparatedFiles, images, size, displayRate, scriptingNode, -1.0);
    }

    private void createMovie(String commaSeparatedFiles, List<ImageWrapper> images, Dimension size, double displayRate, Element scriptingNode, double endPause) {
        List<String> fileToks = StringUtil.split(commaSeparatedFiles, ",", true, true);
        boolean doingPanel = false;
        if (scriptingNode != null && scriptingNode.getTagName().equals("panel")) {
            doingPanel = true;
        }
        if (this.writePositions && fileToks.size() > 0) {
            try {
                String positionFilename = IOUtil.stripExtension(fileToks.get(0)) + ".xidv";
                ArrayList<double[]> positions = new ArrayList<double[]>();
                for (ImageWrapper imageWrapper : images) {
                    positions.add(imageWrapper.getPosition());
                }
                IOUtil.writeFile(positionFilename, this.idv.encodeObject(positions, true, true));
            }
            catch (IOException ioe) {
                LogUtil.userErrorMessage("Error writing positions:" + ioe);
                return;
            }
        }
        for (int i = 0; i < fileToks.size(); ++i) {
            String movieFile = fileToks.get(i);
            try {
                if (doingPanel) {
                    this.createPanel(movieFile, images, scriptingNode);
                    continue;
                }
                if (!this.isInteractive() && images.size() > 0) {
                    BufferedImage image = ImageUtils.toBufferedImage(ImageUtils.readImage(images.get(0).getPath()));
                    ImageUtils.waitOnImage(image);
                    size = new Dimension(image.getWidth(null), image.getHeight(null));
                }
                if (movieFile.toLowerCase().endsWith(".gif")) {
                    double rate = 1.0 / displayRate;
                    boolean useGCT = this.getGlobalPaletteValue();
                    AnimatedGifEncoder.createGif(movieFile, ImageWrapper.makeFileList(images), 0, (int)(rate * 1000.0), (int)(endPause == -1.0 ? -1.0 : endPause * 1000.0), useGCT);
                } else if (movieFile.toLowerCase().endsWith(".htm") || movieFile.toLowerCase().endsWith(".html")) {
                    this.createAnisHtml(movieFile, images, size, displayRate, scriptingNode);
                } else if (movieFile.toLowerCase().endsWith(".kmz")) {
                    this.createKmz(movieFile, images, scriptingNode);
                } else if (movieFile.toLowerCase().endsWith(".zip")) {
                    this.createZip(movieFile, images, scriptingNode);
                } else if (movieFile.toLowerCase().endsWith(".avi")) {
                    ImageUtils.writeAvi(ImageWrapper.makeFileList(images), displayRate, new File(movieFile));
                } else {
                    SecurityManager backup = System.getSecurityManager();
                    System.setSecurityManager(null);
                    if (size == null) {
                        size = new Dimension(600, 400);
                    }
                    JpegImagesToMovie.createMovie(movieFile, size.width, size.height, (int)displayRate, new Vector<String>(ImageWrapper.makeFileList(images)));
                    System.setSecurityManager(backup);
                }
            }
            catch (NumberFormatException nfe) {
                LogUtil.userErrorMessage("Bad number format");
                return;
            }
            catch (IOException ioe) {
                LogUtil.userErrorMessage("Error writing movie:" + ioe);
                return;
            }
            this.idv.getPublishManager().publishContent(movieFile, this.viewManager, this.publishCbx);
        }
    }

    public void createKmz(String movieFile, List<ImageWrapper> images, Element scriptingNode) {
        try {
            ZipOutputStream zos = null;
            if (movieFile.toLowerCase().endsWith(".kmz")) {
                zos = new ZipOutputStream(new FileOutputStream(movieFile));
            }
            StringBuffer sb = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            sb.append("<kml xmlns=\"http://earth.google.com/kml/2.0\">\n");
            String open = "1";
            String visibility = "1";
            if (scriptingNode != null) {
                visibility = this.imageGenerator.applyMacros(scriptingNode, ATTR_KML_VISIBILITY, visibility);
                open = this.imageGenerator.applyMacros(scriptingNode, ATTR_KML_OPEN, open);
            }
            sb.append("<Folder>\n");
            sb.append("<open>" + open + "</open>\n");
            sb.append(XmlUtil.tag(TAG_VISIBILITY, "", visibility));
            if (scriptingNode != null) {
                String desc;
                String folderName = this.imageGenerator.applyMacros(scriptingNode, ATTR_KML_NAME, (String)null);
                if (folderName != null) {
                    sb.append("<name>" + folderName + "</name>\n");
                }
                if ((desc = this.imageGenerator.applyMacros(scriptingNode, ATTR_KML_DESC, (String)null)) == null && (desc = this.imageGenerator.applyMacros(XmlUtil.getChildText(scriptingNode))) != null) {
                    desc = desc.trim();
                }
                if (desc != null && desc.length() > 0) {
                    sb.append(XmlUtil.tag(TAG_DESCRIPTION, "", desc));
                }
            }
            if (scriptingNode != null) {
                Element kmlElement = XmlUtil.findChild(scriptingNode, "kml");
                if (kmlElement != null) {
                    sb.append(this.imageGenerator.applyMacros(XmlUtil.getChildText(kmlElement)));
                }
                List nodes = XmlUtil.findChildren(scriptingNode, "kmzfile");
                for (int i = 0; i < nodes.size(); ++i) {
                    Element child = (Element)nodes.get(i);
                    String file = XmlUtil.getAttribute(child, ATTR_FILENAME);
                    if (zos == null) continue;
                    zos.putNextEntry(new ZipEntry(IOUtil.getFileTail(file)));
                    Object bytes = IOUtil.readBytes(IOUtil.getInputStream(file));
                    zos.write((byte[])bytes, 0, ((Object)bytes).length);
                }
            }
            TimeZone tz = TimeZone.getTimeZone("GMT");
            boolean didKmlFiles = false;
            for (ImageWrapper imageWrapper : images) {
                byte[] imageBytes;
                String tail;
                List kmlFiles = (List)imageWrapper.getProperty("kmlfiles");
                if (!didKmlFiles && kmlFiles != null) {
                    didKmlFiles = true;
                    for (String kmlFile : kmlFiles) {
                        tail = IOUtil.getFileTail(kmlFile);
                        if (zos == null) continue;
                        zos.putNextEntry(new ZipEntry(tail));
                        imageBytes = IOUtil.readBytes(new FileInputStream(kmlFile));
                        zos.write(imageBytes, 0, imageBytes.length);
                    }
                }
                String extraKml = (String)imageWrapper.getProperty("kml");
                String image = imageWrapper.getPath();
                tail = IOUtil.getFileTail(image);
                if (zos != null) {
                    zos.putNextEntry(new ZipEntry(tail));
                    imageBytes = IOUtil.readBytes(new FileInputStream(image));
                    zos.write(imageBytes, 0, imageBytes.length);
                }
                DateTime dttm = imageWrapper.getDttm();
                GeoLocationInfo bounds = imageWrapper.getBounds();
                if (extraKml != null) {
                    sb.append(extraKml);
                }
                sb.append("<GroundOverlay>\n");
                sb.append("<name>" + (dttm == null ? tail : dttm.toString()) + "</name>\n");
                sb.append(XmlUtil.tag(TAG_VISIBILITY, "", visibility));
                sb.append("<Icon><href>" + tail + "</href></Icon>\n");
                if (bounds != null) {
                    KmlDataSource.createLatLonBox(bounds, sb);
                }
                if (dttm != null) {
                    String when = dttm.formattedString("yyyy-MM-dd", tz) + "T" + dttm.formattedString("HH:mm:ss", tz) + "Z";
                    sb.append("<TimeStamp><when>" + when + "</when></TimeStamp>\n");
                }
                sb.append("</GroundOverlay>\n");
            }
            sb.append("</Folder></kml>\n");
            if (zos != null) {
                zos.putNextEntry(new ZipEntry(IOUtil.stripExtension(IOUtil.getFileTail(movieFile)) + ".kml"));
                byte[] kmlBytes = sb.toString().getBytes();
                zos.write(kmlBytes, 0, kmlBytes.length);
                zos.close();
            } else {
                IOUtil.writeFile(movieFile, sb.toString());
            }
        }
        catch (Exception exc) {
            LogUtil.logException("Saving kmz file", exc);
        }
    }

    public void createZip(String movieFile, List<ImageWrapper> images, Element scriptingNode) {
        try {
            ZipOutputStream zos = null;
            if (movieFile.toLowerCase().endsWith(".zip")) {
                zos = new ZipOutputStream(new FileOutputStream(movieFile));
            }
            StringBuffer sb = new StringBuffer("<entries>\n");
            DateTime time = null;
            time = this.getAnimation() != null && this.getAnimation().getAniValue() != null ? new DateTime(this.getAnimation().getAniValue()) : null;
            String pName = IOUtil.stripExtension(IOUtil.getFileTail(movieFile));
            sb.append("<entry fromdate=\"" + time.toString() + "\" id=\"imageloopParent\" name=\"" + pName + "\"  type=\"media_imageloop\">\n");
            sb.append("</entry>\n");
            int idx = 0;
            for (ImageWrapper imageWrapper : images) {
                zos.putNextEntry(new ZipEntry(IOUtil.getFileTail(imageWrapper.getPath())));
                byte[] imageBytes = IOUtil.readBytes(new FileInputStream(imageWrapper.getPath()));
                zos.write(imageBytes, 0, imageBytes.length);
                String image = imageWrapper.getPath();
                String tail = IOUtil.getFileTail(image);
                DateTime dttm = imageWrapper.getDttm();
                GeoLocationInfo bounds = imageWrapper.getBounds();
                String nameStr = "image_" + idx;
                sb.append("<entry fromdate=\"" + dttm.toString() + "\" file=\"" + tail + "\" name=\"" + nameStr + "\" parent=\"imageloopParent\" type=\"file\">\n");
                sb.append("</entry>\n");
                ++idx;
            }
            sb.append("</entries>\n");
            if (zos != null) {
                zos.putNextEntry(new ZipEntry("entries.xml"));
                byte[] kmlBytes = sb.toString().getBytes();
                zos.write(kmlBytes, 0, kmlBytes.length);
                zos.close();
            } else {
                IOUtil.writeFile(movieFile, sb.toString());
            }
        }
        catch (Exception exc) {
            LogUtil.logException("Saving zip file", exc);
        }
    }

    private void createAnisHtml(String movieFile, List<ImageWrapper> images, Dimension size, double displayRate, Element scriptingNode) {
        try {
            boolean copyFiles = false;
            boolean doFlanis = false;
            String type = "anis";
            String dir = IOUtil.getFileRoot(movieFile);
            String preText = "";
            String postText = "";
            String width = "" + (size != null ? "" + (size.width + 200) : "600");
            String height = "" + (size != null ? "" + (size.height + 200) : "600");
            if (scriptingNode == null) {
                if (preFld == null) {
                    preFld = new JTextArea(5, 20);
                    postFld = new JTextArea(5, 20);
                    copyCbx = new JCheckBox("Copy image files to: " + dir);
                    widthFld = new JTextField("600", 5);
                    heightFld = new JTextField("600", 5);
                    typeCbx = new JCheckBox("FlAniS? (default: AniS)");
                    typeCbx.setToolTipText("Check this box to create HTML to use the Flash animator (FlAniS); otherwise, the java applet animator (AniS) will be used.");
                }
                widthFld.setText(width);
                heightFld.setText(height);
                copyCbx.setText("Copy image files to: " + dir);
                GuiUtils.tmpInsets = new Insets(5, 5, 5, 5);
                JPanel contents = GuiUtils.doLayout(new Component[]{GuiUtils.rLabel("Dimension:"), GuiUtils.left(GuiUtils.hbox((Component)widthFld, (Component)new JLabel(" X "), heightFld)), GuiUtils.top(GuiUtils.rLabel("Top HTML:")), GuiUtils.makeScrollPane(preFld, 200, 100), GuiUtils.top(GuiUtils.rLabel("Bottom HTML:")), GuiUtils.makeScrollPane(postFld, 200, 100), GuiUtils.rLabel(""), typeCbx, GuiUtils.rLabel(""), copyCbx}, 2, GuiUtils.WT_NY, GuiUtils.WT_N);
                if (!GuiUtils.showOkCancelDialog(null, "ANIS Applet Information", contents, null)) {
                    return;
                }
                copyFiles = copyCbx.isSelected();
                doFlanis = typeCbx.isSelected();
                preText = preFld.getText();
                postText = postFld.getText();
                width = widthFld.getText().trim();
                height = heightFld.getText().trim();
            } else {
                width = XmlUtil.getAttribute((Node)scriptingNode, ATTR_ANIS_WIDTH, width);
                height = XmlUtil.getAttribute((Node)scriptingNode, ATTR_ANIS_HEIGHT, height);
                preText = XmlUtil.getAttribute((Node)scriptingNode, ATTR_ANIS_PREHTML, preText);
                postText = XmlUtil.getAttribute((Node)scriptingNode, ATTR_ANIS_POSTHTML, postText);
                doFlanis = !(type = XmlUtil.getAttribute((Node)scriptingNode, ATTR_ANIS_TYPE, type)).toLowerCase().equals("anis");
            }
            StringBuffer sb = new StringBuffer();
            String files = "";
            for (int i = 0; i < images.size(); ++i) {
                ImageWrapper imageWrapper = images.get(i);
                String file = imageWrapper.getPath();
                if (copyFiles) {
                    IOUtil.copyFile(new File(file), new File(dir));
                }
                if (i > 0) {
                    files = files + ",";
                }
                files = files + IOUtil.getFileTail(file);
            }
            sb.append(preText);
            sb.append("\n");
            if (doFlanis) {
                sb.append("<OBJECT type=\"application/x-shockwave-flash\" data=\"./flanis.swf\" width=\"" + width + "\" height=\"" + height + "\" id=\"FlAniS\"> \n");
                sb.append("<PARAM NAME=\"movie\" VALUE=\"./flanis.swf\"> \n");
                sb.append("<PARAM NAME=\"quality\" VALUE=\"high\"> \n");
                sb.append("<PARAM NAME=\"menu\" value=\"false\"> \n");
                sb.append("<PARAM NAME=\"FlashVars\" value=\"controls=startstop,step,speed,toggle,zoom&filenames=" + files + "\"> \n");
                sb.append("</OBJECT>\n");
            } else {
                sb.append("<APPLET code=\"AniS.class\" width=" + width + " height=" + height + ">\n");
                sb.append("<PARAM name=\"controls\" value=\"startstop,step, speed, toggle, zoom\">\n");
                sb.append("<PARAM name=\"filenames\" value=\"" + files + "\">\n");
                sb.append("</APPLET>\n");
            }
            sb.append("\n");
            sb.append(postText);
            IOUtil.writeFile(new File(movieFile), sb.toString());
        }
        catch (Exception exc) {
            LogUtil.logException("Saving html file", exc);
        }
    }

    public static void main(String[] args) {
        AnimatedGifEncoder e = new AnimatedGifEncoder();
        e.start("test.gif");
        for (int i = 0; i < args.length; ++i) {
            ImagePlus image = new ImagePlus(args[i]);
            e.addFrame(image);
        }
        e.finish();
    }
}

