/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.ui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TimeZone;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;
import org.python.core.PyObject;
import org.python.util.PythonInterpreter;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataSelection;
import ucar.unidata.data.DataSource;
import ucar.unidata.data.GeoLocationInfo;
import ucar.unidata.data.grid.GridDataSource;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionRect;
import ucar.unidata.idv.ControlDescriptor;
import ucar.unidata.idv.CrossSectionViewManager;
import ucar.unidata.idv.DisplayControl;
import ucar.unidata.idv.IdvManager;
import ucar.unidata.idv.IntegratedDataViewer;
import ucar.unidata.idv.MapViewManager;
import ucar.unidata.idv.VectorGraphicsRenderer;
import ucar.unidata.idv.ViewDescriptor;
import ucar.unidata.idv.ViewManager;
import ucar.unidata.idv.control.DisplayControlImpl;
import ucar.unidata.idv.ui.IdvUIManager;
import ucar.unidata.idv.ui.IdvWindow;
import ucar.unidata.idv.ui.ImageSequenceGrabber;
import ucar.unidata.idv.ui.ImageWrapper;
import ucar.unidata.ui.ImageUtils;
import ucar.unidata.ui.colortable.ColorTableCanvas;
import ucar.unidata.util.CacheManager;
import ucar.unidata.util.ColorTable;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.PatternFileFilter;
import ucar.unidata.util.Range;
import ucar.unidata.util.StringUtil;
import ucar.unidata.util.Trace;
import ucar.unidata.view.geoloc.NavigatedDisplay;
import ucar.unidata.view.geoloc.ViewpointInfo;
import ucar.unidata.xml.XmlUtil;
import ucar.visad.GeoUtils;
import ucar.visad.ProjectionCoordinateSystem;
import ucar.visad.UtcDate;
import ucar.visad.Util;
import ucar.visad.display.Animation;
import ucar.visad.display.AnimationWidget;
import visad.CommonUnit;
import visad.DateTime;
import visad.MouseBehavior;
import visad.Real;
import visad.RealType;
import visad.Unit;
import visad.data.DataCacheManager;
import visad.georef.EarthLocation;
import visad.georef.EarthLocationTuple;
import visad.georef.LatLonPoint;
import visad.georef.MapProjection;
import visad.util.BaseRGBMap;
import visad.util.ColorPreview;

public class ImageGenerator
extends IdvManager {
    public static final String VALUE_TOP = "top";
    public static final String VALUE_BOTTOM = "bottom";
    public static final String VALUE_RIGHT = "right";
    public static final String VALUE_LEFT = "left";
    public static final String VALUE_ALL = "all";
    public static final String VALUE_NONE = "none";
    public static final String VALUE_FIRST = "first";
    public static final String VALUE_LAST = "last";
    public static final String PROP_LOOPINDEX = "loopindex";
    public static final String PROP_LOOPINDEX_PAD2 = "loopindex_pad2";
    public static final String PROP_LOOPINDEX_PAD3 = "loopindex_pad3";
    public static final String PROP_LOOPINDEX_PAD4 = "loopindex_pad4";
    public static final String PROP_VIEWINDEX = "viewindex";
    public static final String PROP_VIEWNAME = "viewname";
    public static final String PROP_IMAGEINDEX = "imageindex";
    public static final String PROP_IMAGEFILE = "imagefile";
    public static final String PROP_IMAGEPATH = "imagepath";
    public static final String PROP_FILE = "file";
    public static final String PROP_FILENOSUFFIX = "filenosuffix";
    public static final String PROP_FILETAIL = "filetail";
    public static final String PROP_FILETAILNOSUFFIX = "filetailnosuffix";
    public static final String PROP_FILEPREFIX = "fileprefix";
    public static final String PROP_CONTENTS = "contents";
    public static final String PROP_ANIMATIONTIME = "animationtime";
    public static final String PROP_OFFSCREEN = "offscreen";
    private static final String[] DATE_PROPS = new String[]{"G", "yy", "yyyy", "MM", "M", "MMM", "MMMMM", "HH", "H", "k", "kk", "D", "d", "dd", "K", "KK", "a", "mm", "ss", "s", "S", "EEE", "Z"};
    private static List DATE_FORMATS;
    public static final String TAG_FILESET = "fileset";
    public static final String TAG_VIEW = "view";
    public static final String TAG_TEMPLATE = "template";
    public static final String TAG_APPEND = "append";
    public static final String TAG_SETFILES = "setfiles";
    public static final String TAG_ISL = "isl";
    public static final String TAG_VIEWPOINT = "viewpoint";
    public static final String TAG_PROPERTY = "property";
    public static final String TAG_IMPORT = "import";
    public static final String TAG_IMAGE = "image";
    public static final String TAG_GROUP = "group";
    public static final String TAG_PAUSE = "pause";
    public static final String TAG_MOVIE = "movie";
    public static final String TAG_BUNDLE = "bundle";
    public static final String TAG_ELSE = "else";
    public static final String TAG_THEN = "then";
    public static final String TAG_COLORBAR = "colorbar";
    public static final String TAG_CLIP = "clip";
    public static final String TAG_PUBLISH = "publish";
    public static final String TAG_DISPLAY = "display";
    public static final String TAG_DATASOURCE = "datasource";
    public static final String TAG_MATTE = "matte";
    public static final String TAG_SHOW = "show";
    public static final String TAG_DISPLAYLIST = "displaylist";
    public static final String TAG_OUTPUT = "output";
    public static final String TAG_OVERLAY = "overlay";
    public static final String TAG_KML = "kml";
    public static final String TAG_KML_COLORBAR = "kmlcolorbar";
    public static final String TAG_KMZFILE = "kmzfile";
    public static final String TAG_SPLIT = "split";
    public static final String TAG_RESIZE = "resize";
    public static final String TAG_THUMBNAIL = "thumbnail";
    public static final String TAG_TRANSPARENT = "transparent";
    public static final String TAG_PROJECTION = "projection";
    public static final String TAG_BGTRANSPARENT = "backgroundtransparent";
    public static final String ATTR_INDEX = "index";
    public static final String ATTR_STRIDE = "stride";
    public static final String ATTR_STRIDEX = "stridex";
    public static final String ATTR_STRIDEY = "stridey";
    public static final String ATTR_STRIDEZ = "stridez";
    public static final String ATTR_BBOX = "bbox";
    public static final String ATTR_DRIVERTIME_START = "timedriverstart";
    public static final String ATTR_DRIVERTIME_END = "timedriverend";
    public static final String ATTR_LEVEL_FROM = "levelfrom";
    public static final String ATTR_LEVEL_TO = "levelto";
    public static final String ATTR_AZIMUTH = "azimuth";
    public static final String ATTR_TILT = "tilt";
    public static final String ATTR_ASPECTX = "aspectx";
    public static final String ATTR_ASPECTY = "aspecty";
    public static final String ATTR_ASPECTZ = "aspectz";
    public static final String ATTR_ROTX = "rotx";
    public static final String ATTR_ROTY = "roty";
    public static final String ATTR_ROTZ = "rotz";
    public static final String ATTR_SCALE = "scale";
    public static final String ATTR_TRANSX = "transx";
    public static final String ATTR_TRANSY = "transy";
    public static final String ATTR_TRANSZ = "transz";
    public static final String ATTR_SUFFIX = "suffix";
    public static final String ATTR_SHOWUNIT = "showunit";
    public static final String ATTR_TRANSPARENCY = "transparency";
    public static final String ATTR_TOP = "top";
    public static final String ATTR_SPACE_LEFT = "space_left";
    public static final String ATTR_SPACE_RIGHT = "space_right";
    public static final String ATTR_SPACE_TOP = "space_top";
    public static final String ATTR_SPACE_BOTTOM = "space_bottom";
    public static final String TAG_WRITE = "write";
    public static final String ATTR_ANCHOR = "anchor";
    public static final String ATTR_FROM = "from";
    public static final String ATTR_TO = "to";
    public static final String ATTR_GLOBAL = "global";
    public static final String ATTR_ONERROR = "onerror";
    public static final String ATTR_SORT = "sort";
    public static final String ATTR_SORTDIR = "sortdir";
    public static final String VALUE_TIME = "time";
    public static final String VALUE_ASCENDING = "ascending";
    public static final String VALUE_DESCENDING = "descending";
    public static final String ATTR_FIRST = "first";
    public static final String ATTR_LAST = "last";
    public static final String ATTR_USEPROJECTION = "useprojection";
    public static final String ATTR_EXPR = "expr";
    public static final String ATTR_COPY = "copy";
    public static final String ATTR_COUNT = "count";
    public static final String ATTR_COLUMNS = "columns";
    public static final String ATTR_DATASOURCE = "datasource";
    public static final String ATTR_DESTINATION = "destination";
    public static final String ATTR_SERVER = "server";
    public static final String ATTR_PASSWORD = "password";
    public static final String ATTR_USER = "user";
    public static final String ATTR_ROWS = "rows";
    public static final String ATTR_CLASS = "class";
    public static final String ATTR_ANGLE = "angle";
    public static final String ATTR_WHERE = "where";
    public static final String ATTR_BACKGROUND = "background";
    public static final String ATTR_BUNDLE = "bundle";
    public static final String ATTR_SHOWLINES = "showlines";
    public static final String ATTR_LINECOLOR = "linecolor";
    public static final String ATTR_COLOR = "color";
    public static final String ATTR_COMMAND = "command";
    public static final String ATTR_FONTFACE = "fontface";
    public static final String ATTR_FORMAT = "format";
    public static final String TAG_LATLONLABELS = "latlonlabels";
    public static final String ATTR_LAT_VALUES = "latvalues";
    public static final String ATTR_LAT_LABELS = "latlabels";
    public static final String ATTR_LON_VALUES = "lonvalues";
    public static final String ATTR_LON_LABELS = "lonlabels";
    public static final String ATTR_DRAWLONLINES = "drawlonlines";
    public static final String ATTR_DRAWLATLINES = "drawlatlines";
    public static final String ATTR_DASHES = "dashes";
    public static final String ATTR_LINEWIDTH = "linewidth";
    public static final String ATTR_LINEOFFSET_RIGHT = "lineoffsetright";
    public static final String ATTR_LINEOFFSET_LEFT = "lineoffsetleft";
    public static final String ATTR_LINEOFFSET_TOP = "lineoffsettop";
    public static final String ATTR_LINEOFFSET_BOTTOM = "lineoffsetbottom";
    public static final String ATTR_LABELBACKGROUND = "labelbackground";
    public static final String ATTR_SHOWTOP = "showtop";
    public static final String ATTR_SHOWBOTTOM = "showbottom";
    public static final String ATTR_SHOWLEFT = "showleft";
    public static final String ATTR_SHOWRIGHT = "showright";
    public static final String ATTR_FONTSIZE = "fontsize";
    public static final String ATTR_FRAMERATE = "framerate";
    public static final String ATTR_ENDFRAMEPAUSE = "endframepause";
    public static final String ATTR_CAPTION = "caption";
    public static final String ATTR_DEBUG = "debug";
    public static final String ATTR_DEFAULT = "default";
    public static final String ATTR_DISPLAY = "display";
    public static final String ATTR_OFFSCREEN = "offscreen";
    public static final String ATTR_TIMES = "times";
    public static final String ATTR_ENSEMBLES = "ensembles";
    public static final String ATTR_DIR = "dir";
    public static final String ATTR_PATTERN = "pattern";
    public static final String ATTR_WAIT = "wait";
    public static final String ATTR_PROPERTY = "property";
    public static final String ATTR_QUALITY = "quality";
    public static final String ATTR_LOOP = "loop";
    public static final String ATTR_ENTRY = "entry";
    public static final String ATTR_ID = "id";
    public static final String ATTR_IMAGE = "image";
    public static final String ATTR_INTERVAL = "interval";
    public static final String ATTR_LEFT = "left";
    public static final String ATTR_MESSAGE = "message";
    public static final String ATTR_MATTEBG = "mattebg";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_RIGHT = "right";
    public static final String ATTR_TICKMARKS = "tickmarks";
    public static final String ATTR_SPACE = "space";
    public static final String ATTR_HSPACE = "hspace";
    public static final String ATTR_VSPACE = "vspace";
    public static final String ATTR_BOTTOM = "bottom";
    public static final String ATTR_VALIGN = "valign";
    public static final String ATTR_TEXT = "text";
    public static final String ATTR_TEMPLATE = "template";
    public static final String ATTR_TYPE = "type";
    public static final String ATTR_EVERY = "every";
    public static final String ATTR_VALUE = "value";
    public static final String ATTR_VALUES = "values";
    public static final String ATTR_ORIENTATION = "orientation";
    public static final String ATTR_PARAM = "param";
    public static final String ATTR_PLACE = "place";
    public static final String ATTR_VIEW = "view";
    public static final String ATTR_VIEWDIR = "viewdir";
    public static final String ATTR_URL = "url";
    public static final String ATTR_FILE = "file";
    public static final String ATTR_FROMFILE = "fromfile";
    public static final String ATTR_NORTH = "north";
    public static final String ATTR_SOUTH = "south";
    public static final String ATTR_EAST = "east";
    public static final String ATTR_WEST = "west";
    public static final String ATTR_WIDTH = "width";
    public static final String ATTR_HEIGHT = "height";
    public static final String ATTR_SLEEP = "sleep";
    public static final String ATTR_SECONDS = "seconds";
    public static final String ATTR_MINUTES = "minutes";
    public static final String ATTR_HOURS = "hours";
    public static final String ATTR_CLEAR = "clear";
    public static final String ATTR_WINDOW = "window";
    public static final String ATTR_CODE = "code";
    public static final String ATTR_LAT = "lat";
    public static final String ATTR_LON = "lon";
    public static final String ATTR_WHAT = "what";
    public static final String ATTR_COMBINE = "combine";
    public static final String ATTR_ANIMATION_INDEX = "animation_index";
    private static final String ATTR_SUFFIXFREQUENCY = "suffixfrequency";
    private boolean debug = false;
    private List propertiesStack = new ArrayList();
    private Hashtable idToDataSource = new Hashtable();
    private List<String> results = new ArrayList<String>();
    private boolean interactive;
    private String error = null;
    private PythonInterpreter interpreter;
    private List outputStack = new ArrayList();
    private int currentLoopIndex = 0;
    private Hashtable procs;
    private Hashtable methods = new Hashtable();
    private Element currentNode;
    private Image lastImage;
    private Hashtable objectMap;
    private static String[] alphabet;
    private static String[] roman;

    public ImageGenerator(IntegratedDataViewer idv) {
        super(idv);
    }

    public ImageGenerator(IntegratedDataViewer idv, List scriptFiles) {
        super(idv);
        this.processScriptFiles(scriptFiles);
    }

    public void processScriptFiles(List scriptFiles) {
        for (int fileIdx = 0; fileIdx < scriptFiles.size(); ++fileIdx) {
            String filename = (String)scriptFiles.get(fileIdx);
            if (this.processScriptFile(filename)) continue;
            return;
        }
    }

    public boolean processScriptFile(String islFile) {
        return this.processScriptFile(islFile, new Hashtable());
    }

    public boolean processScriptFile(String islFile, Hashtable properties) {
        return this.processScriptFile(islFile, properties, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean processScriptFile(String islFile, Hashtable properties, boolean interactive) {
        this.procs = new Hashtable();
        this.idToDataSource = new Hashtable();
        this.propertiesStack = new ArrayList();
        this.interactive = interactive;
        this.pushProperties();
        this.results = new ArrayList<String>();
        this.error = null;
        if (islFile.endsWith(".jy") || islFile.endsWith(".py")) {
            try {
                String islPath = IOUtil.getFileRoot(islFile);
                this.putProperty("islpath", islPath);
                String jythonCode = IOUtil.readContents(islFile);
                PythonInterpreter interp = this.getInterpreter();
                if (this.getIdv().getJythonManager().getInError()) {
                    return false;
                }
                interp.exec(jythonCode);
                this.popProperties();
                return true;
            }
            catch (Exception exc) {
                exc.printStackTrace();
                return this.error("Error running jython script:" + islFile + "\n" + exc);
            }
        }
        Element root = null;
        try {
            InputStream is = null;
            try {
                if (islFile.startsWith("xml:")) {
                    String xml = islFile.substring(4);
                    is = new ByteArrayInputStream(xml.getBytes());
                    islFile = "Inline isl";
                } else if (islFile.startsWith("b64:")) {
                    is = new ByteArrayInputStream(XmlUtil.decodeBase64(islFile.substring(4)));
                    islFile = "Inline base 64 encoded isl";
                } else {
                    is = IOUtil.getInputStream(islFile, this.getClass());
                }
            }
            catch (FileNotFoundException xml) {
            }
            catch (IOException xml) {
                // empty catch block
            }
            if (is == null) {
                return this.error("Given script file does not exist or could not be read: " + islFile);
            }
            root = XmlUtil.getRoot(is);
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return this.error("Could not load script file:" + islFile + "\n" + exc);
        }
        if (root == null) {
            return this.error("Could not load script file:" + islFile);
        }
        try {
            String islPath = IOUtil.getFileRoot(islFile);
            this.putProperty("islpath", islPath);
            this.objectMap = properties;
            this.processNode(root);
            this.popProperties();
        }
        catch (InvocationTargetException ite) {
            Throwable inner = ite.getTargetException();
            while (inner instanceof InvocationTargetException) {
                inner = ((InvocationTargetException)inner).getTargetException();
            }
            boolean bl = this.handleError(inner);
            return bl;
        }
        catch (Throwable exc) {
            boolean bl = this.handleError(exc);
            return bl;
        }
        finally {
            this.objectMap = null;
        }
        return true;
    }

    public List<String> getResults() {
        return this.results;
    }

    public String getError() {
        return this.error;
    }

    private boolean handleError(Throwable exc) {
        if (!(exc instanceof IllegalStateException) && !(exc instanceof IllegalArgumentException)) {
            exc.printStackTrace();
        } else {
            exc.printStackTrace();
        }
        if (this.interactive) {
            return this.error("An error occurred:" + exc);
        }
        return this.error(exc.getMessage());
    }

    private Throwable getInnerException(InvocationTargetException ite) {
        Throwable inner = ite.getTargetException();
        while (inner instanceof InvocationTargetException) {
            inner = ((InvocationTargetException)inner).getTargetException();
        }
        return inner;
    }

    private boolean processNode(Element node) throws Throwable {
        String tagName = node.getTagName();
        String methodName = "processTag" + tagName.substring(0, 1).toUpperCase() + tagName.substring(1).toLowerCase();
        Element procNode = (Element)this.procs.get(tagName);
        if (procNode != null) {
            return this.processTagCall(node, procNode);
        }
        Object tmp = this.methods.get(methodName);
        if (tmp == null) {
            try {
                tmp = this.getClass().getDeclaredMethod(methodName, Element.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (tmp == null) {
                tmp = "no method";
            }
            this.methods.put(methodName, tmp);
        }
        if (tmp instanceof Method) {
            try {
                this.currentNode = node;
                Object result = ((Method)tmp).invoke((Object)this, node);
                if (result.equals(Boolean.TRUE)) {
                    return true;
                }
            }
            catch (InvocationTargetException ite) {
                Throwable inner = this.getInnerException(ite);
                if (inner instanceof BadIslException) {
                    return this.error("Error handling ISL node:" + XmlUtil.toStringNoChildren(this.currentNode) + "\t" + inner.toString());
                }
                throw inner;
            }
            return false;
        }
        return this.error("Unknown tag:" + tagName);
    }

    protected boolean processTagFor(Element node) throws Throwable {
        this.pushProperties();
        int start = XmlUtil.getAttribute((Node)node, "start", 0);
        int end = XmlUtil.getAttribute((Node)node, "end", 0);
        int inc = XmlUtil.getAttribute((Node)node, "increment", 1);
        for (int i = start; i < end; i += inc) {
            this.putProperty(ATTR_INDEX, "" + i);
            try {
                if (this.processChildren(node)) continue;
                return false;
            }
            catch (MyBreakException be) {
                break;
            }
            catch (MyContinueException myContinueException) {
                // empty catch block
            }
        }
        this.popProperties();
        return true;
    }

    private boolean processChildren(Element node) throws Throwable {
        NodeList elements = XmlUtil.getElements(node);
        for (int childIdx = 0; childIdx < elements.getLength(); ++childIdx) {
            Element child = (Element)elements.item(childIdx);
            try {
                if (this.processNode(child)) continue;
                return false;
            }
            catch (Throwable thr) {
                String onerror = this.applyMacros(node, ATTR_ONERROR, (String)null);
                if (onerror == null) {
                    throw thr;
                }
                if (onerror.equals("ignore")) continue;
                System.err.println("Error occured");
                thr.printStackTrace();
            }
        }
        return true;
    }

    protected boolean processTagFtp(Element node) throws Throwable {
        String file = this.applyMacros(node, "file");
        String server = this.applyMacros(node, ATTR_SERVER);
        String destination = this.applyMacros(node, ATTR_DESTINATION);
        String user = this.applyMacros(node, ATTR_USER, "anonymous");
        String password = this.applyMacros(node, ATTR_PASSWORD, "idvuser@unidata.ucar.edu");
        byte[] bytes = IOUtil.readBytes(IOUtil.getInputStream(file));
        ImageGenerator.ftpPut(server, user, password, destination, bytes);
        return true;
    }

    protected boolean processTagExport(Element node) throws Throwable {
        String what = this.applyMacros(node, ATTR_WHAT, (String)null);
        String filename = this.applyMacros(node, "file", (String)null);
        if (what != null && what.equals("zidv") && filename != null) {
            this.getIdv().getIdvUIManager();
            IdvUIManager.waitUntilDisplaysAreDone(this.getIdv().getIdvUIManager(), 0L);
            this.getIdv().getPersistenceManager().doSaveAs(filename);
            return true;
        }
        DisplayControlImpl display = this.findDisplayControl(node);
        String displayId = XmlUtil.getAttribute((Node)node, "display", (String)null);
        if (display == null && displayId == null) {
            List controls = this.getIdv().getDisplayControls();
            for (int i = 0; i < controls.size(); ++i) {
                DisplayControlImpl tmpDisplay = (DisplayControlImpl)controls.get(i);
                if (!tmpDisplay.canExportData()) continue;
                display = tmpDisplay;
                break;
            }
        }
        if (display == null) {
            throw new IllegalArgumentException(displayId == null ? "Could not find display: No display attribute provided" : "Could not find display with id:" + displayId);
        }
        display.doExport(what, filename);
        return true;
    }

    protected boolean processTagSave(Element node) throws Throwable {
        String result;
        String filename = this.applyMacros(node, "file", "idv.xidv");
        this.getIdv().getPersistenceManager().doSaveAs(filename);
        if (XmlUtil.getAttribute((Node)node, TAG_PUBLISH, false) && (result = this.getIdv().getPublishManager().publishFile(filename)) != null) {
            this.results.add(result);
        }
        return true;
    }

    protected boolean processTagPublish(Element node) throws Throwable {
        String filename = this.applyMacros(node, "file", "idv.xidv");
        String result = this.getIdv().getPublishManager().publishFile(filename);
        if (result != null) {
            this.results.add(result);
        }
        return true;
    }

    protected boolean processTagTrace(Element node) throws Throwable {
        String pattern = this.applyMacros(node, ATTR_PATTERN);
        this.debug("turning trace on for:" + pattern);
        Trace.startTrace();
        Trace.clearOnly();
        Trace.addOnly(pattern);
        return true;
    }

    protected boolean processTagRemovedisplays(Element node) throws Throwable {
        if (XmlUtil.hasAttribute(node, "display")) {
            this.debug("Removing display");
            DisplayControlImpl display = this.findDisplayControl(node);
            if (display == null) {
                return this.error("Could not find display:" + XmlUtil.toString(node));
            }
            display.doRemove();
            return true;
        }
        this.debug("Removing all displays");
        this.getIdv().removeAllDisplays(true);
        return true;
    }

    protected boolean processTagPrintcache(Element node) throws Throwable {
        DataCacheManager.getCacheManager().printStats();
        return true;
    }

    protected boolean processTagRemoveall(Element node) throws Throwable {
        this.debug("Removing all displays and data");
        this.getIdv().removeAllDisplays(false);
        this.getIdv().removeAllDataSources();
        this.idToDataSource = new Hashtable();
        return true;
    }

    protected boolean processTagSetfiles(Element node) throws Throwable {
        DataSource dataSource = this.findDataSource(node);
        if (dataSource == null) {
            return this.error("Could not find data source");
        }
        ArrayList<String> files = new ArrayList<String>();
        if (XmlUtil.hasAttribute(node, "file")) {
            files.add(this.applyMacros(node, "file"));
        } else {
            List filesetFiles = this.findFiles(node);
            if (filesetFiles != null) {
                files.addAll(filesetFiles);
            }
        }
        if (files.size() == 0) {
            return this.error("Could not find files");
        }
        dataSource.setNewFiles(files);
        return true;
    }

    protected boolean processTagExists(Element node) throws Throwable {
        List files = this.findFiles(node);
        boolean exists = files != null && files.size() > 0;
        this.putProperty(this.applyMacros(node, "property"), exists ? "1" : "0");
        return true;
    }

    protected boolean processTagBeep(Element node) throws Throwable {
        Toolkit.getDefaultToolkit().beep();
        return true;
    }

    protected boolean processTagAsk(Element node) throws Throwable {
        boolean result;
        String property = this.applyMacros(node, "property");
        if (this.getIdv().getArgsManager().getIsOffScreen()) {
            if (!XmlUtil.hasAttribute(node, ATTR_DEFAULT)) {
                throw new IllegalStateException("Running in offscreen mode and the 'ask' node does not have a 'default' attribute");
            }
            result = this.applyMacros(node, ATTR_DEFAULT, true);
        } else {
            result = GuiUtils.showYesNoDialog(null, this.applyMacros(node, ATTR_MESSAGE), "");
        }
        this.putProperty(property, result ? "1" : "0");
        return true;
    }

    protected boolean processTagEcho(Element node) throws Throwable {
        String message = this.applyMacros(node, ATTR_MESSAGE, (String)null);
        if (message == null) {
            message = this.applyMacros(XmlUtil.getChildText(node));
        }
        System.out.println(message);
        return true;
    }

    protected boolean processTagAsktocontinue(Element node) throws Throwable {
        String message = this.applyMacros(node, ATTR_MESSAGE, (String)null);
        if (message == null) {
            message = this.applyMacros(XmlUtil.getChildText(node));
        }
        return GuiUtils.askOkCancel("ISL", message);
    }

    protected boolean processTagGc(Element node) throws Throwable {
        Runtime.getRuntime().gc();
        return true;
    }

    protected boolean processTagBreak(Element node) throws Throwable {
        throw new MyBreakException();
    }

    protected boolean processTagContinue(Element node) throws Throwable {
        throw new MyContinueException();
    }

    protected boolean processTagReturn(Element node) throws Throwable {
        throw new MyReturnException();
    }

    protected boolean processTagProcedure(Element node) throws Throwable {
        this.procs.put(this.applyMacros(node, ATTR_NAME), node);
        return true;
    }

    protected boolean processTagMkdir(Element node) throws Throwable {
        IOUtil.makeDir(this.applyMacros(node, "file"));
        return true;
    }

    protected boolean processTagStop(Element node) throws Throwable {
        return false;
    }

    protected String[] getPropertyValue(Element node) throws Throwable {
        String name = this.applyMacros(node, ATTR_NAME);
        String value = null;
        if (XmlUtil.hasAttribute(node, ATTR_VALUE)) {
            value = this.applyMacros(node, ATTR_VALUE);
        } else if (XmlUtil.hasAttribute(node, ATTR_FROMFILE)) {
            String filename = this.applyMacros(node, ATTR_FROMFILE);
            value = this.applyMacros(IOUtil.readContents(filename));
        } else {
            value = XmlUtil.getChildText(node);
            if (value == null || value.trim().length() == 0) {
                throw new IllegalArgumentException("No value in property tag: " + XmlUtil.toString(node));
            }
            value = this.applyMacros(value);
        }
        return new String[]{name, value};
    }

    protected boolean processTagIdvproperty(Element node) throws Throwable {
        String[] tuple = this.getPropertyValue(node);
        this.debug("setting idv property: " + tuple[0] + " =" + tuple[1]);
        this.getIdv().getStateManager().putProperty(this.applyMacros(tuple[0]), this.applyMacros(tuple[1]));
        return true;
    }

    protected boolean processTagProperty(Element node) throws Throwable {
        String[] tuple = this.getPropertyValue(node);
        this.putProperty(this.applyMacros(tuple[0]), tuple[1], this.applyMacros(node, ATTR_GLOBAL, false));
        return true;
    }

    protected boolean processTagMove(Element node) throws Throwable {
        List files = this.findFiles(node);
        if (files != null) {
            File dir = new File(this.applyMacros(node, ATTR_DIR));
            this.debug("moving files to: " + dir + " files=" + files);
            for (int i = 0; i < files.size(); ++i) {
                IOUtil.moveFile(new File(files.get(i).toString()), dir);
            }
        }
        return true;
    }

    protected boolean processTagRename(Element node) throws Throwable {
        String from = this.applyMacros(node, ATTR_FROM);
        String to = this.applyMacros(node, ATTR_TO);
        IOUtil.moveFile(new File(from), new File(to));
        return true;
    }

    protected boolean processTagDelete(Element node) throws Throwable {
        List files = this.findFiles(node);
        if (files != null) {
            this.debug("deleting files:" + files);
            for (int i = 0; i < files.size(); ++i) {
                ((File)files.get(i)).delete();
            }
        }
        return true;
    }

    protected boolean processTagClear(Element node) throws Throwable {
        String name = this.applyMacros(node, ATTR_NAME);
        Hashtable ht = (Hashtable)this.propertiesStack.get(0);
        ht.remove(name);
        return true;
    }

    protected boolean processTagAppend(Element node) throws Throwable {
        String name = this.applyMacros(node, ATTR_NAME);
        Hashtable ht = this.findTableFor(name);
        String value = (String)ht.get(name);
        if (value == null) {
            value = "";
        }
        if (XmlUtil.hasAttribute(node, ATTR_VALUE)) {
            value = value + this.applyMacros(node, ATTR_VALUE);
        } else if (XmlUtil.hasAttribute(node, ATTR_FROMFILE)) {
            String filename = this.applyMacros(node, ATTR_FROMFILE);
            value = value + this.applyMacros(IOUtil.readContents(filename));
        } else {
            value = value + this.applyMacros(XmlUtil.getChildText(node)).trim();
        }
        ht.put(name, value);
        return true;
    }

    protected boolean processTagIncrement(Element node) throws Throwable {
        String name = this.applyMacros(node, ATTR_NAME);
        Hashtable ht = this.findTableFor(name);
        String value = (String)ht.get(name);
        if (value == null) {
            value = "0";
        }
        String by = "1";
        if (XmlUtil.hasAttribute(node, ATTR_VALUE)) {
            by = this.applyMacros(node, ATTR_VALUE);
        }
        double num = new Double(value) + new Double(by);
        ht.put(name, "" + num);
        return true;
    }

    protected boolean processTagReplace(Element node) throws Throwable {
        String name = this.applyMacros(node, ATTR_NAME);
        Hashtable ht = this.findTableFor(name);
        ht.put(name, this.applyMacros(node, ATTR_VALUE));
        return true;
    }

    protected boolean processTagCopy(Element node) throws Throwable {
        List files = this.findFiles(node);
        if (files != null) {
            File dir = new File(this.applyMacros(node, ATTR_DIR));
            IOUtil.makeDir(dir);
            if (!dir.isDirectory()) {
                return this.error("Specified file:" + dir + " is not a directory");
            }
            this.debug("copying files to: " + dir + " files=" + files);
            for (int i = 0; i < files.size(); ++i) {
                IOUtil.copyFile(new File(files.get(i).toString()), dir);
            }
        }
        return true;
    }

    protected boolean processTagReload(Element node) throws Throwable {
        List dataSources = this.getIdv().getDataSources();
        for (int i = 0; i < dataSources.size(); ++i) {
            DataSource dataSource = (DataSource)dataSources.get(i);
            dataSource.reloadData();
        }
        return true;
    }

    protected boolean processTagExec(Element node) throws Throwable {
        String command = this.applyMacros(node, ATTR_COMMAND);
        this.debug("Calling exec:" + command);
        Process process = Runtime.getRuntime().exec(command);
        process.waitFor();
        if (process.exitValue() != 0) {
            String result = IOUtil.readContents(process.getInputStream());
            System.err.println("Exec:\n\t" + command + "\nreturned:" + process.exitValue() + "\n" + result);
        }
        return true;
    }

    protected boolean processTagJython(Element node) throws Throwable {
        String jythonFile = this.applyMacros(node, "file", (String)null);
        if (jythonFile != null) {
            InputStream is = IOUtil.getInputStream(jythonFile, this.getClass());
            if (is == null) {
                return this.error("Could not open jython file:" + jythonFile);
            }
            this.getInterpreter().execfile(is, jythonFile);
        } else {
            String jython = this.applyMacros(node, ATTR_CODE, (String)null);
            if (jython == null) {
                jython = XmlUtil.getChildText(node);
            }
            if (jython != null) {
                this.getInterpreter().exec(jython);
            }
        }
        return true;
    }

    protected boolean processTagFileset(Element node) throws Throwable {
        List files = this.findFiles(Misc.newList(node));
        this.pushProperties();
        for (int i = 0; i < files.size(); ++i) {
            try {
                String filePath = files.get(i).toString();
                String tail = IOUtil.getFileTail(filePath);
                this.putProperty("file", filePath);
                this.putProperty(PROP_FILEPREFIX, IOUtil.stripExtension(filePath));
                this.putProperty(PROP_FILENOSUFFIX, IOUtil.stripExtension(filePath));
                this.putProperty(PROP_FILETAIL, tail);
                this.putProperty(PROP_FILETAILNOSUFFIX, IOUtil.stripExtension(tail));
                if (this.processChildren(node)) continue;
                return false;
            }
            catch (MyBreakException be) {
                break;
            }
            catch (MyContinueException myContinueException) {
                // empty catch block
            }
        }
        this.popProperties();
        return true;
    }

    protected boolean processTagImport(Element node) throws Throwable {
        Element parent = (Element)node.getParentNode();
        String file = this.applyMacros(node, "file");
        Element root = XmlUtil.findRoot(node);
        Element newRoot = XmlUtil.getRoot(file, this.getClass());
        newRoot = (Element)root.getOwnerDocument().importNode(newRoot, true);
        parent.insertBefore(newRoot, node);
        parent.removeChild(node);
        return this.processNode(newRoot);
    }

    protected boolean processTagLoadcatalog(Element node) throws Throwable {
        String url = this.applyMacros(node, ATTR_URL, (String)null);
        this.getIdv().getIdvChooserManager().showCatalogUrl(url);
        return true;
    }

    protected boolean processTagListdirectory(Element node) throws Throwable {
        String file = this.applyMacros(node, "file", (String)null);
        this.getIdv().getIdvChooserManager().showFileChooser(file);
        return true;
    }

    protected boolean processTagDatasource(Element node) throws Throwable {
        this.debug("Creating data source");
        DataSource dataSource = null;
        String id = this.applyMacros(node, ATTR_ID, (String)null);
        if (id != null && this.objectMap != null) {
            dataSource = (DataSource)this.objectMap.get(id);
        }
        if (dataSource == null) {
            Object dataObject = this.applyMacros(node, ATTR_URL, (String)null);
            if (dataObject == null) {
                dataObject = StringUtil.toString(this.findFiles(node));
            }
            String bundle = this.applyMacros(node, "bundle", (String)null);
            String type = this.applyMacros(node, ATTR_TYPE, (String)null);
            if (bundle == null && dataObject == null) {
                return this.error("datasource tag requires either a url, fileset or a bundle");
            }
            Hashtable<String, String> properties = new Hashtable<String, String>();
            String name = this.applyMacros(node, ATTR_NAME, (String)null);
            if (name != null) {
                properties.put(ATTR_NAME, name);
            }
            if (dataObject != null) {
                dataSource = this.getIdv().makeOneDataSource(dataObject, type, properties);
                if (dataSource == null) {
                    return this.error("Failed to create data source:" + dataObject + " " + type);
                }
            } else {
                try {
                    String bundleXml = IOUtil.readContents(bundle);
                    Object obj = this.getIdv().getEncoderForRead().toObject(bundleXml);
                    if (!(obj instanceof DataSource)) {
                        return this.error("datasource bundle is not a DataSource:" + obj.getClass().getName());
                    }
                    dataSource = (DataSource)obj;
                }
                catch (Exception exc) {
                    return this.error("Error loading data source bundle: " + bundle, exc);
                }
            }
        }
        if (XmlUtil.hasAttribute(node, ATTR_TIMES)) {
            List timesList = StringUtil.parseIntegerListString(this.applyMacros(node, ATTR_TIMES, (String)null));
            dataSource.setDateTimeSelection(timesList);
        }
        if (XmlUtil.hasAttribute(node, ATTR_ENSEMBLES)) {
            List ensList = StringUtil.parseIntegerListString(this.applyMacros(node, ATTR_ENSEMBLES, (String)null));
            if (dataSource instanceof GridDataSource) {
                ((GridDataSource)dataSource).setEnsembleSelection(ensList);
            }
        }
        this.processGeoSelectionTags(node, dataSource.getDataSelection());
        Hashtable properties = this.getProperties(node);
        dataSource.setObjectProperties(properties);
        if (id != null) {
            this.idToDataSource.put(id, dataSource);
        }
        NodeList elements = XmlUtil.getElements(node);
        for (int childIdx = 0; childIdx < elements.getLength(); ++childIdx) {
            Element child = (Element)elements.item(childIdx);
            if (!child.getTagName().equals("display") || this.processDisplayNode(child, dataSource)) continue;
            return false;
        }
        this.updateViewManagers();
        return true;
    }

    protected boolean processTagJoin(Element node) throws Throwable {
        List files = this.findFiles(node);
        if (files != null) {
            ArrayList<Image> images = new ArrayList<Image>();
            int cols = this.applyMacros(node, ATTR_COLUMNS, 0);
            int rows = this.applyMacros(node, ATTR_ROWS, 0);
            if (cols == 0 && rows == 0) {
                cols = 1;
            }
            if (cols != 0 && rows != 0) {
                cols = 0;
            }
            boolean colNum = false;
            boolean rowNum = false;
            for (int i = 0; i < files.size(); ++i) {
                Image theImage = ImageUtils.readImage(files.get(i).toString());
                if (theImage == null) continue;
                images.add(theImage);
            }
            if (images.size() > 0) {
                if (cols == 0) {
                    cols = images.size() / rows;
                } else {
                    rows = images.size() / cols;
                }
                boolean maxWidth = false;
                boolean maxHeight = false;
                boolean colCnt = false;
                for (int i = 0; i < images.size(); ++i) {
                    Image theImage = (Image)images.get(i);
                    int width = theImage.getWidth(null);
                    int n = theImage.getHeight(null);
                }
            }
        }
        return true;
    }

    protected boolean processTagView(Element node) throws Throwable {
        List<ViewManager> vms = this.getViewManagers(node);
        String width = this.applyMacros(node, ATTR_WIDTH, (String)null);
        String height = this.applyMacros(node, ATTR_HEIGHT, (String)null);
        if (width != null && height != null) {
            this.getIdv().getStateManager().setViewSize(new Dimension(new Integer(width), new Integer(height)));
        }
        if (vms.size() == 0) {
            StringBuffer properties = new StringBuffer();
            List nodes = XmlUtil.findChildren(node, "property");
            for (int childIdx = 0; childIdx < nodes.size(); ++childIdx) {
                Element child = (Element)nodes.get(childIdx);
                properties.append(this.applyMacros(child, ATTR_NAME) + "=" + this.applyMacros(child, ATTR_VALUE) + ";");
            }
            vms.add(this.getIdv().getViewManager(ViewDescriptor.LASTACTIVE, false, properties.toString()));
            return true;
        }
        for (int i = 0; i < vms.size(); ++i) {
            ViewManager vm = vms.get(i);
            List nodes = XmlUtil.findChildren(node, "property");
            for (int childIdx = 0; childIdx < nodes.size(); ++childIdx) {
                Element child = (Element)nodes.get(childIdx);
                vm.setProperty(this.applyMacros(child, ATTR_NAME), this.applyMacros(child, ATTR_VALUE), false);
            }
        }
        return true;
    }

    protected boolean processTagAnimation(Element node) throws Throwable {
        String indexString = this.applyMacros(node, ATTR_INDEX, "0");
        int index = -1;
        boolean end = indexString.equals("end");
        boolean step = indexString.equals("step");
        if (!end && !step) {
            index = new Integer(indexString);
        }
        for (ViewManager viewManager : this.getViewManagers(node)) {
            AnimationWidget animationWidget = viewManager.getAnimationWidget();
            if (animationWidget == null) continue;
            if (end) {
                animationWidget.gotoEnd();
                continue;
            }
            if (step) {
                animationWidget.stepForward();
                continue;
            }
            animationWidget.gotoIndex(index);
        }
        return true;
    }

    protected boolean processTagViewpoint(Element node) throws Throwable {
        List<ViewManager> vms = this.getViewManagers(node);
        if (vms.size() == 0) {
            this.debug("Could not find view managers processing:" + XmlUtil.toString(node));
        }
        ViewpointInfo viewpointInfo = null;
        for (int i = 0; i < vms.size(); ++i) {
            double[] a;
            ViewManager vm = vms.get(i);
            if (XmlUtil.hasAttribute(node, ATTR_VIEWDIR)) {
                vm.setView(XmlUtil.getAttribute(node, ATTR_VIEWDIR));
            }
            if (XmlUtil.hasAttribute(node, ATTR_AZIMUTH) || XmlUtil.hasAttribute(node, ATTR_TILT)) {
                viewpointInfo = new ViewpointInfo(this.toDouble(node, ATTR_AZIMUTH, 0.0), this.toDouble(node, ATTR_TILT, 0.0));
                if (!(vm instanceof MapViewManager)) continue;
                MapViewManager mvm = (MapViewManager)vm;
                mvm.setViewpointInfo(viewpointInfo);
            }
            if (XmlUtil.hasAttribute(node, ATTR_ASPECTX) || XmlUtil.hasAttribute(node, ATTR_ASPECTY) || XmlUtil.hasAttribute(node, ATTR_ASPECTZ)) {
                a = vm.getMaster().getDisplayAspect();
                a = new double[]{this.toDouble(node, ATTR_ASPECTX, a[0]), this.toDouble(node, ATTR_ASPECTY, a[1]), this.toDouble(node, ATTR_ASPECTZ, a[2])};
                vm.getMaster().setDisplayAspect(a);
                vm.setAspectRatio(a);
            }
            if (!XmlUtil.hasAttribute(node, ATTR_ROTX) && !XmlUtil.hasAttribute(node, ATTR_ROTY) && !XmlUtil.hasAttribute(node, ATTR_ROTZ) && !XmlUtil.hasAttribute(node, ATTR_TRANSX) && !XmlUtil.hasAttribute(node, ATTR_TRANSY) && !XmlUtil.hasAttribute(node, ATTR_TRANSZ) && !XmlUtil.hasAttribute(node, ATTR_SCALE)) continue;
            a = vm.getMaster().getDisplayAspect();
            double[] currentMatrix = vm.getDisplayMatrix();
            double[] trans = new double[]{0.0, 0.0, 0.0};
            double[] rot = new double[]{0.0, 0.0, 0.0};
            double[] scale = new double[]{0.0, 0.0, 0.0};
            MouseBehavior mb = vm.getMaster().getMouseBehavior();
            mb.instance_unmake_matrix(rot, scale, trans, currentMatrix);
            double scaleValue = this.applyMacros(node, ATTR_SCALE, 0.0);
            if (scaleValue != 0.0) {
                double scaleX = scaleValue * a[0];
                double scaleY = scaleValue * a[1];
                double scaleZ = scaleValue * a[2];
                double[] scaleMatrix = mb.make_matrix(0.0, 0.0, 0.0, scaleX / scale[0], scaleY / scale[1], scaleZ / scale[2], 0.0, 0.0, 0.0);
                currentMatrix = mb.multiply_matrix(scaleMatrix, currentMatrix);
                mb.instance_unmake_matrix(rot, scale, trans, currentMatrix);
            }
            double dummy = 0.0;
            if (XmlUtil.hasAttribute(node, ATTR_ROTX)) {
                double[] tmp = mb.make_matrix(this.applyMacros(node, ATTR_ROTX, dummy), 0.0, 0.0, 1.0, 0.0, 0.0, 0.0);
                currentMatrix = mb.multiply_matrix(tmp, currentMatrix);
                mb.instance_unmake_matrix(rot, scale, trans, currentMatrix);
            }
            if (XmlUtil.hasAttribute(node, ATTR_ROTY)) {
                double[] tmp = mb.make_matrix(0.0, this.applyMacros(node, ATTR_ROTY, dummy) - rot[1], 0.0, 1.0, 0.0, 0.0, 0.0);
                currentMatrix = mb.multiply_matrix(tmp, currentMatrix);
                mb.instance_unmake_matrix(rot, scale, trans, currentMatrix);
            }
            if (XmlUtil.hasAttribute(node, ATTR_ROTZ)) {
                double[] tmp = mb.make_matrix(0.0, 0.0, this.applyMacros(node, ATTR_ROTZ, dummy) - rot[2], 1.0, 0.0, 0.0, 0.0);
                currentMatrix = mb.multiply_matrix(tmp, currentMatrix);
                mb.instance_unmake_matrix(rot, scale, trans, currentMatrix);
            }
            if (XmlUtil.hasAttribute(node, ATTR_TRANSX)) {
                double[] tmp = mb.make_translate(this.applyMacros(node, ATTR_TRANSX, dummy) - trans[0], 0.0, 0.0);
                currentMatrix = mb.multiply_matrix(tmp, currentMatrix);
                mb.instance_unmake_matrix(rot, scale, trans, currentMatrix);
            }
            if (XmlUtil.hasAttribute(node, ATTR_TRANSY)) {
                double[] tmp = mb.make_translate(0.0, this.applyMacros(node, ATTR_TRANSY, dummy) - trans[1], 0.0);
                currentMatrix = mb.multiply_matrix(tmp, currentMatrix);
                mb.instance_unmake_matrix(rot, scale, trans, currentMatrix);
            }
            if (XmlUtil.hasAttribute(node, ATTR_TRANSZ)) {
                double[] tmp = mb.make_translate(0.0, 0.0, this.applyMacros(node, ATTR_TRANSZ, dummy) - trans[2]);
                currentMatrix = mb.multiply_matrix(tmp, currentMatrix);
                mb.instance_unmake_matrix(rot, scale, trans, currentMatrix);
            }
            vm.setDisplayMatrix(currentMatrix);
        }
        return true;
    }

    protected boolean processTagCenter(Element node) throws Throwable {
        List<ViewManager> vms = this.getViewManagers(node);
        if (XmlUtil.hasAttribute(node, ATTR_LAT)) {
            this.getVMManager().center(Util.makeEarthLocation(this.toDouble(node, ATTR_LAT), this.toDouble(node, ATTR_LON)), vms);
            return true;
        }
        if (XmlUtil.hasAttribute(node, ATTR_NORTH)) {
            ProjectionRect projRect = new ProjectionRect(this.toDouble(node, ATTR_WEST), this.toDouble(node, ATTR_NORTH), this.toDouble(node, ATTR_EAST), this.toDouble(node, ATTR_SOUTH));
            this.getVMManager().center(projRect, vms);
            return true;
        }
        if (XmlUtil.hasAttribute(node, "display")) {
            DisplayControlImpl display = this.findDisplayControl(node);
            if (display == null) {
                throw new IllegalArgumentException("Could not find display:" + XmlUtil.toString(node));
            }
            if (XmlUtil.getAttribute((Node)node, ATTR_USEPROJECTION, false)) {
                MapProjection mp = display.getDataProjection();
                if (mp != null) {
                    this.getVMManager().center(mp, vms);
                }
            } else {
                LatLonPoint llp = display.getDisplayCenter();
                if (llp != null) {
                    this.getVMManager().center(Util.makeEarthLocation(llp), vms);
                }
            }
            return true;
        }
        this.getVMManager().center(vms);
        return true;
    }

    protected boolean processTagProjection(Element node) throws Throwable {
        if (XmlUtil.hasAttribute(node, ATTR_NAME)) {
            String projName = this.applyMacros(node, ATTR_NAME);
            ProjectionImpl projection = this.getIdv().getIdvProjectionManager().findProjectionByName(projName);
            if (projection == null) {
                throw new IllegalArgumentException("Could not find projection: " + projName);
            }
            ProjectionCoordinateSystem mp = new ProjectionCoordinateSystem(projection);
            this.getVMManager().center(mp);
            return true;
        }
        return true;
    }

    private DataSource findDataSource(Element node) {
        String id = XmlUtil.getAttribute(node, "datasource");
        return this.findDataSource(id);
    }

    private DataSource findDataSource(String id) {
        List dataSources = this.getIdv().getDataSources();
        DataSource dataSource = (DataSource)this.idToDataSource.get(id);
        if (dataSource != null) {
            return dataSource;
        }
        for (int i = 0; i < dataSources.size(); ++i) {
            dataSource = (DataSource)dataSources.get(i);
            if (!dataSource.identifiedByName(id)) continue;
            return dataSource;
        }
        return null;
    }

    private DisplayControlImpl findDisplayControl(Element node) {
        String id = XmlUtil.getAttribute((Node)node, "display", (String)null);
        if (id == null) {
            return null;
        }
        return this.findDisplayControl(id);
    }

    public DisplayControlImpl findDisplayControl(String id) {
        List controls = this.getIdv().getDisplayControls();
        return this.findDisplayControl(id, controls);
    }

    public DisplayControlImpl findDisplayControl(String id, List<DisplayControlImpl> controls) {
        for (int i = 0; i < controls.size(); ++i) {
            DisplayControlImpl control = controls.get(i);
            if (id.startsWith("class:") && StringUtil.stringMatch(control.getClass().getName(), id.substring(6), true, true)) {
                return control;
            }
            if (control.getId() == null || !StringUtil.stringMatch(control.getId(), id, true, true)) continue;
            return control;
        }
        return null;
    }

    protected boolean processTagBundle(Element node) throws Throwable {
        String tdendString;
        String tdstartString;
        String bboxString;
        List timesList = null;
        List ensList = null;
        if (XmlUtil.hasAttribute(node, ATTR_TIMES)) {
            timesList = StringUtil.parseIntegerListString(this.applyMacros(node, ATTR_TIMES, (String)null));
        }
        if (XmlUtil.hasAttribute(node, ATTR_ENSEMBLES)) {
            ensList = StringUtil.parseIntegerListString(this.applyMacros(node, ATTR_ENSEMBLES, (String)null));
        }
        List nodes = XmlUtil.findChildren(node, TAG_SETFILES);
        ArrayList<String> ids = new ArrayList<String>();
        ArrayList fileList = new ArrayList();
        this.getPersistenceManager().clearFileMapping();
        for (int i = 0; i < nodes.size(); ++i) {
            Element child = (Element)nodes.get(i);
            String dataSourceId = XmlUtil.getAttribute(child, "datasource");
            ids.add(dataSourceId);
            ArrayList<String> files = new ArrayList<String>();
            if (XmlUtil.hasAttribute(child, "file")) {
                String file = this.applyMacros(child, "file");
                this.debug("For data source: " + dataSourceId + " Using file: " + file);
                files.add(file);
            } else {
                List filesetFiles = this.findFiles(child);
                if (filesetFiles != null) {
                    this.debug("For data source: " + dataSourceId + " Using file: " + filesetFiles);
                    files.addAll(filesetFiles);
                } else {
                    this.debug("For data source: " + dataSourceId + " Could not find any files");
                }
            }
            fileList.add(files);
            this.debug("Adding a file override id=" + dataSourceId + " files=" + files);
        }
        if (ids.size() > 0) {
            this.getPersistenceManager().setFileMapping(ids, fileList);
        }
        String width = this.applyMacros(node, ATTR_WIDTH, (String)null);
        String height = this.applyMacros(node, ATTR_HEIGHT, (String)null);
        if (width != null && height != null) {
            this.getIdv().getStateManager().setViewSize(new Dimension(new Integer(width), new Integer(height)));
        }
        String bundleFile = this.applyMacros(node, "file", (String)null);
        boolean doRemove = this.applyMacros(node, ATTR_CLEAR, true);
        boolean addWindows = this.applyMacros(node, ATTR_WINDOW, false);
        if (addWindows) {
            this.getPersistenceManager().setAddWindows(addWindows);
        }
        if (doRemove) {
            this.cleanup();
        }
        this.getIdv().getStateManager().setAlwaysLoadBundlesSynchronously(true);
        Hashtable<String, Object> bundleProperties = new Hashtable<String, Object>();
        if (timesList != null) {
            bundleProperties.put("idv.timeslist", timesList);
        }
        if (ensList != null) {
            bundleProperties.put("idv.enslist", ensList);
        }
        if ((bboxString = this.applyMacros(node, ATTR_BBOX, (String)null)) != null) {
            DataSelection dataSelection = new DataSelection();
            this.processGeoSelectionTags(node, dataSelection);
            bundleProperties.put("idv.geoselection", dataSelection.getGeoSelection());
        }
        if ((tdstartString = this.applyMacros(node, ATTR_DRIVERTIME_START, (String)null)) != null) {
            DateTime dd = UtcDate.createDateTime(tdstartString);
            Date aniTDTstart = new Date((long)(dd.getValue(CommonUnit.secondsSinceTheEpoch) * 1000.0));
            bundleProperties.put("idv.drivertimestart", aniTDTstart);
        }
        if ((tdendString = this.applyMacros(node, ATTR_DRIVERTIME_END, (String)null)) != null) {
            DateTime de = UtcDate.createDateTime(tdendString);
            Date aniTDTend = new Date((long)(de.getValue(CommonUnit.secondsSinceTheEpoch) * 1000.0));
            bundleProperties.put("idv.drivertimeend", aniTDTend);
        }
        if (bundleFile != null) {
            String xml;
            this.debug("Loading bundle: " + bundleFile);
            if (bundleFile.endsWith(".jnlp")) {
                xml = this.getPersistenceManager().extractBundleFromJnlp(bundleFile);
                this.getPersistenceManager().decodeXml(xml, false, bundleFile, null, false, true, bundleProperties, true, false);
            } else if (this.getArgsManager().isZidvFile(bundleFile)) {
                Hashtable properties = new Hashtable();
                boolean ask = this.getStore().get("idv.zidv.ask", true);
                this.getStore().put("idv.zidv.ask", false);
                this.getPersistenceManager().decodeXmlFile(bundleFile, "", false, false, properties);
                this.getStore().put("idv.zidv.ask", ask);
            } else {
                xml = IOUtil.readContents(bundleFile);
                xml = this.applyMacros(xml, null, false);
                this.getPersistenceManager().decodeXml(xml, false, bundleFile, null, false, true, bundleProperties, true, false);
            }
        } else {
            String b64Bundle = XmlUtil.getChildText(node).trim();
            if (b64Bundle.length() == 0) {
                return this.error("Could not bundle");
            }
            String xml = new String(XmlUtil.decodeBase64(b64Bundle));
            this.getPersistenceManager().decodeXml(xml, false, "", null, false, true, bundleProperties, true, false);
        }
        if (this.applyMacros(node, ATTR_WAIT, true)) {
            this.getIdv().getIdvUIManager();
            IdvUIManager.waitUntilDisplaysAreDone(this.getIdv().getIdvUIManager());
        }
        this.getPersistenceManager().clearFileMapping();
        Color c = this.applyMacros(node, ATTR_COLOR, (Color)null);
        List<ViewManager> viewManagers = this.getVMManager().getViewManagers();
        for (int i = 0; i < viewManagers.size(); ++i) {
            ViewManager viewManager = viewManagers.get(i);
            if (c != null) {
                viewManager.setColors(null, c);
            }
            viewManager.updateDisplayList();
        }
        this.updateViewManagers();
        this.getIdv().getIdvUIManager();
        IdvUIManager.waitUntilDisplaysAreDone(this.getIdv().getIdvUIManager());
        return true;
    }

    private void cleanup() {
        this.getIdv().removeAllDisplays(false);
        this.getIdv().removeAllDataSources();
        this.idToDataSource = new Hashtable();
        CacheManager.clearCache();
        if (this.getIdv().getArgsManager().getIsOffScreen()) {
            this.getIdv().getVMManager().removeAllViewManagers(true);
        }
        this.getIdv().getIdvUIManager().clearWaitCursor();
        double totalMemory = Runtime.getRuntime().maxMemory();
        double highWaterMark = Runtime.getRuntime().totalMemory();
        double freeMemory = Runtime.getRuntime().freeMemory();
        double usedMemory = highWaterMark - freeMemory;
        totalMemory /= 1000000.0;
        usedMemory /= 1000000.0;
        highWaterMark /= 1000000.0;
    }

    protected boolean processTagCall(Element node) throws Throwable {
        String name = this.applyMacros(node, ATTR_NAME);
        Element procNode = (Element)this.procs.get(name);
        return this.processTagCall(node, procNode);
    }

    protected boolean processTagCall(Element node, Element procNode) throws Throwable {
        NamedNodeMap nnm;
        if (procNode == null) {
            return this.error("Could not find procedure node for call:" + XmlUtil.toString(node));
        }
        this.pushProperties();
        String cdata = XmlUtil.getChildText(node);
        if (cdata != null && cdata.trim().length() > 0) {
            this.putProperty("paramtext", cdata);
        } else {
            this.putProperty("paramtext", "");
        }
        NamedNodeMap procnnm = procNode.getAttributes();
        if (procnnm != null) {
            for (int i = 0; i < procnnm.getLength(); ++i) {
                Attr attr = (Attr)procnnm.item(i);
                if (ATTR_NAME.equals(attr.getNodeName())) continue;
                this.putProperty(attr.getNodeName(), this.applyMacros(attr.getNodeValue()));
            }
        }
        if ((nnm = node.getAttributes()) != null) {
            for (int i = 0; i < nnm.getLength(); ++i) {
                Attr attr = (Attr)nnm.item(i);
                if (ATTR_NAME.equals(attr.getNodeName())) continue;
                this.putProperty(attr.getNodeName(), this.applyMacros(attr.getNodeValue()));
            }
        }
        try {
            if (!this.processChildren(node)) {
                return false;
            }
            try {
                if (!this.processChildren(procNode)) {
                    return false;
                }
            }
            catch (MyReturnException i) {}
        }
        finally {
            this.popProperties();
        }
        return true;
    }

    protected boolean processTagIf(Element node) throws Throwable {
        Element statementNode;
        String expr = this.applyMacros(node, ATTR_EXPR, (String)null);
        if (expr == null) {
            expr = this.applyMacros(XmlUtil.getChildText(node));
        }
        if (expr == null || expr.trim().length() == 0) {
            return this.error("Could not find if expression");
        }
        expr = expr.trim();
        boolean result = this.getInterpreter().eval(expr).toString().equals("True") || this.getInterpreter().eval(expr).toString().equals("1");
        Element thenNode = XmlUtil.findChild(node, TAG_THEN);
        Element elseNode = XmlUtil.findChild(node, TAG_ELSE);
        Element element = statementNode = result ? thenNode : elseNode;
        if (statementNode == null) {
            if (result && thenNode == null && elseNode == null) {
                statementNode = node;
            } else {
                return true;
            }
        }
        if (statementNode != null) {
            if (!this.processChildren(statementNode)) {
                return false;
            }
        }
        return true;
    }

    protected boolean processTagOutput(Element node) throws Throwable {
        if (!XmlUtil.hasAttribute(node, "file")) {
            for (int i = 0; i < this.outputStack.size(); ++i) {
                OutputInfo oi = (OutputInfo)this.outputStack.get(i);
                oi.process(node);
            }
            return true;
        }
        OutputInfo outputInfo = new OutputInfo(node);
        this.outputStack.add(outputInfo);
        this.pushProperties();
        try {
            if (!this.processChildren(node)) {
                return false;
            }
        }
        finally {
            this.popProperties();
        }
        this.outputStack.remove(this.outputStack.size() - 1);
        outputInfo.write();
        return true;
    }

    protected boolean processTagIsl(Element node) throws Throwable {
        this.debug = this.applyMacros(node, ATTR_DEBUG, false);
        boolean offScreen = this.applyMacros(node, "offscreen", true);
        if (!this.getIdv().getArgsManager().getIslInteractive()) {
            this.getIdv().getArgsManager().setIsOffScreen(offScreen);
        }
        this.putProperty("offscreen", this.getIdv().getArgsManager().getIsOffScreen() ? "1" : "0");
        return this.processTagGroup(node);
    }

    protected boolean processTagGroup(Element node) throws Throwable {
        this.pushProperties();
        int loopTimes = this.applyMacros(node, ATTR_LOOP, 1);
        String sleepString = this.applyMacros(node, ATTR_SLEEP, (String)null);
        long sleepTime = 0L;
        if (sleepString != null) {
            sleepString = sleepString.trim();
            long multiplier = 1000L;
            String unit = StringUtil.findPattern(sleepString, "[0-9.]+(.*)$");
            if (unit != null && unit.trim().length() > 0) {
                sleepString = sleepString.substring(0, sleepString.length() - unit.length());
                switch (unit) {
                    case "s": {
                        break;
                    }
                    case "seconds": {
                        break;
                    }
                    case "minutes": {
                        multiplier = 60000L;
                        break;
                    }
                    case "m": {
                        multiplier = 60000L;
                        break;
                    }
                    case "hours": {
                        multiplier = 3600000L;
                        break;
                    }
                    case "h": {
                        multiplier = 3600000L;
                        break;
                    }
                    default: {
                        return this.error("Unknown sleep time unit:" + unit);
                    }
                }
            }
            sleepTime = (long)((double)multiplier * new Double(sleepString));
        }
        for (int i = 0; i < loopTimes; ++i) {
            this.currentLoopIndex = i;
            try {
                if (!this.processChildren(node)) {
                    return false;
                }
            }
            catch (MyBreakException be) {
                break;
            }
            catch (MyContinueException myContinueException) {
                // empty catch block
            }
            if (loopTimes <= 1 || sleepTime <= 0L) continue;
            Misc.sleep(sleepTime);
        }
        this.popProperties();
        return true;
    }

    protected boolean processTagForeach(Element node) throws Throwable {
        this.pushProperties();
        ArrayList<Object[]> allValues = new ArrayList<Object[]>();
        int numElements = 0;
        int cnt = 1;
        NamedNodeMap attrs = node.getAttributes();
        if (attrs == null) {
            return this.error("No values in foreach tag");
        }
        for (int i = 0; i < attrs.getLength(); ++i) {
            List<String> tokens;
            Attr attr = (Attr)attrs.item(i);
            String var = attr.getNodeName();
            String values = this.applyMacros(attr.getNodeValue());
            if (values.startsWith("file:")) {
                String filename = this.applyMacros(values.substring("file:".length()));
                values = IOUtil.readContents(filename, this.getClass()).trim();
                tokens = StringUtil.split(values, "\n");
            } else {
                tokens = StringUtil.split(values, ",");
            }
            if (allValues.size() == 0) {
                numElements = tokens.size();
            } else if (numElements != tokens.size()) {
                return this.error("Bad number of tokens (" + tokens.size() + " should be:" + numElements + ") in foreach argument:\n" + var + "=" + tokens);
            }
            allValues.add(new Object[]{var, tokens});
            ++cnt;
        }
        for (int tokIdx = 0; tokIdx < numElements; ++tokIdx) {
            for (int valueIdx = 0; valueIdx < allValues.size(); ++valueIdx) {
                Object[] tuple = (Object[])allValues.get(valueIdx);
                this.putProperty(tuple[0], ((List)tuple[1]).get(tokIdx));
            }
            try {
                if (this.processChildren(node)) continue;
                return false;
            }
            catch (MyBreakException be) {
                break;
            }
            catch (MyContinueException myContinueException) {
                // empty catch block
            }
        }
        this.popProperties();
        return true;
    }

    protected boolean processTagMovie(Element node) throws Throwable {
        String result;
        String filename = XmlUtil.getAttribute(node, "file");
        this.pushProperties();
        this.getIdv().getIdvUIManager();
        IdvUIManager.waitUntilDisplaysAreDone(this.getIdv().getIdvUIManager(), 0L);
        this.captureMovie(null, node);
        this.popProperties();
        if (XmlUtil.getAttribute((Node)node, TAG_PUBLISH, false) && (result = this.getIdv().getPublishManager().publishFile(filename)) != null) {
            this.results.add(result);
        }
        return true;
    }

    protected boolean processTagHtml(Element node) throws Throwable {
        String html = null;
        html = XmlUtil.hasAttribute(node, ATTR_FROMFILE) ? IOUtil.readContents(this.applyMacros(node, ATTR_FROMFILE)) : XmlUtil.getChildText(node);
        html = this.applyMacros(html);
        int width = XmlUtil.getAttribute((Node)node, ATTR_WIDTH, -1);
        Image image = ImageUtils.renderHtml(html, width, null, null);
        image = this.processImage(ImageUtils.toBufferedImage(image), XmlUtil.getAttribute(node, "file"), node, this.getAllProperties(), null, new Hashtable());
        return true;
    }

    protected boolean processTagPanel(Element node) throws Throwable {
        this.pushProperties();
        this.captureMovie(null, node);
        this.popProperties();
        return true;
    }

    private Element makeElement(String xml) throws Exception {
        return XmlUtil.getRoot(xml);
    }

    public void writeMovie(String filename, String params) throws Exception {
        String isl = ImageGenerator.makeXmlFromString(params);
        String xml = XmlUtil.getHeader() + "\n<movie file=\"" + filename + "\" imagesuffix=\".png\">" + isl + "</movie>";
        this.captureMovie(this.applyMacros(filename), this.makeElement(xml));
    }

    protected boolean processTagImage(Element node) throws Throwable {
        String result;
        String filename = XmlUtil.getAttribute(node, "file");
        this.captureImage(filename, node);
        if (XmlUtil.getAttribute((Node)node, TAG_PUBLISH, false) && (result = this.getIdv().getPublishManager().publishFile(filename)) != null) {
            this.results.add(result);
        }
        return true;
    }

    protected boolean processTagWait(Element node) throws Throwable {
        File f = null;
        if (XmlUtil.hasAttribute(node, "file")) {
            f = new File(this.applyMacros(node, "file"));
        }
        double seconds = this.applyMacros(node, ATTR_SECONDS, 60.0);
        if (f != null && f.isDirectory()) {
            String patternStr = this.applyMacros(this.applyMacros(node, ATTR_PATTERN, (String)null));
            IOUtil.wait(f, patternStr, seconds);
        } else if (f != null) {
            IOUtil.wait(Misc.newList(f), seconds);
        } else {
            IOUtil.wait(this.findFiles(node), seconds);
        }
        return true;
    }

    protected boolean processTagPause(Element node) throws Throwable {
        if (XmlUtil.hasAttribute(node, ATTR_EVERY)) {
            Misc.pauseEvery((int)(60.0 * this.toDouble(node, ATTR_EVERY)));
            return true;
        }
        if (XmlUtil.hasAttribute(node, ATTR_SECONDS)) {
            Misc.sleep((long)(1000.0 * this.toDouble(node, ATTR_SECONDS)));
        } else if (XmlUtil.hasAttribute(node, ATTR_MINUTES)) {
            Misc.sleep((long)(60000.0 * this.toDouble(node, ATTR_MINUTES)));
        } else if (XmlUtil.hasAttribute(node, ATTR_HOURS)) {
            Misc.sleep((long)(3600000.0 * this.toDouble(node, ATTR_HOURS)));
        } else {
            this.updateViewManagers();
            this.getIdv().getIdvUIManager();
            IdvUIManager.waitUntilDisplaysAreDone(this.getIdv().getIdvUIManager());
        }
        return true;
    }

    protected void updateViewManagers() {
        try {
            List<ViewManager> viewManagers = this.getVMManager().getViewManagers();
            for (int i = 0; i < viewManagers.size(); ++i) {
                ViewManager viewManager = viewManagers.get(i);
                viewManager.updateDisplayIfNeeded();
            }
        }
        catch (Exception exc) {
            ImageGenerator.logException("Updating view manager", exc);
        }
    }

    protected boolean processTagDisplayproperties(Element node) {
        DisplayControlImpl display = this.findDisplayControl(node);
        if (display == null) {
            throw new IllegalArgumentException("Could not find display:" + XmlUtil.toString(node));
        }
        Hashtable properties = this.getProperties(node);
        display.applyProperties(properties);
        return true;
    }

    protected boolean processTagDisplay(Element node) {
        if (!this.processDisplayNode(node, null)) {
            return false;
        }
        if (this.applyMacros(node, ATTR_WAIT, true)) {
            this.pause();
        }
        this.updateViewManagers();
        return true;
    }

    private boolean processDisplayNode(Element node, DataSource dataSource) {
        String type = this.applyMacros(node, ATTR_TYPE, (String)null);
        String param = this.applyMacros(node, ATTR_PARAM, (String)null);
        DataChoice dataChoice = null;
        this.debug("Creating display: " + type + " param:" + param);
        if (dataSource == null && XmlUtil.hasAttribute(node, "datasource") && (dataSource = this.findDataSource(node)) == null) {
            return this.error("Failed to to find data source for display tag:" + XmlUtil.toString(node));
        }
        if (param != null) {
            if (dataSource != null) {
                dataChoice = dataSource.findDataChoice(param);
            } else {
                List dataSources = this.getIdv().getDataSources();
                for (int i = 0; i < dataSources.size() && dataChoice == null; ++i) {
                    dataSource = (DataSource)dataSources.get(i);
                    dataChoice = dataSource.findDataChoice(param);
                }
            }
            if (dataChoice == null) {
                return this.error("Failed to find parameter:" + param);
            }
        }
        ArrayList<DataChoice> dataChoices = new ArrayList<DataChoice>();
        if (dataChoice != null) {
            dataChoice = dataChoice.createClone();
            DataSelection dataSelection = new DataSelection(this.applyMacros(node, ATTR_LEVEL_FROM, (String)null), this.applyMacros(node, ATTR_LEVEL_TO, (String)null));
            this.processGeoSelectionTags(node, dataSelection);
            String timeString = this.applyMacros(node, ATTR_TIMES, (String)null);
            if (timeString != null) {
                ArrayList<Integer> times = new ArrayList<Integer>();
                for (String tok : StringUtil.split(timeString, ",", true, true)) {
                    times.add(new Integer(tok));
                }
                dataSelection.setTimes(times);
            }
            if (XmlUtil.hasAttribute(node, ATTR_ENSEMBLES)) {
                List ensList = StringUtil.parseIntegerListString(this.applyMacros(node, ATTR_ENSEMBLES, (String)null));
                dataSelection.putProperty("prop.gridmembers", ensList);
            }
            dataChoice.setDataSelection(dataSelection);
            dataChoices.add(dataChoice);
        }
        if (type == null) {
            String bundleXml = null;
            if (XmlUtil.hasAttribute(node, "template")) {
                String filename = this.applyMacros(node, "template");
                try {
                    bundleXml = IOUtil.readContents(filename);
                }
                catch (IOException exc) {
                    return this.error("Could not find file: " + filename);
                }
            } else {
                Element templateNode = XmlUtil.findChild(node, "template");
                if (templateNode != null) {
                    bundleXml = XmlUtil.getChildText(templateNode);
                }
            }
            if (bundleXml == null) {
                return this.error("<display> tag does not contain type attribute or template attribute/tag");
            }
            try {
                Object obj = this.getIdv().getEncoderForRead().toObject(bundleXml);
                if (!(obj instanceof DisplayControl)) {
                    return this.error("display template is not a DisplayControl:" + obj.getClass().getName());
                }
                DisplayControl displayControl = (DisplayControl)obj;
                displayControl.initAfterUnPersistence(this.getIdv(), this.getProperties(node), dataChoices);
                this.getIdv().addDisplayControl(displayControl);
            }
            catch (Exception exc) {
                return this.error("Creating display", exc);
            }
        } else {
            ControlDescriptor cd = this.getIdv().getControlDescriptor(type);
            if (cd == null) {
                return this.error("Failed to find display control:" + type);
            }
            Trace.call1("ImageGenerator making display");
            this.getIdv().doMakeControl(dataChoices, cd, this.getProperties(node), null, false);
            Trace.call2("ImageGenerator making display");
        }
        return true;
    }

    private boolean processGeoSelectionTags(Element node, DataSelection dataSelection) {
        String bboxString;
        String strideZString;
        String strideYString;
        String strideXString;
        String strideString = this.applyMacros(node, ATTR_STRIDE, (String)null);
        if (strideString != null) {
            dataSelection.getGeoSelection(true).setXStride(this.applyMacros(node, ATTR_STRIDE, 1));
            dataSelection.getGeoSelection(true).setYStride(this.applyMacros(node, ATTR_STRIDE, 1));
        }
        if ((strideXString = this.applyMacros(node, ATTR_STRIDEX, (String)null)) != null) {
            dataSelection.getGeoSelection(true).setXStride(this.applyMacros(node, ATTR_STRIDEX, 1));
        }
        if ((strideYString = this.applyMacros(node, ATTR_STRIDEY, (String)null)) != null) {
            dataSelection.getGeoSelection(true).setYStride(this.applyMacros(node, ATTR_STRIDEY, 1));
        }
        if ((strideZString = this.applyMacros(node, ATTR_STRIDEZ, (String)null)) != null) {
            dataSelection.getGeoSelection(true).setZStride(this.applyMacros(node, ATTR_STRIDEX, 1));
        }
        if ((bboxString = this.applyMacros(node, ATTR_BBOX, (String)null)) != null) {
            List<String> toks = StringUtil.split(bboxString, ",", true, true);
            if (toks.size() != 4) {
                return this.error("Bad idv.data.geosubset property:" + bboxString);
            }
            GeoLocationInfo boundingBox = new GeoLocationInfo(Misc.decodeLatLon(toks.get(0)), Misc.decodeLatLon(toks.get(1)), Misc.decodeLatLon(toks.get(2)), Misc.decodeLatLon(toks.get(3)));
            dataSelection.getGeoSelection(true).setBoundingBox(boundingBox);
        }
        return true;
    }

    private Hashtable getProperties(Element node) {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        List nodes = XmlUtil.findChildren(node, "property");
        for (int i = 0; i < nodes.size(); ++i) {
            Element child = (Element)nodes.get(i);
            properties.put(this.applyMacros(child, ATTR_NAME), this.applyMacros(child, ATTR_VALUE));
        }
        return properties;
    }

    protected boolean error(String msg) {
        if (this.interactive && !this.getIdv().getArgsManager().getIsOffScreen()) {
            LogUtil.userErrorMessage(msg);
        } else {
            System.err.println(msg);
            this.error = msg;
        }
        return false;
    }

    protected boolean error(String msg, Exception exc) {
        if (!this.getIdv().getArgsManager().getIsOffScreen()) {
            LogUtil.logException(msg, exc);
        } else {
            exc.printStackTrace();
            System.err.println(msg);
        }
        return false;
    }

    private List findFiles(Element parentNode) {
        ArrayList resultFiles = null;
        List filesets = XmlUtil.findChildren(parentNode, TAG_FILESET);
        if (filesets.size() > 0) {
            if (resultFiles == null) {
                resultFiles = new ArrayList();
            }
            resultFiles.addAll(this.findFiles(filesets));
        }
        if (resultFiles == null) {
            return null;
        }
        return resultFiles;
    }

    private List findFiles(List nodes) {
        ArrayList<File> files = new ArrayList<File>();
        for (int i = 0; i < nodes.size(); ++i) {
            int last;
            int fileIdx;
            File[] allFiles;
            Element node = (Element)nodes.get(i);
            if (!node.getTagName().equals(TAG_FILESET)) continue;
            String filename = this.applyMacros(node, "file", (String)null);
            if (filename != null) {
                files.add(new File(filename));
                continue;
            }
            File dir = new File(this.applyMacros(node, ATTR_DIR, "."));
            String pattern = this.applyMacros(this.applyMacros(node, ATTR_PATTERN, (String)null));
            File[] fileArray = allFiles = pattern == null ? dir.listFiles() : dir.listFiles(new PatternFileFilter(pattern));
            if (allFiles == null) continue;
            List tmpFiles = new ArrayList<File>();
            for (int fileIdx2 = 0; fileIdx2 < allFiles.length; ++fileIdx2) {
                if (allFiles[fileIdx2].isDirectory() || files.contains(allFiles[fileIdx2])) continue;
                tmpFiles.add(allFiles[fileIdx2]);
            }
            String sort = this.applyMacros(node, ATTR_SORT, (String)null);
            String sortDir = this.applyMacros(node, ATTR_SORTDIR, VALUE_ASCENDING);
            if (sort != null) {
                if (sort.equals(VALUE_TIME)) {
                    switch (sortDir) {
                        case "ascending": {
                            tmpFiles = Misc.toList(IOUtil.sortFilesOnAge(IOUtil.toFiles(tmpFiles), false));
                            break;
                        }
                        case "descending": {
                            tmpFiles = Misc.toList(IOUtil.sortFilesOnAge(IOUtil.toFiles(tmpFiles), true));
                            break;
                        }
                        default: {
                            System.err.println("unknown sort direction:" + sortDir);
                            break;
                        }
                    }
                } else {
                    System.err.println("unknown sort type:" + sort);
                }
            }
            if (XmlUtil.hasAttribute(node, "first")) {
                int first = this.applyMacros(node, "first", 0);
                if (first < tmpFiles.size()) {
                    ArrayList tmp = new ArrayList();
                    for (fileIdx = 0; fileIdx < first; ++fileIdx) {
                        tmp.add(tmpFiles.get(fileIdx));
                    }
                    tmpFiles = tmp;
                }
            } else if (XmlUtil.hasAttribute(node, "last") && (last = this.applyMacros(node, "last", 0)) < tmpFiles.size()) {
                ArrayList tmp = new ArrayList();
                for (fileIdx = tmpFiles.size() - 1; fileIdx >= 0; --fileIdx) {
                    tmp.add(0, tmpFiles.get(fileIdx));
                    if (tmp.size() >= last) break;
                }
                tmpFiles = tmp;
            }
            files.addAll(tmpFiles);
        }
        return files;
    }

    private void putProperty(Object key, Object value) {
        this.putProperty(key, value, false);
    }

    private void putProperty(Object key, Object value, boolean global) {
        Hashtable properties = global ? (Hashtable)this.propertiesStack.get(0) : this.getProperties();
        properties.put(key, value);
    }

    private Hashtable findTableFor(Object key) {
        for (int i = this.propertiesStack.size() - 1; i >= 0; --i) {
            Hashtable properties = (Hashtable)this.propertiesStack.get(i);
            if (properties.get(key) == null) continue;
            return properties;
        }
        return this.getProperties();
    }

    private void replaceProperty(Object key, Object value) {
        this.findTableFor(key).put(key, value);
    }

    private Hashtable getProperties() {
        if (this.propertiesStack.size() == 0) {
            return new Hashtable();
        }
        return (Hashtable)this.propertiesStack.get(this.propertiesStack.size() - 1);
    }

    private Hashtable pushProperties() {
        Hashtable properties = new Hashtable();
        this.propertiesStack.add(properties);
        return properties;
    }

    private void popProperties() {
        this.propertiesStack.remove(this.propertiesStack.size() - 1);
    }

    private double toDouble(Element node, String attr, double baseValue) {
        String s = this.applyMacros(node, attr);
        return this.toDouble(s, baseValue);
    }

    private double toDouble(String s, double baseValue) {
        if (s.endsWith("%")) {
            double percent = Misc.toDouble(s.substring(0, s.length() - 1));
            return percent / 100.0 * baseValue;
        }
        return new Double(s);
    }

    private double toDouble(Element node, String attr) {
        return Misc.toDouble(this.applyMacros(node, attr));
    }

    public String applyMacros(Element node, String attr) {
        return this.applyMacros(XmlUtil.getAttribute(node, attr));
    }

    public String applyMacros(Element node, String attr, String dflt) {
        return this.applyMacros(XmlUtil.getAttribute((Node)node, attr, dflt));
    }

    public int applyMacros(Element node, String attr, int dflt) {
        String value = XmlUtil.getAttribute((Node)node, attr, (String)null);
        if (value == null) {
            return dflt;
        }
        return (int)Misc.toDouble(this.applyMacros(value));
    }

    public boolean applyMacros(Element node, String attr, boolean dflt) {
        String value = XmlUtil.getAttribute((Node)node, attr, (String)null);
        if (value == null) {
            return dflt;
        }
        return new Boolean(this.applyMacros(value));
    }

    public Color applyMacros(Element node, String attr, Color dflt) {
        String value = XmlUtil.getAttribute((Node)node, attr, (String)null);
        if (value == null) {
            return dflt;
        }
        String result = this.applyMacros(value);
        if (result.equals(VALUE_NONE)) {
            return null;
        }
        return GuiUtils.decodeColor(result, dflt);
    }

    public double applyMacros(Element node, String attr, double dflt) {
        String value = XmlUtil.getAttribute((Node)node, attr, (String)null);
        if (value == null) {
            return dflt;
        }
        return Misc.toDouble(this.applyMacros(value));
    }

    public String applyMacros(String s) {
        return this.applyMacros(s, null);
    }

    private Hashtable getAllProperties() {
        Hashtable props = new Hashtable();
        for (int i = 0; i < this.propertiesStack.size(); ++i) {
            Hashtable properties = (Hashtable)this.propertiesStack.get(i);
            props.putAll(properties);
        }
        return props;
    }

    private String applyMacros(String s, Hashtable props) {
        return this.applyMacros(s, props, true);
    }

    private String applyMacros(String s, Hashtable props, boolean doTime) {
        if (s == null) {
            return null;
        }
        if (props == null) {
            props = new Hashtable();
        } else {
            Hashtable tmp = props;
            props = new Hashtable();
            props.putAll(tmp);
        }
        props.putAll(this.getAllProperties());
        this.putIndex(props, PROP_LOOPINDEX, this.currentLoopIndex);
        props.put(PROP_LOOPINDEX_PAD2, StringUtil.padLeft("" + this.currentLoopIndex, 2, "0"));
        props.put(PROP_LOOPINDEX_PAD3, StringUtil.padLeft("" + this.currentLoopIndex, 3, "0"));
        props.put(PROP_LOOPINDEX_PAD4, StringUtil.padLeft("" + this.currentLoopIndex, 4, "0"));
        Date now = new Date(Misc.getCurrentTime());
        if (DATE_FORMATS == null) {
            TimeZone timeZone = TimeZone.getTimeZone("GMT");
            DATE_FORMATS = new ArrayList();
            for (int i = 0; i < DATE_PROPS.length; ++i) {
                SimpleDateFormat sdf = new SimpleDateFormat(DATE_PROPS[i]);
                sdf.setTimeZone(timeZone);
                DATE_FORMATS.add(sdf);
            }
        }
        for (int i = 0; i < DATE_FORMATS.size(); ++i) {
            SimpleDateFormat sdf = (SimpleDateFormat)DATE_FORMATS.get(i);
            props.put(DATE_PROPS[i], sdf.format(now));
        }
        props.put("memory", "" + Misc.usedMemory());
        TimeZone tz = this.getIdv().getPreferenceManager().getDefaultTimeZone();
        s = StringUtil.replaceDate(s, "now:", now, tz);
        if (s.indexOf("anim:") >= 0 || s.indexOf("time:") >= 0) {
            Date animationTime = this.getAnimationTime();
            if (animationTime == null) {
                animationTime = now;
            }
            if (doTime) {
                s = StringUtil.replaceDate(s, "anim:", animationTime, tz);
                s = StringUtil.replaceDate(s, "time:", animationTime, tz);
                s = StringUtil.replaceDate(s, "now:", now, tz);
            }
        }
        s = StringUtil.applyMacros(s, props, false);
        if ((s = StringUtil.applyMacros(s, this.getStateManager().getProperties(), false)).indexOf("${") >= 0) {
            throw new BadIslException("Undefined macro in: " + s);
        }
        if (s.startsWith("jython:")) {
            PyObject result = this.getInterpreter().eval(s.substring(7));
            s = ((Object)result).toString();
        }
        if (s.startsWith("interp.")) {
            PyObject result = this.getInterpreter().eval(s);
            s = ((Object)result).toString();
        }
        if (s.startsWith("islInterpreter.")) {
            PyObject result = this.getInterpreter().eval(s);
            s = ((Object)result).toString();
        }
        s = s.replace("\\n", "\n");
        return s;
    }

    public void captureImage(String filename) {
        try {
            this.captureImage(filename, null);
        }
        catch (Throwable exc) {
            ImageGenerator.logException("Capturing image", exc);
        }
    }

    public void putIndex(Hashtable props, String name, int v) {
        props.put(name, new Integer(v));
        props.put(name + "_alpha", this.getLetter(v).toLowerCase());
        props.put(name + "_ALPHA", this.getLetter(v).toUpperCase());
        props.put(name + "_ROMAN", this.getRoman(v).toUpperCase());
        props.put(name + "_roman", this.getRoman(v).toLowerCase());
    }

    private List<ViewManager> getViewManagers(Element node) {
        List<ViewManager> viewManagers = this.getVMManager().getViewManagers();
        if (node == null || !XmlUtil.hasAttribute(node, "view")) {
            return viewManagers;
        }
        ArrayList<ViewManager> goodOnes = new ArrayList<ViewManager>();
        String viewId = this.applyMacros(node, "view");
        if (viewId.startsWith("name:")) {
            viewId = viewId.substring(5);
        }
        for (int i = 0; i < viewManagers.size(); ++i) {
            ViewManager viewManager = viewManagers.get(i);
            if (viewId.startsWith("#")) {
                int viewIndex = new Integer(viewId.substring(1));
                if (viewIndex != i) continue;
                goodOnes.add(viewManager);
                continue;
            }
            if (viewId.startsWith("class:")) {
                if (!StringUtil.stringMatch(viewManager.getClass().getName(), viewId.substring(6), true, true)) continue;
                goodOnes.add(viewManager);
                continue;
            }
            String name = viewManager.getName();
            if (name == null) {
                name = "";
            }
            if (!StringUtil.stringMatch(name, viewId, true, true)) continue;
            goodOnes.add(viewManager);
        }
        if (goodOnes.size() == 0) {
            this.warning("Unable to find any views with id:" + viewId);
        }
        return goodOnes;
    }

    public void pause() {
        this.getIdv().waitUntilDisplaysAreDone();
    }

    public void setDebug(boolean v) {
        this.debug = v;
    }

    public boolean evaluateIsl(String isl) throws Throwable {
        isl = XmlUtil.tag(TAG_GROUP, "", isl);
        return this.processNode(XmlUtil.getRoot(isl));
    }

    public void loadBundle(String bundleFile, List setFiles) throws Throwable {
        this.loadBundle(bundleFile, setFiles, -1, -1, "", true);
    }

    public void loadBundle(String bundleFile, List setFiles, int width, int height) throws Throwable {
        this.loadBundle(bundleFile, setFiles, width, height, "", true);
    }

    public void loadBundle(String bundleFile, List setFiles, int width, int height, String times, boolean clear) throws Throwable {
        StringBuffer extra = new StringBuffer();
        if (setFiles != null) {
            for (int i = 0; i < setFiles.size(); i += 2) {
                String datasource = (String)setFiles.get(i);
                String files = (String)setFiles.get(i + 1);
                if (datasource != null && files != null) {
                    extra.append(XmlUtil.tag(TAG_SETFILES, XmlUtil.attrs("datasource", datasource, "file", files)));
                }
                extra.append("\n");
            }
        }
        StringBuffer attrs = new StringBuffer();
        attrs.append(" ");
        attrs.append("file=" + ImageGenerator.quote(bundleFile));
        attrs.append(" ");
        if (width > 0 && height > 0) {
            attrs.append(" ");
            attrs.append("width=" + ImageGenerator.quote("" + width));
            attrs.append(" ");
            attrs.append("height=" + ImageGenerator.quote("" + height));
            attrs.append(" ");
        }
        if (times != null && !times.isEmpty()) {
            attrs.append(" ");
            attrs.append("times=" + ImageGenerator.quote("" + times));
        }
        if (!clear) {
            attrs.append(" ");
            attrs.append("clear=" + ImageGenerator.quote("false"));
        }
        String xml = "<bundle " + attrs + ">" + extra + "</bundle>";
        System.err.println(xml);
        this.processTagBundle(this.makeElement(xml));
    }

    public void writeImageToFile(Image image, String file) throws Exception {
        ImageUtils.writeImageToFile(image, this.applyMacros(this.getImageFileName(file)));
    }

    protected static String makeXmlFromString(String s) {
        if (s == null || s.length() == 0) {
            return "";
        }
        StringTokenizer st = new StringTokenizer(s, ";");
        StringBuffer sb = new StringBuffer();
        while (st.hasMoreTokens()) {
            String so = st.nextToken();
            StringTokenizer sot = new StringTokenizer(so, "=");
            int k = sot.countTokens();
            for (int i = 0; i < k; ++i) {
                StringTokenizer sbt = new StringTokenizer(sot.nextToken().trim(), " ");
                if (i == 0) {
                    sb.append("<" + sbt.nextToken().trim());
                }
                boolean gotone = false;
                for (int n = sbt.countTokens(); n > 1; --n) {
                    if (gotone) {
                        sb.append(" ");
                    }
                    sb.append(sbt.nextToken().trim());
                    gotone = true;
                }
                if (!sbt.hasMoreTokens()) continue;
                if (i != k - 1) {
                    if (gotone) {
                        sb.append("\" " + sbt.nextToken().trim() + "=\"");
                        continue;
                    }
                    sb.append(" " + sbt.nextToken().trim() + "=\"");
                    continue;
                }
                if (gotone) {
                    sb.append(" " + sbt.nextToken().trim() + "\"");
                    continue;
                }
                sb.append(sbt.nextToken().trim() + "\"");
            }
            sb.append(" />");
        }
        return sb.toString();
    }

    private static String quote(String s) {
        return "\"" + s + "\"";
    }

    public void writeImage(String filename, String params, float qual) throws Exception, Throwable {
        String isl = ImageGenerator.makeXmlFromString(params);
        String xml = XmlUtil.getHeader() + "\n<image file=\"" + filename + "\" quality=\"" + qual + "\">" + isl + "</image>";
        this.captureImage(this.applyMacros(filename), this.makeElement(xml));
    }

    public Image getImage() throws Exception {
        int i = 0;
        List<ViewManager> viewManagers = this.getVMManager().getViewManagers();
        if (i < viewManagers.size()) {
            IdvWindow window;
            ViewManager viewManager = viewManagers.get(i);
            if (!this.getIdv().getArgsManager().getIsOffScreen() && (window = viewManager.getDisplayWindow()) != null) {
                window.setLocation(50, 50);
                viewManager.toFront();
            }
            return viewManager.getMaster().getImage(false);
        }
        return null;
    }

    private void captureImage(String filename, Element scriptingNode) throws Throwable {
        Hashtable imageProperties = new Hashtable();
        if (scriptingNode != null && XmlUtil.hasAttribute(scriptingNode, "test")) {
            BufferedImage tmpImage = new BufferedImage(this.applyMacros(scriptingNode, ATTR_WIDTH, 300), this.applyMacros(scriptingNode, ATTR_HEIGHT, 300), 1);
            String loopFilename = this.applyMacros(filename);
            this.lastImage = this.processImage(tmpImage, loopFilename, scriptingNode, this.getAllProperties(), null, imageProperties);
            return;
        }
        List viewManagers = null;
        if (scriptingNode != null && XmlUtil.hasAttribute(scriptingNode, "display")) {
            DisplayControlImpl display = this.findDisplayControl(scriptingNode);
            if (display == null) {
                throw new IllegalArgumentException("Could not find display:" + XmlUtil.toString(scriptingNode));
            }
            String loopFilename = this.applyMacros(filename);
            String what = this.applyMacros(scriptingNode, ATTR_WHAT, (String)null);
            ViewManager viewManager = display.getViewManagerForCapture(what);
            if (viewManager != null) {
                viewManager.updateDisplayIfNeeded();
                viewManagers = Misc.newList(viewManager);
            } else {
                this.lastImage = display.getImage(what);
                this.lastImage = this.processImage((BufferedImage)this.lastImage, loopFilename, scriptingNode, this.getAllProperties(), null, imageProperties);
                return;
            }
        }
        if (viewManagers == null) {
            viewManagers = this.getViewManagers(scriptingNode);
        }
        if (viewManagers.size() == 0) {
            this.debug("No views to capture");
        }
        this.pushProperties();
        String animationIdx = XmlUtil.getAttribute((Node)scriptingNode, ATTR_ANIMATION_INDEX, "-1");
        List indices = null;
        indices = animationIdx.startsWith("$") ? StringUtil.parseIntegerListString(this.applyMacros(animationIdx)) : StringUtil.parseIntegerListString(animationIdx);
        int idx = 0;
        for (int j = 0; j < indices.size(); ++j) {
            VectorGraphicsRenderer vectorRenderer;
            ArrayList<Image> images = new ArrayList<Image>();
            String fname = indices.size() > 1 ? this.fixFileName(filename, (Integer)indices.get(j)) : filename;
            int timeIndex = (Integer)indices.get(j);
            for (int i = 0; i < viewManagers.size(); ++i) {
                IdvWindow window;
                ViewManager viewManager = (ViewManager)viewManagers.get(i);
                if (timeIndex >= 0 && viewManager.getAnimation() != null) {
                    viewManager.getAnimation().setCurrent(timeIndex);
                }
                this.putIndex(this.getProperties(), PROP_VIEWINDEX, idx);
                String name = viewManager.getName();
                if (name == null) {
                    name = "view" + idx;
                }
                this.getProperties().put(PROP_VIEWNAME, name);
                if (!this.getIdv().getArgsManager().getIsOffScreen() && (window = viewManager.getDisplayWindow()) != null) {
                    window.setLocation(50, 50);
                    viewManager.toFront();
                }
                String loopFilename = this.applyMacros(fname);
                if (scriptingNode == null) {
                    File imageFile = null;
                    if (loopFilename != null) {
                        imageFile = new File(this.getImageFileName(loopFilename));
                    }
                    viewManager.writeImage(imageFile, true, false);
                } else if (loopFilename != null && ViewManager.isVectorGraphicsFile(loopFilename)) {
                    vectorRenderer = new VectorGraphicsRenderer(viewManager);
                    vectorRenderer.renderTo(loopFilename);
                } else {
                    if (viewManager instanceof CrossSectionViewManager) {
                        this.getIdv().getIdvUIManager();
                        IdvUIManager.waitUntilDisplaysAreDone(this.getIdv().getIdvUIManager(), 1000L);
                    } else {
                        this.getIdv().getIdvUIManager();
                        IdvUIManager.waitUntilDisplaysAreDone(this.getIdv().getIdvUIManager(), 100L);
                    }
                    this.lastImage = viewManager.captureIslImage(scriptingNode);
                    imageProperties = new Hashtable();
                    this.lastImage = this.processImage((BufferedImage)this.lastImage, loopFilename, scriptingNode, this.getAllProperties(), viewManager, imageProperties);
                }
                images.add(this.lastImage);
                ++idx;
            }
            boolean combine = XmlUtil.getAttribute((Node)scriptingNode, ATTR_COMBINE, false);
            if (!combine) continue;
            String combineFilename = this.applyMacros(filename);
            LinkedList<JComponent> components = new LinkedList<JComponent>();
            for (ViewManager vm : viewManagers) {
                components.add(vm.getComponent());
            }
            int cols = 2;
            cols = !this.getIdv().getArgsManager().getIsOffScreen() ? ImageUtils.getColumnCountFromComps(components) : XmlUtil.getAttribute((Node)scriptingNode, ATTR_COLUMNS, cols);
            if (ViewManager.isVectorGraphicsFile(combineFilename)) {
                vectorRenderer = new VectorGraphicsRenderer(viewManagers, cols);
                vectorRenderer.renderTo(combineFilename);
                continue;
            }
            Image i = ImageUtils.gridImages2(images, 0, Color.GRAY, cols);
            ImageUtils.writeImageToFile(i, combineFilename);
        }
        this.popProperties();
    }

    private String fixFileName(String filename, Integer integer) {
        String[] tokens = filename.split("\\.(?=[^\\.]+$)");
        return tokens[0] + integer + "." + tokens[1];
    }

    protected Image resize(Image image, Element node) {
        int imageWidth = image.getWidth(null);
        int imageHeight = image.getHeight(null);
        int width = -1;
        int height = -1;
        if (XmlUtil.hasAttribute(node, ATTR_WIDTH)) {
            width = (int)this.toDouble(node, ATTR_WIDTH, imageWidth);
        }
        if (XmlUtil.hasAttribute(node, ATTR_HEIGHT)) {
            height = (int)this.toDouble(node, ATTR_HEIGHT, imageWidth);
        }
        if (width == -1 && height == -1) {
            return image;
        }
        return image.getScaledInstance(width, height, 16);
    }

    public BufferedImage resizeImage(BufferedImage image, String widthStr, String heightStr) {
        int imageWidth = image.getWidth(null);
        int imageHeight = image.getHeight(null);
        int width = -1;
        int height = -1;
        if (!widthStr.equals("-1")) {
            width = (int)this.toDouble(widthStr, imageWidth);
        }
        if (!heightStr.equals("-1")) {
            height = (int)this.toDouble(heightStr, imageHeight);
        }
        if (width == -1 && height == -1) {
            return image;
        }
        BufferedImage resizedImage = ImageUtils.toBufferedImage(image.getScaledInstance(width, height, 16), 1);
        return resizedImage;
    }

    public BufferedImage matteImage(BufferedImage image, String bgString, int top, int left, int bottom, int right) {
        Color bg = GuiUtils.decodeColor(bgString, null);
        return ImageUtils.matte(image, top, bottom, left, right, bg);
    }

    protected BufferedImage processImage(BufferedImage image, String filename, Element node, Hashtable props, ViewManager viewManager, Hashtable imageProps) throws Throwable {
        if (node == null) {
            return image;
        }
        if (props == null) {
            props = new Hashtable<String, Object>();
        }
        if (viewManager != null) {
            Animation animation = viewManager.getAnimation();
            props.put(PROP_ANIMATIONTIME, "");
            if (animation != null && animation.getAniValue() != null) {
                props.put(PROP_ANIMATIONTIME, animation.getAniValue());
            }
        }
        this.getProperties().putAll(props);
        NodeList elements = XmlUtil.getElements(node);
        Hashtable<Object[], Object[]> seenColorTable = new Hashtable<Object[], Object[]>();
        block40: for (int childIdx = 0; childIdx < elements.getLength(); ++childIdx) {
            String tagName;
            boolean shouldIterateChildren = true;
            BufferedImage newImage = null;
            int imageWidth = image.getWidth(null);
            int imageHeight = image.getHeight(null);
            Element child = (Element)elements.item(childIdx);
            switch (tagName = child.getTagName()) {
                case "resize": {
                    newImage = ImageUtils.toBufferedImage(this.resize(image, child));
                    break;
                }
                case "fileset": {
                    break;
                }
                case "output": {
                    this.processTagOutput(child);
                    break;
                }
                case "displaylist": {
                    if (viewManager == null) break;
                    newImage = ImageUtils.toBufferedImage((Image)image, true);
                    Graphics g = newImage.getGraphics();
                    String valign = this.applyMacros(child, ATTR_VALIGN, "bottom");
                    Font font = this.getFont(child);
                    if (XmlUtil.hasAttribute(child, ATTR_MATTEBG)) {
                        int height = viewManager.paintDisplayList((Graphics2D)g, null, imageWidth, imageHeight, valign.equals("bottom"), null, font);
                        int top = valign.equals("top") ? height : 0;
                        int bottom = valign.equals("bottom") ? height : 0;
                        newImage = ImageUtils.matte(image, top, bottom, 0, 0, this.applyMacros(child, ATTR_MATTEBG, Color.white));
                        g = newImage.getGraphics();
                        imageHeight += height;
                    }
                    Color c = this.applyMacros(child, ATTR_COLOR, (Color)null);
                    viewManager.paintDisplayList((Graphics2D)g, null, imageWidth, imageHeight, valign.equals("bottom"), c, font);
                    break;
                }
                case "colorbar": 
                case "kmlcolorbar": {
                    int i;
                    List controls;
                    Integer index = (Integer)props.get(PROP_IMAGEINDEX);
                    if (index != null && index > 0 && tagName.equals(TAG_KML_COLORBAR)) continue block40;
                    boolean showLines = this.applyMacros(child, ATTR_SHOWLINES, false);
                    List list = controls = viewManager != null ? viewManager.getControls() : new ArrayList();
                    if (XmlUtil.hasAttribute(child, "display")) {
                        DisplayControlImpl display;
                        DisplayControlImpl displayControlImpl = display = controls.size() > 0 ? this.findDisplayControl(XmlUtil.getAttribute(child, "display"), controls) : this.findDisplayControl(child);
                        if (display == null) {
                            this.error("Could not find display:" + XmlUtil.toString(node));
                            return null;
                        }
                        controls = Misc.newList(display);
                    }
                    int width = this.applyMacros(child, ATTR_WIDTH, 150);
                    int height = this.applyMacros(child, ATTR_HEIGHT, 20);
                    int ticks = this.applyMacros(child, ATTR_TICKMARKS, 0);
                    double interval = this.applyMacros(child, ATTR_INTERVAL, -1.0);
                    String valuesStr = this.applyMacros(child, ATTR_VALUES, (String)null);
                    Color c = this.applyMacros(child, ATTR_COLOR, Color.black);
                    Color lineColor = this.applyMacros(child, ATTR_LINECOLOR, c);
                    Rectangle imageRect = new Rectangle(0, 0, imageWidth, imageHeight);
                    Point pp = ImageUtils.parsePoint(this.applyMacros(child, ATTR_PLACE, "ll,10,-10"), imageRect);
                    Point ap = ImageUtils.parsePoint(this.applyMacros(child, ATTR_ANCHOR, "ll"), new Rectangle(0, 0, width, height));
                    String orientation = this.applyMacros(child, ATTR_ORIENTATION, "bottom");
                    boolean vertical = orientation.equals("right") || orientation.equals("left");
                    int baseY = pp.y - ap.y + (vertical ? 0 : height);
                    int baseX = pp.x - ap.x;
                    ArrayList<ColorTable> colorTables = new ArrayList<ColorTable>();
                    ArrayList<Range> ranges = new ArrayList<Range>();
                    ArrayList<Unit> units = new ArrayList<Unit>();
                    boolean forKml = tagName.equals(TAG_KML_COLORBAR);
                    for (i = 0; i < controls.size(); ++i) {
                        Range range;
                        Object[] key;
                        DisplayControlImpl control = (DisplayControlImpl)controls.get(i);
                        ColorTable colorTable = control.getColorTable();
                        if (colorTable == null || seenColorTable.get(key = new Object[]{colorTable, range = control.getRangeForColorTable()}) != null) continue;
                        seenColorTable.put(key, key);
                        colorTables.add(colorTable);
                        ranges.add(range);
                        units.add(control.getDisplayUnit());
                    }
                    for (i = 0; i < colorTables.size(); ++i) {
                        BufferedImage imageToDrawIn;
                        ColorTable colorTable = (ColorTable)colorTables.get(i);
                        Range range = (Range)ranges.get(i);
                        Unit unit = (Unit)units.get(i);
                        if (forKml) {
                            if (vertical) {
                                baseX = 0;
                                baseY = 0;
                            } else {
                                baseX = 0;
                                baseY = height;
                            }
                            int space = this.applyMacros(child, ATTR_SPACE, vertical ? width : height);
                            imageToDrawIn = new BufferedImage(width + (vertical ? space : 0), height + (vertical ? 0 : space), 1);
                        } else {
                            imageToDrawIn = newImage = ImageUtils.toBufferedImage(image);
                        }
                        Graphics g = ((Image)imageToDrawIn).getGraphics();
                        if (forKml) {
                            Color bgColor = this.applyMacros(child, ATTR_BACKGROUND, Color.white);
                            g.setColor(bgColor);
                            g.fillRect(0, 0, ((Image)imageToDrawIn).getWidth(null), ((Image)imageToDrawIn).getHeight(null));
                        }
                        ColorPreview preview = new ColorPreview(new BaseRGBMap(colorTable.getNonAlphaTable()), vertical ? width : height);
                        if (vertical) {
                            preview.setSize(new Dimension(height, width));
                        } else {
                            preview.setSize(new Dimension(width, height));
                        }
                        Image previewImage = GuiUtils.getImage(preview);
                        boolean includeAlpha = this.applyMacros(child, ATTR_TRANSPARENCY, true);
                        previewImage = ColorTableCanvas.getImage(colorTable, vertical ? height : width, vertical ? width : height, includeAlpha);
                        if (vertical) {
                            BufferedImage tmpImage = new BufferedImage(width, height, 1);
                            BufferedImage tmpImagexxx = new BufferedImage(500, 500, 1);
                            Graphics2D tmpG = (Graphics2D)tmpImage.getGraphics();
                            tmpG.setColor(Color.red);
                            tmpG.fillRect(0, 0, 1000, 1000);
                            tmpG.rotate(Math.toRadians(90.0));
                            tmpG.drawImage(previewImage, 0, 0 - width, null);
                            previewImage = tmpImage;
                        }
                        if (forKml) {
                            g.drawImage(previewImage, 0, 0, null);
                        } else {
                            g.drawImage(previewImage, baseX, vertical ? baseY : baseY - height, null);
                        }
                        if (showLines) {
                            g.setColor(lineColor);
                            g.drawRect(baseX, vertical ? baseY : baseY - height, width - 1, height - (vertical ? 1 : 0));
                        }
                        this.setFont(g, child);
                        FontMetrics fm = g.getFontMetrics();
                        ArrayList<Double> values = new ArrayList<Double>();
                        String suffixFrequency = XmlUtil.getAttribute((Node)child, ATTR_SUFFIXFREQUENCY, XmlUtil.getAttribute((Node)child, ATTR_SHOWUNIT, "false")).toLowerCase();
                        String unitDefault = !suffixFrequency.equals("false") ? " %unit%" : "";
                        String labelSuffix = this.applyMacros(child, ATTR_SUFFIX, unitDefault);
                        labelSuffix = unit != null ? labelSuffix.replace("%unit%", "" + unit) : labelSuffix.replace("%unit%", "");
                        if (valuesStr != null) {
                            double[] valueArray = Misc.parseDoubles(valuesStr, ",");
                            for (int valueIdx = 0; valueIdx < valueArray.length; ++valueIdx) {
                                values.add(new Double(valueArray[valueIdx]));
                            }
                        } else if (ticks > 0) {
                            int spacing = ticks == 1 ? 0 : (vertical ? height : width) / (ticks - 1);
                            for (int tickIdx = 0; tickIdx < ticks; ++tickIdx) {
                                double percent = ticks > 1 ? (double)tickIdx / (double)(ticks - 1) : 0.0;
                                values.add(new Double(range.getValueOfPercent(percent)));
                            }
                        } else if (interval > 0.0) {
                            double max = range.getMax();
                            for (double value = range.getMin(); value <= max; value += interval) {
                                values.add(new Double(value));
                            }
                        }
                        for (int valueIdx = 0; valueIdx < values.size(); ++valueIdx) {
                            int xLoc;
                            int y;
                            int x;
                            double value = (Double)values.get(valueIdx);
                            if (vertical) {
                                x = orientation.equals("right") ? baseX + width : baseX;
                                y = baseY + (int)(range.getPercent(value) * (double)height);
                                if (y > baseY + height) {
                                    break;
                                }
                            } else {
                                y = orientation.equals("bottom") ? baseY : baseY - height;
                                x = range != null ? baseX + (int)(range.getPercent(value) * (double)width) : baseX;
                                if (x > baseX + width) break;
                            }
                            String tickLabel = this.getIdv().getDisplayConventions().format(value);
                            if (suffixFrequency.equals("last") && valueIdx == values.size() - 1) {
                                tickLabel = tickLabel + labelSuffix;
                            } else if (suffixFrequency.equals("first") && valueIdx == 0) {
                                tickLabel = tickLabel + labelSuffix;
                            } else if (suffixFrequency.equals(VALUE_ALL) || suffixFrequency.equals("true")) {
                                tickLabel = tickLabel + labelSuffix;
                            }
                            Rectangle2D rect = fm.getStringBounds(tickLabel, g);
                            g.setColor(lineColor);
                            if (orientation.equals("right")) {
                                g.drawLine(x + 1, y, x, y);
                                if (showLines) {
                                    g.drawLine(x, y, x - width, y);
                                }
                            } else if (orientation.equals("left")) {
                                g.drawLine(x - 1, y, x, y);
                                if (showLines) {
                                    g.drawLine(x, y, x + width, y);
                                }
                            } else if (orientation.equals("bottom")) {
                                g.drawLine(x, y + 1, x, y);
                                if (showLines) {
                                    g.drawLine(x, y, x, y - height);
                                }
                            } else {
                                g.drawLine(x, y - 1, x, y);
                                if (showLines) {
                                    g.drawLine(x, y, x, y + height);
                                }
                            }
                            g.setColor(c);
                            if (orientation.equals("right")) {
                                int yLoc = y + (int)(rect.getHeight() / 2.0) - 2;
                                if (forKml) {
                                    if (valueIdx == 0) {
                                        yLoc = y + (int)rect.getHeight() - 2;
                                    } else if (valueIdx == values.size() - 1) {
                                        yLoc = y - (int)rect.getHeight() + 6;
                                    }
                                }
                                g.drawString(tickLabel, x + 2, yLoc);
                                continue;
                            }
                            if (orientation.equals("left")) {
                                xLoc = x - 2 - (int)rect.getWidth();
                                g.drawString(tickLabel, xLoc, y + (int)(rect.getHeight() / 2.0) - 2);
                                continue;
                            }
                            if (orientation.equals("bottom")) {
                                xLoc = x - (int)(rect.getWidth() / 2.0);
                                if (forKml) {
                                    if (valueIdx == 0) {
                                        xLoc = x + 2;
                                    } else if (valueIdx == values.size() - 1) {
                                        xLoc = x - (int)rect.getWidth() + 2;
                                    }
                                }
                                g.drawString(tickLabel, xLoc, y + (int)rect.getHeight() + 2);
                                continue;
                            }
                            g.drawString(tickLabel, x - (int)(rect.getWidth() / 2.0), y - 2);
                        }
                        if (vertical) {
                            baseX += width + 30;
                        } else {
                            baseY += height + 30;
                        }
                        if (!forKml) continue;
                        String tmpImageFile = this.applyMacros(child, "file", this.getIdv().getStore().getTmpFile("testcolorbar${viewindex}.png"));
                        String template = "<ScreenOverlay><name>${kml.name}</name><Icon><href>${icon}</href></Icon>\n<overlayXY x=\"${kml.overlayXY.x}\" y=\"${kml.overlayXY.y}\" xunits=\"${kml.overlayXY.xunits}\" yunits=\"${kml.overlayXY.yunits}\"/>\n<screenXY x=\"${kml.screenXY.x}\" y=\"${kml.screenXY.y}\" xunits=\"${kml.screenXY.xunits}\" yunits=\"${kml.screenXY.yunits}\"/>\n<size x=\"${kml.size.x}\" y=\"${kml.size.y}\" xunits=\"${kml.size.xunits}\" yunits=\"${kml.size.yunits}\"/>\n</ScreenOverlay>\n";
                        String[] macros = new String[]{"kml.name", "kml.overlayXY.x", "kml.overlayXY.y", "kml.overlayXY.xunits", "kml.overlayXY.yunits", "kml.screenXY.x", "kml.screenXY.y", "kml.screenXY.xunits", "kml.screenXY.yunits", "kml.size.x", "kml.size.y", "kml.size.xunits", "kml.size.yunits"};
                        String[] macroValues = new String[]{"", "0", "1", "fraction", "fraction", "0", "1", "fraction", "fraction", "-1", "-1", "pixels", "pixels"};
                        for (int macroIdx = 0; macroIdx < macros.length; ++macroIdx) {
                            template = template.replace("${" + macros[macroIdx] + "}", this.applyMacros(child, macros[macroIdx], macroValues[macroIdx]));
                        }
                        template = template.replace("${icon}", IOUtil.getFileTail(tmpImageFile));
                        imageProps.put(TAG_KML, template);
                        ArrayList<String> kmlFiles = (ArrayList<String>)imageProps.get("kmlfiles");
                        if (kmlFiles == null) {
                            kmlFiles = new ArrayList<String>();
                            imageProps.put("kmlfiles", kmlFiles);
                        }
                        kmlFiles.add(tmpImageFile);
                        ImageUtils.writeImageToFile((Image)imageToDrawIn, tmpImageFile);
                    }
                    break;
                }
                case "transparent": 
                case "backgroundtransparent": {
                    Color c = null;
                    c = tagName.equals(TAG_BGTRANSPARENT) ? viewManager.getBackground() : this.applyMacros(child, ATTR_COLOR, (Color)null);
                    int[] redRange = new int[]{0, 0};
                    int[] greenRange = new int[]{0, 0};
                    int[] blueRange = new int[]{0, 0};
                    if (c != null) {
                        redRange[0] = redRange[1] = c.getRed();
                        greenRange[0] = greenRange[1] = c.getGreen();
                        blueRange[0] = blueRange[1] = c.getBlue();
                    }
                    newImage = ImageUtils.makeColorTransparent(image, redRange, greenRange, blueRange);
                    break;
                }
                case "show": {
                    JComponent contents = new JLabel(new ImageIcon(image));
                    String message = this.applyMacros(child, ATTR_MESSAGE, (String)null);
                    if (message != null) {
                        contents = GuiUtils.topCenter(new JLabel(message), contents);
                    }
                    if (GuiUtils.askOkCancel("Continue?", contents)) break;
                    throw new MyQuitException();
                }
                case "matte": {
                    newImage = this.doMatte(image, child, 0);
                    break;
                }
                case "latlonlabels": {
                    newImage = this.doLatLonLabels(child, viewManager, image, imageProps);
                    break;
                }
                case "write": {
                    ImageUtils.writeImageToFile((Image)image, this.getImageFileName(this.applyMacros(child, "file")));
                    break;
                }
                case "publish": {
                    this.getIdv().getPublishManager().publishIslImage(this, node, image);
                    break;
                }
                case "clip": {
                    int[] lr;
                    int[] ul;
                    if (XmlUtil.hasAttribute(child, "display")) {
                        DisplayControlImpl dc = this.findDisplayControl(child);
                        if (dc == null) {
                            throw new IllegalArgumentException("Could not find display:" + XmlUtil.toString(node));
                        }
                        NavigatedDisplay display = (NavigatedDisplay)viewManager.getMaster();
                        MapProjection mapProjection = dc.getDataProjection();
                        Rectangle2D rect = mapProjection.getDefaultMapArea();
                        LatLonPoint llplr = mapProjection.getLatLon(new double[][]{{rect.getX() + rect.getWidth()}, {rect.getY() + rect.getHeight()}});
                        LatLonPoint llpul = mapProjection.getLatLon(new double[][]{{rect.getX()}, {rect.getY()}});
                        EarthLocationTuple ulEl = new EarthLocationTuple(llpul, new Real(RealType.Altitude, 0.0));
                        EarthLocationTuple lrEl = new EarthLocationTuple(llplr, new Real(RealType.Altitude, 0.0));
                        ul = display.getScreenCoordinates(display.getSpatialCoordinates(ulEl, null));
                        if (ul[0] > (lr = display.getScreenCoordinates(display.getSpatialCoordinates(lrEl, null)))[0]) {
                            int tmp = ul[0];
                            ul[0] = lr[0];
                            lr[0] = tmp;
                        }
                        if (ul[1] > lr[1]) {
                            int tmp = ul[1];
                            ul[1] = lr[1];
                            lr[1] = tmp;
                        }
                        imageProps.put(ATTR_NORTH, new Double(ulEl.getLatitude().getValue()));
                        imageProps.put(ATTR_WEST, new Double(ulEl.getLongitude().getValue()));
                        imageProps.put(ATTR_SOUTH, new Double(lrEl.getLatitude().getValue()));
                        imageProps.put(ATTR_EAST, new Double(lrEl.getLongitude().getValue()));
                    } else if (viewManager != null && XmlUtil.hasAttribute(child, ATTR_NORTH)) {
                        NavigatedDisplay display = (NavigatedDisplay)viewManager.getMaster();
                        EarthLocation el1 = DisplayControlImpl.makeEarthLocation(this.toDouble(child, ATTR_NORTH), this.toDouble(child, ATTR_WEST), 0.0);
                        EarthLocation el2 = DisplayControlImpl.makeEarthLocation(this.toDouble(child, ATTR_SOUTH), this.toDouble(child, ATTR_EAST), 0.0);
                        ul = display.getScreenCoordinates(display.getSpatialCoordinates(el1, null));
                        lr = display.getScreenCoordinates(display.getSpatialCoordinates(el2, null));
                        imageProps.put(ATTR_NORTH, new Double(el1.getLatitude().getValue()));
                        imageProps.put(ATTR_WEST, new Double(el1.getLongitude().getValue()));
                        imageProps.put(ATTR_SOUTH, new Double(el2.getLatitude().getValue()));
                        imageProps.put(ATTR_EAST, new Double(el2.getLongitude().getValue()));
                    } else if (XmlUtil.hasAttribute(child, "left")) {
                        ul = new int[]{(int)this.toDouble(child, "left", imageWidth), (int)this.toDouble(child, "top", imageHeight)};
                        lr = new int[]{(int)this.toDouble(child, "right", imageWidth), (int)this.toDouble(child, "bottom", imageHeight)};
                    } else {
                        if (viewManager == null) continue block40;
                        NavigatedDisplay display = (NavigatedDisplay)viewManager.getMaster();
                        ul = display.getScreenCoordinates(new double[]{-1.0, 1.0, 0.0});
                        lr = display.getScreenCoordinates(new double[]{1.0, -1.0, 0.0});
                        int space = this.applyMacros(child, ATTR_SPACE, 0);
                        int hspace = this.applyMacros(child, ATTR_HSPACE, space);
                        int vspace = this.applyMacros(child, ATTR_VSPACE, space);
                        ul[0] = ul[0] - this.applyMacros(child, ATTR_SPACE_LEFT, hspace);
                        ul[1] = ul[1] - this.applyMacros(child, ATTR_SPACE_TOP, vspace);
                        lr[0] = lr[0] + this.applyMacros(child, ATTR_SPACE_RIGHT, hspace);
                        lr[1] = lr[1] + this.applyMacros(child, ATTR_SPACE_BOTTOM, vspace);
                    }
                    for (String attr : Misc.newList(ATTR_NORTH, ATTR_SOUTH, ATTR_EAST, ATTR_WEST)) {
                        String kmlAttr = "kml." + attr;
                        if (!XmlUtil.hasAttribute(child, kmlAttr)) continue;
                        imageProps.put(attr, new Double(this.applyMacros(child, kmlAttr, 0.0)));
                    }
                    ul[0] = Math.max(0, ul[0]);
                    ul[1] = Math.max(0, ul[1]);
                    lr[0] = Math.min(lr[0], imageWidth);
                    lr[1] = Math.min(lr[1], imageHeight);
                    newImage = ImageUtils.clip(image, ul, lr);
                    break;
                }
                case "split": {
                    shouldIterateChildren = false;
                    int width = image.getWidth(null);
                    int height = image.getHeight(null);
                    int cols = this.applyMacros(child, ATTR_COLUMNS, 2);
                    int rows = this.applyMacros(child, ATTR_ROWS, 2);
                    String file = this.applyMacros(child, "file");
                    int cnt = 0;
                    int hSpace = width / cols;
                    int vSpace = height / rows;
                    for (int row = 0; row < rows; ++row) {
                        for (int col = 0; col < cols; ++col) {
                            this.pushProperties();
                            Hashtable myprops = new Hashtable();
                            this.putProperty("row", new Integer(row));
                            this.putProperty("column", new Integer(col));
                            this.putProperty(ATTR_COUNT, new Integer(++cnt));
                            String realFile = this.applyMacros(file, myprops);
                            BufferedImage splitImage = image.getSubimage(hSpace * col, vSpace * row, hSpace, vSpace);
                            this.processImage(ImageUtils.toBufferedImage(splitImage), realFile, child, myprops, viewManager, new Hashtable());
                            this.popProperties();
                        }
                    }
                    break;
                }
                case "thumbnail": {
                    shouldIterateChildren = false;
                    BufferedImage thumbImage = ImageUtils.toBufferedImage(this.resize(image, child));
                    String thumbFile = this.applyMacros(child, "file", (String)null);
                    if (thumbFile == null) {
                        thumbFile = IOUtil.stripExtension(filename) + "_thumb" + IOUtil.getFileExtension(filename);
                    }
                    this.processImage(thumbImage, thumbFile, child, null, viewManager, new Hashtable());
                    break;
                }
                case "kml": {
                    break;
                }
                case "kmzfile": {
                    break;
                }
                case "overlay": {
                    Image overlay;
                    double transparency = this.applyMacros(child, ATTR_TRANSPARENCY, 0.0);
                    Graphics2D g = (Graphics2D)image.getGraphics();
                    String imagePath = this.applyMacros(child, "image", (String)null);
                    Rectangle imageRect = new Rectangle(0, 0, imageWidth, imageHeight);
                    Point pp = ImageUtils.parsePoint(this.applyMacros(child, ATTR_PLACE, "lr,-10,-10"), imageRect);
                    String text = this.applyMacros(child, ATTR_TEXT, (String)null);
                    Color bg = this.applyMacros(child, ATTR_BACKGROUND, (Color)null);
                    if (text != null) {
                        double angle = Math.toRadians(this.applyMacros(child, ATTR_ANGLE, 0.0));
                        text = this.applyMacros(text);
                        Color c = this.applyMacros(child, ATTR_COLOR, Color.white);
                        if (c != null && transparency > 0.0) {
                            c = new Color(c.getRed(), c.getGreen(), c.getBlue(), ImageUtils.toAlpha(transparency));
                        }
                        if (bg != null && transparency > 0.0) {
                            bg = new Color(bg.getRed(), bg.getGreen(), bg.getBlue(), ImageUtils.toAlpha(transparency));
                        }
                        this.setFont(g, child);
                        FontMetrics fm = g.getFontMetrics();
                        Rectangle2D rect = fm.getStringBounds(text, g);
                        int width = (int)rect.getWidth();
                        int height = (int)rect.getHeight();
                        Point ap = ImageUtils.parsePoint(this.applyMacros(child, ATTR_ANCHOR, "lr,-10,-10"), new Rectangle(0, 0, width, height));
                        g.rotate(angle);
                        if (bg != null) {
                            g.setColor(bg);
                            g.fillRect(pp.x - ap.x - 1, pp.y - ap.y - 1, width + 2, height + 2);
                        }
                        g.setColor(c);
                        g.drawString(text, pp.x - ap.x, pp.y - ap.y + height);
                    }
                    if (imagePath == null || (overlay = ImageUtils.readImage(imagePath)) == null) break;
                    if (transparency > 0.0) {
                        overlay = ImageUtils.setAlpha(overlay, transparency);
                    }
                    int width = overlay.getWidth(null);
                    int height = overlay.getHeight(null);
                    Point ap = ImageUtils.parsePoint(this.applyMacros(child, ATTR_ANCHOR, "lr,-10,-10"), new Rectangle(0, 0, width, height));
                    g.drawImage(overlay, pp.x - ap.x, pp.y - ap.y, bg, null);
                    break;
                }
                default: {
                    this.error("Unknown tag:" + tagName);
                }
            }
            if (newImage == null) continue;
            String newFileName = this.applyMacros(child, "file", (String)null);
            if (shouldIterateChildren) {
                newImage = this.processImage(newImage, newFileName, child, null, viewManager, new Hashtable());
            }
            if (newFileName != null) {
                ImageUtils.writeImageToFile((Image)newImage, this.getImageFileName(newFileName));
                this.debug("Writing image:" + newFileName);
            }
            if (this.applyMacros(child, ATTR_COPY, false)) continue;
            image = newImage;
        }
        if (filename != null) {
            float quality = (float)this.applyMacros(node, ATTR_QUALITY, 1.0);
            List<String> fileToks = StringUtil.split(filename, ",", true, true);
            for (String file : fileToks) {
                file = this.getImageFileName(file);
                this.debug("Writing image:" + file);
                if (file.endsWith(".kmz")) {
                    GeoLocationInfo bounds = null;
                    if (viewManager == null) continue;
                    bounds = viewManager.getVisibleGeoBounds();
                    ImageSequenceGrabber.subsetBounds(bounds, imageProps);
                    String tail = IOUtil.getFileTail(file);
                    String tmpImageFile = this.getIdv().getStore().getTmpFile(tail + ".png");
                    ImageUtils.writeImageToFile(image, tmpImageFile, quality);
                    ImageWrapper imageWrapper = new ImageWrapper(tmpImageFile, null, bounds, null);
                    imageWrapper.setProperties(imageProps);
                    new ImageSequenceGrabber(file, this.getIdv(), this, node, Misc.newList(imageWrapper), null, 1.0);
                    continue;
                }
                ImageUtils.writeImageToFile(image, file, quality);
            }
        }
        return image;
    }

    public Insets getInsets(Element child, int dflt) {
        int space = this.applyMacros(child, ATTR_SPACE, dflt);
        int hspace = this.applyMacros(child, ATTR_HSPACE, space);
        int vspace = this.applyMacros(child, ATTR_VSPACE, space);
        int top = this.applyMacros(child, "top", vspace);
        int bottom = this.applyMacros(child, "bottom", vspace);
        int left = this.applyMacros(child, "left", hspace);
        int right = this.applyMacros(child, "right", hspace);
        return new Insets(top, left, bottom, right);
    }

    public BufferedImage doLatLonLabels(Element child, ViewManager viewManager, BufferedImage image, Hashtable imageProps) throws Exception {
        double percent;
        int i;
        EarthLocation se;
        EarthLocation sw;
        EarthLocation ne;
        EarthLocation nw;
        if (viewManager == null) {
            throw new IllegalArgumentException("Tag latlonlabels requires a view");
        }
        if (!(viewManager instanceof MapViewManager)) {
            throw new IllegalArgumentException("Tag latlonlabels requires a map view");
        }
        MapViewManager mvm = (MapViewManager)viewManager;
        NavigatedDisplay display = (NavigatedDisplay)viewManager.getMaster();
        DecimalFormat format = new DecimalFormat(this.applyMacros(child, ATTR_FORMAT, "##0.0"));
        Color color = this.applyMacros(child, ATTR_COLOR, Color.red);
        Color lineColor = this.applyMacros(child, ATTR_LINECOLOR, color);
        Color bg = this.applyMacros(child, ATTR_LABELBACKGROUND, (Color)null);
        double[] latValues = Misc.parseDoubles(this.applyMacros(child, ATTR_LAT_VALUES, ""));
        List<String> latLabels = StringUtil.split(this.applyMacros(child, ATTR_LAT_LABELS, ""), ",", true, true);
        double[] lonValues = Misc.parseDoubles(this.applyMacros(child, ATTR_LON_VALUES, ""));
        List<String> lonLabels = StringUtil.split(this.applyMacros(child, ATTR_LON_LABELS, ""), ",", true, true);
        boolean drawLonLines = this.applyMacros(child, ATTR_DRAWLONLINES, false);
        boolean drawLatLines = this.applyMacros(child, ATTR_DRAWLATLINES, false);
        boolean showTop = this.applyMacros(child, ATTR_SHOWTOP, false);
        boolean showBottom = this.applyMacros(child, ATTR_SHOWBOTTOM, true);
        boolean showLeft = this.applyMacros(child, ATTR_SHOWLEFT, true);
        boolean showRight = this.applyMacros(child, ATTR_SHOWRIGHT, false);
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        int centerX = width / 2;
        int centerY = height / 2;
        Double north = (Double)imageProps.get(ATTR_NORTH);
        Double south = (Double)imageProps.get(ATTR_SOUTH);
        Double east = (Double)imageProps.get(ATTR_EAST);
        Double west = (Double)imageProps.get(ATTR_WEST);
        if (north != null) {
            nw = DisplayControlImpl.makeEarthLocation(north, west, 0.0);
            ne = DisplayControlImpl.makeEarthLocation(north, east, 0.0);
            sw = DisplayControlImpl.makeEarthLocation(south, west, 0.0);
            se = DisplayControlImpl.makeEarthLocation(south, east, 0.0);
        } else {
            nw = display.screenToEarthLocation(0, 0);
            ne = display.screenToEarthLocation(width, 0);
            se = display.screenToEarthLocation(0, height);
            sw = display.screenToEarthLocation(width, height);
        }
        double widthDegrees = ne.getLongitude().getValue() - nw.getLongitude().getValue();
        double heightDegrees = ne.getLatitude().getValue() - se.getLatitude().getValue();
        Insets insets = this.getInsets(child, 0);
        int delta = 2;
        int bgPad = 1;
        image = this.doMatte(image, child, 0);
        Graphics2D g = (Graphics2D)image.getGraphics();
        g.setFont(this.getFont(child));
        FontMetrics fm = g.getFontMetrics();
        int lineOffsetRight = this.applyMacros(child, ATTR_LINEOFFSET_RIGHT, 0);
        int lineOffsetLeft = this.applyMacros(child, ATTR_LINEOFFSET_LEFT, 0);
        int lineOffsetTop = this.applyMacros(child, ATTR_LINEOFFSET_TOP, 0);
        int lineOffsetBottom = this.applyMacros(child, ATTR_LINEOFFSET_BOTTOM, 0);
        BasicStroke lineStroke = XmlUtil.hasAttribute(child, ATTR_DASHES) ? new BasicStroke((float)this.applyMacros(child, ATTR_LINEWIDTH, 1.0), 0, 2, 1.0f, Misc.parseFloats(this.applyMacros(child, ATTR_DASHES, "8")), 0.0f) : new BasicStroke((float)this.applyMacros(child, ATTR_LINEWIDTH, 1.0));
        g.setStroke(lineStroke);
        double leftLon = nw.getLongitude().getValue(CommonUnit.degree);
        double rightLon = ne.getLongitude().getValue(CommonUnit.degree);
        Range lonRange = new Range(leftLon, rightLon);
        for (i = 0; i < lonValues.length; ++i) {
            double lon = GeoUtils.normalizeLongitude(lonRange, lonValues[i]);
            percent = (lon - nw.getLongitude().getValue()) / widthDegrees;
            String label = i < lonLabels.size() ? lonLabels.get(i) : format.format(lonValues[i]);
            Rectangle2D rect = fm.getStringBounds(label, g);
            int baseX = insets.left + (int)(percent * (double)width);
            int x = baseX - (int)rect.getWidth() / 2;
            int topY = insets.top == 0 ? (int)rect.getHeight() + delta : insets.top - delta;
            if (drawLonLines) {
                g.setColor(lineColor);
                g.drawLine(baseX, insets.top + lineOffsetTop, baseX, insets.top + height - lineOffsetBottom);
            }
            if (showTop) {
                if (bg != null) {
                    g.setColor(bg);
                    g.fillRect(x - bgPad, topY - (int)rect.getHeight() - bgPad, (int)rect.getWidth() + bgPad * 2, (int)rect.getHeight() + bgPad * 2);
                }
                g.setColor(color);
                g.drawString(label, x, topY);
            }
            int bottomY = insets.bottom == 0 ? insets.top + height - delta : insets.top + height + (int)rect.getHeight() + delta;
            if (!showBottom) continue;
            if (bg != null) {
                g.setColor(bg);
                g.fillRect(x - bgPad, bottomY - (int)rect.getHeight() - bgPad, (int)rect.getWidth() + bgPad * 2, (int)rect.getHeight() + bgPad * 2);
            }
            g.setColor(color);
            g.drawString(label, x, bottomY);
        }
        for (i = 0; i < latValues.length; ++i) {
            double lat = latValues[i];
            percent = 1.0 - (lat - se.getLatitude().getValue()) / heightDegrees;
            int baseY = insets.top + (int)(percent * (double)height);
            String label = i < latLabels.size() ? latLabels.get(i) : format.format(lat);
            Rectangle2D rect = fm.getStringBounds(label, g);
            int y = baseY + (int)rect.getHeight() / 2;
            int leftX = insets.left == 0 ? delta : insets.left - (int)rect.getWidth() - delta;
            if (drawLonLines) {
                g.setColor(lineColor);
                g.drawLine(insets.left + lineOffsetRight, baseY, insets.left + width - lineOffsetRight, baseY);
            }
            if (showLeft) {
                if (bg != null) {
                    g.setColor(bg);
                    g.fillRect(leftX - bgPad, y - (int)rect.getHeight() - bgPad, (int)rect.getWidth() + bgPad * 2, (int)rect.getHeight() + bgPad * 2);
                }
                g.setColor(color);
                g.drawString(label, leftX, y);
            }
            leftX = insets.right == 0 ? insets.left + width - (int)rect.getWidth() - delta : insets.left + width + delta;
            if (!showRight) continue;
            if (bg != null) {
                g.setColor(bg);
                g.fillRect(leftX - bgPad, y - (int)rect.getHeight() - bgPad, (int)rect.getWidth() + bgPad * 2, (int)rect.getHeight() + bgPad * 2);
            }
            g.setColor(color);
            g.drawString(label, leftX, y);
        }
        return image;
    }

    public BufferedImage doMatte(BufferedImage image, Element child, int dfltSpace) {
        return this.doMatte(image, child, this.getInsets(child, dfltSpace));
    }

    public BufferedImage doMatte(BufferedImage image, Element child, Insets insets) {
        Color bg = this.applyMacros(child, ATTR_BACKGROUND, Color.white);
        return ImageUtils.matte(image, insets.top, insets.bottom, insets.left, insets.right, bg);
    }

    private String getImageFileName(String filename) {
        if (LogUtil.getTestMode() && this.getIdv().getArgsManager().testDir != null) {
            filename = IOUtil.joinDir(this.getIdv().getArgsManager().testDir, filename);
        }
        return filename;
    }

    private void setFont(Graphics g, Element node) {
        int fontSize = this.applyMacros(node, ATTR_FONTSIZE, 12);
        Font f = new Font(this.applyMacros(node, ATTR_FONTFACE, "dialog"), 0, fontSize);
        g.setFont(f);
    }

    private Font getFont(Element node) {
        if (XmlUtil.hasAttribute(node, ATTR_FONTSIZE) || XmlUtil.hasAttribute(node, ATTR_FONTFACE)) {
            int fontSize = this.applyMacros(node, ATTR_FONTSIZE, 12);
            return new Font(this.applyMacros(node, ATTR_FONTFACE, "dialog"), 0, fontSize);
        }
        return null;
    }

    public synchronized void doneCapturingMovie() {
        this.notify();
    }

    public synchronized void captureMovie(String filename) {
        this.captureMovie(filename, null);
    }

    public synchronized void captureMovie(String filename, Element scriptingNode) {
        boolean combine;
        ViewManager viewManager;
        List files;
        if (filename == null && scriptingNode != null) {
            filename = XmlUtil.getAttribute(scriptingNode, "file");
        }
        if (scriptingNode != null && (files = this.findFiles(scriptingNode)) != null) {
            this.debug("Making movie from existing images " + filename);
            filename = this.applyMacros(filename);
            Dimension size = new Dimension(this.applyMacros(scriptingNode, ATTR_WIDTH, 400), this.applyMacros(scriptingNode, ATTR_HEIGHT, 300));
            ImageSequenceGrabber isg = new ImageSequenceGrabber(filename, this.getIdv(), this, scriptingNode, files, size, this.applyMacros(scriptingNode, ATTR_FRAMERATE, 2), this.applyMacros(scriptingNode, ATTR_ENDFRAMEPAUSE, -1));
            return;
        }
        List viewManagers = null;
        if (scriptingNode != null && XmlUtil.hasAttribute(scriptingNode, "display")) {
            DisplayControlImpl display = this.findDisplayControl(scriptingNode);
            if (display == null) {
                throw new IllegalArgumentException("Could not find display:" + XmlUtil.toString(scriptingNode));
            }
            String what = this.applyMacros(scriptingNode, ATTR_WHAT, (String)null);
            viewManager = null;
            try {
                viewManager = display.getViewManagerForCapture(what);
                if (viewManager != null) {
                    viewManager.updateDisplayIfNeeded();
                }
            }
            catch (Exception exc) {
                throw new RuntimeException(exc);
            }
            if (viewManager != null) {
                viewManagers = Misc.newList(viewManager);
            } else {
                throw new IllegalArgumentException("Cannot capture a movie with display:" + XmlUtil.toString(scriptingNode));
            }
        }
        if (viewManagers == null) {
            viewManagers = this.getViewManagers(scriptingNode);
        }
        if (combine = XmlUtil.getAttribute((Node)scriptingNode, ATTR_COMBINE, false)) {
            JFrame frame;
            ViewManager viewManager2 = this.getIdv().getVMManager().getLastActiveViewManager();
            this.getProperties().put(PROP_VIEWINDEX, new Integer(0));
            String name = viewManager2.getName();
            if (name == null) {
                name = "view0";
            }
            this.getProperties().put(PROP_VIEWNAME, name);
            if (!this.getIdv().getArgsManager().getIsOffScreen() && (frame = GuiUtils.getFrame(viewManager2.getContents())) != null) {
                LogUtil.registerWindow(frame);
                frame.setVisible(true);
                GuiUtils.toFront(frame);
                frame.setLocation(50, 50);
                Misc.sleep(50L);
            }
            String loopFilename = this.applyMacros(filename);
            this.debug("Making movie:" + loopFilename);
            ImageSequenceGrabber isg = new ImageSequenceGrabber(viewManager2, loopFilename, this.getIdv(), this, scriptingNode);
            try {
                this.wait();
            }
            catch (Exception exc) {
                ImageGenerator.logException("Doing the captureMovie wait", exc);
            }
            this.debug("Done making movie:" + loopFilename);
        } else {
            for (int i = 0; i < viewManagers.size(); ++i) {
                JFrame frame;
                viewManager = viewManagers.get(i);
                this.getProperties().put(PROP_VIEWINDEX, new Integer(i));
                String name = viewManager.getName();
                if (name == null) {
                    name = "view" + i;
                }
                this.getProperties().put(PROP_VIEWNAME, name);
                if (!this.getIdv().getArgsManager().getIsOffScreen() && (frame = GuiUtils.getFrame(viewManager.getContents())) != null) {
                    LogUtil.registerWindow(frame);
                    frame.setVisible(true);
                    GuiUtils.toFront(frame);
                    frame.setLocation(50, 50);
                    Misc.sleep(50L);
                }
                String loopFilename = this.applyMacros(filename);
                this.debug("Making movie:" + loopFilename);
                ImageSequenceGrabber isg = new ImageSequenceGrabber(viewManager, loopFilename, this.getIdv(), this, scriptingNode);
                try {
                    this.wait();
                }
                catch (Exception exc) {
                    ImageGenerator.logException("Doing the captureMovie wait", exc);
                }
                this.debug("Done making movie:" + loopFilename);
            }
        }
    }

    public Date getAnimationTime() {
        Real v;
        ViewManager vm;
        Animation animation;
        List<ViewManager> vms = this.getViewManagers(this.currentNode);
        if (vms.size() > 0 && (animation = (vm = vms.get(0)).getAnimation()) != null && (v = animation.getAniValue()) != null) {
            return new Date((long)v.getValue() * 1000L);
        }
        return new Date(Misc.getCurrentTime());
    }

    private PythonInterpreter getInterpreter() {
        if (this.interpreter == null) {
            this.interpreter = this.getIdv().getJythonManager().createInterpreter();
            this.interpreter.set("ig", this);
            this.interpreter.set("interp", this);
            this.interpreter.set("islInterpreter", this);
        }
        return this.interpreter;
    }

    public String fields(String datasource, String pattern) {
        DataSource dataSource = this.findDataSource(datasource);
        if (dataSource == null) {
            throw new IllegalArgumentException("Could not find data source:" + datasource);
        }
        List choices = pattern == null || pattern.length() == 0 ? dataSource.getDataChoices() : dataSource.findDataChoices(pattern);
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 0; i < choices.size(); ++i) {
            DataChoice dataChoice = (DataChoice)choices.get(i);
            names.add(dataChoice.getName());
        }
        return StringUtil.join(",", names);
    }

    private void warning(String msg) {
        System.err.println(new Date() + " WARNING:" + msg);
    }

    protected void debug(String msg) {
        if (this.debug) {
            System.out.println(new Date() + ": " + msg);
        }
    }

    private static void checkFtp(FTPClient f, String msg) throws Exception {
        int replyCode = f.getReplyCode();
        if (!FTPReply.isPositiveCompletion((int)replyCode)) {
            String reply = f.getReplyString();
            f.disconnect();
            throw new IllegalStateException("Error with ftp: " + replyCode + " " + msg + "\n" + reply);
        }
    }

    public static void ftpPut(String server, String userName, String password, String destination, byte[] bytes) throws Exception {
        FTPClient f = new FTPClient();
        f.connect(server);
        f.login(userName, password);
        f.setFileType(2);
        f.enterLocalPassiveMode();
        ImageGenerator.checkFtp(f, "Connecting to ftp server");
        f.storeFile(destination, (InputStream)new ByteArrayInputStream(bytes));
        ImageGenerator.checkFtp(f, "Storing file");
        f.logout();
        f.disconnect();
    }

    public String getLetter(int i) {
        if (i >= 0 && i < alphabet.length) {
            return alphabet[i];
        }
        return "out of range";
    }

    public String getRoman(int i) {
        if (i >= 0 && i < roman.length) {
            return roman[i];
        }
        return "out of range";
    }

    static {
        alphabet = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z"};
        roman = new String[]{"I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX", "X", "XI", "XII", "XIII", "XIV", "XV", "XVI", "XVII", "XVIII", "XX", "XXI", "XXII", "XXIII", "XXIV", "XXV", "XXVI", "XXVII", "XXVIII"};
    }

    private static class BadIslException
    extends RuntimeException {
        String msg;

        public BadIslException(String msg) {
            this.msg = msg;
        }

        @Override
        public String toString() {
            return this.msg;
        }
    }

    protected static class MyQuitException
    extends Exception {
        protected MyQuitException() {
        }
    }

    protected static class MyReturnException
    extends Exception {
        protected MyReturnException() {
        }
    }

    protected static class MyContinueException
    extends Exception {
        protected MyContinueException() {
        }
    }

    protected static class MyBreakException
    extends Exception {
        protected MyBreakException() {
        }
    }

    private class OutputInfo {
        Element outputNode;
        Hashtable buffers = new Hashtable();
        Hashtable templates = new Hashtable();

        public OutputInfo(Element node) {
            this.outputNode = node;
        }

        public void process(Element node) throws Throwable {
            String text;
            String where = ImageGenerator.this.applyMacros(node, "template", ImageGenerator.PROP_CONTENTS);
            StringBuffer sb = (StringBuffer)this.buffers.get(where);
            String template = (String)this.templates.get(where);
            if (sb == null) {
                sb = new StringBuffer();
                template = XmlUtil.getAttribute((Node)this.outputNode, "template:" + where, "${text}");
                if (template.startsWith("file:")) {
                    template = ImageGenerator.this.applyMacros(template);
                    template = IOUtil.readContents(template.substring(5));
                }
                this.buffers.put(where, sb);
                this.templates.put(where, template);
            }
            if ((text = XmlUtil.getAttribute((Node)node, ImageGenerator.ATTR_TEXT, (String)null)) == null) {
                if (XmlUtil.hasAttribute(node, ImageGenerator.ATTR_FROMFILE)) {
                    String filename = ImageGenerator.this.applyMacros(node, ImageGenerator.ATTR_FROMFILE);
                    text = ImageGenerator.this.applyMacros(IOUtil.readContents(filename));
                } else {
                    text = XmlUtil.getChildText(node);
                    if (text != null && text.length() == 0) {
                        text = null;
                    }
                }
            }
            if (text == null) {
                NamedNodeMap nnm = node.getAttributes();
                Hashtable<String, String> props = new Hashtable<String, String>();
                if (nnm != null) {
                    for (int i = 0; i < nnm.getLength(); ++i) {
                        Attr attr = (Attr)nnm.item(i);
                        if ("template".equals(attr.getNodeName())) continue;
                        props.put(attr.getNodeName(), ImageGenerator.this.applyMacros(attr.getNodeValue()));
                    }
                }
                text = ImageGenerator.this.applyMacros(template, props);
            } else {
                text = ImageGenerator.this.applyMacros(text);
            }
            sb.append(text);
        }

        public void write() throws Throwable {
            String outputFile = ImageGenerator.this.applyMacros(this.outputNode, "file");
            String template = ImageGenerator.this.applyMacros(this.outputNode, "template", (String)null);
            if (template == null) {
                template = "${contents}";
            }
            if (template.startsWith("file:")) {
                template = IOUtil.readContents(template.substring(5));
            }
            Enumeration keys = this.buffers.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                StringBuffer buff = (StringBuffer)this.buffers.get(key);
                template = ImageGenerator.this.applyMacros(template, Misc.newHashtable(key, buff.toString()));
            }
            IOUtil.writeFile(outputFile, template);
        }
    }
}

