/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.ui;

import java.awt.Component;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.help.HelpSet;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ucar.unidata.idv.IntegratedDataViewer;
import ucar.unidata.idv.ViewDescriptor;
import ucar.unidata.idv.ViewManager;
import ucar.unidata.idv.chooser.IdvChooserManager;
import ucar.unidata.idv.ui.IdvComponentGroup;
import ucar.unidata.idv.ui.IdvComponentHolder;
import ucar.unidata.idv.ui.IdvHelp;
import ucar.unidata.idv.ui.IdvUIManager;
import ucar.unidata.idv.ui.IdvWindow;
import ucar.unidata.idv.ui.QuicklinkPanel;
import ucar.unidata.ui.ComponentGroup;
import ucar.unidata.ui.FineLineBorder;
import ucar.unidata.ui.HtmlComponent;
import ucar.unidata.ui.RovingProgress;
import ucar.unidata.ui.XmlUi;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.MemoryMonitor;
import ucar.unidata.util.Misc;
import ucar.unidata.util.StringUtil;
import ucar.unidata.util.WrapperException;
import ucar.unidata.xml.XmlUtil;

public class IdvXmlUi
extends XmlUi {
    private static final String ATTR_USEPREF = "usepref";
    private static int version = 0;
    IntegratedDataViewer idv;
    private List viewManagers = new ArrayList();
    private List viewManagersToUse;
    IdvWindow window;
    private List memoryMonitors = new ArrayList();
    int componentCnt = 0;

    public IdvXmlUi(IntegratedDataViewer idv, Element root) {
        super(root, idv);
        this.viewManagersToUse = new ArrayList();
        this.idv = idv;
        this.properties.put("versionuid", Misc.getUniqueId());
        this.properties.put("version", "" + version++);
    }

    public IdvXmlUi(IdvWindow window, List viewManagers, IntegratedDataViewer idv, Element root) {
        this(window, viewManagers, idv, root, null);
    }

    public IdvXmlUi(IdvWindow window, List viewManagers, IntegratedDataViewer idv, Element root, Element startNode) {
        super(root, startNode, null, idv, null);
        this.window = window;
        if (viewManagers != null) {
            this.viewManagers.addAll(viewManagers);
            this.viewManagersToUse = new ArrayList(viewManagers);
        }
        if (window != null) {
            window.setXmlUI(this);
        }
        this.idv = idv;
        this.properties.put("versionuid", Misc.getUniqueId());
        this.properties.put("version", "" + version++);
    }

    protected static void processToolbarXml(Element root, IdvUIManager uiManager) {
        root.removeAttribute("id");
        NodeList elements = XmlUtil.getElements(root);
        Object iconSize = uiManager.getIdv().getStateManager().getPreferenceOrProperty("idv.ui.iconsize");
        if (iconSize != null && iconSize.toString().trim().length() == 0) {
            iconSize = null;
        }
        if (iconSize == null) {
            iconSize = uiManager.getIdv().getStateManager().getPreferenceOrProperty("idv.ui.minimumiconsize");
        }
        if (iconSize != null && iconSize.toString().trim().length() == 0) {
            iconSize = null;
        }
        for (int i = 0; i < elements.getLength(); ++i) {
            Element child = (Element)elements.item(i);
            child.removeAttribute("id");
            if (!child.getTagName().equals("button")) continue;
            String action = XmlUtil.getAttribute((Node)child, "action", "");
            String desc = uiManager.getActionDescription(action);
            if (XmlUtil.getAttribute((Node)child, "tooltip", (String)null) == null && desc != null) {
                child.setAttribute("tooltip", desc);
            }
            boolean haveImage = true;
            if (XmlUtil.getAttribute((Node)child, "image", (String)null) == null) {
                String image = uiManager.getActionImage(action);
                if (image != null) {
                    if (iconSize != null && image.indexOf("16") >= 0) {
                        String tmp = StringUtil.replace(image, "16", iconSize.toString());
                        if (GuiUtils.getImage(tmp, IdvXmlUi.class, true, true) != null) {
                            image = tmp;
                        } else {
                            child.setAttribute("imagewidth", iconSize.toString());
                        }
                    }
                    child.setAttribute("image", image);
                } else {
                    haveImage = false;
                    if (XmlUtil.getAttribute((Node)child, "label", (String)null) == null) {
                        child.setAttribute("label", desc);
                    }
                }
            }
            if (haveImage) {
                child.setAttribute("space", "2");
                child.setAttribute("mouse_enter", "ui.setText(idv.messagelabel,prop:tooltip);ui.setBorder(this,etched);");
                child.setAttribute("mouse_exit", "ui.setText(idv.messagelabel,);ui.setBorder(this,empty);");
                child.setAttribute("border", "empty");
            } else {
                child.setAttribute("space", "0");
                child.setAttribute("border", "empty");
            }
            if (XmlUtil.getAttribute((Node)child, "class", (String)null) != null) continue;
            if (haveImage) {
                child.setAttribute("class", "iconbtn");
                continue;
            }
            child.setAttribute("class", "textbtn");
        }
    }

    @Override
    public void dispose() {
        for (int i = 0; i < this.memoryMonitors.size(); ++i) {
            ((MemoryMonitor)this.memoryMonitors.get(i)).stop();
        }
        this.memoryMonitors = null;
        this.viewManagers = null;
        this.viewManagersToUse = null;
        this.window = null;
        super.dispose();
    }

    @Override
    public Component createComponent(Element node, String id) {
        String tagName = node.getTagName();
        if (tagName.equals("idv.quicklinks")) {
            if (XmlUtil.getAttribute((Node)node, ATTR_USEPREF, false) && !this.idv.getIdvUIManager().embedQuickLinksInDashboard()) {
                return null;
            }
            return QuicklinkPanel.createQuicklinksFromResources(this.idv);
        }
        if (tagName.equals("idv.quicklinks.favorites")) {
            QuicklinkPanel.Bundle editor = new QuicklinkPanel.Bundle(this.idv, "Favorite Bundles", 0);
            editor.doUpdate();
            return ((QuicklinkPanel)editor).getContents();
        }
        if (tagName.equals("idv.quicklinks.datasources")) {
            QuicklinkPanel.Bundle editor = new QuicklinkPanel.Bundle(this.idv, "Data Favorites", 2);
            editor.doUpdate();
            return ((QuicklinkPanel)editor).getContents();
        }
        if (tagName.equals("idv.quicklinks.displaytemplates")) {
            QuicklinkPanel.Bundle editor = new QuicklinkPanel.Bundle(this.idv, "Display Templates", 1);
            editor.doUpdate();
            return ((QuicklinkPanel)editor).getContents();
        }
        if (tagName.equals("idv.quicklinks.history")) {
            QuicklinkPanel.FileHistory editor = new QuicklinkPanel.FileHistory(this.idv, "History");
            editor.doUpdate();
            return editor.getContents();
        }
        if (tagName.equals("idv.quicklinks.special")) {
            QuicklinkPanel.Control editor = new QuicklinkPanel.Control(this.idv, "Special Displays");
            editor.doUpdate();
            return editor.getContents();
        }
        if (tagName.equals("idv.quicklinks.windows")) {
            QuicklinkPanel.Html editor = new QuicklinkPanel.Html(this.idv, "New Window", "Create New Window", this.idv.getIdvUIManager().getSkinHtml());
            editor.doUpdate();
            return editor.getContents();
        }
        if (tagName.equals("idv.help")) {
            try {
                URL url = IOUtil.getURL(XmlUtil.getAttribute((Node)node, "helpset", this.idv.getStateManager().getHelpRoot() + "/HelpSet.hs"), this.getClass());
                if (url == null) {
                    return null;
                }
                return new IdvHelp(new HelpSet(this.getClass().getClassLoader(), url));
            }
            catch (Exception exc) {
                LogUtil.logException("Error loading help", exc);
                return null;
            }
        }
        if (tagName.equals("idv.component.group")) {
            String key = XmlUtil.getAttribute((Node)node, "id", "" + this.componentCnt);
            ++this.componentCnt;
            ComponentGroup compGroup = (ComponentGroup)(this.window != null ? this.window.getPersistentComponent(key) : null);
            if (compGroup == null) {
                compGroup = this.makeComponentGroup(node);
                compGroup.setShowHeader(XmlUtil.getAttribute((Node)node, "showheader", true));
                if (this.window != null) {
                    this.window.putPersistentComponent(key, compGroup);
                }
            }
            return compGroup.getContents();
        }
        if (tagName.equals("idv.choosers")) {
            if (XmlUtil.getAttribute((Node)node, ATTR_USEPREF, false) && !this.idv.getIdvUIManager().embedDataChooserInDashboard()) {
                return null;
            }
            boolean inTabs = XmlUtil.getAttribute((Node)node, "intabs", !this.idv.getProperty("idv.chooser.treeview", false));
            ArrayList choosers = new ArrayList();
            JComponent comp = this.idv.getIdvChooserManager().createChoosers(inTabs, choosers, node);
            for (int i = 0; i < choosers.size(); ++i) {
                if (this.window == null) continue;
                this.window.addToGroup("choosers", (Component)choosers.get(i));
            }
            return comp;
        }
        if (tagName.equals("chooser")) {
            if (this.idv.getPreferenceManager().shouldShowChooser(IdvChooserManager.getChooserId(node))) {
                Component comp = this.idv.getIdvChooserManager().createChooser(node);
                if (comp != null && this.window != null) {
                    this.window.addToGroup("choosers", comp);
                }
                return comp;
            }
            return new JPanel();
        }
        if (tagName.equals("idv.viewpanel")) {
            if (XmlUtil.getAttribute((Node)node, ATTR_USEPREF, false) && !this.idv.getIdvUIManager().getShowControlsInTab()) {
                return null;
            }
            return this.idv.getIdvUIManager().getViewPanel().getContents();
        }
        if (tagName.equals("idv.toolbar")) {
            JComponent toolbar = this.idv.getIdvUIManager().doMakeToolbar();
            toolbar = GuiUtils.center(toolbar);
            if (this.window != null) {
                this.window.addToGroup("toolbars", toolbar);
            }
            return toolbar;
        }
        if (tagName.equals("idv.menubar")) {
            if (GuiUtils.doMacMenubar()) {
                return GuiUtils.filler();
            }
            return this.idv.getIdvUIManager().doMakeMenuBar(this.window);
        }
        if (tagName.equals("idv.memorymonitor.dashboard")) {
            MemoryMonitor monitor = new MemoryMonitor(80, (boolean)new Boolean(this.idv.getStateManager().getPreferenceOrProperty("idv.monitor.showclock.dashboard", "true")));
            this.memoryMonitors.add(monitor);
            return monitor;
        }
        if (tagName.equals("idv.memorymonitor.view")) {
            MemoryMonitor monitor = new MemoryMonitor(80, (boolean)new Boolean(this.idv.getStateManager().getPreferenceOrProperty("idv.monitor.showclock.view", "true")));
            this.memoryMonitors.add(monitor);
            return monitor;
        }
        if (tagName.equals("idv.statusbar")) {
            return this.idv.getIdvUIManager().doMakeStatusBar(this.window);
        }
        if (tagName.equals("idv.dataselector")) {
            if (XmlUtil.getAttribute((Node)node, ATTR_USEPREF, false) && !this.idv.getIdvUIManager().embedFieldSelectorInDashboard()) {
                return null;
            }
            return this.idv.getIdvUIManager().createDataSelector(false, false).getContents();
        }
        if (tagName.equals("idv.progressbar")) {
            return new RovingProgress(true);
        }
        if (tagName.equals("idv.datatree")) {
            return this.idv.getIdvUIManager().createDataTree(false).getScroller();
        }
        if (tagName.equals("idv.messagelogger")) {
            JTextArea messageLog = new JTextArea(3, 40);
            messageLog.setEditable(false);
            LogUtil.addMessageLogger(messageLog);
            return messageLog;
        }
        if (tagName.equals("idv.waitlabel")) {
            JLabel waitLabel = new JLabel(IdvWindow.getNormalIcon());
            this.addComponent("idv.waitlabel", waitLabel);
            return waitLabel;
        }
        if (tagName.equals("idv.progressbar")) {
            return this.idv.getIdvUIManager().doMakeRovingProgressBar();
        }
        if (tagName.equals("idv.messagelabel")) {
            JLabel msgLabel = new JLabel(" ");
            LogUtil.addMessageLogger(msgLabel);
            return msgLabel;
        }
        if (tagName.equals("idv.mapview") || tagName.equals("idv.view")) {
            ViewManager viewManager = null;
            if (this.viewManagersToUse != null && this.viewManagersToUse.size() > 0) {
                viewManager = (ViewManager)this.viewManagersToUse.get(0);
                this.viewManagersToUse.remove(0);
            }
            if (viewManager == null) {
                viewManager = this.getViewManager(node);
            }
            if (viewManager == null) {
                return new JLabel("Error creating view manager");
            }
            return viewManager.getContents();
        }
        return super.createComponent(node, id);
    }

    protected IdvComponentGroup makeComponentGroup(Element node) {
        IdvComponentGroup compGroup = new IdvComponentGroup(this.idv, "");
        compGroup.initWith(node);
        NodeList elements = XmlUtil.getElements(node);
        block17: for (int i = 0; i < elements.getLength(); ++i) {
            String childTagName;
            Element child = (Element)elements.item(i);
            switch (childTagName = child.getTagName()) {
                case "idv.mapview": 
                case "idv.view": {
                    ViewManager viewManager = this.getViewManager(child);
                    compGroup.addComponent(new IdvComponentHolder(this.idv, viewManager));
                    continue block17;
                }
                case "idv.component.choosers": {
                    IdvComponentHolder comp = new IdvComponentHolder(this.idv, "choosers");
                    comp.setType("choosers");
                    comp.setName(XmlUtil.getAttribute((Node)child, "name", "Choosers"));
                    compGroup.addComponent(comp);
                    continue block17;
                }
                case "idv.component.skin": {
                    IdvComponentHolder comp = new IdvComponentHolder(this.idv, XmlUtil.getAttribute(child, "url"));
                    comp.setType("skin");
                    comp.setName(XmlUtil.getAttribute((Node)child, "name", "UI"));
                    compGroup.addComponent(comp);
                    continue block17;
                }
                case "idv.component.html": {
                    String text = XmlUtil.getChildText(child);
                    text = new String(XmlUtil.decodeBase64(text.trim()));
                    HtmlComponent comp = new HtmlComponent("Html Text", text);
                    comp.setShowHeader(false);
                    comp.setName(XmlUtil.getAttribute((Node)child, "name", "HTML"));
                    compGroup.addComponent(comp);
                    continue block17;
                }
                case "idv.component.group": {
                    IdvComponentGroup childCompGroup = this.makeComponentGroup(child);
                    compGroup.addComponent(childCompGroup);
                    continue block17;
                }
                case "idv.dataselector": {
                    compGroup.addComponent(new IdvComponentHolder(this.idv, this.idv.getIdvUIManager().createDataSelector(false, false)));
                    continue block17;
                }
                default: {
                    System.err.println("Unknwon component element:" + XmlUtil.toString(child));
                }
            }
        }
        return compGroup;
    }

    protected ViewManager getViewManager(Element node) {
        String xmlProperties;
        String bundleText = XmlUtil.getChildText(node);
        if (bundleText != null && bundleText.trim().length() > 0) {
            try {
                bundleText = new String(XmlUtil.decodeBase64(bundleText.trim()));
                return (ViewManager)this.idv.decodeObject(bundleText);
            }
            catch (Exception exc) {
                throw new WrapperException(exc);
            }
        }
        String properties = this.idv.getViewManagerProperties();
        if (properties == null) {
            properties = "";
        }
        if ((xmlProperties = this.getAttr(node, "properties", (String)null)) != null) {
            properties = properties + ";" + xmlProperties;
        }
        String viewId = this.getAttr(node, "viewid", (String)null);
        ViewDescriptor viewDescriptor = null;
        if (viewId != null) {
            viewDescriptor = new ViewDescriptor(viewId);
        }
        ViewManager viewManager = null;
        String className = this.getAttr(node, "class", (String)null);
        if (className != null && className.startsWith("${")) {
            className = null;
        }
        if (className != null) {
            try {
                Class vmClass;
                Constructor ctor;
                if (viewDescriptor == null) {
                    viewDescriptor = new ViewDescriptor();
                }
                if ((ctor = Misc.findConstructor(vmClass = Misc.findClass(className), new Class[]{IntegratedDataViewer.class, ViewDescriptor.class, String.class})) == null) {
                    System.err.println("Could not find ctor for:" + vmClass.getName());
                } else {
                    viewManager = (ViewManager)ctor.newInstance(this.idv, viewDescriptor, properties);
                    viewManager.initFromSkin(node);
                    this.idv.getVMManager().addViewManager(viewManager);
                    this.viewManagers.add(viewManager);
                }
            }
            catch (Exception exc) {
                LogUtil.logException("", exc);
                System.err.println("Error creating class:" + className + " exception: " + exc);
                exc.printStackTrace();
            }
        }
        if (viewManager == null) {
            viewManager = this.idv.getVMManager().createViewManager(viewDescriptor, properties);
            if (viewManager == null) {
                return null;
            }
            this.viewManagers.add(viewManager);
        }
        return viewManager;
    }

    @Override
    public Border getBorder(String type, Element node) {
        if (type.equals("idv.status")) {
            FineLineBorder outside = new FineLineBorder(1);
            Border inside = BorderFactory.createEmptyBorder(0, 2, 0, 2);
            return BorderFactory.createCompoundBorder(outside, inside);
        }
        return super.getBorder(type, node);
    }

    public List getViewManagers() {
        return this.viewManagers;
    }
}

