/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import ucar.unidata.idv.IntegratedDataViewer;
import ucar.unidata.idv.ViewManager;
import ucar.unidata.idv.ui.IdvComponentGroup;
import ucar.unidata.idv.ui.IdvXmlUi;
import ucar.unidata.ui.ComponentGroup;
import ucar.unidata.ui.MultiFrame;
import ucar.unidata.ui.RovingProgress;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.Removable;

public class IdvWindow
extends MultiFrame {
    public static final String GROUP_CHOOSERS = "choosers";
    public static final String GROUP_TOOLBARS = "toolbars";
    private static int lastX = 10;
    private static int lastY = 10;
    private static boolean waitState = false;
    private List<Removable> removables = new ArrayList<Removable>();
    private boolean hasBeenDisposed = false;
    JComponent contents;
    private static ImageIcon waitIcon;
    private static ImageIcon waitOverIcon;
    private static ImageIcon normalIcon;
    private static ArrayList allWindows;
    private static ArrayList mainWindows;
    private static IdvWindow lastActiveWindow;
    private String uniqueId;
    private IdvXmlUi xmlUI;
    private String skinPath;
    private IntegratedDataViewer idv;
    private Hashtable components = new Hashtable();
    private List viewManagers = new ArrayList();
    private boolean waiting = false;
    private boolean isAMainWindow = false;
    private String type = "";
    private Hashtable groups = new Hashtable();
    private Hashtable persistentComponents = new Hashtable();

    public IdvWindow(String title, IntegratedDataViewer theIdv) {
        this(title, theIdv, false);
    }

    public IdvWindow(String title, IntegratedDataViewer theIdv, boolean isAMainWindow) {
        super(title);
        if (this.uniqueId == null) {
            this.uniqueId = Misc.getUniqueId();
        }
        if (GuiUtils.isMac() && theIdv.getProperty("mac.fullscreen.enable", Boolean.FALSE)) {
            IdvWindow.enableFullScreenMode(this.getWindow());
        }
        allWindows.add(this);
        if (isAMainWindow) {
            mainWindows.add(this);
        }
        this.idv = theIdv;
        this.isAMainWindow = isAMainWindow;
        this.setDefaultCloseOperation(0);
        final WindowAdapter[] wa = new WindowAdapter[]{null};
        wa[0] = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (IdvWindow.this.doClose()) {
                    IdvWindow.this.removeWindowListener(wa[0]);
                    lastActiveWindow = null;
                }
            }

            @Override
            public void windowActivated(WindowEvent e) {
                lastActiveWindow = IdvWindow.this;
            }
        };
        this.addWindowListener(wa[0]);
        LogUtil.registerWindow(this.getWindow());
        if (lastX > 500) {
            lastX = 10;
            lastY = 10;
        }
        this.setLocation(lastX, lastY);
        lastX += 50;
    }

    public static IdvWindow getActiveWindow() {
        return lastActiveWindow;
    }

    public static void setWaitState(boolean waiting) {
        waitState = waiting;
    }

    public static boolean getWaitState() {
        return waitState;
    }

    public JComponent getContents() {
        return this.contents;
    }

    public void setContents(JComponent contents) {
        this.contents = contents;
        if (contents == null) {
            return;
        }
        Container contentPane = this.getContentPane();
        if (contentPane != null) {
            contentPane.removeAll();
            contentPane.add(contents);
            this.pack();
        }
    }

    public void setWindowBounds(Rectangle r) {
        this.setBounds(r);
    }

    public static IdvWindow findWindow(Component contents) {
        if (contents == null) {
            return null;
        }
        for (Container parent = contents.getParent(); parent != null; parent = parent.getParent()) {
            IdvWindow idvWindow;
            int i;
            if (parent instanceof Window) {
                for (i = 0; i < allWindows.size(); ++i) {
                    idvWindow = (IdvWindow)allWindows.get(i);
                    if (idvWindow.getFrame() != parent) continue;
                    return idvWindow;
                }
            }
            if (!(parent instanceof JInternalFrame)) continue;
            for (i = 0; i < allWindows.size(); ++i) {
                idvWindow = (IdvWindow)allWindows.get(i);
                if (idvWindow.getInternalFrame() != parent) continue;
                return idvWindow;
            }
        }
        return null;
    }

    public void setXmlUI(IdvXmlUi xmlUI) {
        this.xmlUI = xmlUI;
    }

    public IdvXmlUi getXmlUI() {
        return this.xmlUI;
    }

    public String getSkinPath() {
        return this.skinPath;
    }

    public void setSkinPath(String b) {
        this.skinPath = b;
    }

    public String toString() {
        return "IdvWindow:" + this.skinPath;
    }

    public static ImageIcon getWaitIcon() {
        if (waitIcon == null) {
            return IdvWindow.setWaitIcon("/ucar/unidata/idv/images/wait.gif");
        }
        return waitIcon;
    }

    public static ImageIcon setWaitIcon(String path) {
        waitIcon = GuiUtils.getImageIcon(path);
        return waitIcon;
    }

    @Override
    public void show() {
        if (this.idv != null && !this.idv.okToShowWindows()) {
            return;
        }
        if (waitState) {
            this.startWait();
        }
        this.setState(0);
        super.show();
    }

    public static ImageIcon getNormalIcon() {
        if (normalIcon == null) {
            Image waitImage = IdvWindow.getWaitIcon().getImage();
            BufferedImage image = new BufferedImage(waitImage.getWidth(null), waitImage.getHeight(null), 2);
            normalIcon = new ImageIcon(image);
        }
        return normalIcon;
    }

    public static ImageIcon setNormalIcon(String path) {
        return IdvWindow.getNormalIcon();
    }

    public static ImageIcon getWaitOverIcon() {
        if (waitOverIcon == null) {
            return IdvWindow.setWaitOverIcon("/ucar/unidata/idv/images/wait_over.gif");
        }
        return waitOverIcon;
    }

    public static ImageIcon setWaitOverIcon(String path) {
        waitOverIcon = GuiUtils.getImageIcon(path);
        return waitOverIcon;
    }

    public JLabel getMsgLabel() {
        return (JLabel)this.getComponent("idv.messagelabel");
    }

    public void startWait() {
        this.waiting = true;
        this.setWaitIcon(IdvWindow.getWaitIcon());
        RovingProgress progress = (RovingProgress)this.getComponent("idv.progressbar");
        if (progress != null) {
            progress.start();
        }
    }

    public void endWait() {
        this.waiting = false;
        this.setWaitIcon(IdvWindow.getNormalIcon());
        RovingProgress progress = (RovingProgress)this.getComponent("idv.progressbar");
        if (progress != null) {
            progress.stop();
        }
    }

    public void setWaitIcon(Icon icon) {
        JLabel waitLbl = this.getWaitLabel();
        if (waitLbl != null) {
            waitLbl.setIcon(icon);
            waitLbl.repaint();
        }
    }

    public JLabel getWaitLabel() {
        return (JLabel)this.getComponent("idv.waitlabel");
    }

    protected boolean doClose() {
        if (this.isAMainWindow && mainWindows.contains(this) && mainWindows.size() == 1 && !this.idv.quit()) {
            return false;
        }
        this.dispose();
        return true;
    }

    public boolean getHasBeenDisposed() {
        return this.hasBeenDisposed;
    }

    @Override
    public void dispose() {
        JComponent messageLogger;
        RovingProgress progress;
        if (this.hasBeenDisposed) {
            return;
        }
        this.hasBeenDisposed = true;
        if (lastActiveWindow == this) {
            lastActiveWindow = null;
        }
        this.idv.getIdvUIManager().removeWindow(this);
        for (Removable removable : this.removables) {
            removable.doRemove();
        }
        this.removables = null;
        JMenuBar menuBar = (JMenuBar)this.getComponent("idv.menubar");
        if (menuBar != null) {
            GuiUtils.empty(menuBar, true);
        }
        if ((progress = (RovingProgress)this.getComponent("idv.progressbar")) != null) {
            progress.doRemove();
        }
        if ((messageLogger = (JComponent)this.getComponent("idv.messagelabel")) != null) {
            LogUtil.removeMessageLogger(messageLogger);
        }
        allWindows.remove(this);
        mainWindows.remove(this);
        List<IdvComponentGroup> groups = this.getComponentGroups();
        for (int i = 0; i < groups.size(); ++i) {
            ComponentGroup group = groups.get(i);
            group.doRemove();
        }
        this.groups = null;
        this.destroyViewManagers();
        this.viewManagers = null;
        this.components = null;
        this.persistentComponents = null;
        this.contents = null;
        if (this.xmlUI != null) {
            this.xmlUI.dispose();
            this.xmlUI = null;
        }
        super.dispose();
    }

    private void destroyViewManagers() {
        List viewManagers = this.getViewManagers();
        if (viewManagers == null) {
            return;
        }
        try {
            for (int i = 0; i < viewManagers.size(); ++i) {
                ((ViewManager)viewManagers.get(i)).destroy();
            }
        }
        catch (Exception exc) {
            LogUtil.logException("Destroying window", exc);
        }
    }

    public void destroy() {
        this.destroyViewManagers();
        GuiUtils.empty(this.getContainer(), true);
    }

    public static List getMainWindows() {
        return mainWindows;
    }

    public void setComponent(String componentName, Object component) {
        if (this.components == null) {
            return;
        }
        this.components.put(componentName, component);
    }

    public void addRemovable(Removable removable) {
        this.removables.add(removable);
    }

    public void putPersistentComponent(Object key, Object object) {
        if (this.persistentComponents == null) {
            return;
        }
        this.persistentComponents.put(key, object);
    }

    public Object getPersistentComponent(Object key) {
        if (this.persistentComponents == null) {
            return null;
        }
        return this.persistentComponents.get(key);
    }

    public List<IdvComponentGroup> getComponentGroups() {
        ArrayList<IdvComponentGroup> groups = new ArrayList<IdvComponentGroup>();
        if (this.persistentComponents == null) {
            return groups;
        }
        Hashtable map = this.getPersistentComponents();
        Enumeration keys = map.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object obj = map.get(key);
            if (!(obj instanceof IdvComponentGroup)) continue;
            groups.add((IdvComponentGroup)obj);
        }
        return groups;
    }

    public void addToGroup(Object groupKey, Object comp) {
        ArrayList<Object> comps = (ArrayList<Object>)this.groups.get(groupKey);
        if (comps == null) {
            comps = new ArrayList<Object>();
            this.groups.put(groupKey, comps);
        }
        if (!comps.contains(comp)) {
            comps.add(comp);
        }
    }

    public List getGroup(Object groupKey) {
        return (List)this.groups.get(groupKey);
    }

    public List getComponents() {
        if (this.xmlUI != null) {
            return this.xmlUI.getComponents();
        }
        return null;
    }

    public Object getComponent(String componentName) {
        if (this.components == null) {
            return null;
        }
        Object comp = this.components.get(componentName);
        if (comp == null && this.xmlUI != null) {
            comp = this.xmlUI.getComponent(componentName);
        }
        return comp;
    }

    public static List getWindows() {
        return new ArrayList(allWindows);
    }

    public boolean hasViewManagers() {
        List viewManagers = this.getViewManagers();
        if (viewManagers != null) {
            return viewManagers.size() > 0;
        }
        return false;
    }

    public void setTheViewManagers(List value) {
        this.viewManagers = value;
    }

    public void addViewManager(ViewManager viewManager) {
        if (this.viewManagers == null) {
            this.viewManagers = new ArrayList();
        }
        if (!this.viewManagers.contains(viewManager)) {
            this.viewManagers.add(viewManager);
        }
    }

    public List getViewManagers() {
        ArrayList tmp = new ArrayList();
        if (this.viewManagers != null) {
            tmp.addAll(this.viewManagers);
        }
        if (this.persistentComponents != null) {
            Enumeration keys = this.persistentComponents.keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                Object obj = this.persistentComponents.get(key);
                if (!(obj instanceof IdvComponentGroup)) continue;
                ((IdvComponentGroup)obj).getViewManagers(tmp);
            }
        }
        return tmp;
    }

    public void setUniqueId(String value) {
        this.uniqueId = value;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public void setIsAMainWindow(boolean value) {
        this.isAMainWindow = value;
    }

    public boolean getIsAMainWindow() {
        return this.isAMainWindow;
    }

    public void showWaitCursor() {
        this.setCursor(Cursor.getPredefinedCursor(3));
    }

    public void showNormalCursor() {
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void setType(String value) {
        this.type = value;
    }

    public String getType() {
        return this.type;
    }

    public void setPersistentComponents(Hashtable value) {
        if (value == null) {
            this.persistentComponents = value;
            return;
        }
        this.persistentComponents = new Hashtable();
        this.persistentComponents.putAll(value);
    }

    public Hashtable getPersistentComponents() {
        return this.persistentComponents;
    }

    public static void enableFullScreenMode(Window window) {
        String className = "com.apple.eawt.FullScreenUtilities";
        String methodName = "setWindowCanFullScreen";
        try {
            Class<?> clazz = Class.forName(className);
            Method method = clazz.getMethod(methodName, Window.class, Boolean.TYPE);
            method.invoke(null, window, true);
        }
        catch (Throwable t) {
            LogUtil.printMessage("Full screen mode is not supported");
        }
    }

    static {
        allWindows = new ArrayList();
        mainWindows = new ArrayList();
    }
}

