/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.text.JTextComponent;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ucar.unidata.data.CompositeDataChoice;
import ucar.unidata.data.DataAlias;
import ucar.unidata.data.DataCategory;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataManager;
import ucar.unidata.data.DataOperand;
import ucar.unidata.data.DataSelection;
import ucar.unidata.data.DataSource;
import ucar.unidata.data.DataSourceDescriptor;
import ucar.unidata.data.DataSourceImpl;
import ucar.unidata.data.DataSourceResults;
import ucar.unidata.data.DerivedDataChoice;
import ucar.unidata.data.DescriptorDataSource;
import ucar.unidata.data.ListDataChoice;
import ucar.unidata.data.UserOperandValue;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.gis.maps.MapData;
import ucar.unidata.idv.ControlDescriptor;
import ucar.unidata.idv.DisplayControl;
import ucar.unidata.idv.History;
import ucar.unidata.idv.IdvConstants;
import ucar.unidata.idv.IdvManager;
import ucar.unidata.idv.IdvPreferenceManager;
import ucar.unidata.idv.IdvResourceManager;
import ucar.unidata.idv.IntegratedDataViewer;
import ucar.unidata.idv.LibVersionUtil;
import ucar.unidata.idv.MapViewManager;
import ucar.unidata.idv.SavedBundle;
import ucar.unidata.idv.TransectViewManager;
import ucar.unidata.idv.ViewDescriptor;
import ucar.unidata.idv.ViewManager;
import ucar.unidata.idv.ViewState;
import ucar.unidata.idv.control.DisplayControlImpl;
import ucar.unidata.idv.control.DisplaySettingsDialog;
import ucar.unidata.idv.control.MapDisplayControl;
import ucar.unidata.idv.ui.BundleTree;
import ucar.unidata.idv.ui.DataControlDialog;
import ucar.unidata.idv.ui.DataSelector;
import ucar.unidata.idv.ui.DataSourceHolder;
import ucar.unidata.idv.ui.DataTree;
import ucar.unidata.idv.ui.DataTreeDialog;
import ucar.unidata.idv.ui.IdvComponentGroup;
import ucar.unidata.idv.ui.IdvHelp;
import ucar.unidata.idv.ui.IdvSplash;
import ucar.unidata.idv.ui.IdvWindow;
import ucar.unidata.idv.ui.IdvXmlUi;
import ucar.unidata.idv.ui.ToolbarEditor;
import ucar.unidata.idv.ui.ViewPanel;
import ucar.unidata.idv.ui.ViewPanelImpl;
import ucar.unidata.idv.ui.WindowInfo;
import ucar.unidata.metdata.NamedStationTable;
import ucar.unidata.ui.ComponentHolder;
import ucar.unidata.ui.DateTimePicker;
import ucar.unidata.ui.FineLineBorder;
import ucar.unidata.ui.Help;
import ucar.unidata.ui.HelpTipDialog;
import ucar.unidata.ui.HttpFormEntry;
import ucar.unidata.ui.LatLonWidget;
import ucar.unidata.ui.MultiFrame;
import ucar.unidata.ui.RovingProgress;
import ucar.unidata.ui.Timeline;
import ucar.unidata.ui.XmlUi;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.MemoryMonitor;
import ucar.unidata.util.Misc;
import ucar.unidata.util.Msg;
import ucar.unidata.util.ObjectListener;
import ucar.unidata.util.PatternFileFilter;
import ucar.unidata.util.Removable;
import ucar.unidata.util.StringUtil;
import ucar.unidata.util.TwoFacedObject;
import ucar.unidata.util.WrapperException;
import ucar.unidata.xml.PreferenceManager;
import ucar.unidata.xml.XmlObjectStore;
import ucar.unidata.xml.XmlResourceCollection;
import ucar.unidata.xml.XmlUtil;
import ucar.visad.display.AnimationWidget;
import visad.DateTime;
import visad.georef.EarthLocation;
import visad.georef.LatLonPoint;

public class IdvUIManager
extends IdvManager {
    public static final String FIELDTYPE_TEXT = "text";
    public static final String FIELDTYPE_BOOLEAN = "boolean";
    public static final String FIELDTYPE_CHOICE = "choice";
    public static final String FIELDTYPE_FILE = "file";
    public static final String FIELDTYPE_LOCATION = "location";
    public static final String FIELDTYPE_AREA = "area";
    public static ImageIcon ICON_LOCK;
    public static ImageIcon ICON_UNLOCK;
    public static ImageIcon ICON_REMOVE;
    public static final String PROP_SUPPORT_PACKAGE = "idv.support.package";
    public static final String PROP_SUPPORT_MESSAGE = "idv.support.message";
    public static final String PROP_HELP_EMAIL = "idv.help.email";
    public static final String PROP_HELP_ORG = "idv.help.org";
    public static final String PROP_HELP_NAME = "idv.help.name";
    public static final String TAG_ACTION = "action";
    public static final String ATTR_ID = "id";
    public static final String ATTR_MAINWINDOW = "mainwindow";
    public static final String ATTR_DESCRIPTION = "description";
    public static final String ATTR_GROUP = "group";
    public static final String ATTR_ACTION = "action";
    public static final String ATTR_IMAGE = "image";
    public static final String COMP_FAVORITESBAR = "idv.favoritesbar";
    public static final String COMP_HELP = "idv.help";
    public static final String COMP_MENUBAR = "idv.menubar";
    public static final String COMP_TOOLBAR = "idv.toolbar";
    public static final String COMP_DATASELECTOR = "idv.dataselector";
    public static final String COMP_COMPONENT_GROUP = "idv.component.group";
    public static final String COMP_COMPONENT_CHOOSERS = "idv.component.choosers";
    public static final String COMP_COMPONENT_SKIN = "idv.component.skin";
    public static final String COMP_COMPONENT_HTML = "idv.component.html";
    public static final String COMP_MEMORYMONITOR_VIEW = "idv.memorymonitor.view";
    public static final String COMP_MEMORYMONITOR_DASH = "idv.memorymonitor.dashboard";
    public static final String COMP_WAITLABEL = "idv.waitlabel";
    public static final String COMP_STREAMINGLABEL = "idv.streaminglabel";
    public static final String COMP_READINGLABEL = "idv.readinglabel";
    public static final String COMP_PROGRESSBAR = "idv.progressbar";
    public static final String COMP_DATATREE = "idv.datatree";
    public static final String COMP_VIEWPANEL = "idv.viewpanel";
    public static final String COMP_MESSAGELOGGER = "idv.messagelogger";
    public static final String COMP_MESSAGELABEL = "idv.messagelabel";
    public static final String COMP_MAPVIEW = "idv.mapview";
    public static final String COMP_GLOBEVIEW = "idv.globeview";
    public static final String COMP_TRANSECTVIEW = "idv.transectview";
    public static final String COMP_VIEW = "idv.view";
    public static final String COMP_STATUSBAR = "idv.statusbar";
    public static final String COMP_CHOOSER = "chooser";
    public static final String COMP_CHOOSERS = "idv.choosers";
    public static final String MENU_DATA = "data";
    public static final String MENU_MAPS = "maps";
    public static final String MENU_SPECIAL = "special";
    public static final String MENU_LOCATIONS = "locations";
    public static final String MENU_HELP = "help";
    public static final String MENU_VIEW = "view";
    public static final String MENU_DELETEVIEWS = "edit.deleteviews";
    public static final String MENU_EDITFORMULAS = "edit.formulas";
    public static final String MENU_NEWVIEWS = "file.new.views";
    public static final String MENU_WINDOWS = "menu.windows";
    public static final String MENU_PUBLISH = "publish";
    public static final String MENU_PUBLISH_CONFIG = "publish.config";
    public static final String MENU_HISTORY = "menu.history";
    public static final String MENU_HISTORY_FILE = "menu.history.file";
    public static final String MENU_HISTORY_BUNDLE = "menu.history.bundle";
    public static final String MENU_DELETEHISTORY = "menu.deletehistory";
    public static final String MENU_DISPLAYS = "displays";
    public static final String MENU_NEWDISPLAY = "file.new.display";
    private boolean haveInitialized = false;
    private Hashtable fixedDataMenuItems = new Hashtable();
    private Hashtable bundleTrees = new Hashtable();
    private Object CURSOR_MUTEX = new Object();
    private IdvSplash splash;
    private Hashtable actionMap;
    private Hashtable menuIds;
    private Hashtable<String, ImageIcon> actionIcons;
    private List actionGroupList = new ArrayList();
    private Hashtable actionGroupMap = new Hashtable();
    private List actionList;
    private Hashtable operandCache;
    protected IdvWindow lastActiveFrame = null;
    private int waitCursorCount = 0;
    List dcdWindows = new ArrayList();
    private HelpTipDialog helpTipDialog;
    private List windowsToBeShown;
    List dataSourceHolders = new ArrayList();
    Hashtable dataSourceHolderWindows = new Hashtable();
    Hashtable defaultHolderBounds;
    private ToolbarEditor toolbarEditor;
    private ViewPanel viewPanel;
    private JDesktopPane desktopPane;
    private JFrame desktopFrame;
    private GraphicsDevice[] screens;
    private Rectangle[] screenRects;
    private GraphicsDevice defaultScreen;
    public static final String PREF_LightWeightPopupEnabled = "LightWeightPopupEnabled";
    public static final String MENU_BUNDLES = "bundles";
    public static long timeSinceLastWait;
    public static long startTime;
    private List haikus;
    private List haikuActions;
    private boolean haikuUserOk = true;

    public IdvUIManager(IntegratedDataViewer idv) {
        super(idv);
    }

    public void loadLookAndFeel() {
        String locale;
        String lookAndFeel;
        if (!GuiUtils.isMac() && (lookAndFeel = this.getStore().get("idv.ui.lookandfeel", (String)null)) != null) {
            try {
                UIManager.setLookAndFeel(lookAndFeel);
            }
            catch (Exception exc) {
                System.err.println("Unknown look and feel:" + lookAndFeel);
            }
        }
        if ((locale = this.getStore().get("Data.Locale", (String)null)) != null) {
            Locale.setDefault(Locale.US);
        }
    }

    public void init() {
        String tmpSize;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        try {
            this.screens = ge.getScreenDevices();
            int ns = this.screens.length;
            this.screenRects = new Rectangle[ns];
            for (int j = 0; j < ns; ++j) {
                GraphicsDevice screen = this.screens[j];
                this.screenRects[j] = screen.getDefaultConfiguration().getBounds();
            }
            this.defaultScreen = ge.getDefaultScreenDevice();
        }
        catch (HeadlessException ns) {
            // empty catch block
        }
        AnimationWidget.bigIcon = this.getProperty("idv.animation.bigicon", false);
        GuiUtils.setIconsInMenus(this.getIdv().getStateManager().getPreferenceOrProperty("idv.ui.iconsinmenus", "true").equals("true"));
        UIDefaults defaults = UIManager.getDefaults();
        JLabel tmp = new JLabel("");
        Object iconSize = this.getIdv().getStateManager().getPreferenceOrProperty("idv.ui.minimumiconsize");
        String fontSize = (String)this.getIdv().getStateManager().getPreferenceOrProperty("idv.ui.fontsize");
        if (fontSize != null && fontSize.trim().length() == 0) {
            fontSize = null;
        }
        if (iconSize != null && (tmpSize = iconSize.toString().trim()).length() > 0) {
            GuiUtils.setDefaultIconSize(new Integer(tmpSize));
        }
        if (fontSize != null) {
            String[] landf = new String[]{"Button", "ToggleButton", "RadioButton", "CheckBox", "Colorchooser", "ComboBox", "FileChooser", "FileView", "InternalFrame", "DesktopIcon", "Label", "List", "MenuBar", "MenuItem", "RadioButtonMenuItem", "CheckBoxMenuItem", "Menu", "PopupMenu", "OptionPane", "Panel", "ProgressBar", "Separator", "List", "ScrollPane", "Slider", "SplitPane", "TabbedPane", "Table", "TableHeader", "TextField", "PasswordField", "TextPane", "TextArea", "EditorPane", "TitledBorder", "Toolbar", "ToolTip", "tree"};
            int size = new Integer(fontSize);
            Font dfltFont = tmp.getFont().deriveFont((float)size);
            GuiUtils.setDefaultFont(dfltFont);
            for (int i = 0; i < landf.length; ++i) {
                defaults.put(landf[i] + ".font", dfltFont);
            }
            defaults.put("HONOR_DISPLAY_PROPERTIES", Boolean.TRUE);
        }
        if (this.getStateManager().getProperty("idv.ui.desktop", false)) {
            this.desktopPane = new JDesktopPane();
            this.desktopPane.setPreferredSize(new Dimension(700, 500));
            this.desktopFrame = new JFrame(this.getStateManager().getTitle());
            this.desktopFrame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    if (IdvUIManager.this.getIdv().quit()) {
                        // empty if block
                    }
                }
            });
            this.desktopFrame.getContentPane().add(this.desktopPane);
            this.desktopFrame.pack();
            this.desktopFrame.setLocation(new Point(50, 50));
            this.desktopFrame.setDefaultCloseOperation(0);
            MultiFrame.useDesktopPane(this.desktopPane);
        }
        if (!this.getArgsManager().isScriptingMode() && this.getIdv().getStateManager().getShowDashboardOnStart()) {
            this.showBasicWindow(true);
        }
    }

    public void doMakeInitialGui() {
        this.createNewWindow(new ArrayList(), false);
    }

    public void doMakeBasicWindows() {
        this.splashMsg("Creating User Interface");
        List<String> skins = this.getInitialSkins();
        for (int i = 0; i < skins.size(); ++i) {
            String skin = skins.get(i);
            try {
                this.createNewWindow(new ArrayList(), skin);
                continue;
            }
            catch (Throwable exc) {
                IdvUIManager.logException("Creating UI from skin:" + skin, exc);
            }
        }
    }

    public Object findComponent(String id) {
        List comps = this.findComponents(id);
        if (comps.size() > 0) {
            return comps.get(0);
        }
        return null;
    }

    public List getWindowGroup(Object group) {
        List groupList;
        ArrayList comps = new ArrayList();
        IdvWindow active = IdvWindow.getActiveWindow();
        if (active != null && (groupList = active.getGroup(group)) != null) {
            comps.addAll(groupList);
        }
        ArrayList windows = new ArrayList(IdvWindow.getWindows());
        for (int i = 0; i < windows.size(); ++i) {
            IdvWindow window = (IdvWindow)windows.get(i);
            if (active == window || (groupList = window.getGroup(group)) == null) continue;
            comps.addAll(groupList);
        }
        return comps;
    }

    public List getComponents() {
        List windowComps;
        ArrayList comps = new ArrayList();
        IdvWindow active = IdvWindow.getActiveWindow();
        if (active != null && (windowComps = active.getComponents()) != null) {
            comps.addAll(windowComps);
        }
        ArrayList windows = new ArrayList(IdvWindow.getWindows());
        for (int i = 0; i < windows.size(); ++i) {
            List windowComps2;
            IdvWindow window = (IdvWindow)windows.get(i);
            if (active == window || (windowComps2 = window.getComponents()) == null) continue;
            comps.addAll(windowComps2);
        }
        return comps;
    }

    private List findComponents(String id) {
        Object comp = null;
        ArrayList<Object> comps = new ArrayList<Object>();
        IdvWindow active = IdvWindow.getActiveWindow();
        if (active != null && (comp = IdvWindow.getActiveWindow().getComponent(id)) != null) {
            comps.add(comp);
            return comps;
        }
        ArrayList windows = new ArrayList(IdvWindow.getWindows());
        for (int i = 0; i < windows.size(); ++i) {
            IdvWindow window = (IdvWindow)windows.get(i);
            if (active == window || (comp = window.getComponent(id)) == null) continue;
            comps.add(comp);
        }
        return comps;
    }

    public GraphicsDevice getScreen(Point p) {
        if (p == null || this.screens == null) {
            return null;
        }
        GraphicsDevice screen = null;
        int n = this.screenRects.length;
        for (int i = 0; i < n; ++i) {
            if (!this.screenRects[i].contains(p)) continue;
            screen = this.screens[i];
            break;
        }
        return screen;
    }

    public void closeCurrentWindow() {
        IdvWindow window = IdvWindow.getActiveWindow();
        if (window != null) {
            window.doClose();
        }
    }

    public ViewPanel getViewPanel() {
        if (this.viewPanel == null) {
            this.viewPanel = this.doMakeViewPanel();
        }
        return this.viewPanel;
    }

    protected ViewPanel doMakeViewPanel() {
        ViewPanelImpl vp = new ViewPanelImpl(this.getIdv());
        vp.getContents();
        return vp;
    }

    public boolean handleSideLegend(ViewManager viewManager, JComponent sideLegend) {
        if (this.getArgsManager().getIsOffScreen()) {
            return false;
        }
        return false;
    }

    public void viewManagerAdded(ViewManager viewManager) {
        if (this.getArgsManager().getIsOffScreen()) {
            return;
        }
        if (this.getViewPanel() != null) {
            this.getViewPanel().viewManagerAdded(viewManager);
        }
    }

    public void viewManagerDestroyed(ViewManager viewManager) {
        if (this.getArgsManager().getIsOffScreen()) {
            return;
        }
        if (this.getViewPanel() != null) {
            this.getViewPanel().viewManagerDestroyed(viewManager);
        }
    }

    public void viewManagerActiveChanged(ViewManager viewManager) {
        if (this.getViewPanel() != null) {
            this.getViewPanel().viewManagerChanged(viewManager);
        }
    }

    public void viewManagerChanged(ViewManager viewManager) {
        if (this.getArgsManager().getIsOffScreen()) {
            return;
        }
        if (this.getViewPanel() != null) {
            this.getViewPanel().viewManagerChanged(viewManager);
        }
    }

    protected String getViewManagerTabLabel(ViewManager viewManager, JTabbedPane tabs) {
        String name = viewManager.getName();
        if (name == null || name.trim().length() == 0) {
            name = "View " + (tabs.getTabCount() + 1);
        }
        return name;
    }

    public void initDone() {
        if (this.haveInitialized) {
            return;
        }
        this.haveInitialized = true;
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        String ut = (String)this.getIdv().getStateManager().getPreferenceOrProperty(PREF_LightWeightPopupEnabled);
        if (ut != null && ut.equalsIgnoreCase("yes")) {
            ToolTipManager.sharedInstance().setLightWeightPopupEnabled(true);
        } else {
            ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
        }
        if (this.getIdv().getStateManager().getShowDashboardOnStart()) {
            // empty if block
        }
        if (!this.getArgsManager().getIsOffScreen() && IdvWindow.getMainWindows().size() == 0 && !this.getArgsManager().getNoGui()) {
            this.doMakeInitialGui();
        }
        this.splashClose();
        if (this.desktopFrame != null) {
            this.desktopFrame.setSize(new Dimension(700, 500));
            this.desktopFrame.setVisible(true);
        }
        if (this.windowsToBeShown != null) {
            for (int i = 0; i < this.windowsToBeShown.size(); ++i) {
                IdvWindow idvWindow = (IdvWindow)this.windowsToBeShown.get(i);
                idvWindow.setVisible(true);
                idvWindow.show();
            }
            this.windowsToBeShown = null;
        }
        List<ViewManager> vms = this.getVMManager().getViewManagers();
        for (int i = 0; i < vms.size(); ++i) {
            vms.get(i).guiInitializationDone();
        }
        this.showAllWindows();
        this.initHelpTips(true);
        GuiUtils.toFrontModalDialogs();
    }

    private void initActions() {
        if (this.actionMap != null) {
            return;
        }
        this.actionIcons = new Hashtable();
        this.actionMap = new Hashtable();
        this.actionList = new ArrayList();
        IdvResourceManager idvResourceManager = this.getResourceManager();
        this.getResourceManager();
        XmlResourceCollection xrc = idvResourceManager.getXmlResources(IdvResourceManager.RSC_ACTIONS);
        for (int i = 0; i < xrc.size(); ++i) {
            Element root = xrc.getRoot(i);
            if (root == null) continue;
            List children = XmlUtil.findChildren(root, "action");
            for (int actionIdx = 0; actionIdx < children.size(); ++actionIdx) {
                ImageIcon icon;
                Element actionNode = (Element)children.get(actionIdx);
                String id = XmlUtil.getAttribute(actionNode, ATTR_ID);
                this.actionMap.put(id, actionNode);
                this.actionList.add(id);
                String group = XmlUtil.getAttribute((Node)actionNode, ATTR_GROUP, "General");
                ArrayList<Element> groupList = (ArrayList<Element>)this.actionGroupMap.get(group);
                if (groupList == null) {
                    groupList = new ArrayList<Element>();
                    this.actionGroupMap.put(group, groupList);
                    this.actionGroupList.add(group);
                }
                groupList.add(actionNode);
                String image = XmlUtil.getAttribute((Node)actionNode, ATTR_IMAGE, (String)null);
                if (image == null || (icon = GuiUtils.getImageIcon(image, true)) == null) continue;
                this.actionIcons.put("action:" + id, icon);
            }
        }
    }

    public List makeActionMenu(Object object, String method, boolean makeCall) {
        ArrayList<JMenu> items = new ArrayList<JMenu>();
        for (int groupIdx = 0; groupIdx < this.actionGroupList.size(); ++groupIdx) {
            String group = (String)this.actionGroupList.get(groupIdx);
            List l = (List)this.actionGroupMap.get(group);
            ArrayList<JMenuItem> subItems = new ArrayList<JMenuItem>();
            for (int actionIdx = 0; actionIdx < l.size(); ++actionIdx) {
                Element node = (Element)l.get(actionIdx);
                String desc = XmlUtil.getAttribute((Node)node, ATTR_DESCRIPTION, (String)null);
                if (desc == null) continue;
                String action = XmlUtil.getAttribute(node, ATTR_ID);
                if (makeCall) {
                    action = "idv.handleAction('action:" + action + "')";
                }
                subItems.add(GuiUtils.makeMenuItem(desc, object, method, action));
            }
            items.add(GuiUtils.makeMenu(group, subItems));
        }
        return items;
    }

    public boolean isAction(String id) {
        return id.startsWith("action:");
    }

    public String stripAction(String id) {
        if (id.startsWith("action:")) {
            id = id.substring(7);
        }
        return id;
    }

    public Element getActionNode(String id) {
        this.initActions();
        return (Element)this.actionMap.get(this.stripAction(id));
    }

    public String getActionAttr(String id, String attr) {
        this.initActions();
        Element node = this.getActionNode(this.stripAction(id));
        if (node == null) {
            return null;
        }
        return XmlUtil.getAttribute((Node)node, attr, (String)null);
    }

    public String getAction(String id) {
        return this.getActionAttr(id, "action");
    }

    public String getActionImage(String id) {
        return this.getActionAttr(id, ATTR_IMAGE);
    }

    public String getActionDescription(String id) {
        return this.getActionAttr(id, ATTR_DESCRIPTION);
    }

    public List getActions() {
        this.initActions();
        return this.actionList;
    }

    public void showWindow(DisplayControl control, IdvWindow window) {
        if (this.getIdv().getHaveInitialized()) {
            window.setVisible(true);
        } else {
            if (this.windowsToBeShown == null) {
                this.windowsToBeShown = new ArrayList();
            }
            this.windowsToBeShown.add(window);
        }
    }

    public boolean isMac() {
        return GuiUtils.isMac();
    }

    public void initSplash() {
        if (this.getProperty("idv.splash.show", true) && !this.getArgsManager().getNoGui() && !this.getArgsManager().getIsOffScreen() && !this.getArgsManager().testMode) {
            this.splash = new IdvSplash(this.getIdv());
            this.splashMsg("Loading Programs");
        }
    }

    public int getWaitCursorCount() {
        return this.waitCursorCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void showWaitCursor() {
        Object object = this.CURSOR_MUTEX;
        synchronized (object) {
            ++this.waitCursorCount;
            if (this.waitCursorCount == 1) {
                long tmp;
                timeSinceLastWait = tmp = System.currentTimeMillis();
                this.setCursor(true, GuiUtils.waitCursor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void showNormalCursor() {
        Object object = this.CURSOR_MUTEX;
        synchronized (object) {
            this.waitCursorCount = Math.max(0, this.waitCursorCount - 1);
            if (this.waitCursorCount == 0) {
                long tmp;
                timeSinceLastWait = tmp = System.currentTimeMillis();
                this.setCursor(false, GuiUtils.normalCursor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearWaitCursor() {
        Object object = this.CURSOR_MUTEX;
        synchronized (object) {
            this.waitCursorCount = 0;
            this.setCursor(false, GuiUtils.normalCursor);
        }
    }

    public void startReading(Object source) {
    }

    public void stopReading(Object source) {
    }

    private void setCursor(boolean waiting, Cursor cursor) {
        Object window;
        int i;
        for (int i2 = 0; i2 < this.dcdWindows.size(); ++i2) {
            DataControlDialog dcd = (DataControlDialog)this.dcdWindows.get(i2);
            dcd.setCursor(cursor);
        }
        IdvWindow.setWaitState(waiting);
        ArrayList windows = new ArrayList(IdvWindow.getWindows());
        for (i = 0; i < windows.size(); ++i) {
            IdvWindow window2 = (IdvWindow)windows.get(i);
            try {
                window2.setCursor(cursor);
                if (waiting) {
                    window2.startWait();
                    continue;
                }
                window2.endWait();
                continue;
            }
            catch (Exception exc) {
                System.err.println("Error in setCursor-windows:" + exc);
                exc.printStackTrace();
            }
        }
        for (i = 0; i < this.dataSourceHolders.size(); ++i) {
            DataSourceHolder holder = (DataSourceHolder)this.dataSourceHolders.get(i);
            window = holder.getFrame();
            if (window == null) continue;
            try {
                ((MultiFrame)window).setCursor(cursor);
                continue;
            }
            catch (Exception exc) {
                System.err.println("Error in setCursor-data source holders:" + exc);
            }
        }
        List displayControls = this.getIdv().getDisplayControls();
        for (int i3 = 0; i3 < displayControls.size(); ++i3) {
            window = ((DisplayControl)displayControls.get(i3)).getWindow();
            if (window == null) continue;
            try {
                ((Window)window).setCursor(cursor);
                continue;
            }
            catch (Exception exc) {
                System.err.println("Error in setCursor-displays:" + exc);
            }
        }
    }

    public void showAllWindows() {
        ArrayList windows = new ArrayList(IdvWindow.getWindows());
        for (int i = 0; i < windows.size(); ++i) {
        }
        List displayControls = this.getIdv().getDisplayControls();
        for (int i = 0; i < displayControls.size(); ++i) {
            ((DisplayControl)displayControls.get(i)).toFront();
        }
    }

    public void toFrontMainWindows() {
        List mainWindows = IdvWindow.getMainWindows();
        for (int i = 0; i < mainWindows.size(); ++i) {
            ((IdvWindow)mainWindows.get(i)).show();
            ((IdvWindow)mainWindows.get(i)).toFront();
        }
    }

    private void associateWindowWithViewManagers(final IdvWindow window, List viewManagers) {
        window.setTheViewManagers(viewManagers);
        if (viewManagers.size() == 0) {
            return;
        }
        for (int i = 0; i < viewManagers.size(); ++i) {
            ViewManager viewManager = (ViewManager)viewManagers.get(i);
            viewManager.setWindow(window);
        }
        final WindowAdapter[] wa = new WindowAdapter[]{null};
        wa[0] = new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                if (IdvUIManager.this.lastActiveFrame == window) {
                    return;
                }
                if (window.getHasBeenDisposed()) {
                    return;
                }
                IdvUIManager.this.lastActiveFrame = window;
                if (!IdvUIManager.this.getStateManager().isLoadingXml() && IdvUIManager.this.getIdv().getHaveInitialized()) {
                    IdvUIManager.this.handleWindowActivated(window);
                }
            }

            @Override
            public void windowClosed(WindowEvent e) {
                IdvUIManager.this.removeWindow(window);
                window.removeWindowListener(wa[0]);
            }
        };
        window.addWindowListener(wa[0]);
    }

    public void resetLastActiveViewManager() {
        if (this.lastActiveFrame != null && this.lastActiveFrame.getViewManagers() != null && this.lastActiveFrame.getViewManagers().size() > 0) {
            this.handleWindowActivated(this.lastActiveFrame);
        } else {
            this.getVMManager().setLastActiveViewManager(null);
            List windows = IdvWindow.getMainWindows();
            for (int i = 0; i < windows.size(); ++i) {
                this.handleWindowActivated((IdvWindow)windows.get(i));
            }
        }
    }

    public void handleWindowActivated(IdvWindow window) {
        if (window.getHasBeenDisposed()) {
            return;
        }
        List viewManagers = window.getViewManagers();
        ViewManager viewManagerToMakeActive = null;
        long lastActivatedTime = -1L;
        for (int i = 0; i < viewManagers.size(); ++i) {
            ViewManager viewManager = (ViewManager)viewManagers.get(i);
            if (viewManager.getContents() == null || !viewManager.getContents().isVisible()) continue;
            this.lastActiveFrame = window;
            if (viewManager.getLastTimeActivated() <= lastActivatedTime) continue;
            viewManagerToMakeActive = viewManager;
            lastActivatedTime = viewManager.getLastTimeActivated();
        }
        if (viewManagerToMakeActive != null) {
            this.getVMManager().setLastActiveViewManager(viewManagerToMakeActive);
            return;
        }
        this.getVMManager().setLastActiveViewManager(null);
    }

    public void removeWindow(IdvWindow window) {
        if (this.lastActiveFrame == window) {
            this.lastActiveFrame = null;
            List list = IdvWindow.getMainWindows();
        }
        this.getVMManager().setLastActiveViewManager(this.getVMManager().getLastActiveViewManager());
        window.destroy();
    }

    public void updateHistoryLinks() {
    }

    public DataControlDialog addDCD(DataControlDialog dcd) {
        this.dcdWindows.add(dcd);
        return dcd;
    }

    public void removeDCD(DataControlDialog dcd) {
        this.dcdWindows.remove(dcd);
    }

    public void processDialog(DataControlDialog dcd) {
        DataChoice dataChoice = dcd.getDataChoice();
        DataSource dataSource = dcd.getDataSource();
        if (dataChoice != null) {
            Object[] selectedControls = dcd.getSelectedControls();
            for (int i = 0; i < selectedControls.length; ++i) {
                List tclist;
                ViewManager vm;
                ControlDescriptor cd = (ControlDescriptor)selectedControls[i];
                if (!dcd.getDataSelectionWidget().okToCreateTheDisplay(cd.doesLevels())) {
                    return;
                }
                DataSelection dataSelection = dcd.getDataSelectionWidget().createDataSelection(cd.doesLevels());
                Hashtable<String, List> props = new Hashtable<String, List>();
                List settings = dcd.getDataSelectionWidget().getSelectedSettings();
                if (settings != null && settings.size() > 0) {
                    props.put("initialSettings", settings);
                }
                if ((vm = this.getIdv().getViewManager()) != null && vm instanceof TransectViewManager && (tclist = vm.getVMManager().findTransectDrawingControls()).size() == 0) {
                    DisplayControl dc = this.getIdv().doMakeControl("transectdrawingcontrol");
                    List<ViewManager> vmList = vm.getVMManager().getViewManagers();
                    Boolean moved = false;
                    block1: for (int ii = 0; ii < vmList.size(); ++ii) {
                        ViewManager vm0 = vmList.get(ii);
                        if (!(vm0 instanceof TransectViewManager)) continue;
                        String grp0 = (String)vm0.getShareGroup();
                        if (!vm0.getShareViews() || grp0 == null) continue;
                        for (int j = 0; j < vmList.size(); ++j) {
                            String grp1;
                            ViewManager vm1 = vmList.get(j);
                            if (!(vm1 instanceof MapViewManager) || !grp0.equals(grp1 = (String)vm1.getShareGroup()) || j == ii) continue;
                            dc.moveTo(vm1);
                            moved = true;
                            continue block1;
                        }
                    }
                    if (!moved.booleanValue()) {
                        if (dc.getDefaultViewManager() != null) {
                            dc.moveTo(dc.getDefaultViewManager());
                        } else {
                            List<ViewManager> vms = vm.getVMManager().getViewManagers();
                            for (int ii = 0; ii < vms.size(); ++ii) {
                                ViewManager mvm = vms.get(ii);
                                if (!(mvm instanceof MapViewManager)) continue;
                                dc.moveTo(mvm);
                                break;
                            }
                        }
                    }
                }
                this.getIdv().doMakeControl(Misc.newList(dataChoice), cd, props, dataSelection);
            }
        } else if (dataSource != null) {
            dataSource.setDateTimeSelection(dcd.getDataSelectionWidget().getSelectedDateTimes());
            this.dataSourceTimeChanged(dataSource);
        }
    }

    protected void handleMenuSelected(String id, JMenu menu, IdvWindow idvWindow) {
        switch (id) {
            case "file.new": {
                if (idvWindow == null) {
                    return;
                }
                List<IdvComponentGroup> groups = idvWindow.getComponentGroups();
                if (groups.size() == 0) {
                    return;
                }
                for (int i = 0; i < menu.getItemCount(); ++i) {
                    JMenuItem mi = menu.getItem(i);
                    if (!mi.getLabel().startsWith("Group:")) continue;
                    menu.remove(mi);
                    break;
                }
                for (IdvComponentGroup group : groups) {
                    ArrayList items = new ArrayList();
                    group.getPopupMenuItems(items);
                    JMenu groupMenu = new JMenu("Group: " + group.getName());
                    GuiUtils.makeMenu(groupMenu, items);
                    menu.insert(groupMenu, 0);
                }
                break;
            }
            case "menu.windows": {
                menu.removeAll();
                this.makeWindowsMenu(menu, idvWindow);
                break;
            }
            case "file.newdata": 
            case "data.newdata": {
                menu.removeAll();
                GuiUtils.makeMenu(menu, this.getIdvChooserManager().makeChooserMenus(new ArrayList()));
                break;
            }
            case "data.special": {
                menu.removeAll();
                ArrayList<JMenuItem> menus = new ArrayList<JMenuItem>();
                for (DataSourceDescriptor descriptor : this.getDataManager().getStandaloneDescriptors()) {
                    menus.add(GuiUtils.makeMenuItem(descriptor.getLabel(), this.getIdv(), "makeDataSource", descriptor));
                }
                GuiUtils.makeMenu(menu, menus);
                break;
            }
            case "file.new.views": {
                menu.removeAll();
                this.makeViewStateMenu(menu);
                break;
            }
            case "menu.history": {
                this.historyMenuSelected(menu);
                break;
            }
            case "menu.history.file": {
                this.historyMenuSelected(menu);
                break;
            }
            case "menu.history.bundle": {
                this.historyMenuSelectedV(menu, "ucar.unidata.idv.FileHistory");
                break;
            }
            case "edit.formulas": {
                this.editFormulasMenuSelected(menu);
                break;
            }
            case "menu.deletehistory": {
                this.deleteHistoryMenuSelected(menu);
                break;
            }
            case "edit.deleteviews": {
                menu.removeAll();
                this.makeDeleteViewsMenu(menu);
                break;
            }
            case "displays": {
                menu.removeAll();
                this.initializeDisplayMenu(menu);
                break;
            }
            case "maps": {
                if (menu.getItemCount() != 0) break;
                this.processMapMenu(menu, false);
                break;
            }
            case "locations": {
                if (menu.getItemCount() != 0) break;
                Msg.addDontComponent(menu);
                this.processStationMenu(menu, false);
                break;
            }
            case "special": {
                if (menu.getItemCount() != 0) break;
                this.processStandAloneMenu(menu, false);
                break;
            }
            case "view": {
                break;
            }
            case "data": {
                this.updateDataMenu(menu);
                break;
            }
            case "bundles": {
                menu.removeAll();
                this.initializeBundleMenu(menu);
            }
        }
    }

    protected void handleMenuDeSelected(String id, JMenu menu, IdvWindow idvWindow) {
        switch (id) {
            case "displays": {
                menu.removeAll();
                break;
            }
            case "bundles": {
                menu.removeAll();
                break;
            }
            case "data": {
                menu.removeAll();
            }
        }
    }

    public Hashtable getMenuIds() {
        return this.menuIds;
    }

    public JMenuBar doMakeMenuBar() {
        return this.doMakeMenuBar(null);
    }

    public JMenuBar doMakeMenuBar(IdvWindow idvWindow) {
        JMenu publishMenu;
        JMenu newDisplayMenu;
        Hashtable menuMap;
        this.menuIds = menuMap = new Hashtable();
        JMenuBar menuBar = null;
        IdvResourceManager idvResourceManager = this.getResourceManager();
        this.getResourceManager();
        XmlResourceCollection xrc = idvResourceManager.getXmlResources(IdvResourceManager.RSC_MENUBAR);
        menuBar = new JMenuBar();
        this.initActions();
        for (int i = 0; i < xrc.size(); ++i) {
            GuiUtils.processXmlMenuBar(xrc.getRoot(i), menuBar, this.getIdv(), menuMap, this.actionIcons);
        }
        JMenu helpMenu = (JMenu)menuMap.get(MENU_HELP);
        if (helpMenu != null) {
            menuBar.remove(helpMenu);
            menuBar.add(helpMenu);
        }
        if ((newDisplayMenu = (JMenu)menuMap.get(MENU_NEWDISPLAY)) != null) {
            ActionListener listener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    IdvResourceManager idvResourceManager = IdvUIManager.this.getResourceManager();
                    IdvUIManager.this.getResourceManager();
                    XmlResourceCollection skins = idvResourceManager.getXmlResources(IdvResourceManager.RSC_SKIN);
                    int skinIndex = (Integer)ae.getSource();
                    IdvUIManager.this.createNewWindow(null, true, IdvUIManager.this.getWindowTitleFromSkin(skinIndex), skins.get(skinIndex).toString(), skins.getRoot(skinIndex, false), true, null);
                }
            };
            GuiUtils.makeMenu(newDisplayMenu, this.makeSkinMenuItems(listener, true, false));
        }
        if ((publishMenu = (JMenu)menuMap.get(MENU_PUBLISH)) != null) {
            if (!this.getPublishManager().isPublishingEnabled()) {
                publishMenu.getParent().remove(publishMenu);
            } else {
                this.getPublishManager().initMenu(publishMenu);
            }
        }
        Enumeration keys = menuMap.keys();
        while (keys.hasMoreElements()) {
            String menuId = (String)keys.nextElement();
            if (!(menuMap.get(menuId) instanceof JMenu)) continue;
            JMenu menu = (JMenu)menuMap.get(menuId);
            MyMenuListener menuListener = new MyMenuListener(this, idvWindow, menu, menuId);
            menu.addMenuListener(menuListener);
            if (idvWindow == null) continue;
            idvWindow.addRemovable(menuListener);
        }
        if (idvWindow != null) {
            idvWindow.setComponent(COMP_MENUBAR, menuBar);
        }
        return menuBar;
    }

    public void getComponentGroupMenuItems(final IdvComponentGroup group, List items) {
        ArrayList<JMenuItem> newItems = new ArrayList<JMenuItem>();
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                int skinIndex = (Integer)ae.getSource();
                group.makeSkin(skinIndex);
            }
        };
        List skinItems = this.getIdv().getIdvUIManager().makeSkinMenuItems(listener, false, true);
        if (skinItems.size() > 0) {
            newItems.add(GuiUtils.makeMenu("User Interface", skinItems));
        }
        newItems.add(GuiUtils.makeMenuItem("Tab Group", group, "makeNew", COMP_COMPONENT_GROUP));
        newItems.add(GuiUtils.makeMenuItem("Html Text", group, "makeNew", COMP_COMPONENT_HTML));
        items.add(GuiUtils.makeMenu("New", newItems));
        ArrayList<JMenuItem> importItems = new ArrayList<JMenuItem>();
        List<ViewManager> vms = this.getIdv().getVMManager().getViewManagers();
        for (int vmIdx = 0; vmIdx < vms.size(); ++vmIdx) {
            ViewManager vm = vms.get(vmIdx);
            ArrayList<Object> viewItems = new ArrayList<Object>();
            List displayControls = vm.getControls();
            for (int i = 0; i < displayControls.size(); ++i) {
                DisplayControlImpl dc = (DisplayControlImpl)displayControls.get(i);
                if (dc.getComponentHolder() != null && dc.getComponentHolder().getParent() == group) continue;
                if (viewItems.size() == 0 && displayControls.size() > 0) {
                    viewItems.add(GuiUtils.makeMenuItem("Import All", group, "importAllDisplayControls", displayControls));
                    viewItems.add("separator");
                }
                viewItems.add(GuiUtils.makeMenuItem(dc.getLabel(), group, "importDisplayControl", dc));
            }
            if (viewItems.size() <= 0) continue;
            String name = vm.getName();
            if (name == null || name.trim().length() == 0) {
                name = "View " + (vmIdx + 1);
            }
            importItems.add(GuiUtils.makeMenu(name, viewItems));
        }
        if (importItems.size() == 0) {
            importItems.add(new JMenuItem("No displays to import"));
        }
        items.add(GuiUtils.makeMenu("Import Display", importItems));
        items.add(GuiUtils.makeMenuItem("Write Skin", group, "writeSkin"));
        items.add("separator");
    }

    public List makeSkinMenuItems(final ActionListener listener, boolean onlyUI, boolean onlyEmbedded) {
        ArrayList<JMenuItem> items = new ArrayList<JMenuItem>();
        IdvResourceManager idvResourceManager = this.getResourceManager();
        this.getResourceManager();
        XmlResourceCollection skins = idvResourceManager.getXmlResources(IdvResourceManager.RSC_SKIN);
        Hashtable<String, JMenu> menus = new Hashtable<String, JMenu>();
        for (int i = 0; i < skins.size(); ++i) {
            Element root = skins.getRoot(i);
            if (root == null || (!onlyEmbedded ? onlyUI && !XmlUtil.getAttribute((Node)root, "forui", true) : !XmlUtil.getAttribute((Node)root, "embedded", false))) continue;
            if (Misc.equals(skins.getProperty("embedded", i), "true")) continue;
            final int skinIndex = i;
            List<String> names = StringUtil.split(skins.getShortName(i), ">", true, true);
            Container theMenu = null;
            String path = "";
            for (int nameIdx = 0; nameIdx < names.size() - 1; ++nameIdx) {
                String catName = names.get(nameIdx);
                JMenu tmpMenu = (JMenu)menus.get(path = path + ">" + catName);
                if (tmpMenu == null) {
                    tmpMenu = new JMenu(catName);
                    if (theMenu == null) {
                        items.add(tmpMenu);
                    } else {
                        theMenu.add(tmpMenu);
                    }
                    menus.put(path, tmpMenu);
                }
                theMenu = tmpMenu;
            }
            String name = names.get(names.size() - 1);
            JMenuItem mi = new JMenuItem(name);
            if (theMenu == null) {
                items.add(mi);
            } else {
                theMenu.add(mi);
            }
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    ActionEvent action = new ActionEvent(new Integer(skinIndex), 0, "");
                    listener.actionPerformed(action);
                }
            });
        }
        return items;
    }

    public String getSkinHtml() {
        int i;
        StringBuffer html = new StringBuffer("<html><body><h2>Create New Windows</h2><ul>");
        IdvResourceManager idvResourceManager = this.getResourceManager();
        this.getResourceManager();
        XmlResourceCollection skins = idvResourceManager.getXmlResources(IdvResourceManager.RSC_SKIN);
        ArrayList<String> cats = new ArrayList<String>();
        Hashtable<String, StringBuffer> buffs = new Hashtable<String, StringBuffer>();
        for (i = 0; i < skins.size(); ++i) {
            Element root = skins.getRoot(i);
            if (root == null || !XmlUtil.getAttribute((Node)root, "forui", true)) continue;
            String shortName = skins.getShortName(i);
            List<String> names = StringUtil.split(shortName, ">", true, true);
            String path = "";
            for (int nameIdx = 0; nameIdx < names.size() - 1; ++nameIdx) {
                String catName = names.get(nameIdx);
                if (path.length() > 0) {
                    path = path + "&gt;";
                }
                path = path + catName;
            }
            StringBuffer sb = (StringBuffer)buffs.get(path);
            if (sb == null) {
                sb = new StringBuffer();
                buffs.put(path, sb);
                cats.add(path);
            }
            String name = names.get(names.size() - 1);
            String action = "jython:idv.getIdvUIManager().loadSkinByIndex(" + i + ")";
            sb.append("<li> <A href=\"" + action + "\"> " + name + "</a>\n");
        }
        for (i = 0; i < cats.size(); ++i) {
            html.append("<li> " + cats.get(i) + " <ul style=\"margin-top:0;\">");
            html.append(buffs.get(cats.get(i)));
            html.append("</ul>");
        }
        return html.toString();
    }

    public void loadSkinByIndex(int skinIndex) {
        IdvResourceManager idvResourceManager = this.getResourceManager();
        this.getResourceManager();
        XmlResourceCollection skins = idvResourceManager.getXmlResources(IdvResourceManager.RSC_SKIN);
        Element root = skins.getRoot(skinIndex, false);
        this.createNewWindow(null, true, this.getWindowTitleFromSkin(skinIndex), skins.get(skinIndex).toString(), root, true, null);
    }

    public void makeWindowsMenu(JMenu menu, IdvWindow idvWindow) {
        IdvWindow activeWindow;
        IdvWindow idvWindow2 = activeWindow = idvWindow != null ? idvWindow : IdvWindow.getActiveWindow();
        if (activeWindow != null) {
            this.makeWindowMenu(activeWindow, menu);
        }
        List windows = IdvWindow.getWindows();
        for (int i = 0; i < windows.size(); ++i) {
            IdvWindow window = (IdvWindow)windows.get(i);
            if (window == activeWindow) continue;
            this.makeWindowMenu(window, menu);
        }
    }

    protected void makeWindowMenu(IdvWindow window, JMenu menu) {
        Hashtable components = window.getPersistentComponents();
        if (components.size() > 0) {
            ArrayList<JMenuItem> subItems = new ArrayList<JMenuItem>();
            subItems.add(GuiUtils.makeMenuItem("Show", window, "show"));
            Enumeration keys = components.keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                ComponentHolder comp = (ComponentHolder)components.get(key);
                subItems.add(GuiUtils.makeMenuItem("Edit Component: " + comp.getName(), comp, "showProperties"));
            }
            menu.add(GuiUtils.makeMenu(window.getTitle(), subItems));
        } else {
            menu.add(GuiUtils.makeMenuItem(window.getTitle(), window, "show"));
        }
    }

    public void makeViewStateMenu(JMenu menu) {
        this.makeViewStateMenu(menu, null);
    }

    public void makeViewStateMenu(JMenu menu, final ViewManager vm) {
        List vms = this.getVMManager().getVMState();
        if (vms.size() == 0) {
            menu.add(new JMenuItem(Msg.msg("No Saved Viewpoints")));
        } else {
            JMenu deleteMenu = new JMenu("Delete");
            menu.add(deleteMenu);
            this.makeDeleteViewsMenu(deleteMenu);
        }
        for (int i = 0; i < vms.size(); ++i) {
            Object vpObject = vms.get(i);
            TwoFacedObject tfo = null;
            if (vpObject instanceof TwoFacedObject) {
                tfo = (TwoFacedObject)vpObject;
                ViewManager that = (ViewManager)tfo.getId();
                if (!vm.isCompatibleWith(that)) {
                    continue;
                }
            } else if (vpObject instanceof ViewState) {
                if (!vm.isCompatibleWith((ViewState)vpObject)) continue;
                tfo = new TwoFacedObject((Object)((ViewState)vpObject).getName(), vpObject);
            }
            JMenuItem mi = new JMenuItem(tfo.getLabel().toString());
            menu.add(mi);
            mi.addActionListener(new ObjectListener(tfo.getId()){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    if (vm == null) {
                        ViewManager viewManager = (ViewManager)this.theObject;
                    } else if (this.theObject instanceof ViewManager) {
                        vm.initWith((ViewManager)this.theObject, true);
                    } else if (this.theObject instanceof ViewState) {
                        try {
                            vm.initWith((ViewState)this.theObject);
                        }
                        catch (Throwable exc) {
                            IdvManager.logException("Initializing viewpoint", exc);
                        }
                    }
                }
            });
        }
    }

    public void makeDeleteViewsMenu(JMenu menu) {
        List vms = this.getVMManager().getVMState();
        if (vms.size() == 0) {
            menu.add(new JMenuItem(Msg.msg("No Saved Views")));
        }
        for (int i = 0; i < vms.size(); ++i) {
            String label = "";
            Object o = vms.get(i);
            if (o instanceof TwoFacedObject) {
                label = ((TwoFacedObject)o).getLabel().toString();
            } else if (o instanceof ViewState) {
                ViewState viewState = (ViewState)o;
                if (!viewState.getIsLocal()) continue;
                label = viewState.getName();
            }
            JMenuItem mi = new JMenuItem("Delete " + label);
            menu.add(mi);
            mi.addActionListener(new ObjectListener(o){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    if (!GuiUtils.askYesNo("Delete Saved View", "Are you sure you want to delete the saved view: " + this.theObject + " ?")) {
                        return;
                    }
                    IdvUIManager.this.getIdv().getVMManager().getVMState().remove(this.theObject);
                    IdvUIManager.this.getIdv().getVMManager().writeVMState();
                }
            });
        }
    }

    public void editDisplaySettings() {
        DisplaySettingsDialog dsd = new DisplaySettingsDialog(this.getIdv());
    }

    public void editFormulasMenuSelected(JMenu menu) {
        menu.removeAll();
        GuiUtils.makeMenu(menu, this.getJythonManager().doMakeEditMenuItems());
    }

    public void historyMenuSelected(JMenu fileMenu) {
        fileMenu.removeAll();
        List historyList = this.getIdv().getHistory();
        if (historyList != null && historyList.size() > 0) {
            for (int i = 0; i < historyList.size(); ++i) {
                JMenuItem mi;
                History history = (History)historyList.get(i);
                if (history.toString().length() <= 40) {
                    mi = new JMenuItem(history.toString());
                } else {
                    mi = new JMenuItem(history.toString().substring(0, 39) + "...");
                    mi.setToolTipText(history.toString());
                }
                fileMenu.add(mi);
                mi.addActionListener(new ObjectListener(history){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        Misc.run(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    IdvUIManager.this.showWaitCursor();
                                    ((History)theObject).process(IdvUIManager.this.getIdv());
                                    IdvUIManager.this.showNormalCursor();
                                }
                                catch (Throwable exc) {
                                    IdvManager.logException("Creating data source from history", exc);
                                }
                            }
                        });
                    }
                });
            }
        } else {
            fileMenu.add(new JMenuItem("No Files"));
        }
    }

    public void historyMenuSelectedV(JMenu fileMenu, String type) {
        fileMenu.removeAll();
        List historyList = this.getIdv().getHistory();
        if (historyList != null && historyList.size() > 0) {
            for (int i = 0; i < historyList.size(); ++i) {
                JMenuItem mi;
                History history = (History)historyList.get(i);
                if (!history.getClass().toString().contains(type)) continue;
                if (history.toString().length() <= 40) {
                    mi = new JMenuItem(history.toString());
                } else {
                    mi = new JMenuItem(history.toString().substring(0, 39) + "...");
                    mi.setToolTipText(history.toString());
                }
                fileMenu.add(mi);
                mi.addActionListener(new ObjectListener(history){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        Misc.run(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    IdvUIManager.this.showWaitCursor();
                                    ((History)theObject).process(IdvUIManager.this.getIdv());
                                    IdvUIManager.this.showNormalCursor();
                                }
                                catch (Throwable exc) {
                                    IdvManager.logException("Creating data source from history", exc);
                                }
                            }
                        });
                    }
                });
            }
        } else {
            fileMenu.add(new JMenuItem("No Files"));
        }
    }

    private void updateDataMenu(JMenu dataMenu) {
        JMenu currentDataSourcesMenu;
        boolean makeNewMenu;
        int i;
        JMenu fixedMenu = null;
        ArrayList<Component> fixedComps = (ArrayList<Component>)this.fixedDataMenuItems.get(dataMenu);
        if (fixedComps == null) {
            fixedComps = new ArrayList<Component>();
            for (i = 0; i < dataMenu.getMenuComponentCount(); ++i) {
                fixedComps.add(dataMenu.getMenuComponent(i));
            }
            this.fixedDataMenuItems.put(dataMenu, fixedComps);
        } else {
            dataMenu.removeAll();
            for (i = 0; i < fixedComps.size(); ++i) {
                dataMenu.add((Component)fixedComps.get(i));
            }
        }
        fixedMenu = this.getIdv().getIdvChooserManager().addUserChooserToMenu(dataMenu, fixedMenu);
        this.processBundleMenu(dataMenu, 2);
        ArrayList<DescriptorDataSource> dataSources = new ArrayList<DescriptorDataSource>(this.getIdv().getDataSources());
        if (this.getIdv().getJythonManager().getDescriptorDataSource() != null) {
            dataSources.add(0, this.getIdv().getJythonManager().getDescriptorDataSource());
        }
        boolean bl = makeNewMenu = dataSources.size() > 10;
        if (makeNewMenu) {
            currentDataSourcesMenu = new JMenu("Current Data Sources");
            dataMenu.add(currentDataSourcesMenu);
        } else {
            currentDataSourcesMenu = dataMenu;
        }
        for (int i2 = 0; i2 < dataSources.size(); ++i2) {
            DataSource dataSource = (DataSource)dataSources.get(i2);
            JMenu dataSourceMenu = new JMenu(DataSelector.getNameForDataSource(dataSource));
            dataSourceMenu.setToolTipText(dataSource.toString());
            currentDataSourcesMenu.add(dataSourceMenu);
            JMenu editMenu = GuiUtils.makeMenu("Edit", this.doMakeDataSourceMenuItems(dataSource, null));
            dataSourceMenu.add(editMenu);
            dataSourceMenu.addSeparator();
            this.addChoicesToMenu(dataSource, dataSourceMenu, dataMenu);
        }
        if (makeNewMenu) {
            GuiUtils.limitMenuSize(currentDataSourcesMenu, "Data Sources ", 20, false);
        }
    }

    public void deleteHistoryMenuSelected(JMenu fileMenu) {
        fileMenu.removeAll();
        List historyList = this.getIdv().getHistory();
        if (historyList != null && historyList.size() > 0) {
            JMenuItem mi = new JMenuItem("Remove All");
            fileMenu.add(mi);
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    IdvUIManager.this.getIdv().clearHistoryList();
                }
            });
            fileMenu.addSeparator();
            for (int i = 0; i < historyList.size(); ++i) {
                Object history = historyList.get(i);
                JMenu menu = new JMenu(history.toString());
                fileMenu.add(menu);
                mi = new JMenuItem("Remove");
                menu.add(mi);
                mi.addActionListener(new ObjectListener(new Integer(i)){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        int index = (Integer)this.theObject;
                        List historyList = IdvUIManager.this.getIdv().getHistory();
                        historyList.remove(index);
                        IdvUIManager.this.getIdv().writeHistoryList();
                    }
                });
                mi = new JMenuItem("Set Alias");
                menu.add(mi);
                mi.addActionListener(new ObjectListener(history){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        IdvUIManager.this.getIdv().getHistory();
                        History history = (History)this.theObject;
                        String alias = GuiUtils.getInput(" ", "Alias: ", history.getAlias());
                        if (alias != null) {
                            history.setAlias(alias);
                        }
                        IdvUIManager.this.getIdv().writeHistoryList();
                    }
                });
            }
        } else {
            fileMenu.add(new JMenuItem("No History"));
        }
    }

    public void addChoicesToMenu(DataSource dataSource, JMenu dataSourceMenu, JMenu dataMenu) {
        List choices = dataSource.getDataChoices();
        Hashtable<String, JMenu> catToMenu = new Hashtable<String, JMenu>();
        for (int i = 0; i < choices.size(); ++i) {
            DataChoice choice = (DataChoice)choices.get(i);
            if (!choice.getForUser()) continue;
            JMenu parent = dataSourceMenu;
            String catPath = null;
            for (DataCategory topCategory = choice.getDisplayCategory(); topCategory != null; topCategory = topCategory.getChild()) {
                String catName = topCategory.getName();
                if (catName.equals("skip")) continue;
                JMenu nextMenu = (JMenu)catToMenu.get(catPath = catPath == null ? catName : catPath + "." + catName);
                if (nextMenu == null) {
                    nextMenu = new JMenu(catName);
                    parent.add(nextMenu);
                    catToMenu.put(catPath, nextMenu);
                }
                parent = nextMenu;
            }
            this.createDataChoiceMenuItem(choice, parent, dataMenu);
        }
    }

    public void createDataChoiceMenuItem(DataChoice choice, JMenu parentMenu, final JMenu dataMenu) {
        boolean showIcons = this.getIdv().getProperty("idv.ui.datatree.showicons", true);
        boolean isComposite = choice instanceof CompositeDataChoice;
        boolean isDerived = choice instanceof DerivedDataChoice;
        ImageIcon icon = null;
        if (showIcons) {
            if (isDerived) {
                icon = DataTree.getDerivedIcon();
            } else {
                String iconPath = choice.getProperty("prop.icon", null);
                if (iconPath != null) {
                    icon = GuiUtils.getImageIcon(iconPath, true);
                }
            }
        }
        JMenuItem choiceMenuItem = icon != null ? new JMenuItem(choice.toString(), icon) : new JMenuItem(choice.toString());
        choiceMenuItem.addActionListener(new ObjectListener(choice){

            @Override
            public void actionPerformed(ActionEvent e) {
                Point loc = dataMenu.getLocationOnScreen();
                new DataControlDialog(IdvUIManager.this.getIdv(), (DataChoice)this.theObject, loc.x, loc.y);
            }
        });
        int itemCount = parentMenu.getItemCount();
        while (itemCount > 15) {
            JMenu moreMenu = null;
            for (int itemIdx = 0; moreMenu == null && itemIdx < itemCount; ++itemIdx) {
                JMenuItem item = parentMenu.getItem(itemIdx);
                if (item == null || !item.getText().equals("More") || !(item instanceof JMenu)) continue;
                moreMenu = (JMenu)item;
            }
            if (moreMenu == null) {
                moreMenu = new JMenu("More");
                parentMenu.add(moreMenu);
            }
            parentMenu = moreMenu;
            itemCount = parentMenu.getItemCount();
        }
        parentMenu.add(choiceMenuItem);
        if (isComposite) {
            JMenu compositeMenu = new JMenu("Sub: " + choice.toString());
            parentMenu.add(compositeMenu);
            List children = ((CompositeDataChoice)choice).getDataChoices();
            for (int i = 0; i < children.size(); ++i) {
                DataChoice theChild = (DataChoice)children.get(i);
                this.createDataChoiceMenuItem(theChild, compositeMenu, dataMenu);
            }
        }
    }

    public void processBundle(SavedBundle bundle) {
        this.showWaitCursor();
        LogUtil.message("Loading bundle: " + bundle.getName());
        boolean ok = this.getPersistenceManager().decodeXmlFile(bundle.getUrl(), bundle.getName(), bundle.getType() == 0);
        if (ok && bundle.getType() == 2) {
            this.showDataSelector();
        }
        LogUtil.message("");
        this.showNormalCursor();
    }

    protected void processBundleMenu(JMenu displayMenu, final int bundleType) {
        List<SavedBundle> bundles = this.getPersistenceManager().getBundles(bundleType);
        if (bundles.size() == 0) {
            return;
        }
        String title = this.getPersistenceManager().getBundleTitle(bundleType);
        String bundleDir = this.getPersistenceManager().getBundleDirectory(bundleType);
        JMenu bundleMenu = new JMenu(title);
        bundleMenu.setMnemonic(GuiUtils.charToKeyCode(title));
        JMenuItem mi = new JMenuItem("Manage...");
        mi.setMnemonic(GuiUtils.charToKeyCode("M"));
        if (bundleType == 2) {
            this.getPersistenceManager().initBundleMenu(bundleType, bundleMenu);
            bundleMenu.add(mi);
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    IdvUIManager.this.showBundleDialog(bundleType);
                }
            });
            bundleMenu.addSeparator();
            displayMenu.add(bundleMenu);
        } else {
            displayMenu.add(bundleMenu);
            this.getPersistenceManager().initBundleMenu(bundleType, bundleMenu);
            displayMenu.add(mi);
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    IdvUIManager.this.showBundleDialog(bundleType);
                }
            });
            displayMenu.addSeparator();
        }
        Hashtable<String, JMenu> catMenus = new Hashtable<String, JMenu>();
        for (int i = 0; i < bundles.size(); ++i) {
            SavedBundle bundle = bundles.get(i);
            List categories = bundle.getCategories();
            JMenu catMenu = bundleType == 2 ? bundleMenu : displayMenu;
            String mainCategory = "";
            for (int catIdx = 0; catIdx < categories.size(); ++catIdx) {
                String category = (String)categories.get(catIdx);
                JMenu tmpMenu = (JMenu)catMenus.get(mainCategory = mainCategory + "." + category);
                if (tmpMenu == null) {
                    tmpMenu = new JMenu(category);
                    catMenu.add(tmpMenu);
                    catMenus.put(mainCategory, tmpMenu);
                }
                catMenu = tmpMenu;
            }
            final SavedBundle theBundle = bundle;
            mi = new JMenuItem(bundle.getName());
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    Misc.run(IdvUIManager.this, "processBundle", theBundle);
                }
            });
            catMenu.add(mi);
        }
    }

    protected void processMapMenu(JMenu displayMenu, boolean makeNew) {
        JMenu mapMenu;
        if (makeNew) {
            mapMenu = new JMenu("Maps and Backgrounds");
            GuiUtils.setIcon(mapMenu, "/auxdata/ui/icons/map.png");
            displayMenu.add(mapMenu);
        } else {
            mapMenu = displayMenu;
        }
        List<MapData> maps = this.getResourceManager().getMaps();
        JMenuItem mi = new JMenuItem("Add Your Own Map...");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                IdvUIManager.this.addMap(null);
            }
        });
        mapMenu.add(mi);
        mi = new JMenuItem("Add Default Maps");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                IdvUIManager.this.addDefaultMap();
            }
        });
        mapMenu.add(mi);
        JMenu systemMenu = new JMenu("Add System Map");
        mapMenu.add(systemMenu);
        for (int i = 0; i < maps.size(); ++i) {
            final MapData mapData = maps.get(i);
            mi = new JMenuItem(mapData.getDescription());
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    IdvUIManager.this.addMap(mapData);
                }
            });
            systemMenu.add(mi);
        }
        GuiUtils.limitMenuSize(systemMenu, "Maps ", 20);
        mi = new JMenuItem("Add Background Image");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                IdvUIManager.this.getIdv().doMakeBackgroundImage();
            }
        });
        mapMenu.add(mi);
    }

    protected void processStationMenu(JMenu displayMenu, boolean makeNew) {
        ControlDescriptor locationDescriptor = this.getIdv().getControlDescriptor("locationcontrol");
        if (locationDescriptor == null) {
            return;
        }
        List<JMenuItem> stationMenuItems = null;
        if (stationMenuItems == null) {
            List stations = this.getIdv().getLocationList();
            ObjectListener listener = new ObjectListener(locationDescriptor){

                @Override
                public void actionPerformed(ActionEvent ae, Object obj) {
                    IdvUIManager.this.addStationDisplay((NamedStationTable)obj, (ControlDescriptor)this.theObject);
                }
            };
            stationMenuItems = NamedStationTable.makeMenuItems(stations, listener);
        }
        if (makeNew) {
            displayMenu.add(GuiUtils.setIcon(GuiUtils.makeMenu("Locations", stationMenuItems), "/auxdata/ui/icons/world_loc.png"));
        } else {
            GuiUtils.makeMenu(displayMenu, stationMenuItems);
        }
    }

    public List getStandAloneControlDescriptors() {
        ArrayList<ControlDescriptor> result = new ArrayList<ControlDescriptor>();
        List controlDescriptors = this.getIdv().getControlDescriptors();
        for (int i = 0; i < controlDescriptors.size(); ++i) {
            ControlDescriptor cd = (ControlDescriptor)controlDescriptors.get(i);
            if (!cd.canStandAlone()) continue;
            result.add(cd);
        }
        return result;
    }

    protected void processStandAloneMenu(JMenu displayMenu, boolean makeNew) {
        JMenu standAloneMenu;
        if (makeNew) {
            standAloneMenu = new JMenu("Special");
            displayMenu.add(standAloneMenu);
        } else {
            standAloneMenu = displayMenu;
        }
        List controlDescriptors = this.getStandAloneControlDescriptors();
        for (int i = 0; i < controlDescriptors.size(); ++i) {
            ControlDescriptor cd = (ControlDescriptor)controlDescriptors.get(i);
            JMenuItem mi = new JMenuItem(cd.getLabel());
            String icon = cd.getIcon();
            if (icon != null) {
                GuiUtils.setIcon(mi, icon);
            }
            mi.addActionListener(new ObjectListener(cd){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    IdvUIManager.this.getIdv().doMakeControl(new ArrayList(), (ControlDescriptor)this.theObject);
                }
            });
            standAloneMenu.add(mi);
        }
    }

    protected void processInstanceMenu(JMenu displayMenu) {
        List displayControls = this.getIdv().getDisplayControls();
        displayMenu.addSeparator();
        JMenu viewMenu = new JMenu("Current View");
        this.initializeViewMenu(viewMenu);
        displayMenu.add(viewMenu);
        JMenu instanceMenu = null;
        for (int i = 0; i < displayControls.size(); ++i) {
            DisplayControl c = (DisplayControl)displayControls.get(i);
            JMenuItem mi = new JMenuItem(c.getMenuLabel());
            mi.addActionListener(new ObjectListener(c){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    ((DisplayControl)this.theObject).show();
                    ((DisplayControl)this.theObject).toFront();
                }
            });
            if (instanceMenu == null) {
                instanceMenu = new JMenu("Current Displays");
                displayMenu.add(instanceMenu);
            }
            instanceMenu.add(mi);
        }
    }

    protected void initializeViewMenu(JMenu viewMenu) {
        ViewManager vm = this.getIdv().getVMManager().getLastActiveViewManager();
        if (vm == null) {
            viewMenu.add(new JMenuItem("No active views"));
            return;
        }
        ArrayList menus = vm.doMakeMenuList();
        for (int i = 0; i < menus.size(); ++i) {
            viewMenu.add((JMenuItem)menus.get(i));
        }
    }

    protected void initializeDisplayMenu(JMenu displayMenu) {
        this.processMapMenu(displayMenu, true);
        this.processStationMenu(displayMenu, true);
        this.processStandAloneMenu(displayMenu, true);
        this.processInstanceMenu(displayMenu);
        Msg.translateTree(displayMenu);
    }

    protected void initializeBundleMenu(JMenu bundleMenu) {
        this.processBundleMenu(bundleMenu, 0);
        this.processBundleMenu(bundleMenu, 1);
        Msg.translateTree(bundleMenu);
    }

    public void showBundleDialog() {
        this.showBundleDialog(0);
    }

    public void showBundleDialog(int bundleType) {
        Integer key = new Integer(bundleType);
        BundleTree tree = (BundleTree)this.bundleTrees.get(key);
        if (tree == null) {
            tree = new BundleTree(this, bundleType);
            this.bundleTrees.put(key, tree);
        }
        tree.setVisible(true);
    }

    public void displayTemplatesChanged() {
        this.displayControlsChanged();
        for (int i = 0; i < this.dataSourceHolders.size(); ++i) {
            ((DataSourceHolder)this.dataSourceHolders.get(i)).displayTemplatesChanged();
        }
        this.updateToolbars();
        Enumeration keys = this.bundleTrees.keys();
        while (keys.hasMoreElements()) {
            ((BundleTree)this.bundleTrees.get(keys.nextElement())).loadBundles();
        }
    }

    public void favoriteBundlesChanged() {
        this.updateToolbars();
        Enumeration keys = this.bundleTrees.keys();
        while (keys.hasMoreElements()) {
            ((BundleTree)this.bundleTrees.get(keys.nextElement())).loadBundles();
        }
    }

    public void displayControlsChanged() {
    }

    public void displayControlChanged(DisplayControl displayControl) {
        if (this.getViewPanel() != null) {
            this.getViewPanel().displayControlChanged(displayControl);
        }
    }

    private void addToMenu(JComponent menu, JMenuItem mi) {
        if (menu instanceof JPopupMenu) {
            ((JPopupMenu)menu).add(mi);
        } else {
            ((JMenu)menu).add(mi);
        }
    }

    private void updateToolbars() {
        ImageIcon fileIcon = GuiUtils.scaleImageIcon(GuiUtils.getImageIcon("/auxdata/ui/icons/page.png"));
        ImageIcon catIcon = GuiUtils.scaleImageIcon(GuiUtils.getImageIcon("/auxdata/ui/icons/folder.png"));
        List windows = IdvWindow.getWindows();
        List<SavedBundle> bundles = this.getPersistenceManager().getBundles(0);
        ArrayList<SavedBundle> toolbarBundles = new ArrayList<SavedBundle>();
        for (int bundleIdx = 0; bundleIdx < bundles.size(); ++bundleIdx) {
            SavedBundle bundle = bundles.get(bundleIdx);
            if (bundle.getCategories().size() == 0 || !bundle.getCategories().get(0).equals("Toolbar")) continue;
            toolbarBundles.add(bundle);
        }
        ImageIcon separatorIcon = GuiUtils.getImageIcon("/auxdata/ui/icons/Separator.gif");
        for (int i = 0; i < windows.size(); ++i) {
            JPanel toolbar = (JPanel)((IdvWindow)windows.get(i)).getComponent(COMP_FAVORITESBAR);
            if (toolbar == null) continue;
            toolbar.removeAll();
            boolean wasVisible = toolbar.isVisible();
            if (wasVisible) {
                toolbar.setVisible(false);
            }
            ArrayList<JComponent> comps = new ArrayList<JComponent>();
            Hashtable<String, JComponent> menus = new Hashtable<String, JComponent>();
            for (int bundleIdx = 0; bundleIdx < toolbarBundles.size(); ++bundleIdx) {
                final SavedBundle bundle = (SavedBundle)toolbarBundles.get(bundleIdx);
                List categories = bundle.getCategories();
                ActionListener listener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        IdvUIManager.this.getPersistenceManager().open(bundle);
                    }
                };
                if (comps.size() == 0) {
                    comps.add(new JLabel(separatorIcon));
                }
                if (categories.size() == 1) {
                    JButton btn = new JButton(bundle.getName(), fileIcon);
                    btn.setContentAreaFilled(false);
                    GuiUtils.makeMouseOverBorder(btn);
                    btn.setToolTipText("Click to open favorite: " + bundle.getName());
                    btn.addActionListener(listener);
                    comps.add(GuiUtils.inset((Component)btn, 2));
                    continue;
                }
                String catSoFar = "";
                JComponent parentMenu = null;
                for (int catIdx = 1; catIdx < categories.size(); ++catIdx) {
                    String category = categories.get(catIdx).toString();
                    JComponent catMenu = (JComponent)menus.get(catSoFar = catSoFar + "-" + category);
                    if (catMenu != null) {
                        parentMenu = catMenu;
                        continue;
                    }
                    catMenu = parentMenu != null ? new JMenu(category) : new JPopupMenu();
                    menus.put(catSoFar, catMenu);
                    if (parentMenu != null) {
                        this.addToMenu(parentMenu, (JMenuItem)catMenu);
                    } else {
                        final JPopupMenu popup = (JPopupMenu)catMenu;
                        final JButton b = new JButton(category, catIcon);
                        b.setContentAreaFilled(false);
                        b.setToolTipText("Click to show favorites category: " + category);
                        GuiUtils.makeMouseOverBorder(b);
                        b.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent ae) {
                                popup.show(b, 0, b.getHeight());
                            }
                        });
                        comps.add(GuiUtils.inset((Component)b, 2));
                    }
                    parentMenu = catMenu;
                }
                if (parentMenu == null) continue;
                JMenuItem mi = new JMenuItem(bundle.getName(), fileIcon);
                mi.setToolTipText("Click to open favorite: " + bundle.getName());
                mi.addActionListener(listener);
                this.addToMenu(parentMenu, mi);
            }
            if (comps.size() > 1) {
                toolbar.setLayout(new BorderLayout());
                toolbar.add((Component)GuiUtils.inset((Component)GuiUtils.hbox(comps, 4), new Insets(4, 0, 0, 0)), "West");
                toolbar.setVisible(wasVisible);
            }
            toolbar.validate();
        }
    }

    private void addDefaultMap() {
        ControlDescriptor mapDescriptor = this.getIdv().getControlDescriptor("mapdisplay");
        if (mapDescriptor == null) {
            return;
        }
        String attrs = "initializeAsDefault=true;displayName=Default Background Maps;";
        this.getIdv().doMakeControl(new ArrayList(), mapDescriptor, attrs, null);
    }

    private void addMap(MapData mapData) {
        ControlDescriptor mapDescriptor = this.getIdv().getControlDescriptor("mapdisplay");
        if (mapDescriptor == null) {
            return;
        }
        Hashtable<String, Object> properties = new Hashtable<String, Object>(mapDescriptor.getProperties());
        properties.put("initialMap", "");
        properties.put("initialMapDescription", "");
        properties.put("makeWindow", Boolean.FALSE);
        mapDescriptor.initControl((DisplayControl)new MapDisplayControl(mapData), new ArrayList(), this.getIdv(), properties, null);
    }

    public void addStationDisplay(NamedStationTable stationTable, ControlDescriptor cd) {
        this.getIdv().doMakeControl(new ArrayList(), cd, "stationTableName=" + stationTable.getFullName() + ";", null);
    }

    public List doMakeDataSourceMenuItems(final DataSource dataSource, Component src) {
        ArrayList<Object> menuItems = new ArrayList<Object>();
        if (DataManager.isFormulaDataSource(dataSource)) {
            return this.getIdv().getJythonManager().doMakeFormulaDataSourceMenuItems(dataSource);
        }
        JMenuItem mi = new JMenuItem("Remove This Data Source");
        mi.addActionListener(new ObjectListener(null){

            @Override
            public void actionPerformed(ActionEvent ev) {
                IdvUIManager.this.getIdv().removeDataSource(dataSource);
            }
        });
        menuItems.add(mi);
        List l = dataSource.getActions();
        for (int i = 0; i < l.size(); ++i) {
            Action a = (Action)l.get(i);
            mi = new JMenuItem((String)a.getValue("Name"));
            mi.addActionListener(a);
            menuItems.add(mi);
        }
        menuItems.add("separator");
        menuItems.add(GuiUtils.setIcon(GuiUtils.makeMenuItem("Save As Favorite", this.getPersistenceManager(), "saveDataSource", dataSource), "/auxdata/ui/icons/Save16.gif"));
        menuItems.add(GuiUtils.makeMenuItem("Properties", dataSource, "showPropertiesDialog"));
        return menuItems;
    }

    public void changeState(DataSource dataSource) {
        Misc.run(this.getPersistenceManager(), "changeState", dataSource);
    }

    public void setAlias(DataSource dataSource) {
        String alias = GuiUtils.getInput(" ", "Data source alias: ", dataSource.getAlias());
        if (alias != null) {
            dataSource.setAlias(alias);
        }
    }

    public void showDataSourceDetails(DataSource dataSource) {
        this.showWaitCursor();
        try {
            String html = dataSource.getFullDescription();
            GuiUtils.showHtmlDialog(html, this.getIdv());
        }
        catch (Throwable exc) {
            IdvUIManager.logException("Getting data source details", exc);
        }
        this.showNormalCursor();
    }

    public void showTimeSelection(DataSource dataSource, Component src) {
    }

    public JMenu doMakeDataChoiceMenu(DataChoice dataChoice) {
        return GuiUtils.makeMenu("Displays", this.doMakeDataChoiceMenuItems(dataChoice, false, true));
    }

    public List doMakeDataChoiceMenus(DataChoice dataChoice) {
        return this.doMakeDataChoiceMenuItems(dataChoice, false, true);
    }

    public List doMakeDataChoiceMenuItems(final DataChoice dataChoice, boolean isUserFormula, boolean showAll) {
        ArrayList<Object> items = new ArrayList<Object>();
        if (isUserFormula) {
            this.getIdv().getJythonManager().doMakeDataChoiceMenuItems(dataChoice, items);
        }
        if (showAll) {
            if (!items.isEmpty()) {
                items.add("separator");
            }
            List l = ControlDescriptor.getApplicableControlDescriptors(dataChoice.getCategories(), this.getIdv().getControlDescriptors());
            for (int i = 0; i < l.size(); ++i) {
                ControlDescriptor dd = (ControlDescriptor)l.get(i);
                JMenuItem mi = new JMenuItem(dd.getLabel());
                mi.addActionListener(new ObjectListener(dd){

                    @Override
                    public void actionPerformed(ActionEvent ev) {
                        IdvUIManager.this.getIdv().doMakeControl(dataChoice, (ControlDescriptor)this.theObject, IdvConstants.NULL_STRING);
                    }
                });
                items.add(mi);
            }
        }
        return items;
    }

    public JPanel doMakeControlButtons(boolean vertical) {
        ArrayList<JButton> buttons = new ArrayList<JButton>();
        List controlDescriptors = this.getIdv().getControlDescriptors();
        for (int i = 0; i < controlDescriptors.size(); ++i) {
            ControlDescriptor dd = (ControlDescriptor)controlDescriptors.get(i);
            if (dd.getIcon() == null) continue;
            JButton btn = GuiUtils.getImageButton(GuiUtils.getImageIcon(dd.getIcon(), this.getIdvClass()));
            buttons.add(btn);
            btn.setToolTipText(dd.getDescription());
            btn.addActionListener(new ObjectListener(dd){

                @Override
                public void actionPerformed(ActionEvent event) {
                    IdvUIManager.this.getIdv().doMakeControl(IdvUIManager.this.selectDataChoice((ControlDescriptor)this.theObject), (ControlDescriptor)this.theObject, IdvConstants.NULL_STRING);
                }
            });
        }
        if (vertical) {
            return GuiUtils.vbox(buttons);
        }
        return GuiUtils.hbox(buttons);
    }

    public void showDataTreeMenu(DataTree dataTree, MouseEvent event, boolean showFullMenu) {
        Object object = dataTree.getObjectAt(event.getX(), event.getY());
        if (object == null) {
            return;
        }
        List items = null;
        if (object instanceof DataChoice) {
            DataChoice choice = (DataChoice)object;
            items = this.doMakeDataChoiceMenuItems(choice, choice.isEndUserFormula(), showFullMenu);
        } else if (object instanceof DataSource) {
            items = DataManager.isFormulaDataSource(object) ? this.getIdv().getJythonManager().doMakeFormulaDataSourceMenuItems((DataSource)object) : this.doMakeDataSourceMenuItems((DataSource)object, dataTree.getContents());
        }
        if (items != null && items.size() > 0) {
            JPopupMenu menu = GuiUtils.makePopupMenu(items);
            Msg.translateTree(menu);
            if (menu != null) {
                menu.show(dataTree.getTree(), event.getX(), event.getY());
            }
        }
    }

    public void initHelpTips(boolean checkPrefs) {
        try {
            if (this.getIdv().getArgsManager().getIsOffScreen()) {
                return;
            }
            if (checkPrefs && !this.getStore().get("help.helptip.Show", true)) {
                return;
            }
            if (this.helpTipDialog == null) {
                IdvResourceManager resourceManager = this.getResourceManager();
                this.helpTipDialog = new HelpTipDialog(resourceManager.getXmlResources(IdvResourceManager.RSC_HELPTIPS), this.getIdv(), this.getStore(), this.getIdvClass(), this.getStore().get("help.helptip.Show", true));
            }
            this.helpTipDialog.setVisible(true);
            GuiUtils.toFront(this.helpTipDialog);
        }
        catch (Throwable excp) {
            IdvUIManager.logException("Reading help tips", excp);
        }
    }

    public void closeHelpTips() {
        if (this.helpTipDialog != null) {
            this.helpTipDialog.setVisible(false);
        }
    }

    public void showHelpTips() {
        this.initHelpTips(false);
    }

    public void splashMsg(String m) {
        if (this.splash != null) {
            this.splash.splashMsg(m);
        }
    }

    public void splashClose() {
        if (this.splash != null) {
            this.splash.doClose();
        }
    }

    public void about() {
        JLabel iconLbl = new JLabel(GuiUtils.getImageIcon(this.getIdv().getProperty("idv.splash.icon", "")));
        StringBuffer buf = new StringBuffer();
        buf.append("<h1>");
        buf.append(this.getStateManager().getTitle());
        buf.append("</h1>");
        buf.append(this.getStateManager().getVersionAbout());
        String text = buf.toString();
        JEditorPane editor = new JEditorPane();
        editor.setEditable(false);
        editor.setContentType("text/html");
        editor.setText(text);
        JPanel tmp = new JPanel();
        editor.setBackground(tmp.getBackground());
        editor.addHyperlinkListener(this.getIdv());
        JTabbedPane tab = new JTabbedPane();
        JPanel contents = GuiUtils.leftCenter(iconLbl, GuiUtils.inset((Component)editor, 5));
        tab.add("About", contents);
        StringBuffer javaInfo = new StringBuffer();
        StringBuffer props = new StringBuffer();
        props.append("<b>Operating System</b>");
        props.append("<br> ");
        props.append("Name: ");
        props.append(System.getProperty("os.name"));
        props.append("<br>");
        props.append("Version: ");
        props.append(System.getProperty("os.version"));
        props.append("<br>");
        props.append("Architecture: ");
        props.append(System.getProperty("os.arch"));
        props.append("<br> ");
        props.append("<b>Java</b>");
        props.append("<br> ");
        props.append("Version: ");
        props.append(System.getProperty("java.version"));
        props.append("<br> ");
        props.append("Vendor: ");
        props.append(System.getProperty("java.vendor"));
        props.append("<br> ");
        props.append("Location: ");
        props.append(System.getProperty("java.home"));
        props.append("<br> ");
        props.append("netCDF-Java version: ");
        props.append(LibVersionUtil.getNcidvVersion());
        props.append("<br> ");
        props.append("Java 3D Version: ");
        Class<?> c = null;
        try {
            c = Class.forName("javax.media.j3d.VirtualUniverse");
            Method method = Misc.findMethod(c, "getProperties", new Class[0]);
            if (method == null) {
                props.append("<1.3");
            } else {
                try {
                    Map m = (Map)method.invoke(c, new Object[0]);
                    props.append(m.get("j3d.version"));
                    props.append("<br> ");
                    props.append("Java 3D Vendor: ");
                    props.append(System.getProperty("java.vendor"));
                    props.append(m.get("j3d.vendor"));
                    props.append("<br> ");
                    props.append("Java 3D Renderer: ");
                    props.append(m.get("j3d.renderer"));
                }
                catch (Exception exc) {
                    props.append("unknown");
                }
            }
        }
        catch (ClassNotFoundException exc) {
            props.append("none");
        }
        props.append("<br> ");
        props.append("Heap size: ");
        props.append(Misc.format((double)Runtime.getRuntime().maxMemory() / 1000000.0) + " " + Msg.msg("MB"));
        JEditorPane propsLbl = new JEditorPane();
        propsLbl.setEditable(false);
        propsLbl.setContentType("text/html");
        propsLbl.setText(props.toString());
        propsLbl.setBackground(tmp.getBackground());
        tab.add("System", GuiUtils.setSize(new JScrollPane(propsLbl), 300, 200));
        propsLbl.setBackground(Color.white);
        String[] argv = this.getArgsManager().getOriginalArgs();
        if (argv.length > 0) {
            StringBuffer args = new StringBuffer("Command Line Arguments<p>");
            for (int i = 0; i < argv.length; ++i) {
                args.append("<b> arg " + i + "</b> = " + argv[i] + "<br>");
            }
            JEditorPane argsLbl = new JEditorPane();
            argsLbl.setEditable(false);
            argsLbl.setContentType("text/html");
            argsLbl.setText(args.toString());
            argsLbl.setBackground(tmp.getBackground());
            tab.add("Command Line Arguments", GuiUtils.setSize(new JScrollPane(argsLbl), 400, 300));
            argsLbl.setBackground(Color.white);
        }
        GuiUtils.makeDialog(this.getFrame(), "About " + this.getStateManager().getTitle(), tab, null, new String[]{"Close"});
    }

    public void deleteKeyPressed(DataTree dataTree) {
        DataChoice choice = dataTree.getSelectedDataChoice();
        if (choice == null) {
            return;
        }
        this.getJythonManager().deleteKeyPressed(choice);
    }

    public void dataTreeClick(DataTree dataTree, MouseEvent event) {
        String function = "";
        if (SwingUtilities.isRightMouseButton(event)) {
            function = this.getIdv().getProperty("datatree.rightmouse", "showTreeMenu");
        } else if (event.getClickCount() > 1) {
            function = this.getIdv().getProperty("datatree.doubleclick", "showControlDialog");
        }
        function = function.trim();
        if (function.equals("showTreeMenu")) {
            this.showDataTreeMenu(dataTree, event, true);
        } else if (function.equals("showControlDialog")) {
            this.showControlDialog(dataTree, event);
        }
    }

    public void showControlDialog(DataTree dataTree, MouseEvent event) {
        int y;
        int x = event.getX();
        Object object = dataTree.getObjectAt(x, y = event.getY());
        if (object == null || !(object instanceof DataChoice)) {
            return;
        }
        Point sl = dataTree.getLocationOnScreen();
        sl.x += x;
        sl.y += y;
        this.addDCD(new DataControlDialog(this.getIdv(), (DataChoice)object, sl.x, sl.y));
    }

    public JPanel doMakeStatusBar(IdvWindow window) {
        if (window == null) {
            return new JPanel();
        }
        JLabel msgLabel = new JLabel("                         ");
        LogUtil.addMessageLogger(msgLabel);
        if (window != null) {
            window.setComponent(COMP_MESSAGELABEL, msgLabel);
            IdvXmlUi xmlUI = window.getXmlUI();
            if (xmlUI != null) {
                xmlUI.addComponent(COMP_MESSAGELABEL, msgLabel);
            }
        }
        JLabel waitLabel = new JLabel(IdvWindow.getNormalIcon());
        waitLabel.addMouseListener(new ObjectListener(null){

            @Override
            public void mouseClicked(MouseEvent e) {
                IdvUIManager.this.getIdv().clearWaitCursor();
            }
        });
        window.setComponent(COMP_WAITLABEL, waitLabel);
        RovingProgress progress = this.doMakeRovingProgressBar();
        window.setComponent(COMP_PROGRESSBAR, progress);
        Boolean showClock = this.getStateManager().getPreferenceOrProperty("idv.monitor.showclock.view", true);
        if (!window.getIsAMainWindow()) {
            showClock = this.getStateManager().getPreferenceOrProperty("idv.monitor.showclock.dashboard", true);
        }
        MemoryMonitor mm = new MemoryMonitor(80, (boolean)showClock);
        window.addRemovable(mm);
        CompoundBorder paddedBorder = BorderFactory.createCompoundBorder(this.getStatusBorder(), BorderFactory.createEmptyBorder(0, 2, 0, 2));
        mm.setBorder(paddedBorder);
        progress.setBorder(paddedBorder);
        waitLabel.setBorder(this.getStatusBorder());
        msgLabel.setBorder(paddedBorder);
        JPanel msgBar = GuiUtils.leftCenter(mm, msgLabel);
        JPanel statusBar = GuiUtils.centerRight(msgBar, progress);
        statusBar.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        return statusBar;
    }

    public RovingProgress doMakeRovingProgressBar() {
        Color c = Color.lightGray.darker();
        RovingProgress progress = new RovingProgress(c){
            private Font labelFont;

            @Override
            public boolean drawFilledSquare() {
                return false;
            }

            @Override
            public void paintInner(Graphics g) {
                if (!IdvWindow.getWaitState() && super.isRunning()) {
                    super.stop();
                    return;
                }
                if (!super.isRunning()) {
                    super.paintInner(g);
                    return;
                }
                super.paintInner(g);
            }

            @Override
            public void paintLabel(Graphics g, Rectangle bounds) {
                if (this.labelFont == null) {
                    this.labelFont = g.getFont();
                    this.labelFont = this.labelFont.deriveFont(1);
                }
                g.setFont(this.labelFont);
                g.setColor(Color.black);
                if (DataSourceImpl.getOutstandingGetDataCalls() > 0) {
                    g.drawString("Reading data", 5, bounds.height - 4);
                }
            }
        };
        progress.setPreferredSize(new Dimension(130, 10));
        return progress;
    }

    public Border getStatusBorder() {
        return new FineLineBorder(1);
    }

    @Override
    public JFrame getFrame() {
        List windows;
        if (this.lastActiveFrame != null) {
            // empty if block
        }
        if ((windows = IdvWindow.getMainWindows()).size() > 0) {
            IdvWindow idvWindow = (IdvWindow)windows.get(0);
            return idvWindow.getFrame();
        }
        return null;
    }

    private void positionWindow(JFrame frame) {
        if (this.getIdv().getProperty("idv.ui.window.usescreensize", false)) {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            int offset = this.getIdv().getProperty("idv.ui.window.screensizeoffset", 20);
            frame.setLocation(offset, offset);
            frame.setSize(screenSize.width - offset * 2, screenSize.height - offset * 2);
        } else {
            int w = this.getIdv().getProperty("idv.ui.window.width", -1);
            int h = this.getIdv().getProperty("idv.ui.window.height", -1);
            if (w != -1 && h != -1) {
                frame.setSize(w, h);
            }
        }
    }

    public void doBasicInitialization() {
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
        this.setDateFormat();
    }

    private IdvWindow findWindowWithSkin(List windows, String skinPath) {
        for (int windowIdx = 0; windowIdx < windows.size(); ++windowIdx) {
            IdvWindow window = (IdvWindow)windows.get(windowIdx);
            if (!Misc.equals(this.fixSkinPath(window.getSkinPath()), this.fixSkinPath(skinPath))) continue;
            return window;
        }
        return null;
    }

    protected IdvWindow findWindowThatMatches(List currentWindows, WindowInfo windowInfo) {
        if (windowInfo.getPersistentComponents().size() > 0) {
            return null;
        }
        String skinPath = windowInfo.getSkinPath();
        List newVms = windowInfo.getViewManagers();
        for (int oldWindowIdx = 0; oldWindowIdx < currentWindows.size(); ++oldWindowIdx) {
            IdvWindow currentWindow = (IdvWindow)currentWindows.get(oldWindowIdx);
            if (!Misc.equals(this.fixSkinPath(currentWindow.getSkinPath()), this.fixSkinPath(skinPath))) continue;
            List origVms = currentWindow.getViewManagers();
            if (newVms.size() != origVms.size()) continue;
            boolean windowOk = true;
            for (int vmIdx = 0; vmIdx < newVms.size(); ++vmIdx) {
                ViewManager newViewManager = (ViewManager)newVms.get(vmIdx);
                ViewManager origViewManager = (ViewManager)origVms.get(vmIdx);
                if (origViewManager.canBe(newViewManager)) continue;
                windowOk = false;
                break;
            }
            if (!windowOk) continue;
            return currentWindow;
        }
        return null;
    }

    public void unpersistWindowInfo(List windows, List newViewManagers, boolean okToMerge, boolean fromCollab, boolean didRemoveAll) {
        if (newViewManagers == null) {
            newViewManagers = new ArrayList();
        }
        ArrayList currentWindows = new ArrayList(IdvWindow.getWindows());
        for (int newWindowIdx = 0; newWindowIdx < windows.size(); ++newWindowIdx) {
            IdvWindow currentWindow;
            WindowInfo windowInfo = (WindowInfo)windows.get(newWindowIdx);
            windowInfo.setIsAMainWindow(true);
            List newVms = windowInfo.getViewManagers();
            newViewManagers.removeAll(newVms);
            boolean createANewOne = true;
            if (okToMerge && (currentWindow = this.findWindowThatMatches(currentWindows, windowInfo)) != null) {
                List origVms = currentWindow.getViewManagers();
                createANewOne = false;
                for (int vmIdx = 0; vmIdx < newVms.size() && vmIdx < origVms.size(); ++vmIdx) {
                    ViewManager newViewManager = (ViewManager)newVms.get(vmIdx);
                    ViewManager origViewManager = (ViewManager)origVms.get(vmIdx);
                    origViewManager.initWith(newViewManager, fromCollab);
                }
                currentWindows.remove(currentWindow);
                currentWindow.setIsAMainWindow(windowInfo.getIsAMainWindow());
                currentWindow.setPersistentComponents(windowInfo.getPersistentComponents());
                currentWindow.setBounds(windowInfo.getBounds());
            }
            if (!createANewOne) continue;
            this.getVMManager().addViewManagers(newVms);
            String skinPath = windowInfo.getSkinPath();
            IdvWindow window = this.createNewWindow(newVms, skinPath, windowInfo.getTitle(), windowInfo);
            window.setPersistentComponents(windowInfo.getPersistentComponents());
            window.setBounds(windowInfo.getBounds());
        }
        if (okToMerge && didRemoveAll) {
            for (int windowIdx = 0; windowIdx < currentWindows.size(); ++windowIdx) {
                IdvWindow idvWindow = (IdvWindow)currentWindows.get(windowIdx);
                if (!idvWindow.getIsAMainWindow()) continue;
                idvWindow.dispose();
            }
        }
    }

    public void disposeAllWindows() {
        List allWindows = IdvWindow.getWindows();
        for (int windowIdx = 0; windowIdx < allWindows.size(); ++windowIdx) {
            IdvWindow window = (IdvWindow)allWindows.get(windowIdx);
            window.dispose();
        }
    }

    private String getWindowTitleFromSkin(int index) {
        IdvResourceManager idvResourceManager = this.getResourceManager();
        this.getResourceManager();
        XmlResourceCollection skins = idvResourceManager.getXmlResources(IdvResourceManager.RSC_SKIN);
        List<String> names = StringUtil.split(skins.getShortName(index), ">", true, true);
        String title = this.getStateManager().getTitle();
        if (names.size() > 0) {
            title = title + " - " + StringUtil.join(" - ", names);
        }
        return title;
    }

    public IdvWindow createNewWindow() {
        return this.createNewWindow(new ArrayList(), false);
    }

    public IdvWindow createNewWindow(List viewManagers) {
        return this.createNewWindow(viewManagers, true);
    }

    public IdvWindow createNewWindow(List viewManagers, String skinPath) {
        return this.createNewWindow(viewManagers, skinPath, null, null);
    }

    public IdvWindow createNewWindow(List viewManagers, boolean notifyCollab) {
        IdvResourceManager idvResourceManager = this.getResourceManager();
        this.getResourceManager();
        XmlResourceCollection skins = idvResourceManager.getXmlResources(IdvResourceManager.RSC_SKIN);
        Element root = null;
        String path = null;
        String skinName = null;
        path = this.getIdv().getProperty("idv.ui.defaultskin", null);
        if (path != null) {
            path = path.trim();
        }
        if (path != null && path.length() > 0) {
            try {
                root = XmlUtil.getRoot(path, this.getClass());
                skinName = this.getStateManager().getTitle();
                String tmp = XmlUtil.getAttribute((Node)root, "name", (String)null);
                if (tmp == null) {
                    tmp = IOUtil.stripExtension(IOUtil.getFileTail(path));
                }
                skinName = skinName + " - " + tmp;
            }
            catch (Exception exc) {
                IdvUIManager.logException("createNewWindow", exc);
            }
        }
        if (root == null) {
            for (int i = 0; i < skins.size() && root == null; ++i) {
                if (!Misc.equals(skins.getProperty("default", i), "true")) continue;
                root = skins.getRoot(i);
                path = skins.get(i).toString();
                skinName = this.getWindowTitleFromSkin(i);
            }
        }
        if (root == null) {
            for (int i = 0; i < skins.size() && root == null; ++i) {
                root = skins.getRoot(i);
                path = skins.get(i).toString();
                skinName = this.getWindowTitleFromSkin(i);
            }
        }
        return this.createNewWindow(viewManagers, notifyCollab, skinName, path, root, true, null);
    }

    public IdvWindow createNewWindow(List viewManagers, boolean notifyCollab, String title, String skinPath, Element root) {
        return this.createNewWindow(viewManagers, notifyCollab, title, skinPath, root, true, null);
    }

    public IdvWindow createNewWindow(List viewManagers, String skinPath, String windowTitle, WindowInfo windowInfo) {
        try {
            Element skinRoot = XmlUtil.getRoot(this.fixSkinPath(skinPath), this.getClass());
            return this.createNewWindow(viewManagers, false, windowTitle, skinPath, skinRoot, true, windowInfo);
        }
        catch (Throwable excp) {
            IdvUIManager.logException("createNewWindow", excp);
            return null;
        }
    }

    private String fixSkinPath(String skinPath) {
        if (skinPath == null) {
            return null;
        }
        if (StringUtil.stringMatch(skinPath, "^/ucar/unidata/idv/resources/[^/]+\\.xml")) {
            skinPath = StringUtil.replace(skinPath, "/ucar/unidata/idv/resources/", "/ucar/unidata/idv/resources/skins/");
        }
        return skinPath;
    }

    public IdvWindow createNewWindow(List viewManagers, boolean notifyCollab, String skinPath, Element skinRoot) {
        return this.createNewWindow(viewManagers, notifyCollab, null, skinPath, skinRoot, true, null);
    }

    public IdvWindow createNewWindow(List viewManagers, boolean notifyCollab, String title, String skinPath, Element skinRoot, boolean show, WindowInfo windowInfo) {
        try {
            JComponent contents;
            if (title == null) {
                title = this.getStateManager().getTitle();
            }
            boolean isMainWindow = true;
            String windowType = "";
            if (skinRoot != null) {
                windowType = XmlUtil.getAttribute((Node)skinRoot, "windowtype", windowType);
                if (XmlUtil.hasAttribute(skinRoot, ATTR_MAINWINDOW)) {
                    isMainWindow = XmlUtil.getAttribute((Node)skinRoot, ATTR_MAINWINDOW, isMainWindow);
                }
            }
            if (skinRoot != null && XmlUtil.hasAttribute(skinRoot, "windowtitle")) {
                title = XmlUtil.getAttribute((Node)skinRoot, "windowtitle", "");
            }
            IdvWindow window = new IdvWindow(title, this.getIdv(), isMainWindow);
            if (windowInfo != null) {
                window.setPersistentComponents(windowInfo.getPersistentComponents());
            }
            window.setType(windowType);
            window.setVisible(false);
            ImageIcon icon = GuiUtils.getImageIcon(this.getIdv().getProperty("idv.splash.icon", ""));
            if (icon != null) {
                window.setIconImage(icon.getImage());
            }
            if (viewManagers == null) {
                viewManagers = new ArrayList<ViewManager>();
            }
            if (skinRoot != null) {
                JMenuBar menuBar;
                IdvXmlUi xmlUI = this.doMakeIdvXmlUi(window, viewManagers, skinRoot);
                window.setSkinPath(skinPath);
                String iconProp = xmlUI.getProperty("icon.wait.normal");
                if (iconProp != null) {
                    IdvWindow.setNormalIcon(iconProp);
                }
                if ((iconProp = xmlUI.getProperty("icon.wait.wait")) != null) {
                    IdvWindow.setWaitIcon(iconProp);
                }
                contents = (JComponent)xmlUI.getContents();
                window.setXmlUI(xmlUI);
                viewManagers = xmlUI.getViewManagers();
                if (GuiUtils.doMacMenubar() && (menuBar = this.doMakeMenuBar()) != null) {
                    window.setJMenuBar(menuBar);
                }
            } else {
                if (viewManagers.size() == 0) {
                    viewManagers.add(this.getIdv().getViewManager(ViewDescriptor.LASTACTIVE, false, this.getIdv().getViewManagerProperties()));
                }
                contents = this.doMakeDefaultContents(window, (ViewManager)viewManagers.get(0));
                JMenuBar menuBar = this.doMakeMenuBar();
                if (menuBar != null) {
                    window.setJMenuBar(menuBar);
                }
            }
            this.updateToolbars();
            Msg.translateTree(contents);
            this.checkToolbarVisibility();
            window.setContents(contents);
            this.associateWindowWithViewManagers(window, viewManagers);
            if (this.getIdv().okToShowWindows() && show) {
                window.show();
                GuiUtils.toFrontModalDialogs();
            }
            if (notifyCollab) {
                // empty if block
            }
            return window;
        }
        catch (Throwable excp) {
            IdvUIManager.logException("createNewWindow-1", excp);
            return null;
        }
    }

    public List getComponentGroups() {
        ArrayList groups = new ArrayList();
        List allWindows = IdvWindow.getWindows();
        for (int windowIdx = 0; windowIdx < allWindows.size(); ++windowIdx) {
            IdvWindow window = (IdvWindow)allWindows.get(windowIdx);
            List<IdvComponentGroup> groupsInWindow = window.getComponentGroups();
            for (int i = 0; i < groupsInWindow.size(); ++i) {
                groupsInWindow.get(i).addGroups(groups);
            }
        }
        return groups;
    }

    public List getWindowsToPersist() {
        ArrayList<WindowInfo> windows = new ArrayList<WindowInfo>();
        List allWindows = IdvWindow.getWindows();
        for (int windowIdx = 0; windowIdx < allWindows.size(); ++windowIdx) {
            IdvWindow window = (IdvWindow)allWindows.get(windowIdx);
            if (!window.getIsAMainWindow()) continue;
            windows.add(new WindowInfo(window));
        }
        return windows;
    }

    public JComponent getToolbarUI() {
        Element toolbarRoot = this.getToolbarRoot();
        if (toolbarRoot == null) {
            return new JPanel();
        }
        IdvXmlUi.processToolbarXml(toolbarRoot, this);
        return (JComponent)new XmlUi(toolbarRoot, this.getIdv()).getContents();
    }

    protected IdvXmlUi doMakeIdvXmlUi(IdvWindow window, List viewManagers, Element skinRoot) {
        return new IdvXmlUi(window, viewManagers, this.getIdv(), skinRoot);
    }

    protected JComponent doMakeToolbar() {
        Element toolbarRoot = this.getToolbarRoot();
        if (toolbarRoot == null) {
            return new JPanel();
        }
        IdvXmlUi.processToolbarXml(toolbarRoot, this.getIdvUIManager());
        XmlUi xmlui = new XmlUi(toolbarRoot, this.getIdv());
        JComponent toolbar = (JComponent)xmlui.getContents();
        return toolbar;
    }

    public void reloadToolbarResources() {
        IdvResourceManager idvResourceManager = this.getResourceManager();
        this.getResourceManager();
        XmlResourceCollection xrc = idvResourceManager.getXmlResources(IdvResourceManager.RSC_TOOLBAR);
        xrc.clearCache();
    }

    public void updateIconBar() {
        this.reloadToolbarResources();
        List toolbarComps = this.getWindowGroup("toolbars");
        for (int i = 0; i < toolbarComps.size(); ++i) {
            JComponent comp = (JComponent)toolbarComps.get(i);
            JComponent toolbar = this.doMakeToolbar();
            comp.removeAll();
            comp.add("Center", toolbar);
            comp.repaint();
        }
    }

    public void checkToolbarVisibility() {
        boolean toolbarsVisible = (Boolean)this.getIdv().getPreference("idv.window.showtoolbar", true);
        List toolbarComps = this.getWindowGroup("toolbars");
        for (int i = 0; i < toolbarComps.size(); ++i) {
            JComponent comp = (JComponent)toolbarComps.get(i);
            comp.setVisible(toolbarsVisible);
        }
        List windows = IdvWindow.getWindows();
        for (int i = 0; i < windows.size(); ++i) {
            JPanel toolbar = (JPanel)((IdvWindow)windows.get(i)).getComponent(COMP_FAVORITESBAR);
            if (toolbar == null) continue;
            toolbar.setVisible(toolbarsVisible);
        }
    }

    public JComponent doMakeDefaultContents(IdvWindow window, ViewManager viewManager) {
        JPanel statusBar = this.doMakeStatusBar(window);
        JPanel toolbar = new JPanel();
        window.setComponent(COMP_FAVORITESBAR, toolbar);
        return GuiUtils.topCenterBottom(toolbar, viewManager.getContents(), statusBar);
    }

    public Element getToolbarRoot() {
        try {
            IdvResourceManager idvResourceManager = this.getResourceManager();
            this.getResourceManager();
            XmlResourceCollection xrc = idvResourceManager.getXmlResources(IdvResourceManager.RSC_TOOLBAR);
            Element root = null;
            for (int i = 0; i < xrc.size() && root == null; ++i) {
                root = xrc.getRoot(i);
            }
            return root;
        }
        catch (Exception exc) {
            IdvUIManager.logException("Creating icon bar", exc);
            return null;
        }
    }

    public void showResults(DataSourceResults results) {
        JComponent topLabel;
        if (!results.anyFailed()) {
            return;
        }
        Vector failedData = Misc.toVector(StringUtil.listToStringArray(results.getFailedData()));
        List exceptions = results.getExceptions();
        String errorMsg = null;
        errorMsg = exceptions.size() > 1 ? "There were errors loading the data:" : "There was an error loading the data:";
        if (results.anyOk()) {
            errorMsg = exceptions.size() > 1 ? "But there were errors loading some of the data:" : "But there was an error loading some of the data:";
            List success = results.getSuccessData();
            ArrayList<JPanel> comps = new ArrayList<JPanel>();
            for (int i = 0; i < success.size(); ++i) {
                Object o = success.get(i);
                if (!(o instanceof List)) {
                    o = Misc.newList(o);
                }
                List dataList = (List)o;
                for (int j = 0; j < dataList.size(); ++j) {
                    comps.add(GuiUtils.inset((Component)new JLabel("    " + dataList.get(j).toString()), 2));
                }
            }
            topLabel = GuiUtils.vbox(new JLabel("Some of the data files were loaded successfully:"), GuiUtils.vbox(comps));
        } else {
            topLabel = new JLabel(" ");
        }
        if (exceptions.size() > 1) {
            JPanel content = GuiUtils.topCenter(new JLabel(errorMsg), LogUtil.getMultiExceptionsPanel(null, exceptions));
            GuiUtils.showDialog("Data loading errors", GuiUtils.topCenter(topLabel, GuiUtils.inset((Component)content, 4)));
        } else if (exceptions.size() == 1) {
            LogUtil.logException(errorMsg, (Exception)exceptions.get(0));
        }
    }

    public void removeDataSourceHolder(DataSourceHolder holder) {
        this.dataSourceHolders.remove(holder);
    }

    public void addDataSourceHolder(DataSourceHolder holder) {
        this.dataSourceHolders.add(holder);
    }

    public void initDataSourceHolder(DataSourceHolder holder, boolean inWindow) {
        if (inWindow) {
            String className;
            Rectangle defaultBounds;
            IdvWindow treeWindow = holder.doMakeFrame();
            JMenuBar menuBar = this.doMakeMenuBar();
            if (menuBar != null) {
                treeWindow.setJMenuBar(menuBar);
            }
            if (this.defaultHolderBounds != null && (defaultBounds = (Rectangle)this.defaultHolderBounds.get(className = holder.getClass().getName())) != null) {
                treeWindow.setBounds(defaultBounds);
                this.defaultHolderBounds.remove(className);
            }
            if (this.getIdv().getHaveInitialized()) {
                holder.show();
            }
            Msg.translateTree(treeWindow.getContents());
        }
        this.addDataSourceHolder(holder);
        List dataSources = this.getDataSourcesForGui();
        if (dataSources != null) {
            for (int i = 0; i < dataSources.size(); ++i) {
                holder.addDataSource((DataSource)dataSources.get(i));
            }
        }
    }

    private List getDataSourcesForGui() {
        List all = this.getIdv().getDataSources();
        if (all == null) {
            return null;
        }
        ArrayList<DataSource> subset = new ArrayList<DataSource>();
        for (int i = 0; i < all.size(); ++i) {
            DataSource dataSource = (DataSource)all.get(i);
            if (!this.getIdv().getDataManager().getProperty(dataSource.getTypeName(), "show_in_tree", true)) continue;
            subset.add(dataSource);
        }
        return subset;
    }

    public void addDisplayControl(DisplayControl control) {
        if (this.getStateManager().getShowControlsInTree()) {
            DataChoice choice = control.getDataChoice();
            for (int i = 0; i < this.dataSourceHolders.size(); ++i) {
                ((DataSourceHolder)this.dataSourceHolders.get(i)).addDisplayControl(control, choice);
            }
        }
        if (this.getViewPanel() != null && !this.getIdv().getArgsManager().getIsOffScreen()) {
            this.getViewPanel().addDisplayControl(control);
        }
        this.displayControlsChanged();
    }

    public void showDashboard() {
        this.showBasicWindow(true);
    }

    private List<String> getInitialSkins() {
        List<String> temp = StringUtil.split(this.getStateManager().getProperty("idv.ui.initskins", ""), ";", true, true);
        ArrayList<String> skins = new ArrayList<String>();
        for (String skin : temp) {
            skins.add(this.getResourceManager().getResourcePath(skin));
        }
        return skins;
    }

    public boolean haveBasicWindow() {
        ArrayList windows = new ArrayList(IdvWindow.getWindows());
        List<String> skins = this.getInitialSkins();
        for (int i = 0; i < windows.size(); ++i) {
            IdvWindow window = (IdvWindow)windows.get(i);
            if (window.getSkinPath() == null || !skins.contains(window.getSkinPath())) continue;
            return true;
        }
        return false;
    }

    public boolean showBasicWindow(boolean createThemIfNotThere) {
        ArrayList windows = new ArrayList(IdvWindow.getWindows());
        List<String> skins = this.getInitialSkins();
        for (int i = 0; i < windows.size(); ++i) {
            IdvWindow window = (IdvWindow)windows.get(i);
            if (window.getSkinPath() == null || !skins.contains(window.getSkinPath())) continue;
            window.show();
            return true;
        }
        if (createThemIfNotThere) {
            this.showWaitCursor();
            this.doMakeBasicWindows();
            this.showNormalCursor();
        }
        return false;
    }

    public void addViewMenuItems(DisplayControl control, List items) {
        if (this.getViewPanel() != null) {
            this.getViewPanel().addViewMenuItems(control, items);
        }
    }

    protected boolean getShowControlsInTab() {
        return this.getStore().get("Display.ShowInTabs", true);
    }

    public void removeDisplayControl(DisplayControl control) {
        for (int i = 0; i < this.dataSourceHolders.size(); ++i) {
            ((DataSourceHolder)this.dataSourceHolders.get(i)).removeDisplayControl(control);
        }
        if (this.getViewPanel() != null) {
            this.getViewPanel().removeDisplayControl(control);
        }
        this.displayControlsChanged();
    }

    public void removeAllDataSources() {
        for (int i = 0; i < this.dataSourceHolders.size(); ++i) {
            ((DataSourceHolder)this.dataSourceHolders.get(i)).removeAllDataSources();
        }
    }

    public void removeDataSource(DataSource dataSource) {
        for (int i = 0; i < this.dataSourceHolders.size(); ++i) {
            ((DataSourceHolder)this.dataSourceHolders.get(i)).removeDataSource(dataSource);
        }
    }

    public void dataSourceChanged(DataSource source) {
        for (int i = 0; i < this.dataSourceHolders.size(); ++i) {
            DataSourceHolder holder = (DataSourceHolder)this.dataSourceHolders.get(i);
            holder.dataSourceChanged(source);
        }
    }

    public void dataSourceTimeChanged(DataSource source) {
        for (int i = 0; i < this.dataSourceHolders.size(); ++i) {
            DataSourceHolder holder = (DataSourceHolder)this.dataSourceHolders.get(i);
            holder.dataSourceTimeChanged(source);
        }
    }

    public void addDataSource(DataSource dataSource) {
        if (this.dataSourceHolders.size() == 0 && !this.getIdv().getInteractiveMode()) {
            DataSelector selector = new DataSelector(this.getIdv(), false, this.getIdv().getProperty("idv.ui.showformulas", true) ? this.getIdv().getJythonManager().getDescriptorDataSource() : null);
            this.dataSourceHolders.add(selector);
        }
        for (int i = 0; i < this.dataSourceHolders.size(); ++i) {
            ((DataSourceHolder)this.dataSourceHolders.get(i)).addDataSource(dataSource);
        }
    }

    public void addStateToBundle(Hashtable data) {
        ArrayList commandsToRun = new ArrayList();
        if (commandsToRun.size() > 0) {
            data.put("commandstorun", commandsToRun);
        }
        this.addDataHolderState(data);
    }

    public void addDataHolderState(Hashtable data) {
        Object windowedTreeHolder = null;
        Object windowedSelectorHolder = null;
        boolean didOne = false;
        Hashtable<String, Rectangle> bounds = null;
        for (int i = 0; i < this.dataSourceHolders.size(); ++i) {
            String className;
            DataSourceHolder holder = (DataSourceHolder)this.dataSourceHolders.get(i);
            if (holder.getFrame() == null) continue;
            if (bounds == null) {
                bounds = new Hashtable<String, Rectangle>();
            }
            if (bounds.get(className = holder.getClass().getName()) != null) continue;
            bounds.put(className, holder.getFrame().getBounds());
        }
        if (bounds != null) {
            Hashtable misc = new Hashtable();
            misc.put("dataholderbounds", bounds);
            data.put("mischashtable", misc);
        }
    }

    public void applyDataHolderState(Hashtable misc) {
        if (misc == null) {
            return;
        }
        this.defaultHolderBounds = (Hashtable)misc.get("dataholderbounds");
        if (this.defaultHolderBounds == null) {
            return;
        }
        for (int i = 0; i < this.dataSourceHolders.size(); ++i) {
            DataSourceHolder holder = (DataSourceHolder)this.dataSourceHolders.get(i);
            Rectangle bounds = (Rectangle)this.defaultHolderBounds.get(holder.getClass().getName());
            if (bounds == null || holder.getFrame() == null) continue;
            holder.getFrame().setBounds(bounds);
        }
    }

    public List getDataSourceHolders() {
        return new ArrayList(this.dataSourceHolders);
    }

    private Component[] findChildren(JComponent comp) {
        if (comp instanceof JMenu) {
            return ((JMenu)comp).getMenuComponents();
        }
        return comp.getComponents();
    }

    public void showMenu(String s) {
        Misc.run(this, "showMenuInThread", s);
    }

    public void showMenuInThread(String s) {
        IdvWindow idvWindow = IdvWindow.getActiveWindow();
        if (idvWindow == null) {
            return;
        }
        JMenuBar menuBar = null;
        List comps = idvWindow.getComponents();
        if (comps == null) {
            return;
        }
        for (int i = 0; i < comps.size(); ++i) {
            Object o = comps.get(i);
            if (!(o instanceof JMenuBar)) continue;
            menuBar = (JMenuBar)o;
            break;
        }
        if (menuBar == null) {
            return;
        }
        GuiUtils.showComponentInTabs(menuBar);
        List<String> toks = StringUtil.split(s, ":", true, true);
        JComponent comp = menuBar;
        ArrayList<JMenuItem> menus = new ArrayList<JMenuItem>();
        for (int tokIdx = 0; tokIdx < toks.size(); ++tokIdx) {
            String tok = toks.get(tokIdx);
            tok = tok.toLowerCase().trim();
            boolean foundIt = false;
            Component[] children = this.findChildren(comp);
            for (int i = 0; i < children.length && !foundIt; ++i) {
                Component child = children[i];
                if (!(child instanceof JMenuItem)) continue;
                String text = ((JMenuItem)child).getText();
                foundIt = Misc.equals(tok, text = text.toLowerCase().trim());
                if (!foundIt) continue;
                comp = (JComponent)child;
            }
            if (!foundIt) {
                System.err.println("Couldn't find menu:" + tok);
                return;
            }
            JMenuItem mi = (JMenuItem)comp;
            mi.setArmed(true);
            Misc.sleep(1000L);
            if (!(mi instanceof JMenu)) {
                mi.doClick();
                mi.setArmed(false);
                break;
            }
            mi.doClick();
            menus.add(0, mi);
            Misc.sleep(1000L);
        }
        for (int i = 0; i < menus.size(); ++i) {
            JMenu menu = (JMenu)menus.get(i);
            menu.setArmed(false);
            menu.setPopupMenuVisible(false);
        }
    }

    public void showHelp(String target) {
        this.showHelp(null, target);
    }

    public void showHelp(String url, String target) {
        if (url == null) {
            url = this.getIdv().getStateManager().getDefaultHelpUrl();
        }
        if (target == null) {
            target = this.getIdv().getStateManager().getDefaultHelpTarget();
        }
        List comps = this.findComponents(COMP_HELP);
        for (int i = 0; i < comps.size(); ++i) {
            IdvHelp idvHelp;
            Object comp = comps.get(i);
            if (!(comp instanceof IdvHelp) || !(idvHelp = (IdvHelp)((Object)comp)).getHelpSet().getCombinedMap().isValidID(target, idvHelp.getHelpSet())) continue;
            idvHelp.setCurrentID(target);
            GuiUtils.showComponentInTabs((Component)((Object)idvHelp));
            return;
        }
        Help.setTopDir(url);
        Help.getDefaultHelp();
        if (!Help.getDefaultHelp().isValidID(target)) {
            LogUtil.userMessage("Unknown help id: " + target);
            Help.getDefaultHelp().gotoTarget(this.getIdv().getStateManager().getDefaultHelpTarget());
        } else {
            Help.getDefaultHelp().gotoTarget(target);
        }
    }

    public DataTree createDataTree(boolean inOwnWindow) {
        DataTree dataTree = new DataTree(this.getIdv(), this.getIdv().getProperty("idv.ui.showformulas", true) ? this.getIdv().getJythonManager().getDescriptorDataSource() : null);
        this.initDataTree(dataTree);
        this.initDataSourceHolder(dataTree, inOwnWindow);
        return dataTree;
    }

    public DataTree createDataTreeWindow() {
        return this.createDataTree(true);
    }

    public DataTree createDataTree() {
        return this.createDataTree(false);
    }

    public void initDataTree(final DataTree dataTree) {
        if (dataTree == null) {
            return;
        }
        dataTree.getTree().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                IdvUIManager.this.dataTreeClick(dataTree, me);
            }
        });
    }

    public DataSelector createDataSelector() {
        return this.createDataSelector(false, true);
    }

    public boolean embedFieldSelectorInDashboard() {
        return this.getIdv().getStore().get("idv.ui.embedfieldselectorindashboard", true);
    }

    public boolean embedQuickLinksInDashboard() {
        return this.getIdv().getStore().get("idv.ui.embedquicklinksindashboard", this.getIdv().getProperty("idv.quicklinks.show", true));
    }

    public boolean embedDataChooserInDashboard() {
        return this.getIdv().getStore().get("idv.ui.embeddatachooserindashboard", true);
    }

    public boolean embedLegendInDashboard() {
        return this.getIdv().getStore().get("idv.ui.embedlegendindashboard", false);
    }

    public void showOrCreateDataSelector() {
        if (!this.dataSelectorToFront()) {
            this.createDataSelector();
        }
    }

    public void dataSelectorToFrontIfOk() {
        this.dataSelectorToFront();
    }

    public boolean showDataSelector() {
        Object comp = this.findComponent(COMP_DATASELECTOR);
        if (comp != null) {
            GuiUtils.showComponentInTabs((JComponent)comp);
            return true;
        }
        return false;
    }

    public boolean dataSelectorToFront() {
        return this.showDataSelector();
    }

    public void createInitialDataSelector() {
    }

    public DataSelector createDataSelector(boolean inOwnWindow) {
        return this.createDataSelector(!inOwnWindow, inOwnWindow);
    }

    public DataSelector createDataSelector(boolean horizontalOrientation, boolean inOwnWindow) {
        DataSelector selector = new DataSelector(this.getIdv(), horizontalOrientation, this.getIdv().getProperty("idv.ui.showformulas", true) ? this.getIdv().getJythonManager().getDescriptorDataSource() : null);
        this.initDataSourceHolder(selector, inOwnWindow);
        return selector;
    }

    public DataChoice selectDataChoice(ControlDescriptor descriptor) {
        List dataSourcesForTree = this.getDataSourcesForGui();
        if (dataSourcesForTree.size() == 0) {
            return null;
        }
        DataOperand dataOperand = new DataOperand("Please select a data choice:", "Please select a data choice:", descriptor.getCategories(), false);
        DataTreeDialog dataDialog = new DataTreeDialog(this.getIdv(), null, Misc.newList(dataOperand), dataSourcesForTree, null);
        List selected = dataDialog.getSelected();
        dataDialog.dispose();
        if (selected == null || selected.isEmpty()) {
            return null;
        }
        List firstList = (List)selected.get(0);
        if (firstList.isEmpty()) {
            return null;
        }
        return (DataChoice)firstList.get(0);
    }

    public List selectDataChoices(List operands) {
        if (operands.size() == 0) {
            return new ArrayList();
        }
        if (!(operands.get(0) instanceof DataOperand)) {
            ArrayList<DataOperand> tmp = new ArrayList<DataOperand>();
            for (int i = 0; i < operands.size(); ++i) {
                tmp.add(new DataOperand(operands.get(i).toString()));
            }
            operands = tmp;
        }
        Hashtable<DataOperand, List> choicesWeAlreadyHave = new Hashtable<DataOperand, List>();
        ArrayList<DataOperand> operandsToSelect = new ArrayList<DataOperand>();
        for (int i = 0; i < operands.size(); ++i) {
            DataOperand operand = (DataOperand)operands.get(i);
            DataChoice choice = null;
            String dataSourceName = operand.getDataSourceName();
            if (dataSourceName != null) {
                DataSource newDataSource = null;
                if (dataSourceName.startsWith("#")) {
                    List dataSources;
                    int index = new Integer(dataSourceName.substring(1)) - 1;
                    if (index < (dataSources = this.getDataSourcesForGui()).size() && index >= 0) {
                        newDataSource = (DataSource)dataSources.get(index);
                    }
                } else {
                    DataSourceResults results = this.getIdv().createDataSource(dataSourceName, null, null, true);
                    if (results.anyFailed()) {
                        this.showResults(results);
                        return null;
                    }
                    if (!results.anyOk()) {
                        return null;
                    }
                    newDataSource = (DataSource)results.getDataSources().get(0);
                }
                if (newDataSource != null) {
                    choice = newDataSource.findDataChoice(operand.getParamName());
                }
            }
            if (choice != null) {
                choicesWeAlreadyHave.put(operand, Misc.newList(choice));
                continue;
            }
            operandsToSelect.add(operand);
        }
        List dataSourcesForTree = this.getIdv().getAllDataSources();
        if (dataSourcesForTree.size() == 0) {
            LogUtil.userMessage("No available data sources");
            return null;
        }
        List selected = new ArrayList();
        if (operandsToSelect.size() > 0) {
            DataTreeDialog dataDialog = new DataTreeDialog(this.getIdv(), null, operandsToSelect, dataSourcesForTree, null);
            selected = dataDialog.getSelected();
            dataDialog.dispose();
            if (selected == null || selected.size() == 0) {
                return null;
            }
        }
        int selectedIdx = 0;
        ArrayList<ListDataChoice> finalChoices = new ArrayList<ListDataChoice>();
        for (int i = 0; i < operands.size(); ++i) {
            DataOperand operand = (DataOperand)operands.get(i);
            String paramName = operand.getParamName();
            DataChoice choice = (DataChoice)choicesWeAlreadyHave.get(operand);
            List choices = choice == null ? (List)selected.get(selectedIdx++) : Misc.newList(choice);
            if (choices.size() == 0) {
                throw new IllegalStateException("No data selected");
            }
            List times = operand.getTimeIndices();
            if (times != null) {
                for (int choiceIdx = 0; choiceIdx < choices.size(); ++choiceIdx) {
                    ((DataChoice)choices.get(choiceIdx)).setTimeSelection(times);
                }
            }
            if (operand.getMultiple()) {
                ListDataChoice ldc = new ListDataChoice(paramName, choices);
                finalChoices.add(ldc);
                continue;
            }
            finalChoices.add((ListDataChoice)choices.get(0));
        }
        return finalChoices;
    }

    public List selectUserChoices(String msg, List userOperands) {
        if (this.operandCache == null) {
            this.operandCache = (Hashtable)this.getStore().getEncodedFile("operandcache.xml");
            if (this.operandCache == null) {
                this.operandCache = new Hashtable();
            }
        }
        ArrayList<JCheckBox> fields = new ArrayList<JCheckBox>();
        ArrayList<JComponent> components = new ArrayList<JComponent>();
        ArrayList<JCheckBox> persistentCbxs = new ArrayList<JCheckBox>();
        components.add(new JLabel("Property"));
        components.add(new JLabel("Value"));
        components.add(new JLabel("Save in Bundle"));
        for (int i = 0; i < userOperands.size(); ++i) {
            DataOperand operand = (DataOperand)userOperands.get(i);
            String fieldType = operand.getProperty("type");
            if (fieldType == null) {
                fieldType = FIELDTYPE_TEXT;
            }
            String label = operand.getLabel();
            String dflt = operand.getUserDefault();
            List cacheKey = Misc.newList(label, fieldType);
            Object cachedOperand = this.operandCache.get(cacheKey);
            if (cachedOperand != null) {
                dflt = cachedOperand;
            }
            JCheckBox cbx = new JCheckBox("", operand.isPersistent());
            persistentCbxs.add(cbx);
            JComponent field = null;
            JComponent fieldComp = null;
            switch (fieldType) {
                case "text": {
                    int rows;
                    String rowString = operand.getProperty("rows");
                    if (rowString == null) {
                        rowString = "1";
                    }
                    if ((rows = new Integer(rowString).intValue()) == 1) {
                        field = new JTextField(dflt != null ? dflt.toString() : "", 15);
                        break;
                    }
                    field = new JTextArea(dflt != null ? dflt.toString() : "", rows, 15);
                    fieldComp = GuiUtils.makeScrollPane(field, 200, 100);
                    break;
                }
                case "boolean": {
                    field = new JCheckBox("", dflt != null ? new Boolean(dflt.toString()) : true);
                    break;
                }
                case "choice": {
                    String choices = operand.getProperty("choices");
                    if (choices == null) {
                        throw new IllegalArgumentException("No 'choices' attribute defined for operand: " + operand);
                    }
                    List<String> l = StringUtil.split(choices, ";", true, true);
                    field = new JComboBox<String>(new Vector<String>(l));
                    if (dflt == null || !l.contains(dflt)) break;
                    ((JComboBox)field).setSelectedItem(dflt);
                    break;
                }
                case "file": {
                    JTextField fileFld = new JTextField(dflt != null ? dflt.toString() : "", 30);
                    field = fileFld;
                    String patterns = operand.getProperty("filepattern");
                    ArrayList<PatternFileFilter> filters = null;
                    if (patterns != null) {
                        filters = new ArrayList<PatternFileFilter>();
                        List<String> toks = StringUtil.split(patterns, ";", true, true);
                        for (int tokIdx = 0; tokIdx < toks.size(); ++tokIdx) {
                            String tok = toks.get(tokIdx);
                            List<String> subToks = StringUtil.split(tok, ":", true, true);
                            if (subToks.size() == 2) {
                                filters.add(new PatternFileFilter(subToks.get(0), subToks.get(1)));
                                continue;
                            }
                            filters.add(new PatternFileFilter(tok, tok));
                        }
                    }
                    fieldComp = GuiUtils.centerRight(GuiUtils.hfill(fileFld), GuiUtils.makeFileBrowseButton(fileFld, filters));
                    break;
                }
                case "location": {
                    ArrayList l = dflt != null ? StringUtil.split(dflt.toString(), ";", true, true) : new ArrayList();
                    final LatLonWidget llw = new LatLonWidget();
                    field = llw;
                    if (l.size() == 2) {
                        llw.setLat(Misc.decodeLatLon(l.get(0).toString()));
                        llw.setLon(Misc.decodeLatLon(l.get(1).toString()));
                    }
                    final JButton centerPopupBtn = GuiUtils.getImageButton("/auxdata/ui/icons/Map16.gif", this.getClass());
                    centerPopupBtn.setToolTipText("Center on current displays");
                    centerPopupBtn.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent ae) {
                            IdvUIManager.this.popupCenterMenu(centerPopupBtn, llw);
                        }
                    });
                    JPanel centerPopup = GuiUtils.inset((Component)centerPopupBtn, new Insets(0, 0, 0, 4));
                    fieldComp = GuiUtils.hbox((Component)llw, centerPopup);
                    break;
                }
                case "area": {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown type: " + fieldType + " for operand: " + operand);
                }
            }
            fields.add((JCheckBox)field);
            label = StringUtil.replace(label, "_", " ");
            components.add(GuiUtils.rLabel(label));
            components.add(fieldComp != null ? fieldComp : field);
            components.add(cbx);
        }
        GuiUtils.tmpInsets = GuiUtils.INSETS_5;
        JPanel contents = GuiUtils.topCenter(new JLabel(msg), GuiUtils.doLayout(components, 3, GuiUtils.WT_NYN, GuiUtils.WT_N));
        if (!GuiUtils.showOkCancelDialog(null, "Select input", contents, null, fields)) {
            return null;
        }
        ArrayList<UserOperandValue> values = new ArrayList<UserOperandValue>();
        for (int i = 0; i < userOperands.size(); ++i) {
            DataOperand operand = (DataOperand)userOperands.get(i);
            String label = operand.getLabel();
            Object field = fields.get(i);
            Object value = null;
            String cacheValue = null;
            if (field instanceof JTextComponent) {
                value = ((JTextComponent)field).getText().trim();
            } else if (field instanceof JCheckBox) {
                value = new Boolean(((JCheckBox)field).isSelected());
            } else if (field instanceof JComboBox) {
                value = ((JComboBox)field).getSelectedItem();
            } else if (field instanceof LatLonWidget) {
                LatLonWidget llw = (LatLonWidget)field;
                value = new LatLonPointImpl(llw.getLat(), llw.getLon());
                cacheValue = llw.getLat() + ";" + llw.getLon();
            } else {
                throw new IllegalArgumentException("Unknown field type:" + field.getClass().getName());
            }
            if (cacheValue == null) {
                cacheValue = value;
            }
            JCheckBox cbx = (JCheckBox)persistentCbxs.get(i);
            String fieldType = operand.getProperty("type");
            if (fieldType == null) {
                fieldType = FIELDTYPE_TEXT;
            }
            List cacheKey = Misc.newList(label, fieldType);
            this.operandCache.put(cacheKey, cacheValue);
            values.add(new UserOperandValue(value, cbx.isSelected()));
        }
        this.getStore().putEncodedFile("operandcache.xml", this.operandCache);
        return values;
    }

    private void runHaiku(JLabel[] lbl) {
        int cnt = 0;
        while (lbl[0] != null) {
            if (cnt >= this.haikus.size()) {
                cnt = 0;
            }
            if (lbl[0] == null) break;
            lbl[0].setText("<html><div style=\"color:white; font-size:50\">" + this.haikus.get(cnt) + "</div></html>");
            ++cnt;
            try {
                Misc.sleep(6000L);
            }
            catch (Exception exception) {}
        }
    }

    private void doHaiku() {
        if (this.haikus == null) {
            String list;
            this.haikus = new ArrayList();
            while ((list = this.getIdv().getProperty("haiku" + (this.haikus.size() + 1), null)) != null) {
                this.haikus.add(list);
            }
        }
        final Window f = new Window(this.getFrame());
        final JLabel[] lbl = new JLabel[]{new JLabel("  ")};
        JPanel p = GuiUtils.leftCenter(new JLabel("             "), GuiUtils.topCenter(null, lbl[0]));
        GuiUtils.setBackgroundOnTree(p, Color.blue);
        p.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                super.mousePressed(e);
                lbl[0] = null;
                f.setVisible(false);
            }
        });
        Misc.runInABit(2000L, new Runnable(){

            @Override
            public void run() {
                IdvUIManager.this.runHaiku(lbl);
            }
        });
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        screenSize = new Dimension(screenSize.width + 20, screenSize.height + 20);
        p.setMinimumSize(screenSize);
        p.setPreferredSize(screenSize);
        f.add(p);
        f.pack();
        f.setLocation(-10, -10);
        f.setVisible(true);
    }

    public boolean checkHaiku(String action) {
        if (this.haikus == null) {
            List<String> haikuUsers = StringUtil.split(this.getIdv().getProperty("haiku.users", ""), ";", true, true);
            this.haikuActions = StringUtil.split(this.getIdv().getProperty("haiku.actions", ""), ";", true, true);
            this.haikuUserOk = haikuUsers.contains(this.getStateManager().getUserName());
        }
        if (!this.haikuUserOk) {
            return false;
        }
        this.haikuUserOk = false;
        String key = "nohaikus";
        if (this.getStateManager().getPreferenceOrProperty(key) != null) {
            if (this.getStateManager().getProperty(key) != null) {
                this.getStore().put(key, true);
                this.getStore().save();
            }
            this.haikuUserOk = false;
            return false;
        }
        if (StringUtil.findMatch(action, this.haikuActions, null) != null) {
            this.doHaiku();
            return true;
        }
        return false;
    }

    public void captureImage(String filename) {
        this.getImageGenerator().captureImage(filename);
    }

    public synchronized void captureMovie(String filename) {
        this.getImageGenerator().captureMovie(filename);
    }

    public void showSupportForm() {
        this.showSupportForm("", "");
    }

    private void append(StringBuffer sb, String name, Object value) {
        sb.append("<b>" + name + "</b>: " + value + "<br>");
    }

    public void showSupportForm(String description, String stackTrace) {
        this.showSupportForm(description, stackTrace, null);
    }

    public void showSupportForm(final String description, final String stackTrace, final JDialog dialog) {
        Misc.run(new Runnable(){

            @Override
            public void run() {
                IdvUIManager.this.showSupportFormInThread(description, stackTrace, dialog);
            }
        });
    }

    public StringBuffer getSystemInfo() {
        StringBuffer extra = new StringBuffer();
        extra.append("<h3>OS</h3>\n");
        this.append(extra, "os.name", System.getProperty("os.name"));
        this.append(extra, "os.arch", System.getProperty("os.arch"));
        this.append(extra, "os.version", System.getProperty("os.version"));
        extra.append("<h3>Java</h3>\n");
        this.append(extra, "java.vendor", System.getProperty("java.vendor"));
        this.append(extra, "java.version", System.getProperty("java.version"));
        this.append(extra, "java.home", System.getProperty("java.home"));
        this.append(extra, "java.heap", Misc.format((double)Runtime.getRuntime().maxMemory() / 1000000.0) + " " + Msg.msg("MB"));
        this.append(extra, "ncIdv.version", LibVersionUtil.getNcidvVersion());
        return extra;
    }

    private void showSupportFormInThread(String description, String stackTrace, JDialog dialog) {
        StringBuffer extra = this.getSystemInfo();
        ArrayList<HttpFormEntry> entries = new ArrayList<HttpFormEntry>();
        StringBuffer javaInfo = new StringBuffer();
        javaInfo.append("Java: home: " + System.getProperty("java.home"));
        javaInfo.append(" version: " + System.getProperty("java.version"));
        Class<?> c = null;
        try {
            c = Class.forName("javax.media.j3d.VirtualUniverse");
            Method method = Misc.findMethod(c, "getProperties", new Class[0]);
            if (method == null) {
                javaInfo.append("j3d <1.3");
            } else {
                try {
                    Map m = (Map)method.invoke(c, new Object[0]);
                    javaInfo.append(" j3d:" + m.get("j3d.version"));
                    this.append(extra, "j3d.version", m.get("j3d.version"));
                    this.append(extra, "j3d.vendor", m.get("j3d.vendor"));
                    this.append(extra, "j3d.renderer", m.get("j3d.renderer"));
                }
                catch (Exception exc) {
                    javaInfo.append(" j3d:unknown");
                }
            }
        }
        catch (ClassNotFoundException exc) {
            this.append(extra, "j3d", "none");
        }
        extra.append(this.getIdv().getDataManager().getDataSourceHtml());
        extra.append(this.getIdv().getPluginManager().getPluginHtml());
        extra.append(this.getResourceManager().getHtmlView());
        HttpFormEntry nameEntry = new HttpFormEntry(1, "fullName", "Name:", this.getStore().get(PROP_HELP_NAME, (String)null));
        entries.add(nameEntry);
        HttpFormEntry emailEntry = new HttpFormEntry(1, "emailAddress", "Your Email:", this.getStore().get(PROP_HELP_EMAIL, (String)null));
        entries.add(emailEntry);
        HttpFormEntry orgEntry = new HttpFormEntry(1, "organization", "Organization:", this.getStore().get(PROP_HELP_ORG, (String)null));
        entries.add(orgEntry);
        entries.add(new HttpFormEntry(1, "subject", "Subject:"));
        String nag = this.getProperty("idv.supportform.message", "");
        entries.add(new HttpFormEntry(3, "", nag));
        HttpFormEntry descriptionEntry = new HttpFormEntry(2, ATTR_DESCRIPTION, "Description:", description, 5, 30, true);
        entries.add(descriptionEntry);
        entries.add(new HttpFormEntry(4, "attachmentThree", "Attachment:", "", false));
        entries.add(new HttpFormEntry(0, "submit", "", "Send Email"));
        entries.add(new HttpFormEntry(0, "softwarePackage", "", this.getStateManager().getProperty(PROP_SUPPORT_PACKAGE, "idv")));
        entries.add(new HttpFormEntry(0, "packageVersion", "", this.getStateManager().getVersion() + " build date:" + this.getStateManager().getBuildDate()));
        entries.add(new HttpFormEntry(0, "os", "", System.getProperty("os.name")));
        entries.add(new HttpFormEntry(0, "hardware", "", javaInfo.toString()));
        JLabel topLabel = new JLabel("<html>" + this.getStateManager().getProperty(PROP_SUPPORT_MESSAGE, "") + "<br>" + "</html>");
        JCheckBox includeBundleCbx = new JCheckBox("Include Current State as Bundle", true);
        boolean alreadyHaveDialog = true;
        if (dialog == null) {
            dialog = GuiUtils.createDialog(LogUtil.getCurrentWindow(), "Support Request Form", true);
            alreadyHaveDialog = false;
        }
        JLabel statusLabel = GuiUtils.cLabel(" ");
        JPanel bottom = GuiUtils.vbox((Component)GuiUtils.left(includeBundleCbx), statusLabel);
        while (true) {
            statusLabel.setText(" ");
            if (!HttpFormEntry.showUI(entries, GuiUtils.inset((Component)topLabel, 10), bottom, dialog, alreadyHaveDialog)) break;
            statusLabel.setText("Posting support request...");
            this.getStore().put(PROP_HELP_NAME, (Object)nameEntry.getValue());
            this.getStore().put(PROP_HELP_ORG, (Object)orgEntry.getValue());
            this.getStore().put(PROP_HELP_EMAIL, (Object)emailEntry.getValue());
            this.getStore().save();
            ArrayList<HttpFormEntry> entriesToPost = new ArrayList<HttpFormEntry>(entries);
            if (stackTrace != null && stackTrace.length() > 0) {
                entriesToPost.remove(descriptionEntry);
                String newDescription = descriptionEntry.getValue() + "\n\n******************\nStack trace:\n" + stackTrace;
                entriesToPost.add(new HttpFormEntry(0, ATTR_DESCRIPTION, "Description:", newDescription, 5, 30, true));
            }
            try {
                String[] results;
                entriesToPost.add(new HttpFormEntry("attachmentOne", "extra.html", extra.toString().getBytes()));
                if (includeBundleCbx.isSelected()) {
                    entriesToPost.add(new HttpFormEntry("attachmentTwo", "bundle.xidv", this.getIdv().getPersistenceManager().getBundleXml(true).getBytes()));
                }
                if ((results = HttpFormEntry.doPost(entriesToPost, "https://www.unidata.ucar.edu/support/requestSupport.jsp"))[0] != null) {
                    GuiUtils.showHtmlDialog(results[0], "Support Request Response - Error", "Support Request Response - Error", null, true);
                    continue;
                }
                String html = results[1];
                if (html.toLowerCase().indexOf("your email has been sent") >= 0 || html.toLowerCase().indexOf("your request has been sent") >= 0) {
                    LogUtil.userMessage("Your support request has been sent");
                    break;
                }
                GuiUtils.showHtmlDialog(html, "Unknown Support Request Response", "Unknown Support Request Response<br>Note: This form is inactive", null, true);
            }
            catch (Exception exc) {
                LogUtil.logException("Doing support request form", exc);
            }
        }
        dialog.dispose();
    }

    public void addToolbarPreferences(IdvPreferenceManager preferenceManager) {
        if (this.toolbarEditor == null) {
            this.toolbarEditor = new ToolbarEditor(this);
        }
        PreferenceManager toolbarManager = new PreferenceManager(){

            @Override
            public void applyPreference(XmlObjectStore theStore, Object data) {
                if (IdvUIManager.this.toolbarEditor.anyChanges()) {
                    IdvUIManager.this.toolbarEditor.doApply();
                    IdvUIManager.this.updateIconBar();
                }
            }
        };
        preferenceManager.add("Toolbar", "Toolbar icons", toolbarManager, this.toolbarEditor.getContents(), this.toolbarEditor);
    }

    public void setDateFormat() {
        TimeZone tz = this.getIdv().getPreferenceManager().getDefaultTimeZone();
        String dateFormat = this.getIdv().getPreferenceManager().getDefaultDateFormat();
        DateTimePicker.setDefaultTimeZone(tz);
        Timeline.setDateFormat(dateFormat);
        Timeline.setTimeZone(tz);
        if (!tz.equals(DateTime.DEFAULT_TIMEZONE) || !dateFormat.equals("yyyy-MM-dd HH:mm:ss z")) {
            DateTime.setFormatTimeZone(tz);
            DateTime.setFormatPattern(dateFormat);
        } else {
            DateTime.resetFormat();
        }
    }

    private static List sortParamNames(List listToSort) {
        Comparator comparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                String s1 = o1.toString().toLowerCase();
                String s2 = o2.toString().toLowerCase();
                return s1.compareTo(s2);
            }
        };
        Object[] array = listToSort.toArray();
        Arrays.sort(array, comparator);
        return Arrays.asList(array);
    }

    public static List getParamsMenuItems(final JTextComponent fld, final String delimiter, boolean includeAliases) {
        List names = DataChoice.getCurrentNames();
        names = IdvUIManager.sortParamNames(names);
        ArrayList<JMenu> topItems = new ArrayList<JMenu>();
        ArrayList<Component> items = new ArrayList<Component>();
        Hashtable<String, JMenu> catMenus = new Hashtable<String, JMenu>();
        for (int i = 0; i < names.size(); ++i) {
            String name;
            final Object obj = names.get(i);
            String label = name = obj.toString();
            JMenu subMenu = null;
            List<String> toks = StringUtil.split(name, ">", true, true);
            if (toks.size() == 2) {
                String group = toks.get(0);
                label = toks.get(1);
                subMenu = (JMenu)catMenus.get(group);
                if (subMenu == null) {
                    subMenu = new JMenu(group);
                    catMenus.put(group, subMenu);
                    items.add(subMenu);
                }
            }
            JMenuItem mi = new JMenuItem(label);
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    String name = obj instanceof TwoFacedObject ? ((TwoFacedObject)obj).getId().toString() : obj.toString();
                    if (delimiter != null) {
                        GuiUtils.appendText(fld, name, delimiter);
                    } else {
                        fld.setText(name);
                    }
                    ActionListener[] listeners = null;
                    if (fld instanceof JTextField) {
                        listeners = ((JTextField)fld).getActionListeners();
                    }
                    ActionEvent action = new ActionEvent(fld, 0, "changed");
                    if (listeners != null) {
                        for (int i = 0; i < listeners.length; ++i) {
                            listeners[i].actionPerformed(action);
                        }
                    }
                }
            });
            if (subMenu == null) {
                items.add(mi);
                continue;
            }
            subMenu.add(mi);
        }
        if (items.size() > 0) {
            JMenu namesMenu = GuiUtils.makeMenu("Current Fields", items);
            topItems.add(namesMenu);
        }
        if (includeAliases) {
            items = new ArrayList();
            List aliases = DataAlias.getDataAliasList();
            for (int i = 0; i < aliases.size(); ++i) {
                DataAlias dataAlias = (DataAlias)aliases.get(i);
                final String name = dataAlias.getName();
                String lbl = dataAlias.getName();
                if (dataAlias.getLabel() != null && dataAlias.getLabel().length() > 0) {
                    lbl = dataAlias.getLabel() + " (" + lbl + ")";
                }
                JMenuItem mi = new JMenuItem(lbl);
                mi.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        if (delimiter != null) {
                            GuiUtils.appendText(fld, name, delimiter);
                        } else {
                            fld.setText(name);
                        }
                        ActionListener[] listeners = null;
                        if (fld instanceof JTextField) {
                            listeners = ((JTextField)fld).getActionListeners();
                        }
                        ActionEvent action = new ActionEvent(fld, 0, "changed");
                        if (listeners != null) {
                            for (int i = 0; i < listeners.length; ++i) {
                                listeners[i].actionPerformed(action);
                            }
                        }
                    }
                });
                items.add(mi);
            }
            topItems.add(GuiUtils.makeMenu("Aliases", items));
        }
        JMenu dummy = GuiUtils.makeMenu("", topItems);
        items = new ArrayList();
        GuiUtils.limitMenuSize(dummy, "Group #", 20);
        for (int i = 0; i < dummy.getItemCount(); ++i) {
            items.add(dummy.getMenuComponent(i));
        }
        if (items.size() == 0) {
            items.add(new JMenuItem("No parameters"));
        }
        return items;
    }

    public static void showParamsPopup(JTextComponent fld, MouseEvent e, String delimiter, boolean includeAliases) {
        List items = IdvUIManager.getParamsMenuItems(fld, delimiter, includeAliases);
        JPopupMenu popup = GuiUtils.makePopupMenu(items);
        popup.show(fld, e.getX(), e.getY());
    }

    public static JTextField doMakeParamField(final String delimiter, final boolean includeAliases) {
        final JTextField fld = new JTextField("", 20);
        if (delimiter == null) {
            fld.setToolTipText("<html>Parameter name<br>Right mouse to set parameter name</html>");
        } else {
            fld.setToolTipText("<html>Comma separated list of parameter names<br>Right mouse to add parameter names</html>");
        }
        fld.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    IdvUIManager.showParamsPopup(fld, e, delimiter, includeAliases);
                }
            }
        });
        return fld;
    }

    public void popupCenterMenu(JComponent near, final LatLonWidget latLonWidget) {
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                try {
                    EarthLocation el = (EarthLocation)ae.getSource();
                    latLonWidget.setLatLon(Misc.format(el.getLatitude().getValue()), Misc.format(Misc.normalizeLongitude(el.getLongitude().getValue())));
                }
                catch (Exception exc) {
                    IdvManager.logException("Setting center", exc);
                }
            }
        };
        List menuItems = this.makeCenterMenus(listener);
        if (menuItems.size() == 0) {
            menuItems.add(new JMenuItem("No map displays"));
        }
        GuiUtils.showPopupMenu(menuItems, near);
    }

    public List makeCenterMenus(ActionListener listener) {
        ArrayList<JMenu> menus = new ArrayList<JMenu>();
        List vms = this.getIdv().getVMManager().getViewManagers(MapViewManager.class);
        try {
            for (int i = 0; i < vms.size(); ++i) {
                MapViewManager mvm = (MapViewManager)vms.get(i);
                List<TwoFacedObject> l = mvm.getScreenCoordinates();
                ArrayList<JMenu> menuItemList = vms.size() == 1 ? menus : new ArrayList<JMenu>();
                for (TwoFacedObject tfo : l) {
                    menuItemList.add((JMenu)this.makeLocationMenuItem((EarthLocation)tfo.getId(), tfo.toString(), listener));
                }
                if (vms.size() <= 1) continue;
                String name = mvm.getName();
                if (name == null || name.length() == 0) {
                    name = "View " + (i + 1);
                }
                menus.add(GuiUtils.makeMenu(name, menuItemList));
            }
        }
        catch (Exception exc) {
            IdvUIManager.logException("Making center menu", exc);
        }
        return menus;
    }

    private JMenuItem makeLocationMenuItem(final EarthLocation el, String name, final ActionListener listener) {
        LatLonPoint llp = el.getLatLonPoint();
        JMenuItem mi = new JMenuItem(StringUtil.padRight(name + ": ", 15, " ") + this.getIdv().getDisplayConventions().formatLatLonPoint(llp));
        GuiUtils.setFixedWidthFont(mi);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                listener.actionPerformed(new ActionEvent(el, 1, "name"));
            }
        });
        return mi;
    }

    public List getMapLocations() {
        try {
            ArrayList<LatLonPointImpl> centers = new ArrayList<LatLonPointImpl>();
            List<ViewManager> vms = this.getIdv().getVMManager().getViewManagers();
            for (int i = 0; i < vms.size(); ++i) {
                ViewManager vm = vms.get(i);
                if (!(vm instanceof MapViewManager)) continue;
                MapViewManager mvm = (MapViewManager)vm;
                EarthLocation el = mvm.getScreenCenter();
                centers.add(new LatLonPointImpl(el.getLatitude().getValue(), el.getLongitude().getValue()));
            }
            return centers;
        }
        catch (Exception exc) {
            throw new WrapperException(exc);
        }
    }

    static {
        ICON_REMOVE = GuiUtils.getImageIcon("/ucar/unidata/idv/images/delete.png");
        ICON_LOCK = GuiUtils.getImageIcon("/ucar/unidata/idv/images/lock.png");
        ICON_UNLOCK = GuiUtils.getImageIcon("/ucar/unidata/idv/images/lock_open.png");
        timeSinceLastWait = 0L;
        startTime = 0L;
    }

    private static class MyMenuListener
    implements MenuListener,
    Removable {
        IdvUIManager idvUIManager;
        IdvWindow idvWindow;
        JMenu menu;
        String menuId;

        public MyMenuListener(IdvUIManager idvUIManager, IdvWindow idvWindow, JMenu menu, String menuId) {
            this.idvUIManager = idvUIManager;
            this.idvWindow = idvWindow;
            this.menu = menu;
            this.menuId = menuId;
        }

        @Override
        public void menuCanceled(MenuEvent e) {
        }

        @Override
        public void menuDeselected(MenuEvent e) {
            this.idvUIManager.handleMenuDeSelected(this.menuId, this.menu, this.idvWindow);
        }

        @Override
        public void menuSelected(MenuEvent e) {
            this.idvUIManager.handleMenuSelected(this.menuId, this.menu, this.idvWindow);
        }

        @Override
        public void doRemove() {
            this.idvUIManager = null;
            this.idvWindow = null;
            this.menu = null;
        }
    }
}

