/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.ui;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.itc.idv.math.SunriseSunsetCollector;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.ui.LatLonWidget;
import ucar.unidata.ui.Timeline;
import ucar.unidata.util.DateUtil;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.Misc;

public class IdvTimeline
extends Timeline {
    private LatLonPoint sunriseLocation;
    private List sunriseLocations;

    public IdvTimeline() {
    }

    public IdvTimeline(List times, int initDimension) {
        super(times, initDimension);
    }

    public IdvTimeline(List times, int width, int height) {
        super(times, width, height);
    }

    public IdvTimeline(Date start, Date end) {
        super(start, end);
    }

    public IdvTimeline(Date start, Date end, int initDimension) {
        super(start, end, initDimension);
    }

    @Override
    protected void getMenuItems(List items) {
        super.getMenuItems(items);
        List sunriseLocations = this.getSunriseLocations();
        ArrayList<Object> subItems = new ArrayList<Object>();
        subItems.add(GuiUtils.makeMenuItem("Clear Location", this, "clearSunriseLocation"));
        subItems.add(GuiUtils.makeMenuItem("Set Location", this, "setSunriseLocationFromUser"));
        if (this.sunriseLocation != null && this.getIsCapableOfSelection()) {
            subItems.add(GuiUtils.makeMenuItem("Select daytime", this, "selectDaytime"));
        }
        if (sunriseLocations != null && sunriseLocations.size() > 0) {
            subItems.add("separator");
            for (int locIdx = 0; locIdx < sunriseLocations.size(); ++locIdx) {
                LatLonPoint llp = (LatLonPoint)sunriseLocations.get(locIdx);
                subItems.add(GuiUtils.makeMenuItem(Misc.format(llp.getLatitude()) + "/" + Misc.format(llp.getLongitude()), this, "setSunriseLocation", llp));
            }
        }
        items.add(GuiUtils.makeMenu("Sunrise/Sunset", subItems));
    }

    @Override
    public void timelineChanged() {
        super.timelineChanged();
        this.makeSunriseDates();
        this.repaint();
    }

    public List getSunriseLocations() {
        return this.sunriseLocations;
    }

    public void setSunriseLocationFromUser() {
        LatLonWidget llw;
        LatLonWidget latLonWidget = llw = this.sunriseLocation != null ? new LatLonWidget(this.sunriseLocation.getLatitude(), this.sunriseLocation.getLongitude()) : new LatLonWidget(0.0, 0.0);
        if (!GuiUtils.showOkCancelDialog(null, "Sunrise Location", GuiUtils.inset((Component)llw, 5), null)) {
            return;
        }
        this.setSunriseLocation(new LatLonPointImpl(llw.getLat(), llw.getLon()));
    }

    public void setSunriseLocations(List locations) {
        this.sunriseLocations = locations;
    }

    public void clearSunriseLocation() {
        this.setSunriseLocation(null);
    }

    public void setSunriseLocation(LatLonPoint llp) {
        this.sunriseLocation = llp;
        this.makeSunriseDates();
        this.repaint();
    }

    @Override
    public void makeSunriseDates() {
        this.sunriseDates = IdvTimeline.makeSunriseDates(this.sunriseLocation, this.getStartDate(), this.getEndDate());
    }

    public static List makeSunriseDates(LatLonPoint sunriseLocation, Date startDate, Date endDate) {
        ArrayList<Date> sunriseDates = new ArrayList<Date>();
        if (sunriseLocation == null) {
            return sunriseDates;
        }
        try {
            GregorianCalendar gc1 = new GregorianCalendar();
            gc1.setTime(new Date(startDate.getTime() - DateUtil.hoursToMillis(48.0)));
            GregorianCalendar gc2 = new GregorianCalendar();
            gc2.setTime(new Date(endDate.getTime() + DateUtil.hoursToMillis(48.0)));
            List dates = Misc.newList(gc1, gc2);
            SunriseSunsetCollector ssc = new SunriseSunsetCollector(dates);
            List cals = ssc.calculate(sunriseLocation.getLatitude(), sunriseLocation.getLongitude());
            for (int i = 0; i < cals.size(); i += 2) {
                GregorianCalendar cal1 = (GregorianCalendar)cals.get(i);
                GregorianCalendar cal2 = (GregorianCalendar)cals.get(i + 1);
                Date d1 = cal1.getTime();
                Date d2 = cal2.getTime();
                if (d1.getTime() > d2.getTime()) {
                    Date tmp = d1;
                    d1 = d2;
                    d2 = tmp;
                }
                sunriseDates.add(d1);
                sunriseDates.add(d2);
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        return sunriseDates;
    }
}

