/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.FileOutputStream;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;
import ucar.unidata.idv.IntegratedDataViewer;
import ucar.unidata.ui.AudioPlayer;
import ucar.unidata.ui.RovingProgress;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.Msg;
import ucar.unidata.util.ObjectListener;
import ucar.unidata.util.Resource;
import ucar.unidata.util.StringUtil;

public class IdvSplash
extends JWindow {
    IntegratedDataViewer idv;
    JLabel splashLbl;
    private String splashTitle = null;
    private ImageIcon splashIcon;
    private ImageIcon splashRolloverIcon;
    private RovingProgress splashProgressBar;
    boolean playedOnce = false;

    public IdvSplash(IntegratedDataViewer idv) {
        this.idv = idv;
        this.init();
    }

    public void splashMsg(String m) {
        if (this.splashLbl != null) {
            this.splashLbl.setText(" " + Msg.msg(m) + " ");
        }
    }

    public void doClose() {
        if (this.splashProgressBar != null) {
            this.splashProgressBar.stop();
        }
        this.setVisible(false);
        this.dispose();
    }

    private void init() {
        JLabel image;
        try {
            this.splashTitle = this.idv.getProperty("idv.ui.splash.title", "");
            this.splashTitle = this.idv.getResourceManager().getResourcePath(this.splashTitle);
            this.splashTitle = StringUtil.replace(this.splashTitle, "%IDV.TITLE%", this.idv.getProperty("idv.title", "Unidata IDV"));
            this.splashIcon = GuiUtils.getImageIcon(this.idv.getProperty("idv.ui.splash.icon", "/ucar/unidata/idv/images/logo.gif"));
            this.splashRolloverIcon = GuiUtils.getImageIcon(this.idv.getProperty("idv.ui.splash.iconroll", "/ucar/unidata/idv/images/logo_rollover.gif"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        JLabel jLabel = image = this.splashIcon != null ? new JLabel(this.splashIcon) : new JLabel("Unidata IDV");
        if (this.splashIcon != null && this.splashRolloverIcon != null) {
            int width = Math.max(this.splashIcon.getIconWidth(), this.splashRolloverIcon.getIconWidth());
            int height = Math.max(this.splashIcon.getIconHeight(), this.splashRolloverIcon.getIconHeight());
            image.setPreferredSize(new Dimension(width, height));
        }
        image.addMouseListener(new ObjectListener(image){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (IdvSplash.this.splashRolloverIcon != null) {
                    ((JLabel)e.getSource()).setIcon(IdvSplash.this.splashRolloverIcon);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (IdvSplash.this.splashIcon != null) {
                    ((JLabel)e.getSource()).setIcon(IdvSplash.this.splashIcon);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 1 && e.isControlDown()) {
                    ImageIcon beerImage = new ImageIcon(Resource.getImage("/ucar/unidata/idv/images/beer.gif"));
                    JDialog d = new JDialog();
                    JPanel contents = new JPanel(new BorderLayout());
                    contents.add("North", new JLabel("Congratulations, you found the Easter egg!"));
                    contents.add("Center", new JLabel(IdvSplash.this.idv.getProperty("idv.ui.splash.eastermsg", "")));
                    JButton b = new JButton(beerImage);
                    b.setPreferredSize(new Dimension(beerImage.getIconHeight(), beerImage.getIconWidth()));
                    b.addActionListener(new ObjectListener(d){

                        @Override
                        public void actionPerformed(ActionEvent event) {
                            ((JDialog)this.theObject).setVisible(false);
                        }
                    });
                    contents.add("East", GuiUtils.inset((Component)b, 4));
                    GuiUtils.packDialog(d, contents);
                    Dimension ss = Toolkit.getDefaultToolkit().getScreenSize();
                    d.setLocation(ss.width / 2 - 100, ss.height / 2 - 100);
                    d.setVisible(true);
                }
            }

            private /* synthetic */ void lambda$mouseEntered$2() {
                try {
                    String audioFile = IdvSplash.this.idv.getStore().getTmpFile("splash.wav");
                    IOUtil.writeTo(IOUtil.getInputStream("/auxdata/ui/icons/test.gif"), new FileOutputStream(audioFile));
                    AudioPlayer audioPlayer = new AudioPlayer();
                    audioPlayer.setFile(audioFile);
                    audioPlayer.startPlaying();
                    IdvSplash.this.playedOnce = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.splashLbl = GuiUtils.cLabel(" ");
        this.splashLbl.setForeground(Color.gray);
        this.splashProgressBar = new RovingProgress();
        this.splashProgressBar.start();
        this.splashProgressBar.setBorder(BorderFactory.createLineBorder(Color.gray));
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(ae -> System.exit(0));
        if (this.splashTitle == null || this.splashTitle.trim().equals("")) {
            String version = this.idv.getStateManager().getVersion();
            String title = this.idv.getStateManager().getTitle();
            this.splashTitle = title + " " + version;
        }
        JLabel versionLabel = GuiUtils.cLabel("<html><center><b>" + this.splashTitle + "</center></b></html>");
        JPanel imagePanel = GuiUtils.inset((Component)image, new Insets(4, 35, 0, 35));
        JPanel titlePanel = GuiUtils.center(versionLabel);
        JPanel barPanel = GuiUtils.inset((Component)this.splashProgressBar, new Insets(4, 1, 1, 1));
        JPanel topPanel = GuiUtils.vbox(imagePanel, titlePanel, barPanel);
        topPanel = GuiUtils.centerBottom(topPanel, this.splashLbl);
        JPanel contents = GuiUtils.topCenter(topPanel, GuiUtils.inset((Component)GuiUtils.wrap(cancelButton), 4));
        JPanel outer = GuiUtils.center(contents);
        contents.setBorder(BorderFactory.createBevelBorder(0));
        outer.setBorder(BorderFactory.createBevelBorder(0, Color.gray, Color.gray));
        this.getContentPane().add(outer);
        this.pack();
        Dimension size = this.getSize();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(screenSize.width / 2 - size.width / 2, screenSize.height / 2 - size.height / 2);
        Msg.translateTree(this);
        this.setVisible(true);
        this.toFront();
    }
}

