/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.ui;

import java.awt.Color;
import java.awt.Point;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import ucar.unidata.idv.DisplayControl;
import ucar.unidata.idv.ViewManager;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.Removable;
import ucar.unidata.util.Resource;

public abstract class IdvLegend
implements Removable {
    public static final String STATE_HIDDEN = "hidden";
    public static final String STATE_DOCKED = "docked";
    public static final String STATE_FLOAT = "float";
    public static final ImageIcon ICON_FLOAT = GuiUtils.getImageIcon("/auxdata/ui/icons/application_get.png");
    public static final ImageIcon ICON_DOCKED = GuiUtils.getImageIcon("/auxdata/ui/icons/application_put.png");
    protected static ImageIcon ICON_PROPERTIES = new ImageIcon(Resource.getImage("/auxdata/ui/icons/information.png"));
    public static ImageIcon ICON_REMOVE = new ImageIcon(Resource.getImage("/auxdata/ui/icons/delete.png"));
    protected ViewManager viewManager;
    private JComponent container;
    private JComponent contents;
    private JButton floatBtn;
    private JFrame floatFrame;
    private boolean closed = false;
    private Point lastLocation = new Point(20, 20);
    private Object MUTEX = new Object();

    public IdvLegend() {
    }

    public IdvLegend(ViewManager viewManager) {
        this.viewManager = viewManager;
    }

    public void setContentsToUse(JComponent contents) {
        this.contents = contents;
    }

    public JComponent getContents() {
        if (this.contents == null) {
            this.contents = this.doMakeContents();
        }
        return this.contents;
    }

    public void setViewManager(ViewManager viewManager) {
        this.viewManager = viewManager;
    }

    public void setTheContainer(JComponent value) {
        this.container = value;
    }

    public JComponent getContainer() {
        return this.container;
    }

    public void setColors(Color foreground, Color background) {
    }

    protected JButton getFloatButton() {
        if (this.floatBtn == null) {
            this.floatBtn = GuiUtils.getImageButton("/auxdata/ui/icons/Export16.gif", this.getClass());
            this.setFloatToolTip();
            this.floatBtn.addActionListener(ae -> {
                if (this.floatFrame != null) {
                    this.viewManager.setLegendState(this, STATE_DOCKED);
                } else {
                    this.viewManager.setLegendState(this, STATE_FLOAT);
                }
            });
        }
        return this.floatBtn;
    }

    public void showLegend() {
        if (this.closed) {
            return;
        }
        if (this.floatFrame == null) {
            this.floatLegend();
        } else if (this.floatFrame != null) {
            this.floatFrame.setState(0);
            this.floatFrame.setVisible(true);
        }
        this.setFloatToolTip();
    }

    private void setFloatToolTip() {
        if (this.floatBtn != null) {
            if (this.floatFrame != null) {
                this.floatBtn.setIcon(ICON_DOCKED);
                this.floatBtn.setToolTipText("Embed the legend");
            } else {
                this.floatBtn.setIcon(ICON_FLOAT);
                this.floatBtn.setToolTipText("Float the legend");
            }
        }
    }

    protected abstract JComponent doMakeContents();

    public final void fillLegend() {
        if (this.viewManager == null) {
            return;
        }
        SwingUtilities.invokeLater(() -> this.fillLegendInner());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void fillLegendInner() {
        Object object = this.MUTEX;
        synchronized (object) {
            if (this.viewManager == null) {
                return;
            }
            this.fillLegendSafely();
            if (this.contents != null) {
                this.contents.validate();
                this.contents.repaint();
            }
        }
    }

    protected abstract void fillLegendSafely();

    protected JButton makePropertiesButton(DisplayControl control) {
        JButton propertiesBtn = GuiUtils.getImageButton(ICON_PROPERTIES);
        propertiesBtn.setToolTipText("Show or hide the control window");
        propertiesBtn.addActionListener(ae -> {
            try {
                control.toggleWindow();
            }
            catch (Exception exc) {
                this.viewManager.logException("Showing display", exc);
            }
        });
        propertiesBtn.setBackground(null);
        return propertiesBtn;
    }

    public void doClose() {
        this.closed = true;
        if (this.floatFrame != null) {
            this.floatFrame.dispose();
            this.floatFrame = null;
        }
    }

    @Override
    public void doRemove() {
        this.viewManager = null;
        GuiUtils.empty(this.contents, true);
    }

    protected String getTitle() {
        return "Display Legend";
    }

    public void unFloatLegend() {
        if (this.floatFrame != null) {
            this.lastLocation = this.floatFrame.getLocation();
            this.floatFrame.dispose();
            this.floatFrame = null;
            this.setFloatToolTip();
        }
    }

    public void floatLegend() {
        this.floatFrame = GuiUtils.createFrame(this.getTitle());
        this.floatFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                IdvLegend.this.lastLocation = IdvLegend.this.floatFrame.getLocation();
                IdvLegend.this.viewManager.setLegendState(IdvLegend.this, IdvLegend.STATE_HIDDEN);
                IdvLegend.this.floatFrame = null;
            }
        });
        this.floatFrame.getContentPane().add(this.getContents());
        this.floatFrame.pack();
        this.floatFrame.setLocation(this.lastLocation);
        this.floatFrame.setVisible(true);
        this.setFloatToolTip();
    }
}

