/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.ui;

import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ucar.unidata.idv.DisplayControl;
import ucar.unidata.idv.IdvResourceManager;
import ucar.unidata.idv.IntegratedDataViewer;
import ucar.unidata.idv.MapViewManager;
import ucar.unidata.idv.TransectViewManager;
import ucar.unidata.idv.ViewManager;
import ucar.unidata.idv.control.DisplayControlImpl;
import ucar.unidata.idv.ui.DataSelector;
import ucar.unidata.idv.ui.IdvXmlUi;
import ucar.unidata.idv.ui.ViewPanel;
import ucar.unidata.ui.ComponentGroup;
import ucar.unidata.ui.ComponentHolder;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.WrapperException;
import ucar.unidata.xml.XmlResourceCollection;
import ucar.unidata.xml.XmlUtil;

public class IdvComponentHolder
extends ComponentHolder {
    public static final String TYPE_SKIN = "skin";
    public static final String TYPE_CHOOSERS = "choosers";
    public static final String TYPE_DEFAULT = "default";
    private String type = "default";
    IntegratedDataViewer idv;
    private Object object;
    private List viewManagers;

    public IdvComponentHolder() {
    }

    public IdvComponentHolder(IntegratedDataViewer idv, Object object) {
        super("");
        this.idv = idv;
        this.object = object;
        if (object instanceof DisplayControl) {
            DisplayControlImpl control = (DisplayControlImpl)object;
            control.setComponentHolder(this);
            control.setShowInTabs(false);
            control.setMakeWindow(false);
            control.guiImported();
        }
    }

    @Override
    public String getName() {
        String name = this.getNameFromObject();
        if (name == null) {
            return this.getTypeName();
        }
        return name;
    }

    public Element createXmlNode(Document doc) {
        if (this.object == null) {
            return null;
        }
        if (this.object instanceof ViewManager) {
            Element node = doc.createElement("idv.view");
            node.setAttribute("class", this.object.getClass().getName());
            node.appendChild(XmlUtil.makeCDataNode(doc, this.idv.encodeObject(this.object, false)));
            node.setAttribute("showheader", "" + this.getShowHeader());
            return node;
        }
        if (this.object instanceof String && this.type.equals(TYPE_SKIN)) {
            Element node = doc.createElement("idv.component.skin");
            node.setAttribute("url", this.object.toString());
            return node;
        }
        return null;
    }

    @Override
    public void doRemove() {
        if (this.object != null && this.idv != null) {
            try {
                if (this.viewManagers != null) {
                    for (int i = 0; i < this.viewManagers.size(); ++i) {
                        ((ViewManager)this.viewManagers.get(i)).destroy();
                    }
                    this.viewManagers = null;
                }
                if (this.object instanceof ViewManager) {
                    ((ViewManager)this.object).destroy();
                } else if (this.object instanceof DisplayControl) {
                    ((DisplayControl)this.object).doRemove();
                } else if (this.object instanceof DataSelector) {
                    this.idv.getIdvUIManager().removeDataSourceHolder((DataSelector)this.object);
                }
            }
            catch (Exception exc) {
                LogUtil.logException("Error removing component holder", exc);
            }
            this.idv = null;
            this.object = null;
        }
        super.doRemove();
    }

    public void removeDisplayControl(DisplayControl displayControl) {
        if (displayControl == this.object) {
            this.object = null;
            this.doRemove();
        }
    }

    public void undockControl() {
        DisplayControlImpl control = (DisplayControlImpl)this.object;
        this.object = null;
        control.setComponentHolder(null);
        control.setShowInTabs(false);
        control.setMakeWindow(true);
        control.guiExported();
        this.doRemove();
    }

    @Override
    protected List getPopupMenuItems(List items) {
        if (this.object instanceof DisplayControl) {
            items.add(GuiUtils.makeMenuItem("Undock " + this.getName(), this, "undockControl"));
        }
        items.add(GuiUtils.makeMenuItem("Remove " + this.getName(), this, "removeDisplayComponent"));
        return items;
    }

    @Override
    public String getCategory() {
        if (this.object instanceof ViewManager) {
            return "Views";
        }
        if (this.object instanceof DisplayControl) {
            return "Displays";
        }
        if (this.object instanceof DataSelector) {
            return "Tools";
        }
        if (this.object instanceof String) {
            if (this.type.equals(TYPE_SKIN)) {
                return "IDV User Interface";
            }
            if (this.type.equals(TYPE_CHOOSERS)) {
                return "Data Choosers";
            }
        }
        return super.getCategory();
    }

    private String getNameFromObject() {
        if (this.object instanceof ViewManager) {
            return ((ViewManager)this.object).getName();
        }
        if (this.object instanceof DisplayControl) {
            return ((DisplayControl)this.object).getLabel();
        }
        if (this.object instanceof DataSelector) {
            return "Field Selector";
        }
        return super.getName();
    }

    @Override
    public ImageIcon getIcon() {
        if (this.object instanceof MapViewManager) {
            MapViewManager mvm = (MapViewManager)this.object;
            if (mvm.getUseGlobeDisplay()) {
                return ViewPanel.ICON_GLOBE;
            }
            return ViewPanel.ICON_MAP;
        }
        if (this.object instanceof TransectViewManager) {
            return ViewPanel.ICON_TRANSECT;
        }
        return super.getIcon();
    }

    @Override
    public String getTypeName() {
        if (this.object instanceof MapViewManager) {
            MapViewManager mvm = (MapViewManager)this.object;
            if (mvm.getUseGlobeDisplay()) {
                return "Globe View";
            }
            return "Map View";
        }
        if (this.object instanceof TransectViewManager) {
            return "Transect View";
        }
        if (this.object instanceof ViewManager) {
            return "View";
        }
        if (this.object instanceof DisplayControl) {
            return "Display Control";
        }
        if (this.object instanceof DataSelector) {
            return "Field Selector";
        }
        if (this.object instanceof String) {
            if (this.type.equals(TYPE_SKIN)) {
                return "UI Skin";
            }
            if (this.type.equals(TYPE_CHOOSERS)) {
                return "Data Choosers";
            }
        }
        return super.getTypeName();
    }

    public void displayControlHasInitialized() {
        JComponent comp;
        Window w;
        this.clearContents();
        this.getContents().invalidate();
        ComponentGroup parent = this.getParent();
        if (parent != null) {
            parent.redoLayout();
        }
        if ((w = GuiUtils.getWindow(comp = this.getContents())) != null) {
            w.doLayout();
        }
    }

    @Override
    public void initWith(Element node) {
        super.initWith(node);
        this.setShowHeader(XmlUtil.getAttribute((Node)node, "showheader", this.getShowHeader()));
    }

    protected JComponent makeSkin() {
        try {
            int i;
            String path = (String)this.object;
            Element root = null;
            XmlResourceCollection skins = this.getIdv().getResourceManager().getXmlResources(IdvResourceManager.RSC_SKIN);
            for (i = 0; i < skins.size(); ++i) {
                String id = skins.getProperty("skinid", i);
                if (!Misc.equals(path, skins.getProperty("skinid", i))) continue;
                root = skins.getRoot(i, false);
                break;
            }
            if (root == null) {
                for (i = 0; i < skins.size(); ++i) {
                    if (!Misc.equals(path, skins.get(i).toString())) continue;
                    root = skins.getRoot(i);
                    break;
                }
            }
            if (root == null) {
                root = XmlUtil.getRoot(path, this.getClass());
            }
            IdvXmlUi xmlUI = this.getIdv().getIdvUIManager().doMakeIdvXmlUi(null, this.viewManagers, root);
            Element startNode = XmlUtil.findElement(root, null, "embeddednode", "true");
            if (startNode != null) {
                xmlUI.setStartNode(startNode);
            }
            JComponent contents = (JComponent)xmlUI.getContents();
            this.viewManagers = xmlUI.getViewManagers();
            return contents;
        }
        catch (Exception exc) {
            throw new WrapperException(exc);
        }
    }

    @Override
    public JComponent doMakeContents() {
        if (this.object instanceof String) {
            if (this.type.equals(TYPE_SKIN)) {
                return this.makeSkin();
            }
            if (this.type.equals(TYPE_CHOOSERS)) {
                ArrayList choosers = new ArrayList();
                return this.getIdv().getIdvChooserManager().createChoosers(false, choosers, null);
            }
            return new JLabel("Unknown component: " + this.object);
        }
        if (this.object instanceof ViewManager) {
            return (JComponent)((ViewManager)this.object).getContents();
        }
        if (this.object instanceof DisplayControlImpl) {
            JComponent inner = (JComponent)((DisplayControlImpl)this.object).getOuterContents();
            if (inner == null) {
                return new JLabel("");
            }
            return inner;
        }
        if (this.object instanceof DataSelector) {
            return ((DataSelector)this.object).getContents();
        }
        return new JLabel("Unknwon object:" + this.object);
    }

    public void setObject(Object value) {
        this.object = value;
    }

    public Object getObject() {
        return this.object;
    }

    public void setIdv(IntegratedDataViewer value) {
        this.idv = value;
    }

    public IntegratedDataViewer getIdv() {
        return this.idv;
    }

    public void setType(String value) {
        this.type = value;
    }

    public String getType() {
        return this.type;
    }

    public void setViewManagers(List value) {
        this.viewManagers = value;
    }

    public List getViewManagers() {
        return this.viewManagers;
    }
}

