/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.ui;

import java.awt.Component;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ucar.unidata.idv.DisplayControl;
import ucar.unidata.idv.IdvResourceManager;
import ucar.unidata.idv.IntegratedDataViewer;
import ucar.unidata.idv.MapViewManager;
import ucar.unidata.idv.TransectViewManager;
import ucar.unidata.idv.ViewDescriptor;
import ucar.unidata.idv.ViewManager;
import ucar.unidata.idv.control.DisplayControlImpl;
import ucar.unidata.idv.ui.IdvComponentHolder;
import ucar.unidata.ui.ComponentGroup;
import ucar.unidata.ui.ComponentHolder;
import ucar.unidata.ui.HtmlComponent;
import ucar.unidata.util.FileManager;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.StringUtil;
import ucar.unidata.xml.XmlResourceCollection;
import ucar.unidata.xml.XmlUtil;

public class IdvComponentGroup
extends ComponentGroup {
    IntegratedDataViewer idv;
    private boolean autoImportDisplays = false;
    private JCheckBox autoImportCbx;

    public IdvComponentGroup() {
    }

    public IdvComponentGroup(IntegratedDataViewer idv, String name) {
        super(name);
        this.idv = idv;
    }

    public void writeSkin() {
        try {
            String template;
            JCheckBox pluginCbx = new JCheckBox("Install as plugin", true);
            JPanel extra = GuiUtils.inset((Component)GuiUtils.top(GuiUtils.vbox(new JLabel("Note: Filename should end in \"skin.xml\""), pluginCbx)), 5);
            String filename = FileManager.getWriteFile(FileManager.FILTER_XML, ".xml", (JComponent)extra);
            if (filename == null) {
                return;
            }
            Element root = this.createXmlNode(XmlUtil.makeDocument());
            this.setState(root);
            String xml = XmlUtil.toString(root);
            String templatePath = this.idv.getProperty("idv.ui.skin.template", null);
            System.err.println(templatePath);
            if (templatePath != null && (template = IOUtil.readContents(templatePath, this.getClass(), null)) != null) {
                xml = StringUtil.replace(template, "%contents%", xml);
            }
            IOUtil.writeFile(filename, xml);
            if (pluginCbx.isSelected()) {
                this.idv.getPluginManager().installPluginFromFile(filename);
            }
        }
        catch (Exception exc) {
            LogUtil.logException("Error writing skin file", exc);
        }
    }

    @Override
    public void initWith(Element node) {
        super.initWith(node);
        this.autoImportDisplays = XmlUtil.getAttribute((Node)node, "autoimportdisplays", this.autoImportDisplays);
        boolean showHeader = XmlUtil.getAttribute((Node)node, "showheader", this.getShowHeader());
        this.setShowHeader(showHeader);
    }

    public Element createXmlNode(Document doc) {
        Element node = doc.createElement("idv.component.group");
        node.setAttribute("autoimportdisplays", "" + this.autoImportDisplays);
        node.setAttribute("showheader", "" + this.getShowHeader());
        List displayComponents = this.getDisplayComponents();
        for (int i = 0; i < displayComponents.size(); ++i) {
            ComponentHolder comp = (ComponentHolder)displayComponents.get(i);
            Element child = null;
            if (comp instanceof IdvComponentHolder) {
                child = ((IdvComponentHolder)comp).createXmlNode(doc);
            } else if (comp instanceof IdvComponentGroup) {
                child = ((IdvComponentGroup)comp).createXmlNode(doc);
            } else if (comp instanceof HtmlComponent) {
                child = doc.createElement("idv.component.html");
                child.appendChild(XmlUtil.makeCDataNode(doc, ((HtmlComponent)comp).getText()));
            }
            if (child == null) continue;
            comp.setState(child);
            node.appendChild(child);
        }
        return node;
    }

    @Override
    protected List getPopupMenuItems(List items) {
        this.idv.getIdvUIManager().getComponentGroupMenuItems(this, items);
        super.getPopupMenuItems(items);
        return items;
    }

    public void getViewManagers(List viewManagers) {
        List displayComponents = this.getDisplayComponents();
        if (displayComponents == null) {
            return;
        }
        for (int i = 0; i < displayComponents.size(); ++i) {
            ComponentHolder comp = (ComponentHolder)displayComponents.get(i);
            Object child = null;
            if (comp instanceof IdvComponentHolder) {
                Object obj = ((IdvComponentHolder)comp).getObject();
                if (!(obj instanceof ViewManager)) continue;
                viewManagers.add(obj);
                continue;
            }
            if (!(comp instanceof IdvComponentGroup)) continue;
            ((IdvComponentGroup)comp).getViewManagers(viewManagers);
        }
    }

    public void importAllDisplayControls(List displayControls) {
        for (int i = 0; i < displayControls.size(); ++i) {
            DisplayControlImpl dc = (DisplayControlImpl)displayControls.get(i);
            if (dc.getComponentHolder() != null && dc.getComponentHolder().getParent() == this) continue;
            this.importDisplayControl(dc);
        }
    }

    @Override
    protected void doDrop(Object object) {
        if (object instanceof DisplayControl) {
            this.importDisplayControl((DisplayControlImpl)object);
        } else {
            super.doDrop(object);
        }
    }

    @Override
    public boolean dropOk(Object object) {
        if (object instanceof DisplayControl) {
            return true;
        }
        return super.dropOk(object);
    }

    public boolean tryToImportDisplayControl(DisplayControlImpl control) {
        if (this.autoImportDisplays) {
            this.importDisplayControl(control);
            return true;
        }
        List displayComponents = this.getDisplayComponents();
        for (int i = 0; i < displayComponents.size(); ++i) {
            ComponentHolder comp = (ComponentHolder)displayComponents.get(i);
            if (!(comp instanceof IdvComponentGroup) || !((IdvComponentGroup)comp).tryToImportDisplayControl(control)) continue;
            return true;
        }
        return false;
    }

    public void addGroups(List l) {
        l.add(this);
        List displayComponents = this.getDisplayComponents();
        for (int i = 0; i < displayComponents.size(); ++i) {
            ComponentHolder comp = (ComponentHolder)displayComponents.get(i);
            Object child = null;
            if (!(comp instanceof IdvComponentGroup)) continue;
            ((IdvComponentGroup)comp).addGroups(l);
        }
    }

    public void importDisplayControl(DisplayControlImpl dc) {
        if (dc.getComponentHolder() != null) {
            dc.getComponentHolder().removeDisplayControl(dc);
        }
        this.idv.getIdvUIManager().getViewPanel().removeDisplayControl(dc);
        dc.guiImported();
        this.addComponent(new IdvComponentHolder(this.idv, dc));
    }

    public void makeSkin(int skinIndex) {
        XmlResourceCollection skins = this.getIdv().getResourceManager().getXmlResources(IdvResourceManager.RSC_SKIN);
        String id = skins.getProperty("skinid", skinIndex);
        if (id == null) {
            id = skins.get(skinIndex).toString();
        }
        IdvComponentHolder comp = new IdvComponentHolder(this.idv, id);
        comp.setType("skin");
        comp.setName(skins.getLabel(skinIndex));
        this.addComponent(comp);
        GuiUtils.showComponentInTabs(comp.getContents());
    }

    public void makeNew(String what) {
        try {
            ComponentHolder comp = null;
            switch (what) {
                case "idv.mapview": {
                    MapViewManager vm = new MapViewManager(this.idv, new ViewDescriptor(), "showControlLegend=false");
                    this.idv.getVMManager().addViewManager(vm);
                    comp = new IdvComponentHolder(this.idv, vm);
                    break;
                }
                case "idv.globeview": {
                    MapViewManager vm = new MapViewManager(this.idv, new ViewDescriptor(), "showControlLegend=false");
                    vm.setUseGlobeDisplay(true);
                    this.idv.getVMManager().addViewManager(vm);
                    comp = new IdvComponentHolder(this.idv, vm);
                    break;
                }
                case "idv.transectview": {
                    TransectViewManager vm = new TransectViewManager(this.idv, new ViewDescriptor(), "showControlLegend=false");
                    this.idv.getVMManager().addViewManager(vm);
                    comp = new IdvComponentHolder(this.idv, vm);
                    break;
                }
                case "idv.component.choosers": {
                    comp = new IdvComponentHolder(this.idv, "choosers");
                    comp.setName("Data Choosers");
                    ((IdvComponentHolder)comp).setType("choosers");
                    break;
                }
                case "idv.dataselector": {
                    comp = new IdvComponentHolder(this.idv, this.idv.getIdvUIManager().createDataSelector(false, false));
                    break;
                }
                case "idv.component.group": {
                    String name = GuiUtils.getInput("Enter name for tab group", "Name: ", "Group");
                    if (name == null) {
                        return;
                    }
                    IdvComponentGroup group = new IdvComponentGroup(this.idv, name);
                    group.setLayout("tabs");
                    comp = group;
                    break;
                }
                case "idv.component.html": {
                    String text = GuiUtils.getInput("Enter html", "Html: ", "");
                    if (text == null) {
                        return;
                    }
                    comp = new HtmlComponent("Html Text", text);
                    comp.setShowHeader(false);
                }
            }
            if (comp != null) {
                this.addComponent(comp);
                GuiUtils.showComponentInTabs(comp.getContents());
            }
        }
        catch (Exception exc) {
            LogUtil.logException("Error making new " + what, exc);
        }
    }

    @Override
    protected boolean applyProperties() {
        boolean result = super.applyProperties();
        if (!result) {
            return false;
        }
        this.autoImportDisplays = this.autoImportCbx.isSelected();
        return true;
    }

    @Override
    protected void getPropertiesComponents(List comps, int tabIdx) {
        super.getPropertiesComponents(comps, tabIdx);
        if (tabIdx == 0) {
            this.autoImportCbx = new JCheckBox("Import any displays added to window", this.autoImportDisplays);
            comps.add(GuiUtils.filler());
            comps.add(GuiUtils.left(this.autoImportCbx));
        }
    }

    public void setIdv(IntegratedDataViewer value) {
        this.idv = value;
    }

    public IntegratedDataViewer getIdv() {
        return this.idv;
    }

    public void setAutoImportDisplays(boolean value) {
        this.autoImportDisplays = value;
    }

    public boolean getAutoImportDisplays() {
        return this.autoImportDisplays;
    }
}

