/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.python.core.PySyntaxError;
import ucar.unidata.data.DataCategory;
import ucar.unidata.data.DataGroup;
import ucar.unidata.data.DerivedDataChoice;
import ucar.unidata.data.DerivedDataDescriptor;
import ucar.unidata.data.DerivedNeed;
import ucar.unidata.idv.ControlDescriptor;
import ucar.unidata.idv.IntegratedDataViewer;
import ucar.unidata.ui.CheckboxCategoryPanel;
import ucar.unidata.ui.ParamField;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.Msg;
import ucar.unidata.util.Resource;
import ucar.unidata.util.StringUtil;
import ucar.unidata.util.TwoFacedObject;

public class FormulaDialog
extends JFrame
implements ActionListener {
    private static final String MYCATDIVIDER = ">";
    public static ImageIcon ICON_UPUP = new ImageIcon(Resource.getImage("/auxdata/ui/icons/UpUp.gif"));
    public static ImageIcon ICON_DOWNDOWN = new ImageIcon(Resource.getImage("/auxdata/ui/icons/DownDown.gif"));
    public static final String CMD_CHANGE = "cmd.change";
    public static final String CMD_ADD = "cmd.add";
    public static final String HELP_FORMULAS = "idv.tools.formulas";
    public static final String PREF_ADVANCEDOPEN = "FormulaDialog.AdvancedOpen";
    public static final String PREF_WINDOWSIZE = "FormulaDialog.WindowSize";
    private JCheckBox isDefaultCbx;
    private JCheckBox isEndUserCbx;
    private JTextField formulaField;
    private JTextField nameField;
    private JTextField descField;
    private JTextField operandsCategoriesFld;
    private List categories;
    private JComboBox categoryBox;
    private JComponent catComp;
    private boolean advancedOpen = false;
    private JRadioButton useAllBtn;
    private List needCompList = new ArrayList();
    private List catCompList = new ArrayList();
    private Hashtable cbxToCdMap;
    private List catPanels = new ArrayList();
    private String formula = "";
    private String name = "";
    private String description = "";
    private String category = "";
    private boolean makingNewOne = false;
    private DerivedDataDescriptor ddd;
    private IntegratedDataViewer idv;
    List paramGroupComps = new ArrayList();

    public FormulaDialog(IntegratedDataViewer idv, Component src) {
        this(idv, null, src, null);
    }

    public FormulaDialog(IntegratedDataViewer idv, DerivedDataDescriptor ddd, Component src, List categories) {
        this(idv, ddd, src, categories, ddd == null);
    }

    public FormulaDialog(IntegratedDataViewer idv, DerivedDataDescriptor ddd, Component src, List categories, boolean newFormula) {
        super("Formula Editor");
        LogUtil.registerWindow(this);
        this.idv = idv;
        this.makingNewOne = newFormula;
        if (ddd == null) {
            ddd = new DerivedDataDescriptor(idv);
            ddd.setIsEndUser(true);
        }
        this.ddd = ddd;
        this.categories = categories;
        this.formula = ddd.getFormula();
        this.name = ddd.getId();
        this.description = ddd.getDescription();
        DataCategory cat = ddd.getDisplayCategory();
        if (cat != null) {
            this.category = cat.toString();
        }
        this.doMakeWindow(src);
    }

    private void doMakeWindow(Component src) {
        Component contents = this.doMakeContents();
        Container cpane = this.getContentPane();
        cpane.setLayout(new BorderLayout());
        cpane.add(contents, "Center");
        try {
            Point loc = src.getLocationOnScreen();
            Dimension size = src.getSize();
            this.setLocation(loc.x + size.width, loc.y);
        }
        catch (Exception exc) {
            this.setLocation(50, 50);
        }
        Dimension dim = (Dimension)this.idv.getStore().get(PREF_WINDOWSIZE);
        this.pack();
        if (dim != null) {
            this.setSize(dim.width, this.getSize().height);
        }
        Msg.translateTree(this);
        this.show();
    }

    private Component doMakeContents() {
        int i;
        ParamComponent pc;
        ParamGroupComponent pgc;
        ArrayList<JLabel> fieldLabelList = new ArrayList<JLabel>();
        fieldLabelList.add(new JLabel("Field name"));
        fieldLabelList.add(new JLabel("Identifier"));
        JButton jythonBtn = GuiUtils.makeImageButton("/auxdata/ui/icons/EditJython16.png", this.idv.getJythonManager(), "showJythonEditor");
        GuiUtils.makeMouseOverBorder(jythonBtn);
        jythonBtn.setToolTipText("Edit Jython Library");
        JButton evalBtn = GuiUtils.makeImageButton("/auxdata/ui/icons/Evaluate16.png", this, "evaluate");
        GuiUtils.makeMouseOverBorder(evalBtn);
        evalBtn.setToolTipText("Save and Evaluate Formula");
        this.formulaField = new JTextField(this.formula, 25);
        this.formulaField.setToolTipText("<html>Right-click to add procedures from library</html>");
        this.formulaField.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    ArrayList<JMenu> items = new ArrayList<JMenu>();
                    items.add(GuiUtils.makeMenu("Insert Procedure Call", FormulaDialog.this.idv.getJythonManager().makeProcedureMenu(FormulaDialog.this, "insertText", null)));
                    JPopupMenu popup = GuiUtils.makePopupMenu(items);
                    popup.show(FormulaDialog.this.formulaField, e.getX(), (int)FormulaDialog.this.formulaField.getBounds().getHeight());
                }
            }
        });
        this.nameField = new JTextField(this.name, 25);
        this.nameField.setToolTipText("<html>Name is used with the parameter defaults</html>");
        this.descField = new JTextField(this.description, 25);
        this.descField.setToolTipText("<html>The description is shown in Field Selector</html>");
        this.categoryBox = new JComboBox();
        this.categoryBox.setEditable(true);
        this.categoryBox.addItem("");
        this.categoryBox.setToolTipText("<html>The group can be entered manually<br>Use '>' as the group delimiter. e.g.:<br>System &gt; Sub group</html>");
        if (this.categories != null) {
            for (int i2 = 0; i2 < this.categories.size(); ++i2) {
                String catString = this.categories.get(i2).toString();
                catString = this.convertToMyCategory(catString);
                this.categoryBox.addItem(catString);
            }
        }
        if (this.category != null) {
            this.categoryBox.setSelectedItem(this.convertToMyCategory(this.category));
        }
        Hashtable<String, String> controlsMap = new Hashtable<String, String>();
        if (this.ddd != null && this.ddd.getDataCategories() != null) {
            List categories = this.ddd.getDataCategories();
            for (int i3 = 0; i3 < categories.size(); ++i3) {
                DataCategory dc = (DataCategory)categories.get(i3);
                String name = dc.toString();
                if (!name.startsWith("display:")) continue;
                controlsMap.put(name.substring(8).trim(), name);
            }
        }
        List controlDescriptors = this.idv.getControlDescriptors();
        Vector listData = new Vector();
        boolean allUnchecked = true;
        ArrayList<JPanel> cdList = new ArrayList<JPanel>();
        Hashtable<String, CheckboxCategoryPanel> catMap = new Hashtable<String, CheckboxCategoryPanel>();
        this.cbxToCdMap = new Hashtable();
        JButton allOn = new JButton("All on");
        allOn.addActionListener(ae -> this.toggleAll(true));
        JButton allOff = new JButton("All off");
        allOff.addActionListener(ae -> this.toggleAll(false));
        for (int i4 = 0; i4 < controlDescriptors.size(); ++i4) {
            boolean isSelected;
            ControlDescriptor cd = (ControlDescriptor)controlDescriptors.get(i4);
            if (cd.canStandAlone() || !this.idv.getPreferenceManager().shouldShowControl(cd)) continue;
            String displayCategory = cd.getDisplayCategory();
            CheckboxCategoryPanel catPanel = (CheckboxCategoryPanel)catMap.get(displayCategory);
            if (catPanel == null) {
                catPanel = new CheckboxCategoryPanel(displayCategory, false);
                this.catPanels.add(catPanel);
                catMap.put(displayCategory, catPanel);
                cdList.add(catPanel.getTopPanel());
                cdList.add(catPanel);
            }
            boolean bl = isSelected = this.ddd == null ? true : controlsMap.containsKey(cd.getControlId());
            if (isSelected) {
                allUnchecked = false;
            }
            JCheckBox cbx = new JCheckBox(cd.getLabel(), isSelected);
            cbx.setBorder(BorderFactory.createEmptyBorder());
            catPanel.addItem(cbx);
            this.cbxToCdMap.put(cbx, cd);
            catPanel.add(GuiUtils.inset((Component)cbx, new Insets(0, 20, 0, 0)));
        }
        JPanel cdPanel = GuiUtils.vbox(cdList);
        JScrollPane cdScroll = GuiUtils.makeScrollPane(GuiUtils.top(cdPanel), 100, 150);
        cdScroll.getVerticalScrollBar().setUnitIncrement(10);
        cdScroll.setPreferredSize(new Dimension(100, 150));
        if (this.ddd == null) {
            allUnchecked = true;
        }
        this.useAllBtn = new JRadioButton("Use all ", allUnchecked);
        JRadioButton useTheseBtn = new JRadioButton("Use selected: ", !allUnchecked);
        GuiUtils.buttonGroup(this.useAllBtn, useTheseBtn);
        ActionListener radioBtnListener = ae -> {
            GuiUtils.enableTree(cdPanel, !this.useAllBtn.isSelected());
            allOn.setEnabled(!this.useAllBtn.isSelected());
            allOff.setEnabled(!this.useAllBtn.isSelected());
        };
        this.useAllBtn.addActionListener(radioBtnListener);
        useTheseBtn.addActionListener(radioBtnListener);
        GuiUtils.enableTree(cdPanel, !this.useAllBtn.isSelected());
        allOn.setEnabled(!this.useAllBtn.isSelected());
        allOff.setEnabled(!this.useAllBtn.isSelected());
        JPanel allOnOffPanel = GuiUtils.vbox(allOn, allOff);
        JPanel radioBtnPanel = GuiUtils.hbox(Misc.newList(this.useAllBtn, useTheseBtn));
        JPanel displaysPanel = GuiUtils.topCenter(radioBtnPanel, cdScroll);
        GuiUtils.tmpInsets = new Insets(4, 4, 4, 4);
        double[] stretchyY = new double[]{0.0, 0.0, 0.0, 1.0};
        GuiUtils.tmpInsets = new Insets(4, 4, 4, 4);
        JPanel bottomPanel = GuiUtils.doLayout(new Component[]{GuiUtils.rLabel("Group:"), this.categoryBox, GuiUtils.rLabel("Displays:"), radioBtnPanel, GuiUtils.top(allOnOffPanel), cdScroll}, 2, GuiUtils.WT_NY, stretchyY);
        this.isDefaultCbx = new JCheckBox("Create derived quantities (Note: Use D1, D2, ..., DN as operands in formula) ", this.ddd.getIsDefault());
        this.isEndUserCbx = new JCheckBox("For end user", this.ddd.getIsEndUser());
        this.isDefaultCbx.setToolTipText("Automatically create derived  quantities for data sources that have fields that match the following");
        List needs = this.ddd.getNeeds();
        ArrayList<JComponent> needsComps = new ArrayList<JComponent>();
        this.operandsCategoriesFld = this.doMakeCategoriesField();
        if (this.ddd.getOperandsCategories() != null) {
            this.operandsCategoriesFld.setText(this.ddd.getOperandsCategories());
        }
        needsComps.add(new JLabel("Parameter Groups"));
        needsComps.add(new JLabel("Categories"));
        ArrayList<JComponent> pcs = new ArrayList<JComponent>();
        pcs.add(new JLabel("Parameters"));
        pcs.add(new JLabel("Categories"));
        for (int needIdx = 0; needIdx < needs.size(); ++needIdx) {
            DerivedNeed need = (DerivedNeed)needs.get(needIdx);
            String groupName = need.getGroupName();
            if (groupName != null) {
                DataGroup group = DataGroup.getDataGroup(groupName);
                if (group == null) continue;
                pgc = new ParamGroupComponent(need, group);
                this.needCompList.add(pgc);
                needsComps.add(pgc.cbx);
                needsComps.add(pgc.catFld);
                continue;
            }
            pc = new ParamComponent(need);
            this.needCompList.add(pc);
            pcs.add(pc.paramsFld);
            pcs.add(pc.catFld);
        }
        for (i = 0; i < 1; ++i) {
            pgc = new ParamGroupComponent(new DerivedNeed(this.ddd, null), null);
            this.needCompList.add(pgc);
            needsComps.add(pgc.cbx);
            needsComps.add(pgc.catFld);
        }
        for (i = 0; i < 1; ++i) {
            pc = new ParamComponent(new DerivedNeed(this.ddd, null));
            this.needCompList.add(pc);
            pcs.add(pc.paramsFld);
            pcs.add(pc.catFld);
        }
        needsComps.addAll(pcs);
        ArrayList catComps = new ArrayList();
        List cats = this.ddd.getDataCategories();
        int catCols = 0;
        for (int i5 = 0; i5 < cats.size(); ++i5) {
            DataCategory dataCategory = (DataCategory)cats.get(i5);
            this.catCompList.add(new CatComponent(dataCategory, catComps));
            if (catCols != 0) continue;
            catCols = catComps.size() / 2;
        }
        this.catCompList.add(new CatComponent(new DataCategory(false), catComps));
        if (catCols == 0) {
            catCols = catComps.size() / 2;
        }
        this.catCompList.add(new CatComponent(new DataCategory(false), catComps));
        this.catCompList.add(new CatComponent(new DataCategory(false), catComps));
        GuiUtils.setHFill();
        this.catComp = GuiUtils.doLayout(catComps, catCols, GuiUtils.WT_YN, GuiUtils.WT_N);
        GuiUtils.tmpInsets = new Insets(2, 2, 2, 2);
        GuiUtils.setHFill();
        JPanel needsComp = GuiUtils.doLayout(needsComps, 2, GuiUtils.WT_NY, GuiUtils.WT_N);
        needsComp = GuiUtils.vbox((Component)GuiUtils.label("Categories: ", this.operandsCategoriesFld), needsComp);
        needsComp = GuiUtils.inset((Component)needsComp, new Insets(5, 0, 0, 0));
        JPanel cbxPanel = GuiUtils.vbox(this.isEndUserCbx, this.isDefaultCbx);
        JPanel derivedPanel = needsComp;
        this.catComp = GuiUtils.vbox(new JLabel("Categorize the new data with:"), this.catComp);
        JButton popupBtn = GuiUtils.makeButton("Define Output Categories >>", this, "popupCatComp");
        derivedPanel = GuiUtils.inset((Component)GuiUtils.vbox(new JLabel("Match on fields:"), derivedPanel, GuiUtils.left(popupBtn)), new Insets(0, 30, 0, 0));
        derivedPanel = GuiUtils.top(GuiUtils.vbox((Component)cbxPanel, derivedPanel));
        JTabbedPane advancedTab = new JTabbedPane();
        advancedTab.add("Settings", bottomPanel);
        advancedTab.add("Derived", derivedPanel);
        JPanel theBottomPanel = GuiUtils.inset((Component)advancedTab, 4);
        this.advancedOpen = this.idv.getStore().get(PREF_ADVANCEDOPEN, this.advancedOpen);
        theBottomPanel.setVisible(this.advancedOpen);
        JButton advancedBtn = new JButton("Advanced  ");
        JButton advancedIconBtn = new JButton(ICON_DOWNDOWN);
        advancedIconBtn.setContentAreaFilled(false);
        GuiUtils.makeMouseOverBorder(advancedIconBtn);
        ActionListener advancedListener = ae -> {
            this.advancedOpen = !theBottomPanel.isVisible();
            theBottomPanel.setVisible(this.advancedOpen);
            this.checkAdvancedState(advancedBtn, advancedIconBtn);
            int oldWidth = this.getSize().width;
            this.pack();
            this.setSize(oldWidth, this.getSize().height);
            this.doLayout();
        };
        this.checkAdvancedState(advancedBtn, advancedIconBtn);
        advancedBtn.addActionListener(advancedListener);
        advancedIconBtn.addActionListener(advancedListener);
        JLabel descriptionLabel = GuiUtils.rLabel("Description: ");
        JLabel idLabel = GuiUtils.rLabel("Name: ");
        JLabel formulaLabel = GuiUtils.rLabel("Formula: ");
        descriptionLabel.setToolTipText("The description is shown in Field Selector");
        idLabel.setToolTipText("Name is used with the parameter defaults");
        formulaLabel.setToolTipText("Mathematical formula to be used");
        GuiUtils.tmpInsets = new Insets(4, 4, 0, 4);
        JPanel topPanel = GuiUtils.doLayout(new Component[]{descriptionLabel, this.descField, idLabel, this.nameField, formulaLabel, GuiUtils.centerRight(this.formulaField, GuiUtils.hbox(evalBtn, jythonBtn)), GuiUtils.rLabel("Advanced"), GuiUtils.left(advancedIconBtn)}, 2, GuiUtils.WT_NY, GuiUtils.WT_N);
        JPanel innerPanel = GuiUtils.doLayout(Misc.newList(topPanel, theBottomPanel), 1, GuiUtils.WT_Y, GuiUtils.WT_NY);
        JPanel buttons = !this.makingNewOne ? (!this.ddd.getIsLocalUsers() ? GuiUtils.makeButtons((ActionListener)this, new String[]{"Change Formula", "Cancel", "Help"}, new String[]{CMD_CHANGE, GuiUtils.CMD_CANCEL, GuiUtils.CMD_HELP}) : GuiUtils.makeButtons((ActionListener)this, new String[]{"Change Formula", "Remove Formula", "Cancel", "Help"}, new String[]{CMD_CHANGE, GuiUtils.CMD_REMOVE, GuiUtils.CMD_CANCEL, GuiUtils.CMD_HELP})) : GuiUtils.makeButtons((ActionListener)this, new String[]{"Add Formula", "Cancel", "Help"}, new String[]{CMD_ADD, GuiUtils.CMD_CANCEL, GuiUtils.CMD_HELP});
        return GuiUtils.centerBottom(GuiUtils.inset((Component)innerPanel, 2), buttons);
    }

    public void insertText(String t) {
        GuiUtils.insertText(this.formulaField, t);
    }

    public void popupCatComp() {
        GuiUtils.makeDialog(this, "Define Output Categories", GuiUtils.inset((Component)this.catComp, 5), null, new String[]{GuiUtils.CMD_OK});
    }

    private void showCategoriesPopup(JTextField fld, MouseEvent e) {
        List cats = DataCategory.getCurrentCategories();
        cats = Misc.sort(cats);
        ArrayList<Component> items = new ArrayList<Component>();
        for (int i = 0; i < cats.size(); ++i) {
            String cat = (String)cats.get(i);
            JMenuItem mi = new JMenuItem(cat);
            mi.addActionListener(ae -> GuiUtils.appendText(fld, cat, ";"));
            items.add(mi);
        }
        JMenu dummy = GuiUtils.makeMenu("", items);
        items = new ArrayList();
        GuiUtils.limitMenuSize(dummy, "Data Categories Group #", 20);
        for (int i = 0; i < dummy.getItemCount(); ++i) {
            items.add(dummy.getMenuComponent(i));
        }
        JPopupMenu popup = GuiUtils.makePopupMenu(items);
        popup.show(fld, e.getX(), (int)fld.getBounds().getHeight());
    }

    private JTextField doMakeCategoriesField() {
        final JTextField fld = new JTextField("", 15);
        fld.setToolTipText("<html>Semi-colon separated list of data categories<br>Right mouse to add categories</html>");
        fld.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    FormulaDialog.this.showCategoriesPopup(fld, e);
                }
            }
        });
        return fld;
    }

    private String convertToMyCategory(String cat) {
        return StringUtil.join(MYCATDIVIDER, StringUtil.split(cat, "-", true, true));
    }

    private void checkAdvancedState(JButton advancedBtn, JButton advancedIconBtn) {
        if (this.advancedOpen) {
            advancedIconBtn.setIcon(ICON_UPUP);
            advancedIconBtn.setToolTipText("Click to hide advanced options");
            advancedBtn.setToolTipText("Click to hide advanced options");
        } else {
            advancedIconBtn.setIcon(ICON_DOWNDOWN);
            advancedIconBtn.setToolTipText("Click to show advanced options");
            advancedBtn.setToolTipText("Click to show advanced options");
        }
    }

    private void toggleAll(boolean to) {
        for (int i = 0; i < this.catPanels.size(); ++i) {
            ((CheckboxCategoryPanel)this.catPanels.get(i)).toggleAll(to);
        }
    }

    public void evaluate() {
        Misc.run(this, "evaluateInThread");
    }

    public void evaluateInThread() {
        if (!this.addOrChange()) {
            return;
        }
        this.idv.getJythonManager().evaluateDataChoice(this.ddd.getDataChoice());
    }

    private boolean addOrChange() {
        boolean wasNew = false;
        if (this.ddd == null) {
            this.ddd = new DerivedDataDescriptor(this.idv);
            this.ddd.setIsEndUser(true);
            wasNew = true;
        }
        if (!this.setValues(this.ddd)) {
            return false;
        }
        this.ddd.setIsLocalUsers(true);
        if (wasNew) {
            this.idv.getJythonManager().addFormula(this.ddd);
        } else {
            this.idv.getJythonManager().descriptorChanged(this.ddd);
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String cmd = event.getActionCommand();
        if (cmd.equals(CMD_ADD)) {
            if (this.descField.getText() == null || this.descField.getText().isEmpty() || this.nameField.getText() == null || this.nameField.getText().isEmpty() || this.formulaField.getText() == null || this.formulaField.getText().isEmpty()) {
                JOptionPane.showMessageDialog(this, "Values for Description, Name and Forumla must be entered");
            } else if (this.addOrChange()) {
                this.closeFormulaDialog();
            }
            return;
        }
        if (cmd.equals(CMD_CHANGE)) {
            if (this.descField.getText() == null || this.descField.getText().isEmpty() || this.nameField.getText() == null || this.nameField.getText().isEmpty() || this.formulaField.getText() == null || this.formulaField.getText().isEmpty()) {
                JOptionPane.showMessageDialog(this, "Values for Description, Name and Forumla must be entered");
            } else if (this.addOrChange()) {
                this.closeFormulaDialog();
            }
            return;
        }
        if (cmd.equals(GuiUtils.CMD_REMOVE) && GuiUtils.askOkCancel("Remove Formula", "Are you sure you want to remove the formula?")) {
            this.idv.getJythonManager().removeFormula(this.ddd);
            this.closeFormulaDialog();
        }
        if (cmd.equals(GuiUtils.CMD_HELP)) {
            this.idv.getIdvUIManager().showHelp(HELP_FORMULAS);
        }
        if (cmd.equals(GuiUtils.CMD_CANCEL)) {
            this.closeFormulaDialog();
        }
    }

    private void closeFormulaDialog() {
        this.idv.getStore().put(PREF_ADVANCEDOPEN, this.advancedOpen);
        this.idv.getStore().put(PREF_WINDOWSIZE, (Object)this.getSize());
        this.idv.getStore().saveIfNeeded();
        this.hide();
    }

    private boolean setValues(DerivedDataDescriptor ddd) {
        String desc;
        String name = this.nameField.getText().trim();
        String oldName = ddd.getId();
        ddd.setId(name);
        String formula = this.formulaField.getText();
        ddd.setFormula(formula);
        ddd.setIsEndUser(this.isEndUserCbx.isSelected());
        ddd.setIsDefault(this.isDefaultCbx.isSelected());
        ddd.setOperandsCategories(this.operandsCategoriesFld.getText().trim());
        ArrayList<DerivedNeed> derivedNeeds = new ArrayList<DerivedNeed>();
        for (int i = 0; i < this.needCompList.size(); ++i) {
            NeedComponent needComponent = (NeedComponent)this.needCompList.get(i);
            DerivedNeed derivedNeed = needComponent.getNeed();
            if (derivedNeed == null) continue;
            derivedNeeds.add(derivedNeed);
        }
        ddd.setNeeds(derivedNeeds);
        String proc = ddd.getJythonProcedure("testproc");
        if (proc != null) {
            try {
                String cleanProc = DerivedDataChoice.cleanupJythonCode(proc);
                this.idv.getJythonManager().getDerivedDataInterpreter(null).exec(cleanProc);
            }
            catch (PySyntaxError pse) {
                LogUtil.userErrorMessage("The formula: " + formula + " has a Jython error: " + pse);
                return false;
            }
            catch (Exception e) {
                LogUtil.userErrorMessage("The formula: " + formula + " has a Jython error: " + e);
                return false;
            }
        }
        if ((desc = this.descField.getText().trim()).length() == 0) {
            desc = name;
        }
        ddd.setFormula(this.formulaField.getText());
        ddd.setDescription(desc);
        this.setCategory(ddd);
        return true;
    }

    private void setCategory(DerivedDataDescriptor ddd) {
        ArrayList<DataCategory> categories = new ArrayList<DataCategory>();
        String category = this.categoryBox.getSelectedItem().toString().trim();
        if (category.length() > 0) {
            category = StringUtil.join("-", StringUtil.split(category, MYCATDIVIDER, true, true));
            DataCategory dataCategory = DataCategory.parseCategory(category, true);
            dataCategory.setForDisplay(true);
            categories.add(dataCategory);
        }
        if (!this.useAllBtn.isSelected()) {
            int numNotSelected = 0;
            Enumeration keys = this.cbxToCdMap.keys();
            while (keys.hasMoreElements()) {
                JCheckBox cbx = (JCheckBox)keys.nextElement();
                if (!cbx.isSelected()) {
                    ++numNotSelected;
                    continue;
                }
                ControlDescriptor cd = (ControlDescriptor)this.cbxToCdMap.get(cbx);
                categories.add(new DataCategory("display:" + cd.getControlId(), false));
            }
            if (numNotSelected == 0) {
                categories = new ArrayList();
            }
        }
        for (int i = 0; i < this.catCompList.size(); ++i) {
            CatComponent catComponent = (CatComponent)this.catCompList.get(i);
            DataCategory cat = catComponent.getDataCategory();
            if (cat == null) continue;
            categories.add(cat);
        }
        ddd.setDataCategories(categories);
    }

    private class CatComponent {
        DataCategory cat;
        JTextField appendFld;
        JTextField catFld;
        JRadioButton catButton;
        JRadioButton inheritButton;
        JComboBox childIndexCbx;
        JComboBox catIndexCbx;

        public CatComponent(DataCategory cat, List comps) {
            String catString;
            Vector indices = new Vector(Misc.toList(new Object[]{new TwoFacedObject((Object)"All", -1), new TwoFacedObject((Object)"1st", 0), new TwoFacedObject((Object)"2nd", 1), new TwoFacedObject((Object)"3rd", 2), new TwoFacedObject((Object)"4th", 3), new TwoFacedObject((Object)"5th", 4)}));
            this.childIndexCbx = new JComboBox(indices);
            TwoFacedObject tfo = TwoFacedObject.findId(new Integer(cat.getChildIndex()), indices);
            if (tfo != null) {
                this.childIndexCbx.setSelectedItem(tfo);
            }
            this.catIndexCbx = new JComboBox(indices);
            tfo = TwoFacedObject.findId(new Integer(cat.getCategoryIndex()), indices);
            if (tfo != null) {
                this.catIndexCbx.setSelectedItem(tfo);
            }
            if ((catString = cat.toString()).startsWith("display:") || cat.getForDisplay()) {
                return;
            }
            if (comps.size() == 0) {
                comps.add(GuiUtils.cLabel("Data Category"));
                comps.add(GuiUtils.cLabel("  Use Data  "));
                comps.add(GuiUtils.cLabel("  Operand  "));
                comps.add(GuiUtils.cLabel("  Category  "));
                comps.add(GuiUtils.cLabel("  Append  "));
            }
            this.cat = cat;
            this.inheritButton = new JRadioButton("", false);
            this.catButton = new JRadioButton("", true);
            GuiUtils.buttonGroup(this.inheritButton, this.catButton);
            ActionListener listener = ae -> this.checkEnabled();
            this.inheritButton.addActionListener(listener);
            this.catButton.addActionListener(listener);
            if (cat == null) {
                cat = new DataCategory();
            }
            this.appendFld = new JTextField(cat.getAppend(), 10);
            this.catFld = FormulaDialog.this.doMakeCategoriesField();
            if (catString.equals("inherit")) {
                catString = "";
                this.inheritButton.setSelected(true);
            }
            this.catFld.setText(catString);
            comps.add(GuiUtils.leftCenter(this.catButton, this.catFld));
            comps.add(GuiUtils.right(this.inheritButton));
            comps.add(this.childIndexCbx);
            comps.add(this.catIndexCbx);
            comps.add(this.appendFld);
            this.checkEnabled();
        }

        public DataCategory getDataCategory() {
            if (this.catFld == null) {
                return null;
            }
            if (this.catButton.isSelected()) {
                String catString = this.catFld.getText().trim();
                if (catString.length() == 0) {
                    return null;
                }
                return DataCategory.parseCategory(catString, false);
            }
            DataCategory cat = DataCategory.parseCategory("inherit", false);
            TwoFacedObject tfo = (TwoFacedObject)this.childIndexCbx.getSelectedItem();
            cat.setChildIndex((Integer)tfo.getId());
            tfo = (TwoFacedObject)this.catIndexCbx.getSelectedItem();
            cat.setCategoryIndex((Integer)tfo.getId());
            cat.setAppend(this.appendFld.getText().trim());
            return cat;
        }

        private void checkEnabled() {
            boolean enabled = this.inheritButton.isSelected();
            this.appendFld.setEnabled(enabled);
            this.childIndexCbx.setEnabled(enabled);
            this.catIndexCbx.setEnabled(enabled);
            this.catFld.setEnabled(!enabled);
        }
    }

    private class ParamComponent
    extends NeedComponent {
        ParamField paramsFld;

        public ParamComponent(DerivedNeed need) {
            super(need);
            this.paramsFld = new ParamField(",", true);
            if (need.getParamSets().size() > 0) {
                this.paramsFld.setText(StringUtil.join(", ", (List)need.getParamSets().get(0)));
            }
        }

        @Override
        public DerivedNeed getNeed() {
            String params = this.paramsFld.getText().trim();
            if (params.length() == 0) {
                return null;
            }
            return new DerivedNeed(FormulaDialog.this.ddd, StringUtil.split(params, ",", true, true), this.catFld.getText().trim());
        }
    }

    private class ParamGroupComponent
    extends NeedComponent {
        JComboBox cbx;

        public ParamGroupComponent(DerivedNeed need, DataGroup group) {
            super(need);
            Vector<String> groups = new Vector<String>(DataGroup.getGroups());
            groups.add(0, "");
            this.cbx = new JComboBox(groups);
            if (group != null) {
                this.cbx.setSelectedItem(group);
            }
        }

        @Override
        public DerivedNeed getNeed() {
            Object o = this.cbx.getSelectedItem();
            if (o == null || !(o instanceof DataGroup)) {
                return null;
            }
            DataGroup dataGroup = (DataGroup)o;
            return new DerivedNeed(FormulaDialog.this.ddd, dataGroup.getName(), this.catFld.getText().trim());
        }
    }

    private abstract class NeedComponent {
        JTextField catFld;
        DerivedNeed need;

        public NeedComponent(DerivedNeed need) {
            this.need = need;
            this.catFld = FormulaDialog.this.doMakeCategoriesField();
            if (need.getCategories() != null) {
                this.catFld.setText(need.getCategories());
            }
        }

        public abstract DerivedNeed getNeed();
    }
}

