/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ucar.unidata.idv.MapViewManager;
import ucar.unidata.idv.flythrough.Flythrough;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.view.geoloc.NavigatedDisplay;
import ucar.visad.GeoUtils;
import visad.Real;
import visad.RealType;
import visad.georef.LatLonPoint;

public class EarthNavPanel
extends JPanel
implements MouseListener,
MouseMotionListener {
    private static final String PROP_SHOWADDRESS = "earthnav.showaddress";
    private boolean showAddress = true;
    private static final String CMD_JOYSTICK = "cmd.joystick";
    private boolean ignoreChanges = false;
    private MapViewManager viewManager;
    private ImageIcon panelIcon;
    private List locations = new ArrayList();
    JLabel label;
    JComboBox addressBox;
    private int[] masterTimeStamp = new int[]{0};
    private Flythrough flythrough;
    private boolean handlingKey = false;
    private static int width0 = 10;
    private static int width1 = 18;
    private static int width2 = 20;
    private static int width3 = 32;
    private static int topY1 = 33;
    private static int bottomY1 = 70;
    private static int zoomX = 20;
    private static int tiltX = 275;
    private static int rotateY = 23;
    private static int rotateLeftX = 66;
    private static int rotateRightX = 227;
    private static int panLeftX = 117;
    private static int panRightX = 174;
    private static int panHY = 53;
    private static int panVX = 145;
    private static int panUpY = 28;
    private static int panDownY = 78;
    private Location pressed;
    private Location joystick;
    private MouseEvent dragEvent;
    private boolean isControlDown = false;
    private boolean isShiftDown = false;
    private int timeStamp = 0;

    public EarthNavPanel(MapViewManager viewManager) {
        String prop = viewManager.getSkinProperty(PROP_SHOWADDRESS);
        if (prop != null) {
            this.showAddress = new Boolean(prop);
        }
        this.init(viewManager);
    }

    public EarthNavPanel(MapViewManager viewManager, Flythrough flythrough, boolean showAddress) {
        this.showAddress = showAddress;
        this.flythrough = flythrough;
        this.init(viewManager);
    }

    private void init(MapViewManager viewManager) {
        this.viewManager = viewManager;
        this.setLayout(new BorderLayout());
        this.label = new JLabel("", 0){

            @Override
            public void paint(Graphics g) {
                super.paint(g);
                if (EarthNavPanel.this.pressed != null && !((EarthNavPanel)EarthNavPanel.this).pressed.method.equals(EarthNavPanel.CMD_JOYSTICK)) {
                    int iconWidth = EarthNavPanel.this.panelIcon.getIconWidth();
                    int myWidth = this.getBounds().width;
                    int iconX = myWidth / 2 - iconWidth / 2;
                    g.setColor(Color.gray);
                    g.drawArc(iconX + ((EarthNavPanel)EarthNavPanel.this).pressed.r.x, ((EarthNavPanel)EarthNavPanel.this).pressed.r.y, ((EarthNavPanel)EarthNavPanel.this).pressed.r.width, ((EarthNavPanel)EarthNavPanel.this).pressed.r.height, 0, 360);
                }
            }
        };
        this.add("Center", this.label);
        this.panelIcon = GuiUtils.getImageIcon("/auxdata/ui/icons/EarthPanel.png");
        this.label.setIcon(this.panelIcon);
        this.label.addMouseListener(this);
        this.label.addMouseMotionListener(this);
        this.label.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent ke) {
                EarthNavPanel.this.isControlDown = ke.isControlDown();
                EarthNavPanel.this.isShiftDown = ke.isShiftDown();
            }

            @Override
            public void keyPressed(KeyEvent ke) {
                EarthNavPanel.this.isControlDown = ke.isControlDown();
                EarthNavPanel.this.isShiftDown = ke.isShiftDown();
                if (EarthNavPanel.this.flythrough == null) {
                    return;
                }
                if (EarthNavPanel.this.handlingKey) {
                    return;
                }
                EarthNavPanel.this.handlingKey = true;
                try {
                    if (ke.getKeyCode() == 39) {
                        EarthNavPanel.this.flythrough.driveRight();
                    } else if (ke.getKeyCode() == 37) {
                        EarthNavPanel.this.flythrough.driveLeft();
                    } else if (ke.getKeyCode() == 38) {
                        EarthNavPanel.this.flythrough.driveForward();
                    } else if (ke.getKeyCode() == 40) {
                        EarthNavPanel.this.flythrough.driveBack();
                    }
                }
                finally {
                    EarthNavPanel.this.handlingKey = false;
                }
            }
        });
        this.addressBox = new JComboBox();
        this.addressBox.setToolTipText("<html>Enter an address, zip code, city,state, etc.<br>Examples:<br>12345 oak street, my town, my state<br>Or: my town, my state<br>Or: 80303 (zip code)<br>Or: latitude longitude<br>Or: \"ip\" for the location of this computer</html>");
        GeoUtils.initAddressBox(this.addressBox);
        this.addressBox.setEditable(true);
        this.addressBox.addActionListener(GuiUtils.makeActionListener(this, "goToAddress", null));
        JButton addressSearchBtn = GuiUtils.makeButton("Go To Address:", this, "goToAddress");
        addressSearchBtn.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        JPanel addressPanel = GuiUtils.vbox(addressSearchBtn, this.addressBox);
        addressPanel = GuiUtils.inset((Component)GuiUtils.top(addressPanel), 5);
        if (this.showAddress) {
            this.add("West", addressPanel);
        }
        this.initLocations();
    }

    public void goToAddress() {
        if (this.ignoreChanges) {
            return;
        }
        Misc.run(this, "goToAddressInner");
    }

    public void goToAddressInner() {
        try {
            this.masterTimeStamp[0] = this.masterTimeStamp[0] + 1;
            int timestamp = this.masterTimeStamp[0];
            this.viewManager.getIdvUIManager().showWaitCursor();
            String address = (String)this.addressBox.getSelectedItem();
            LatLonPoint llp = GeoUtils.getLocationFromAddress(address, this.masterTimeStamp);
            this.viewManager.getIdvUIManager().showNormalCursor();
            if (llp == null) {
                if (timestamp == this.masterTimeStamp[0]) {
                    LogUtil.userMessage("Could not find address");
                }
            } else {
                Real alt = new Real(RealType.Altitude, 1000.0);
                this.viewManager.getMapDisplay().centerAndZoom(GeoUtils.toEarthLocation(llp), alt, 1.0, true, true);
                this.ignoreChanges = true;
                GeoUtils.initAddressBox(this.addressBox);
                this.ignoreChanges = false;
            }
        }
        catch (Exception exc) {
            LogUtil.logException("Error going to address", exc);
        }
    }

    private void initLocations() {
        this.locations.add(new Location(146, 52, width0, CMD_JOYSTICK));
        this.locations.add(new Location(zoomX, topY1, width1, "action:cmd.nav.small.zoomin"));
        this.locations.add(new Location(zoomX, bottomY1, width1, "action:cmd.nav.small.zoomout"));
        this.locations.add(new Location(tiltX, topY1, width1, "action:cmd.nav.small.tiltdown"));
        this.locations.add(new Location(tiltX, bottomY1, width1, "action:cmd.nav.small.tiltup"));
        this.locations.add(new Location(rotateLeftX, rotateY, width3, "action:cmd.nav.small.rotateleft"));
        this.locations.add(new Location(rotateRightX, rotateY, width3, "action:cmd.nav.small.rotateright"));
        if (this.flythrough != null) {
            this.locations.add(new Location(panLeftX, panHY, width2, "action:cmd.fly.left"));
            this.locations.add(new Location(panRightX, panHY, width2, "action:cmd.fly.right"));
            this.locations.add(new Location(panVX, panUpY, width2, "action:cmd.fly.forward"));
            this.locations.add(new Location(panVX, panDownY, width2, "action:cmd.fly.back"));
        } else {
            this.locations.add(new Location(panLeftX, panHY, width2, "action:cmd.nav.small.left"));
            this.locations.add(new Location(panRightX, panHY, width2, "action:cmd.nav.small.right"));
            this.locations.add(new Location(panVX, panUpY, width2, "action:cmd.nav.small.up"));
            this.locations.add(new Location(panVX, panDownY, width2, "action:cmd.nav.small.down"));
        }
        this.locations.add(new Location(216, 86, 22, "action:cmd.nav.home"));
        this.locations.add(new Location(76, 73, width2, "action:none"));
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.isControlDown = e.isControlDown();
        this.isShiftDown = e.isShiftDown();
        this.dragEvent = e;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.isControlDown = e.isControlDown();
        this.isShiftDown = e.isShiftDown();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent event) {
        this.label.requestFocus();
        this.isControlDown = event.isControlDown();
        this.isShiftDown = event.isShiftDown();
        ++this.timeStamp;
        this.pressed = this.findLocation(event);
        if (this.pressed == null) {
            return;
        }
        if (this.pressed.method.equals(CMD_JOYSTICK)) {
            // empty if block
        }
        if (this.pressed != null) {
            this.label.repaint();
            this.startRun(this.pressed, ++this.timeStamp);
        }
    }

    public void startRun(Location location, int theTimeStamp) {
        Misc.run(() -> {
            do {
                this.processLocation(this.pressed);
                Misc.sleep(100L);
            } while (this.timeStamp == theTimeStamp && location == this.pressed);
        });
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        this.isControlDown = event.isControlDown();
        this.isShiftDown = event.isShiftDown();
        ++this.timeStamp;
        if (this.pressed != null) {
            this.pressed = null;
            this.label.repaint();
        }
    }

    private int getX(MouseEvent event) {
        int iconWidth = this.panelIcon.getIconWidth();
        int myWidth = this.label.getBounds().width;
        int iconX = myWidth / 2 - iconWidth / 2;
        return event.getX() - iconX;
    }

    private Location findLocation(MouseEvent event) {
        int iconX = this.getX(event);
        int iconY = event.getY();
        Location closest = null;
        Point p = new Point(iconX, iconY);
        for (int i = 0; i < this.locations.size(); ++i) {
            Location l = (Location)this.locations.get(i);
            if (!l.r.contains(p)) continue;
            return l;
        }
        return closest;
    }

    public void processLocation(Location location) {
        if (location == null) {
            return;
        }
        if (location.method.equals(CMD_JOYSTICK) && this.dragEvent != null) {
            NavigatedDisplay navDisplay = this.viewManager.getMapDisplay();
            int x = this.getX(this.dragEvent);
            int y = this.dragEvent.getY();
            int dx = location.cx - x;
            int dy = y - location.cy;
            int limit = 40;
            if (dx < -limit) {
                dx = -limit;
            }
            if (dx > limit) {
                dx = limit;
            }
            if (dy < -limit) {
                dy = -limit;
            }
            if (dy > limit) {
                dy = limit;
            }
            double px = (double)dx / (double)limit;
            double py = (double)dy / (double)limit;
            if (this.isControlDown || this.isShiftDown) {
                // empty if block
            }
            navDisplay.translate(px * 0.06, py * 0.06);
            return;
        }
        if (location.method.startsWith("action:")) {
            String cmd = location.method.substring(7);
            this.viewManager.actionPerformed(new ActionEvent(this, 1, cmd));
            return;
        }
    }

    @Override
    public void mouseClicked(MouseEvent event) {
    }

    private static class Location {
        int cx;
        int cy;
        Rectangle r;
        String method;

        public Location(int x, int y, int r, String method) {
            this(x, y, r, r, method);
        }

        public Location(int x, int y, int w, int h, String method) {
            this.r = new Rectangle(x - w / 2, y - h / 2, w, h);
            this.cx = x;
            this.cy = y;
            this.method = method;
        }

        public String toString() {
            return this.method;
        }
    }
}

