/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataOperand;
import ucar.unidata.data.DataSelection;
import ucar.unidata.data.DataSource;
import ucar.unidata.idv.IntegratedDataViewer;
import ucar.unidata.idv.ViewManager;
import ucar.unidata.idv.ui.DataSelectionWidget;
import ucar.unidata.idv.ui.DataTree;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.Misc;
import ucar.unidata.util.StringUtil;
import visad.DateTime;

public class DataTreeDialog
implements ActionListener {
    private static String TITLE = "Field Selector";
    private static final String CMD_POPUPDATACHOOSER = "Add New Data Source";
    private JDialog dialog;
    IntegratedDataViewer idv;
    private List paramNames;
    private List fieldNames;
    private boolean includeSubsetWidget;
    List dataTrees = new ArrayList();
    List dataSelectionWidgets = new ArrayList();
    List multiLists = new ArrayList();
    List selected = null;
    List dataSources;
    List categories;
    List operands = new ArrayList();

    public DataTreeDialog(IntegratedDataViewer idv, Component src, List operands, List dataSources, List selectedDataChoices) {
        this(idv, src, operands, dataSources, selectedDataChoices, true);
    }

    public DataTreeDialog(IntegratedDataViewer idv, Component src, List operands, List dataSources, List selectedDataChoices, boolean includeDataSubsetWidget) {
        this.dialog = GuiUtils.createDialog(null, TITLE, true);
        this.idv = idv;
        this.operands = operands;
        this.dataSources = dataSources;
        this.includeSubsetWidget = includeDataSubsetWidget;
        this.init(src, selectedDataChoices);
    }

    private void init(Component src, List selectedDataChoices) {
        for (int i = 0; i < this.operands.size(); ++i) {
            final DataOperand operand = (DataOperand)this.operands.get(i);
            List categoryList = operand.getCategories();
            DataTree dataTree = new DataTree(this.idv, this.dataSources, categoryList, operand.getParamName(), null);
            final int theIndex = i;
            dataTree.getTree().addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent me) {
                    if (me.getClickCount() > 1 && !operand.getMultiple()) {
                        DataTreeDialog.this.doOk();
                        return;
                    }
                    DataTreeDialog.this.treeClick(theIndex, me.getClickCount() > 1);
                }
            });
            this.idv.getIdvUIManager().addDataSourceHolder(dataTree);
            dataTree.setMultipleSelect(operand.getMultiple());
            if (selectedDataChoices != null) {
                dataTree.selectChoices(selectedDataChoices);
            } else if (operand.getPattern() != null) {
                String pattern = "pattern:" + operand.getPattern();
                for (int dataSourceIdx = 0; dataSourceIdx < this.dataSources.size(); ++dataSourceIdx) {
                    DataSource dataSource = (DataSource)this.dataSources.get(dataSourceIdx);
                    List choices = dataSource.findDataChoices(pattern);
                    if (choices == null || choices.size() <= 0) continue;
                    if (!operand.getMultiple()) {
                        choices = Misc.newList(choices.get(0));
                    }
                    dataTree.selectChoices(choices);
                    break;
                }
            }
            this.dataTrees.add(dataTree);
        }
        Component contents = this.doMakeContents();
        Container cpane = this.dialog.getContentPane();
        cpane.setLayout(new BoxLayout(cpane, 1));
        cpane.add(contents);
        try {
            Point loc = src.getLocationOnScreen();
            Dimension size = src.getSize();
            this.dialog.setLocation(loc.x + size.width, loc.y - 30);
        }
        catch (Exception exc) {
            this.dialog.setLocation(50, 50);
        }
        this.dialog.pack();
        this.dialog.setVisible(true);
    }

    private void treeClick(int index, boolean doubleClick) {
        DataTree tree = (DataTree)this.dataTrees.get(index);
        DataOperand operand = (DataOperand)this.operands.get(index);
        DataSelectionWidget dsw = (DataSelectionWidget)this.dataSelectionWidgets.get(index);
        DataChoice dataChoice = tree.getSelectedDataChoice();
        dsw.updateSelectionTab(dataChoice);
        if (doubleClick) {
            this.addMultiple(new Integer(index));
        }
    }

    private void deleteMultiple(int index) {
        JList list = (JList)this.multiLists.get(index);
        Vector v = new Vector(GuiUtils.getItems(list));
        Vector newV = new Vector(v);
        int[] indices = list.getSelectedIndices();
        for (int i = 0; i < indices.length; ++i) {
            newV.remove(v.get(indices[i]));
        }
        list.setListData(newV);
    }

    public void addMultiple(Integer index) {
        DataTree tree = (DataTree)this.dataTrees.get(index);
        DataSelectionWidget dsw = (DataSelectionWidget)this.dataSelectionWidgets.get(index);
        JList list = (JList)this.multiLists.get(index);
        Vector<DataChoice> v = new Vector<DataChoice>(GuiUtils.getItems(list));
        for (DataChoice dataChoice : tree.getSelectedDataChoices()) {
            DataChoice newDataChoice = dataChoice.createClone();
            newDataChoice.setDataSelection(dsw.createDataSelection(true));
            v.add(newDataChoice);
        }
        list.setListData(v);
    }

    public List getSelected() {
        return this.selected;
    }

    private Component doMakeContents() {
        ArrayList<JPanel> topComponents = new ArrayList<JPanel>();
        ArrayList<JComponent> timeComponents = new ArrayList<JComponent>();
        ArrayList<JPanel> multiComponents = new ArrayList<JPanel>();
        for (int i = 0; i < this.operands.size(); ++i) {
            JPanel multiComp;
            DataOperand operand = (DataOperand)this.operands.get(i);
            DataTree dataTree = (DataTree)this.dataTrees.get(i);
            JScrollPane scroller = dataTree.getScroller();
            final int index = i;
            JList multiList = new JList();
            multiList.setToolTipText("Press the 'Delete' key to delete selected entry");
            this.multiLists.add(multiList);
            multiList.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (GuiUtils.isDeleteEvent(e)) {
                        DataTreeDialog.this.deleteMultiple(index);
                    }
                }
            });
            DataSelectionWidget dsw = new DataSelectionWidget(this.idv, false);
            dsw.setDefaultLevelToFirst(false);
            this.dataSelectionWidgets.add(dsw);
            DataChoice dataChoice = ((DataTree)this.dataTrees.get(i)).getSelectedDataChoice();
            dsw.updateSelectionTab(dataChoice);
            String labelString = operand.getDescription();
            if (labelString == null || labelString.length() == 0) {
                labelString = operand.getLabel();
            }
            if (!(labelString = StringUtil.replace(labelString, "_", " ")).startsWith("<html")) {
                labelString = "<html>Field: <i><b>" + labelString + "</b></i></html>";
            }
            JLabel label = new JLabel(labelString);
            scroller.setPreferredSize(new Dimension(250, 300));
            JScrollPane treeContents = scroller;
            if (operand.getMultiple()) {
                JScrollPane multiScroller = GuiUtils.makeScrollPane(multiList, 250, 100);
                multiScroller.setPreferredSize(new Dimension(250, 100));
                JButton multiBtn = GuiUtils.makeButton("Add selected>>", this, "addMultiple", new Integer(index));
                multiComp = GuiUtils.topCenter(GuiUtils.left(multiBtn), multiScroller);
            } else {
                multiComp = new JPanel();
            }
            multiComponents.add(multiComp);
            topComponents.add(GuiUtils.topCenter(GuiUtils.inset((Component)label, new Insets(10, 5, 0, 10)), treeContents));
            timeComponents.add(dsw.getContents());
        }
        if (this.includeSubsetWidget) {
            topComponents.addAll(timeComponents);
            topComponents.addAll(multiComponents);
        }
        GuiUtils.tmpInsets = new Insets(4, 6, 4, 6);
        JPanel trees = GuiUtils.doLayout(topComponents, topComponents.size() / 3, GuiUtils.WT_Y, GuiUtils.WT_YYN);
        JPanel buttons = GuiUtils.makeButtons(this, new String[]{GuiUtils.CMD_OK, GuiUtils.CMD_CANCEL});
        return GuiUtils.centerBottom(trees, buttons);
    }

    private void doClose() {
        for (int i = 0; i < this.dataTrees.size(); ++i) {
            this.idv.getIdvUIManager().removeDataSourceHolder((DataTree)this.dataTrees.get(i));
        }
        this.dialog.hide();
    }

    public void dispose() {
        this.dataTrees = null;
        this.selected = null;
        this.dataSources = null;
        this.dialog.dispose();
    }

    public void doOk() {
        this.selected = new ArrayList();
        for (int i = 0; i < this.dataTrees.size(); ++i) {
            JList list = (JList)this.multiLists.get(i);
            Vector v = new Vector(GuiUtils.getItems(list));
            if (v.size() > 0) {
                this.selected.add(v);
                continue;
            }
            DataSelection dataSelection = null;
            DataSelectionWidget dsw = (DataSelectionWidget)this.dataSelectionWidgets.get(i);
            dataSelection = dsw.createDataSelection(true);
            DataTree dataTree = (DataTree)this.dataTrees.get(i);
            List selectedFromTree = DataChoice.cloneDataChoices(dataTree.getSelectedDataChoices());
            if (this.idv.getUseTimeDriver() && dsw.getTimeOption().equals("Match Time Driver")) {
                ViewManager vm = this.idv.getViewManager();
                dataSelection.putProperty("Use_Display_Driver_Times", true);
                try {
                    List<DateTime> times = vm.getTimeDriverTimes();
                    dataSelection.setTheTimeDriverTimes(times);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            for (int dataChoiceIdx = 0; dataChoiceIdx < selectedFromTree.size(); ++dataChoiceIdx) {
                ((DataChoice)selectedFromTree.get(dataChoiceIdx)).setDataSelection(dataSelection);
            }
            this.selected.add(selectedFromTree);
        }
        this.doClose();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String cmd = event.getActionCommand();
        if (cmd.equals(CMD_POPUPDATACHOOSER)) {
            if (this.idv != null) {
                this.idv.showChooserModal();
            }
            return;
        }
        if (cmd.equals(GuiUtils.CMD_OK)) {
            this.doOk();
            return;
        }
        if (cmd.equals(GuiUtils.CMD_CANCEL)) {
            this.selected = null;
            this.doClose();
            return;
        }
    }
}

