/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import ucar.unidata.data.CompositeDataChoice;
import ucar.unidata.data.DataAlias;
import ucar.unidata.data.DataCategory;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataManager;
import ucar.unidata.data.DataSource;
import ucar.unidata.data.DerivedDataChoice;
import ucar.unidata.data.DerivedDataDescriptor;
import ucar.unidata.idv.ControlDescriptor;
import ucar.unidata.idv.DisplayControl;
import ucar.unidata.idv.IntegratedDataViewer;
import ucar.unidata.idv.ui.DataSourceHolder;
import ucar.unidata.idv.ui.DataTreeNode;
import ucar.unidata.ui.DndTree;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.Misc;

public class DataTree
extends DataSourceHolder {
    List categories;
    private boolean showIcons = true;
    MyTree tree;
    DataTreeNode treeRoot;
    DefaultTreeModel treeModel;
    private Object searchState = null;
    Hashtable dataToTreeNode = new Hashtable();
    boolean showDataSourceNode = true;
    JScrollPane scroller;
    String initialSelectedFieldName;
    boolean doSort = false;

    public DataTree(IntegratedDataViewer idv, boolean showDataSourceNode, boolean treatFormulaDataSourceSpecial) {
        this(idv, null);
        this.showDataSourceNode = showDataSourceNode;
        this.treatFormulaDataSourceSpecial = treatFormulaDataSourceSpecial;
    }

    public DataTree(IntegratedDataViewer idv, DataSource formulaDataSource) {
        this(idv, formulaDataSource, (Dimension)null);
    }

    public DataTree(IntegratedDataViewer idv, DataSource formulaDataSource, Dimension defaultSize) {
        super(idv, formulaDataSource, defaultSize);
        this.init(null);
        if (formulaDataSource != null) {
            this.addDataSource(formulaDataSource);
        }
    }

    public DataTree(IntegratedDataViewer idv, List sources, List categories) {
        this(idv, sources, categories, null);
    }

    public DataTree(IntegratedDataViewer idv, List sources, List categories, Dimension defaultSize) {
        this(idv, sources, categories, null, defaultSize);
    }

    public DataTree(IntegratedDataViewer idv, List sources, List categories, String initialSelectedFieldName, Dimension defaultSize) {
        super(idv, null, defaultSize);
        this.categories = categories;
        this.initialSelectedFieldName = initialSelectedFieldName;
        this.init(sources);
    }

    public void sort() {
        this.doSort = true;
    }

    @Override
    protected String getName() {
        return "Data tree selector";
    }

    public void setDataSource(DataSource dataSource) {
        this.removeAllDataSources();
        this.addDataSource(dataSource);
    }

    @Override
    public JComponent getContents() {
        return this.getScroller();
    }

    public JTree getTree() {
        return this.tree;
    }

    private void handleTreeMouseEvent(MouseEvent e) {
        if (!SwingUtilities.isRightMouseButton(e)) {
            return;
        }
        List<DataChoice> choices = this.getSelectedDataChoices();
        if (choices == null || choices.size() == 0) {
            return;
        }
        DataChoice dataChoice = choices.get(0);
        JPopupMenu popup = new JPopupMenu();
        String name = dataChoice.getName();
        JMenu menu = new JMenu("Add \"" + name + "\" as alias for");
        for (DataAlias alias : Misc.sort(DataAlias.getDataAliasList())) {
            String aliasName = alias.getName();
            if (alias.getLabel().length() > 0) {
                aliasName = aliasName + " - " + alias.getLabel();
            }
            menu.add(GuiUtils.makeMenuItem(aliasName, this, "addAsAlias", new Object[]{name, alias}));
        }
        GuiUtils.limitMenuSize(menu, "Canonical Name", 15);
        popup.add(menu);
        popup.show((Component)e.getSource(), e.getX(), e.getY());
    }

    public void addAsAlias(Object[] pair) {
        String name = (String)pair[0];
        DataAlias alias = (DataAlias)pair[1];
        this.getIdv().getAliasEditor().addAsAlias(alias, name);
    }

    private void init(List sources) {
        this.showIcons = this.idv.getProperty("idv.ui.datatree.showicons", true);
        this.doSort = this.idv.getProperty("idv.ui.sortchoices", false);
        this.tree = new MyTree(this);
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                DataTree.this.handleTreeMouseEvent(e);
            }
        });
        ToolTipManager.sharedInstance().registerComponent(this.getTree());
        DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree theTree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                super.getTreeCellRendererComponent(theTree, value, sel, expanded, leaf, row, hasFocus);
                this.setToolTipText(null);
                if (value instanceof DataTreeNode) {
                    Object o;
                    DataTreeNode dtn = (DataTreeNode)value;
                    if (dtn.getIsDerived() && DataTree.this.showIcons) {
                        this.setIcon(DataSourceHolder.getDerivedIcon());
                    }
                    if ((o = dtn.getObject()) instanceof DerivedDataChoice) {
                        DerivedDataChoice ddc = (DerivedDataChoice)o;
                        if (ddc.getFormula() != null) {
                            this.setToolTipText("<html> " + ddc.getName() + "<br> " + ddc.getFormula() + "</html>");
                        }
                    } else if (o instanceof DataChoice) {
                        ImageIcon icon;
                        String iconPath;
                        DataChoice dc = (DataChoice)o;
                        if (DataTree.this.showIcons && (iconPath = dc.getProperty("prop.icon", null)) != null && (icon = GuiUtils.getImageIcon(iconPath, true)) != null) {
                            this.setIcon(icon);
                        }
                        this.setToolTipText("<html> " + dc.getName() + "<br> " + dc.getDescription() + "</html>");
                    } else if (o instanceof DataSource) {
                        this.setToolTipText(((DataSource)o).getDescription());
                    }
                }
                return this;
            }
        };
        this.tree.setCellRenderer(renderer);
        this.tree.setRowHeight(18);
        ImageIcon icon = GuiUtils.getImageIcon("/ucar/unidata/idv/ui/Bullet.gif", this.getClass());
        renderer.setOpenIcon(null);
        renderer.setClosedIcon(null);
        if (this.showIcons) {
            renderer.setLeafIcon(icon);
        } else {
            renderer.setLeafIcon(null);
        }
        Font f = renderer.getFont();
        this.treeRoot = new DataTreeNode(this, "");
        this.treeModel = new DefaultTreeModel(this.treeRoot);
        this.tree.setModel(this.treeModel);
        this.tree.setRootVisible(false);
        this.setMultipleSelect(true);
        this.tree.setShowsRootHandles(true);
        if (sources != null) {
            for (int i = 0; i < sources.size(); ++i) {
                this.addDataSource((DataSource)sources.get(i));
            }
        }
    }

    public void clearSearchState() {
        this.searchState = null;
    }

    public boolean doSearch(String searchString, JComponent near) {
        GuiUtils.TreeSearchResults results = GuiUtils.doTreeSearch(this.tree, this.searchState, "field", near, searchString);
        this.searchState = results.lastState;
        return results.success;
    }

    public void selectChoices(List choices) {
        this.selectChoices(choices, false);
    }

    public void selectChoices(List choices, boolean shouldSet) {
        for (int i = 0; i < choices.size(); ++i) {
            DataTreeNode node = this.getTreeNode(choices.get(i));
            if (node == null) continue;
            Object[] path = this.treeModel.getPathToRoot(node);
            if (shouldSet) {
                this.tree.setSelectionPath(new TreePath(path));
                continue;
            }
            this.tree.addSelectionPath(new TreePath(path));
        }
    }

    public void setMultipleSelect(boolean v) {
        this.tree.getSelectionModel().setSelectionMode(v ? 4 : 1);
    }

    public JScrollPane getScroller() {
        if (this.scroller == null) {
            if (this.defaultDimension == null) {
                this.defaultDimension = new Dimension(300, 400);
            }
            this.scroller = GuiUtils.makeScrollPane(this.getTree(), (int)this.defaultDimension.getWidth(), (int)this.defaultDimension.getHeight());
            this.scroller.setPreferredSize(this.defaultDimension);
        }
        return this.scroller;
    }

    @Override
    public void addDisplayControl(DisplayControl control, DataChoice choice) {
        DataTreeNode parent = this.getTreeNode(choice);
        if (parent == null) {
            return;
        }
        this.createTreeNode(parent, control.toString(), control);
    }

    @Override
    public void removeDisplayControl(DisplayControl control) {
        this.removeTreeNode(this.getTreeNode(control));
    }

    public boolean isValidData(Object data) {
        return this.getTreeNode(data) != null;
    }

    public DataTreeNode getTreeNode(Object data) {
        return (DataTreeNode)this.dataToTreeNode.get(data);
    }

    public DataTreeNode createTreeNode(String label, Object data) {
        DataTreeNode node = new DataTreeNode(this, label, data);
        this.dataToTreeNode.put(data, node);
        return node;
    }

    public DataTreeNode createTreeNode(DataTreeNode parent, String label, Object data) {
        DataTreeNode child = this.createTreeNode(label, data);
        parent.add(child);
        this.treeStructureChanged(child);
        return child;
    }

    public void removeTreeNode(DataTreeNode node) {
        if (node == null) {
            return;
        }
        if (node.getObject() != null) {
            this.dataToTreeNode.remove(node.getObject());
        }
        DataTreeNode parent = (DataTreeNode)node.getParent();
        node.removeFromParent();
        Hashtable paths = this.getExpandedPaths();
        if (parent != null) {
            this.treeModel.nodeStructureChanged(parent);
            TreePath path = new TreePath(parent.getPath());
            this.tree.expandPath(path);
        }
        GuiUtils.expandPathsAfterChange(this.tree, paths, this.treeRoot);
    }

    public void removeObject(Object dataObject) {
        this.removeTreeNode(this.getTreeNode(dataObject));
    }

    public TreePath getPath(DefaultMutableTreeNode treeNode) {
        return new TreePath(treeNode.getPath());
    }

    public Hashtable getExpandedPaths() {
        return GuiUtils.initializeExpandedPathsBeforeChange(this.tree, this.treeRoot);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.tree.clearPaths();
        this.tree.setModel(new DefaultTreeModel(new DataTreeNode(this, "")));
        this.tree.dispose();
        this.categories = null;
        this.treeRoot = null;
        this.treeModel = null;
        this.dataToTreeNode = null;
        this.scroller = null;
    }

    private void treeStructureChanged(DataTreeNode nodeToScrollTo) {
        this.treeStructureChanged(nodeToScrollTo, null);
    }

    private void treeStructureChanged(DataTreeNode nodeToScrollTo, Hashtable paths) {
        this.tree.clearPaths();
        this.treeModel.nodeStructureChanged(this.treeRoot);
        if (nodeToScrollTo != null) {
            // empty if block
        }
        if (paths != null) {
            // empty if block
        }
        if (nodeToScrollTo != null) {
            this.tree.scrollPathToVisible(this.getPath(nodeToScrollTo));
            this.tree.setSelectionPath(this.getPath(nodeToScrollTo));
        }
    }

    @Override
    public synchronized void removeAllDataSources() {
        super.removeAllDataSources();
        this.treeStructureChanged(null);
        this.rebuildMaps();
    }

    private void rebuildMaps() {
        this.dataToTreeNode = new Hashtable();
        this.rebuildMaps(this.treeRoot);
    }

    private void rebuildMaps(TreeNode node) {
        DataTreeNode treeNode;
        if (node == null) {
            return;
        }
        if (node instanceof DataTreeNode && (treeNode = (DataTreeNode)node).getObject() != null) {
            this.dataToTreeNode.put(treeNode.getObject(), node);
        }
        Enumeration<? extends TreeNode> nodes = node.children();
        while (nodes.hasMoreElements()) {
            this.rebuildMaps(nodes.nextElement());
        }
    }

    @Override
    public void removeDataSource(DataSource dataSource) {
        super.removeDataSource(dataSource);
        this.treeStructureChanged(null);
        this.rebuildMaps();
    }

    @Override
    protected boolean removeDataSourceInner(DataSource dataSource) {
        if (!super.removeDataSourceInner(dataSource)) {
            return false;
        }
        if (this.showDataSourceNode) {
            this.removeObject(dataSource);
        } else {
            this.treeRoot.removeAllChildren();
        }
        return true;
    }

    @Override
    public void dataSourceChanged(DataSource source) {
        this.addDataSource(source);
    }

    @Override
    public void addDataSource(DataSource dataSource) {
        Hashtable paths = this.getExpandedPaths();
        DataTreeNode dataSourceNode = this.getTreeNode(dataSource);
        boolean newDataSource = true;
        DataTreeNode parentNode = null;
        if (!this.showDataSourceNode) {
            this.treeRoot.removeAllChildren();
        }
        if (dataSourceNode != null) {
            dataSourceNode.removeAllChildren();
            newDataSource = false;
        } else {
            if (this.treatFormulaDataSourceSpecial && DataManager.isFormulaDataSource(dataSource) && this.formulaDataSource == null) {
                this.formulaDataSource = dataSource;
                dataSourceNode = this.getTreeNode(dataSource);
                if (dataSourceNode == null && this.showDataSourceNode) {
                    dataSourceNode = this.createTreeNode(dataSource.toString(), dataSource);
                    this.treeRoot.insert(dataSourceNode, 0);
                }
            } else if (this.showDataSourceNode) {
                dataSourceNode = this.createTreeNode(dataSource.toString(), dataSource);
                this.treeRoot.add(dataSourceNode);
            }
            super.addDataSource(dataSource);
        }
        parentNode = this.showDataSourceNode && dataSourceNode != null ? dataSourceNode : this.treeRoot;
        ArrayList<Object> choices = new ArrayList<Object>();
        choices.addAll(dataSource.getDataChoices());
        if (this.doSort) {
            Collections.sort(choices, new Comparator(){

                public int compare(Object o1, Object o2) {
                    String s1 = o1.toString().toLowerCase();
                    String s2 = o2.toString().toLowerCase();
                    return s1.compareTo(s2);
                }
            });
        }
        ArrayList nodesToExpand = new ArrayList();
        List initialSelectedChoices = null;
        int cnt = 0;
        DefaultMutableTreeNode lastNode = null;
        Hashtable<String, DataTreeNode> catToNode = new Hashtable<String, DataTreeNode>();
        if (DataManager.isFormulaDataSource(dataSource)) {
            int i;
            List<Object[]> pairs = new ArrayList();
            for (i = 0; i < choices.size(); ++i) {
                DataChoice choice = (DataChoice)choices.get(i);
                String desc = choice.getDescription();
                if (desc.trim().length() == 0) {
                    desc = "no name";
                }
                pairs.add(new Object[]{desc, choice});
            }
            pairs = Misc.sortTuples(pairs, true);
            choices = new ArrayList();
            for (i = 0; i < pairs.size(); ++i) {
                choices.add(((Object[])pairs.get(i))[1]);
            }
        }
        for (int i = 0; i < choices.size(); ++i) {
            String desc;
            DataChoice choice = (DataChoice)choices.get(i);
            if (!choice.getForUser() || this.categories != null && !(choice instanceof CompositeDataChoice) && !DataCategory.applicableTo(this.categories, choice.getCategories())) continue;
            ++cnt;
            if (this.initialSelectedFieldName != null && (choice.toString().equals(this.initialSelectedFieldName) || choice.getName().equals(this.initialSelectedFieldName))) {
                initialSelectedChoices = Misc.newList(choice);
                this.initialSelectedFieldName = null;
            }
            if ((desc = choice.getDescription()).trim().length() == 0) {
                desc = "no name";
            }
            DataTreeNode fieldNode = this.createTreeNode(desc, choice);
            lastNode = fieldNode;
            fieldNode.setIsDerived(choice instanceof DerivedDataChoice);
            DataTreeNode parent = parentNode;
            String catPath = null;
            for (DataCategory topCategory = choice.getDisplayCategory(); topCategory != null; topCategory = topCategory.getChild()) {
                String catName = topCategory.getName();
                if (catName.equals("skip")) continue;
                DataTreeNode nextNode = (DataTreeNode)catToNode.get(catPath = catPath == null ? catName : catPath + "-" + catName);
                if (nextNode == null) {
                    nextNode = this.createTreeNode(parent, catName, catPath);
                    catToNode.put(catPath, nextNode);
                }
                parent = nextNode;
            }
            parent.add(fieldNode);
            if (!(choice instanceof CompositeDataChoice)) continue;
            fieldNode.add(new DefaultMutableTreeNode(""));
        }
        if (this.showDataSourceNode && dataSourceNode != null && cnt == 0) {
            DataTreeNode parent = (DataTreeNode)dataSourceNode.getParent();
            parent.remove(dataSourceNode);
        }
        GuiUtils.moveSubtreesToTop(parentNode);
        this.rebuildMaps();
        if (cnt == 0) {
            // empty if block
        }
        this.treeStructureChanged(parentNode);
        for (int i = 0; i < nodesToExpand.size(); ++i) {
            DataTreeNode nodeToExpand = (DataTreeNode)nodesToExpand.get(i);
            TreePath path = this.getPath(nodeToExpand);
            this.tree.expandPath(path);
        }
        if (cnt == 1) {
            if (lastNode.getParent() != parentNode) {
                Enumeration<TreeNode> nodes = parentNode.children();
                while (nodes.hasMoreElements()) {
                    parentNode.remove((DefaultMutableTreeNode)nodes.nextElement());
                }
                parentNode.add(lastNode);
            }
            this.treeStructureChanged((DataTreeNode)lastNode);
        }
        if (initialSelectedChoices != null) {
            this.selectChoices(initialSelectedChoices, true);
        }
        GuiUtils.expandPathsAfterChange(this.tree, paths, this.treeRoot);
    }

    protected void createSubtree(CompositeDataChoice choice, DataTreeNode treeNode) {
        List children = choice.getDataChoices();
        for (int i = 0; i < children.size(); ++i) {
            DataChoice child = (DataChoice)children.get(i);
            DataTreeNode childNode = this.createTreeNode(child.toString(), child);
            treeNode.add(childNode);
            if (!(child instanceof CompositeDataChoice)) continue;
            this.createSubtree((CompositeDataChoice)child, childNode);
        }
    }

    public void openUp() {
        this.openUp(this.treeRoot, null);
    }

    private void openUp(DataTreeNode node, DataTreeNode parent) {
        Object object = node.getObject();
        if (object instanceof DataChoice) {
            this.tree.expandPath(this.getPath(parent));
            Object[] path = this.treeModel.getPathToRoot(node);
            this.tree.addSelectionPath(new TreePath(path));
            return;
        }
        if (node.getChildCount() > 1 || node.getChildCount() == 0) {
            return;
        }
        this.openUp((DataTreeNode)node.getChildAt(0), node);
    }

    public DataChoice getSelectedDataChoice() {
        List<DataChoice> choices = this.getSelectedDataChoices();
        if (choices.size() == 0) {
            return null;
        }
        return choices.get(0);
    }

    public DataChoice getSelectedDataChoice(ControlDescriptor descriptor) {
        List<DataChoice> choices = this.getSelectedDataChoices();
        for (int i = 0; i < choices.size(); ++i) {
            DataChoice dataChoice = choices.get(i);
            if (!descriptor.applicableTo(dataChoice)) continue;
            return dataChoice;
        }
        return null;
    }

    public List<DataChoice> getSelectedDataChoicesRecursive() {
        return null;
    }

    public List<DataChoice> getSelectedDataChoices() {
        TreePath[] paths = this.tree.getSelectionModel().getSelectionPaths();
        ArrayList<DataChoice> choices = new ArrayList<DataChoice>();
        if (paths == null) {
            return choices;
        }
        for (int i = 0; i < paths.length; ++i) {
            Object object;
            Object last = paths[i].getLastPathComponent();
            if (last == null || !((object = ((DataTreeNode)last).getObject()) instanceof DataChoice)) continue;
            DataChoice choice = (DataChoice)object;
            choices.add(choice);
        }
        return choices;
    }

    public Object getObjectAt(int x, int y) {
        TreePath path = this.tree.getPathForLocation(x, y);
        if (path == null) {
            return null;
        }
        Object last = path.getLastPathComponent();
        if (last == null) {
            return null;
        }
        Object object = ((DataTreeNode)last).getObject();
        if (object == null) {
            return null;
        }
        if (object instanceof DataChoice) {
            this.tree.setSelectionPath(path);
        }
        return object;
    }

    private static class MyTree
    extends DndTree {
        private DataTree dataTree;

        public MyTree(DataTree dataTree) {
            this.dataTree = dataTree;
        }

        @Override
        public void fireTreeWillExpand(TreePath treePath) throws ExpandVetoException {
            DataTreeNode node;
            Object[] path = treePath.getPath();
            if (path.length > 0 && path[path.length - 1] instanceof DataTreeNode && (node = (DataTreeNode)path[path.length - 1]).getObject() instanceof CompositeDataChoice) {
                node.checkExpansion(this.dataTree);
            }
            super.fireTreeWillExpand(treePath);
        }

        public void dispose() {
            this.dataTree = null;
        }

        public void clearPaths() {
        }

        @Override
        protected boolean okToDrag(DefaultMutableTreeNode sourceNode) {
            if (!(sourceNode instanceof DataTreeNode)) {
                return false;
            }
            DataTreeNode dtn = (DataTreeNode)sourceNode;
            if (!(dtn.getObject() instanceof DerivedDataChoice)) {
                return false;
            }
            DerivedDataChoice ddc = (DerivedDataChoice)dtn.getObject();
            return ddc.isEndUserFormula();
        }

        @Override
        protected boolean okToDrop(DefaultMutableTreeNode sourceNode, DefaultMutableTreeNode destNode) {
            if (sourceNode.getParent() == destNode) {
                return false;
            }
            if (!(sourceNode instanceof DataTreeNode)) {
                return false;
            }
            if (!(destNode instanceof DataTreeNode)) {
                return false;
            }
            Object destData = ((DataTreeNode)destNode).getObject();
            return destData instanceof String;
        }

        @Override
        protected void doDrop(DefaultMutableTreeNode sourceNode, DefaultMutableTreeNode destNode) {
            DerivedDataChoice ddc = (DerivedDataChoice)((DataTreeNode)sourceNode).getObject();
            DerivedDataDescriptor ddd = ddc.getDataDescriptor();
            String category = "";
            category = ((DataTreeNode)destNode).getObject().toString();
            DataCategory dataCategory = DataCategory.parseCategory(category, true);
            dataCategory.setForDisplay(true);
            ddd.setDataCategories(Misc.newList(dataCategory));
            this.dataTree.getIdv().getJythonManager().descriptorChanged(ddd);
        }
    }
}

