/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.ui;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataSource;
import ucar.unidata.idv.DisplayControl;
import ucar.unidata.idv.IntegratedDataViewer;
import ucar.unidata.idv.ui.IdvWindow;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.Misc;

public abstract class DataSourceHolder {
    protected IntegratedDataViewer idv;
    protected IdvWindow frame;
    private List dataSources;
    protected DataSource formulaDataSource;
    protected boolean treatFormulaDataSourceSpecial = true;
    protected Dimension defaultDimension;
    private static ImageIcon derivedIcon;

    public DataSourceHolder(IntegratedDataViewer idv, DataSource formulaDataSource, Dimension defaultDimension) {
        this.idv = idv;
        this.formulaDataSource = formulaDataSource;
        if (defaultDimension != null) {
            this.defaultDimension = new Dimension(defaultDimension);
        }
    }

    public IdvWindow doMakeFrame() {
        if (this.frame == null) {
            JButton newBtn = new JButton("Add New Data Source");
            newBtn.addActionListener(e -> this.idv.showChooser());
            JButton closeBtn = new JButton("Close");
            closeBtn.addActionListener(e -> this.doClose());
            JComponent extra = this.getButtons();
            JPanel buttons = extra != null ? GuiUtils.wrap(GuiUtils.hflow(Misc.newList(extra, closeBtn), 4, 4)) : GuiUtils.wrap(GuiUtils.hflow(Misc.newList(closeBtn), 4, 4));
            JPanel contents = GuiUtils.centerBottom(this.getContents(), buttons);
            this.frame = new IdvWindow(this.getName(), this.idv, false);
            this.frame.getContentPane().add(contents);
            this.frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    DataSourceHolder.this.doClose();
                }
            });
            this.frame.pack();
            this.frame.show();
        }
        return this.frame;
    }

    public IntegratedDataViewer getIdv() {
        return this.idv;
    }

    protected String getName() {
        return "Field Selector";
    }

    public void doClose() {
        this.idv.getIdvUIManager().removeDataSourceHolder(this);
        this.dispose();
    }

    public void show() {
        JComponent contents;
        if (this.frame != null) {
            this.frame.show();
        }
        if ((contents = this.getContents()) != null) {
            GuiUtils.showComponentInTabs(contents, true);
        }
    }

    public void setFrame(IdvWindow f) {
        this.frame = f;
    }

    public IdvWindow getFrame() {
        return this.frame;
    }

    public abstract JComponent getContents();

    public Point getLocationOnScreen() {
        return this.getContents().getLocationOnScreen();
    }

    public JComponent getButtons() {
        return null;
    }

    public List getDataSources() {
        if (this.dataSources == null) {
            this.dataSources = new ArrayList();
        }
        return this.dataSources;
    }

    public static ImageIcon getDerivedIcon() {
        if (derivedIcon == null) {
            derivedIcon = GuiUtils.getImageIcon("/auxdata/ui/icons/Derived.gif", DataSourceHolder.class);
        }
        return derivedIcon;
    }

    public void setDefaultSize(Dimension d) {
        this.defaultDimension = new Dimension(d);
    }

    public void addDisplayControl(DisplayControl control, DataChoice choice) {
    }

    public void removeDisplayControl(DisplayControl control) {
    }

    public void addDisplayControl(DisplayControl control) {
    }

    public void dispose() {
        if (this.frame != null) {
            this.frame.dispose();
        }
        this.formulaDataSource = null;
        this.frame = null;
        this.dataSources = null;
    }

    public synchronized void removeAllDataSources() {
        ArrayList tmp = new ArrayList(this.getDataSources());
        for (int i = 0; i < tmp.size(); ++i) {
            DataSource source = (DataSource)tmp.get(i);
            this.removeDataSourceInner(source);
        }
    }

    public void addDataSource(DataSource dataSource) {
        if (!this.getDataSources().contains(dataSource)) {
            this.getDataSources().add(dataSource);
        }
    }

    public void removeDataSource(DataSource dataSource) {
        this.removeDataSourceInner(dataSource);
    }

    protected boolean removeDataSourceInner(DataSource dataSource) {
        if (this.treatFormulaDataSourceSpecial && dataSource == this.formulaDataSource) {
            return false;
        }
        this.getDataSources().remove(dataSource);
        return true;
    }

    public void dataSourceChanged(DataSource source) {
    }

    public void dataSourceTimeChanged(DataSource source) {
    }

    public void displayTemplatesChanged() {
    }
}

