/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.ui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataManager;
import ucar.unidata.data.DataSource;
import ucar.unidata.data.DataSourceImpl;
import ucar.unidata.idv.IntegratedDataViewer;
import ucar.unidata.idv.ui.DataControlDialog;
import ucar.unidata.idv.ui.DataSourceHolder;
import ucar.unidata.idv.ui.DataTree;
import ucar.unidata.ui.ButtonTabbedPane;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.Misc;
import ucar.unidata.util.Msg;

public class DataSelector
extends DataSourceHolder {
    private static ImageIcon cancelIcon;
    private static ImageIcon searchIcon;
    public static final Color COLOR_BADSEARCH;
    private static final int DIM_H_X = 200;
    private static final int DIM_H_Y = 100;
    private boolean horizontalOrientation = false;
    Dimension defaultDimension;
    JComponent contents;
    private boolean singletonDataSource = false;
    private ButtonTabbedPane tabbedPane;
    private List wrappers = new ArrayList();

    public DataSelector(IntegratedDataViewer idv, DataSource formulaDataSource) {
        this(idv, true, formulaDataSource);
    }

    public DataSelector(IntegratedDataViewer idv, boolean horizontalOrientation, DataSource formulaDataSource) {
        super(idv, formulaDataSource, null);
        this.horizontalOrientation = horizontalOrientation;
        this.init(null);
        if (formulaDataSource != null) {
            this.addDataSource(formulaDataSource);
        }
    }

    public DataSelector(IntegratedDataViewer idv, Dimension defaultSize, boolean singletonDataSource) {
        super(idv, null, defaultSize);
        this.singletonDataSource = singletonDataSource;
        this.init(null);
    }

    private void init(List sources) {
        this.tabbedPane = new ButtonTabbedPane(GuiUtils.inset((Component)new JLabel("Data Sources:"), new Insets(5, 5, 0, 0)), 175);
        this.contents = this.tabbedPane;
        if (sources != null) {
            for (int i = 0; i < sources.size(); ++i) {
                this.addDataSource((DataSource)sources.get(i));
            }
        }
    }

    private Component getCurrentComponent() {
        List wrappers = this.getWrappers();
        for (int i = 0; i < wrappers.size(); ++i) {
            DataSourceWrapper wrapper = (DataSourceWrapper)wrappers.get(i);
            if (!wrapper.button.isSelected()) continue;
            return wrapper.contents;
        }
        return null;
    }

    private DataSource findCurrentDataSource() {
        Component comp = this.getCurrentComponent();
        if (comp == null) {
            return null;
        }
        List wrappers = this.getWrappers();
        for (int i = 0; i < wrappers.size(); ++i) {
            DataSourceWrapper wrapper = (DataSourceWrapper)wrappers.get(i);
            if (wrapper.contents != comp) continue;
            return wrapper.dataSource;
        }
        return null;
    }

    public void setDataSource(DataSource dataSource) {
        if (this.singletonDataSource) {
            this.removeAllDataSources();
            this.addDataSource(dataSource);
        } else {
            this.addDataSource(dataSource);
        }
    }

    private static JComponent makeLabel(String s) {
        return GuiUtils.inset((Component)new JLabel(s), 4);
    }

    private void showDataSourceMenu(MouseEvent event, JComponent where, DataSource dataSource) {
        if (!SwingUtilities.isRightMouseButton(event)) {
            return;
        }
        List items = this.getIdv().getIdvUIManager().doMakeDataSourceMenuItems(dataSource, where);
        if (items != null && items.size() > 0) {
            JPopupMenu menu = GuiUtils.makePopupMenu(items);
            menu.show(where, event.getX(), event.getY());
        }
    }

    private DataSource getDataSourceAt(int listIndex) {
        return (DataSource)this.getDataSources().get(listIndex);
    }

    @Override
    public JComponent getContents() {
        return this.contents;
    }

    @Override
    public JComponent getButtons() {
        return new JPanel();
    }

    @Override
    public void dispose() {
        for (int i = 0; i < this.getDataSources().size(); ++i) {
            DataSource dataSource = (DataSource)this.getDataSources().get(i);
            if (dataSource != null) continue;
        }
        super.dispose();
    }

    private DataSourceWrapper findWrapper(DataSource dataSource) {
        List wrappers = this.getWrappers();
        for (int i = 0; i < wrappers.size(); ++i) {
            DataSourceWrapper wrapper = (DataSourceWrapper)wrappers.get(i);
            if (!Misc.equals(dataSource, wrapper.dataSource)) continue;
            return wrapper;
        }
        return null;
    }

    @Override
    protected boolean removeDataSourceInner(DataSource dataSource) {
        if (!super.removeDataSourceInner(dataSource)) {
            return false;
        }
        DataSourceWrapper wrapper = this.findWrapper(dataSource);
        if (wrapper != null) {
            this.wrappers.remove(wrapper);
            wrapper.remove();
        }
        return true;
    }

    @Override
    public void displayTemplatesChanged() {
        List wrappers = this.getWrappers();
        for (int i = 0; i < wrappers.size(); ++i) {
            DataSourceWrapper wrapper = (DataSourceWrapper)wrappers.get(i);
            wrapper.dcd.displayTemplatesChanged();
        }
    }

    private void dataSourcesChanged(boolean forceUpdate) {
        List wrappers = this.getWrappers();
        for (int i = 0; i < wrappers.size(); ++i) {
            DataSourceWrapper wrapper = (DataSourceWrapper)wrappers.get(i);
            wrapper.dataSourceChanged();
        }
    }

    private List getWrappers() {
        return new ArrayList(this.wrappers);
    }

    @Override
    public void dataSourceTimeChanged(DataSource dataSource) {
        this.dataSourceChanged(dataSource);
    }

    @Override
    public void dataSourceChanged(DataSource dataSource) {
        List wrappers = this.getWrappers();
        for (int i = 0; i < wrappers.size(); ++i) {
            DataSourceWrapper wrapper = (DataSourceWrapper)wrappers.get(i);
            if (!Misc.equals(wrapper.dataSource, dataSource) || !Misc.equals(wrapper.dataSource, dataSource)) continue;
            wrapper.dataSourceChanged();
        }
    }

    @Override
    public void addDataSource(DataSource dataSource) {
        this.addDataSource(dataSource, this.formulaDataSource != null && dataSource.equals(this.formulaDataSource));
    }

    private void addDataSource(DataSource dataSource, boolean forceUpdate) {
        super.addDataSource(dataSource);
        DataSourceWrapper wrapper = this.findWrapper(dataSource);
        if (wrapper == null) {
            wrapper = new DataSourceWrapper(this, dataSource);
            this.wrappers.add(wrapper);
        }
        this.dataSourcesChanged(forceUpdate);
    }

    public static String getNameForDataSource(DataSource ds) {
        return DataSelector.getNameForDataSource(ds, 30, true);
    }

    public static String getNameForDataSource(DataSource ds, int length, boolean alwaysDoIt) {
        return DataSourceImpl.getNameForDataSource(ds, length, alwaysDoIt);
    }

    static {
        COLOR_BADSEARCH = new Color(255, 102, 102);
    }

    public static class DataSourceWrapper
    extends JPanel {
        private final Object SEARCH_MUTEX = new Object();
        DataSelector dataSelector;
        private JPanel treePanel;
        private JButton searchBtn;
        private JPanel searchPanel;
        private JTextField searchFld;
        private JButton sortBtn;
        private JPanel searchFldPanel;
        private boolean showingSearchFld = false;
        DataSource dataSource;
        DataControlDialog dcd;
        JComponent contents;
        DataTree dataTree;
        JToggleButton button;

        public DataSourceWrapper(DataSelector theDataSelector, DataSource dataSource) {
            this.dataSelector = theDataSelector;
            this.dataSource = dataSource;
            this.doMakeContents();
            this.button = this.dataSelector.tabbedPane.addTab(this.getLabel(), (Component)this.contents);
            this.initButton();
            this.dataSourceChanged();
        }

        private void initButton() {
            this.button.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent event) {
                    if (!SwingUtilities.isRightMouseButton(event) && event.getClickCount() > 1) {
                        if (DataManager.isFormulaDataSource(dataSource)) {
                            dataSelector.getIdv().getJythonManager().showFormulaDialog();
                        } else {
                            dataSource.showPropertiesDialog();
                        }
                    }
                }

                @Override
                public void mousePressed(MouseEvent event) {
                    if (SwingUtilities.isRightMouseButton(event)) {
                        dataSelector.showDataSourceMenu(event, (JComponent)event.getSource(), dataSource);
                    }
                }
            });
        }

        private void doMakeContents() {
            JButton createBtn;
            this.dcd = new DataControlDialog(this.dataSelector.getIdv(), false, this.dataSelector.horizontalOrientation);
            this.dataTree = this.createDataTree(this.dataSource);
            this.treePanel = new JPanel();
            this.treePanel.setLayout(new BorderLayout());
            if (this.dataSelector.horizontalOrientation) {
                this.treePanel.setPreferredSize(new Dimension(200, 100));
            } else {
                this.treePanel.setPreferredSize(new Dimension(200, 200));
            }
            JComponent treeContents = this.dataTree.getContents();
            if (treeContents != null) {
                this.treePanel.add("Center", treeContents);
                DataChoice dataChoice = this.dataTree.getSelectedDataChoice();
                if (dataChoice != null) {
                    this.dcd.setDataChoice(dataChoice);
                }
            }
            this.searchFldPanel = new JPanel(new CardLayout());
            this.searchFld = new JTextField("", 7);
            this.searchFld.setToolTipText("<html>" + Msg.msg("Enter a search term") + "<br>" + Msg.msg("Press return to repeat search") + "<br>" + Msg.msg("Escape to close") + "</html>");
            this.searchFld.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    if (e.getKeyCode() == 27) {
                        this.searchBtnPressed();
                    } else {
                        this.doSearch(e.getKeyCode() != 10);
                    }
                }
            });
            this.sortBtn = GuiUtils.makeImageButton("/auxdata/ui/icons/DownDown.gif", this, "sort");
            this.sortBtn.setToolTipText("Sort the entries");
            this.searchFldPanel.add("empty", new JLabel(" "));
            this.searchFldPanel.add("field", this.searchFld);
            this.searchBtn = GuiUtils.makeImageButton("/auxdata/ui/icons/Search16.gif", this, "searchBtnPressed");
            if (cancelIcon == null) {
                cancelIcon = GuiUtils.getImageIcon("/auxdata/ui/icons/cancel.gif", true);
                searchIcon = GuiUtils.getImageIcon("/auxdata/ui/icons/Search16.gif", true);
            }
            this.searchPanel = GuiUtils.centerRight(this.searchFldPanel, this.searchBtn);
            JPanel left = GuiUtils.topCenter(GuiUtils.leftRight(DataSelector.makeLabel("Fields"), this.searchPanel), this.treePanel);
            left.setBorder(null);
            GuiUtils.makeMouseOverBorder(this.searchBtn);
            this.searchBtn.setToolTipText("Search for a field by name");
            this.searchBtn.setFocusPainted(false);
            if (this.dataSelector.horizontalOrientation) {
                this.dcd.displayScroller.setPreferredSize(new Dimension(200, 100));
                createBtn = GuiUtils.makeButton("Create Display", this.dcd, "doOk");
                createBtn.setHorizontalAlignment(2);
                this.dcd.addCreateButton(createBtn);
                this.dcd.getDataSelectionWidget().getTimesList().setPreferredSize(new Dimension(200, 100));
                JSplitPane right = GuiUtils.hsplit((Component)this.dcd.getDataSelectionWidget().getTimesList(), (Component)GuiUtils.topCenter(GuiUtils.wrap(GuiUtils.inset((Component)createBtn, 1)), this.dcd.displayScroller), 0.5);
                right.setBorder(null);
                this.contents = GuiUtils.hsplit((Component)left, (Component)right, 0.5);
            } else {
                JPanel right = GuiUtils.topCenter(DataSelector.makeLabel("Displays    "), GuiUtils.inset((Component)this.dcd.getContents(), 4));
                this.contents = GuiUtils.hsplit((Component)left, (Component)right, 0.5);
            }
            if (!this.dataSelector.horizontalOrientation) {
                createBtn = new JButton("Create Display");
                createBtn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        dcd.doOk();
                    }
                });
                this.dcd.addCreateButton(createBtn);
                this.contents = GuiUtils.centerBottom(this.contents, GuiUtils.inset((Component)GuiUtils.wrap(createBtn), 5));
                this.contents = GuiUtils.inset((Component)this.contents, new Insets(0, 0, 0, 0));
            }
        }

        public void sort() {
            this.dataTree.sort();
        }

        private void remove() {
            this.dataSelector.tabbedPane.remove(this.button, this.contents);
        }

        public void dataSourceChanged() {
            String toolTip = "<html>&nbsp;" + this.dataSource.toString() + "&nbsp;<br>&nbsp;Right mouse to show context menu</html>";
            this.button.setText(this.getLabel());
            this.button.setToolTipText(toolTip);
            this.dcd.dataSourceChanged(this.dataSource);
            this.dataTree.dataSourceChanged(this.dataSource);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doSearch(boolean andClear) {
            Object object = this.SEARCH_MUTEX;
            synchronized (object) {
                String s = this.searchFld.getText().trim();
                if (s.length() == 0) {
                    this.dataTree.clearSearchState();
                    this.searchFld.setBackground(Color.white);
                    return;
                }
                if (andClear) {
                    this.dataTree.clearSearchState();
                }
                if (this.dataTree.doSearch(s, this.searchBtn)) {
                    this.searchFld.setBackground(Color.white);
                } else {
                    this.dataTree.clearSearchState();
                    if (this.dataTree.doSearch(s, this.searchBtn)) {
                        this.searchFld.setBackground(Color.white);
                    } else {
                        this.searchFld.setBackground(COLOR_BADSEARCH);
                    }
                }
            }
        }

        private DataTree createDataTree(final DataSource dataSource) {
            final DataTree dataTree = new DataTree(this.dataSelector.getIdv(), false, true);
            dataTree.getTree().addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (!showingSearchFld) {
                        if (e.getKeyCode() == 70 && e.isControlDown() || e.getKeyCode() == 47) {
                            this.searchBtnPressed();
                        }
                    } else if (e.getKeyCode() == 27) {
                        this.searchBtnPressed();
                    }
                }
            });
            dataTree.getTree().addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    DataChoice selectedChoice = dataTree.getSelectedDataChoice();
                    if (selectedChoice != null) {
                        dcd.setDataChoice(selectedChoice);
                    } else {
                        String choiceName = (String)dataSource.getProperty("datachoicename");
                        if (choiceName != null) {
                            selectedChoice = dataSource.findDataChoice(choiceName);
                            if (selectedChoice != null) {
                                ArrayList<DataChoice> selectedChoices = new ArrayList<DataChoice>();
                                selectedChoices.add(selectedChoice);
                                dataTree.selectChoices(selectedChoices, true);
                            } else {
                                dcd.setDataChoice(null);
                            }
                        } else {
                            dcd.setDataChoice(null);
                        }
                    }
                }
            });
            dataTree.getTree().addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent event) {
                    Object object = dataTree.getObjectAt(event.getX(), event.getY());
                    if (object == null || !(object instanceof DataChoice)) {
                        return;
                    }
                    DataChoice dataChoice = (DataChoice)object;
                    if (SwingUtilities.isRightMouseButton(event) && ((DataChoice)object).isEndUserFormula()) {
                        dataSelector.getIdv().getIdvUIManager().showDataTreeMenu(dataTree, event, false);
                    } else if (SwingUtilities.isLeftMouseButton(event) && event.getClickCount() > 1) {
                        dcd.setDataChoice(dataChoice);
                        dataSelector.getIdv().getIdvUIManager().processDialog(dcd);
                    }
                }
            });
            dataTree.getTree().addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent event) {
                    if (GuiUtils.isDeleteEvent(event)) {
                        dataSelector.getIdv().getIdvUIManager().deleteKeyPressed(dataTree);
                    }
                }
            });
            dataTree.setDataSource(dataSource);
            dataTree.openUp();
            DataChoice selectedChoice = dataTree.getSelectedDataChoice();
            if (selectedChoice != null) {
                this.dcd.setDataChoice(selectedChoice);
            }
            return dataTree;
        }

        public String getLabel() {
            return DataSelector.getNameForDataSource(this.dataSource, 30, true);
        }

        public void searchBtnPressed() {
            CardLayout cardLayout = (CardLayout)this.searchFldPanel.getLayout();
            if (!this.showingSearchFld) {
                cardLayout.show(this.searchFldPanel, "field");
                this.searchFld.requestFocus();
                this.searchBtn.setIcon(cancelIcon);
            } else {
                this.searchBtn.setIcon(searchIcon);
                cardLayout.show(this.searchFldPanel, "empty");
            }
            this.showingSearchFld = !this.showingSearchFld;
        }
    }
}

