/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.ListSelectionModel;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataSelection;
import ucar.unidata.data.DataSelectionComponent;
import ucar.unidata.data.DataSource;
import ucar.unidata.data.DataSourceImpl;
import ucar.unidata.data.DerivedDataChoice;
import ucar.unidata.data.GeoSelection;
import ucar.unidata.data.GeoSelectionPanel;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.idv.ControlDescriptor;
import ucar.unidata.idv.IntegratedDataViewer;
import ucar.unidata.idv.MapViewManager;
import ucar.unidata.idv.NavigatedViewManager;
import ucar.unidata.idv.ViewManager;
import ucar.unidata.idv.chooser.TimesChooser;
import ucar.unidata.idv.control.DisplaySetting;
import ucar.unidata.idv.ui.SettingsTree;
import ucar.unidata.ui.Timeline;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.TwoFacedObject;
import ucar.unidata.view.geoloc.NavigatedDisplay;
import ucar.visad.Util;
import visad.DateTime;
import visad.Real;
import visad.georef.EarthLocation;

public class DataSelectionWidget {
    private IntegratedDataViewer idv;
    JComponent contents;
    private JComponent[] timesListInfo;
    JList timesList;
    JList membersList;
    JComponent timesComponent;
    JComponent selectionContainer;
    JComponent selectionTabContainer;
    private boolean doSettings = true;
    private SettingsTree settingsTree;
    private JTabbedPane selectionTab;
    private JPanel strideTab;
    private JCheckBox strideCbx;
    private JComponent strideComponent;
    private JComponent areaComponent;
    private JPanel areaTab;
    private JCheckBox allTimesButton;
    private JComboBox timeOptionLabelBox;
    private List allDateTimes;
    private GeoSelectionPanel geoSelectionPanel;
    private Object lastLevel;
    private List levels;
    private List<TwoFacedObject> members;
    private List levelsFromDisplay;
    private boolean defaultLevelToFirst = true;
    private boolean defaultMemberToAll = true;
    private JList levelsList;
    private JScrollPane levelsScroller;
    private JScrollPane membersScroller;
    private JComponent levelsTab;
    private JComponent membersTab;
    private DataSource lastDataSource;
    private boolean lastChoiceRequiresVolume = false;
    private DataChoice lastDataChoice;
    private String currentLbl;
    private List<DataSelectionComponent> dataSelectionComponents;
    private boolean doUseDisplay = true;
    private boolean chooserDoTimeMatching = false;
    public static final String USE_DEFAULTTIMES = "Use Default";
    public static final String USE_SELECTEDTIMES = "Use Selected";
    public static final String USE_DRIVERTIMES = "Match Time Driver";
    public static final String AS_DRIVERTIMES = "Set As Time Driver";
    private static final String[] timeSubsetOptionLabels = new String[]{"Use Default", "Use Selected", "Match Time Driver", "Set As Time Driver"};
    private Timeline timeline;
    private String timeOption = "Use Default";
    public String USE_DEFAULTREGION = "Use Default";
    private TwoFacedObject[] regionSubsetOptions = new TwoFacedObject[]{new TwoFacedObject((Object)"Use Default Region", "Use_Default_Area"), new TwoFacedObject((Object)"Select A Region", "Use_Selected_Area"), new TwoFacedObject((Object)"Match Display Region", "Match_Display_Area")};
    JComboBox regionOptionLabelBox;
    private String regionOption = this.USE_DEFAULTREGION;

    public DataSelectionWidget(IntegratedDataViewer idv) {
        this(idv, true);
    }

    public DataSelectionWidget(IntegratedDataViewer idv, boolean doSettings) {
        this.doSettings = doSettings;
        this.idv = idv;
        this.getContents();
    }

    public DataSelectionWidget(IntegratedDataViewer idv, boolean doSettings, boolean doUseDisplay) {
        this.doSettings = doSettings;
        this.idv = idv;
        this.doUseDisplay = doUseDisplay;
        this.getContents();
    }

    public JComponent getContents() {
        if (this.contents == null) {
            this.contents = this.doMakeContents();
        }
        return this.contents;
    }

    public void dataSourceChanged(DataSource dataSource) {
        if (dataSource == null) {
            this.setTimes(new ArrayList(), new ArrayList());
        } else {
            this.setTimes(dataSource.getAllDateTimes(), dataSource.getDateTimeSelection());
        }
    }

    public GeoSelection getGeoSelection() {
        if (this.geoSelectionPanel == null) {
            return null;
        }
        if (!this.geoSelectionPanel.getEnabled()) {
            return null;
        }
        return this.geoSelectionPanel.getGeoSelection();
    }

    protected Object[] getSelectedLevelRange() {
        int indexOffset;
        Object[] NO_LEVELS = new Object[]{};
        if (this.levelsTab == null || this.levelsTab.getParent() == null) {
            return NO_LEVELS;
        }
        int[] selected = this.levelsList.getSelectedIndices();
        if (selected.length == 0 || selected.length == 1 && selected[0] == 0 && this.levelsFromDisplay == null && this.lastDataSource != null && this.lastDataSource.canDoAllLevels()) {
            return NO_LEVELS;
        }
        int n = indexOffset = this.levelsFromDisplay == null && this.lastDataSource != null && this.lastDataSource.canDoAllLevels() ? 1 : 0;
        if (selected.length == 1) {
            this.lastLevel = this.levels.get(selected[0] - indexOffset);
            return new Object[]{this.lastLevel};
        }
        int first = -1;
        int last = -1;
        for (int i = 0; i < selected.length; ++i) {
            if (selected[i] == 0) continue;
            if (i == 0 || selected[i] < first) {
                first = selected[i];
            }
            if (i != 0 && selected[i] <= last) continue;
            last = selected[i];
        }
        if (first <= 0 || last <= 0) {
            return NO_LEVELS;
        }
        return new Object[]{this.levels.get(first - indexOffset), this.levels.get(last - indexOffset)};
    }

    protected void updateSettings(ControlDescriptor cd) {
        if (this.settingsTree == null) {
            this.settingsTree = new SettingsTree(this.idv);
        }
        if (this.settingsTree != null) {
            this.settingsTree.updateSettings(cd);
        }
    }

    protected void updateSelectionTab(DataChoice dataChoice) {
        if (dataChoice == null) {
            this.updateSelectionTab(null, dataChoice);
            return;
        }
        List sources = new ArrayList();
        dataChoice.getDataSources(sources);
        sources = Misc.makeUnique(sources);
        if (sources.size() == 1) {
            this.updateSelectionTab((DataSource)sources.get(0), dataChoice);
        } else {
            this.updateSelectionTab(null, dataChoice);
        }
    }

    protected boolean updateSelectionTab(DataSource dataSource, DataChoice dc) {
        TwoFacedObject o;
        this.lastDataChoice = dc;
        boolean newDataSource = false;
        if (this.lastDataSource != dataSource) {
            this.dataSourceChanged(dataSource);
            newDataSource = true;
        }
        this.lastDataSource = dataSource;
        if (dc != null) {
            Object cu;
            this.lastDataChoice.setProperty("Use_Display_Driver_Times", false);
            if (dataSource != null && (cu = dataSource.getProperty("Chooser_Do_Time_Matching")) != null) {
                this.chooserDoTimeMatching = (Boolean)cu;
                if (this.chooserDoTimeMatching) {
                    this.timeOptionLabelBox.setSelectedItem(USE_DRIVERTIMES);
                }
            }
        }
        if (this.selectionTab == null) {
            return newDataSource;
        }
        int idx = this.selectionTab.getSelectedIndex();
        if (idx >= 0) {
            this.currentLbl = this.selectionTab.getTitleAt(idx);
        }
        this.selectionTab.removeAll();
        this.dataSelectionComponents = dc != null && dataSource != null ? dataSource.getDataSelectionComponents(dc) : null;
        if (this.timesList.getModel().getSize() > 0) {
            this.selectionTab.add(this.timesComponent, "Times", 0);
        }
        if (dataSource == null) {
            if (dc != null) {
                this.addSettingsComponent();
            }
            this.checkSelectionTab();
            return newDataSource;
        }
        if (dc == null) {
            this.checkSelectionTab();
            return newDataSource;
        }
        this.members = (List)dc.getProperty("prop.gridmembers");
        if (this.members != null && this.members.size() > 1) {
            List dcMembers;
            if (this.membersList == null) {
                this.membersList = new JList();
                this.membersList.setSelectionMode(2);
                this.membersScroller = GuiUtils.makeScrollPane(this.membersList, 300, 100);
                this.membersTab = this.membersScroller;
            }
            Vector<TwoFacedObject> membersForGui = new Vector<TwoFacedObject>();
            if (this.levelsFromDisplay == null) {
                membersForGui.add(new TwoFacedObject((Object)"All Members", null));
            }
            for (int i = 0; i < this.members.size(); ++i) {
                o = this.members.get(i);
                membersForGui.add(o);
            }
            Object[] selectedMembers = this.membersList.getSelectedValues();
            if (!(selectedMembers != null && selectedMembers.length != 0 || (dcMembers = (List)dc.getProperty("prop.gridmembers")) == null || dcMembers.isEmpty())) {
                selectedMembers = dcMembers.toArray();
            }
            this.membersList.setListData(membersForGui);
            if (membersForGui.size() > 1) {
                if (this.defaultMemberToAll) {
                    this.membersList.setSelectedIndex(0);
                } else {
                    this.membersList.setSelectedIndex(1);
                }
            } else {
                this.membersList.setSelectedIndex(0);
            }
            this.selectionTab.add(this.membersTab, "Ensemble", 0);
        }
        if (dc instanceof DerivedDataChoice) {
            DerivedDataChoice ddc = (DerivedDataChoice)dc;
            List ll = ddc.getChoices();
            DataChoice cdc = (DataChoice)ll.get(0);
            if (cdc instanceof DerivedDataChoice) {
                DerivedDataChoice ddc0 = (DerivedDataChoice)cdc;
                List ll0 = ddc0.getChoices();
                cdc = (DataChoice)ll0.get(0);
            }
            this.members = (List)cdc.getProperty("prop.gridmembers");
            if (this.members != null && this.members.size() > 1) {
                List dcMembers;
                if (this.membersList == null) {
                    this.membersList = new JList();
                    this.membersList.setSelectionMode(2);
                    this.membersScroller = GuiUtils.makeScrollPane(this.membersList, 300, 100);
                    this.membersTab = this.membersScroller;
                }
                Vector<TwoFacedObject> membersForGui = new Vector<TwoFacedObject>();
                if (this.levelsFromDisplay == null) {
                    membersForGui.add(new TwoFacedObject((Object)"All Members", null));
                }
                for (int i = 0; i < this.members.size(); ++i) {
                    TwoFacedObject o2 = this.members.get(i);
                    membersForGui.add(o2);
                }
                Object[] selectedMembers = this.membersList.getSelectedValues();
                if (!(selectedMembers != null && selectedMembers.length != 0 || (dcMembers = (List)dc.getProperty("prop.gridmembers")) == null || dcMembers.isEmpty())) {
                    selectedMembers = dcMembers.toArray();
                }
                this.membersList.setListData(membersForGui);
                if (membersForGui.size() > 1) {
                    if (this.defaultMemberToAll) {
                        this.membersList.setSelectedIndex(0);
                    } else {
                        this.membersList.setSelectedIndex(1);
                    }
                } else {
                    this.membersList.setSelectedIndex(0);
                }
                this.selectionTab.add(this.membersTab, "Ensemble", 0);
            }
        }
        List list = this.levels = this.levelsFromDisplay != null ? this.levelsFromDisplay : dc.getAllLevels(new DataSelection(1));
        if (this.levels != null && this.levels.size() > 1) {
            List dcLevels;
            if (this.levelsList == null) {
                this.levelsList = new JList();
                this.levelsList.setSelectionMode(1);
                this.levelsList.setToolTipText("Shift-Click to select a range");
                this.levelsScroller = GuiUtils.makeScrollPane(this.levelsList, 300, 100);
                this.levelsTab = this.levelsScroller;
            }
            Vector<TwoFacedObject> levelsForGui = new Vector<TwoFacedObject>();
            if (this.levelsFromDisplay == null && dataSource.canDoAllLevels()) {
                levelsForGui.add(new TwoFacedObject((Object)"All Levels", null));
            }
            for (int i = 0; i < this.levels.size(); ++i) {
                o = this.levels.get(i);
                if (o instanceof Real) {
                    Real r = (Real)this.levels.get(i);
                    levelsForGui.add(Util.labeledReal(r, true));
                    continue;
                }
                levelsForGui.add(o);
            }
            Object[] selectedLevels = this.levelsList.getSelectedValues();
            if (!(selectedLevels != null && selectedLevels.length != 0 || (dcLevels = (List)dc.getProperty("default_levels")) == null || dcLevels.isEmpty())) {
                selectedLevels = dcLevels.toArray();
            }
            boolean thisChoiceRequiresVolume = false;
            DataChoice theDataChoice = dc;
            if (theDataChoice == null) {
                theDataChoice = this.lastDataChoice;
            }
            if (theDataChoice != null) {
                thisChoiceRequiresVolume = Misc.equals(theDataChoice.getProperty("requiresvolume"), "true");
            }
            this.levelsList.setListData(levelsForGui);
            ListSelectionModel lsm = this.levelsList.getSelectionModel();
            int previouslySelectedLevels = 0;
            for (int i = 0; i < selectedLevels.length; ++i) {
                int index = levelsForGui.indexOf(selectedLevels[i]);
                if (index < 0) continue;
                lsm.addSelectionInterval(index, index);
                ++previouslySelectedLevels;
            }
            if (thisChoiceRequiresVolume && thisChoiceRequiresVolume != this.lastChoiceRequiresVolume && previouslySelectedLevels == 1) {
                previouslySelectedLevels = 0;
            }
            if (previouslySelectedLevels == 0) {
                if (levelsForGui.size() > 1) {
                    if (this.defaultLevelToFirst && !thisChoiceRequiresVolume) {
                        this.levelsList.setSelectedIndex(1);
                    } else {
                        this.levelsList.setSelectedIndex(0);
                    }
                } else {
                    this.levelsList.setSelectedIndex(0);
                }
            }
            this.selectionTab.add((Component)this.levelsTab, "Level");
            this.lastChoiceRequiresVolume = thisChoiceRequiresVolume;
        }
        if (dataSource.canDoGeoSelection()) {
            if (this.strideTab == null) {
                this.strideTab = new JPanel(new BorderLayout());
            }
            if (this.areaTab == null) {
                this.areaTab = new JPanel(new BorderLayout());
            }
            this.strideTab.removeAll();
            this.areaTab.removeAll();
            GeoSelectionPanel oldPanel = this.geoSelectionPanel;
            this.geoSelectionPanel = ((DataSourceImpl)dataSource).doMakeGeoSelectionPanel(false);
            this.strideComponent = this.geoSelectionPanel.getStrideComponent();
            this.areaComponent = this.geoSelectionPanel.getAreaComponent();
            if (this.areaComponent != null) {
                this.areaComponent.setPreferredSize(new Dimension(200, 150));
                GuiUtils.enableTree(this.areaComponent, this.regionOption.equals("Use_Selected_Area"));
            }
            if (oldPanel != null) {
                this.geoSelectionPanel.initWith(oldPanel);
            }
            if (this.areaComponent != null) {
                boolean useDA;
                this.areaComponent.setPreferredSize(new Dimension(200, 150));
                Object dr = dataSource.getProperty("Match_Display_Area");
                if (dr != null && (useDA = ((Boolean)dr).booleanValue())) {
                    this.regionOptionLabelBox.setSelectedIndex(2);
                }
                GuiUtils.enableTree(this.areaComponent, this.regionOption.equals("Use_Selected_Area"));
                this.areaTab.add(GuiUtils.topCenter(GuiUtils.inset((Component)GuiUtils.right(this.regionOptionLabelBox), 0), this.areaComponent));
                this.selectionTab.add("Region", this.areaTab);
                boolean usePR = false;
                if (this.idv.getViewManager() instanceof MapViewManager) {
                    MapViewManager mvm = (MapViewManager)this.idv.getViewManager();
                    usePR = mvm.getUseProgressiveResolution();
                }
            }
            if (this.strideComponent != null) {
                GuiUtils.enableTree(this.strideComponent, !this.strideCbx.isSelected());
                this.strideTab.add(GuiUtils.top(GuiUtils.topCenter(GuiUtils.inset((Component)GuiUtils.right(this.strideCbx), new Insets(0, 0, 5, 0)), this.strideComponent)));
                this.selectionTab.add("Data Sampling", this.strideTab);
            }
        }
        if (this.dataSelectionComponents != null) {
            for (DataSelectionComponent comp : this.dataSelectionComponents) {
                if (comp == null) continue;
                this.selectionTab.addTab(comp.getName(), comp.getContents());
            }
        }
        this.addSettingsComponent();
        this.checkSelectionTab();
        if (this.currentLbl != null && (idx = this.selectionTab.indexOfTab(this.currentLbl)) >= 0) {
            this.selectionTab.setSelectedIndex(idx);
        }
        return newDataSource;
    }

    public DataSelection createDataSelection(boolean addLevels) {
        List selectedMembers;
        Object[] levelRange;
        GeoSelection geoSelection;
        DataSelection dataSelection = null;
        boolean isProgressiveResolution = false;
        if (this.getUseAllTimes() || this.chooserDoTimeMatching || this.timeOption.equals(USE_DRIVERTIMES)) {
            dataSelection = new DataSelection();
        } else {
            dataSelection = new DataSelection(this.getSelectedDateTimes());
            dataSelection.putProperty("As_Display_Driver_Times", this.timeOption.equals(AS_DRIVERTIMES));
        }
        dataSelection.putProperty("Use_Display_Driver_Times", this.timeOption.equals(USE_DRIVERTIMES) || this.chooserDoTimeMatching);
        String idx = (String)this.timeOptionLabelBox.getSelectedItem();
        if (idx.equals(USE_SELECTEDTIMES) && this.lastDataChoice.getProperty("Use DataChoice time subset") == null) {
            this.lastDataChoice.setProperty("Use DataChoice time subset", true);
        }
        if ((geoSelection = this.getGeoSelection()) != null) {
            if (this.strideCbx.isSelected()) {
                geoSelection.clearStride();
            }
            if (this.regionOption.equals("Use_Default_Area")) {
                geoSelection.setBoundingBox(null);
                geoSelection.setUseFullBounds(false);
                geoSelection.setUseViewBounds(false);
            }
        }
        if ((levelRange = this.getSelectedLevelRange()) != null && levelRange.length > 0 && (addLevels || levelRange.length == 2)) {
            if (levelRange.length == 1) {
                dataSelection.setLevel(levelRange[0]);
            } else {
                dataSelection.setLevelRange(levelRange[0], levelRange[1]);
            }
        }
        ViewManager vm = this.idv.getViewManager();
        NavigatedDisplay navDisplay = null;
        if (vm instanceof NavigatedViewManager) {
            navDisplay = (NavigatedDisplay)vm.getMaster();
        }
        if (this.dataSelectionComponents != null) {
            for (DataSelectionComponent comp : this.dataSelectionComponents) {
                if (comp == null) continue;
                comp.applyToDataSelection(dataSelection);
            }
        }
        if (this.dataSelectionComponents != null && this.dataSelectionComponents.size() == 2) {
            geoSelection = dataSelection.getGeoSelection();
            this.regionOption = dataSelection.getProperty("Region_Selection_Option", this.USE_DEFAULTREGION);
            if (this.regionOption.equals("Match_Display_Area") && navDisplay != null) {
                geoSelection.setUseViewBounds(true);
            } else {
                geoSelection.setUseViewBounds(false);
            }
        } else {
            if (geoSelection != null) {
                if (this.strideCbx.isSelected()) {
                    geoSelection.clearStride();
                }
                if (this.regionOption.equals("Use_Default_Area")) {
                    geoSelection.setBoundingBox(null);
                    geoSelection.setUseFullBounds(false);
                    geoSelection.setUseViewBounds(false);
                } else if (this.regionOption.equals("Match_Display_Area") && navDisplay != null) {
                    try {
                        vm.setProjectionFromData(false);
                        Rectangle sbox = navDisplay.getScreenBounds();
                        Rectangle2D.Double bbox = navDisplay.getLatLonBox();
                        geoSelection.setLatLonRect(bbox);
                        geoSelection.setUseViewBounds(true);
                        dataSelection.setGeoSelection(geoSelection);
                        EarthLocation el = navDisplay.screenToEarthLocation((int)(((RectangularShape)sbox).getWidth() / 2.0), (int)(((RectangularShape)sbox).getHeight() / 2.0));
                        LatLonPointImpl llpi = new LatLonPointImpl(el.getLatitude().getValue(), el.getLongitude().getValue());
                        dataSelection.putProperty("centerPosition", llpi);
                    }
                    catch (Exception sbox) {
                        // empty catch block
                    }
                }
            }
            dataSelection.setGeoSelection(geoSelection);
            dataSelection.putProperty("Use_Progressive_Resolution", this.getIsProgressiveResolution());
            dataSelection.putProperty("Region_Selection_Option", this.regionOption);
        }
        if (this.regionOption.equals(this.USE_DEFAULTREGION) && geoSelection != null) {
            geoSelection.setBoundingBox(null);
        }
        if (geoSelection != null && navDisplay != null) {
            Rectangle screenBoundRect = navDisplay.getScreenBounds();
            geoSelection.setScreenBound(screenBoundRect);
        }
        if ((selectedMembers = this.getSelectedMembers()) != null && selectedMembers.size() > 0) {
            dataSelection.putProperty("prop.gridmembers", selectedMembers);
        }
        return dataSelection;
    }

    public boolean getIsProgressiveResolution() {
        boolean usePR = false;
        if (this.idv.getViewManager() instanceof MapViewManager) {
            MapViewManager mvm = (MapViewManager)this.idv.getViewManager();
            usePR = mvm.getUseProgressiveResolution();
        }
        return usePR;
    }

    public boolean okToCreateTheDisplay(boolean addLevels) {
        if (this.lastChoiceRequiresVolume) {
            boolean inError = false;
            if (this.levelsTab == null || this.levelsTab.getParent() == null) {
                return true;
            }
            int[] selected = this.levelsList.getSelectedIndices();
            if (selected.length == 0) {
                inError = true;
            } else if (selected.length == 1 && selected[0] != 0) {
                inError = true;
            }
            if (inError) {
                LogUtil.userErrorMessage(new JLabel("<html>The selected field requires a 3D volume of data.<br>Please select \"All Levels\" or a range of 2 or more levels</html>"));
                return false;
            }
        }
        return true;
    }

    private void checkSelectionTab() {
        boolean changed = false;
        if (this.selectionTab.getTabCount() > 0 && this.selectionTabContainer.getParent() == null) {
            this.selectionContainer.add(this.selectionTabContainer);
            changed = true;
        } else if (this.selectionTab.getTabCount() == 0 && this.selectionTabContainer.getParent() != null) {
            this.selectionContainer.removeAll();
            changed = true;
        }
        if (changed) {
            this.selectionContainer.validate();
            this.selectionContainer.repaint();
        }
    }

    protected List getSelectedSettings() {
        if (this.settingsTree == null) {
            return null;
        }
        return this.settingsTree.getSelectedSettings();
    }

    private void addSettingsComponent() {
        if (!this.doSettings) {
            return;
        }
        List<DisplaySetting> settings = this.idv.getResourceManager().getDisplaySettings();
        if (settings == null || settings.size() == 0) {
            return;
        }
        if (this.settingsTree == null) {
            this.settingsTree = new SettingsTree(this.idv);
        }
        this.selectionTab.add("Settings", this.settingsTree.getContents());
    }

    private JComponent doMakeContents() {
        this.regionOptionLabelBox = new JComboBox();
        this.regionOptionLabelBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                TwoFacedObject selectedObj = (TwoFacedObject)DataSelectionWidget.this.regionOptionLabelBox.getSelectedItem();
                DataSelectionWidget.this.regionOption = (String)selectedObj.getId();
                if (DataSelectionWidget.this.areaComponent != null) {
                    GuiUtils.enableTree(DataSelectionWidget.this.areaComponent, DataSelectionWidget.this.regionOption.equals("Use_Selected_Area"));
                }
                if (DataSelectionWidget.this.areaComponent != null && !DataSelectionWidget.this.regionOption.equals("Use_Selected_Area")) {
                    DataSelectionWidget.this.geoSelectionPanel.reSetBoundsFromFields();
                }
            }
        });
        GuiUtils.enableTree(this.regionOptionLabelBox, true);
        List regionOptionNames = Misc.toList(this.regionSubsetOptions);
        GuiUtils.setListData(this.regionOptionLabelBox, regionOptionNames);
        GuiUtils.enableTree(this.regionOptionLabelBox, true);
        this.strideCbx = new JCheckBox(USE_DEFAULTTIMES, true);
        this.strideCbx.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (DataSelectionWidget.this.strideComponent != null) {
                    GuiUtils.enableTree(DataSelectionWidget.this.strideComponent, !DataSelectionWidget.this.strideCbx.isSelected());
                }
            }
        });
        this.timesComponent = this.getTimesList();
        this.selectionTab = new JTabbedPane();
        this.selectionTab.setBorder(null);
        this.selectionTabContainer = new JPanel(new BorderLayout());
        this.selectionTabContainer.add(this.selectionTab);
        this.selectionContainer = new JPanel(new BorderLayout());
        this.selectionContainer.setPreferredSize(new Dimension(200, 150));
        Font font = this.selectionTab.getFont();
        font = font.deriveFont((float)font.getSize() - 2.0f).deriveFont(2).deriveFont(1);
        this.selectionTab.setFont(font);
        this.selectionTab.add("Times", this.timesComponent);
        return this.selectionContainer;
    }

    public List getAllDateTimes() {
        return this.allDateTimes;
    }

    public List getSelectedDateTimes() {
        if (this.idv.getUseTimeDriver() ? this.timeOptionLabelBox == null : this.allTimesButton == null) {
            return null;
        }
        if (this.getUseAllTimes()) {
            return null;
        }
        return this.getSelectedDateTimesInList();
    }

    public List getSelectedMembers() {
        if (this.membersList == null) {
            return null;
        }
        List selected = Misc.toList(this.membersList.getSelectedValues());
        int ssize = selected.size();
        for (int i = 0; i < ssize; ++i) {
            TwoFacedObject to = (TwoFacedObject)selected.get(i);
            if (to.getLabel() != "All Members") continue;
            return Misc.getIndexList(this.members, this.members);
        }
        return Misc.getIndexList(selected, this.members);
    }

    private List getSelectedDateTimesInList() {
        if (this.timesList == null) {
            return new ArrayList();
        }
        List selected = Misc.toList(this.timesList.getSelectedValues());
        return Misc.getIndexList(selected, this.allDateTimes);
    }

    public boolean getUseAllTimes() {
        if (this.idv.getUseTimeDriver()) {
            if (this.timeOptionLabelBox == null) {
                return true;
            }
            return this.timeOptionLabelBox.getSelectedItem().equals(USE_DEFAULTTIMES);
        }
        if (this.allTimesButton == null) {
            return true;
        }
        return this.allTimesButton.isSelected();
    }

    public void setTimes(List all, List selected) {
        if (!this.getUseAllTimes() && !Misc.equals(this.timeOption, USE_DRIVERTIMES) && Misc.equals(this.allDateTimes, all)) {
            selected = this.getSelectedDateTimesInList();
        }
        if (this.idv.getUseTimeDriver()) {
            String idx;
            DataSelectionWidget.setTimes(this.timesList, this.timeOptionLabelBox, all, selected);
            if (all != null) {
                this.allDateTimes = new ArrayList(all);
            }
            if ((idx = (String)this.timeOptionLabelBox.getSelectedItem()).equals(USE_SELECTEDTIMES)) {
                this.timesList.setEnabled(true);
            } else {
                this.timesList.setEnabled(false);
            }
        } else {
            DataSelectionWidget.setTimes(this.timesList, this.allTimesButton, all, selected);
            if (all != null) {
                this.allDateTimes = new ArrayList(all);
            }
            this.allTimesButton.setSelected(this.allTimesButton.isSelected());
            this.timesList.setEnabled(!this.allTimesButton.isSelected());
        }
    }

    public void setUseAllTimes(boolean useAllTimes) {
        if (this.idv.getUseTimeDriver()) {
            if (this.timeOptionLabelBox != null) {
                if (useAllTimes) {
                    this.timeOptionLabelBox.setSelectedItem(USE_DEFAULTTIMES);
                    this.timesList.setEnabled(false);
                } else {
                    this.timeOptionLabelBox.setSelectedItem(USE_SELECTEDTIMES);
                    this.timesList.setEnabled(true);
                }
            } else if (this.allTimesButton != null) {
                this.allTimesButton.setSelected(useAllTimes);
                this.timesList.setEnabled(!this.allTimesButton.isSelected());
            }
        }
    }

    public JComponent getTimesList() {
        return this.getTimesList(USE_DEFAULTTIMES);
    }

    public JComponent getTimesList(String cbxLabel) {
        if (this.timesListInfo == null) {
            this.timesListInfo = this.makeTimesListAndPanel(cbxLabel, null);
            this.timesList = (JList)this.timesListInfo[0];
            if (this.idv.getUseTimeDriver()) {
                this.timeOptionLabelBox = (JComboBox)this.timesListInfo[1];
            } else {
                this.allTimesButton = (JCheckBox)this.timesListInfo[1];
            }
        }
        return this.timesListInfo[2];
    }

    private static void setTimes(JList timesList, JCheckBox allTimesButton, List all, List selected) {
        if (DataSourceImpl.holdsIndices(selected = DataSourceImpl.getDateTimes(selected, all))) {
            selected = Misc.getValuesFromIndices(selected, all);
        }
        if (all == null) {
            return;
        }
        List sortedAllDateTimes = Misc.sort(new HashSet(all));
        timesList.setListData(new Vector(sortedAllDateTimes));
        allTimesButton.setEnabled(sortedAllDateTimes.size() > 0);
        boolean allSelected = false;
        if (selected != null && selected.size() > 0) {
            allSelected = sortedAllDateTimes.size() == selected.size();
            for (int i = 0; i < selected.size(); ++i) {
                int idx = sortedAllDateTimes.indexOf(selected.get(i));
                if (idx < 0) continue;
                timesList.getSelectionModel().addSelectionInterval(idx, idx);
            }
        } else {
            allSelected = true;
        }
        if (allSelected) {
            timesList.getSelectionModel().addSelectionInterval(0, timesList.getModel().getSize() - 1);
        }
        if (selected == null || selected.size() == 0) {
            // empty if block
        }
        timesList.setEnabled(!allTimesButton.isSelected());
    }

    private static void setTimes(JList timesList, JComboBox timeOptionLabelBox, List all, List selected) {
        if (DataSourceImpl.holdsIndices(selected = DataSourceImpl.getDateTimes(selected, all))) {
            selected = Misc.getValuesFromIndices(selected, all);
        }
        if (all == null) {
            return;
        }
        List sortedAllDateTimes = Misc.sort(new HashSet(all));
        timesList.setListData(new Vector(sortedAllDateTimes));
        timeOptionLabelBox.setEnabled(sortedAllDateTimes.size() > 0);
        boolean allSelected = false;
        if (selected != null && selected.size() > 0) {
            allSelected = sortedAllDateTimes.size() == selected.size();
            for (int i = 0; i < selected.size(); ++i) {
                int idx = sortedAllDateTimes.indexOf(selected.get(i));
                if (idx < 0) continue;
                timesList.getSelectionModel().addSelectionInterval(idx, idx);
            }
        } else {
            allSelected = true;
        }
        if (allSelected) {
            timesList.getSelectionModel().addSelectionInterval(0, timesList.getModel().getSize() - 1);
        }
        if (selected == null || selected.size() == 0) {
            // empty if block
        }
        String idx = (String)timeOptionLabelBox.getSelectedItem();
        timesList.setEnabled(idx.equals(USE_DEFAULTTIMES));
    }

    private JComponent[] makeTimesListAndPanel(String cbxLabel, JComponent extra) {
        final JComboBox timeOptionLabelBox = new JComboBox();
        final JList timesList = new JList();
        timesList.setBorder(null);
        TimesChooser.addTimeSelectionListener(timesList, this.timeline);
        timesList.setToolTipText("Right click to show selection menu");
        timesList.setSelectionMode(2);
        final JCheckBox allTimesButton = new JCheckBox(cbxLabel, true);
        allTimesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                timesList.setEnabled(!allTimesButton.isSelected());
            }
        });
        timeOptionLabelBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                String selectedObj = (String)timeOptionLabelBox.getSelectedItem();
                DataSelectionWidget.this.setTimeOptions(selectedObj);
                if (!selectedObj.equals(DataSelectionWidget.USE_DRIVERTIMES)) {
                    DataSelectionWidget.this.chooserDoTimeMatching = false;
                } else if (!DataSelectionWidget.this.checkActiveViewWithDriver()) {
                    timeOptionLabelBox.setSelectedItem(DataSelectionWidget.USE_DEFAULTTIMES);
                }
            }
        });
        GuiUtils.enableTree(timeOptionLabelBox, true);
        List timeOptionNames = Misc.toList(timeSubsetOptionLabels);
        if (this.idv.getUseTimeDriver() && !this.doUseDisplay) {
            timeOptionNames.remove(3);
            timeOptionNames.remove(2);
        }
        GuiUtils.setListData(timeOptionLabelBox, timeOptionNames);
        JPanel top = this.idv.getUseTimeDriver() ? (extra != null ? GuiUtils.leftRight(extra, timeOptionLabelBox) : GuiUtils.right(timeOptionLabelBox)) : (extra != null ? GuiUtils.leftRight(extra, allTimesButton) : GuiUtils.right(allTimesButton));
        JScrollPane scroller = GuiUtils.makeScrollPane(timesList, 300, 100);
        if (this.idv.getUseTimeDriver()) {
            return new JComponent[]{timesList, timeOptionLabelBox, GuiUtils.topCenter(top, scroller)};
        }
        return new JComponent[]{timesList, allTimesButton, GuiUtils.topCenter(top, scroller)};
    }

    public void setTimeOptions(String selectedObject) {
        if (this.timesList == null) {
            return;
        }
        this.timeOption = selectedObject;
        switch (selectedObject) {
            case "Use Default": {
                this.timesList.setVisible(true);
                this.timesList.setEnabled(false);
                if (this.lastDataChoice == null) break;
                this.lastDataChoice.setProperty("Use DataChoice time subset", false);
                break;
            }
            case "Use Selected": {
                this.timesList.setVisible(true);
                this.timesList.setEnabled(true);
                this.chooserDoTimeMatching = false;
                if (this.lastDataChoice == null) break;
                this.lastDataChoice.setProperty("Use DataChoice time subset", true);
                break;
            }
            case "Match Time Driver": {
                this.timesList.setVisible(false);
                this.timesList.setEnabled(false);
                if (this.lastDataChoice == null) break;
                this.lastDataChoice.setProperty("Use_Display_Driver_Times", true);
                this.lastDataChoice.setProperty("Use DataChoice time subset", false);
                break;
            }
            case "Set As Time Driver": {
                this.timesList.setVisible(true);
                this.timesList.setEnabled(true);
                this.chooserDoTimeMatching = false;
                if (this.lastDataChoice == null) break;
                this.lastDataChoice.setProperty("As_Display_Driver_Times", true);
                this.lastDataChoice.setProperty("Use DataChoice time subset", false);
            }
        }
    }

    protected boolean checkActiveViewWithDriver() {
        List<ViewManager> vms = this.idv.getVMManager().getViewManagers();
        int size = vms.size();
        if (size == 0) {
            return true;
        }
        boolean isBundle = this.idv.getStateManager().isLoadingXml();
        if (isBundle) {
            return true;
        }
        ViewManager vm0 = this.idv.getVMManager().getLastActiveViewManager();
        List<DateTime> tdt = null;
        try {
            tdt = vm0.getTimeDriverTimes();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (tdt != null) {
            return true;
        }
        LogUtil.userErrorMessage(new JLabel("<html>Error: there is no time driver in the current active view window, please select or set the view window with time driver! </html>"));
        return false;
    }

    public String getTimeOption() {
        return this.timeOption;
    }

    public void setLevelsFromDisplay(List levels) {
        if (!Misc.equals(this.levelsFromDisplay, levels)) {
            this.levelsFromDisplay = levels;
            this.updateSelectionTab(this.lastDataSource, this.lastDataChoice);
        }
    }

    public void setDefaultLevelToFirst(boolean value) {
        this.defaultLevelToFirst = value;
    }

    public boolean getDefaultLevelToFirst() {
        return this.defaultLevelToFirst;
    }

    public void setDefaultMemberToAll(boolean value) {
        this.defaultMemberToAll = value;
    }

    public boolean getDefaultMemberToAll() {
        return this.defaultMemberToAll;
    }
}

