/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataSource;
import ucar.unidata.idv.ControlDescriptor;
import ucar.unidata.idv.IntegratedDataViewer;
import ucar.unidata.idv.ui.DataSelectionWidget;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.Misc;
import ucar.unidata.util.StringUtil;

public class DataControlDialog
implements ActionListener {
    private IntegratedDataViewer idv;
    private JDialog dialog;
    JComponent contents;
    private boolean horizontalOrientation = false;
    List createBtns = new ArrayList();
    private Object ENABLE_MUTEX = new Object();
    JLabel label;
    JTree controlTree;
    private Object CONTROLTREE_MUTEX;
    DefaultMutableTreeNode controlTreeRoot;
    DefaultTreeModel controlTreeModel;
    private Hashtable cdToNode = new Hashtable();
    private ControlDescriptor firstCd;
    JComponent displayScroller;
    private DataSelectionWidget dataSelectionWidget;
    DataSource dataSource;
    DataChoice dataChoice;
    private boolean inOwnWindow = true;

    public DataControlDialog(IntegratedDataViewer idv, boolean inOwnWindow, boolean horizontalOrientation) {
        this.inOwnWindow = inOwnWindow;
        this.horizontalOrientation = horizontalOrientation;
        this.init(idv, null, 50, 50);
    }

    public DataControlDialog(IntegratedDataViewer idv, DataChoice dataChoice, int x, int y) {
        this.init(idv, dataChoice, x, y);
    }

    private void init(IntegratedDataViewer idv, DataChoice dataChoice, int windowX, int windowY) {
        this.idv = idv;
        this.dataChoice = dataChoice;
        this.contents = this.doMakeDataChoiceDialog(dataChoice);
        if (this.inOwnWindow) {
            this.doMakeWindow(GuiUtils.centerBottom(this.contents, GuiUtils.makeApplyOkCancelButtons(this)), windowX, windowY, "Select Display");
        }
    }

    public void addCreateButton(JButton b) {
        this.createBtns.add(b);
        b.setEnabled(this.getSelectedControl() != null);
    }

    public JComponent getContents() {
        return this.contents;
    }

    public void setCursor(Cursor cursor) {
        this.contents.setCursor(cursor);
    }

    public void setDataSource(DataSource ds) {
        this.dataSource = ds;
    }

    public void dataSourceChanged(DataSource dataSource) {
        if (this.dataSource == null) {
            this.setDataChoice(this.dataChoice);
            return;
        }
        if (this.dataSource != dataSource) {
            return;
        }
        this.dataSelectionWidget.dataSourceChanged(dataSource);
    }

    protected ControlDescriptor getSelectedControl() {
        if (this.controlTree == null) {
            return null;
        }
        List l = this.getSelectedControlsFromTree();
        if (l.size() > 0) {
            return (ControlDescriptor)l.get(0);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getSelectedControlsFromTree() {
        TreePath[] paths;
        Object object = this.CONTROLTREE_MUTEX;
        synchronized (object) {
            paths = this.controlTree.getSelectionModel().getSelectionPaths();
        }
        ArrayList<Object> descriptors = new ArrayList<Object>();
        if (paths == null) {
            return descriptors;
        }
        for (int i = 0; i < paths.length; ++i) {
            Object object2;
            Object last = paths[i].getLastPathComponent();
            if (last == null || !((object2 = ((DefaultMutableTreeNode)last).getUserObject()) instanceof ControlDescriptor)) continue;
            descriptors.add(object2);
        }
        return descriptors;
    }

    public Object[] getSelectedControls() {
        return this.getSelectedControlsFromTree().toArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setControlList(Vector v) {
        Object object = this.CONTROLTREE_MUTEX;
        synchronized (object) {
            DefaultMutableTreeNode node;
            int i;
            ArrayList<Object> openCds = new ArrayList<Object>();
            Enumeration<TreePath> paths = this.controlTree.getExpandedDescendants(new TreePath(this.controlTreeRoot.getPath()));
            if (paths != null) {
                while (paths.hasMoreElements()) {
                    TreePath path = paths.nextElement();
                    DefaultMutableTreeNode last = (DefaultMutableTreeNode)path.getLastPathComponent();
                    Enumeration<TreeNode> nodeChildren = last.children();
                    while (nodeChildren.hasMoreElements()) {
                        DefaultMutableTreeNode child = (DefaultMutableTreeNode)nodeChildren.nextElement();
                        if (!(child.getUserObject() instanceof ControlDescriptor)) continue;
                        openCds.add(child.getUserObject());
                    }
                }
            }
            this.cdToNode = new Hashtable();
            this.firstCd = null;
            this.controlTreeRoot.removeAllChildren();
            ArrayList<DefaultMutableTreeNode> leafNodes = new ArrayList<DefaultMutableTreeNode>();
            Hashtable<String, DefaultMutableTreeNode> nodes = new Hashtable<String, DefaultMutableTreeNode>();
            for (i = 0; i < v.size(); ++i) {
                ControlDescriptor cd = (ControlDescriptor)v.get(i);
                String displayCategory = cd.getDisplayCategory();
                DefaultMutableTreeNode parentNode = this.controlTreeRoot;
                String catSoFar = "";
                List<String> cats = StringUtil.split(displayCategory, "/", true, true);
                for (int catIdx = 0; catIdx < cats.size(); ++catIdx) {
                    String subCat = cats.get(catIdx);
                    DefaultMutableTreeNode node2 = (DefaultMutableTreeNode)nodes.get(catSoFar = catSoFar + "/" + subCat);
                    if (node2 == null) {
                        node2 = new DefaultMutableTreeNode(subCat);
                        parentNode.add(node2);
                        nodes.put(catSoFar, node2);
                    }
                    parentNode = node2;
                }
                if (this.firstCd == null) {
                    this.firstCd = cd;
                }
                DefaultMutableTreeNode node3 = new DefaultMutableTreeNode(cd);
                leafNodes.add(node3);
                this.cdToNode.put(cd, node3);
                parentNode.add(node3);
            }
            for (i = 0; i < leafNodes.size(); ++i) {
                DefaultMutableTreeNode grandParent;
                node = (DefaultMutableTreeNode)leafNodes.get(i);
                DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
                if (parent == this.controlTreeRoot || parent.getChildCount() != 1 || (grandParent = (DefaultMutableTreeNode)parent.getParent()) != this.controlTreeRoot && grandParent.getChildCount() != 1) continue;
                node.removeFromParent();
                grandParent.add(node);
                parent.removeFromParent();
            }
            this.controlTreeModel.nodeStructureChanged(this.controlTreeRoot);
            for (i = 0; i < openCds.size(); ++i) {
                node = (DefaultMutableTreeNode)this.cdToNode.get(openCds.get(i));
                if (node == null) continue;
                TreePath path = new TreePath(this.controlTreeModel.getPathToRoot(node));
                this.controlTree.addSelectionPath(path);
                this.controlTree.expandPath(path);
            }
            this.controlTree.clearSelection();
            this.checkSettings();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSelectedControl(ControlDescriptor cd) {
        Object object = this.CONTROLTREE_MUTEX;
        synchronized (object) {
            if (cd == null) {
                cd = this.firstCd;
            }
            if (cd == null) {
                return;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.cdToNode.get(cd);
            if (node == null) {
                return;
            }
            TreePath path = new TreePath(this.controlTreeModel.getPathToRoot(node));
            this.controlTree.addSelectionPath(path);
            this.controlTree.expandPath(path);
        }
    }

    private void showControlHelp() {
        ControlDescriptor selected = this.getSelectedControl();
        if (selected == null) {
            this.idv.getIdvUIManager().showHelp("idv.data.fieldselector");
        } else {
            selected.showHelp();
        }
    }

    public void displayTemplatesChanged() {
        this.setDataChoice(this.dataChoice);
    }

    public synchronized void setDataChoice(DataChoice dc) {
        this.dataChoice = dc;
        if (this.dataChoice == null) {
            this.setControlList(new Vector());
            this.dataSelectionWidget.setTimes(new ArrayList(), new ArrayList());
            this.dataSelectionWidget.updateSelectionTab(null, null);
            return;
        }
        ControlDescriptor selected = this.getSelectedControl();
        Vector newList = new Vector(ControlDescriptor.getApplicableControlDescriptors(this.dataChoice.getCategories(), this.idv.getControlDescriptors(true)));
        this.setControlList(newList);
        if (!newList.contains(selected)) {
            selected = null;
        }
        this.setSelectedControl(selected);
        if (this.label != null) {
            this.label.setText("Choose a display for data: " + this.dataChoice);
        }
        List sources = new ArrayList();
        this.dataChoice.getDataSources(sources);
        sources = Misc.makeUnique(sources);
        List selectedTimes = this.dataChoice.getSelectedDateTimes();
        List times = this.dataChoice.getAllDateTimes();
        this.dataSelectionWidget.setTimes(times, selectedTimes);
        if (sources.size() == 1) {
            DataSource dataSource = (DataSource)sources.get(0);
            if (this.dataSelectionWidget.updateSelectionTab(dataSource, dc)) {
                this.dataSelectionWidget.setTimes(times, selectedTimes);
            }
        } else {
            this.dataSelectionWidget.updateSelectionTab(null, dc);
        }
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public DataChoice getDataChoice() {
        return this.dataChoice;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void controlTreeChanged() {
        Object[] cd = this.getSelectedControls();
        Object object = this.ENABLE_MUTEX;
        synchronized (object) {
            for (int i = 0; i < this.createBtns.size(); ++i) {
                ((JButton)this.createBtns.get(i)).setEnabled(cd.length > 0);
            }
        }
        if (this.dataSelectionWidget != null) {
            List levels = null;
            if (cd.length == 1) {
                levels = ((ControlDescriptor)cd[0]).getLevels();
            }
            this.dataSelectionWidget.setLevelsFromDisplay(levels);
        }
    }

    public JComponent doMakeDataChoiceDialog(DataChoice dataChoice) {
        this.controlTree = new ControlTree();
        this.CONTROLTREE_MUTEX = this.controlTree.getTreeLock();
        this.controlTreeRoot = new DefaultMutableTreeNode("Displays");
        this.controlTreeModel = new DefaultTreeModel(this.controlTreeRoot);
        this.controlTree.setModel(this.controlTreeModel);
        DefaultTreeCellRenderer renderer = (DefaultTreeCellRenderer)this.controlTree.getCellRenderer();
        renderer.setOpenIcon(null);
        renderer.setClosedIcon(null);
        renderer.setLeafIcon(null);
        Font f = renderer.getFont();
        this.controlTree.setRowHeight(18);
        this.controlTree.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 112) {
                    DataControlDialog.this.showControlHelp();
                }
            }
        });
        this.controlTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                DataControlDialog.this.checkSettings();
                Misc.run(new Runnable(){

                    @Override
                    public void run() {
                        DataControlDialog.this.controlTreeChanged();
                    }
                });
            }
        });
        this.controlTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    DataControlDialog.this.doOk();
                }
                if (SwingUtilities.isRightMouseButton(e)) {
                    return;
                }
            }
        });
        this.displayScroller = GuiUtils.makeScrollPane(this.controlTree, 200, 150);
        this.displayScroller.setBorder(null);
        this.dataSelectionWidget = new DataSelectionWidget(this.idv);
        if (this.horizontalOrientation) {
            this.displayScroller.setPreferredSize(new Dimension(150, 35));
            this.contents = GuiUtils.hsplit(this.dataSelectionWidget.getContents(), this.displayScroller);
        } else {
            this.displayScroller.setPreferredSize(new Dimension(200, 150));
            this.dataSelectionWidget.getContents().setPreferredSize(new Dimension(200, 200));
            this.contents = GuiUtils.vsplit(this.displayScroller, this.dataSelectionWidget.getContents(), 150, 0.5);
        }
        if (this.inOwnWindow) {
            this.label = new JLabel("                 ");
            this.contents = GuiUtils.topCenter(GuiUtils.inset((Component)this.label, 5), this.contents);
        }
        this.setDataChoice(dataChoice);
        return this.contents;
    }

    private void checkSettings() {
        Object[] cd = this.getSelectedControls();
        this.dataSelectionWidget.updateSettings((ControlDescriptor)(cd.length > 0 ? cd[0] : null));
    }

    public DataSelectionWidget getDataSelectionWidget() {
        return this.dataSelectionWidget;
    }

    protected void doMakeWindow(JComponent contents, int x, int y) {
        this.doMakeWindow(contents, x, y, "Select Display");
    }

    private void doMakeWindow(JComponent contents, int x, int y, String title) {
        this.dialog = GuiUtils.createDialog(title, true);
        Container cpane = this.dialog.getContentPane();
        cpane.setLayout(new BorderLayout());
        cpane.add("Center", GuiUtils.inset((Component)contents, 5));
        this.dialog.setLocation(x, y);
        this.dialog.pack();
        this.dialog.setVisible(true);
    }

    public void dispose() {
        if (this.dialog != null) {
            this.dialog.dispose();
        }
        this.idv.getIdvUIManager().removeDCD(this);
    }

    public void doClose() {
        if (!this.inOwnWindow) {
            return;
        }
        if (this.dialog != null) {
            this.dialog.setVisible(false);
        }
        this.dispose();
        this.idv = null;
        this.dataSource = null;
        this.dataChoice = null;
    }

    public void doOk() {
        this.doApply();
        if (this.inOwnWindow) {
            this.doClose();
        }
    }

    private void doApply() {
        this.idv.getIdvUIManager().processDialog(this);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getActionCommand().equals(GuiUtils.CMD_OK)) {
            this.doOk();
        } else if (event.getActionCommand().equals(GuiUtils.CMD_APPLY)) {
            this.doApply();
        } else if (event.getActionCommand().equals(GuiUtils.CMD_CANCEL)) {
            this.doClose();
        }
    }

    private class ControlTree
    extends JTree {
        private String defaultToolTip = "Click here and press F1 for help";

        public ControlTree() {
            this.setRootVisible(false);
            this.setShowsRootHandles(true);
            this.setToggleClickCount(1);
            this.setToolTipText(this.defaultToolTip);
            DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer(){

                @Override
                public Component getTreeCellRendererComponent(JTree theTree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                    super.getTreeCellRendererComponent(theTree, value, sel, expanded, leaf, row, hasFocus);
                    if (!(value instanceof DefaultMutableTreeNode)) {
                        return this;
                    }
                    Object object = ((DefaultMutableTreeNode)value).getUserObject();
                    if (!(object instanceof ControlDescriptor)) {
                        return this;
                    }
                    ControlDescriptor cd = (ControlDescriptor)object;
                    if (cd.getIcon() != null) {
                        ImageIcon imageIcon = GuiUtils.getImageIcon(cd.getIcon(), false);
                    }
                    return this;
                }
            };
            this.setCellRenderer(renderer);
        }

        @Override
        public String getToolTipText(MouseEvent event) {
            if (DataControlDialog.this.getSelectedControl() == null) {
                return this.defaultToolTip;
            }
            return this.defaultToolTip + " on this display type";
        }

        private String findToolTipText(MouseEvent event) {
            TreePath path = this.getPathForLocation(event.getX(), event.getY());
            if (path == null) {
                return this.defaultToolTip;
            }
            Object last = path.getLastPathComponent();
            if (last == null) {
                return this.defaultToolTip;
            }
            if (!(last instanceof DefaultMutableTreeNode)) {
                return this.defaultToolTip;
            }
            Object object = ((DefaultMutableTreeNode)last).getUserObject();
            if (!(object instanceof ControlDescriptor)) {
                return this.defaultToolTip;
            }
            ControlDescriptor cd = (ControlDescriptor)object;
            return cd.getToolTipText();
        }
    }
}

