/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;
import ucar.unidata.idv.DisplayControl;
import ucar.unidata.idv.NavigatedViewManager;
import ucar.unidata.idv.control.ReadoutInfo;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.Misc;
import ucar.unidata.util.StringUtil;
import ucar.visad.display.Animation;
import visad.Real;
import visad.VisADException;
import visad.georef.EarthLocation;
import visad.georef.EarthLocationTuple;

public class CursorReadoutWindow {
    NavigatedViewManager vm;
    protected JWindow window;
    protected JLabel label;
    protected int windowWidth = 0;
    private EarthLocation lastEarthLocation;
    private boolean ignoreMissing = true;

    public CursorReadoutWindow(NavigatedViewManager vm) {
        this(vm, true);
    }

    public CursorReadoutWindow(NavigatedViewManager vm, boolean ignoreMissing) {
        this.vm = vm;
        this.ignoreMissing = ignoreMissing;
        this.label = GuiUtils.getFixedWidthLabel("");
    }

    public void handleMouseReleased(MouseEvent e) {
        if (this.window != null) {
            this.window.dispose();
            this.window = null;
            this.windowWidth = -1;
        }
    }

    private void setWindowLocation() {
        int top;
        int bottom;
        int right;
        JComponent contents = (JComponent)this.vm.getContents();
        Rectangle b = contents.bounds();
        Point loc = contents.getLocationOnScreen();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int left = loc.x;
        if (left < 0) {
            left = 0;
        }
        if ((right = left + this.window.getBounds().width) > screenSize.width) {
            left += screenSize.width - right;
        }
        if ((bottom = (top = loc.y + contents.bounds().height) + this.window.getBounds().height) > screenSize.height) {
            top += screenSize.height - bottom - 10;
        }
        this.window.setLocation(left, top);
    }

    public void handleMousePressedOrDragged(MouseEvent e) throws RemoteException, VisADException {
        if (this.window == null) {
            JComponent contents = (JComponent)this.vm.getContents();
            Window parent = GuiUtils.getWindow(contents);
            this.window = new JWindow(parent);
            this.window.pack();
            this.setWindowLocation();
            this.window.setVisible(true);
        }
        double[] box = this.vm.getNavigatedDisplay().getSpatialCoordinatesFromScreen(e.getX(), e.getY());
        this.lastEarthLocation = this.vm.getNavigatedDisplay().getEarthLocation(box[0], box[1], box[2], true);
        if (this.lastEarthLocation.getLongitude().getValue() < -180.0 || this.lastEarthLocation.getLongitude().getValue() > 180.0) {
            this.lastEarthLocation = new EarthLocationTuple(this.lastEarthLocation.getLatitude().getValue(), Misc.normalizeLongitude(this.lastEarthLocation.getLongitude().getValue()), this.lastEarthLocation.getAltitude().getValue());
        }
        this.updateReadout();
    }

    public void updateReadout() {
        if (this.lastEarthLocation == null || this.window == null) {
            return;
        }
        String readout = this.getReadout(this.lastEarthLocation, true, false, new ArrayList<ReadoutInfo>());
        if (readout == null) {
            readout = "";
        }
        String theReadout = readout;
        GuiUtils.invokeInSwingThread(() -> {
            this.label.setText(theReadout);
            this.window.getContentPane().removeAll();
            JPanel wrapper = GuiUtils.inset((Component)this.label, new Insets(2, 5, 1, 5));
            wrapper.setBorder(BorderFactory.createBevelBorder(0));
            this.window.getContentPane().add(wrapper);
            this.window.pack();
            this.setWindowLocation();
            this.window.toFront();
        });
    }

    public String getReadout(EarthLocation earthLocation, boolean showDisplays, boolean showAlt, List<ReadoutInfo> samples) {
        if (earthLocation == null) {
            return "";
        }
        List controls = this.vm.getControls();
        StringBuffer sb = new StringBuffer();
        Animation animation = this.vm.getAnimation();
        int step = animation.getCurrent();
        Real aniValue = animation.getAniValue();
        boolean didone = false;
        try {
            if (showDisplays) {
                for (int i = 0; i < controls.size(); ++i) {
                    DisplayControl display = (DisplayControl)controls.get(i);
                    List readout = display.getCursorReadout(earthLocation, aniValue, step, samples);
                    if (readout == null || readout.size() <= 0) continue;
                    didone = true;
                    sb.append(StringUtil.join("", readout));
                }
            }
            if (!didone) {
                // empty if block
            }
            String llp = earthLocation == null ? "" : this.vm.getIdv().getDisplayConventions().formatEarthLocation(earthLocation, showAlt);
            llp = StringUtil.padRight(llp, 600, "&nbsp;");
            return "<html>Location: " + llp + (didone ? "<hr>" : "") + "<table cellspacing=\"0\" cellpadding=\"0\" width=\"100%\">" + sb + "</table></html>";
        }
        catch (Exception exc) {
            this.vm.logException("Getting cursor readouts", exc);
            return "";
        }
    }
}

