/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import ucar.unidata.util.ContourInfo;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.TwoFacedObject;
import visad.Unit;
import visad.util.HersheyFont;
import visad.util.TextControlWidget;

public class ContourInfoDialog
implements ActionListener {
    private static final int MAX_LEVELS = 1500;
    private boolean ok;
    private JDialog dialog;
    private JComponent contents;
    private ContourInfo myInfo;
    private JTextField intervalFld;
    private JTextField minFld;
    private JTextField maxFld;
    private JTextField baseFld;
    private JCheckBox toggleBtn;
    private JCheckBox dashBtn;
    private JComboBox widthBox;
    private JComboBox styleBox;
    private JComboBox fontBox;
    private JComboBox fontSizeBox;
    private JSlider labelFreqSlider;
    private JComboBox alignBox;
    private JPanel labelPanel;
    private String title;
    private TwoFacedObject[] aligns = new TwoFacedObject[]{new TwoFacedObject((Object)"Along Contours", new Boolean(true)), new TwoFacedObject((Object)"Horizontal", new Boolean(false))};
    private String current_action_command = null;
    private JSpinner js = null;

    public ContourInfoDialog(String title, boolean showApplyBtn) {
        this(title, showApplyBtn, null);
    }

    public ContourInfoDialog(String title, boolean showApplyBtn, Unit unit) {
        this(title, showApplyBtn, unit, true);
    }

    public ContourInfoDialog(String title, boolean showApplyBtn, Unit unit, boolean doDialog) {
        this.title = title;
        this.doMakeContents(showApplyBtn, unit, doDialog);
    }

    private JTextField makeField() {
        JTextField fld = new JTextField("", 6);
        fld.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (ContourInfoDialog.this.doApply()) {
                    ContourInfoDialog.this.dialog.setVisible(false);
                    ContourInfoDialog.this.ok = true;
                }
            }
        });
        return fld;
    }

    private void doMakeContents(boolean showApplyBtn, Unit unit, boolean doDialog) {
        JPanel buttons;
        String labelString = "";
        if (unit != null) {
            labelString = " " + unit.toString() + " ";
        }
        this.dashBtn = new JCheckBox("Dash:");
        this.dashBtn.setToolTipText("Dash contour lines if less than base");
        this.styleBox = new JComboBox<String>(new String[]{"_ _ _", ".....", "_._._"});
        this.styleBox.setMaximumSize(new Dimension(30, 16));
        this.styleBox.setToolTipText("Set the line style");
        Font f = Font.decode("monospaced-BOLD");
        if (f != null) {
            this.styleBox.setFont(f);
        }
        this.dashBtn = new JCheckBox("Dash:");
        this.dashBtn.setToolTipText("Dash contour lines if less than base");
        this.dashBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ContourInfoDialog.this.styleBox.setEnabled(((JCheckBox)e.getSource()).isSelected());
            }
        });
        Vector fonts = GuiUtils.getFontList();
        String[] hFonts = TextControlWidget.getHersheyFontNames();
        for (int i = 0; i < hFonts.length; ++i) {
            fonts.add(this.makeTwoFacedFont(new HersheyFont(hFonts[i])));
        }
        fonts.insertElementAt(this.makeTwoFacedFont(null), 0);
        this.fontBox = new JComboBox(fonts);
        this.fontBox.setToolTipText("Set the contour label font");
        this.fontSizeBox = GuiUtils.doMakeFontSizeBox(12);
        this.fontSizeBox.setToolTipText("Set the contour label size");
        this.alignBox = new JComboBox<TwoFacedObject>(this.aligns);
        this.alignBox.setToolTipText("Set the contour label alignment");
        this.labelFreqSlider = new JSlider(0, 1, 9, 2);
        this.labelFreqSlider.setMajorTickSpacing(2);
        this.labelFreqSlider.setPaintTicks(true);
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        labelTable.put(new Integer(1), new JLabel("Lo"));
        labelTable.put(new Integer(5), new JLabel("Med"));
        labelTable.put(new Integer(9), new JLabel("Hi"));
        this.labelFreqSlider.setLabelTable(labelTable);
        this.labelFreqSlider.setPaintLabels(true);
        this.labelFreqSlider.setSnapToTicks(true);
        this.labelFreqSlider.setValue(1);
        Integer defaultInterval = new Integer(2);
        Integer minInterval = new Integer(1);
        Integer maxInterval = new Integer(100);
        Integer intervalStep = new Integer(1);
        SpinnerNumberModel snm = new SpinnerNumberModel(defaultInterval, minInterval, maxInterval, intervalStep);
        this.js = new JSpinner(snm);
        JFormattedTextField jftfLineSkip = this.getTextField(this.js);
        if (jftfLineSkip != null) {
            jftfLineSkip.setColumns(3);
            jftfLineSkip.setEditable(false);
        }
        this.toggleBtn = new JCheckBox("Labels:", true);
        this.toggleBtn.setToolTipText("Toggle contour labels");
        Component[] componentArray = new Component[24];
        componentArray[0] = GuiUtils.rLabel("Contour Interval:");
        this.intervalFld = this.makeField();
        componentArray[1] = GuiUtils.centerRight(this.intervalFld, new JLabel(labelString));
        componentArray[2] = GuiUtils.rLabel("Base Contour:");
        this.baseFld = this.makeField();
        componentArray[3] = GuiUtils.centerRight(this.baseFld, new JLabel(labelString));
        componentArray[4] = GuiUtils.rLabel("Minimum Value:");
        this.minFld = this.makeField();
        componentArray[5] = GuiUtils.centerRight(this.minFld, new JLabel(labelString));
        componentArray[6] = GuiUtils.rLabel("Maximum Value:");
        this.maxFld = this.makeField();
        componentArray[7] = GuiUtils.centerRight(this.maxFld, new JLabel(labelString));
        componentArray[8] = GuiUtils.rLabel("Line Width:");
        this.widthBox = GuiUtils.createValueBox(this, "lineWidth", 1, Misc.createIntervalList(1, 5, 1), true);
        componentArray[9] = this.widthBox;
        componentArray[10] = GuiUtils.right(this.dashBtn);
        componentArray[11] = this.styleBox;
        componentArray[12] = GuiUtils.right(GuiUtils.right(this.toggleBtn));
        componentArray[13] = new JLabel("");
        componentArray[14] = GuiUtils.rLabel("Font:");
        componentArray[15] = GuiUtils.center(this.fontBox);
        componentArray[16] = GuiUtils.rLabel("Size:");
        componentArray[17] = GuiUtils.center(this.fontSizeBox);
        componentArray[18] = GuiUtils.rLabel("Align:");
        componentArray[19] = GuiUtils.center(this.alignBox);
        componentArray[20] = GuiUtils.rLabel("Frequency:");
        componentArray[21] = GuiUtils.center(this.labelFreqSlider);
        componentArray[22] = GuiUtils.rLabel("Label Every Nth Line:");
        componentArray[23] = GuiUtils.center(this.js);
        Component[] comps = componentArray;
        GuiUtils.tmpInsets = new Insets(4, 4, 4, 4);
        JPanel p1 = GuiUtils.doLayout(comps, 2, GuiUtils.WT_NY, GuiUtils.WT_N);
        this.contents = p1;
        JPanel jPanel = buttons = showApplyBtn ? GuiUtils.makeApplyOkCancelButtons(this) : GuiUtils.makeOkCancelButtons(this);
        if (doDialog) {
            this.dialog = GuiUtils.createDialog(this.title, true);
            this.dialog.getContentPane().add(GuiUtils.centerBottom(this.contents, buttons));
            GuiUtils.packInCenter(this.dialog);
        }
    }

    public JComponent getContents() {
        return this.contents;
    }

    public JComponent getLabelPanel() {
        return this.labelPanel;
    }

    public boolean doApply() {
        try {
            float[] levels;
            String intoStr = this.intervalFld.getText();
            float into = Float.NaN;
            if (!ContourInfo.isIrregularInterval(intoStr)) {
                into = (float)Misc.parseNumber(intoStr);
                intoStr = null;
            }
            float baso = (float)Misc.parseNumber(this.baseFld.getText());
            float mino = (float)Misc.parseNumber(this.minFld.getText());
            float maxo = (float)Misc.parseNumber(this.maxFld.getText());
            if (!Float.isNaN(into) && (double)into < 0.0) {
                into = (float)((double)into * -1.0);
            }
            if (!Float.isNaN(into) && mino > maxo) {
                maxo = mino + into;
            }
            boolean any_changed = false;
            float cur_interval = this.myInfo.getInterval();
            String cur_lev_string = this.myInfo.getLevelsString();
            float cur_base = this.myInfo.getBase();
            float cur_min = this.myInfo.getMin();
            float cur_max = this.myInfo.getMax();
            boolean cur_dash_on = this.myInfo.getDashOn();
            boolean cur_isLabelled = this.myInfo.getIsLabeled();
            int cur_line_width = this.myInfo.getLineWidth();
            int cur_dash_style = this.myInfo.getDashedStyle();
            Object cur_font = this.myInfo.getFont();
            int cur_font_size = this.myInfo.getLabelSize();
            int cur_label_freq = this.myInfo.getLabelFreq();
            int cur_line_skip = this.myInfo.getLabelLineSkip();
            boolean cur_align_labels = this.myInfo.getAlignLabels();
            String new_lev_string = ContourInfo.cleanupUserLevelString(intoStr);
            boolean new_dash_on = this.dashBtn.isSelected();
            boolean new_isLabelled = this.toggleBtn.isSelected();
            int new_line_width = new Integer(this.widthBox.getSelectedItem().toString());
            int new_dash_style = this.styleBox.getSelectedIndex() + 1;
            Object new_font = ((TwoFacedObject)this.fontBox.getSelectedItem()).getId();
            int new_font_size = (Integer)this.fontSizeBox.getSelectedItem();
            boolean new_align_labels = (Boolean)((TwoFacedObject)this.alignBox.getSelectedItem()).getId();
            int new_label_freq = this.labelFreqSlider.getValue();
            int new_line_skip = ((Number)this.js.getValue()).intValue();
            if (0 != Float.compare(cur_interval, into)) {
                this.myInfo.setInterval(into);
                any_changed = true;
            }
            if (!Misc.equals(cur_lev_string, new_lev_string)) {
                this.myInfo.setLevelsString(new_lev_string);
                any_changed = true;
            }
            if (0 != Float.compare(cur_base, baso)) {
                this.myInfo.setBase(baso);
                any_changed = true;
            }
            if (0 != Float.compare(cur_min, mino)) {
                this.myInfo.setMin(mino);
                any_changed = true;
            }
            if (0 != Float.compare(cur_max, maxo)) {
                this.myInfo.setMax(maxo);
                any_changed = true;
            }
            if (cur_dash_on != new_dash_on) {
                this.myInfo.setDashOn(new_dash_on);
                any_changed = true;
            }
            if (cur_isLabelled != new_isLabelled) {
                this.myInfo.setIsLabeled(new_isLabelled);
                any_changed = true;
            }
            if (cur_line_width != new_line_width) {
                this.myInfo.setLineWidth(new_line_width);
                any_changed = true;
            }
            if (cur_dash_style != new_dash_style) {
                this.myInfo.setDashedStyle(new_dash_style);
                any_changed = true;
            }
            if ((levels = this.myInfo.getContourLevels()).length > 1500) {
                LogUtil.userErrorMessage("Contour interval too small for range");
                return false;
            }
            if (!Misc.equals(cur_font, new_font)) {
                this.myInfo.setFont(new_font);
                any_changed = true;
            }
            if (cur_font_size != new_font_size) {
                this.myInfo.setLabelSize(new_font_size);
                any_changed = true;
            }
            if (cur_align_labels != new_align_labels) {
                this.myInfo.setAlignLabels(new_align_labels);
                any_changed = true;
            }
            if (cur_label_freq != new_label_freq) {
                this.myInfo.setLabelFreq(new_label_freq);
                any_changed = true;
            }
            if (cur_line_skip != new_line_skip) {
                this.myInfo.setLabelLineSkip(new_line_skip);
                any_changed = true;
            }
            if (this.current_action_command != null && this.dialog != null && this.current_action_command.equals(GuiUtils.CMD_OK)) {
                this.dialog.setVisible(false);
            }
            return any_changed;
        }
        catch (NumberFormatException nfe) {
            LogUtil.userErrorMessage("Incorrect number format");
            return false;
        }
        catch (Exception exc) {
            LogUtil.logException("Setting contours", exc);
            return false;
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        String cmd;
        this.current_action_command = cmd = evt.getActionCommand();
        if ((cmd.equals(GuiUtils.CMD_OK) || cmd.equals(GuiUtils.CMD_APPLY)) && !this.doApply()) {
            return;
        }
        if (cmd.equals(GuiUtils.CMD_CANCEL)) {
            this.ok = false;
        } else if (cmd.equals(GuiUtils.CMD_OK)) {
            this.ok = true;
        }
        if (cmd.equals(GuiUtils.CMD_CANCEL) || cmd.equals(GuiUtils.CMD_OK)) {
            this.dialog.setVisible(false);
        }
    }

    public JFormattedTextField getTextField(JSpinner spinner) {
        JComponent editor = spinner.getEditor();
        if (editor instanceof JSpinner.DefaultEditor) {
            return ((JSpinner.DefaultEditor)editor).getTextField();
        }
        LogUtil.message("Unexpected editor type: " + spinner.getEditor().getClass() + " isn't a descendant of DefaultEditor");
        return null;
    }

    public boolean showDialog(ContourInfo transfer) {
        this.ok = true;
        this.setState(transfer);
        this.dialog.setVisible(true);
        return this.ok;
    }

    public void setState(ContourInfo transfer) {
        this.myInfo = transfer;
        this.intervalFld.setText(transfer.getIntervalString());
        this.baseFld.setText(Misc.format(transfer.getBase()));
        this.minFld.setText(Misc.format(transfer.getMin()));
        this.maxFld.setText(Misc.format(transfer.getMax()));
        this.toggleBtn.setSelected(this.myInfo.getIsLabeled());
        this.dashBtn.setSelected(this.myInfo.getDashOn());
        this.dashBtn.setEnabled(!this.myInfo.getIsFilled());
        this.labelFreqSlider.setValue(transfer.getLabelFreq());
        this.js.setValue(transfer.getLabelLineSkip());
        this.widthBox.setSelectedItem(new Integer(this.myInfo.getLineWidth()));
        this.styleBox.setSelectedIndex(this.myInfo.getDashedStyle() - 1);
        this.styleBox.setEnabled(this.myInfo.getDashOn());
        this.fontBox.setSelectedItem(this.makeTwoFacedFont(this.myInfo.getFont()));
        this.fontSizeBox.setSelectedItem(new Integer(this.myInfo.getLabelSize()));
        this.alignBox.setSelectedItem(this.myInfo.getAlignLabels() ? this.aligns[0] : this.aligns[1]);
    }

    private TwoFacedObject makeTwoFacedFont(Object font) {
        if (font == null) {
            return new TwoFacedObject((Object)"Default", font);
        }
        if (font instanceof Font) {
            return GuiUtils.makeTwoFacedFont((Font)font);
        }
        if (font instanceof HersheyFont) {
            return new TwoFacedObject((Object)font.toString(), font);
        }
        return null;
    }

    public static Object getContourFont(Object fontSpec) {
        Object font = fontSpec;
        if (fontSpec != null && !(fontSpec instanceof Font) && !(fontSpec instanceof HersheyFont)) {
            String fontName = fontSpec.toString();
            try {
                if (fontName.startsWith("HersheyFont:")) {
                    font = new HersheyFont(fontName.substring(fontName.indexOf(" ") + 1));
                } else {
                    fontName = fontName + "-1";
                    font = Font.decode(fontName);
                }
            }
            catch (Exception e) {
                font = null;
            }
        }
        return font;
    }

    public ContourInfo getInfo() {
        return this.myInfo;
    }
}

