/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ucar.unidata.idv.IdvPersistenceManager;
import ucar.unidata.idv.SavedBundle;
import ucar.unidata.idv.ui.IdvUIManager;
import ucar.unidata.ui.DndTree;
import ucar.unidata.util.FileManager;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.xml.XmlUtil;

public class BundleTree
extends DndTree {
    public static final String CMD_EXPORT_TO_PLUGIN = "Export to Plugin";
    private JFrame frame;
    private int bundleType;
    private DefaultMutableTreeNode treeRoot;
    private DefaultTreeModel treeModel;
    private Hashtable nodeToData;
    private IdvUIManager uiManager;
    private ImageIcon categoryIcon = GuiUtils.getImageIcon("/auxdata/ui/icons/folder.png", this.getClass());
    private ImageIcon bundleIcon = GuiUtils.getImageIcon("/auxdata/ui/icons/page.png", this.getClass());

    public BundleTree(IdvUIManager uiManager, int bundleType) {
        this.uiManager = uiManager;
        this.setToolTipText("<html>Right click to show popup menu.<br>Drag to move bundles or categories</html>");
        this.bundleType = bundleType;
        this.treeRoot = new DefaultMutableTreeNode(this.getPersistenceManager().getBundleTitle(this.getBundleType()));
        this.setShowsRootHandles(true);
        this.treeModel = new DefaultTreeModel(this.treeRoot);
        this.setModel(this.treeModel);
        DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree theTree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                super.getTreeCellRendererComponent(theTree, value, sel, expanded, leaf, row, hasFocus);
                if (BundleTree.this.nodeToData == null || value == null) {
                    return this;
                }
                Object data = BundleTree.this.nodeToData.get(value);
                if (data == null) {
                    this.setIcon(BundleTree.this.categoryIcon);
                    return this;
                }
                if (data instanceof SavedBundle) {
                    this.setToolTipText("<html>Right click to show bundle menu.<br>Drag to move bundle</html>");
                    this.setIcon(BundleTree.this.bundleIcon);
                } else {
                    this.setToolTipText("<html>Right click to show category menu.<br>Drag to move bundles or categories</html><");
                    this.setIcon(BundleTree.this.categoryIcon);
                }
                return this;
            }
        };
        this.setCellRenderer(renderer);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                SavedBundle bundle;
                if (GuiUtils.isDeleteEvent(e)) {
                    BundleTree.this.deleteSelected();
                } else if (e.getKeyCode() == 10 && (bundle = BundleTree.this.findSelectedBundle()) != null) {
                    BundleTree.this.doOpen(bundle);
                }
            }
        });
        this.getSelectionModel().setSelectionMode(4);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                TreePath path = BundleTree.this.getPathForLocation(event.getX(), event.getY());
                Object data = BundleTree.this.findDataAtPath(path);
                if (!SwingUtilities.isRightMouseButton(event)) {
                    if (event.getClickCount() > 1 && data != null && data instanceof SavedBundle) {
                        BundleTree.this.doOpen((SavedBundle)data);
                    }
                    return;
                }
                BundleTree.this.clearSelection();
                BundleTree.this.addSelectionPath(path);
                DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)path.getLastPathComponent();
                JPopupMenu popup = new JPopupMenu();
                if (data == null) {
                    popup.add(GuiUtils.makeMenuItem("Add Sub-Category", BundleTree.this, "addCategory", parentNode));
                } else if (data instanceof SavedBundle) {
                    SavedBundle bundle = (SavedBundle)data;
                    popup.add(GuiUtils.makeMenuItem("Open", BundleTree.this, "doOpen", bundle));
                    popup.add(GuiUtils.makeMenuItem("Rename", BundleTree.this, "doRename", bundle));
                    popup.add(GuiUtils.makeMenuItem("Export", BundleTree.this, "doExport", bundle));
                    popup.add(GuiUtils.makeMenuItem(BundleTree.CMD_EXPORT_TO_PLUGIN, BundleTree.this, "doExportToPlugin", bundle));
                    popup.add(GuiUtils.makeMenuItem("Delete", BundleTree.this, "deleteBundle", bundle));
                } else {
                    popup.add(GuiUtils.makeMenuItem("Import Bundle", BundleTree.this, "doImport", parentNode));
                    popup.add(GuiUtils.makeMenuItem("Delete Category", BundleTree.this, "deleteCategory", data.toString()));
                    popup.add(GuiUtils.makeMenuItem("Add Sub-Category", BundleTree.this, "addCategory", parentNode));
                }
                popup.show((Component)event.getSource(), event.getX(), event.getY());
            }
        });
        this.loadBundles();
        String title = "Local " + this.getPersistenceManager().getBundleTitle(this.getBundleType()) + " Manager";
        Dimension defaultDimension = new Dimension(300, 400);
        JScrollPane sp = GuiUtils.makeScrollPane(this, (int)defaultDimension.getWidth(), (int)defaultDimension.getHeight());
        sp.setPreferredSize(defaultDimension);
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        JMenu helpMenu = new JMenu("Help");
        menuBar.add(fileMenu);
        fileMenu.add(GuiUtils.makeMenuItem("Export to File", this, "doExport"));
        fileMenu.add(GuiUtils.makeMenuItem(CMD_EXPORT_TO_PLUGIN, this, "doExportToPlugin"));
        fileMenu.addSeparator();
        fileMenu.add(GuiUtils.makeMenuItem("Close", this, "doClose"));
        JPanel bottom = GuiUtils.wrap(GuiUtils.makeButton("Close", this, "doClose"));
        JPanel contents = GuiUtils.topCenterBottom(menuBar, sp, bottom);
        this.frame = GuiUtils.createFrame(title);
        this.frame.getContentPane().add(contents);
        this.frame.pack();
        this.frame.setLocation(100, 100);
    }

    public void doOpen(SavedBundle bundle) {
        this.getPersistenceManager().open(bundle);
    }

    public void doRename(SavedBundle bundle) {
        this.getPersistenceManager().rename(bundle, this.getBundleType());
    }

    public void doExport(SavedBundle bundle) {
        this.getPersistenceManager().export(bundle, this.getBundleType());
    }

    public void doExportToPlugin(SavedBundle bundle) {
        this.uiManager.getIdv().getPluginManager().addObject(bundle);
    }

    public void doClose() {
        this.frame.dispose();
    }

    private List getSelectedBundles() {
        TreePath[] paths = this.getSelectionModel().getSelectionPaths();
        if (paths == null || paths.length == 0) {
            return new ArrayList();
        }
        ArrayList<Object> bundles = new ArrayList<Object>();
        for (int i = 0; i < paths.length; ++i) {
            Object data = this.findDataAtPath(paths[i]);
            if (data == null || !(data instanceof SavedBundle)) continue;
            bundles.add(data);
        }
        return bundles;
    }

    public void doExportToPlugin() {
        List bundles = this.getSelectedBundles();
        if (bundles.size() == 0) {
            LogUtil.userMessage("No bundles are selected");
            return;
        }
        this.uiManager.getIdv().getPluginManager().addObjects(bundles);
    }

    public void doExport() {
        try {
            List bundles = this.getSelectedBundles();
            if (bundles.size() == 0) {
                LogUtil.userMessage("No bundles are selected");
                return;
            }
            String filename = FileManager.getWriteFile(FileManager.FILTER_XML, ".xml");
            if (filename == null) {
                return;
            }
            File dir = new File(filename).getParentFile();
            boolean anyExist = false;
            for (int i = 0; i < bundles.size(); ++i) {
                SavedBundle bundle = (SavedBundle)bundles.get(i);
                if (!new File(IOUtil.joinDir(dir, IOUtil.getFileTail(bundle.getUrl()))).exists()) continue;
                anyExist = true;
                break;
            }
            if (anyExist && !GuiUtils.showOkCancelDialog(null, "Overwrite Bundle Files", new JLabel("<html>One or more bundle files already exist.<br>Do you want to overwrite them?</html>"), null, null)) {
                return;
            }
            Document doc = XmlUtil.makeDocument();
            Element root = doc.createElement("bundles");
            for (int i = 0; i < bundles.size(); ++i) {
                SavedBundle bundle = (SavedBundle)bundles.get(i);
                bundle.toXml(doc, root);
            }
            String xml = XmlUtil.toString(doc.getDocumentElement());
            IOUtil.writeFile(filename, xml);
            String msg = "<html>The selected bundles have been exported. The files are:<br>";
            for (int i = 0; i < bundles.size(); ++i) {
                SavedBundle bundle = (SavedBundle)bundles.get(i);
                String tail = IOUtil.getFileTail(bundle.getUrl());
                msg = msg + "&nbsp;&nbsp;<b>" + tail + "</b><br>";
                File toFile = new File(IOUtil.joinDir(dir, tail));
                IOUtil.copyFile(new File(bundle.getUrl()), toFile);
            }
            msg = msg + "</html>";
            LogUtil.userMessage(msg);
        }
        catch (Exception exc) {
            LogUtil.logException("Exporting bundles", exc);
        }
    }

    private int getBundleType() {
        return this.bundleType;
    }

    private IdvPersistenceManager getPersistenceManager() {
        return this.uiManager.getPersistenceManager();
    }

    @Override
    public void setVisible(boolean visible) {
        this.frame.setVisible(visible);
    }

    @Override
    protected boolean okToDrag(DefaultMutableTreeNode sourceNode) {
        return sourceNode.getParent() != null;
    }

    @Override
    protected boolean okToDrop(DefaultMutableTreeNode sourceNode, DefaultMutableTreeNode destNode) {
        if (sourceNode.getUserObject() instanceof SavedBundle && destNode.getParent() == null) {
            return false;
        }
        if (destNode.getUserObject() instanceof SavedBundle) {
            return false;
        }
        if (destNode == sourceNode.getParent()) {
            return false;
        }
        while (destNode != null) {
            if (destNode == sourceNode) {
                return false;
            }
            destNode = (DefaultMutableTreeNode)destNode.getParent();
        }
        return true;
    }

    @Override
    protected void doDrop(DefaultMutableTreeNode sourceNode, DefaultMutableTreeNode destNode) {
        if (sourceNode.getUserObject() instanceof SavedBundle) {
            this.uiManager.getPersistenceManager().moveBundle((SavedBundle)sourceNode.getUserObject(), this.getCategoryList(destNode), this.bundleType);
        } else {
            this.uiManager.getPersistenceManager().moveCategory(this.getCategoryList(sourceNode), this.getCategoryList(destNode), this.bundleType);
        }
        this.loadBundles();
    }

    private List getCategoryList(DefaultMutableTreeNode destNode) {
        ArrayList<String> categories = new ArrayList<String>();
        while (destNode.getParent() != null) {
            categories.add(0, destNode.getUserObject().toString());
            destNode = (DefaultMutableTreeNode)destNode.getParent();
        }
        return categories;
    }

    public void deleteSelected() {
        TreePath[] paths = this.getSelectionModel().getSelectionPaths();
        if (paths == null || paths.length == 0) {
            return;
        }
        Object data = this.findDataAtPath(paths[0]);
        if (data == null) {
            return;
        }
        if (data instanceof SavedBundle) {
            this.deleteBundle((SavedBundle)data);
        } else {
            this.deleteCategory(data.toString());
        }
    }

    public SavedBundle findSelectedBundle() {
        TreePath[] paths = this.getSelectionModel().getSelectionPaths();
        if (paths == null || paths.length == 0) {
            return null;
        }
        Object data = this.findDataAtPath(paths[0]);
        if (data == null) {
            return null;
        }
        if (data instanceof SavedBundle) {
            return (SavedBundle)data;
        }
        return null;
    }

    protected void loadBundles() {
        int i;
        Enumeration<TreePath> paths = this.getExpandedDescendants(new TreePath(this.treeRoot.getPath()));
        Hashtable expandedState = GuiUtils.initializeExpandedPathsBeforeChange(this, this.treeRoot);
        List allCategories = this.uiManager.getPersistenceManager().getAllCategories(this.bundleType);
        this.nodeToData = new Hashtable();
        this.treeRoot.removeAllChildren();
        Hashtable<String, DefaultMutableTreeNode> catNodes = new Hashtable<String, DefaultMutableTreeNode>();
        Hashtable<SavedBundle, SavedBundle> fakeBundles = new Hashtable<SavedBundle, SavedBundle>();
        ArrayList<SavedBundle> bundles = new ArrayList<SavedBundle>();
        for (i = 0; i < allCategories.size(); ++i) {
            this.uiManager.getPersistenceManager();
            List categories = IdvPersistenceManager.stringToCategories((String)allCategories.get(i));
            SavedBundle fakeBundle = new SavedBundle("", "", categories);
            fakeBundles.put(fakeBundle, fakeBundle);
            bundles.add(fakeBundle);
        }
        bundles.addAll(this.uiManager.getPersistenceManager().getWritableBundles(this.bundleType));
        for (i = 0; i < bundles.size(); ++i) {
            SavedBundle bundle = (SavedBundle)bundles.get(i);
            List categories = bundle.getCategories();
            DefaultMutableTreeNode catNode = this.treeRoot;
            String fullCat = "";
            for (int catIdx = 0; catIdx < categories.size(); ++catIdx) {
                DefaultMutableTreeNode tmpNode;
                String cat = (String)categories.get(catIdx);
                if (fullCat.length() > 0) {
                    fullCat = fullCat + ">";
                }
                if ((tmpNode = (DefaultMutableTreeNode)catNodes.get(fullCat = fullCat + cat)) == null) {
                    tmpNode = new DefaultMutableTreeNode(cat);
                    this.nodeToData.put(tmpNode, fullCat);
                    catNode.add(tmpNode);
                    catNodes.put(fullCat, tmpNode);
                }
                catNode = tmpNode;
            }
            if (fakeBundles.get(bundle) != null) continue;
            DefaultMutableTreeNode bundleNode = new DefaultMutableTreeNode(bundle);
            this.nodeToData.put(bundleNode, bundle);
            catNode.add(bundleNode);
        }
        this.treeModel.nodeStructureChanged(this.treeRoot);
        GuiUtils.expandPathsAfterChange(this, expandedState, this.treeRoot);
    }

    public void deleteBundle(SavedBundle bundle) {
        if (!GuiUtils.askYesNo("Bundle delete confirmation", "Are you sure you want to delete the bundle \"" + bundle + "\"  ?")) {
            return;
        }
        this.uiManager.getPersistenceManager().deleteBundle(bundle.getUrl());
        this.loadBundles();
    }

    public void addCategory(DefaultMutableTreeNode parentNode) {
        String fullCat;
        String cat = GuiUtils.getInput("Please enter the new sub-category name", "Name: ", "");
        if (cat == null) {
            return;
        }
        String parentCat = (String)this.nodeToData.get(parentNode);
        String string = fullCat = parentCat == null ? cat : parentCat + ">" + cat;
        if (!this.uiManager.getPersistenceManager().addBundleCategory(this.bundleType, fullCat)) {
            LogUtil.userMessage("A subcategory with the given name already exists");
            return;
        }
        DefaultMutableTreeNode newCatNode = new DefaultMutableTreeNode(cat);
        this.nodeToData.put(newCatNode, fullCat);
        parentNode.add(newCatNode);
        Hashtable expandedState = GuiUtils.initializeExpandedPathsBeforeChange(this, this.treeRoot);
        this.treeModel.nodeStructureChanged(this.treeRoot);
        GuiUtils.expandPathsAfterChange(this, expandedState, this.treeRoot);
    }

    public void doImport(DefaultMutableTreeNode parentNode) {
        String filename = FileManager.getReadFile("Import Bundle", Misc.newList(this.uiManager.getIdv().getArgsManager().getXidvZidvFileFilter()));
        if (filename == null) {
            return;
        }
        String fullCat = (String)this.nodeToData.get(parentNode);
        this.uiManager.getPersistenceManager().doImport(this.bundleType, filename, fullCat);
        Hashtable expandedState = GuiUtils.initializeExpandedPathsBeforeChange(this, this.treeRoot);
        this.treeModel.nodeStructureChanged(this.treeRoot);
        GuiUtils.expandPathsAfterChange(this, expandedState, this.treeRoot);
    }

    public void deleteCategory(String category) {
        if (!GuiUtils.askYesNo("Bundle Category Delete Confirmation", "<html>Are you sure you want to delete the category:<p> <center>\"" + category + "\"</center> <br> and all bundles and categories under it?</html>")) {
            return;
        }
        this.uiManager.getPersistenceManager().deleteBundleCategory(this.bundleType, category);
        this.loadBundles();
    }

    private Object findDataAtPath(TreePath path) {
        if (path == null || this.nodeToData == null) {
            return null;
        }
        DefaultMutableTreeNode last = (DefaultMutableTreeNode)path.getLastPathComponent();
        if (last == null) {
            return null;
        }
        return this.nodeToData.get(last);
    }
}

