/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import ucar.unidata.idv.DisplayControl;
import ucar.unidata.idv.ViewManager;
import ucar.unidata.idv.ui.IdvLegend;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.ObjectListener;

public class BottomLegend
extends IdvLegend {
    private Color background;
    private Color foreground;
    private JPanel legendPanel;
    private JPanel mainContents;
    private static Border legendBorder;

    public BottomLegend(ViewManager viewManager) {
        super(viewManager);
    }

    @Override
    protected JComponent doMakeContents() {
        this.legendPanel = new JPanel();
        JScrollPane scroller = GuiUtils.makeScrollPane(this.legendPanel, 500, 50);
        scroller.setBorder(BorderFactory.createEmptyBorder());
        scroller.setPreferredSize(new Dimension(500, 50));
        this.mainContents = GuiUtils.center(scroller);
        KeyAdapter keyListener = new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                BottomLegend.this.viewManager.keyWasTyped(e);
            }
        };
        ObjectListener mouseListener = new ObjectListener(this.legendPanel){

            @Override
            public void mouseClicked(MouseEvent e) {
                ((Component)e.getSource()).requestFocus();
            }
        };
        JComponent[] comps = new JComponent[]{this.legendPanel, this.mainContents};
        IntStream.range(0, comps.length).filter(i -> comps[i] != null).forEach(i -> {
            comps[i].addKeyListener(keyListener);
            comps[i].addMouseListener(mouseListener);
            comps[i].setRequestFocusEnabled(true);
        });
        return this.mainContents;
    }

    @Override
    public void setColors(Color foreground, Color background) {
        this.foreground = foreground;
        this.background = background;
        this.mainContents.setBackground(background);
        this.legendPanel.setBackground(background);
        this.fillLegend();
    }

    @Override
    protected void fillLegendSafely() {
        this.legendPanel.removeAll();
        List controls = this.viewManager.getControls();
        ArrayList<JPanel> comps = new ArrayList<JPanel>();
        int cnt = 0;
        for (int i = controls.size() - 1; i >= 0; --i) {
            DisplayControl control = (DisplayControl)controls.get(i);
            JComponent controlLegend = control.getLegendComponent(0);
            control.setLegendBackground(this.background);
            control.setLegendForeground(this.foreground);
            String legendOrder = " #" + ++cnt + "  ";
            JLabel ll = new JLabel(legendOrder);
            ll.setBackground(this.background);
            ll.setForeground(this.foreground);
            JPanel legend = GuiUtils.hbox(ll, controlLegend);
            legend.setBackground(this.background);
            legend.setBackground(this.background);
            legend.setBorder(legendBorder);
            comps.add(legend);
        }
        JPanel listPanel = GuiUtils.vbox(comps);
        this.legendPanel.setLayout(new BorderLayout());
        this.legendPanel.add((Component)listPanel, "North");
        this.legendPanel.repaint();
        this.legendPanel.revalidate();
    }

    static {
        Border outerSpace = BorderFactory.createEmptyBorder(0, 1, 0, 1);
        Border innerSpace = BorderFactory.createEmptyBorder(1, 2, 1, 2);
        legendBorder = BorderFactory.createCompoundBorder(outerSpace, BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.gray, 1), innerSpace));
    }
}

