/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataSource;
import ucar.unidata.data.DataSourceDescriptor;
import ucar.unidata.idv.ControlDescriptor;
import ucar.unidata.idv.IdvManager;
import ucar.unidata.idv.IdvResourceManager;
import ucar.unidata.idv.IntegratedDataViewer;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.Misc;
import ucar.unidata.util.TwoFacedObject;
import ucar.unidata.xml.XmlResourceCollection;
import ucar.unidata.xml.XmlUtil;

public class AutoDisplayEditor
extends IdvManager {
    private static final String TAG_AUTODISPLAY = "autodisplay";
    private static final String TAG_AUTODISPLAYS = "autodisplays";
    private static final String ATTR_DATASOURCE = "datasource";
    private static final String ATTR_PARAMETER = "parameter";
    private static final String ATTR_DISPLAY = "display";
    private static final String ATTR_ENABLED = "enabled";
    private DefaultMutableTreeNode treeRoot;
    private DefaultTreeModel treeModel;
    private JTree tree;
    private boolean needToLoadTree = true;
    private Hashtable autoDisplayMap;
    public static final String[] ordinalNames = new String[]{"First", "Second", "Third", "Fourth", "Fifth", "Sixth", "Seventh", "Eight", "Ninth", "Tenth"};

    public AutoDisplayEditor(IntegratedDataViewer idv) {
        super(idv);
        JPanel buttons = GuiUtils.makeButtons(this, new String[]{GuiUtils.CMD_CLOSE});
        this.contents = GuiUtils.centerBottom(this.doMakeContents(), buttons);
    }

    @Override
    protected String getWindowTitle() {
        return "Auto-Displays Editor";
    }

    @Override
    public void show() {
        if (this.needToLoadTree) {
            this.loadTree();
        }
        super.show();
    }

    private void loadTree() {
        Hashtable oldPaths = GuiUtils.initializeExpandedPathsBeforeChange(this.tree, this.treeRoot);
        this.needToLoadTree = false;
        this.treeRoot.removeAllChildren();
        this.initAutoDisplays();
        Enumeration keys = this.autoDisplayMap.keys();
        while (keys.hasMoreElements()) {
            List paramDisplays;
            DataSourceDescriptor dsd = this.getDataManager().getDescriptor((String)keys.nextElement());
            if (dsd == null || (paramDisplays = (List)this.autoDisplayMap.get(dsd.getId())).size() == 0) continue;
            String dsdLabel = dsd.getLabel();
            if (dsdLabel == null || dsdLabel.trim().length() == 0) {
                dsdLabel = dsd.getId();
            }
            DefaultMutableTreeNode dsdNode = new DefaultMutableTreeNode(dsdLabel);
            this.treeRoot.add(dsdNode);
            for (int i = 0; i < paramDisplays.size(); ++i) {
                ParamDisplay pd = (ParamDisplay)paramDisplays.get(i);
                String paramLabel = pd.paramId;
                if (pd.paramId.startsWith("#")) {
                    int nth = new Integer(pd.paramId.substring(1));
                    paramLabel = nth < ordinalNames.length ? ordinalNames[nth] + " parameter" : nth + "th parameter";
                }
                TwoFacedObject tfo = new TwoFacedObject((Object)(paramLabel + " --> " + pd.cd), new Object[]{dsd, pd});
                DefaultMutableTreeNode displayNode = new DefaultMutableTreeNode(tfo);
                dsdNode.add(displayNode);
            }
        }
        this.treeModel.nodeStructureChanged(this.treeRoot);
        GuiUtils.expandPathsAfterChange(this.tree, oldPaths, this.treeRoot);
    }

    @Override
    protected JComponent doMakeContents() {
        this.treeRoot = new DefaultMutableTreeNode("");
        this.treeModel = new DefaultTreeModel(this.treeRoot);
        this.tree = new JTree(this.treeModel);
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (!SwingUtilities.isRightMouseButton(event)) {
                    return;
                }
                TreePath path = AutoDisplayEditor.this.tree.getPathForLocation(event.getX(), event.getY());
                if (path == null) {
                    return;
                }
                DefaultMutableTreeNode last = (DefaultMutableTreeNode)path.getLastPathComponent();
                Object data = last.getUserObject();
                if (data == null || !(data instanceof TwoFacedObject)) {
                    return;
                }
                final TwoFacedObject tfo = (TwoFacedObject)data;
                JPopupMenu popup = new JPopupMenu();
                JMenuItem mi = new JMenuItem("Remove");
                popup.add(mi);
                mi.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        AutoDisplayEditor.this.removeAutoDisplay(tfo);
                    }
                });
                for (int i = 0; i < 5; ++i) {
                    final int index = i;
                    mi = new JMenuItem("Change parameter to the " + ordinalNames[i] + " parameter");
                    popup.add(mi);
                    mi.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent ae) {
                            AutoDisplayEditor.this.setParameter(tfo, "#" + index);
                        }
                    });
                }
                popup.show((Component)event.getSource(), event.getX(), event.getY());
            }
        });
        this.tree.setToolTipText("<html>Use the 'Delete' key to remove the selected auto-displays.<br>Right click to show popup menu.</html>");
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent event) {
                if (GuiUtils.isDeleteEvent(event)) {
                    TreePath[] paths = AutoDisplayEditor.this.tree.getSelectionModel().getSelectionPaths();
                    if (paths == null || paths.length == 0) {
                        return;
                    }
                    DefaultMutableTreeNode last = (DefaultMutableTreeNode)paths[0].getLastPathComponent();
                    if (last == null) {
                        return;
                    }
                    Object object = last.getUserObject();
                    if (!(object instanceof TwoFacedObject)) {
                        return;
                    }
                    TwoFacedObject tfo = (TwoFacedObject)object;
                    AutoDisplayEditor.this.removeAutoDisplay(tfo);
                }
            }
        });
        Dimension defaultDimension = new Dimension(300, 400);
        JScrollPane sp = GuiUtils.makeScrollPane(this.tree, (int)defaultDimension.getWidth(), (int)defaultDimension.getHeight());
        sp.setPreferredSize(defaultDimension);
        return sp;
    }

    private ParamDisplay getParamDisplay(TwoFacedObject tfo) {
        return (ParamDisplay)((Object[])tfo.getId())[1];
    }

    private DataSourceDescriptor getDataSourceDescriptor(TwoFacedObject tfo) {
        return (DataSourceDescriptor)((Object[])tfo.getId())[0];
    }

    private void setParameter(TwoFacedObject tfo, String paramId) {
        this.getParamDisplay((TwoFacedObject)tfo).paramId = paramId;
        this.writeXml();
        this.loadTree();
    }

    private void removeAutoDisplay(TwoFacedObject tfo) {
        ParamDisplay pd = this.getParamDisplay(tfo);
        this.removeAutoDisplay(this.getDataSourceDescriptor(tfo), pd.paramId, pd.cd);
    }

    private void removeAutoDisplay(DataSourceDescriptor dsd, String paramId, ControlDescriptor cd) {
        List paramDisplays = (List)this.autoDisplayMap.get(dsd.getId());
        if (paramDisplays == null) {
            return;
        }
        for (int i = 0; i < paramDisplays.size(); ++i) {
            ParamDisplay pd = (ParamDisplay)paramDisplays.get(i);
            if (!Misc.equals(paramId, pd.paramId) || !Misc.equals(cd, pd.cd)) continue;
            paramDisplays.remove(i);
            break;
        }
        this.writeXml();
        this.loadTree();
    }

    public void addDisplayForDataSource(DataChoice dataChoice, ControlDescriptor cd) {
        ArrayList dataSources = new ArrayList();
        dataChoice.getDataSources(dataSources);
        if (dataSources.size() == 0) {
            return;
        }
        String paramId = dataChoice.getName();
        String dataSourceId = ((DataSource)dataSources.get(0)).getTypeName();
        ArrayList<ParamDisplay> paramDisplays = (ArrayList<ParamDisplay>)this.autoDisplayMap.get(dataSourceId);
        if (paramDisplays == null) {
            paramDisplays = new ArrayList<ParamDisplay>();
            this.autoDisplayMap.put(dataSourceId, paramDisplays);
        }
        for (int i = 0; i < paramDisplays.size(); ++i) {
            ParamDisplay pd = (ParamDisplay)paramDisplays.get(i);
            if (!Misc.equals(paramId, pd.paramId) || !Misc.equals(cd, pd.cd)) continue;
            return;
        }
        paramDisplays.add(new ParamDisplay(paramId, cd, true));
        this.writeXml();
        this.loadTree();
    }

    private void writeXml() {
        XmlResourceCollection resources = this.getResourceManager().getXmlResources(IdvResourceManager.RSC_AUTODISPLAYS);
        Document displaysDoc = resources.getWritableDocument("<autodisplays></autodisplays>");
        Element root = resources.getWritableRoot("<autodisplays></autodisplays>");
        XmlUtil.removeChildren(root);
        this.initAutoDisplays();
        Enumeration keys = this.autoDisplayMap.keys();
        while (keys.hasMoreElements()) {
            DataSourceDescriptor dsd = this.getDataManager().getDescriptor((String)keys.nextElement());
            if (dsd == null) continue;
            List paramDisplays = (List)this.autoDisplayMap.get(dsd.getId());
            for (int i = 0; i < paramDisplays.size(); ++i) {
                ParamDisplay pd = (ParamDisplay)paramDisplays.get(i);
                Element element = displaysDoc.createElement(TAG_AUTODISPLAY);
                element.setAttribute(ATTR_DATASOURCE, dsd.getId());
                element.setAttribute(ATTR_PARAMETER, pd.paramId);
                element.setAttribute(ATTR_DISPLAY, pd.cd.getControlId());
                element.setAttribute(ATTR_ENABLED, pd.enabled + "");
                root.appendChild(element);
            }
        }
        try {
            resources.writeWritable();
        }
        catch (Throwable exc) {
            AutoDisplayEditor.logException("Adding autodisplay", exc);
        }
    }

    private List findDisplays(String paramId, List paramDisplays) {
        ArrayList<ControlDescriptor> descriptors = null;
        for (int i = 0; i < paramDisplays.size(); ++i) {
            ParamDisplay pd = (ParamDisplay)paramDisplays.get(i);
            if (!Misc.equals(paramId, pd.paramId)) continue;
            if (descriptors == null) {
                descriptors = new ArrayList<ControlDescriptor>();
            }
            descriptors.add(pd.cd);
        }
        return descriptors;
    }

    public List getDisplaysForDataSource(DataSource dataSource) {
        ArrayList<DataChoice> pairs = new ArrayList<DataChoice>();
        List dataChoices = dataSource.getDataChoices();
        this.initAutoDisplays();
        String typeName = dataSource.getTypeName();
        if (typeName == null) {
            return new ArrayList();
        }
        List paramDisplays = (List)this.autoDisplayMap.get(typeName);
        if (paramDisplays == null) {
            return pairs;
        }
        for (int i = 0; i < dataChoices.size(); ++i) {
            int j;
            DataChoice dc = (DataChoice)dataChoices.get(i);
            List dcs1 = this.findDisplays(dc.getName(), paramDisplays);
            List dcs2 = this.findDisplays("#" + i, paramDisplays);
            if (dcs1 != null) {
                for (j = 0; j < dcs1.size(); ++j) {
                    pairs.add(dc);
                    pairs.add((DataChoice)dcs1.get(j));
                }
            }
            if (dcs2 == null) continue;
            for (j = 0; j < dcs2.size(); ++j) {
                pairs.add(dc);
                pairs.add((DataChoice)dcs2.get(j));
            }
        }
        return pairs;
    }

    private void initAutoDisplays() {
        if (this.autoDisplayMap != null) {
            return;
        }
        this.autoDisplayMap = new Hashtable();
        XmlResourceCollection resources = this.getResourceManager().getXmlResources(IdvResourceManager.RSC_AUTODISPLAYS);
        for (int i = 0; i < resources.size(); ++i) {
            Element root = resources.getRoot(i);
            if (root == null) continue;
            List nodes = XmlUtil.findChildren(root, TAG_AUTODISPLAY);
            for (int nodeIdx = 0; nodeIdx < nodes.size(); ++nodeIdx) {
                Element autoDisplayNode = (Element)nodes.get(nodeIdx);
                String dataSourceId = XmlUtil.getAttribute(autoDisplayNode, ATTR_DATASOURCE);
                String paramId = XmlUtil.getAttribute(autoDisplayNode, ATTR_PARAMETER);
                String displayId = XmlUtil.getAttribute(autoDisplayNode, ATTR_DISPLAY);
                boolean enabled = XmlUtil.getAttribute((Node)autoDisplayNode, ATTR_ENABLED, true);
                ControlDescriptor cd = this.getIdv().getControlDescriptor(displayId);
                if (cd == null) continue;
                ArrayList<ParamDisplay> paramDisplays = (ArrayList<ParamDisplay>)this.autoDisplayMap.get(dataSourceId);
                if (paramDisplays == null) {
                    paramDisplays = new ArrayList<ParamDisplay>();
                    this.autoDisplayMap.put(dataSourceId, paramDisplays);
                }
                paramDisplays.add(new ParamDisplay(paramId, cd, enabled));
            }
        }
    }

    public static class ParamDisplay {
        boolean enabled = true;
        String paramId;
        ControlDescriptor cd;

        public ParamDisplay(String paramId, ControlDescriptor cd, boolean enabled) {
            this.paramId = paramId;
            this.cd = cd;
            this.enabled = enabled;
        }
    }
}

