/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ucar.unidata.data.DataAlias;
import ucar.unidata.idv.IdvManager;
import ucar.unidata.idv.IdvResourceManager;
import ucar.unidata.idv.IntegratedDataViewer;
import ucar.unidata.idv.PluginManager;
import ucar.unidata.idv.ui.IdvUIManager;
import ucar.unidata.idv.ui.ResourceViewer;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Msg;
import ucar.unidata.util.StringUtil;
import ucar.unidata.xml.XmlResourceCollection;
import ucar.unidata.xml.XmlUtil;

public class AliasEditor
extends IdvManager {
    static LogUtil.LogCategory log_ = LogUtil.getLogInstance(AliasEditor.class.getName());
    XmlResourceCollection resources;
    private List tableModels = new ArrayList();
    private List<AliasTableModel> displayedTableModels = new ArrayList<AliasTableModel>();
    private List tables = new ArrayList();
    private JTabbedPane tabbedPane;

    public AliasEditor(IntegratedDataViewer idv) {
        super(idv);
        this.resources = this.resources = idv.getResourceManager().getXmlResources(IdvResourceManager.RSC_ALIASES);
        this.init();
    }

    @Override
    public String getWindowTitle() {
        return GuiUtils.getApplicationTitle() + "Alias Editor";
    }

    public void addAsAlias(DataAlias dataAlias, String alias) {
        boolean first = true;
        AliasTableModel to = this.getTableModel(0);
        for (AliasTableModel model : this.displayedTableModels) {
            int index = model.indexOfName(dataAlias.getName());
            if (index >= 0) {
                if (first) {
                    model.addAlias(index, alias);
                    this.editEntry(model, index, false);
                    return;
                }
                String aliases = (String)model.aliases.get(index);
                aliases = aliases + "," + alias;
                to.add(dataAlias.getName(), dataAlias.getLabel(), aliases);
                this.editEntry(to, to.getRowCount() - 1, true);
                return;
            }
            first = false;
        }
        this.editEntry(null, 0, true, dataAlias.getName(), alias);
    }

    public void newAlias() {
        this.tabbedPane.setSelectedIndex(0);
        this.editEntry(null, 0, true);
    }

    public List getResources() {
        ArrayList<ResourceViewer.ResourceWrapper> aliases = new ArrayList<ResourceViewer.ResourceWrapper>();
        for (AliasTableModel model : this.displayedTableModels) {
            for (DataAlias dataAlias : model.aliases) {
                aliases.add(new ResourceViewer.ResourceWrapper(dataAlias, dataAlias.toString(), model.label, this.isEditableResource(model.resourceIdx)));
            }
        }
        return aliases;
    }

    private void init() {
        this.tabbedPane = new JTabbedPane();
        for (int resourceIdx = 0; resourceIdx < this.resources.size(); ++resourceIdx) {
            JScrollPane sp;
            Element root = this.resources.getRoot(resourceIdx);
            boolean resourceOk = true;
            if (root == null && resourceIdx > 0) {
                resourceOk = false;
            }
            AliasTableModel tableModel = new AliasTableModel(this, resourceIdx);
            tableModel.label = "" + this.resources.get(resourceIdx);
            this.tableModels.add(tableModel);
            if (root != null) {
                List dataAliases = DataAlias.createDataAliases(root);
                for (int aliasIdx = 0; aliasIdx < dataAliases.size(); ++aliasIdx) {
                    DataAlias dataAlias = (DataAlias)dataAliases.get(aliasIdx);
                    String name = dataAlias.getName();
                    List aliases = dataAlias.getAliases();
                    tableModel.add(name, dataAlias.getLabel(), StringUtil.join(", ", aliases));
                }
            }
            JTable table = this.createTable(resourceIdx, tableModel);
            table.setAutoCreateRowSorter(true);
            table.getRowSorter().toggleSortOrder(0);
            JComponent contents = sp = new JScrollPane(table, 20, 30);
            String editableStr = "";
            if (!this.isEditableResource(resourceIdx)) {
                table.setToolTipText("Right click or double click to copy to local alias list");
                editableStr = " (non-editable)";
            } else {
                table.setToolTipText("<html>" + Msg.msg("Right click to edit or delete") + "<br>" + Msg.msg("Double click to edit") + "</html>");
            }
            String label = Msg.msg("Path: ${param1}", this.resources.get(resourceIdx) + editableStr);
            contents = GuiUtils.topCenter(GuiUtils.inset((Component)new JLabel("<html>" + label + "</html>"), 5), sp);
            if (!resourceOk) continue;
            this.displayedTableModels.add(tableModel);
            this.tabbedPane.add(this.resources.getShortName(resourceIdx), contents);
        }
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        JMenu helpMenu = new JMenu("Help");
        menuBar.add(fileMenu);
        menuBar.add(helpMenu);
        fileMenu.add(GuiUtils.makeMenuItem("New Alias", this, "newAlias"));
        fileMenu.addSeparator();
        fileMenu.add(GuiUtils.makeMenuItem("Export to Plugin", this, "exportToPlugin"));
        fileMenu.add(GuiUtils.makeMenuItem("Export Selected to Plugin", this, "exportSelectedToPlugin"));
        fileMenu.addSeparator();
        fileMenu.add(GuiUtils.makeMenuItem("Close", this, "close"));
        helpMenu.add(GuiUtils.makeMenuItem("Show Data Alias Help", this, "showHelp"));
        JPanel bottom = GuiUtils.wrap(GuiUtils.makeButton("Close", this, "close"));
        this.contents = GuiUtils.topCenterBottom(menuBar, this.tabbedPane, bottom);
        this.setMenuBar(menuBar);
    }

    private boolean isEditableResource(int resourceIdx) {
        return resourceIdx == 0;
    }

    private JTable createTable(final int resourceIdx, AliasTableModel tableModel) {
        JTable table;
        tableModel.table = table = new JTable(tableModel);
        this.tables.add(table);
        table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                AliasEditor.this.handleMouseEvent(e, table, resourceIdx);
            }
        });
        if (!this.isEditableResource(resourceIdx)) {
            return table;
        }
        table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (GuiUtils.isDeleteEvent(e)) {
                    AliasEditor.this.getTableModel(resourceIdx).remove(table.getSelectedRows());
                }
            }
        });
        table.getColumnModel().getColumn(0).setPreferredWidth(25);
        table.getColumnModel().getColumn(1).setPreferredWidth(125);
        return table;
    }

    private void handleMouseEvent(MouseEvent e, JTable table, final int resourceIdx) {
        int origRow = table.rowAtPoint(e.getPoint());
        final int row = table.convertRowIndexToModel(origRow);
        if (!SwingUtilities.isRightMouseButton(e)) {
            if (e.getClickCount() > 1) {
                if (this.isEditableResource(resourceIdx)) {
                    this.editEntry(this.getTableModel(resourceIdx), row, false);
                } else {
                    this.copyEntry(resourceIdx, row);
                }
            }
            return;
        }
        table.getSelectionModel().setSelectionInterval(origRow, origRow);
        JPopupMenu popup = new JPopupMenu();
        JMenuItem mi = null;
        if (this.isEditableResource(resourceIdx)) {
            mi = new JMenuItem("Edit Entry");
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    AliasEditor.this.editEntry(AliasEditor.this.getTableModel(resourceIdx), row, false);
                }
            });
            popup.add(mi);
            mi = new JMenuItem("Delete Entry");
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    AliasEditor.this.removeEntry(resourceIdx, row);
                }
            });
            popup.add(mi);
        } else {
            mi = new JMenuItem("Edit Alias");
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    AliasEditor.this.copyEntry(resourceIdx, row);
                }
            });
            popup.add(mi);
        }
        popup.show((Component)e.getSource(), e.getX(), e.getY());
    }

    private void editEntry(AliasTableModel tableModel, int row, boolean deleteOnCancel) {
        this.editEntry(tableModel, row, deleteOnCancel, "", "");
    }

    private void editEntry(AliasTableModel tableModel, int row, boolean deleteOnCancel, String name, String aliases) {
        boolean newEntry = tableModel == null;
        String label = "";
        if (!newEntry) {
            name = tableModel.getName(row);
            label = tableModel.getLabel(row);
            aliases = tableModel.getString(row);
        }
        aliases = StringUtil.join("\n", StringUtil.split(aliases, ",", true, true));
        JTextField nameFld = new JTextField(name, 40);
        JTextField labelFld = new JTextField(label, 40);
        final JTextArea aliasesFld = new JTextArea(aliases);
        aliasesFld.setToolTipText("<html>Enter parameter name, one per line<br>Right mouse to add current parameters</html>");
        aliasesFld.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    IdvUIManager.showParamsPopup(aliasesFld, e, "\n", false);
                }
            }
        });
        JScrollPane sp = new JScrollPane(aliasesFld, 20, 30);
        GuiUtils.tmpInsets = new Insets(4, 4, 4, 4);
        JPanel namePanel = new JPanel();
        namePanel.setLayout(new BoxLayout(namePanel, 2));
        namePanel.add(new JLabel("Name: "));
        namePanel.add(nameFld);
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new BoxLayout(labelPanel, 2));
        labelPanel.add(new JLabel("Label: "));
        labelPanel.add(labelFld);
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BoxLayout(topPanel, 3));
        topPanel.add(namePanel);
        topPanel.add(labelPanel);
        JPanel botPanel = new JPanel(new BorderLayout());
        JLabel aliasLabel = new JLabel("Enter aliases one per line:");
        aliasLabel.setBorder(BorderFactory.createEmptyBorder(4, 2, 4, 2));
        botPanel.add((Component)aliasLabel, "North");
        botPanel.add((Component)sp, "Center");
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.setPreferredSize(new Dimension(400, 300));
        mainPanel.setBorder(BorderFactory.createEmptyBorder(4, 8, 4, 8));
        mainPanel.add((Component)topPanel, "North");
        mainPanel.add((Component)botPanel, "Center");
        if (!GuiUtils.showOkCancelDialog(null, "Data Alias", mainPanel, null)) {
            if (deleteOnCancel && !newEntry) {
                this.removeEntry(tableModel, row);
            }
            return;
        }
        name = nameFld.getText().trim();
        label = labelFld.getText().trim();
        aliases = StringUtil.join(",", StringUtil.split(aliasesFld.getText(), "\n", true, true));
        if (!newEntry) {
            tableModel.set(row, name, label, aliases);
        } else {
            tableModel = this.getTableModel(0);
            tableModel.add(name, label, aliases);
        }
        this.saveAliases();
    }

    public void showHelp() {
        this.getIdvUIManager().showHelp("idv.tools.aliaseditor");
    }

    private AliasTableModel getTableModel(int index) {
        return (AliasTableModel)this.tableModels.get(index);
    }

    private JTable getTable(int index) {
        return (JTable)this.tables.get(index);
    }

    private void doCancel() {
        this.removeAll();
        this.init();
    }

    private void copyEntry(int resourceIdx, int row) {
        AliasTableModel from = this.getTableModel(resourceIdx);
        AliasTableModel to = this.getTableModel(0);
        to.add((String)from.names.get(row), (String)from.labels.get(row), (String)from.aliases.get(row));
        this.tabbedPane.setSelectedIndex(0);
        this.editEntry(to, to.getRowCount() - 1, true);
    }

    private void removeEntry(int resourceIdx, int row) {
        this.removeEntry(this.getTableModel(resourceIdx), row);
    }

    private void removeEntry(AliasTableModel from, int row) {
        from.remove(row);
        this.saveAliases();
    }

    private void saveAliases() {
        AliasTableModel from = this.getTableModel(0);
        from.saveAliases();
    }

    public void exportToPlugin() {
        int index = this.tabbedPane.getSelectedIndex();
        AliasTableModel from = this.displayedTableModels.get(index);
        from.exportToPlugin(this.getIdv().getPluginManager());
    }

    public void exportSelectedToPlugin() {
        int index = this.tabbedPane.getSelectedIndex();
        AliasTableModel from = this.displayedTableModels.get(index);
        from.exportSelectedToPlugin(this.getIdv().getPluginManager());
    }

    private static class AliasTableModel
    extends AbstractTableModel {
        String label;
        List names = new ArrayList();
        List labels = new ArrayList();
        List aliases = new ArrayList();
        int resourceIdx;
        AliasEditor editor;
        JTable table;

        public AliasTableModel(AliasEditor editor, int resourceIdx) {
            this.editor = editor;
            this.resourceIdx = resourceIdx;
        }

        public void add(String name, String label, String aliases) {
            this.names.add(name);
            this.labels.add(label);
            this.aliases.add(aliases);
            this.fireTableStructureChanged();
        }

        public void addAlias(int row, String alias) {
            String aliases = (String)this.aliases.get(row);
            aliases = aliases + "," + alias;
            this.aliases.set(row, aliases);
        }

        public void set(int row, String name, String label, String aliases) {
            this.names.set(row, name);
            this.labels.set(row, label);
            this.aliases.set(row, aliases);
            this.fireTableStructureChanged();
        }

        public String getName(int row) {
            return (String)this.names.get(row);
        }

        public String getLabel(int row) {
            return (String)this.labels.get(row);
        }

        public String getString(int row) {
            return (String)this.aliases.get(row);
        }

        private List remove(List from, int[] indices) {
            ArrayList tmp = new ArrayList();
            for (int i = 0; i < from.size(); ++i) {
                boolean isIndexIn = false;
                for (int j = 0; j < indices.length && !isIndexIn; ++j) {
                    isIndexIn = indices[j] == i;
                }
                if (isIndexIn) continue;
                tmp.add(from.get(i));
            }
            return tmp;
        }

        public void remove(int[] rows) {
            if (this.names.size() == 0) {
                return;
            }
            this.names = this.remove(this.names, rows);
            this.labels = this.remove(this.labels, rows);
            this.aliases = this.remove(this.aliases, rows);
            this.fireTableStructureChanged();
            int min = Integer.MAX_VALUE;
            for (int i = 0; i < rows.length; ++i) {
                if (rows[i] >= min) continue;
                min = rows[i];
            }
            while (min >= this.names.size()) {
                --min;
            }
            if (min >= 0) {
                this.editor.getTable(this.resourceIdx).setRowSelectionInterval(min, min);
            }
        }

        public void remove(int row) {
            this.names.remove(row);
            this.labels.remove(row);
            this.aliases.remove(row);
            this.fireTableStructureChanged();
        }

        public int indexOfName(String name) {
            return this.names.indexOf(name);
        }

        private void saveAliases() {
            Document doc = XmlUtil.makeDocument();
            Element root = doc.createElement("aliases");
            for (int i = 0; i < this.names.size(); ++i) {
                String name = (String)this.names.get(i);
                String aliases = (String)this.aliases.get(i);
                String label = (String)this.labels.get(i);
                Element aliasNode = doc.createElement("alias");
                aliasNode.setAttribute("name", name);
                aliasNode.setAttribute("label", label);
                aliasNode.setAttribute("aliases", aliases);
                root.appendChild(aliasNode);
            }
            try {
                this.editor.resources.setWritableDocument(doc, root);
                this.editor.resources.writeWritable();
                DataAlias.reInit(this.editor.resources);
            }
            catch (Exception exc) {
                LogUtil.printException(log_, "writing aliases xml", exc);
            }
        }

        private Element makeXml(boolean selected) {
            Document doc = XmlUtil.makeDocument();
            Element root = doc.createElement("aliases");
            int[] indices = null;
            if (selected) {
                indices = this.table.getSelectedRows();
            }
            for (int i = 0; i < (indices != null ? indices.length : this.names.size()); ++i) {
                int index = indices != null ? indices[i] : i;
                String name = (String)this.names.get(index);
                String aliases = (String)this.aliases.get(index);
                String label = (String)this.labels.get(index);
                Element aliasNode = doc.createElement("alias");
                aliasNode.setAttribute("name", name);
                aliasNode.setAttribute("label", label);
                aliasNode.setAttribute("aliases", aliases);
                root.appendChild(aliasNode);
            }
            return root;
        }

        private void exportToPlugin(PluginManager pluginManager) {
            Element root = this.makeXml(false);
            pluginManager.addText(XmlUtil.toString(root), "aliases.xml");
        }

        private void exportSelectedToPlugin(PluginManager pluginManager) {
            Element root = this.makeXml(true);
            pluginManager.addText(XmlUtil.toString(root), "aliases.xml");
        }

        @Override
        public int getRowCount() {
            return this.names.size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 1) {
                this.labels.set(rowIndex, aValue.toString());
            } else {
                this.aliases.set(rowIndex, aValue.toString());
            }
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (column == 0) {
                return this.names.get(row);
            }
            if (column == 1) {
                return this.labels.get(row);
            }
            if (column == 2) {
                return this.aliases.get(row);
            }
            return "";
        }

        @Override
        public String getColumnName(int column) {
            return column == 0 ? "Name" : (column == 1 ? "Description" : "Aliases");
        }
    }
}

