/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.test;

import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import ucar.unidata.data.DataCancelException;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataManager;
import ucar.unidata.data.DataSelection;
import ucar.unidata.data.DataSource;
import ucar.unidata.data.DerivedDataChoice;
import ucar.unidata.idv.ControlDescriptor;
import ucar.unidata.idv.DisplayControl;
import ucar.unidata.idv.IdvManager;
import ucar.unidata.idv.IntegratedDataViewer;
import ucar.unidata.idv.ViewManager;
import ucar.unidata.util.CacheManager;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.Trace;
import visad.Data;

public class TestManager
extends IdvManager {
    private boolean didIsl = false;
    public static final String PREF_TEST_ONLYTHESE = "idv.test.onlythese";
    public static final String PREF_TEST_NOTTHESE = "idv.test.notthese";

    public TestManager(IntegratedDataViewer idv) {
        super(idv);
    }

    void removeDisplayControls(List dcs) {
        for (int i = 0; i < dcs.size(); ++i) {
            try {
                ((DisplayControl)dcs.get(i)).doRemove();
                continue;
            }
            catch (Throwable exc) {
                LogUtil.logException("testAll", exc);
            }
        }
    }

    private void evaluateAllDataChoices() throws Exception {
        List dataSources = this.getIdv().getDataSources();
        for (int i = 0; i < dataSources.size(); ++i) {
            DataSource dataSource = (DataSource)dataSources.get(i);
            this.testAll(dataSource, false);
        }
    }

    public void testAll(DataSource dataSource, boolean createDisplays) throws Exception {
        LogUtil.setTestMode(true);
        if (DataManager.isFormulaDataSource(dataSource)) {
            return;
        }
        System.err.println("Evaluating: " + dataSource.getClass().getName() + " " + dataSource);
        List choices = dataSource.getDataChoices();
        ArrayList descriptors = new ArrayList(this.getIdv().getControlDescriptors());
        ArrayList<DisplayControl> dcs = new ArrayList<DisplayControl>();
        List times = dataSource.getAllDateTimes();
        DataSelection dataSelection = null;
        if (times != null && times.size() > 0) {
            dataSelection = new DataSelection(Misc.newList(times.get(0)));
        }
        for (int cIdx = 0; cIdx < choices.size() && descriptors.size() != 0; ++cIdx) {
            DataChoice dataChoice = (DataChoice)choices.get(cIdx);
            if (!createDisplays) {
                String lbl = "\tdata:" + dataChoice + " " + (dataChoice instanceof DerivedDataChoice ? "(derived) " : "");
                try {
                    Data data = dataChoice.getData(dataSelection);
                    CacheManager.clearCache();
                    if (data == null) {
                        System.err.println(lbl + "  **** returned null");
                        continue;
                    }
                    System.err.println(lbl + "  **** ok " + data.getClass().getName());
                }
                catch (DataCancelException data) {
                }
                catch (Throwable exc) {
                    System.err.println(lbl + "  **** exception: " + exc);
                }
                continue;
            }
            List l = ControlDescriptor.getApplicableControlDescriptors(dataChoice.getCategories(), descriptors);
            for (int j = 0; j < l.size(); ++j) {
                if (j == 0) {
                    System.err.println("\tData: " + dataChoice.getName() + " " + dataChoice.getDescription());
                }
                ControlDescriptor cd = (ControlDescriptor)l.get(j);
                descriptors.remove(cd);
                DisplayControl dc = this.getIdv().doMakeControl(dataChoice, cd, NULL_STRING);
                if (dc == null) continue;
                dcs.add(dc);
                if (dcs.size() <= 4) continue;
                this.removeDisplayControls(dcs);
                dcs = new ArrayList();
            }
        }
        this.removeDisplayControls(dcs);
    }

    public void printLog() {
        System.out.println(Trace.buff.toString());
        Trace.buff = new StringBuffer();
    }

    public void createTestArchive() {
        String lastArchiveName = (String)this.getStateManager().getPreference("test.archivename", "test");
        String lastArchiveDir = (String)this.getStateManager().getPreference("test.archivedir", null);
        JFileChooser fileChooser = lastArchiveDir != null ? new JFileChooser(lastArchiveDir) : new JFileChooser();
        fileChooser.setFileSelectionMode(1);
        fileChooser.setControlButtonsAreShown(false);
        JTextField nameFld = new JTextField();
        if (lastArchiveName != null) {
            nameFld.setText(lastArchiveName);
        }
        final JTextArea descFld = new JTextArea(7, 40);
        if (lastArchiveName != null && lastArchiveDir != null) {
            String descFile = IOUtil.joinDir(IOUtil.joinDir(new File(lastArchiveDir), lastArchiveName), lastArchiveName + ".txt");
            System.err.println("checking last desc:" + descFile);
            String lastDescription = IOUtil.readContents(descFile, this.getIdv().getClass(), null);
            if (lastDescription != null) {
                descFld.setText(lastDescription);
            }
        }
        JCheckBox islCbx = new JCheckBox("Generate ISL", false);
        JScrollPane descScroller = GuiUtils.makeScrollPane(descFld, 100, 40);
        JPanel contents = GuiUtils.doLayout(new Component[]{GuiUtils.rLabel(" Archive name: "), GuiUtils.inset((Component)nameFld, 6), GuiUtils.top(GuiUtils.rLabel(" Description: ")), GuiUtils.inset((Component)descScroller, 6), islCbx, GuiUtils.filler()}, 2, GuiUtils.WT_NY, GuiUtils.WT_N);
        JPanel filePanel = GuiUtils.topCenter(new JLabel("Directory to write archive directory to:"), fileChooser);
        if (!GuiUtils.showOkCancelDialog(null, "Test archive", contents = GuiUtils.inset((Component)GuiUtils.vbox(contents, new JLabel(" "), filePanel), 6), null, null)) {
            return;
        }
        final String archiveName = nameFld.getText().trim();
        File chosenDirectory = fileChooser.getSelectedFile();
        if (chosenDirectory == null) {
            chosenDirectory = fileChooser.getCurrentDirectory();
        }
        if (chosenDirectory == null) {
            return;
        }
        chosenDirectory = new File(IOUtil.joinDir(chosenDirectory, archiveName));
        IOUtil.makeDir(chosenDirectory);
        File archiveFile = new File(IOUtil.joinDir(chosenDirectory, archiveName + (islCbx.isSelected() ? ".isl" : ".jnlp")));
        if (archiveFile.exists()) {
            if (!GuiUtils.showYesNoDialog(null, "Directory: " + archiveName + " exists. Do you want to delete everything in that directory and  create a new  archive?", "Test archive exists")) {
                return;
            }
            File[] files = chosenDirectory.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].toString().endsWith(".jpg")) continue;
                files[i].delete();
            }
            IOUtil.makeDir(chosenDirectory);
        }
        final File directory = chosenDirectory;
        String desc = descFld.getText().trim();
        this.getStateManager().putPreference("test.archivename", archiveName);
        this.getStateManager().writePreference("test.archivedir", directory.getParent().toString());
        final boolean doIsl = islCbx.isSelected();
        Misc.run(new Runnable(){

            @Override
            public void run() {
                TestManager.this.showWaitCursor();
                boolean ok = true;
                try {
                    ok = TestManager.this.writeTestArchive(archiveName, directory, true, doIsl);
                    String descText = descFld.getText().trim();
                    if (ok && descText.length() > 0) {
                        IOUtil.writeFile(IOUtil.joinDir(directory, archiveName + ".txt"), descText);
                    }
                }
                catch (Exception exc) {
                    ok = false;
                    IdvManager.logException("Writing archive", exc);
                }
                TestManager.this.showNormalCursor();
                if (ok) {
                    LogUtil.userMessage("Test archive " + archiveName + " written to: " + directory);
                }
            }
        });
    }

    protected boolean writeTestArchive(String archiveName, File directory, boolean writeBundle, boolean doIsl) {
        try {
            int i;
            ViewManager viewManager;
            int i2;
            File imagePath = null;
            if (directory != null) {
                imagePath = new File(IOUtil.joinDir(directory, archiveName));
                archiveName = IOUtil.joinDir(directory, archiveName);
            }
            if (writeBundle) {
                String bundleName = archiveName + (doIsl ? ".isl" : ".jnlp");
                if (!this.getPersistenceManager().doSave(bundleName)) {
                    return false;
                }
            }
            if (doIsl) {
                return true;
            }
            List displayControls = this.getIdv().getDisplayControls();
            List<ViewManager> viewManagers = this.getVMManager().getViewManagers();
            for (int i3 = 0; i3 < viewManagers.size(); ++i3) {
                ViewManager viewManager2 = viewManagers.get(i3);
                if (viewManager2.getDisplayWindow() == null) continue;
                viewManager2.getDisplayWindow().setVisible(false);
            }
            ArrayList<DisplayControl> goodDisplayControls = new ArrayList<DisplayControl>();
            for (i2 = 0; i2 < displayControls.size(); ++i2) {
                DisplayControl dc = (DisplayControl)displayControls.get(i2);
                JFrame frame = dc.getWindow();
                if (frame == null || !frame.isShowing()) continue;
                goodDisplayControls.add(dc);
                frame.setVisible(false);
            }
            for (i2 = 0; i2 < viewManagers.size(); ++i2) {
                String vmArchive = archiveName + "_view_" + (i2 + 1);
                viewManager = viewManagers.get(i2);
                if (viewManager.getDisplayWindow() == null) continue;
                viewManager.getDisplayWindow().setLocation(50, 50);
                viewManager.getDisplayWindow().setVisible(true);
                Misc.sleep(100L);
                viewManager.writeTestArchive(vmArchive);
                viewManager.getDisplayWindow().setVisible(false);
            }
            int displayCnt = 0;
            for (i = 0; i < goodDisplayControls.size(); ++i) {
                DisplayControl dc = (DisplayControl)goodDisplayControls.get(i);
                JFrame frame = dc.getWindow();
                if (frame == null) continue;
                frame.setLocation(50, 50);
                frame.setVisible(true);
                Misc.sleep(100L);
                String displayArchiveName = archiveName + "_control_" + ++displayCnt;
                dc.writeTestArchive(displayArchiveName);
                frame.setVisible(false);
            }
            if (!LogUtil.getTestMode()) {
                for (i = 0; i < viewManagers.size(); ++i) {
                    viewManager = viewManagers.get(i);
                    if (viewManager.getDisplayWindow() == null) continue;
                    viewManager.getDisplayWindow().setVisible(true);
                }
            }
        }
        catch (Exception exc) {
            TestManager.logException("Writing archive", exc);
            return false;
        }
        return true;
    }

    public void doTest() {
        LogUtil.setTestMode(true);
        try {
            int i;
            for (i = 0; i < this.getArgsManager().argXidvFiles.size(); ++i) {
                this.getPersistenceManager().decodeXmlFile((String)this.getArgsManager().argXidvFiles.get(i), false);
            }
            for (i = 0; i < this.getArgsManager().b64Bundles.size(); ++i) {
                this.getPersistenceManager().loadB64Bundle((String)this.getArgsManager().b64Bundles.get(i));
            }
            for (i = 0; i < this.getArgsManager().scriptingFiles.size(); ++i) {
                String scriptFile = (String)this.getArgsManager().scriptingFiles.get(i);
                this.getIdv().getImageGenerator().processScriptFile(scriptFile);
                this.didIsl = true;
            }
        }
        catch (Throwable exc) {
            System.err.println("Error:" + exc);
            exc.printStackTrace();
            System.exit(1);
        }
        Misc.run(this, "waitAndTest");
    }

    public void waitAndTest() {
        if (!this.didIsl) {
            TestManager.waitUntilDisplaysAreDone(this.getIdvUIManager());
        }
        this.doTestInner();
        System.exit(0);
    }

    private void doTestInner() {
        try {
            String testArchive = this.getArgsManager().testArchive;
            String testDir = this.getArgsManager().testDir;
            if (this.getArgsManager().testEval) {
                this.evaluateAllDataChoices();
            }
            if (testArchive != null) {
                this.writeTestArchive(testArchive, new File(testDir), false, false);
            }
        }
        catch (Exception exc) {
            System.err.println("Error:" + exc);
            exc.printStackTrace();
            System.exit(1);
        }
        if (LogUtil.anyErrors()) {
            System.exit(1);
        }
    }

    public static void gc() {
        Thread t = Thread.currentThread();
        for (int i = 0; i < 5; ++i) {
            Runtime.getRuntime().gc();
            try {
                Thread.sleep(400L);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void startTrace() {
        Trace.setFilters((String)this.getStore().get(PREF_TEST_NOTTHESE), (String)this.getStore().get(PREF_TEST_ONLYTHESE));
        Trace.startTrace();
        System.out.println("****** START ****** ");
    }

    public void changeFilters() {
        String[] filters = Trace.changeFilters();
        if (filters == null) {
            return;
        }
        this.getStore().put(PREF_TEST_NOTTHESE, (Object)filters[0]);
        this.getStore().put(PREF_TEST_ONLYTHESE, (Object)filters[1]);
    }

    public void stopTrace() {
        Trace.stopTrace();
    }

    public void startDebug() {
        LogUtil.setDebugMode(true);
        System.out.println("****** START DEBUG ****** ");
    }

    public void stopDebug() {
        LogUtil.setDebugMode(false);
        System.out.println("****** END DEBUG ****** ");
    }

    public void printTrace() {
        System.out.println("****** TRACE ****** ");
        Trace.printMsgs();
    }

    public void printCacheStats() {
        CacheManager.printStats();
    }

    public void testDisplayControlHelp() {
        List controlDescriptors = this.getIdv().getControlDescriptors();
        for (int i = 0; i < controlDescriptors.size(); ++i) {
            ControlDescriptor controlDescriptor = (ControlDescriptor)controlDescriptors.get(i);
        }
    }

    public void dumpThreads() {
        ThreadGroup root = Thread.currentThread().getThreadGroup().getParent();
        while (root.getParent() != null) {
            root = root.getParent();
        }
        TestManager.visitThreads(root, 0);
    }

    public static void visitThreads(ThreadGroup group, int level) {
        int numThreads = group.activeCount();
        Thread[] threads = new Thread[numThreads * 2];
        numThreads = group.enumerate(threads, false);
        for (int i = 0; i < numThreads; ++i) {
            Thread thread = threads[i];
            System.err.println("\n************************************************\n" + thread);
            thread.dumpStack();
        }
        int numGroups = group.activeGroupCount();
        ThreadGroup[] groups = new ThreadGroup[numGroups * 2];
        numGroups = group.enumerate(groups, false);
        for (int i = 0; i < numGroups; ++i) {
            TestManager.visitThreads(groups[i], level + 1);
        }
    }
}

