/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.test;

import java.io.File;
import java.io.InputStream;
import java.util.StringTokenizer;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.PatternFileFilter;

public class RunTest {
    public static File getTestDirectory() {
        String cp = System.getProperty("java.class.path");
        if (cp == null) {
            System.err.println("No classpath found");
            return null;
        }
        StringTokenizer st = new StringTokenizer(cp, ":");
        while (st.hasMoreElements()) {
            String path = (String)st.nextElement();
            File dir = new File(path + "/ucar/unidata/idv/test");
            if (!dir.exists()) continue;
            return dir;
        }
        return null;
    }

    public static void main(String[] args) {
        File testDirectory = null;
        testDirectory = args.length > 0 ? new File(args[0]) : RunTest.getTestDirectory();
        if (testDirectory == null) {
            System.err.println("No  testDirectory given");
            return;
        }
        File[] files = testDirectory.listFiles(new PatternFileFilter(".*\\.xidv$", false));
        if (files.length == 0) {
            System.err.println("No .xidv files found in: " + testDirectory);
            return;
        }
        boolean inError = false;
        for (int i = 0; i < files.length; ++i) {
            try {
                File f = files[i];
                String imageName = f.getName();
                imageName = imageName.substring(0, imageName.lastIndexOf("."));
                String newImageName = "new_" + imageName;
                String[] cmd = new String[]{"java", "ucar.unidata.idv.DefaultIdv", "-test", f.getPath(), "-testimage", newImageName};
                System.err.println(f.getPath());
                Process p = Runtime.getRuntime().exec(cmd, null, testDirectory);
                p.waitFor();
                System.err.println(RunTest.getOutput(p));
                if (p.exitValue() == 0) {
                    if (RunTest.checkImage(testDirectory, imageName + ".jpg", newImageName)) continue;
                    inError = true;
                    continue;
                }
                inError = true;
                System.err.println("Error evaluating " + f.getPath());
                System.err.println(RunTest.getOutput(p));
                continue;
            }
            catch (Exception exc) {
                System.err.println("Error:" + exc);
                System.exit(1);
            }
        }
        if (inError) {
            System.exit(1);
        }
        System.err.println("No errors");
    }

    public static String getOutput(Process p) throws Exception {
        InputStream stderr = p.getErrorStream();
        String errstr = IOUtil.readContents(stderr);
        stderr.close();
        InputStream stdout = p.getInputStream();
        String outstr = IOUtil.readContents(stdout);
        stdout.close();
        return errstr + outstr;
    }

    public static boolean checkImage(File testDirectory, String imageName, String newImageName) throws Exception {
        File image = new File(testDirectory.getPath() + File.separator + imageName);
        File newImage = new File(testDirectory.getPath() + File.separator + newImageName);
        if (!image.exists()) {
            return true;
        }
        if (!newImage.exists()) {
            return true;
        }
        String[] cmd = new String[]{"diff", image.getPath(), newImage.getPath()};
        Process p = Runtime.getRuntime().exec(cmd, null);
        p.waitFor();
        if (p.exitValue() == 0) {
            return true;
        }
        System.err.println("images differ: " + image.getPath() + "\n" + "               " + newImage.getPath());
        return false;
    }
}

