/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.publish;

import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ucar.unidata.idv.IdvManager;
import ucar.unidata.idv.IdvResourceManager;
import ucar.unidata.idv.IntegratedDataViewer;
import ucar.unidata.idv.ViewManager;
import ucar.unidata.idv.publish.IdvPublisher;
import ucar.unidata.idv.ui.ImageGenerator;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.ObjectListener;
import ucar.unidata.util.TwoFacedObject;
import ucar.unidata.xml.XmlResourceCollection;
import ucar.unidata.xml.XmlUtil;

public class PublishManager
extends IdvManager {
    public static final String TAG_PUBLISHER = "publisher";
    public static final String ATTR_CLASS = "class";
    public static final String ATTR_NAME = "name";
    private List<IdvPublisher> publishers;
    private List<TwoFacedObject> types = new ArrayList<TwoFacedObject>();
    private List<JComboBox> comboBoxes = new ArrayList<JComboBox>();
    private JComboBox myPublisherBox;
    private Hashtable<String, JComboBox> selectors = new Hashtable();

    public PublishManager(IntegratedDataViewer idv) {
        super(idv);
        XmlResourceCollection resources = this.getIdv().getResourceManager().getXmlResources(IdvResourceManager.RSC_PUBLISHERS);
        this.publishers = new ArrayList<IdvPublisher>();
        for (int resourceIdx = 0; resourceIdx < resources.size(); ++resourceIdx) {
            String xml = resources.read(resourceIdx);
            if (xml == null) continue;
            try {
                List tmp = (List)this.getIdv().getEncoderForRead().toObject(xml, false);
                if (tmp == null) {
                    return;
                }
                for (IdvPublisher publisher : tmp) {
                    publisher.setLocal(resources.isWritable(resourceIdx));
                    publisher.setIdv(this.getIdv());
                }
                this.publishers.addAll(tmp);
                continue;
            }
            catch (Exception exc) {
                exc.printStackTrace();
                LogUtil.userErrorMessage("There was a problem loading the publishers file:\n" + resources.get(resourceIdx) + "\nYou should update any publisher plugin or delete the above file");
            }
        }
    }

    public void initMenu(final JMenu menu) {
        menu.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent e) {
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuSelected(MenuEvent e) {
                menu.removeAll();
                PublishManager.this.makeMenu(menu);
            }
        });
    }

    public JComboBox getSelector(String fixedId) {
        JComboBox selector = this.selectors.get(fixedId);
        if (selector == null) {
            selector = this.makeSelector();
            if (selector == null) {
                return null;
            }
            this.selectors.put(fixedId, selector);
        }
        return selector;
    }

    public JComboBox makeSelector() {
        if (!this.isPublishingEnabled()) {
            return null;
        }
        JComboBox cbx = new JComboBox();
        this.comboBoxes.add(cbx);
        this.updatePublishers(false);
        return cbx;
    }

    public void publishContent(String file, ViewManager fromViewmanager, JComboBox box) {
        if (box == null || box.getSelectedIndex() == 0) {
            return;
        }
        IdvPublisher publisher = (IdvPublisher)box.getSelectedItem();
        publisher.publishContent(file, fromViewmanager);
    }

    public String publishFile(String file) {
        JPanel contents;
        if (this.myPublisherBox == null) {
            this.myPublisherBox = this.makeSelector();
        }
        if (!GuiUtils.showOkCancelDialog(null, "Select a publisher", GuiUtils.inset((Component)(contents = GuiUtils.vbox(new JLabel("Publish the file: " + file), GuiUtils.inset((Component)this.myPublisherBox, 5))), 5), null)) {
            return null;
        }
        if (this.myPublisherBox.getSelectedIndex() == 0) {
            return null;
        }
        IdvPublisher publisher = (IdvPublisher)this.myPublisherBox.getSelectedItem();
        return publisher.publishContent(file, null);
    }

    public void publishIslImage(ImageGenerator imageGenerator, Element tag, Image image) {
        String id = XmlUtil.getAttribute((Node)tag, "publisherid", (String)null);
        for (IdvPublisher publisher : this.publishers) {
            if (id != null && !Misc.equals(id, publisher.getName())) continue;
            publisher.publishIslImage(tag, image);
        }
    }

    private void updatePublishers(boolean andWrite) {
        if (andWrite) {
            ArrayList<IdvPublisher> localPublishers = new ArrayList<IdvPublisher>();
            for (IdvPublisher publisher : this.publishers) {
                if (!publisher.getLocal()) continue;
                localPublishers.add(publisher);
            }
            this.getIdv().getStore().putEncodedFile("publishers.xml", localPublishers);
        }
        for (JComboBox publishCbx : this.comboBoxes) {
            Object selected = publishCbx.getSelectedItem();
            Vector<String> items = new Vector<String>();
            items.add("-Select Publisher-");
            items.addAll(this.getIdv().getPublishManager().getPublishers());
            GuiUtils.setListData(publishCbx, items);
            if (selected == null || !items.contains(selected)) continue;
            publishCbx.setSelectedItem(selected);
        }
    }

    public void makeMenu(JMenu menu) {
        JMenu newMenu = new JMenu("New");
        menu.add(newMenu);
        for (TwoFacedObject tfo : this.types) {
            JMenuItem mi = new JMenuItem(tfo.toString());
            newMenu.add(mi);
            mi.addActionListener(new ObjectListener(tfo.getId()){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    try {
                        IdvPublisher newPublisher = (IdvPublisher)this.theObject.getClass().newInstance();
                        newPublisher.setLocal(true);
                        newPublisher.setIdv(PublishManager.this.getIdv());
                        if (newPublisher.doInitNew()) {
                            PublishManager.this.publishers.add(newPublisher);
                            PublishManager.this.updatePublishers(true);
                        }
                    }
                    catch (Exception exc) {
                        IdvManager.logException("Creating publisher", exc);
                    }
                }
            });
        }
        if (this.publishers.size() > 0) {
            JMenu configMenu = new JMenu("Configure");
            JMenu deleteMenu = new JMenu("Delete");
            boolean didone = false;
            for (IdvPublisher publisher : this.publishers) {
                if (!publisher.getLocal()) continue;
                deleteMenu.add(GuiUtils.makeMenuItem(publisher.toString(), this, "deletePublisher", publisher));
                configMenu.add(GuiUtils.makeMenuItem(publisher.toString(), this, "configurePublisher", publisher));
                didone = true;
            }
            if (didone) {
                menu.add(configMenu);
                menu.add(deleteMenu);
            }
        }
    }

    public void configurePublisher(IdvPublisher publisher) {
        publisher.configure();
        this.updatePublishers(true);
    }

    public void deletePublisher(IdvPublisher publisher) {
        this.publishers.remove(publisher);
        this.updatePublishers(true);
    }

    public void newPublisher() {
    }

    public boolean isPublishingEnabled() {
        return this.types.size() > 0;
    }

    public boolean publishCheck() {
        if (!this.isPublishingEnabled()) {
            LogUtil.userMessage("No publishing available");
            return false;
        }
        return true;
    }

    public IdvPublisher getPublisher() {
        return this.publishers.get(0);
    }

    public void publishObject(String desc, Object object) {
        try {
            this.publishXml(desc, this.getIdv().getEncoderForWrite().toElement(object), ".xidv");
        }
        catch (Exception exc) {
            PublishManager.logException("Publishing " + desc, exc);
        }
    }

    public void publishXml(String desc, Element root) {
        this.publishXml(desc, root, ".xml");
    }

    public void publishXml(String desc, Element root, String fileExt) {
        try {
            String xml = XmlUtil.toString(root);
            String uid = Misc.getUniqueId();
            String tail = uid + fileExt;
            String file = IOUtil.joinDir(this.getStore().getUserTmpDirectory(), tail);
            IOUtil.writeFile(file, xml);
            this.doPublish("Publish " + desc, file);
        }
        catch (Exception exc) {
            PublishManager.logException("Publishing " + desc, exc);
        }
    }

    public void publishMessage() {
        this.publishMessage(null);
    }

    public void publishMessage(String properties) {
        this.doPublish("Publish message", null, properties);
    }

    public void publishState() {
        this.publishState(null);
    }

    public void publishState(String properties) {
        String uid = Misc.getUniqueId();
        String tail = uid + ".jnlp";
        String file = IOUtil.joinDir(this.getStore().getUserTmpDirectory(), tail);
        this.getPersistenceManager().doSave(file);
        this.doPublish("Publish bundle file", file, properties);
    }

    public void doPublish(String title, String filePath) {
        this.doPublish(title, filePath, null);
    }

    public void doPublish(String title, String filePath, String properties) {
        if (!this.publishCheck()) {
            return;
        }
    }

    public void initPublisher() {
        try {
            XmlResourceCollection resources = this.getIdv().getResourceManager().getXmlResources(IdvResourceManager.RSC_PUBLISHERTYPES);
            for (int resourceIdx = 0; resourceIdx < resources.size(); ++resourceIdx) {
                Element root = resources.getRoot(resourceIdx);
                if (root == null) continue;
                this.types.addAll(PublishManager.getPublisherTypes(this.getIdv(), root));
            }
        }
        catch (Exception exc) {
            PublishManager.logException("Initializing publishers", exc);
        }
    }

    public static List<TwoFacedObject> getPublisherTypes(IntegratedDataViewer idv, Element root) {
        ArrayList<TwoFacedObject> publisherTypes = new ArrayList<TwoFacedObject>();
        List nodes = XmlUtil.findChildren(root, TAG_PUBLISHER);
        for (int i = 0; i < nodes.size(); ++i) {
            try {
                Element child = (Element)nodes.get(i);
                Class publisherClass = Misc.findClass(XmlUtil.getAttribute(child, ATTR_CLASS));
                if (publisherClass == null) {
                    throw new IllegalArgumentException("Could not load publisher class:" + XmlUtil.getAttribute(child, ATTR_CLASS));
                }
                Constructor ctor = Misc.findConstructor(publisherClass, new Class[]{IntegratedDataViewer.class, Element.class});
                if (ctor == null) continue;
                Object obj = ctor.newInstance(idv, child);
                IdvPublisher idvPublisher = (IdvPublisher)ctor.newInstance(idv, child);
                publisherTypes.add(new TwoFacedObject((Object)XmlUtil.getAttribute(child, ATTR_NAME), idvPublisher));
                continue;
            }
            catch (Exception exc) {
                LogUtil.logException("Creating publisher client", exc);
            }
        }
        return publisherTypes;
    }

    public List getPublishers() {
        return this.publishers;
    }
}

