/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.flythrough;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.JComponent;
import ucar.unidata.idv.control.ReadoutInfo;
import ucar.unidata.idv.flythrough.Flythrough;
import ucar.unidata.idv.flythrough.FlythroughDecorator;
import ucar.unidata.idv.flythrough.FlythroughPoint;
import ucar.unidata.util.GuiUtils;
import ucar.visad.Util;
import ucar.visad.quantities.CommonUnits;
import visad.Real;
import visad.Unit;

public class WeatherDecorator
extends FlythroughDecorator {
    private double precipLevel = 0.0;
    private double temperature = Double.NaN;
    private Image rainIcon;
    private Image snowIcon;

    public WeatherDecorator() {
    }

    public WeatherDecorator(Flythrough flythrough) {
        super(flythrough);
    }

    @Override
    public String getName() {
        return "raindrops and weather";
    }

    @Override
    public void handleReadout(FlythroughPoint pt, List<ReadoutInfo> samples) throws Exception {
        this.precipLevel = 0.0;
        this.temperature = Double.NaN;
        for (ReadoutInfo info : samples) {
            String name;
            Real r = info.getReal();
            if (r == null) continue;
            Unit unit = info.getUnit();
            if (unit == null) {
                unit = r.getUnit();
            }
            if (((name = Util.cleanTypeName(r.getType())).toLowerCase().indexOf("precipitation") >= 0 || name.toLowerCase().indexOf("rain") >= 0) && Unit.canConvert(unit, CommonUnits.MILLIMETER)) {
                this.precipLevel = r.getValue(CommonUnits.MILLIMETER);
                continue;
            }
            if (!Unit.canConvert(unit, CommonUnits.CELSIUS)) continue;
            this.temperature = r.getValue(CommonUnits.CELSIUS);
        }
    }

    @Override
    public boolean paintDashboard(Graphics2D g, JComponent comp) {
        if (this.precipLevel > 0.0) {
            Rectangle b = comp.getBounds();
            int cv = 255 - (int)(255.0 * (Math.min(this.precipLevel, 100.0) / 100.0));
            Color c = new Color(cv, cv, cv);
            g.setColor(c);
            if (this.rainIcon == null) {
                this.snowIcon = GuiUtils.getImage("/auxdata/ui/icons/snowflake.gif", this.getClass());
                this.rainIcon = GuiUtils.getImage("/auxdata/ui/icons/drops.gif", this.getClass());
            }
            Image icon = this.temperature == this.temperature && this.temperature < 0.0 ? this.snowIcon : this.rainIcon;
            int i = 0;
            while ((double)i < this.precipLevel * 10.0) {
                int x = (int)(Math.random() * (double)b.width) - icon.getWidth(null);
                int y = (int)(Math.random() * (double)b.height) - icon.getHeight(null);
                g.drawImage(icon, x, y, null);
                ++i;
            }
            return true;
        }
        return false;
    }
}

