/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.flythrough;

import java.util.ArrayList;
import java.util.List;
import org.jfree.data.xy.XYSeries;
import ucar.unidata.util.Misc;
import ucar.unidata.util.Range;
import visad.Real;
import visad.Unit;
import visad.VisADException;
import visad.georef.EarthLocation;

public class SampleInfo {
    private Unit unit;
    private XYSeries series;
    private String name;
    private Range range;
    private List<Real> values = new ArrayList<Real>();
    private List<EarthLocation> locations = new ArrayList<EarthLocation>();

    public SampleInfo(String name, Unit unit, Range range) {
        this.name = name;
        this.unit = unit;
        this.range = range;
        String unitSuffix = "";
        if (unit != null) {
            unitSuffix = " [" + unit + "]";
        }
        this.series = new XYSeries((Comparable)((Object)(name + unitSuffix)));
    }

    public void add(Real r, EarthLocation loc) throws VisADException {
        double v = this.unit == null ? r.getValue() : r.getValue(this.unit);
        this.series.add((double)this.values.size(), v);
        this.values.add(r);
        this.locations.add(loc);
    }

    public boolean equals(Object o) {
        if (!(o instanceof SampleInfo)) {
            return false;
        }
        return Misc.equals(this.name, ((SampleInfo)o).name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public void setUnit(Unit value) {
        this.unit = value;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public void setName(String value) {
        this.name = value;
    }

    public String getName() {
        return this.name;
    }

    public void setValues(List<Real> value) {
        this.values = value;
    }

    public List<Real> getValues() {
        return this.values;
    }

    public void setLocations(List<EarthLocation> value) {
        this.locations = value;
    }

    public List<EarthLocation> getLocations() {
        return this.locations;
    }

    public void setRange(Range value) {
        this.range = value;
    }

    public Range getRange() {
        return this.range;
    }

    public void setSeries(XYSeries value) {
        this.series = value;
    }

    public XYSeries getSeries() {
        return this.series;
    }
}

