/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.flythrough;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.util.HashSet;
import java.util.List;
import javax.swing.JComponent;
import ucar.unidata.idv.control.ReadoutInfo;
import ucar.unidata.idv.flythrough.Flythrough;
import ucar.unidata.idv.flythrough.FlythroughDecorator;
import ucar.unidata.idv.flythrough.FlythroughPoint;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.Misc;

public class ImageDecorator
extends FlythroughDecorator {
    private Image backgroundImage;
    private String imageUrl;
    private ReadoutInfo imageReadout;
    private HashSet fetchedImages = new HashSet();

    public ImageDecorator() {
    }

    public ImageDecorator(Flythrough flythrough) {
        super(flythrough);
    }

    @Override
    public void handleReadout(FlythroughPoint pt, List<ReadoutInfo> samples) throws Exception {
        String newImageUrl = null;
        this.imageReadout = null;
        for (ReadoutInfo info : samples) {
            if (info.getImageUrl() == null) continue;
            newImageUrl = info.getImageUrl();
            this.imageReadout = info;
        }
        if (!Misc.equals(newImageUrl, this.imageUrl)) {
            this.imageUrl = newImageUrl;
            if (this.imageUrl != null) {
                if (!this.fetchedImages.contains(this.imageUrl)) {
                    this.fetchedImages.add(this.imageUrl);
                    Misc.run(this, "fetchBackgroundImage", this.imageUrl);
                }
            } else {
                this.backgroundImage = null;
            }
        }
    }

    public void fetchBackgroundImage(String url) {
        Image image = GuiUtils.getImage(this.imageUrl, this.getClass());
        if (image != null) {
            image.getWidth(this.flythrough);
            if (Misc.equals(url, this.imageUrl)) {
                this.backgroundImage = image;
                this.flythrough.updateDashboard();
            }
        }
    }

    @Override
    public String getName() {
        return "background images";
    }

    @Override
    public boolean paintDashboard(Graphics2D g2, JComponent comp) {
        Image image = this.backgroundImage;
        if (image != null) {
            Rectangle b = comp.getBounds();
            int imageHeight = image.getHeight(null);
            int imageWidth = image.getWidth(this.flythrough);
            if (imageHeight > 0) {
                double scale = (double)b.width / (double)imageWidth;
                AffineTransform oldTransform = g2.getTransform();
                g2.scale(scale, scale);
                g2.drawImage(image, 0, this.flythrough.dashboardImageOffset.y, null);
                g2.setTransform(oldTransform);
            } else {
                g2.drawImage(image, 0, 0, null);
            }
            g2.setColor(Color.black);
            if (this.imageReadout.getImageName() != null) {
                g2.drawString(this.imageReadout.getImageName(), 10, 20);
            }
        }
        return false;
    }
}

