/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.flythrough;

import java.util.List;
import javax.swing.table.AbstractTableModel;
import ucar.unidata.idv.flythrough.Flythrough;
import ucar.unidata.idv.flythrough.FlythroughPoint;
import visad.DateTime;

public class FlythroughTableModel
extends AbstractTableModel {
    Flythrough flythrough;
    public static final int COL_LAT = 0;
    public static final int COL_LON = 1;
    public static final int COL_ALT = 2;
    public static final int COL_DATE = 3;

    public FlythroughTableModel(Flythrough flythrough) {
        this.flythrough = flythrough;
    }

    @Override
    public int getRowCount() {
        return this.flythrough.getPointsToUse().size();
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        List<FlythroughPoint> thePoints = this.flythrough.getPointsToUse();
        FlythroughPoint pt = thePoints.get(rowIndex);
        if (aValue == null) {
            pt.setDateTime(null);
        } else if (aValue instanceof DateTime) {
            pt.setDateTime((DateTime)aValue);
        }
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 3;
    }

    @Override
    public Object getValueAt(int row, int column) {
        List<FlythroughPoint> thePoints = this.flythrough.getPointsToUse();
        if (row >= thePoints.size()) {
            return "n/a";
        }
        FlythroughPoint pt = thePoints.get(row);
        if (column == 0) {
            if (pt.getMatrix() != null) {
                return "matrix";
            }
            return pt.getEarthLocation().getLatitude();
        }
        if (column == 1) {
            if (pt.getMatrix() != null) {
                return "";
            }
            return pt.getEarthLocation().getLongitude();
        }
        if (column == 2) {
            if (pt.getMatrix() != null) {
                return "";
            }
            return pt.getEarthLocation().getAltitude();
        }
        if (column == 3) {
            return pt.getDateTime();
        }
        return "";
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "Latitude";
            }
            case 1: {
                return "Longitude";
            }
            case 2: {
                return "Altitude";
            }
            case 3: {
                return "Date/Time";
            }
        }
        return "";
    }
}

