/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.flythrough;

import java.awt.Graphics2D;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JMenu;
import ucar.unidata.idv.control.ReadoutInfo;
import ucar.unidata.idv.flythrough.Flythrough;
import ucar.unidata.idv.flythrough.FlythroughPoint;
import ucar.unidata.util.GuiUtils;

public abstract class FlythroughDecorator {
    Flythrough flythrough;
    private boolean shown = true;

    public FlythroughDecorator() {
    }

    public FlythroughDecorator(Flythrough flythrough) {
        this.flythrough = flythrough;
    }

    public void setFlythrough(Flythrough flythrough) {
        this.flythrough = flythrough;
    }

    public void handleReadout(FlythroughPoint pt, List<ReadoutInfo> samples) throws Exception {
    }

    public boolean paintDashboard(Graphics2D g, JComponent comp) {
        return false;
    }

    public abstract String getName();

    public void clearSamples() {
    }

    public void initViewMenu(JMenu viewMenu) {
        viewMenu.add(GuiUtils.makeCheckboxMenuItem("Show " + this.getName(), this, "shown", null));
    }

    public void initEditMenu(JMenu viewMenu) {
    }

    public void initFileMenu(JMenu viewMenu) {
    }

    public void setShown(boolean value) {
        this.shown = value;
        if (this.flythrough != null) {
            this.flythrough.updateDashboard();
        }
    }

    public boolean getShown() {
        return this.shown;
    }

    public void logException(String msg, Throwable exc) {
        this.flythrough.logException(msg, exc);
    }
}

