/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.flythrough;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.ImageObserver;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.media.j3d.BadTransformException;
import javax.media.j3d.Transform3D;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CompassPlot;
import org.jfree.chart.plot.MeterPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.Range;
import org.jfree.data.general.DefaultValueDataset;
import org.jfree.data.general.ValueDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeriesCollection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ucar.unidata.collab.SharableImpl;
import ucar.unidata.geoloc.Bearing;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.idv.IntegratedDataViewer;
import ucar.unidata.idv.MapViewManager;
import ucar.unidata.idv.control.ReadoutInfo;
import ucar.unidata.idv.flythrough.ChartDecorator;
import ucar.unidata.idv.flythrough.FlythroughDecorator;
import ucar.unidata.idv.flythrough.FlythroughPoint;
import ucar.unidata.idv.flythrough.FlythroughTableModel;
import ucar.unidata.idv.flythrough.ImageDecorator;
import ucar.unidata.idv.flythrough.WeatherDecorator;
import ucar.unidata.idv.ui.CursorReadoutWindow;
import ucar.unidata.idv.ui.EarthNavPanel;
import ucar.unidata.idv.ui.PipPanel;
import ucar.unidata.ui.ImageUtils;
import ucar.unidata.ui.LatLonWidget;
import ucar.unidata.util.DateUtil;
import ucar.unidata.util.FileManager;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.StringUtil;
import ucar.unidata.util.TwoFacedObject;
import ucar.unidata.view.geoloc.NavigatedDisplay;
import ucar.unidata.xml.XmlUtil;
import ucar.visad.ShapeUtility;
import ucar.visad.Util;
import ucar.visad.data.CalendarDateTime;
import ucar.visad.data.CalendarDateTimeSet;
import ucar.visad.display.Animation;
import ucar.visad.display.AnimationInfo;
import ucar.visad.display.AnimationWidget;
import ucar.visad.display.LineDrawing;
import ucar.visad.display.SelectorPoint;
import visad.CommonUnit;
import visad.DateTime;
import visad.DisplayEvent;
import visad.Gridded3DSet;
import visad.MathType;
import visad.MouseBehavior;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.Unit;
import visad.VisADException;
import visad.VisADGeometryArray;
import visad.georef.EarthLocation;
import visad.georef.EarthLocationLite;
import visad.georef.EarthLocationTuple;

public class Flythrough
extends SharableImpl
implements PropertyChangeListener,
ImageObserver {
    public static final String ORIENT_POINT = "point";
    public static final String ORIENT_FORWARD = "forward";
    public static final String ORIENT_UP = "up";
    public static final String ORIENT_DOWN = "down";
    public static final String ORIENT_LEFT = "left";
    public static final String ORIENT_RIGHT = "right";
    private static final String DIR_FORWARD = "forward";
    private static final String DIR_BACK = "back";
    private static final String DIR_LEFT = "left";
    private static final String DIR_RIGHT = "right";
    public static final String TAG_FLYTHROUGH = "flythrough";
    public static final String TAG_DESCRIPTION = "description";
    public static final String TAG_POINT = "point";
    public static final String ATTR_DATE = "date";
    public static final String ATTR_LAT = "lat";
    public static final String ATTR_LON = "lon";
    public static final String ATTR_ALT = "alt";
    public static final String[] ATTR_TILT = new String[]{"tiltx", "tilty", "tiltz"};
    public static final String ATTR_ZOOM = "zoom";
    public static final String ATTR_MATRIX = "matrix";
    private MapViewManager viewManager;
    private SimpleDateFormat sdf;
    private List<FlythroughPoint> allPoints = new ArrayList<FlythroughPoint>();
    private List<FlythroughPoint> pointsToUse = new ArrayList<FlythroughPoint>();
    private int stride = 1;
    private double[] tilt = new double[]{-30.0, 0.0, 0.0};
    JSlider[] tiltSliders = new JSlider[]{null, null, null};
    JLabel[] tiltLabels = new JLabel[]{null, null, null};
    private double zoom = 1.0;
    private boolean lastMoveWasTrack = true;
    private boolean goToClick = false;
    private boolean showAnimation = true;
    private boolean showDecoration = true;
    private boolean changeViewpoint = true;
    private boolean animate = false;
    private int animationSpeed = 50;
    private JCheckBox animateCbx;
    private AnimationInfo animationInfo;
    private Animation animation;
    private AnimationWidget animationWidget;
    private boolean hasTimes = false;
    private String orientation = "point";
    private JCheckBox showTimesCbx;
    private FlythroughPoint currentPoint;
    private CursorReadoutWindow readout;
    private JLabel readoutLabel;
    private JComponent readoutDisplay;
    private JCheckBox changeViewpointCbx;
    private JTextField zoomFld;
    private JComboBox orientBox;
    private Vector<TwoFacedObject> orients = new Vector();
    private JCheckBox fixedZCbx;
    private JRadioButton backBtn;
    private JFrame frame;
    private Rectangle windowBounds;
    private LineDrawing locationLine;
    private LineDrawing locationLine2;
    private SelectorPoint locationMarker;
    private JTable pointTable;
    private FlythroughTableModel pointTableModel;
    private JEditorPane htmlView;
    private JComponent contents;
    private boolean shown = false;
    private boolean useFixedZ = true;
    private int currentIndex = 0;
    private EarthLocation location;
    private double heading = 0.0;
    private double currentHeading = 0.0;
    private JLabel dashboardLbl;
    private EarthNavPanel earthNavPanel;
    private PipPanel pipPanel;
    private JFrame pipFrame;
    private Rectangle pipRect;
    private Dimension dialDimension = new Dimension(180, 130);
    private int[][] dialPts = new int[][]{{402, 100, 206, 145}, {256, 90, 120, 100}, {515, 60, 130, 100}, {224, 180, 170, 100}, {575, 180, 170, 100}, {356, 240, 150, 100}, {447, 240, 150, 100}, {687, 262, 90, 100}};
    private List<JComponent> dials = new ArrayList<JComponent>();
    protected Point dashboardImageOffset = new Point(0, 0);
    private Image dashboardImage;
    private boolean showTimes = false;
    private boolean showLine = true;
    private boolean showMarker = true;
    private boolean showReadout = true;
    private List<FlythroughDecorator> decorators = new ArrayList<FlythroughDecorator>();
    private double[] lastViewpoint;
    private EarthLocation lastLocation;
    private int lastIndex = -1;
    private Object REPAINT_MUTEX = new Object();
    private int repaintCnt = 0;
    private VisADGeometryArray marker;

    public Flythrough() {
        this.sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss Z");
        this.sdf.setTimeZone(DateUtil.TIMEZONE_GMT);
        this.decorators.add(new ImageDecorator(this));
        this.decorators.add(new WeatherDecorator(this));
        this.decorators.add(new ChartDecorator(this));
    }

    public Flythrough(MapViewManager viewManager) {
        this();
        this.viewManager = viewManager;
    }

    public void setViewManager(MapViewManager viewManager) {
        this.viewManager = viewManager;
    }

    public void init(MapViewManager viewManager) {
        this.viewManager = viewManager;
        for (FlythroughDecorator decorator : this.decorators) {
            decorator.setFlythrough(this);
        }
    }

    public void initWith(Flythrough that) {
        if (this == that) {
            return;
        }
        this.allPoints = new ArrayList<FlythroughPoint>(that.allPoints);
        this.pointsToUse = new ArrayList<FlythroughPoint>(that.pointsToUse);
        this.stride = that.stride;
        this.animationInfo = that.animationInfo;
        this.tilt = new double[]{that.tilt[0], that.tilt[1], that.tilt[2]};
        this.zoom = that.zoom;
        this.changeViewpoint = that.changeViewpoint;
        this.showLine = that.showLine;
        this.showMarker = that.showMarker;
        this.showReadout = that.showReadout;
        this.showTimes = that.showTimes;
        this.setAnimationTimes();
    }

    public MapViewManager getViewManager() {
        return this.viewManager;
    }

    public IntegratedDataViewer getIdv() {
        return this.viewManager.getIdv();
    }

    public void destroy() throws VisADException, RemoteException {
        if (this.frame != null) {
            this.frame.dispose();
            this.frame = null;
        }
        if (this.locationMarker != null && this.viewManager != null) {
            this.viewManager.getMaster().removeDisplayable(this.locationMarker);
            this.viewManager.getMaster().removeDisplayable(this.locationLine);
        }
        if (this.animationWidget != null) {
            this.animationWidget.destroy();
            this.animationWidget = null;
        }
        this.viewManager = null;
    }

    public AnimationWidget getAnimationWidget() {
        return this.animationWidget;
    }

    public Animation getAnimation() {
        return this.animation;
    }

    private void setPts(LineDrawing ld, float x1, float x2, float y1, float y2, float z1, float z2) throws VisADException, RemoteException {
        RealTupleType mathType = RealTupleType.SpatialCartesian3DTuple;
        float[][] pts = new float[][]{{x1, x2}, {y1, y2}, {z1, z2}};
        ld.setData(new Gridded3DSet((MathType)mathType, (float[][])pts, 2));
    }

    public void flythrough(float[][] pts) {
        ArrayList<FlythroughPoint> points = new ArrayList<FlythroughPoint>();
        NavigatedDisplay navDisplay = this.viewManager.getNavigatedDisplay();
        for (int i = 0; i < pts[0].length; ++i) {
            EarthLocation el = navDisplay.getEarthLocation(pts[0][i], pts[1][i], pts[2][i], false);
            points.add(new FlythroughPoint(el));
        }
        this.flythrough(points);
    }

    public void flythrough(List<FlythroughPoint> newPoints) {
        this.flythrough(newPoints, true);
    }

    public void flythrough(List<FlythroughPoint> newPoints, boolean andShow) {
        this.allPoints = new ArrayList<FlythroughPoint>(newPoints);
        ArrayList<FlythroughPoint> tmp = new ArrayList<FlythroughPoint>();
        for (int i = 0; i < newPoints.size(); i += this.stride) {
            tmp.add(newPoints.get(i));
        }
        newPoints = tmp;
        this.pointsToUse = new ArrayList<FlythroughPoint>(newPoints);
        if (this.animation != null) {
            this.animation.setCurrent(this.currentIndex);
            this.setAnimationTimes();
        }
        if (andShow) {
            this.show();
        }
    }

    private double parse(JTextField fld, double d) {
        String t = fld.getText().trim();
        if (t.length() == 0) {
            return d;
        }
        if (t.equals("-")) {
            return d;
        }
        try {
            return Misc.parseNumber(t);
        }
        catch (NumberFormatException nfe) {
            this.animationWidget.setRunning(false);
            this.logException("Parse error:" + t, nfe);
            return d;
        }
    }

    private void setAnimationTimes() {
        this.hasTimes = false;
        if (this.animationWidget == null) {
            return;
        }
        try {
            CalendarDateTimeSet set = null;
            List<FlythroughPoint> thePoints = this.pointsToUse;
            if (thePoints != null && !thePoints.isEmpty()) {
                DateTime[] timeArray = new DateTime[thePoints.size()];
                for (int i = 0; i < thePoints.size(); ++i) {
                    DateTime dttm = thePoints.get(i).getDateTime();
                    if (dttm == null) {
                        dttm = new DateTime(new Date(i * 1000 * 60 * 60 * 24));
                    } else {
                        this.hasTimes = true;
                    }
                    timeArray[i] = dttm;
                }
                set = CalendarDateTime.makeTimeSet(timeArray);
            }
            if (this.showTimesCbx != null) {
                this.showTimesCbx.setEnabled(this.hasTimes);
            }
            this.animationWidget.showDateBox(this.hasTimes);
            this.animationWidget.setBaseTimes(set);
            if (this.pointTableModel != null) {
                this.pointTableModel.fireTableStructureChanged();
            }
        }
        catch (Exception exc) {
            this.logException("Setting flythrough", exc);
        }
    }

    public void goToCurrent() {
        try {
            if (!this.lastMoveWasTrack) {
                this.doDrive(false, this.heading);
            } else if (this.animation != null) {
                this.doStep(this.animation.getCurrent());
            }
        }
        catch (Exception exc) {
            this.logException("Setting flythrough", exc);
        }
    }

    public void updateDashboard() {
        if (this.dashboardLbl != null) {
            this.dashboardLbl.repaint();
        }
    }

    @Override
    public boolean imageUpdate(Image img, int flags, int x, int y, int width, int height) {
        if ((flags & 0x40) != 0) {
            return false;
        }
        this.updateDashboard();
        return (flags & 0x20) == 0;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("aniValue")) {
            this.lastMoveWasTrack = true;
            this.goToCurrent();
        }
    }

    private void makeWidgets() throws VisADException, RemoteException {
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab("Dashboard", this.doMakeDashboardPanel());
        tabbedPane.addTab("Values", this.doMakeValuesPanel());
        tabbedPane.addTab("Description", this.doMakeDescriptionPanel());
        tabbedPane.addTab("Viewpoint", this.doMakeViewpointPanel());
        tabbedPane.addTab("Points", this.doMakePointsPanel());
        JPanel innerContents = GuiUtils.topCenterBottom(this.animationWidget.getContents(), tabbedPane, this.doMakeNavigationPanel());
        if (!this.showAnimation) {
            this.animationWidget.getContents().setVisible(false);
        }
        JMenuBar menuBar = this.doMakeMenuBar();
        innerContents = GuiUtils.inset((Component)innerContents, 5);
        this.contents = GuiUtils.topCenter(menuBar, innerContents);
        this.animation.setCurrent(this.currentIndex);
    }

    private JEditorPane getHtmlView() {
        if (this.htmlView == null) {
            JEditorPane tmp = new JEditorPane();
            tmp.setContentType("text/html");
            tmp.setPreferredSize(new Dimension(300, 400));
            tmp.setEditable(false);
            tmp.setText(" ");
            this.htmlView = tmp;
        }
        return this.htmlView;
    }

    public JComponent doMakeDescriptionPanel() {
        JScrollPane htmlScrollPane = new JScrollPane(this.getHtmlView());
        htmlScrollPane.setPreferredSize(new Dimension(400, 300));
        return htmlScrollPane;
    }

    public JMenuBar doMakeMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = GuiUtils.makeDynamicMenu("File", this, "initFileMenu");
        JMenu editMenu = GuiUtils.makeDynamicMenu("Edit", this, "initEditMenu");
        JMenu viewMenu = GuiUtils.makeDynamicMenu("View", this, "initViewMenu");
        menuBar.add(fileMenu);
        menuBar.add(editMenu);
        menuBar.add(viewMenu);
        return menuBar;
    }

    public JComponent doMakeViewpointPanel() throws VisADException, RemoteException {
        JSlider speedSlider = new JSlider(1, 200, 200 - this.animationSpeed);
        speedSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSlider slider = (JSlider)e.getSource();
                if (!slider.getValueIsAdjusting()) {
                    Flythrough.this.animationSpeed = 200 - slider.getValue() + 1;
                }
            }
        });
        this.showTimesCbx = new JCheckBox("Set Animation Time", this.showTimes);
        this.showTimesCbx.setEnabled(this.hasTimes);
        this.animateCbx = new JCheckBox("Animated", this.animate);
        this.changeViewpointCbx = new JCheckBox("Change Viewpoint", this.changeViewpoint);
        this.orients = new Vector();
        this.orients.add(new TwoFacedObject((Object)"Towards Next Point", "point"));
        this.orients.add(new TwoFacedObject((Object)"Forward", "forward"));
        this.orients.add(new TwoFacedObject((Object)"Up", ORIENT_UP));
        this.orients.add(new TwoFacedObject((Object)"Down", ORIENT_DOWN));
        this.orients.add(new TwoFacedObject((Object)"Left", "left"));
        this.orients.add(new TwoFacedObject((Object)"Right", "right"));
        this.orientBox = new JComboBox<TwoFacedObject>(this.orients);
        this.orientBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                Flythrough.this.orientation = TwoFacedObject.getIdString(Flythrough.this.orientBox.getSelectedItem());
                Flythrough.this.goToCurrent();
            }
        });
        if (this.animationInfo == null) {
            this.animationInfo = new AnimationInfo();
            this.animationInfo.setShareIndex(true);
        }
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                Misc.run(Flythrough.this, "goToCurrent");
            }
        };
        this.animationWidget = new AnimationWidget(null, null, this.animationInfo);
        if (this.getShareGroup() == null || this.getShareGroup().equals("All")) {
            this.setShareGroup(TAG_FLYTHROUGH);
        }
        this.animationWidget.setShareGroup(this.getShareGroup());
        this.animationWidget.setSharing(this.getSharing());
        this.animation = new Animation();
        this.animation.setAnimationInfo(this.animationInfo);
        this.animation.addPropertyChangeListener(this);
        this.animationWidget.setAnimation(this.animation);
        this.locationMarker = new SelectorPoint("flythrough.point", ShapeUtility.setSize(ShapeUtility.createShape("AIRPLANE3D")[0], 0.1f), new RealTuple(RealTupleType.SpatialCartesian3DTuple, new double[]{0.0, 0.0, 0.0}));
        this.locationMarker.setAutoSize(true);
        this.locationMarker.setManipulable(false);
        this.locationMarker.setColor(Color.green);
        this.locationMarker.setVisible(false);
        this.locationLine = new LineDrawing("flythroughpoint.line");
        this.locationLine.setVisible(false);
        this.locationLine.setLineWidth(2.0f);
        this.locationLine.setColor(Color.green);
        Misc.runInABit(2000L, this, "setScaleOnMarkers", null);
        this.viewManager.getMaster().addDisplayable(this.locationMarker);
        this.viewManager.getMaster().addDisplayable(this.locationLine);
        this.readout = new CursorReadoutWindow(this.viewManager, false);
        this.zoomFld = new JTextField(Misc.format(this.zoom), 5);
        for (int i = 0; i < this.tilt.length; ++i) {
            final int theIndex = i;
            this.tiltSliders[i] = new JSlider(-90, 90, (int)this.tilt[i]);
            this.tiltSliders[i].setToolTipText("Control-R: reset");
            this.tiltSliders[i].addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 82 && e.isControlDown()) {
                        ((Flythrough)Flythrough.this).tilt[theIndex] = 0.0;
                        Flythrough.this.tiltLabels[theIndex].setText("" + (int)Flythrough.this.tilt[theIndex]);
                        Flythrough.this.tiltSliders[theIndex].setValue(0);
                        Flythrough.this.goToCurrent();
                    }
                }
            });
            this.tiltLabels[i] = new JLabel("" + (int)this.tilt[i]);
            this.tiltSliders[i].addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    JSlider slider = (JSlider)e.getSource();
                    Flythrough.this.tiltLabels[theIndex].setText("" + slider.getValue());
                    if (!slider.getValueIsAdjusting()) {
                        ((Flythrough)Flythrough.this).tilt[theIndex] = slider.getValue();
                        Flythrough.this.goToCurrent();
                    }
                }
            });
        }
        this.zoomFld.addActionListener(listener);
        this.fixedZCbx = GuiUtils.makeCheckbox("Use fixed Z", this, "useFixedZ");
        GuiUtils.tmpInsets = GuiUtils.INSETS_5;
        JComponent orientationComp = GuiUtils.formLayout(new Component[]{GuiUtils.filler(), GuiUtils.left(this.changeViewpointCbx), GuiUtils.rLabel("Tilt Down/Up:"), GuiUtils.centerRight(this.tiltSliders[0], this.tiltLabels[0]), GuiUtils.rLabel("Tilt Left/Right:"), GuiUtils.centerRight(this.tiltSliders[1], this.tiltLabels[1]), GuiUtils.rLabel("Zoom:"), GuiUtils.left(this.zoomFld), GuiUtils.rLabel("Orientation:"), GuiUtils.left(GuiUtils.hbox(this.orientBox, this.doGlobe() ? GuiUtils.filler() : this.fixedZCbx)), GuiUtils.rLabel("Transitions:"), GuiUtils.vbox((Component)GuiUtils.left(this.animateCbx), GuiUtils.leftCenter(new JLabel("Speed"), speedSlider)), GuiUtils.filler(), GuiUtils.left(this.showTimesCbx)});
        return GuiUtils.top(orientationComp);
    }

    public void setScaleOnMarkers() {
        if (this.viewManager != null && this.locationMarker != null) {
            try {
                NavigatedDisplay navDisplay = this.viewManager.getNavigatedDisplay();
                this.locationMarker.setScale(navDisplay.getDisplayScale());
            }
            catch (Exception exc) {
                this.logException("Setting scale on marker", exc);
            }
        }
    }

    public JComponent doMakePointsPanel() {
        this.pointTableModel = new FlythroughTableModel(this);
        this.pointTable = new JTable(this.pointTableModel);
        this.pointTable.setToolTipText("Double click: view; Control-P: Show point properties; Delete: delete point");
        this.pointTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                List oldPoints;
                int[] rows;
                ArrayList<FlythroughPoint> newPoints;
                if (e.getKeyCode() == 80 && e.isControlDown()) {
                    FlythroughPoint pt;
                    newPoints = new ArrayList<FlythroughPoint>();
                    rows = Flythrough.this.pointTable.getSelectedRows();
                    oldPoints = Flythrough.this.pointsToUse;
                    for (int j = 0; j < rows.length && Flythrough.this.showProperties(pt = (FlythroughPoint)oldPoints.get(rows[j])); ++j) {
                        Flythrough.this.pointTable.repaint();
                    }
                }
                if (GuiUtils.isDeleteEvent(e)) {
                    newPoints = new ArrayList();
                    rows = Flythrough.this.pointTable.getSelectedRows();
                    oldPoints = Flythrough.this.pointsToUse;
                    for (int i = 0; i < oldPoints.size(); ++i) {
                        boolean good = true;
                        for (int j = 0; j < rows.length; ++j) {
                            if (i != rows[j]) continue;
                            good = false;
                            break;
                        }
                        if (!good) continue;
                        newPoints.add((FlythroughPoint)oldPoints.get(i));
                    }
                    Flythrough.this.flythrough(newPoints);
                }
            }
        });
        this.pointTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int row = Flythrough.this.pointTable.rowAtPoint(e.getPoint());
                if (row < 0 || row >= Flythrough.this.pointsToUse.size()) {
                    return;
                }
                if (e.getClickCount() > 1) {
                    Flythrough.this.animation.setCurrent(row);
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.pointTable);
        scrollPane.setPreferredSize(new Dimension(400, 300));
        return scrollPane;
    }

    public JComponent doMakeValuesPanel() {
        this.readoutLabel = GuiUtils.getFixedWidthLabel("<html></html>");
        this.readoutLabel.setVerticalAlignment(1);
        this.readoutDisplay = new JPanel();
        this.readoutDisplay.setLayout(new BorderLayout());
        return this.readoutLabel;
    }

    public JComponent doMakeDashboardPanel() {
        this.dashboardImage = GuiUtils.getImage("/auxdata/ui/icons/cockpit.gif", this.getClass(), false);
        this.pipPanel = new PipPanel(this.viewManager);
        this.pipPanel.getNavigatedPanel().setBorder(null);
        this.pipPanel.setPreferredSize(new Dimension(100, 100));
        this.pipPanel.doLayout();
        this.pipPanel.validate();
        this.pipFrame = new JFrame("Show remain invisible");
        this.pipFrame.setContentPane(this.pipPanel);
        this.pipFrame.pack();
        this.dashboardLbl = new JLabel(new ImageIcon(this.dashboardImage)){

            @Override
            public void paint(Graphics g) {
                Flythrough.this.paintDashboardBackground(g, Flythrough.this.dashboardLbl);
                super.paint(g);
                Flythrough.this.paintDashboardAfter(g, Flythrough.this.dashboardLbl);
            }
        };
        this.dashboardLbl.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                Flythrough.this.pipPanel.keyPressedInMap(e);
                Flythrough.this.updateDashboard();
            }
        });
        this.dashboardLbl.setVerticalAlignment(3);
        MouseAdapter mouseAdapter = new MouseAdapter(){
            Point mouseStart = new Point(0, 0);
            Point originalOffset = new Point(0, 0);

            @Override
            public void mouseClicked(MouseEvent me) {
                if (Flythrough.this.pipRect == null) {
                    return;
                }
                if (Flythrough.this.goToClick && Flythrough.this.pipRect.contains(new Point(me.getX(), me.getY()))) {
                    try {
                        int x = me.getX() - ((Flythrough)Flythrough.this).pipRect.x;
                        int y = me.getY() - ((Flythrough)Flythrough.this).pipRect.y;
                        LatLonPoint llp = Flythrough.this.pipPanel.screenToLatLon(x, y);
                        Flythrough.this.location = Flythrough.this.makePoint(llp.getLatitude(), llp.getLongitude(), 0.0);
                        Flythrough.this.doDrive(false, Flythrough.this.heading);
                    }
                    catch (Exception exc) {
                        Flythrough.this.logException("Driving", exc);
                    }
                }
            }

            @Override
            public void mousePressed(MouseEvent me) {
                Flythrough.this.dashboardLbl.requestFocus();
                this.originalOffset = new Point(Flythrough.this.dashboardImageOffset);
                this.mouseStart.x = me.getX();
                this.mouseStart.y = me.getY();
                Rectangle b = Flythrough.this.dashboardLbl.getBounds();
                int w = Flythrough.this.dashboardImage.getWidth(null);
                int h = Flythrough.this.dashboardImage.getHeight(null);
                Point ul = new Point(b.width / 2 - w / 2, b.height - h);
            }

            @Override
            public void mouseDragged(MouseEvent me) {
                Flythrough.this.dashboardImageOffset.x = this.originalOffset.x + me.getX() - this.mouseStart.x;
                Flythrough.this.dashboardImageOffset.y = this.originalOffset.y + me.getY() - this.mouseStart.y;
                Flythrough.this.updateDashboard();
            }
        };
        this.dashboardLbl.addMouseListener(mouseAdapter);
        this.dashboardLbl.addMouseMotionListener(mouseAdapter);
        Misc.run(new Runnable(){

            @Override
            public void run() {
                try {
                    MeterPlot plot = new MeterPlot((ValueDataset)new DefaultValueDataset((Number)new Double(1.0)));
                    Flythrough.createChart((XYDataset)new XYSeriesCollection());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        return this.dashboardLbl;
    }

    private void readPts() {
        try {
            if (new File("pts").exists()) {
                String s = IOUtil.readContents("pts", "");
                s = s.replace("{", "");
                s = s.replace("}", "");
                ArrayList<int[]> pts = new ArrayList<int[]>();
                for (String line : StringUtil.split(s, "\n", true, true)) {
                    pts.add(Misc.parseInts(line, ","));
                }
                this.dialPts = new int[pts.size()][];
                for (int i = 0; i < pts.size(); ++i) {
                    this.dialPts[i] = (int[])pts.get(i);
                }
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRepaint(JComponent c) {
        boolean callRepaint = false;
        Object object = this.REPAINT_MUTEX;
        synchronized (object) {
            --this.repaintCnt;
            if (this.repaintCnt == 0) {
                callRepaint = true;
            }
        }
        if (callRepaint) {
            c.repaint();
        }
    }

    public EarthLocation getLastLocation() {
        return this.lastLocation;
    }

    public void paintDashboardAfter(Graphics g, JComponent comp) {
        Graphics2D g2 = (Graphics2D)g;
        AffineTransform oldTransform = g2.getTransform();
        Rectangle b = this.dashboardLbl.getBounds();
        int w = this.dashboardImage.getWidth(null);
        int h = this.dashboardImage.getHeight(null);
        Point ul = new Point(b.width / 2 - w / 2, b.height - h);
        int ptsIdx = 0;
        try {
            this.pipPanel.setPreferredSize(new Dimension(this.dialPts[ptsIdx][2], this.dialPts[ptsIdx][3]));
            this.pipFrame.setSize(this.dialPts[ptsIdx][2], this.dialPts[ptsIdx][3]);
            this.pipPanel.doLayout();
            this.pipPanel.validate();
            this.pipFrame.pack();
            this.pipPanel.resetDrawBounds();
            this.pipPanel.redraw();
        }
        catch (Exception exception) {
            // empty catch block
        }
        JComponent locLbl = null;
        if (this.lastLocation != null) {
            try {
                locLbl = new JLabel("<html><table width=100%><tr><td align=right>&nbsp;Lat:</td></td>" + this.getIdv().getDisplayConventions().formatLatLon(this.getLat(this.lastLocation)) + "</td></tr>" + "<tr><td align=right>&nbsp;Lon:</td></td>" + this.getIdv().getDisplayConventions().formatLatLon(this.getLon(this.lastLocation)) + "</td></tr>" + "<tr><td align=right>&nbsp;Alt:</td></td>" + this.getIdv().getDisplayConventions().formatDistance(this.getAlt(this.lastLocation)) + "</table>");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (locLbl == null) {
            locLbl = new JLabel("<html><table width=100%><tr><td align=right>&nbsp;Lat:</td></td>N/A </td></tr><tr><td align=right>&nbsp;Lon:</td></td>N/A </td></tr><tr><td align=right>&nbsp;Alt:</td></td>N/A </table>");
        }
        locLbl.setOpaque(true);
        locLbl.setBackground(Color.white);
        DefaultValueDataset headingDataset = new DefaultValueDataset((Number)new Double(this.currentHeading));
        CompassPlot plot = new CompassPlot((ValueDataset)headingDataset);
        plot.setSeriesNeedle(0);
        plot.setSeriesPaint(0, (Paint)Color.red);
        plot.setSeriesOutlinePaint(0, (Paint)Color.red);
        JFreeChart chart = new JFreeChart("", (Plot)plot);
        ChartPanel compassPanel = new ChartPanel(chart);
        plot.setBackgroundPaint((Paint)new Color(255, 255, 255, 0));
        plot.setBackgroundImageAlpha(0.0f);
        chart.setBackgroundPaint((Paint)new Color(255, 255, 255, 0));
        compassPanel.setBackground(new Color(255, 255, 255, 0));
        compassPanel.setPreferredSize(this.dialDimension);
        g2.setTransform(oldTransform);
        this.pipRect = this.drawDial(g2, this.pipPanel, ptsIdx++, ul);
        JFrame dummyFrame = new JFrame("");
        dummyFrame.setContentPane((Container)compassPanel);
        dummyFrame.pack();
        g2.setTransform(oldTransform);
        this.drawDial(g2, (JComponent)compassPanel, ptsIdx++, ul);
        g2.setTransform(oldTransform);
        dummyFrame.setContentPane(locLbl);
        dummyFrame.pack();
        this.drawDial(g2, locLbl, ptsIdx++, ul);
        if (this.showReadout) {
            for (JComponent dial : this.dials) {
                dummyFrame.setContentPane(dial);
                dummyFrame.pack();
                g2.setTransform(oldTransform);
                this.drawDial(g2, dial, ptsIdx++, ul);
            }
        }
        g2.setTransform(oldTransform);
    }

    public Image getDashboardImage() {
        return this.dashboardImage;
    }

    public static JFreeChart createChart(XYDataset dataset) {
        JFreeChart chart = ChartFactory.createXYLineChart((String)"", (String)"", (String)"", (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)new Color(255, 255, 255, 0));
        XYPlot plot = (XYPlot)chart.getPlot();
        plot.setBackgroundPaint((Paint)Color.lightGray);
        plot.setDomainGridlinePaint((Paint)Color.white);
        plot.setRangeGridlinePaint((Paint)Color.white);
        ValueAxis domainAxis = plot.getDomainAxis();
        domainAxis.setVisible(false);
        return chart;
    }

    private Rectangle drawDial(Graphics g2, JComponent comp, int ptsIdx, Point ul) {
        if (ptsIdx >= this.dialPts.length) {
            return null;
        }
        int w = comp.getWidth();
        int h = comp.getHeight();
        boolean useUpperLeft = false;
        if (comp instanceof ChartPanel) {
            int desiredWidth = this.dialPts[ptsIdx][2];
            double scale = (double)w / (double)desiredWidth;
            if (scale != 0.0) {
                h = (int)((double)h / scale);
            }
            comp.setSize(new Dimension(desiredWidth, h));
        } else if (comp instanceof JLabel) {
            useUpperLeft = true;
        } else {
            comp.setSize(new Dimension(this.dialPts[ptsIdx][2], this.dialPts[ptsIdx][3]));
        }
        try {
            int x = ul.x + this.dialPts[ptsIdx][0] - (useUpperLeft ? 0 : this.dialPts[ptsIdx][2] / 2);
            int y = ul.y + this.dialPts[ptsIdx][1] - (useUpperLeft ? 0 : this.dialPts[ptsIdx][3] / 2);
            Image image = ImageUtils.getImage(comp);
            g2.translate(x, y);
            g2.drawImage(image, 0, 0, null);
            return new Rectangle(x, y, comp.getWidth(), comp.getHeight());
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintDashboardBackground(Graphics g, JComponent comp) {
        Graphics2D g2 = (Graphics2D)g;
        Rectangle b = this.dashboardLbl.getBounds();
        g.setColor(Color.white);
        g.fillRect(0, 0, b.width, b.height);
        if (this.showDecoration) {
            boolean callRepaint = false;
            for (FlythroughDecorator decorator : this.decorators) {
                if (!decorator.getShown() || !decorator.paintDashboard(g2, comp)) continue;
                callRepaint = true;
            }
            if (callRepaint) {
                Object object = this.REPAINT_MUTEX;
                synchronized (object) {
                    ++this.repaintCnt;
                    Misc.runInABit(500L, this, "doRepaint", comp);
                }
            }
        }
    }

    public void displayChanged(DisplayEvent event) throws VisADException, RemoteException {
        InputEvent inputEvent;
        int mods;
        if (!this.isActive()) {
            return;
        }
        double[] viewpoint = this.viewManager.getDisplayMatrix();
        if (!Misc.arraysEquals(viewpoint, this.lastViewpoint)) {
            this.lastViewpoint = viewpoint;
            this.updateDashboard();
        }
        if (this.goToClick && event.getId() == 1 && ((mods = (inputEvent = event.getInputEvent()).getModifiers()) & 0x10) != 0 && !inputEvent.isShiftDown() && !inputEvent.isControlDown()) {
            NavigatedDisplay navDisplay = this.viewManager.getNavigatedDisplay();
            this.location = navDisplay.screenToEarthLocation(event.getX(), event.getY());
            this.doDrive(false, this.heading);
        }
    }

    public JComponent doMakeNavigationPanel() {
        this.earthNavPanel = new EarthNavPanel(this.viewManager, this, false);
        return this.earthNavPanel;
    }

    public void driveLeft() {
        this.heading -= 3.0;
        this.doDrive(false, this.heading);
    }

    public void driveRight() {
        this.heading += 3.0;
        this.doDrive(false, this.heading);
    }

    public void driveForward() {
        this.doDrive(true, this.heading);
    }

    public void driveBack() {
        this.doDrive(true, this.heading - 180.0, false);
    }

    public void doDrive(boolean takeStep, double heading) {
        this.doDrive(takeStep, heading, true);
    }

    public void doDrive(boolean takeStep, double heading, boolean forward) {
        this.lastMoveWasTrack = false;
        try {
            NavigatedDisplay navDisplay = this.viewManager.getNavigatedDisplay();
            if (this.location == null) {
                this.location = this.pointsToUse.size() > 0 ? this.pointsToUse.get(0).getEarthLocation() : (this.doGlobe() ? this.makePoint(40.0, -100.0, 0.0) : navDisplay.getEarthLocation(navDisplay.getScreenCenter()));
            }
            double zoom = navDisplay.getScale();
            LatLonPointImpl llp = null;
            EarthLocation nextLocation = null;
            double[] xyz1 = new double[]{0.0, 0.0, 0.0};
            double[] xyz2 = new double[]{0.0, 0.0, 0.0};
            double[] xyz = this.getXYZ(this.location);
            EarthLocation sll = navDisplay.getEarthLocation(navDisplay.getScreenUpperLeft());
            EarthLocation slr = navDisplay.getEarthLocation(navDisplay.getScreenLowerRight());
            Bearing bearing = Bearing.calculateBearing(new LatLonPointImpl(this.getLat(sll), this.getLon(sll)), (LatLonPoint)new LatLonPointImpl(this.getLat(slr), this.getLon(slr)), null);
            double distance = bearing.getDistance();
            double distancePerStep = distance / 30.0;
            if (distancePerStep != distancePerStep) {
                distancePerStep = 100.0;
            }
            llp = Bearing.findPoint(new LatLonPointImpl(this.getLat(this.location), this.getLon(this.location)), heading, distancePerStep, null);
            nextLocation = this.makePoint(llp.getLatitude(), llp.getLongitude(), 0.0);
            if (takeStep) {
                this.location = nextLocation;
                llp = Bearing.findPoint(new LatLonPointImpl(this.getLat(this.location), this.getLon(this.location)), heading, 100.0, null);
                nextLocation = this.makePoint(llp.getLatitude(), llp.getLongitude(), 0.0);
            }
            xyz1 = this.getXYZ(this.location);
            xyz2 = this.getXYZ(nextLocation);
            if (!forward) {
                double[] xyz3 = new double[]{xyz1[0] - (xyz2[0] - xyz1[0]), xyz1[1] - (xyz2[1] - xyz1[1]), xyz1[2] - (xyz2[2] - xyz1[2])};
                xyz2 = xyz3;
                this.location = navDisplay.getEarthLocation(xyz1[0], xyz1[1], xyz1[2], false);
            }
            this.goTo(new FlythroughPoint(this.location), xyz1, xyz2, null, false);
        }
        catch (Exception exc) {
            this.logException("Driving", exc);
        }
    }

    public double getLat(EarthLocation location) throws VisADException {
        return location.getLatitude().getValue(CommonUnit.degree);
    }

    public double getLon(EarthLocation location) throws VisADException {
        return location.getLongitude().getValue(CommonUnit.degree);
    }

    public double getAlt(EarthLocation location) throws VisADException {
        Real r = location.getAltitude();
        if (r == null) {
            return 0.0;
        }
        return r.getValue(CommonUnit.meter);
    }

    public void clearPoints() {
        this.flythrough(new ArrayList<FlythroughPoint>());
    }

    public void initEditMenu(JMenu editMenu) {
        editMenu.add(GuiUtils.makeMenuItem("Add Point", this, "addPointWithoutTime"));
        editMenu.add(GuiUtils.makeMenuItem("Add Point with Time", this, "addPointWithTime"));
        editMenu.add(GuiUtils.makeMenuItem("Fly along a latitude", this, "flyAlongLatitude"));
        editMenu.add(GuiUtils.makeMenuItem("Fly along a longitude", this, "flyAlongLongitude"));
        int cnt = this.pointsToUse.size();
        if (cnt > 0) {
            int[] strides = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 20, 50, 75, 100};
            JMenu strideMenu = new JMenu("Stride");
            editMenu.add(strideMenu);
            editMenu.add(GuiUtils.makeMenuItem("Remove all points (#" + cnt + ")", this, "clearPoints"));
            int[] nArray = strides;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                int s;
                final int theStride = s = nArray[i];
                JMenuItem mi = new JMenuItem((s == 1 ? "All points" : "Every " + s + " points") + "  " + (s == this.stride ? "(current)" : ""));
                mi.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        Flythrough.this.stride = theStride;
                        Flythrough.this.flythrough(Flythrough.this.allPoints);
                    }
                });
                strideMenu.add(mi);
            }
        }
        for (FlythroughDecorator decorator : this.decorators) {
            decorator.initEditMenu(editMenu);
        }
        editMenu.addSeparator();
        editMenu.add(GuiUtils.makeCheckboxMenuItem("Sharing On", this, "sharing", null));
        editMenu.add(GuiUtils.makeMenuItem("Set Share Group", this, "showSharableDialog"));
    }

    public void initFileMenu(JMenu fileMenu) {
        fileMenu.add(GuiUtils.makeMenuItem("Export", this, "doExport"));
        fileMenu.add(GuiUtils.makeMenuItem("Import", this, "doImport"));
        for (FlythroughDecorator decorator : this.decorators) {
            decorator.initFileMenu(fileMenu);
        }
    }

    public void initViewMenu(JMenu viewMenu) {
        JMenu dashboardMenu = new JMenu("Dashboard");
        viewMenu.add(dashboardMenu);
        viewMenu.add(GuiUtils.makeCheckboxMenuItem("Go to mouse click", this, "goToClick", null));
        viewMenu.add(GuiUtils.makeCheckboxMenuItem("Show animation", this, "showAnimation", null));
        viewMenu.add(GuiUtils.makeCheckboxMenuItem("Show line", this, "showLine", null));
        viewMenu.add(GuiUtils.makeCheckboxMenuItem("Show marker", this, "showMarker", null));
        for (FlythroughDecorator decorator : this.decorators) {
            decorator.initViewMenu(dashboardMenu);
        }
        dashboardMenu.add(GuiUtils.makeCheckboxMenuItem("Show gauges", this, "showReadout", null));
        dashboardMenu.add(GuiUtils.makeMenuItem("Clear data", this, "clearSamples"));
    }

    public void clearSamples() {
        for (FlythroughDecorator decorator : this.decorators) {
            decorator.clearSamples();
        }
        this.updateDashboard();
    }

    @Override
    public void setSharing(boolean sharing) {
        super.setSharing(sharing);
        if (this.animationWidget != null) {
            this.animationWidget.setSharing(sharing);
            this.animationInfo.setShared(true);
        }
    }

    @Override
    public void setShareGroup(Object shareGroup) {
        super.setShareGroup(shareGroup);
        if (this.animationWidget != null) {
            this.animationWidget.setShareGroup(shareGroup);
        }
    }

    private boolean showProperties(FlythroughPoint pt) {
        try {
            Object[] times = this.viewManager.getAnimationWidget().getTimes();
            JComboBox timeBox = null;
            JLabel timeLabel = GuiUtils.rLabel("Time:");
            Vector<Comparable> timesList = new Vector<Comparable>();
            timesList.add(0, new TwoFacedObject((Object)"None", null));
            if (times != null && times.length > 0) {
                timesList.addAll(Misc.toList(times));
            }
            if (pt.getDateTime() != null && !timesList.contains(pt.getDateTime())) {
                timesList.add(pt.getDateTime());
            }
            timeBox = new JComboBox(timesList);
            if (pt.getDateTime() != null) {
                timeBox.setSelectedItem(pt.getDateTime());
            }
            LatLonWidget llw = new LatLonWidget("Latitude: ", "Longitude: ", "Altitude: ", null){

                @Override
                protected String formatLatLonString(String latOrLon) {
                    return latOrLon;
                }
            };
            EarthLocation el = pt.getEarthLocation();
            llw.setLatLon(el.getLatitude().getValue(CommonUnit.degree), el.getLongitude().getValue(CommonUnit.degree));
            llw.setAlt(this.getAlt(el));
            JTextArea textArea = new JTextArea("", 5, 100);
            if (pt.getDescription() != null) {
                textArea.setText(pt.getDescription());
            }
            JScrollPane scrollPane = new JScrollPane(textArea);
            scrollPane.setPreferredSize(new Dimension(400, 300));
            JComponent contents = GuiUtils.formLayout(new Component[]{GuiUtils.rLabel("Location:"), llw, timeLabel, GuiUtils.left(timeBox), GuiUtils.rLabel("Description:"), scrollPane});
            if (!GuiUtils.showOkCancelDialog(this.frame, "Point Properties", contents, null)) {
                return false;
            }
            pt.setDescription(textArea.getText());
            pt.setEarthLocation(this.makePoint(llw.getLat(), llw.getLon(), llw.getAlt()));
            Object selectedDate = timeBox.getSelectedItem();
            if (selectedDate instanceof TwoFacedObject) {
                pt.setDateTime(null);
            } else {
                pt.setDateTime((DateTime)selectedDate);
            }
            return true;
        }
        catch (Exception exc) {
            this.logException("Showing point properties", exc);
            return false;
        }
    }

    private synchronized void doMakeContents(boolean force) throws Exception {
        if (!force && this.contents != null) {
            return;
        }
        if (this.contents == null) {
            this.makeWidgets();
        }
        this.animation.setAnimationInfo(this.animationInfo);
        this.showTimesCbx.setSelected(this.showTimes);
        this.showTimesCbx.setEnabled(this.hasTimes);
        this.animateCbx.setSelected(this.animate);
        this.changeViewpointCbx.setSelected(this.changeViewpoint);
        this.orientBox.setSelectedItem(TwoFacedObject.findId(this.orientation, this.orients));
        this.zoomFld.setText(Misc.format(this.zoom));
        for (int i = 0; i < this.tilt.length; ++i) {
            this.tiltSliders[i].setValue((int)this.tilt[i]);
            this.tiltLabels[i].setText("" + (int)this.tilt[i]);
        }
        this.setAnimationTimes();
        boolean hadFrame = true;
        if (this.frame == null) {
            this.frame = new JFrame(GuiUtils.getApplicationTitle() + "Flythrough");
            this.frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    if (Flythrough.this.locationLine != null) {
                        try {
                            Flythrough.this.locationLine.setVisible(false);
                            Flythrough.this.locationMarker.setVisible(false);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }

                @Override
                public void windowDeiconified(WindowEvent e) {
                    System.err.println("window");
                    if (Flythrough.this.locationLine != null) {
                        try {
                            Flythrough.this.locationLine.setVisible(Flythrough.this.showLine);
                            Flythrough.this.locationMarker.setVisible(Flythrough.this.showMarker);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            });
            this.frame.setIconImage(GuiUtils.getImage("/auxdata/ui/icons/plane.png"));
            hadFrame = false;
        }
        this.frame.getContentPane().removeAll();
        this.frame.getContentPane().add(this.contents);
        this.frame.pack();
        if (this.windowBounds != null) {
            this.frame.setLocation(this.windowBounds.x, this.windowBounds.y);
        }
        GuiUtils.toFront(this.frame);
    }

    private EarthLocation makePoint(String latitude, String longitude, String alt) throws VisADException, RemoteException {
        return this.makePoint(latitude == null ? 0.0 : new Double(latitude.trim()), longitude == null ? 0.0 : new Double(longitude.trim()), alt == null ? 0.0 : new Double(alt.trim()));
    }

    private EarthLocation makePoint(double latitude, double longitude, double alt) throws VisADException, RemoteException {
        Real altReal = new Real(RealType.Altitude, alt);
        return new EarthLocationLite(new Real(RealType.Latitude, latitude), new Real(RealType.Longitude, longitude), altReal);
    }

    private void importKml(Element root) {
        try {
            List tourNodes = XmlUtil.findDescendants(root, "gx:Tour");
            if (tourNodes.size() == 0) {
                LogUtil.userMessage("Could not find any tours");
                return;
            }
            Element tourNode = (Element)tourNodes.get(0);
            ArrayList<FlythroughPoint> thePoints = new ArrayList<FlythroughPoint>();
            Element playListNode = XmlUtil.findChild(tourNode, "gx:Playlist");
            if (playListNode == null) {
                LogUtil.userMessage("Could not find playlist");
                return;
            }
            NodeList elements = XmlUtil.getElements(playListNode);
            for (int i = 0; i < elements.getLength(); ++i) {
                Element child = (Element)elements.item(i);
                if (child.getTagName().equals("gx:FlyTo")) {
                    Element cameraNode = XmlUtil.findChild(child, "Camera");
                    if (cameraNode == null) {
                        cameraNode = XmlUtil.findChild(child, "LookAt");
                    }
                    if (cameraNode == null) continue;
                    FlythroughPoint pt = new FlythroughPoint(this.makePoint(XmlUtil.getGrandChildText(cameraNode, "latitude"), XmlUtil.getGrandChildText(cameraNode, "longitude"), XmlUtil.getGrandChildText(cameraNode, "altitude")));
                    pt.setTiltX(-new Double(XmlUtil.getGrandChildText(cameraNode, "tilt", "0")).doubleValue());
                    pt.setTiltY(new Double(XmlUtil.getGrandChildText(cameraNode, "heading", "0")));
                    pt.setTiltZ(new Double(XmlUtil.getGrandChildText(cameraNode, "roll", "0")));
                    thePoints.add(pt);
                    continue;
                }
                if (!child.getTagName().equals("gx:Wait")) continue;
            }
            this.flythrough(thePoints);
            this.doMakeContents(true);
            this.setAnimationTimes();
        }
        catch (Exception exc) {
            this.logException("Importing kml", exc);
        }
    }

    public void doImport() {
        try {
            String filename = FileManager.getReadFile(FileManager.FILTER_XML);
            if (filename == null) {
                return;
            }
            Element root = XmlUtil.getRoot(filename, this.getClass());
            if (root.getTagName().equals("kml")) {
                this.importKml(root);
                return;
            }
            if (!root.getTagName().equals(TAG_FLYTHROUGH)) {
                throw new IllegalStateException("Unknown tag:" + root.getTagName());
            }
            for (int i = 0; i < this.tilt.length; ++i) {
                this.tilt[i] = XmlUtil.getAttribute((Node)root, ATTR_TILT[i], this.tilt[i]);
            }
            this.zoom = XmlUtil.getAttribute((Node)root, ATTR_ZOOM, this.zoom);
            ArrayList<FlythroughPoint> thePoints = new ArrayList<FlythroughPoint>();
            NodeList elements = XmlUtil.getElements(root);
            for (int i = 0; i < elements.getLength(); ++i) {
                Element child = (Element)elements.item(i);
                if (!child.getTagName().equals("point")) {
                    throw new IllegalStateException("Unknown tag:" + child.getTagName());
                }
                FlythroughPoint pt = new FlythroughPoint();
                pt.setDescription(XmlUtil.getGrandChildText(child, TAG_DESCRIPTION));
                pt.setEarthLocation(this.makePoint(XmlUtil.getAttribute((Node)child, ATTR_LAT, 0.0), XmlUtil.getAttribute((Node)child, ATTR_LON, 0.0), XmlUtil.getAttribute((Node)child, ATTR_ALT, 0.0)));
                if (XmlUtil.hasAttribute(child, ATTR_DATE)) {
                    pt.setDateTime(this.parseDate(XmlUtil.getAttribute(child, ATTR_DATE)));
                }
                pt.setTiltX(XmlUtil.getAttribute((Node)child, ATTR_TILT[0], Double.NaN));
                pt.setTiltY(XmlUtil.getAttribute((Node)child, ATTR_TILT[1], Double.NaN));
                pt.setTiltZ(XmlUtil.getAttribute((Node)child, ATTR_TILT[2], Double.NaN));
                pt.setZoom(XmlUtil.getAttribute((Node)child, ATTR_ZOOM, Double.NaN));
                String matrixS = XmlUtil.getAttribute((Node)child, ATTR_MATRIX, (String)null);
                if (matrixS != null) {
                    List<String> toks = StringUtil.split(matrixS, ",", true, true);
                    double[] m = new double[toks.size()];
                    for (int tokIdx = 0; tokIdx < m.length; ++tokIdx) {
                        m[tokIdx] = new Double(toks.get(tokIdx));
                    }
                    pt.setMatrix(m);
                }
                thePoints.add(pt);
            }
            this.flythrough(thePoints);
            this.doMakeContents(true);
            this.setAnimationTimes();
        }
        catch (Exception exc) {
            this.logException("Initializing flythrough", exc);
        }
    }

    private String formatDate(DateTime dttm) throws Exception {
        return this.sdf.format(Util.makeDate(dttm));
    }

    private DateTime parseDate(String dttm) throws Exception {
        return new DateTime(this.sdf.parse(dttm));
    }

    public FlythroughPoint addPointWithoutTime() {
        return this.addPoint(false);
    }

    public void flyAlongLatitude() throws VisADException, RemoteException {
        double value = 0.0;
        String s = "0.0";
        while (true) {
            if ((s = GuiUtils.getInput("Please enter a latitude between -90 and 90", "Latitude: ", s)) == null) {
                return;
            }
            try {
                value = Misc.parseDouble(s.trim());
            }
            catch (Exception exc) {
                GuiUtils.showOkDialog(null, "Oops", new JLabel("Please enter a value between -90 and 90"), null);
                continue;
            }
            break;
        }
        ArrayList<FlythroughPoint> pts = new ArrayList<FlythroughPoint>();
        for (double other = 0.0; other < 360.0; other += 1.0) {
            EarthLocationTuple pt = new EarthLocationTuple(value, other, 0.0);
            pts.add(new FlythroughPoint(pt));
        }
        this.flythrough(pts);
    }

    public void flyAlongLongitude() throws VisADException, RemoteException {
        double value = 0.0;
        String s = "0.0";
        while (true) {
            if ((s = GuiUtils.getInput("Please enter a longitude between -180 and 180", "Longitude: ", s)) == null) {
                return;
            }
            try {
                value = Misc.parseDouble(s.trim());
            }
            catch (Exception exc) {
                GuiUtils.showOkDialog(null, "Oops", new JLabel("Please enter a value between -90 and 90"), null);
                continue;
            }
            break;
        }
        ArrayList<FlythroughPoint> pts = new ArrayList<FlythroughPoint>();
        for (double other = 90.0; other >= -90.0; other -= 1.0) {
            EarthLocationTuple pt = new EarthLocationTuple(other, value, 0.0);
            pts.add(new FlythroughPoint(pt));
        }
        this.flythrough(pts);
    }

    public FlythroughPoint addPointWithTime() {
        return this.addPoint(true);
    }

    public FlythroughPoint addPoint(boolean includeTime) {
        try {
            Real dttm;
            FlythroughPoint pt = new FlythroughPoint();
            pt.setEarthLocation(this.makePoint(0.0, 0.0, 0.0));
            NavigatedDisplay navDisplay = this.viewManager.getNavigatedDisplay();
            double[] currentMatrix = navDisplay.getProjectionMatrix();
            if (includeTime && (dttm = this.viewManager.getAnimation().getCurrentAnimationValue()) != null) {
                pt.setDateTime(new DateTime(dttm));
            }
            pt.setMatrix(currentMatrix);
            this.allPoints.add(pt);
            this.flythrough(this.allPoints);
            return pt;
        }
        catch (Exception exc) {
            this.logException("Adding point", exc);
            return null;
        }
    }

    public void doExport() {
        try {
            String filename = FileManager.getWriteFile(FileManager.FILTER_XML, ".xml");
            if (filename == null) {
                return;
            }
            Document doc = XmlUtil.makeDocument();
            Element root = doc.createElement(TAG_FLYTHROUGH);
            for (int i = 0; i < this.tilt.length; ++i) {
                root.setAttribute(ATTR_TILT[i], "" + this.tilt[i]);
            }
            root.setAttribute(ATTR_ZOOM, "" + this.getZoom());
            List<FlythroughPoint> thePoints = this.pointsToUse;
            for (FlythroughPoint pt : thePoints) {
                double[] m;
                Element ptNode = XmlUtil.create("point", root);
                if (pt.getDescription() != null) {
                    XmlUtil.create(root.getOwnerDocument(), TAG_DESCRIPTION, ptNode, pt.getDescription());
                }
                EarthLocation el = pt.getEarthLocation();
                if (pt.getDateTime() != null) {
                    ptNode.setAttribute(ATTR_DATE, this.formatDate(pt.getDateTime()));
                }
                ptNode.setAttribute(ATTR_LAT, "" + el.getLatitude().getValue(CommonUnit.degree));
                ptNode.setAttribute(ATTR_LON, "" + el.getLongitude().getValue(CommonUnit.degree));
                ptNode.setAttribute(ATTR_ALT, "" + this.getAlt(el));
                if (pt.hasTiltX()) {
                    ptNode.setAttribute(ATTR_TILT[0], "" + pt.getTiltX());
                }
                if (pt.hasTiltY()) {
                    ptNode.setAttribute(ATTR_TILT[1], "" + pt.getTiltY());
                }
                if (pt.hasTiltZ()) {
                    ptNode.setAttribute(ATTR_TILT[2], "" + pt.getTiltZ());
                }
                if (pt.hasZoom()) {
                    ptNode.setAttribute(ATTR_ZOOM, "" + pt.getZoom());
                }
                if ((m = pt.getMatrix()) == null) continue;
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < m.length; ++i) {
                    if (i > 0) {
                        sb.append(",");
                    }
                    sb.append(m[i]);
                }
                ptNode.setAttribute(ATTR_MATRIX, sb.toString());
            }
            String xml = XmlUtil.toString(root);
            IOUtil.writeFile(filename, xml);
        }
        catch (Exception exc) {
            this.logException("Exporting flythrough", exc);
        }
    }

    public void show() {
        if (this.frame == null) {
            try {
                this.doMakeContents(false);
            }
            catch (Exception exc) {
                this.logException("Showing flythrough", exc);
            }
        }
        this.setAnimationTimes();
        if (this.frame != null) {
            this.frame.setVisible(true);
        }
    }

    public boolean isActive() {
        if (this.frame == null || this.viewManager == null) {
            return false;
        }
        return this.frame.isShowing();
    }

    private double[] getXYZ(EarthLocation el) throws VisADException, RemoteException {
        NavigatedDisplay navDisplay = this.viewManager.getNavigatedDisplay();
        double alt = this.getAlt(el);
        if (this.doGlobe() && alt == 0.0) {
            alt = 100.0;
        }
        return navDisplay.getSpatialCoordinates(el, null, alt);
    }

    private void doStep(int index) throws Exception {
        if (index < this.lastIndex) {
            this.clearSamples();
        }
        this.lastIndex = index;
        this.lastMoveWasTrack = true;
        if (this.pointsToUse.size() == 0 || !this.isActive()) {
            return;
        }
        if (this.viewManager == null) {
            return;
        }
        List<FlythroughPoint> thePoints = this.pointsToUse;
        NavigatedDisplay navDisplay = this.viewManager.getNavigatedDisplay();
        double[] xyz1 = new double[]{0.0, 0.0, 0.0};
        double[] xyz2 = new double[]{0.0, 0.0, 0.0};
        double[] actualPoint = new double[]{0.0, 0.0, 0.0};
        if (index >= thePoints.size()) {
            index = 0;
        } else if (index < 0) {
            index = thePoints.size() - 1;
        }
        if (this.pointTable != null) {
            this.pointTable.getSelectionModel().setSelectionInterval(index, index);
            this.pointTable.repaint();
        }
        int index1 = index;
        int index2 = index + 1;
        boolean atEnd = false;
        if (index2 >= thePoints.size()) {
            index2 = 0;
            atEnd = true;
        }
        FlythroughPoint pt1 = thePoints.get(index1);
        FlythroughPoint pt2 = thePoints.get(index2);
        xyz1 = this.getXYZ(pt1.getEarthLocation());
        xyz2 = this.getXYZ(pt2.getEarthLocation());
        actualPoint = xyz2;
        if (this.orientation.equals("forward")) {
            int ptCnt = 0;
            double[] sum = new double[]{0.0, 0.0, 0.0};
            double[] tmp = new double[]{0.0, 0.0, 0.0};
            int max = 10;
            for (int ptIdx = index2; ptIdx < thePoints.size() && ptCnt < max; ++ptIdx) {
                tmp = this.getXYZ(thePoints.get(ptIdx).getEarthLocation());
                if (tmp[0] != tmp[0] || tmp[1] != tmp[1] || tmp[2] != tmp[2]) continue;
                ++ptCnt;
                sum[0] = sum[0] + tmp[0];
                sum[1] = sum[1] + tmp[1];
                sum[2] = sum[2] + tmp[2];
            }
            xyz2 = new double[]{sum[0] / (double)ptCnt, sum[1] / (double)ptCnt, sum[2] / (double)ptCnt};
        }
        float x1 = (float)xyz1[0];
        float y1 = (float)xyz1[1];
        float z1 = (float)xyz1[2];
        if (atEnd && thePoints.size() > 1 && index1 > 0) {
            FlythroughPoint prevPt = thePoints.get(index1 - 1);
            double[] xyz3 = this.getXYZ(prevPt.getEarthLocation());
            xyz2 = new double[]{(double)x1 + ((double)x1 - xyz3[0]), (double)y1 + ((double)y1 - xyz3[1]), (double)z1 + ((double)z1 - xyz3[2])};
            actualPoint = xyz2;
        }
        this.goTo(pt1, xyz1, xyz2, actualPoint, this.getAnimate());
    }

    protected void goTo(FlythroughPoint pt1, double[] xyz1, double[] xyz2, double[] actualPoint, boolean animateMove) {
        this.currentHeading = 180.0;
        if (actualPoint == null) {
            actualPoint = xyz2;
        }
        NavigatedDisplay navDisplay = this.viewManager.getNavigatedDisplay();
        MouseBehavior mouseBehavior = navDisplay.getMouseBehavior();
        double[] currentMatrix = navDisplay.getProjectionMatrix();
        double[] aspect = navDisplay.getDisplayAspect();
        try {
            DateTime dttm;
            double tiltz;
            double zoom;
            if (pt1.getDescription() != null) {
                this.getHtmlView().setText(pt1.getDescription());
            } else {
                this.getHtmlView().setText("");
            }
            this.processReadout(pt1);
            float x1 = (float)xyz1[0];
            float y1 = (float)xyz1[1];
            float z1 = (float)xyz1[2];
            float x2 = (float)xyz2[0];
            float y2 = (float)xyz2[1];
            float z2 = (float)xyz2[2];
            double d = zoom = pt1.hasZoom() ? pt1.getZoom() : this.getZoom();
            if (zoom == 0.0) {
                zoom = 0.1;
            }
            double tiltx = pt1.hasTiltX() ? pt1.getTiltX() : this.tilt[0];
            double tilty = pt1.hasTiltY() ? pt1.getTiltY() : this.tilt[1];
            double d2 = tiltz = pt1.hasTiltZ() ? pt1.getTiltZ() : this.tilt[2];
            if (x2 != x2 || y2 != y2 || z2 != z2) {
                return;
            }
            if (x1 != x1 || y1 != y1 || z1 != z1) {
                return;
            }
            double[] m = pt1.getMatrix();
            if (m == null) {
                m = new double[16];
                Transform3D t = new Transform3D();
                if (this.orientation.equals(ORIENT_UP)) {
                    y2 = y1 + 100.0f;
                    x2 = x1;
                } else if (this.orientation.equals(ORIENT_DOWN)) {
                    y2 = y1 - 100.0f;
                    x2 = x1;
                } else if (this.orientation.equals("left")) {
                    x2 = x1 - 100.0f;
                    y2 = y1;
                } else if (this.orientation.equals("right")) {
                    x2 = x1 + 100.0f;
                    y2 = y1;
                }
                if (x1 == x2 && y1 == y2 && z1 == z2) {
                    return;
                }
                Vector3d upVector = this.doGlobe() ? new Vector3d((double)x1, (double)y1, (double)z1) : new Vector3d(0.0, 0.0, 1.0);
                Point3d p1 = new Point3d((double)x1, (double)y1, (double)z1);
                Point3d p2 = new Point3d((double)x2, (double)y2, (double)(!this.getUseFixedZ() || this.doGlobe() ? z2 : z1));
                t.lookAt(p1, p2, upVector);
                t.get(m);
                EarthLocation el1 = navDisplay.getEarthLocation(p1.x, p1.y, p1.z, false);
                EarthLocation el2 = navDisplay.getEarthLocation(p2.x, p2.y, p2.z, false);
                Bearing bearing = Bearing.calculateBearing(new LatLonPointImpl(this.getLat(el1), this.getLon(el1)), (LatLonPoint)new LatLonPointImpl(this.getLat(el2), this.getLon(el2)), null);
                this.currentHeading = bearing.getAngle();
                double[] tiltMatrix = mouseBehavior.make_matrix(tiltx, tilty, tiltz, 1.0, 1.0, 1.0, 0.0, 0.0, 0.0);
                m = mouseBehavior.multiply_matrix(tiltMatrix, m);
                if (aspect != null) {
                    double[] dArray = mouseBehavior.make_matrix(0.0, 0.0, 0.0, aspect[0], aspect[1], aspect[2], 0.0, 0.0, 0.0);
                }
                double[] scaleMatrix = mouseBehavior.make_matrix(0.0, 0.0, 0.0, zoom, 0.0, 0.0, 0.0);
                m = mouseBehavior.multiply_matrix(scaleMatrix, m);
            }
            this.currentPoint = pt1;
            this.location = this.currentPoint.getEarthLocation();
            if (this.doGlobe()) {
                this.setPts(this.locationLine, 0.0f, x1 * 2.0f, 0.0f, y1 * 2.0f, 0.0f, z1 * 2.0f);
            } else {
                this.setPts(this.locationLine, x1, x1, y1, y1, 1.0f, -1.0f);
            }
            RealTuple markerLocation = new RealTuple(RealTupleType.SpatialCartesian3DTuple, new double[]{x1, y1, z1});
            if (xyz1[0] != xyz2[0]) {
                Transform3D rotTransform;
                VisADGeometryArray marker = (VisADGeometryArray)this.getMarker().clone();
                double rotx = 0.0;
                double roty = 0.0;
                double rotz = 0.0;
                rotz = -Math.toDegrees(Math.atan2(actualPoint[1] - xyz1[1], actualPoint[0] - xyz1[0])) + 90.0;
                if (this.doGlobe()) {
                    Vector3d upVector = new Vector3d((double)x1, (double)y1, (double)z1);
                    rotTransform = new Transform3D();
                    rotTransform.lookAt(new Point3d((double)x1, (double)y1, (double)z1), new Point3d((double)x2, (double)y2, (double)z2), upVector);
                    Matrix3d m3d = new Matrix3d();
                    rotTransform.get(m3d);
                    rotTransform = new Transform3D(m3d, new Vector3d(0.0, 0.0, 0.0), 1.0);
                    rotTransform.invert();
                    ShapeUtility.rotate(marker, rotTransform);
                } else {
                    double[] markerM = navDisplay.getMouseBehavior().make_matrix(rotx, roty, rotz, 1.0, 0.0, 0.0, 0.0);
                    rotTransform = new Transform3D(markerM);
                    ShapeUtility.rotate(marker, rotTransform);
                }
                this.locationMarker.setPoint(markerLocation, marker);
            } else {
                this.locationMarker.setPoint(markerLocation);
            }
            this.locationLine.setVisible(this.showLine);
            this.locationMarker.setVisible(this.showMarker);
            if (this.hasTimes && this.getShowTimes() && (dttm = pt1.getDateTime()) != null) {
                this.viewManager.getAnimationWidget().setTimeFromUser(dttm);
            }
            if (this.changeViewpointCbx.isSelected()) {
                if (animateMove) {
                    navDisplay.animateMatrix(m, this.animationSpeed);
                } else {
                    navDisplay.setProjectionMatrix(m);
                }
            }
            if (!Misc.equals(this.lastLocation, pt1.getEarthLocation())) {
                this.lastLocation = pt1.getEarthLocation();
                EarthLocationTuple tuplePosition = new EarthLocationTuple(this.lastLocation.getLatitude(), this.lastLocation.getLongitude(), this.lastLocation.getAltitude());
                this.doShare((Object)"ProbeControl.SHARE_POSITION", tuplePosition);
            }
        }
        catch (NumberFormatException exc) {
            this.logException("Error parsing number:" + exc, exc);
        }
        catch (BadTransformException bte) {
            try {
                navDisplay.setProjectionMatrix(currentMatrix);
            }
            catch (Exception exception) {}
        }
        catch (Exception exc) {
            this.logException("Error", exc);
            if (this.animationWidget != null) {
                this.animationWidget.setRunning(false);
            }
            return;
        }
    }

    public boolean doGlobe() {
        if (this.viewManager != null) {
            return this.viewManager.getUseGlobeDisplay();
        }
        return false;
    }

    public VisADGeometryArray getMarker() {
        if (this.marker == null) {
            this.marker = this.doGlobe() ? ShapeUtility.setSize(ShapeUtility.createShape("CROSS")[0], 0.1f) : ShapeUtility.setSize(ShapeUtility.createShape("AIRPLANE3D")[0], 0.1f);
        }
        return this.marker;
    }

    public void logException(String msg, Throwable exc) {
        LogUtil.logException(msg, exc);
    }

    public void displayControlChanged() {
        this.doUpdate();
    }

    public void doUpdate() {
        FlythroughPoint pt1 = this.getCurrentPoint();
        if (pt1 != null) {
            try {
                this.processReadout(pt1);
            }
            catch (Exception exc) {
                this.logException("Setting readout", exc);
            }
        }
    }

    public void animationTimeChanged() {
        this.doUpdate();
    }

    protected void processReadout(FlythroughPoint pt1) throws Exception {
        Font font = new Font("Dialog", 1, 22);
        this.dials = new ArrayList<JComponent>();
        if (this.readoutLabel == null || pt1 == null) {
            return;
        }
        ArrayList<ReadoutInfo> samples = new ArrayList<ReadoutInfo>();
        this.readoutLabel.setText(this.readout.getReadout(pt1.getEarthLocation(), this.showReadout, true, samples));
        if (!this.showReadout) {
            return;
        }
        ArrayList<ChartPanel> comps = new ArrayList<ChartPanel>();
        for (FlythroughDecorator decorator : this.decorators) {
            decorator.handleReadout(pt1, samples);
        }
        for (ReadoutInfo info : samples) {
            double v;
            Real r = info.getReal();
            if (r == null) continue;
            Unit unit = info.getUnit();
            if (unit == null) {
                unit = r.getUnit();
            }
            String name = Util.cleanTypeName(r.getType());
            String unitSuffix = "";
            if (unit != null) {
                unitSuffix = " [" + unit + "]";
            }
            if ((v = r.getValue(unit)) == v) {
                v = Misc.parseNumber(Misc.format(v));
            }
            JLabel label = new JLabel(name.replace("_", " "));
            label.setFont(font);
            DefaultValueDataset dataset = new DefaultValueDataset((Number)new Double(v));
            MeterPlot plot = new MeterPlot((ValueDataset)dataset);
            if (info.getRange() != null) {
                ucar.unidata.util.Range range = info.getRange();
                plot.setRange(new Range(range.getMin(), range.getMax()));
            }
            if (unit != null) {
                plot.setUnits(unit.toString());
            } else {
                plot.setUnits("");
            }
            plot.setDialBackgroundPaint((Paint)Color.white);
            plot.setTickLabelsVisible(true);
            plot.setValueFont(font);
            plot.setTickLabelFont(font);
            plot.setTickLabelPaint((Paint)Color.darkGray);
            plot.setTickPaint((Paint)Color.black);
            plot.setValuePaint((Paint)Color.black);
            JFreeChart chart = new JFreeChart("", (Plot)plot);
            TextTitle title = new TextTitle(" " + label.getText() + " ", font);
            title.setBackgroundPaint((Paint)Color.gray);
            title.setPaint((Paint)Color.white);
            chart.setTitle(title);
            ChartPanel chartPanel = new ChartPanel(chart);
            chartPanel.setPreferredSize(this.dialDimension);
            chartPanel.setSize(new Dimension(150, 150));
            plot.setBackgroundPaint((Paint)new Color(255, 255, 255, 0));
            plot.setBackgroundImageAlpha(0.0f);
            chart.setBackgroundPaint((Paint)new Color(255, 255, 255, 0));
            chartPanel.setBackground(new Color(255, 255, 255, 0));
            comps.add(chartPanel);
            this.dials.add((JComponent)chartPanel);
        }
        this.readoutDisplay.removeAll();
        this.updateDashboard();
    }

    public FlythroughPoint getCurrentPoint() {
        return this.currentPoint;
    }

    public void setPoints(List<FlythroughPoint> value) {
        this.allPoints = value;
    }

    public List<FlythroughPoint> getPoints() {
        return this.allPoints;
    }

    public List<FlythroughPoint> getPointsToUse() {
        return this.pointsToUse;
    }

    public boolean hasPoints() {
        return this.allPoints.size() > 0;
    }

    public void setTiltX(double value) {
    }

    public void setTiltY(double value) {
    }

    public void setTiltZ(double value) {
    }

    public void setTilt(double[] value) {
        this.tilt = value;
    }

    public double[] getTilt() {
        return this.tilt;
    }

    public void setZoom(double value) {
        this.zoom = value;
    }

    public double getZoom() {
        if (this.zoomFld != null) {
            this.zoom = this.parse(this.zoomFld, this.zoom);
        }
        return this.zoom;
    }

    public void setChangeViewpoint(boolean value) {
        this.changeViewpoint = value;
    }

    public boolean getChangeViewpoint() {
        if (this.changeViewpointCbx != null) {
            return this.changeViewpointCbx.isSelected();
        }
        return this.changeViewpoint;
    }

    public void setShowReadout(boolean value) {
        this.showReadout = value;
        this.updateDashboard();
    }

    public boolean getShowReadout() {
        return this.showReadout;
    }

    public void setShowTimes(boolean value) {
        this.showTimes = value;
    }

    public boolean getShowTimes() {
        if (this.showTimesCbx != null) {
            this.showTimes = this.showTimesCbx.isSelected();
        }
        return this.showTimes;
    }

    public void setShowLine(boolean value) {
        this.showLine = value;
        if (this.locationLine != null) {
            try {
                this.locationLine.setVisible(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.locationLine2 != null) {
            try {
                this.locationLine2.setVisible(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean getShowLine() {
        return this.showLine;
    }

    public void setShowMarker(boolean value) {
        this.showMarker = value;
        if (this.locationMarker != null) {
            try {
                this.locationMarker.setVisible(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean getShowMarker() {
        return this.showMarker;
    }

    public void setAnimate(boolean value) {
        this.animate = value;
    }

    public boolean getAnimate() {
        if (this.animateCbx != null) {
            this.animate = this.animateCbx.isSelected();
        }
        return this.animate;
    }

    public void setRelativeOrientation(boolean value) {
    }

    public void setOrientation(String value) {
        this.orientation = value;
    }

    public String getOrientation() {
        return this.orientation;
    }

    public void setShown(boolean value) {
        this.shown = value;
    }

    public boolean getShown() {
        if (this.frame != null) {
            return this.frame.isShowing();
        }
        return this.shown;
    }

    public void setClip(boolean value) throws Exception {
    }

    public void setUseFixedZ(boolean value) {
        this.useFixedZ = value;
    }

    public boolean getUseFixedZ() {
        return this.useFixedZ;
    }

    public void setCurrentIndex(int value) {
        this.currentIndex = value;
    }

    public int getCurrentIndex() {
        if (this.animation != null) {
            try {
                this.currentIndex = this.animation.getCurrent();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.currentIndex;
    }

    public void setAnimateSpeed(long value) {
    }

    public void setAnimationSpeed(int value) {
        this.animationSpeed = value;
    }

    public int getAnimationSpeed() {
        return this.animationSpeed;
    }

    public void setLocation(EarthLocation value) {
        this.location = value;
    }

    public EarthLocation getLocation() {
        return this.location;
    }

    public void setHeading(double value) {
        this.heading = value;
    }

    public double getHeading() {
        return this.heading;
    }

    public void setFrameLocation(Point value) {
    }

    public void setGoToClick(boolean value) {
        this.goToClick = value;
    }

    public boolean getGoToClick() {
        return this.goToClick;
    }

    public void setShowChart(boolean value) {
    }

    public void setShowDecoration(boolean value) {
        this.showDecoration = value;
        this.updateDashboard();
    }

    public boolean getShowDecoration() {
        return this.showDecoration;
    }

    public void setShowAnimation(boolean value) {
        this.showAnimation = value;
        if (this.animationWidget != null) {
            this.animationWidget.getContents().setVisible(this.showAnimation);
        }
    }

    public boolean getShowAnimation() {
        return this.showAnimation;
    }

    public void setAnimationInfo(AnimationInfo value) {
        this.animationInfo = value;
    }

    public AnimationInfo getAnimationInfo() {
        if (this.animationWidget != null) {
            this.animationInfo = this.animationWidget.getAnimationInfo();
        }
        return this.animationInfo;
    }

    public void setWindowBounds(Rectangle value) {
        this.windowBounds = value;
    }

    public Rectangle getWindowBounds() {
        if (this.frame != null) {
            this.windowBounds = this.frame.getBounds();
        }
        return this.windowBounds;
    }

    public void setMaxPoints(int value) {
    }

    public void setStride(int value) {
        this.stride = value;
    }

    public int getStride() {
        return this.stride;
    }

    public void setDecorators(List<FlythroughDecorator> value) {
        this.decorators = value;
    }

    public List<FlythroughDecorator> getDecorators() {
        return this.decorators;
    }
}

