/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.flythrough;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.Range;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeriesCollection;
import ucar.unidata.idv.control.ReadoutInfo;
import ucar.unidata.idv.flythrough.Flythrough;
import ucar.unidata.idv.flythrough.FlythroughDecorator;
import ucar.unidata.idv.flythrough.FlythroughPoint;
import ucar.unidata.idv.flythrough.SampleInfo;
import ucar.unidata.ui.ImageUtils;
import ucar.unidata.util.FileManager;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.Misc;
import ucar.visad.Util;
import visad.Real;
import visad.Unit;
import visad.georef.EarthLocation;

public class ChartDecorator
extends FlythroughDecorator {
    private boolean collectSamples = false;
    private Hashtable<String, SampleInfo> sampleMap = new Hashtable();
    private List<SampleInfo> sampleInfos = new ArrayList<SampleInfo>();
    public static final Color[] COLORS = new Color[]{Color.blue, Color.red, Color.green, Color.orange, Color.cyan, Color.magenta, Color.pink, Color.yellow};
    private Image lastChartImage;

    public ChartDecorator() {
    }

    public ChartDecorator(Flythrough flythrough) {
        super(flythrough);
    }

    @Override
    public void initViewMenu(JMenu viewMenu) {
        viewMenu.add(GuiUtils.makeCheckboxMenuItem("Collect data", this, "collectSamples", null));
        super.initViewMenu(viewMenu);
    }

    @Override
    public void initFileMenu(JMenu fileMenu) {
        super.initFileMenu(fileMenu);
        if (this.sampleInfos.size() > 0) {
            fileMenu.add(GuiUtils.makeMenuItem("Write data", this, "writeData"));
        }
    }

    public void writeData() {
        try {
            String filename = FileManager.getWriteFile(FileManager.FILTER_CSV, ".csv");
            if (filename == null) {
                return;
            }
            StringBuffer sb = new StringBuffer();
            ArrayList<SampleInfo> infos = new ArrayList<SampleInfo>(this.sampleInfos);
            for (int i = 0; i < infos.size(); ++i) {
                SampleInfo sampleInfo = (SampleInfo)infos.get(i);
                List<Real> values = sampleInfo.getValues();
                List<EarthLocation> locations = sampleInfo.getLocations();
                sb.append("parameter:");
                sb.append(sampleInfo.getName());
                sb.append("\n");
                for (int j = 0; j < values.size(); ++j) {
                    EarthLocation el = locations.get(j);
                    sb.append(el.getLatitude());
                    sb.append(",");
                    sb.append(el.getLongitude());
                    sb.append(",");
                    sb.append(values.get(j));
                    sb.append("\n");
                }
            }
            IOUtil.writeFile(filename, sb.toString());
        }
        catch (Exception exc) {
            this.logException("Exporting data", exc);
        }
    }

    @Override
    public void handleReadout(FlythroughPoint pt, List<ReadoutInfo> samples) throws Exception {
        for (ReadoutInfo info : samples) {
            Real r = info.getReal();
            if (r == null) continue;
            Unit unit = info.getUnit();
            if (unit == null) {
                unit = r.getUnit();
            }
            String name = Util.cleanTypeName(r.getType());
            if (!this.collectSamples || Misc.equals(this.flythrough.getLastLocation(), pt.getEarthLocation())) continue;
            SampleInfo sampleInfo = this.sampleMap.get(name);
            if (sampleInfo == null) {
                sampleInfo = new SampleInfo(name, unit, info.getRange());
                this.sampleInfos.add(sampleInfo);
                this.sampleMap.put(name, sampleInfo);
            }
            sampleInfo.add(r, info.getLocation());
            this.lastChartImage = null;
        }
    }

    @Override
    public String getName() {
        return "track chart";
    }

    @Override
    public void clearSamples() {
        super.clearSamples();
        this.sampleMap = new Hashtable();
        this.sampleInfos = new ArrayList<SampleInfo>();
        this.lastChartImage = null;
    }

    @Override
    public boolean paintDashboard(Graphics2D g2, JComponent comp) {
        try {
            Image image;
            ArrayList<SampleInfo> infos = new ArrayList<SampleInfo>(this.sampleInfos);
            if (infos.size() == 0) {
                return false;
            }
            Rectangle b = comp.getBounds();
            JFrame dummyFrame = new JFrame("");
            XYSeriesCollection dataset = new XYSeriesCollection();
            JFreeChart chart = Flythrough.createChart((XYDataset)dataset);
            XYPlot xyPlot = (XYPlot)chart.getPlot();
            int chartHeight = b.height - this.flythrough.getDashboardImage().getHeight(null);
            chartHeight = Math.max(chartHeight, 50);
            int chartWidth = Math.min(chartHeight * 4, b.width);
            int dx = b.width / 2 - chartWidth / 2;
            int dy = 0;
            Image lastImage = this.lastChartImage;
            if (lastImage != null && lastImage.getWidth(null) == chartWidth && lastImage.getHeight(null) == chartHeight) {
                g2.translate(dx, dy);
                g2.drawImage(lastImage, 0, 0, null);
                g2.translate(-dx, -dy);
                return false;
            }
            for (int i = 0; i < infos.size(); ++i) {
                SampleInfo info = (SampleInfo)infos.get(i);
                NumberAxis rangeAxis = new NumberAxis(info.getName());
                if (info.getRange() != null) {
                    rangeAxis.setRange(new Range(info.getRange().getMin(), info.getRange().getMax()));
                }
                dataset = new XYSeriesCollection();
                dataset.addSeries(info.getSeries());
                xyPlot.setRangeAxis(i, (ValueAxis)rangeAxis, false);
                xyPlot.setDataset(i, (XYDataset)dataset);
                xyPlot.mapDatasetToRangeAxis(i, i);
                final Color color = COLORS[i % COLORS.length];
                XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer(true, false){

                    public Paint xgetItemPaint(int row, int column) {
                        return color;
                    }
                };
                renderer.setSeriesPaint(0, (Paint)color);
                xyPlot.setRenderer(i, (XYItemRenderer)renderer);
            }
            ChartPanel chartPanel = new ChartPanel(chart);
            chartPanel.setPreferredSize(new Dimension(chartWidth, chartHeight));
            dummyFrame.setContentPane((Container)chartPanel);
            dummyFrame.pack();
            this.lastChartImage = image = ImageUtils.getImage((Component)chartPanel);
            g2.translate(dx, dy);
            g2.drawImage(image, 0, 0, null);
            g2.translate(-dx, -dy);
        }
        catch (Exception exc) {
            this.logException("Painting chart", exc);
        }
        return false;
    }

    public void setCollectSamples(boolean value) {
        this.collectSamples = value;
    }

    public boolean getCollectSamples() {
        return this.collectSamples;
    }
}

