/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control.storm;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import ucar.unidata.data.storm.StormTrack;
import ucar.unidata.idv.control.storm.StormDisplayState;
import ucar.unidata.idv.control.storm.StormTrackControl;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.visad.Util;
import ucar.visad.display.StationModelDisplayable;
import ucar.visad.display.TrackDisplayable;
import visad.Data;
import visad.DateTime;
import visad.FieldImpl;

public class YearDisplayState {
    public static final int STATE_INACTIVE = 0;
    public static final int STATE_LOADING = 1;
    public static final int STATE_ACTIVE = 2;
    private static int[] nextColor = new int[]{0};
    private StormTrackControl stormTrackControl;
    private int year;
    private Color color;
    private int state = 0;
    private TrackDisplayable trackDisplay;
    private StationModelDisplayable labelDisplay;
    private List<StormTrack> stormTracks = new ArrayList<StormTrack>();
    private JLabel label;
    private JButton button;
    private GuiUtils.ColorSwatch colorSwatch;
    private List pointObs;

    public YearDisplayState() {
    }

    public YearDisplayState(StormTrackControl stormTrackControl, int year) {
        this.stormTrackControl = stormTrackControl;
        this.year = year;
        this.color = StormDisplayState.getNextColor(nextColor);
    }

    protected JComponent getColorSwatch() {
        if (this.colorSwatch == null) {
            this.colorSwatch = new GuiUtils.ColorSwatch(this.getColor(), "Set track color"){

                @Override
                public void setBackground(Color newColor) {
                    super.setBackground(newColor);
                    YearDisplayState.this.color = newColor;
                    if (YearDisplayState.this.trackDisplay != null) {
                        try {
                            YearDisplayState.this.trackDisplay.setColor(newColor);
                        }
                        catch (Exception exc) {
                            LogUtil.logException("Setting color", exc);
                        }
                    }
                }
            };
            this.colorSwatch.setMinimumSize(new Dimension(15, 15));
            this.colorSwatch.setPreferredSize(new Dimension(15, 15));
        }
        return this.colorSwatch;
    }

    public String toString() {
        return "" + this.year;
    }

    protected List getPointObs() {
        return this.pointObs;
    }

    public void setData(boolean doYearTime, List<StormTrack> tracks, List times, List fields, List pointObs) throws Exception {
        this.pointObs = pointObs;
        this.stormTracks.clear();
        this.stormTracks.addAll(tracks);
        if (this.trackDisplay == null) {
            this.trackDisplay = new TrackDisplayable("year track ");
            this.trackDisplay.setLineWidth(2.0f);
            this.stormTrackControl.addDisplayable(this.trackDisplay);
            this.trackDisplay.setColor(this.color);
        }
        if (doYearTime) {
            DateTime dttm = (DateTime)times.get(0);
            this.trackDisplay.setOverrideAnimationSet(Misc.newList(dttm));
            Data[] datas = fields.toArray(new Data[fields.size()]);
            times = Misc.newList(new DateTime(dttm.cloneButValue(dttm.getValue() - 1000.0)), dttm, new DateTime(dttm.cloneButValue(dttm.getValue() + 1000.0)));
            FieldImpl indexField = Util.indexedField(datas, false);
            fields = Misc.newList(indexField, indexField, indexField);
            this.trackDisplay.setTrack(Util.makeTimeField(fields, times));
        } else {
            this.trackDisplay.setOverrideAnimationSet((List)null);
            this.trackDisplay.setTrack(Util.makeTimeField(fields, times));
        }
    }

    public JButton getButton() {
        if (this.button == null) {
            this.button = new JButton("");
            GuiUtils.setFixedWidthFont(this.button);
            this.setState(this.state);
            this.button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    if (YearDisplayState.this.state == 2) {
                        YearDisplayState.this.state = 0;
                        YearDisplayState.this.unload();
                    } else if (YearDisplayState.this.state == 1) {
                        YearDisplayState.this.state = 0;
                    } else if (YearDisplayState.this.state == 0) {
                        YearDisplayState.this.state = 1;
                        YearDisplayState.this.stormTrackControl.loadYear(YearDisplayState.this);
                    }
                    YearDisplayState.this.setState(YearDisplayState.this.state);
                }
            });
        }
        return this.button;
    }

    public void setStatus(String msg) {
        this.getLabel().setText(msg);
    }

    public JLabel getLabel() {
        if (this.label == null) {
            this.label = new JLabel("");
        }
        return this.label;
    }

    public void unload() {
        if (this.trackDisplay != null) {
            try {
                this.stormTrackControl.removeDisplayable(this.trackDisplay);
                if (this.labelDisplay != null) {
                    this.stormTrackControl.removeDisplayable(this.labelDisplay);
                }
                this.stormTrackControl.unloadYear(this);
            }
            catch (Exception exc) {
                LogUtil.logException("Unloading tracks", exc);
            }
            this.trackDisplay = null;
            this.labelDisplay = null;
        }
    }

    public List<StormTrack> getStormTracks() {
        return this.stormTracks;
    }

    public StormTrackControl getStormTrackControl() {
        return this.stormTrackControl;
    }

    public void setStormTrackControl(StormTrackControl stormTrackControl) {
        this.stormTrackControl = stormTrackControl;
    }

    public void setYear(int value) {
        this.year = value;
    }

    public int getYear() {
        return this.year;
    }

    public void setColor(Color value) {
        this.color = value;
    }

    public Color getColor() {
        return this.color;
    }

    public boolean getActive() {
        return this.state == 2;
    }

    public void setState(int value) {
        this.state = value;
        if (this.button != null) {
            if (this.state == 2) {
                this.button.setText("Unload");
            } else if (this.state == 1) {
                this.button.setText("Cancel");
            } else if (this.state == 0) {
                this.button.setText("Load  ");
            }
        }
    }

    public int getState() {
        return this.state;
    }
}

