/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control.storm;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.rmi.RemoteException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import ucar.unidata.data.grid.GridUtil;
import ucar.unidata.data.point.PointOb;
import ucar.unidata.data.point.PointObFactory;
import ucar.unidata.data.storm.StormParam;
import ucar.unidata.data.storm.StormTrack;
import ucar.unidata.data.storm.StormTrackPoint;
import ucar.unidata.data.storm.Way;
import ucar.unidata.geoloc.Bearing;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.ProjectionPointImpl;
import ucar.unidata.geoloc.projection.FlatEarth;
import ucar.unidata.geoloc.projection.LatLonProjection;
import ucar.unidata.gis.SpatialGrid;
import ucar.unidata.idv.control.storm.DisplayState;
import ucar.unidata.idv.control.storm.StormDisplayState;
import ucar.unidata.ui.colortable.ColorTableDefaults;
import ucar.unidata.ui.symbol.StationModel;
import ucar.unidata.util.ColorTable;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.Range;
import ucar.unidata.view.geoloc.NavigatedDisplay;
import ucar.visad.Util;
import ucar.visad.display.CompositeDisplayable;
import ucar.visad.display.Displayable;
import ucar.visad.display.StationModelDisplayable;
import ucar.visad.display.TrackDisplayable;
import visad.CommonUnit;
import visad.Data;
import visad.DateTime;
import visad.FieldImpl;
import visad.FunctionType;
import visad.Integer1DSet;
import visad.MathType;
import visad.Real;
import visad.RealType;
import visad.Set;
import visad.SetType;
import visad.Text;
import visad.TextType;
import visad.Tuple;
import visad.Unit;
import visad.VisADException;
import visad.georef.EarthLocation;
import visad.georef.EarthLocationLite;

public class WayDisplayState {
    private final RealType azimuthType = RealType.getRealType("Azimuth", CommonUnit.degree);
    private Way way;
    private StormDisplayState stormDisplayState;
    private DisplayState trackState;
    private DisplayState coneState;
    private DisplayState wayState;
    private DisplayState ringsState;
    List<PointOb> pointObs = new ArrayList<PointOb>();
    List<PointOb> allPointObs = new ArrayList<PointOb>();
    private List<StormTrack> tracks = new ArrayList<StormTrack>();
    private List<DateTime> times = new ArrayList<DateTime>();
    private Color color;
    private GuiUtils.ColorSwatch colorSwatch;
    private CompositeDisplayable holder;
    private StationModelDisplayable labelDisplay;
    private StationModelDisplayable obsPointDisplay;
    private TrackDisplayable trackDisplay;
    private TrackDisplayable ringsDisplay;
    private CompositeDisplayable conesHolder;
    private List<StormParam> coneParams;
    private StormParam ringsParam;
    private StormParam colorParam;
    private int modeParam = 99;
    private SpatialGrid stationGrid;
    private float declutterFilter = 1.0f;
    private static TextType fhourType;
    private static TextType rhourType;
    private static TextType shourType;

    public WayDisplayState() {
    }

    public WayDisplayState(StormDisplayState stormDisplayState, Way way) {
        this.stormDisplayState = stormDisplayState;
        this.way = way;
        this.wayState = new DisplayState(this, "Show/Hide All", false);
        this.trackState = new DisplayState(this, "Show/Hide Track", true);
        this.coneState = new DisplayState(this, "Show/Hide Cone", false);
        this.ringsState = new DisplayState(this, "Show/Hide Rings", false);
    }

    protected CompositeDisplayable getHolder() throws VisADException, RemoteException {
        if (this.holder == null) {
            this.holder = new CompositeDisplayable("way  holder");
            this.stormDisplayState.addDisplayable(this.holder);
        }
        return this.holder;
    }

    public boolean hasTrackDisplay() {
        return this.trackDisplay != null;
    }

    public boolean hasLabelDisplay() {
        return this.labelDisplay != null;
    }

    private void removeTrackDisplay() throws VisADException, RemoteException {
        if (this.trackDisplay != null) {
            this.removeDisplayable(this.trackDisplay);
            this.trackDisplay = null;
        }
    }

    private void removeLabelDisplay() throws VisADException, RemoteException {
        if (this.labelDisplay != null) {
            this.removeDisplayable(this.labelDisplay);
            this.labelDisplay = null;
        }
    }

    private void removeObsPointDisplay() throws VisADException, RemoteException {
        if (this.obsPointDisplay != null) {
            this.removeDisplayable(this.obsPointDisplay);
            this.obsPointDisplay = null;
        }
    }

    public boolean hasObsPointDisplay() {
        return this.obsPointDisplay != null;
    }

    public boolean hasRingsDisplay() {
        return this.ringsDisplay != null;
    }

    public boolean hasConeDisplay() {
        return this.conesHolder != null;
    }

    public void updateDisplay(boolean force) throws Exception {
        Object tmp;
        if (!this.shouldShow()) {
            if (this.holder != null) {
                this.holder.setVisible(false);
            }
            return;
        }
        this.getHolder().setVisible(true);
        int forecastAnimationMode = this.stormDisplayState.getForecastAnimationMode();
        if (this.shouldShowTrack()) {
            boolean modeChanged;
            StormParam tmpParam = this.stormDisplayState.getColorParam(this);
            boolean hadTrack = this.hasTrackDisplay();
            boolean paramChanged = !Misc.equals(this.colorParam, tmpParam);
            boolean bl = modeChanged = this.modeParam != forecastAnimationMode;
            if (force || !hadTrack || paramChanged || modeChanged || this.stormDisplayState.isColorRangeChanged()) {
                this.colorParam = tmpParam;
                FieldImpl trackField = this.makeTrackField(forecastAnimationMode);
                if (trackField != null) {
                    if (paramChanged) {
                        this.trackDisplay = null;
                        this.initTrackDisplay();
                    }
                    this.getTrackDisplay().setUseTimesInAnimation(false);
                    this.getTrackDisplay().setTrack(trackField);
                    Range range = null;
                    if (this.colorParam != null) {
                        Unit displayUnit;
                        String paramName = this.colorParam.getName();
                        range = this.stormDisplayState.getStormTrackControl().getIdv().getParamDefaultsEditor().getParamRange(paramName);
                        if (this.stormDisplayState.isColorRangeChanged()) {
                            range = this.stormDisplayState.getStormTrackControl().getRangeForColorTable();
                            this.stormDisplayState.getStormTrackControl().getColorTableWidget(range);
                        }
                        if ((displayUnit = this.stormDisplayState.getStormTrackControl().getIdv().getParamDefaultsEditor().getParamDisplayUnit(paramName)) != null) {
                            this.getTrackDisplay().setDisplayUnit(displayUnit);
                        } else {
                            Unit[] u = GridUtil.getParamUnits(trackField);
                            if (u[0] != null) {
                                this.getTrackDisplay().setDisplayUnit(u[0]);
                            }
                        }
                    }
                    if (range == null) {
                        range = GridUtil.getMinMax(trackField)[0];
                    }
                    this.getTrackDisplay().setRangeForColor(range.getMin(), range.getMax());
                }
            }
            this.setTrackColor();
            this.getTrackDisplay().setVisible(true);
        } else if (this.hasTrackDisplay()) {
            this.getTrackDisplay().setVisible(false);
        }
        this.updateLayoutModel();
        if (this.shouldShowCone()) {
            tmp = this.stormDisplayState.getConeParams(this);
            if (!this.hasConeDisplay() || !Misc.equals(tmp, this.coneParams) || this.modeParam != forecastAnimationMode) {
                this.coneParams = tmp;
                this.getConesHolder().clearDisplayables();
                this.setConeColor();
                for (StormParam param : this.coneParams) {
                    TrackDisplayable coneDisplay = this.makeConeDisplay(param, forecastAnimationMode);
                    if (coneDisplay == null) continue;
                    this.getConesHolder().addDisplayable(coneDisplay);
                }
                this.setConeColor();
            }
            this.getConesHolder().setVisible(true);
        } else if (this.hasConeDisplay()) {
            this.getConesHolder().setVisible(false);
        }
        if (this.shouldShowRings()) {
            tmp = this.stormDisplayState.getRingsParam(this);
            TrackDisplayable ringDisplay = this.getRingsDisplay();
            if (!this.hasRingsDisplay() || !Misc.equals(tmp, this.ringsParam) || this.modeParam != forecastAnimationMode) {
                this.ringsParam = tmp;
                this.setRingsColor();
                FieldImpl field = this.makeRingsField(this.ringsParam, forecastAnimationMode);
                if (field == null || field.getLength() == 0) {
                    ringDisplay.setData(new Real(0.0));
                } else {
                    ringDisplay.setTrack(field);
                }
                this.setRingsColor();
            }
            this.ringsDisplay.setVisible(true);
        } else if (this.hasRingsDisplay()) {
            this.getRingsDisplay().setVisible(false);
        }
        this.modeParam = forecastAnimationMode;
    }

    public boolean shouldShow() {
        if (this.tracks.size() == 0) {
            return false;
        }
        if (!this.way.isObservation() && !this.stormDisplayState.getForecastState().getWayState().getVisible()) {
            return false;
        }
        return this.wayState.getVisible();
    }

    public boolean shouldShowTrack() {
        if (!this.way.isObservation() && !this.stormDisplayState.getForecastState().getTrackState().getVisible()) {
            return false;
        }
        return this.shouldShow() && this.trackState.getVisible();
    }

    public boolean shouldShowRings() {
        if (!this.way.isObservation() && !this.stormDisplayState.getForecastState().getRingsState().getVisible()) {
            return false;
        }
        return this.shouldShow() && this.ringsState.getVisible();
    }

    public boolean shouldShowCone() {
        if (!this.way.isObservation() && !this.stormDisplayState.getForecastState().getConeState().getVisible()) {
            return false;
        }
        return this.shouldShow() && this.coneState.getVisible();
    }

    public void updateLayoutModel() throws Exception {
        if (this.shouldShowTrack()) {
            FieldImpl pointField;
            StationModel sm;
            if (this.way.isObservation()) {
                sm = this.stormDisplayState.getObsPointLayoutModel();
                if (sm == null) {
                    this.removeObsPointDisplay();
                } else {
                    pointField = PointObFactory.makeTimeSequenceOfPointObs(this.allPointObs, -1, -1);
                    FieldImpl pointField1 = this.doDeclutter(pointField, sm);
                    this.getObsPointDisplay().setStationData(pointField1);
                    if (this.hasObsPointDisplay()) {
                        this.getObsPointDisplay().setStationModel(sm);
                    }
                }
            }
            StationModel stationModel = sm = this.way.isObservation() ? this.stormDisplayState.getObsLayoutModel() : this.stormDisplayState.getForecastLayoutModel();
            if (sm == null) {
                this.removeLabelDisplay();
            } else if (this.pointObs.size() > 0) {
                pointField = PointObFactory.makeTimeSequenceOfPointObs(this.pointObs, -1, -1);
                this.getLabelDisplay().setStationData(pointField);
                this.getLabelDisplay().setStationModel(sm);
            }
        }
        this.setLabelColor();
        if (this.hasObsPointDisplay()) {
            this.getObsPointDisplay().setVisible(this.shouldShowTrack());
        }
        if (this.hasLabelDisplay()) {
            this.getLabelDisplay().setVisible(this.shouldShowTrack());
        }
    }

    private FieldImpl doDeclutter(FieldImpl obs, StationModel sModel) throws VisADException, RemoteException {
        boolean isTimeSequence = GridUtil.isTimeSequence(obs);
        FieldImpl declutteredField = null;
        if (isTimeSequence) {
            Set timeSet = obs.getDomainSet();
            declutteredField = new FieldImpl((FunctionType)obs.getType(), timeSet);
            int numTimes = timeSet.getLength();
            for (int i = 0; i < numTimes; ++i) {
                FieldImpl oneTime = (FieldImpl)obs.getSample(i);
                FieldImpl subTime = this.doTheActualDecluttering(oneTime, sModel);
                if (subTime == null) continue;
                declutteredField.setSample(i, (Data)subTime, false);
            }
        } else {
            declutteredField = this.doTheActualDecluttering(obs, sModel);
        }
        return declutteredField;
    }

    private FieldImpl doTheActualDecluttering(FieldImpl pointObs, StationModel sm) throws VisADException, RemoteException {
        if (pointObs == null || pointObs.isMissing()) {
            return pointObs;
        }
        FieldImpl retField = null;
        Set domainSet = pointObs.getDomainSet();
        int numObs = domainSet.getLength();
        Vector<PointOb> v = new Vector<PointOb>();
        long t1 = System.currentTimeMillis();
        Rectangle glyphBounds = sm.getBounds();
        float myScale = this.getObsPointDisplay().getScale() * 0.0025f * this.getDeclutterFilter();
        Rectangle2D.Double scaledGlyphBounds = new Rectangle2D.Double(glyphBounds.getX() * (double)myScale, glyphBounds.getY() * (double)myScale, glyphBounds.getWidth() * (double)myScale, glyphBounds.getHeight() * (double)myScale);
        NavigatedDisplay navDisplay = this.stormDisplayState.getStormTrackControl().getNavigatedDisplay();
        Rectangle2D.Double obBounds = new Rectangle2D.Double();
        obBounds.width = ((RectangularShape)scaledGlyphBounds).getWidth();
        obBounds.height = ((RectangularShape)scaledGlyphBounds).getHeight();
        if (this.stationGrid == null) {
            this.stationGrid = new SpatialGrid(200, 200);
        }
        this.stationGrid.clear();
        this.stationGrid.setGrid(this.getBounds(), scaledGlyphBounds);
        if (this.getDeclutterFilter() < 0.3f) {
            // empty if block
        }
        double[] xyz = new double[3];
        for (int i = 0; i < numObs; ++i) {
            PointOb ob = (PointOb)pointObs.getSample(i);
            xyz = navDisplay.getSpatialCoordinates(ob.getEarthLocation(), xyz);
            obBounds.x = xyz[0];
            obBounds.y = xyz[1];
            if (!this.stationGrid.markIfClear(obBounds, "")) continue;
            v.add(ob);
        }
        long t2 = System.currentTimeMillis();
        if (v.isEmpty()) {
            retField = new FieldImpl((FunctionType)pointObs.getType(), new Integer1DSet((MathType)((SetType)domainSet.getType()).getDomain(), 1));
            retField.setSample(0, pointObs.getSample(0), false);
        } else if (v.size() == numObs) {
            retField = pointObs;
        } else {
            retField = new FieldImpl((FunctionType)pointObs.getType(), new Integer1DSet((MathType)((SetType)domainSet.getType()).getDomain(), v.size()));
            retField.setSamples(v.toArray(new PointOb[v.size()]), false, false);
        }
        long t3 = System.currentTimeMillis();
        return retField;
    }

    public float getDeclutterFilter() {
        return this.declutterFilter;
    }

    protected Rectangle2D getBounds() {
        return this.calculateRectangle();
    }

    protected Rectangle2D calculateRectangle() {
        try {
            Rectangle2D.Double box = this.stormDisplayState.getStormTrackControl().getNavigatedDisplay().getVisadBox();
            if (!box.isEmpty()) {
                double deltaWidth = 0.05 * box.width;
                double deltaHeight = 0.05 * box.height;
                double newX = box.x - deltaWidth;
                double newY = box.y - deltaHeight;
                box.setRect(newX, newY, box.width + 2.0 * deltaWidth, box.height + 2.0 * deltaHeight);
            }
            return box;
        }
        catch (Exception excp) {
            LogUtil.logException("calculating Rectangle ", excp);
            return new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
        }
    }

    public StationModelDisplayable getLabelDisplay() throws Exception {
        if (this.labelDisplay == null) {
            StationModel sm;
            StationModel stationModel = sm = this.way.isObservation() ? this.stormDisplayState.getObsLayoutModel() : this.stormDisplayState.getForecastLayoutModel();
            if (sm != null) {
                this.labelDisplay = new StationModelDisplayable("dots");
                this.labelDisplay.setRotateShapes(true);
                this.labelDisplay.setUseTimesInAnimation(false);
                this.addDisplayable(this.labelDisplay);
                this.labelDisplay.setScale(this.stormDisplayState.getStormTrackControl().getDisplayScale());
            }
        }
        return this.labelDisplay;
    }

    public StationModelDisplayable getObsPointDisplay() throws VisADException, RemoteException {
        if (this.obsPointDisplay == null) {
            this.obsPointDisplay = new StationModelDisplayable("dots");
            this.obsPointDisplay.setRotateShapes(true);
            this.obsPointDisplay.setUseTimesInAnimation(false);
            this.addDisplayable(this.obsPointDisplay);
            this.obsPointDisplay.setScale(this.stormDisplayState.getStormTrackControl().getDisplayScale());
        }
        return this.obsPointDisplay;
    }

    public void initTrackDisplay() throws Exception {
        this.trackDisplay = new TrackDisplayable("track_" + this.stormDisplayState.getStormInfo().getStormId());
        if (this.way.isObservation()) {
            this.trackDisplay.setLineWidth(3.0f);
        } else {
            this.trackDisplay.setLineWidth(2.0f);
            this.trackDisplay.setUseTimesInAnimation(false);
        }
        int cnt = this.holder.displayableCount();
        for (int i = 0; i < cnt; ++i) {
            TrackDisplayable dd;
            Displayable dp = this.holder.getDisplayable(i);
            if (!dp.getClass().isInstance(this.trackDisplay) || !(dd = (TrackDisplayable)dp).toString().equalsIgnoreCase(this.trackDisplay.toString())) continue;
            this.holder.removeDisplayable(dp);
            --cnt;
        }
        this.addDisplayable(this.trackDisplay);
    }

    public TrackDisplayable getTrackDisplay() throws Exception {
        if (this.trackDisplay == null) {
            this.initTrackDisplay();
        }
        return this.trackDisplay;
    }

    public CompositeDisplayable getConesHolder() throws Exception {
        if (this.conesHolder == null) {
            this.conesHolder = new CompositeDisplayable("cone_" + this.stormDisplayState.getStormInfo().getStormId());
            this.conesHolder.setVisible(true);
            this.conesHolder.setUseTimesInAnimation(false);
            this.addDisplayable(this.conesHolder);
        }
        return this.conesHolder;
    }

    public TrackDisplayable getRingsDisplay() throws Exception {
        if (this.ringsDisplay == null) {
            this.ringsDisplay = new TrackDisplayable("ring_" + this.stormDisplayState.getStormInfo().getStormId() + "_" + this.getWay());
            this.ringsDisplay.setVisible(true);
            this.ringsDisplay.setUseTimesInAnimation(false);
            this.addDisplayable(this.ringsDisplay);
        }
        return this.ringsDisplay;
    }

    public TrackDisplayable makeConeDisplay(StormParam param, int mode) throws Exception {
        FieldImpl field = this.makeConeField(param, mode);
        if (field == null) {
            return null;
        }
        TrackDisplayable coneDisplay = new TrackDisplayable("cone_" + this.stormDisplayState.getStormInfo().getStormId());
        coneDisplay.setUseTimesInAnimation(false);
        coneDisplay.setTrack(field);
        coneDisplay.setUseTimesInAnimation(false);
        return coneDisplay;
    }

    public TrackDisplayable makeRingDisplay(StormParam param, int mode) throws Exception {
        FieldImpl field = this.makeRingsField(param, mode);
        if (field == null) {
            return null;
        }
        TrackDisplayable ringDisplay = new TrackDisplayable("ring_" + this.stormDisplayState.getStormInfo().getStormId());
        ringDisplay.setUseTimesInAnimation(false);
        ringDisplay.setTrack(field);
        ringDisplay.setUseTimesInAnimation(false);
        return ringDisplay;
    }

    protected JComponent getColorSwatch() {
        if (this.colorSwatch == null) {
            this.colorSwatch = new GuiUtils.ColorSwatch(this.getColor(), "Set track color"){

                @Override
                public void setBackground(Color newColor) {
                    super.setBackground(newColor);
                    WayDisplayState.this.color = newColor;
                    try {
                        WayDisplayState.this.setTrackColor();
                        WayDisplayState.this.setConeColor();
                        WayDisplayState.this.setRingsColor();
                        WayDisplayState.this.setLabelColor();
                    }
                    catch (Exception exc) {
                        LogUtil.logException("Setting color", exc);
                    }
                }
            };
            this.colorSwatch.setMinimumSize(new Dimension(15, 15));
            this.colorSwatch.setPreferredSize(new Dimension(15, 15));
        }
        return this.colorSwatch;
    }

    public float[][] getColorPalette() {
        ColorTable ct = this.stormDisplayState.getColorTable(this.colorParam);
        if (ct != null) {
            return this.stormDisplayState.getStormTrackControl().getColorTableForDisplayable(ct);
        }
        return WayDisplayState.getColorPalette(this.getColor());
    }

    public static float[][] getColorPalette(Color c) {
        if (c == null) {
            c = Color.red;
        }
        return ColorTableDefaults.allOneColor(c, true);
    }

    private void setTrackColor() throws Exception {
        if (this.trackDisplay != null) {
            if (this.colorParam == null || this.colorParam.getName().equalsIgnoreCase("Fixed")) {
                this.trackDisplay.setColor(this.getColor());
            } else {
                this.trackDisplay.setColorPalette(this.getColorPalette());
            }
        }
    }

    private void setLabelColor() throws Exception {
        Color c = this.getColor();
        if (this.labelDisplay != null) {
            this.labelDisplay.setColor(c);
        }
        if (this.obsPointDisplay != null) {
            this.obsPointDisplay.setColor(c);
        }
    }

    private void setConeColor() throws Exception {
        if (this.conesHolder != null) {
            this.conesHolder.setColorPalette(WayDisplayState.getColorPalette(this.getColor()));
        }
    }

    private void setRingsColor() throws Exception {
        if (this.ringsDisplay != null) {
            this.ringsDisplay.setColor(this.getColor());
        }
    }

    public void deactivate() throws VisADException, RemoteException {
        this.ringsDisplay = null;
        this.conesHolder = null;
        if (this.holder != null) {
            // empty if block
        }
        this.trackDisplay = null;
        this.labelDisplay = null;
        this.obsPointDisplay = null;
        this.holder = null;
        this.tracks = new ArrayList<StormTrack>();
        this.times = new ArrayList<DateTime>();
    }

    public void addTrack(StormTrack track) throws Exception {
        this.tracks.add(track);
    }

    protected FieldImpl makeTrackField(int mode) throws Exception {
        ArrayList<FieldImpl> fields = new ArrayList<FieldImpl>();
        ArrayList<DateTime> times = new ArrayList<DateTime>();
        ArrayList<PointOb> localPointObs = new ArrayList<PointOb>();
        ArrayList<PointOb> localAllPointObs = new ArrayList<PointOb>();
        Data[] datas = new Data[this.tracks.size()];
        int i = 0;
        for (StormTrack track : this.tracks) {
            FieldImpl field = this.stormDisplayState.getStormTrackControl().makeTrackField(track, this.colorParam);
            if (field == null) continue;
            datas[i++] = i == 0 ? field : field.changeMathType(datas[0].getType());
            fields.add(field);
            times.add(track.getStartTime());
            localPointObs.addAll(this.makePointObs(track, !this.way.isObservation()));
            if (!this.way.isObservation()) continue;
            localAllPointObs.addAll(this.makeObsPointObs(track));
        }
        this.pointObs = localPointObs;
        this.allPointObs = localAllPointObs;
        if (fields.size() == 0) {
            return null;
        }
        if (!this.way.isObservation() && mode == 1) {
            return Util.indexedField(datas, false);
        }
        return Util.makeTimeField(fields, times);
    }

    protected FieldImpl makeConeField(StormParam stormParam, int mode) throws Exception {
        ArrayList<FieldImpl> fields = new ArrayList<FieldImpl>();
        ArrayList<DateTime> times = new ArrayList<DateTime>();
        Data[] datas = new Data[this.tracks.size()];
        int i = 0;
        for (StormTrack track : this.tracks) {
            StormTrack coneTrack = this.makeConeTrack(track, stormParam);
            if (coneTrack == null) continue;
            FieldImpl field = this.stormDisplayState.getStormTrackControl().makeTrackField(coneTrack, null);
            fields.add(field);
            times.add(track.getStartTime());
            datas[i++] = field;
        }
        if (fields.size() == 0) {
            return null;
        }
        if (!this.way.isObservation() && mode == 1) {
            return Util.indexedField(datas, false);
        }
        return Util.makeTimeField(fields, times);
    }

    private List<PointOb> makePointObs(StormTrack track, boolean useStartTime) throws Exception {
        boolean isObservation = this.way.isObservation();
        DateTime startTime = track.getStartTime();
        List<StormTrackPoint> stps = track.getTrackPoints();
        if (fhourType == null) {
            fhourType = new TextType("fhour");
        }
        if (rhourType == null) {
            rhourType = new TextType("rhour");
        }
        if (shourType == null) {
            shourType = new TextType("shour");
        }
        ArrayList<PointOb> pointObs = new ArrayList<PointOb>();
        DecimalFormat format = new DecimalFormat("0.#");
        Date startDate = Util.makeDate(startTime);
        List<StormParam> params = track.getParams();
        for (int i = 0; i < stps.size(); ++i) {
            Date dttm;
            StormTrackPoint stp = stps.get(i);
            DateTime time = useStartTime ? startTime : stp.getTime();
            String flabel = "";
            String rlabel = "";
            String slabel = "";
            if (!isObservation) {
                if (i != 0) {
                    flabel = "" + stp.getForecastHour() + "H";
                    dttm = Util.makeDate(stp.getTime());
                    rlabel = "" + dttm.toString();
                    slabel = "" + this.getMonDayHour(dttm);
                }
            } else if (useStartTime && i > 0) {
                dttm = Util.makeDate(stp.getTime());
                double diffSeconds = (double)(dttm.getTime() - startDate.getTime()) / 1000.0;
                double diffHours = diffSeconds / 3600.0;
                flabel = format.format(diffHours) + "H";
                rlabel = "" + dttm.toString();
                slabel = "" + this.getMonDayHour(dttm);
            }
            Data[] data = new Data[params.size() + 3];
            data[0] = new Text(rhourType, rlabel);
            data[1] = new Text(fhourType, flabel);
            data[2] = new Text(shourType, slabel);
            for (int paramIdx = 0; paramIdx < params.size(); ++paramIdx) {
                Real r = stp.getAttribute(params.get(paramIdx));
                if (r == null) {
                    r = params.get(paramIdx).getReal(Double.NaN);
                }
                data[paramIdx + 3] = r;
            }
            Tuple tuple = new Tuple(data);
            pointObs.add(PointObFactory.makePointOb(stp.getLocation(), time, tuple));
        }
        return pointObs;
    }

    private String getMonDayHour(Date dt) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(dt);
        int m = cal.get(2) + 1;
        int d = cal.get(5);
        int h = cal.get(11);
        return "" + m + "/" + d + "/" + h + "H";
    }

    private List<PointOb> makeObsPointObs(StormTrack track) throws Exception {
        DateTime startTime = track.getStartTime();
        List<StormTrackPoint> stps = track.getTrackPoints();
        if (fhourType == null) {
            fhourType = new TextType("fhour");
        }
        if (rhourType == null) {
            rhourType = new TextType("rhour");
        }
        if (shourType == null) {
            shourType = new TextType("shour");
        }
        ArrayList<PointOb> pointObs = new ArrayList<PointOb>();
        DecimalFormat format = new DecimalFormat("0.#");
        List<StormParam> params = track.getParams();
        for (int i = 0; i < stps.size(); ++i) {
            StormTrackPoint baseStp = stps.get(i);
            DateTime baseTime = baseStp.getTime();
            Date baseDate = Util.makeDate(baseTime);
            for (int j = i; j < stps.size(); ++j) {
                StormTrackPoint stp = stps.get(j);
                String flabel = "";
                String rlabel = "";
                String slabel = "";
                if (j > 0) {
                    Date dttm = Util.makeDate(stp.getTime());
                    double diffSeconds = (double)(dttm.getTime() - baseDate.getTime()) / 1000.0;
                    double diffHours = diffSeconds / 3600.0;
                    flabel = format.format(diffHours) + "H";
                    rlabel = "" + stp.getTime().toString();
                    slabel = "" + this.getMonDayHour(dttm);
                }
                Data[] data = new Data[params.size() + 3];
                data[0] = new Text(fhourType, flabel);
                data[1] = new Text(rhourType, rlabel);
                data[2] = new Text(shourType, slabel);
                for (int paramIdx = 0; paramIdx < params.size(); ++paramIdx) {
                    Real r = stp.getAttribute(params.get(paramIdx));
                    if (r == null) {
                        r = params.get(paramIdx).getReal(Double.NaN);
                    }
                    data[paramIdx + 3] = r;
                }
                Tuple tuple = new Tuple(data);
                pointObs.add(PointObFactory.makePointOb(stp.getLocation(), baseTime, tuple));
            }
        }
        return pointObs;
    }

    public List<StormTrack> getTracks() {
        return this.tracks;
    }

    public List<DateTime> getTimes() {
        return this.times;
    }

    public void addDisplayable(Displayable displayable) throws VisADException, RemoteException {
        this.getHolder().addDisplayable(displayable);
    }

    public void removeDisplayable(Displayable displayable) throws VisADException, RemoteException {
        this.getHolder().removeDisplayable(displayable);
    }

    public void setConeState(DisplayState value) {
        this.coneState = value;
    }

    public DisplayState getConeState() {
        return this.coneState;
    }

    public void setTrackState(DisplayState value) {
        this.trackState = value;
    }

    public DisplayState getTrackState() {
        return this.trackState;
    }

    public void setRingsState(DisplayState value) {
        this.ringsState = value;
    }

    public DisplayState getRingsState() {
        return this.ringsState;
    }

    public void setWayState(DisplayState value) {
        this.wayState = value;
    }

    public DisplayState getWayState() {
        return this.wayState;
    }

    public void setColor(Color value) {
        this.color = value;
    }

    public Color getColor() {
        return this.color;
    }

    public void setStormDisplayState(StormDisplayState value) {
        this.stormDisplayState = value;
    }

    public StormDisplayState getStormDisplayState() {
        return this.stormDisplayState;
    }

    public void setWay(Way value) {
        this.way = value;
    }

    public Way getWay() {
        return this.way;
    }

    public void setColorTable(String value) {
    }

    private List<StormTrackPoint> getRealTrackPoints(StormTrack track, StormParam param) {
        ArrayList<StormTrackPoint> newStps = new ArrayList<StormTrackPoint>();
        List<StormTrackPoint> stps = track.getTrackPoints();
        newStps.add(stps.get(0));
        for (StormTrackPoint stp : stps) {
            if (stp.getAttribute(param) == null) continue;
            newStps.add(stp);
        }
        return newStps;
    }

    protected FieldImpl makeRingsField(StormParam stormParam, int mode) throws Exception {
        ArrayList<FieldImpl> fields = new ArrayList<FieldImpl>();
        ArrayList<DateTime> times = new ArrayList<DateTime>();
        Data[] datas = new Data[this.tracks.size() * 10];
        int i = 0;
        if (!this.way.isObservation() && mode == 1) {
            for (StormTrack track : this.tracks) {
                List stList = this.makeRingTrackList(track, stormParam);
                for (StormTrack stk : stList) {
                    FieldImpl field = this.stormDisplayState.getStormTrackControl().makeTrackField(stk, null);
                    fields.add(field);
                    datas[i++] = field;
                }
            }
            return Util.indexedField(datas, false);
        }
        for (StormTrack track : this.tracks) {
            FieldImpl ringField = this.makeRingTracks(track, stormParam);
            fields.add(ringField);
            times.add(track.getStartTime());
        }
        if (fields.size() == 0) {
            return null;
        }
        return Util.makeTimeField(fields, times);
    }

    public List makeRingTrackList(StormTrack track, StormParam param) throws Exception {
        List<StormTrackPoint> stps = this.getRealTrackPoints(track, param);
        ArrayList<StormTrack> stracks = new ArrayList<StormTrack>();
        int size = stps.size();
        DateTime dt = stps.get(0).getTime();
        Way ringWay = new Way(this.getWay() + "_RING");
        int numberOfPoints = 73;
        double angleDelta = 360.0 / (double)(numberOfPoints - 1);
        for (int i = 0; i < size; ++i) {
            StormTrackPoint stp = stps.get(i);
            Real r = stp.getAttribute(param);
            if (r == null) continue;
            double rr = r.getValue();
            double azi = 0.0;
            ArrayList<StormTrackPoint> ringList = new ArrayList<StormTrackPoint>();
            for (int j = 0; j < numberOfPoints; ++j) {
                ringList.add(this.getCirclePoint(stp, rr, azi, dt));
                azi += angleDelta;
            }
            stracks.add(new StormTrack(track.getStormInfo(), ringWay, ringList, null));
        }
        return stracks;
    }

    public FieldImpl makeRingTracks(StormTrack track, StormParam param) throws Exception {
        List<StormTrackPoint> stps = this.getRealTrackPoints(track, param);
        ArrayList<StormTrack> stracks = new ArrayList<StormTrack>();
        int size = stps.size();
        DateTime dt = stps.get(0).getTime();
        Way ringWay = new Way(this.getWay() + "_RING");
        int numberOfPoints = 73;
        double angleDelta = 360.0 / (double)(numberOfPoints - 1);
        for (int i = 0; i < size; ++i) {
            StormTrackPoint stp = stps.get(i);
            Real r = stp.getAttribute(param);
            if (r == null) continue;
            double rr = r.getValue();
            double azi = 0.0;
            ArrayList<StormTrackPoint> ringList = new ArrayList<StormTrackPoint>();
            for (int j = 0; j < numberOfPoints; ++j) {
                ringList.add(this.getCirclePoint(stp, rr, azi, dt));
                azi += angleDelta;
            }
            stracks.add(new StormTrack(track.getStormInfo(), ringWay, ringList, null));
        }
        Data[] datas = new Data[stracks.size()];
        int i = 0;
        for (StormTrack ringTrack : stracks) {
            datas[i++] = this.stormDisplayState.getStormTrackControl().makeTrackField(ringTrack, null);
        }
        return Util.indexedField(datas, false);
    }

    public StormTrackPoint getCirclePoint(StormTrackPoint stp, double r0, double azimuth, DateTime dt) throws VisADException {
        EarthLocation el = stp.getLocation();
        double lat0 = el.getLatitude().getValue();
        double lon0 = el.getLongitude().getValue();
        LatLonPointImpl lp = Bearing.findPoint(lat0, lon0, azimuth, r0, null);
        EarthLocationLite el1 = new EarthLocationLite(lp.getLatitude(), lp.getLongitude(), 0.0);
        StormTrackPoint stp1 = new StormTrackPoint(el1, dt, 0, null);
        return stp1;
    }

    public StormTrack makeConeTrack_Old(StormTrack track, StormParam param) throws VisADException {
        StormTrackPoint stp1;
        List<StormTrackPoint> stps = this.getRealTrackPoints(track, param);
        int size = stps.size();
        int numberOfPoint = size * 2 + 11;
        StormTrackPoint[] conePoints = new StormTrackPoint[numberOfPoint];
        conePoints[0] = stp1 = stps.get(0);
        conePoints[numberOfPoint - 1] = stp1;
        for (int i = 1; i < size; ++i) {
            StormTrackPoint stp;
            StormTrackPoint stp2 = stps.get(i);
            conePoints[i] = stp = this.getPointToCircleTangencyPoint(stp1, stp2, param, true);
            conePoints[numberOfPoint - i - 1] = stp = this.getPointToCircleTangencyPoint(stp1, stp2, param, false);
            stp1 = stp2;
        }
        StormTrackPoint last = stps.get(size - 1);
        EarthLocation lastEl = last.getLocation();
        StormTrackPoint endSTP = conePoints[size - 1];
        int ii = 0;
        while (endSTP == null && ii < size - 2) {
            last = stps.get(size - 1 - ++ii);
            lastEl = last.getLocation();
            endSTP = conePoints[size - 1 - ii];
        }
        if (endSTP == null || ii == size - 2) {
            return null;
        }
        EarthLocation endEl = endSTP.getLocation();
        double ang = this.getCircleAngleRange(lastEl, endEl);
        Real r = last.getAttribute(param);
        StormTrackPoint[] halfCircle = this.getHalfCircleTrackPoint(lastEl, ang, r != null ? r.getValue() : 0.0, last.getTime());
        for (int i = 0; i < 11; ++i) {
            conePoints[size + i] = halfCircle[i];
        }
        ArrayList<StormTrackPoint> coneList = new ArrayList<StormTrackPoint>();
        for (int i = 0; i < numberOfPoint; ++i) {
            if (conePoints[i] == null) continue;
            coneList.add(conePoints[i]);
        }
        return new StormTrack(track.getStormInfo(), new Way(this.getWay() + "_CONE"), coneList, null);
    }

    public StormTrack makeConeTrack(StormTrack track, StormParam param) throws VisADException {
        int s2;
        int i;
        StormTrackPoint last;
        List<StormTrackPoint> stps = this.getRealTrackPoints(track, param);
        int size = stps.size();
        int numberOfPoint = size * 2 + 100;
        ArrayList<StormTrackPoint> conePointsLeft = new ArrayList<StormTrackPoint>();
        ArrayList<StormTrackPoint> conePointsRight = new ArrayList<StormTrackPoint>();
        StormTrackPoint stp1 = stps.get(0);
        conePointsRight.add(stp1);
        conePointsLeft.add(stp1);
        StormTrackPoint stp2 = stps.get(1);
        StormTrackPoint stp3 = stps.get(2);
        int nn = 3;
        List<StormTrackPoint> p2c = this.getPointToCircleTangencyPointA(stp1, stp2, stp3, param, true);
        while (p2c == null) {
            stp2 = stp3;
            stp3 = nn < size ? stps.get(nn) : null;
            p2c = this.getPointToCircleTangencyPointA(stp1, stp2, stp3, param, true);
            if (++nn < size) continue;
        }
        if (p2c != null) {
            conePointsRight.addAll(p2c);
            p2c = this.getPointToCircleTangencyPointA(stp1, stp2, stp3, param, false);
            conePointsLeft.addAll(p2c);
        }
        stp1 = stp2;
        stp2 = stp3;
        for (int i2 = nn; i2 < size; ++i2) {
            stp3 = stps.get(i2);
            p2c = this.getCircleToCircleTangencyPointA(stp1, stp2, stp3, param, true);
            if (p2c != null) {
                conePointsRight.addAll(p2c);
                p2c = this.getCircleToCircleTangencyPointA(stp1, stp2, stp3, param, false);
                conePointsLeft.addAll(p2c);
                stp1 = stp2;
            }
            stp2 = stp3;
        }
        stp3 = null;
        p2c = this.getCircleToCircleTangencyPointA(stp1, stp2, stp3, param, true);
        if (p2c != null) {
            conePointsRight.addAll(p2c);
            p2c = this.getCircleToCircleTangencyPointA(stp1, stp2, stp3, param, false);
            conePointsLeft.addAll(p2c);
            stp1 = stp2;
        }
        if ((last = stp2) == null) {
            last = stp1;
        }
        if (last == null) {
            return null;
        }
        EarthLocation lastEl = last.getLocation();
        StormTrackPoint endSTP = (StormTrackPoint)conePointsRight.get(conePointsRight.size() - 1);
        if (endSTP == null) {
            return null;
        }
        EarthLocation endEl = endSTP.getLocation();
        double ang = this.getCircleAngleRange(lastEl, endEl);
        Real r = last.getAttribute(param);
        StormTrackPoint[] halfCircle = this.getHalfCircleTrackPoint(lastEl, ang, r != null ? r.getValue() : 0.0, last.getTime());
        for (int i3 = 0; i3 < 11; ++i3) {
        }
        ArrayList<StormTrackPoint> coneList = new ArrayList<StormTrackPoint>();
        int s1 = conePointsRight.size();
        for (i = 0; i < s1; ++i) {
            if (conePointsRight.get(i) == null) continue;
            coneList.add((StormTrackPoint)conePointsRight.get(i));
        }
        for (i = 0; i < 11; ++i) {
            coneList.add(halfCircle[i]);
        }
        for (int i4 = s2 = conePointsLeft.size(); i4 > 0; --i4) {
            if (conePointsLeft.get(i4 - 1) == null) continue;
            coneList.add((StormTrackPoint)conePointsLeft.get(i4 - 1));
        }
        return new StormTrack(track.getStormInfo(), new Way(this.getWay() + "_CONE"), coneList, null);
    }

    public Bearing getStormPoinsBearing(StormTrackPoint sp1, StormTrackPoint sp2) {
        EarthLocation el1 = sp1.getLocation();
        EarthLocation el2 = sp2.getLocation();
        return Bearing.calculateBearing(el1.getLatitude().getValue(), el1.getLongitude().getValue(), el2.getLatitude().getValue(), el2.getLongitude().getValue(), null);
    }

    public List<StormTrackPoint> getPointToCircleTangencyPointA(StormTrackPoint sp1, StormTrackPoint sp2, StormTrackPoint sp3, StormParam param, boolean right) throws VisADException {
        double dtt;
        ArrayList<StormTrackPoint> trackPoints = new ArrayList<StormTrackPoint>();
        if (sp3 == null) {
            return this.getPointToCircleTangencyPointB(sp1, sp2, param, right);
        }
        EarthLocation el1 = sp1.getLocation();
        EarthLocation el2 = sp2.getLocation();
        EarthLocation el3 = sp3.getLocation();
        Real rl = sp2.getAttribute(param);
        double r = rl.getValue();
        if (Float.isNaN((float)r) || r == 0.0) {
            return null;
        }
        double lat1 = el1.getLatitude().getValue();
        double lon1 = el1.getLongitude().getValue();
        double lat2 = el2.getLatitude().getValue();
        double lon2 = el2.getLongitude().getValue();
        double lat3 = el3.getLatitude().getValue();
        double lon3 = el3.getLongitude().getValue();
        Bearing b = Bearing.calculateBearing(lat1, lon1, lat2, lon2, null);
        Bearing c = Bearing.calculateBearing(lat2, lon2, lat3, lon3, null);
        double dist1 = b.getDistance();
        if (dist1 < r) {
            trackPoints.add(this.getPointToCircleTangencyPoint(sp1, sp2, param, right));
            return trackPoints;
        }
        double af = this.getCircleAngleRange(el1, el2);
        double ddt = Math.abs(b.getAngle() - c.getAngle());
        double bt = this.getCircleTangencyAngle(el1, el2, r);
        af = af * 180.0 / Math.PI;
        bt = bt * 180.0 / Math.PI;
        af = right ? (af -= 90.0) : (af += 90.0);
        double az = af;
        if (af <= 90.0 && af >= 0.0) {
            az = 90.0 - af;
        } else if (af > 90.0 && af <= 180.0) {
            az = 360.0 + (90.0 - af);
        } else if (af < 0.0 && af >= -180.0) {
            az = 90.0 - af;
        } else if (af > 180.0 && af <= 360.0) {
            az = 450.0 - af;
        } else if (af < -180.0 && af >= -360.0) {
            az = -270.0 - af;
        }
        az = right ? (az += bt) : (az -= bt);
        if (ddt > 270.0) {
            ddt = 360.0 - ddt;
        } else if (ddt > 180.0) {
            ddt -= 180.0;
        } else if (ddt > 90.0) {
            ddt -= 90.0;
        }
        double dt = bt;
        dt = right ? (c.getAngle() < b.getAngle() && Math.abs(b.getAngle() - c.getAngle()) < 90.0 ? bt + ddt : (c.getAngle() > b.getAngle() && Math.abs(b.getAngle() - c.getAngle()) > 180.0 ? bt + ddt : bt - ddt)) : (c.getAngle() > b.getAngle() && Math.abs(b.getAngle() - c.getAngle()) < 90.0 ? bt + ddt : (c.getAngle() < b.getAngle() && Math.abs(b.getAngle() - c.getAngle()) > 180.0 ? bt + ddt : bt - ddt));
        int n = (int)dt / 5 + 1;
        if (n <= 0) {
            n = 1;
        }
        if ((dtt = dt / (double)n) < 0.0) {
            dtt = 0.0;
            n = 1;
        }
        for (int i = 0; i < n; ++i) {
            LatLonPointImpl lp1 = Bearing.findPoint(lat2, lon2, az, r, null);
            EarthLocationLite el = new EarthLocationLite(lp1.getLatitude(), lp1.getLongitude(), 0.0);
            trackPoints.add(new StormTrackPoint(el, sp1.getTime(), 0, null));
            if (right) {
                az -= dtt;
                continue;
            }
            az += dtt;
        }
        return trackPoints;
    }

    public List<StormTrackPoint> getPointToCircleTangencyPointB(StormTrackPoint sp1, StormTrackPoint sp2, StormParam param, boolean right) throws VisADException {
        double lon2;
        double lat2;
        double lon1;
        ArrayList<StormTrackPoint> trackPoints = new ArrayList<StormTrackPoint>();
        if (sp2 == null) {
            return null;
        }
        EarthLocation el1 = sp1.getLocation();
        EarthLocation el2 = sp2.getLocation();
        Real rl = sp2.getAttribute(param);
        double r = rl.getValue();
        if (Float.isNaN((float)r) || r == 0.0) {
            return null;
        }
        double lat1 = el1.getLatitude().getValue();
        Bearing b = Bearing.calculateBearing(lat1, lon1 = el1.getLongitude().getValue(), lat2 = el2.getLatitude().getValue(), lon2 = el2.getLongitude().getValue(), null);
        double dist1 = b.getDistance();
        if (dist1 < r) {
            trackPoints.add(this.getPointToCircleTangencyPoint(sp1, sp2, param, right));
            return trackPoints;
        }
        double af = this.getCircleAngleRange(el1, el2);
        double bt = this.getCircleTangencyAngle(el1, el2, r);
        af = af * 180.0 / Math.PI;
        bt = bt * 180.0 / Math.PI;
        af = right ? (af -= 90.0) : (af += 90.0);
        double az = af;
        if (af <= 90.0 && af >= 0.0) {
            az = 90.0 - af;
        } else if (af > 90.0 && af <= 180.0) {
            az = 360.0 + (90.0 - af);
        } else if (af < 0.0 && af >= -180.0) {
            az = 90.0 - af;
        } else if (af > 180.0 && af <= 360.0) {
            az = 450.0 - af;
        } else if (af < -180.0 && af >= -360.0) {
            az = -270.0 - af;
        }
        az = right ? (az += bt) : (az -= bt);
        double dt = bt;
        int n = (int)dt / 5 + 1;
        double dtt = dt / (double)n;
        for (int i = 0; i < n; ++i) {
            LatLonPointImpl lp1 = Bearing.findPoint(lat2, lon2, az, r, null);
            EarthLocationLite el = new EarthLocationLite(lp1.getLatitude(), lp1.getLongitude(), 0.0);
            trackPoints.add(new StormTrackPoint(el, sp1.getTime(), 0, null));
            if (right) {
                az -= dtt;
                continue;
            }
            az += dtt;
        }
        return trackPoints;
    }

    public List<StormTrackPoint> getCircleToCircleTangencyPointA(StormTrackPoint sp1, StormTrackPoint sp2, StormTrackPoint sp3, StormParam param, boolean right) throws VisADException {
        ArrayList<StormTrackPoint> trackPoints = new ArrayList<StormTrackPoint>();
        if (sp3 == null) {
            if (sp2 == null) {
                return null;
            }
            trackPoints.add(this.getPointToCircleTangencyPoint(sp1, sp2, param, right));
            return trackPoints;
        }
        EarthLocation el1 = sp1.getLocation();
        EarthLocation el2 = sp2.getLocation();
        EarthLocation el3 = sp3.getLocation();
        Real rl = sp2.getAttribute(param);
        double r = rl.getValue();
        if (Float.isNaN((float)r) || r == 0.0) {
            return null;
        }
        double lat1 = el1.getLatitude().getValue();
        double lon1 = el1.getLongitude().getValue();
        double lat2 = el2.getLatitude().getValue();
        double lon2 = el2.getLongitude().getValue();
        double lat3 = el3.getLatitude().getValue();
        double lon3 = el3.getLongitude().getValue();
        Bearing b = Bearing.calculateBearing(lat1, lon1, lat2, lon2, null);
        double dist1 = b.getDistance();
        Bearing c = Bearing.calculateBearing(lat2, lon2, lat3, lon3, null);
        double x = Math.abs(c.getAngle() - b.getAngle());
        if (right && (c.getAngle() > b.getAngle() || x > 180.0)) {
            trackPoints.add(this.getPointToCircleTangencyPoint(sp1, sp2, param, right));
            return trackPoints;
        }
        if (!right && c.getAngle() < b.getAngle() && x < 90.0) {
            trackPoints.add(this.getPointToCircleTangencyPoint(sp1, sp2, param, right));
            return trackPoints;
        }
        double af = this.getCircleAngleRange(el1, el2);
        double dt = 0.0;
        dt = x > 270.0 ? 360.0 - x : (x > 180.0 ? x - 180.0 : (x > 90.0 ? x - 90.0 : x));
        af = af * 180.0 / Math.PI;
        af = right ? (af -= 90.0) : (af += 90.0);
        double az = af;
        if (af <= 90.0 && af >= 0.0) {
            az = 90.0 - af;
        } else if (af > 90.0 && af <= 180.0) {
            az = 360.0 + (90.0 - af);
        } else if (af < 0.0 && af >= -180.0) {
            az = 90.0 - af;
        } else if (af > 180.0 && af <= 360.0) {
            az = 450.0 - af;
        } else if (af < -180.0 && af >= -360.0) {
            az = -270.0 - af;
        }
        int n = (int)dt / 5 + 1;
        double dtt = dt / (double)n;
        for (int i = 0; i < n; ++i) {
            LatLonPointImpl lp1 = Bearing.findPoint(lat2, lon2, az, r, null);
            EarthLocationLite el = new EarthLocationLite(lp1.getLatitude(), lp1.getLongitude(), 0.0);
            trackPoints.add(new StormTrackPoint(el, sp1.getTime(), 0, null));
            if (right) {
                az -= dtt;
                continue;
            }
            az += dtt;
        }
        return trackPoints;
    }

    public StormTrackPoint getPointToCircleTangencyPoint(StormTrackPoint sp1, StormTrackPoint sp2, StormParam param, boolean right) throws VisADException {
        EarthLocation el1 = sp1.getLocation();
        EarthLocation el2 = sp2.getLocation();
        Real rl = sp2.getAttribute(param);
        double r = rl.getValue();
        if (Float.isNaN((float)r) || r == 0.0) {
            return null;
        }
        double lat2 = el2.getLatitude().getValue();
        double lon2 = el2.getLongitude().getValue();
        double af = this.getCircleAngleRange(el1, el2);
        af = af * 180.0 / Math.PI;
        af = right ? (af -= 90.0) : (af += 90.0);
        if (af <= 90.0 && af >= 0.0) {
            af = 90.0 - af;
        } else if (af > 90.0 && af <= 180.0) {
            af = 360.0 + (90.0 - af);
        } else if (af < 0.0 && af >= -180.0) {
            af = 90.0 - af;
        } else if (af > 180.0 && af <= 360.0) {
            af = 450.0 - af;
        } else if (af < -180.0 && af >= -360.0) {
            af = -270.0 - af;
        }
        LatLonPointImpl lp1 = Bearing.findPoint(lat2, lon2, af, r, null);
        EarthLocationLite el = new EarthLocationLite(lp1.getLatitude(), lp1.getLongitude(), 0.0);
        StormTrackPoint sp = new StormTrackPoint(el, sp1.getTime(), 0, null);
        return sp;
    }

    public double getCircleTangencyAngle(EarthLocation c, EarthLocation d, double r) {
        double lat1 = c.getLatitude().getValue();
        double lon1 = c.getLongitude().getValue();
        double lat2 = d.getLatitude().getValue();
        double lon2 = d.getLongitude().getValue();
        Bearing b = Bearing.calculateBearing(lat1, lon1, lat2, lon2, null);
        double dist = b.getDistance();
        double a = Math.asin(r / dist);
        return a;
    }

    public double getCircleAngleRange(EarthLocation c, EarthLocation d) {
        double lat1 = c.getLatitude().getValue();
        double lon1 = c.getLongitude().getValue();
        LatLonPointImpl p1 = new LatLonPointImpl(lat1, lon1);
        double lat2 = d.getLatitude().getValue();
        double lon2 = d.getLongitude().getValue();
        LatLonPointImpl p2 = new LatLonPointImpl(lat2, lon2);
        LatLonProjection pj1 = new LatLonProjection();
        ProjectionPoint pp1 = pj1.latLonToProj(p1);
        LatLonProjection pj2 = new LatLonProjection();
        ProjectionPoint pp2 = pj2.latLonToProj(p2);
        double dx = pp2.getX() - pp1.getX();
        double dy = pp2.getY() - pp1.getY();
        double a = Math.atan2(dy, dx);
        return a;
    }

    public StormTrackPoint[] getHalfCircleTrackPoint(EarthLocation c, double angle, double r, DateTime dt) throws VisADException {
        int size = 11;
        StormTrackPoint[] track = new StormTrackPoint[size];
        double lat0 = c.getLatitude().getValue();
        double lon0 = c.getLongitude().getValue();
        for (int i = 0; i < size; ++i) {
            StormTrackPoint sp;
            double af = (angle + (double)((i + 1) * 15) * Math.PI / 180.0) * 180.0 / Math.PI;
            if (af <= 90.0 && af >= 0.0) {
                af = 90.0 - af;
            } else if (af > 90.0 && af <= 180.0) {
                af = 360.0 + (90.0 - af);
            } else if (af < 0.0 && af >= -180.0) {
                af = 90.0 - af;
            } else if (af > 180.0 && af <= 360.0) {
                af = 450.0 - af;
            } else if (af < -180.0 && af >= -360.0) {
                af = -270.0 - af;
            }
            LatLonPointImpl lp = Bearing.findPoint(lat0, lon0, af, r, null);
            EarthLocationLite el = new EarthLocationLite(lp.getLatitude(), lp.getLongitude(), 0.0);
            track[i] = sp = new StormTrackPoint(el, dt, 0, null);
        }
        return track;
    }

    public StormTrackPoint[] getHalfCircleTrackPointOld(EarthLocation c, double angle, double r, DateTime dt) throws VisADException {
        int size = 11;
        StormTrackPoint[] track = new StormTrackPoint[size];
        FlatEarth e = new FlatEarth();
        ProjectionPoint p0 = e.latLonToProj(c.getLatitude().getValue(), c.getLongitude().getValue());
        for (int i = 0; i < size; ++i) {
            StormTrackPoint sp;
            double af = angle + (double)(i * 15) * Math.PI / 180.0;
            double x = p0.getX() + r * Math.cos(af);
            double y = p0.getY() + r * Math.sin(af);
            ProjectionPointImpl pp = new ProjectionPointImpl(x, y);
            LatLonPointImpl lp = new LatLonPointImpl();
            FlatEarth e3 = new FlatEarth();
            LatLonPoint lp11 = e3.projToLatLon(pp, lp);
            EarthLocationLite el = new EarthLocationLite(lp11.getLatitude(), lp11.getLongitude(), 0.0);
            track[i] = sp = new StormTrackPoint(el, dt, 0, null);
        }
        return track;
    }
}

