/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control.storm;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import ucar.unidata.data.storm.StormParam;
import ucar.unidata.data.storm.StormTrack;
import ucar.unidata.data.storm.StormTrackPoint;
import ucar.unidata.idv.control.storm.StormDisplayState;
import visad.Real;
import visad.Unit;
import visad.VisADException;

public class StormTrackTableModel
extends AbstractTableModel {
    private StormDisplayState stormDisplayState;
    private StormTrack track;
    private List<StormTrackPoint> points;
    private List<StormParam> params;

    public StormTrackTableModel(StormDisplayState stormDisplayState, StormTrack track) {
        this.stormDisplayState = stormDisplayState;
        this.track = track;
        this.points = track.getTrackPoints();
        List<StormParam> tmp = track.getParams();
        this.params = new ArrayList<StormParam>();
        for (StormParam param : tmp) {
            if (param.getDerived()) continue;
            this.params.add(param);
        }
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return false;
        }
        return this.stormDisplayState.getStormTrackControl().getEditMode();
    }

    public StormTrack getStormTrack() {
        return this.track;
    }

    @Override
    public int getRowCount() {
        return this.points.size();
    }

    @Override
    public int getColumnCount() {
        return 3 + this.params.size();
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int column) {
        StormTrackPoint stp = this.points.get(rowIndex);
        if (column == 0) {
            return;
        }
        if (column != 1 && column != 2) {
            StormParam param = this.params.get(column - 3);
            Real r = stp.getAttribute(param);
            double newValue = new Double(aValue.toString());
            Real rr = null;
            try {
                rr = r.cloneButValue(newValue);
            }
            catch (VisADException visADException) {
                // empty catch block
            }
            stp.setAttribute(rr);
        }
        this.stormDisplayState.markHasBeenEdited();
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (row >= this.points.size()) {
            return "";
        }
        StormTrackPoint stp = this.points.get(row);
        if (column == 0) {
            if (this.track.getWay().isObservation()) {
                return stp.getTime();
            }
            return "" + stp.getForecastHour();
        }
        if (column == 1) {
            return stp.getLocation().getLatitude();
        }
        if (column == 2) {
            return stp.getLocation().getLongitude();
        }
        StormParam param = this.params.get(column - 3);
        Real r = stp.getAttribute(param);
        if (r != null) {
            return r.toString();
        }
        return "";
    }

    @Override
    public String getColumnName(int column) {
        if (column == 0) {
            return this.track.getWay().isObservation() ? "Time" : "Hour";
        }
        if (column == 1) {
            return "Lat";
        }
        if (column == 2) {
            return "Lon";
        }
        StormParam param = this.params.get(column - 3);
        Unit unit = param.getUnit();
        return param.toString() + (unit == null ? "" : "[" + unit + "]");
    }
}

