/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control.storm;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.rmi.RemoteException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JWindow;
import org.w3c.dom.Element;
import ucar.unidata.data.BadDataException;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.gis.KmlUtil;
import ucar.unidata.data.grid.GridUtil;
import ucar.unidata.data.point.PointOb;
import ucar.unidata.data.point.PointObFactory;
import ucar.unidata.data.storm.StormDataSource;
import ucar.unidata.data.storm.StormInfo;
import ucar.unidata.data.storm.StormParam;
import ucar.unidata.data.storm.StormTrack;
import ucar.unidata.data.storm.StormTrackCollection;
import ucar.unidata.data.storm.StormTrackPoint;
import ucar.unidata.data.storm.Way;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.idv.MapViewManager;
import ucar.unidata.idv.control.DisplayControlBase;
import ucar.unidata.idv.control.DisplayControlImpl;
import ucar.unidata.idv.control.ReadoutInfo;
import ucar.unidata.idv.control.storm.StormDisplayState;
import ucar.unidata.idv.control.storm.WayDisplayState;
import ucar.unidata.idv.control.storm.YearDisplayState;
import ucar.unidata.ui.TreePanel;
import ucar.unidata.ui.TwoListPanel;
import ucar.unidata.ui.symbol.StationModel;
import ucar.unidata.ui.symbol.StationModelManager;
import ucar.unidata.util.ColorTable;
import ucar.unidata.util.DateUtil;
import ucar.unidata.util.FileManager;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.MenuUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.Range;
import ucar.unidata.util.StringUtil;
import ucar.unidata.util.TwoFacedObject;
import ucar.unidata.view.geoloc.NavigatedDisplay;
import ucar.unidata.xml.XmlUtil;
import ucar.visad.Util;
import ucar.visad.display.CompositeDisplayable;
import ucar.visad.display.DisplayMaster;
import ucar.visad.display.StationModelDisplayable;
import visad.CommonUnit;
import visad.CoordinateSystem;
import visad.Data;
import visad.DateTime;
import visad.DisplayEvent;
import visad.DoubleSet;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.GriddedSet;
import visad.Real;
import visad.RealType;
import visad.Set;
import visad.SetType;
import visad.Text;
import visad.TextType;
import visad.Tuple;
import visad.Unit;
import visad.VisADException;
import visad.georef.EarthLocation;
import visad.georef.MapProjection;

public class StormTrackControl
extends DisplayControlImpl {
    private static final String PREF_STORMDISPLAYSTATE = "pref.stormtrackcontrol.stormdisplaystate";
    private static final String PREF_OKWAYS = "pref.stormtrackcontrol.okways";
    private static final String PREF_OBWAY = "pref.stormtrackcontrol.observationway";
    private static final String PREF_OKPARAMS = "pref.stormtrackcontrol.okparams";
    private static int cnt = 0;
    final ImageIcon ICON_ON = GuiUtils.getImageIcon("/ucar/unidata/idv/control/storm/dot.gif");
    final ImageIcon ICON_OFF = GuiUtils.getImageIcon("/ucar/unidata/idv/control/storm/blank.gif");
    private StormDisplayState localStormDisplayState;
    private Hashtable preferences;
    private Hashtable<String, Boolean> okWays;
    private Way observationWay;
    private Hashtable<String, Boolean> okParams;
    private String startTime;
    private String endTime;
    private CompositeDisplayable placeHolder;
    private StormDataSource stormDataSource;
    private List<StormInfo> stormInfos;
    private EarthLocation lastEarthLocation = null;
    private Hashtable<StormInfo, StormDisplayState> stormDisplayStateMap = new Hashtable();
    private List<StormDisplayState> activeStorms;
    private TreePanel treePanel;
    private static final int YEAR_TIME_MODE_YEAR = 0;
    private static final int YEAR_TIME_MODE_STORM = 1;
    private int yearTimeMode = 0;
    private Hashtable<Integer, YearDisplayState> yearDisplayStateMap = new Hashtable();
    private Hashtable yearData = new Hashtable();
    private JComboBox timeModeBox;
    private JCheckBox obsCbx;
    private JCheckBox forecastCbx;
    private JCheckBox mostRecentCbx;
    private JCheckBox editedCbx;
    private TwoListPanel waysToUseSelector;
    private TwoListPanel chartParamsSelector;
    private JCheckBox waysToUsePreferenceCbx;
    private JCheckBox chartParamsPreferenceCbx;
    private List<Way> allWays;
    private List<Way> useWays;
    private List<StormParam> allParams;
    private List<StormParam> useParams;
    private JCheckBox obsWayPreferenceCbx;
    private List<JRadioButton> obsWayRadioButtons;
    private boolean editMode = false;
    private Object MUTEX = new Object();
    private Hashtable rangeTypes = new Hashtable();
    private StationModelDisplayable yearLabels;

    public StormTrackControl() {
        this.setAttributeFlags(8);
    }

    protected String getPref(String basePref) {
        return basePref + "." + this.stormDataSource.getId();
    }

    protected boolean isEditable() {
        return this.stormDataSource.isEditable();
    }

    public NavigatedDisplay getVM() {
        return this.getNavigatedDisplay();
    }

    @Override
    public boolean init(DataChoice dataChoice) throws VisADException, RemoteException {
        DataChoice.addCurrentName(new TwoFacedObject((Object)"Storm Track>Forecast Hour", "fhour"));
        DataChoice.addCurrentName(new TwoFacedObject((Object)"Storm Track>Forecast Time", "rhour"));
        DataChoice.addCurrentName(new TwoFacedObject((Object)"Storm Track>Forecast STI Time", "shour"));
        this.placeHolder = new CompositeDisplayable("Place holder");
        this.addDisplayable(this.placeHolder);
        ArrayList dataSources = new ArrayList();
        dataChoice.getDataSources(dataSources);
        if (dataSources.size() != 1) {
            StormTrackControl.userMessage("Could not find Storm Data Source");
            return false;
        }
        if (!(dataSources.get(0) instanceof StormDataSource)) {
            StormTrackControl.userMessage("Could not find Storm Data Source");
            return false;
        }
        this.getColorTableWidget(new Range(1.0, 1.0));
        this.stormDataSource = (StormDataSource)dataSources.get(0);
        if (this.okWays == null) {
            this.okWays = (Hashtable)this.getPreferences().get(this.getPref(PREF_OKWAYS));
        }
        if (this.observationWay == null) {
            this.observationWay = (Way)this.getPreferences().get(this.getPref(PREF_OBWAY));
            if (this.observationWay == null) {
                this.observationWay = this.stormDataSource.getDefaultObservationWay();
            }
        }
        if (this.okWays == null) {
            this.okWays = new Hashtable();
        }
        if (this.okParams == null) {
            this.okParams = (Hashtable)this.getPreferences().get(this.getPref(PREF_OKPARAMS));
        }
        if (this.okParams == null) {
            this.okParams = new Hashtable();
        }
        return true;
    }

    private JComponent getWaysToUseComp() {
        this.useWays = new ArrayList<Way>();
        this.allWays = new ArrayList<Way>();
        for (Way way : this.stormDataSource.getWays()) {
            if (way.isObservation()) continue;
            this.allWays.add(way);
            if (!this.okToShowWay(way)) continue;
            this.useWays.add(way);
        }
        this.useWays = Misc.sort(this.useWays);
        this.allWays = Misc.sort(this.allWays);
        if (this.waysToUsePreferenceCbx == null) {
            this.waysToUsePreferenceCbx = new JCheckBox("Save as preference", false);
        }
        this.waysToUseSelector = new TwoListPanel(this.allWays, "Don't Use", this.useWays, "Use", null, false);
        JPanel contents = GuiUtils.centerBottom(this.waysToUseSelector, GuiUtils.left(this.waysToUsePreferenceCbx));
        return contents;
    }

    private boolean applyWaysToUse() {
        boolean changed = false;
        List only = Misc.sort(this.waysToUseSelector.getCurrentEntries());
        if (!this.useWays.equals(only)) {
            changed = true;
            if (only.size() == this.allWays.size()) {
                this.onlyShowTheseWays(new ArrayList<Way>(), this.waysToUsePreferenceCbx.isSelected());
            } else {
                this.onlyShowTheseWays(only, this.waysToUsePreferenceCbx.isSelected());
            }
        }
        return changed;
    }

    public void showWaysToUseDialog() {
        JComponent waysToUseComp = this.getWaysToUseComp();
        JLabel label = GuiUtils.cLabel(this.getWaysName() + " to use");
        JPanel contents = GuiUtils.topCenter(label, waysToUseComp);
        if (!GuiUtils.showOkCancelDialog(null, this.getWaysName() + " to use", waysToUseComp, null)) {
            return;
        }
        if (this.applyWaysToUse()) {
            // empty if block
        }
    }

    @Override
    protected void addPropertiesComponents(JTabbedPane jtp) {
        super.addPropertiesComponents(jtp);
        JComponent waysToUseComp = this.getWaysToUseComp();
        jtp.add(this.getWaysName() + " to use", waysToUseComp);
        this.useParams = new ArrayList<StormParam>();
        this.allParams = new ArrayList<StormParam>();
        for (StormParam param : this.getTrackParams()) {
            this.allParams.add(param);
            if (!this.okToShowParam(param)) continue;
            this.useParams.add(param);
        }
        if (this.chartParamsPreferenceCbx == null) {
            this.chartParamsPreferenceCbx = new JCheckBox("Save as preference", false);
        }
        this.chartParamsSelector = new TwoListPanel(this.allParams, "All Parameters", this.useParams, "Selected Parameters", null, false);
        JPanel paramsContents = GuiUtils.centerBottom(this.chartParamsSelector, GuiUtils.left(this.chartParamsPreferenceCbx));
        jtp.add("Chart Parameters", paramsContents);
        if (this.stormDataSource.getIsObservationWayChangeable()) {
            this.obsWayRadioButtons = new ArrayList<JRadioButton>();
            ButtonGroup bg = new ButtonGroup();
            for (Way way : this.allWays) {
                if (way.isObservation()) continue;
                JRadioButton jrb = new JRadioButton(way.getId(), Misc.equals(this.observationWay, way));
                this.obsWayRadioButtons.add(jrb);
                bg.add(jrb);
            }
            if (this.obsWayPreferenceCbx == null) {
                this.obsWayPreferenceCbx = new JCheckBox("Save as preference", false);
            }
            JComponent obsWayContents = GuiUtils.topLeft(GuiUtils.doLayout(this.obsWayRadioButtons, this.obsWayRadioButtons.size() > 10 ? 2 : 1, GuiUtils.WT_N, GuiUtils.WT_N));
            int width = 200;
            int height = 150;
            if (this.obsWayRadioButtons.size() > 10) {
                obsWayContents = GuiUtils.makeScrollPane(obsWayContents, width, height);
            }
            jtp.add("Observation " + this.getWayName(), GuiUtils.centerBottom(obsWayContents, GuiUtils.left(this.obsWayPreferenceCbx)));
        }
    }

    public List<StormParam> getTrackParams() {
        StormTrack obsTrack;
        List<StormParam> params = new ArrayList<StormParam>();
        StormDisplayState sds = this.getCurrentStormDisplayState();
        if (sds == null) {
            return params;
        }
        StormTrackCollection stc = sds.getTrackCollection();
        if (stc == null) {
            for (int i = this.stormInfos.size() - 1; i >= 0; --i) {
                StormInfo stormInfo = this.stormInfos.get(i);
                StormDisplayState stormDisplayState = this.getStormDisplayState(stormInfo);
                stc = sds.getTrackCollection();
                if (stc != null) break;
            }
        }
        if (stc == null) {
            System.err.println("Unable to find any active storm displays");
            return params;
        }
        for (StormTrack track : stc.getTracks()) {
            if (track == null || track.isObservation()) continue;
            params = track.getParams();
            break;
        }
        if (params.size() == 0 && (obsTrack = stc.getObsTrack()) != null) {
            params = obsTrack.getParams();
        }
        return params;
    }

    @Override
    public boolean doApplyProperties() {
        List onlyCP;
        if (!super.doApplyProperties()) {
            return false;
        }
        boolean changed = false;
        if (this.applyWaysToUse()) {
            changed = true;
        }
        if (!this.useParams.equals(onlyCP = this.chartParamsSelector.getCurrentEntries())) {
            changed = true;
            if (onlyCP.size() == this.allParams.size()) {
                this.onlyShowTheseParams(new ArrayList<StormParam>(), this.chartParamsPreferenceCbx.isSelected());
            } else {
                this.onlyShowTheseParams(onlyCP, this.chartParamsPreferenceCbx.isSelected());
            }
        }
        if (this.stormDataSource.getIsObservationWayChangeable()) {
            Way newObsWay = null;
            for (int i = 0; i < this.obsWayRadioButtons.size(); ++i) {
                if (!this.obsWayRadioButtons.get(i).isSelected()) continue;
                newObsWay = this.allWays.get(i);
                break;
            }
            if (newObsWay != null) {
                if (!Misc.equals(newObsWay, this.observationWay)) {
                    changed = true;
                    this.observationWay = newObsWay;
                }
                if (this.obsWayPreferenceCbx.isSelected()) {
                    this.putPreference(this.getPref(PREF_OBWAY), this.observationWay);
                }
            }
        }
        if (changed) {
            this.reloadStormTracks();
        }
        return true;
    }

    @Override
    protected boolean shouldAddControlListener() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void viewpointChanged() {
        super.viewpointChanged();
        Object object = this.MUTEX;
        synchronized (object) {
            StormDisplayState sds = this.getCurrentStormDisplayState();
            HashMap<Way, List> wayToTracksMap = sds.getTrackCollection().getWayToTracksHashMap();
            java.util.Set<Way> ways = wayToTracksMap.keySet();
            for (Way way : ways) {
                if (!way.equals(Way.OBSERVATION)) continue;
                WayDisplayState obsWDS = sds.getWayDisplayState(way);
                try {
                    obsWDS.updateLayoutModel();
                }
                catch (Exception exc) {
                    StormTrackControl.logException("view point Changed", exc);
                    return;
                }
            }
        }
    }

    protected FieldImpl makeTrackField(StormTrack track, StormParam param) throws Exception {
        List<StormTrackPoint> points = track.getTrackPoints();
        int numPoints = points.size();
        RealType rangeType = null;
        double[][] newRangeVals = new double[1][numPoints];
        float[] alts = new float[numPoints];
        float[] lats = new float[numPoints];
        float[] lons = new float[numPoints];
        Real[] values = param == null ? null : track.getTrackAttributeValues(param);
        Unit unit = param != null ? param.getUnit() : null;
        for (int pointIdx = 0; pointIdx < numPoints; ++pointIdx) {
            Real value;
            StormTrackPoint stp = points.get(pointIdx);
            Real real = value = values == null ? null : values[pointIdx];
            if (rangeType == null) {
                String key = track.getWay() + "_" + track.getId() + "_" + param;
                if (track.getWay().toString().startsWith("Observation_year")) {
                    key = track.getWay() + "_" + param;
                }
                if ((rangeType = (RealType)this.rangeTypes.get(key)) == null) {
                    rangeType = track.getWay().toString().startsWith("Observation_year") ? Util.makeRealType("trackrange_" + track.getWay() + "_" + cnt, unit) : Util.makeRealType("trackrange_" + track.getId() + "_" + track.getWay() + "_" + ++cnt, unit);
                    this.rangeTypes.put(key, rangeType);
                }
            }
            EarthLocation el = stp.getLocation();
            newRangeVals[0][pointIdx] = value != null ? value.getValue() : 0.0;
            lats[pointIdx] = (float)el.getLatitude().getValue();
            lons[pointIdx] = (float)el.getLongitude().getValue();
            alts[pointIdx] = 1.0f;
        }
        GriddedSet llaSet = Util.makeEarthDomainSet(lats, lons, alts);
        Set[] rangeSets = new Set[]{new DoubleSet(new SetType(rangeType))};
        FunctionType newType = new FunctionType(((SetType)llaSet.getType()).getDomain(), rangeType);
        FlatField trackField = new FlatField(newType, (Set)llaSet, (CoordinateSystem)null, rangeSets, new Unit[]{unit});
        trackField.setSamples(newRangeVals, false);
        return trackField;
    }

    @Override
    public void setColorTable(String whichColorTable, ColorTable newColorTable) throws RemoteException, VisADException {
        super.setColorTable(whichColorTable, newColorTable);
        for (StormDisplayState sds : this.getActiveStorms()) {
            sds.colorTableChanged();
        }
    }

    public DisplayMaster getDisplayMaster() {
        return this.getDisplayMaster(this.placeHolder);
    }

    protected boolean okToShowWay(Way way) {
        if (way.isObservation()) {
            return true;
        }
        if (this.okWays == null) {
            this.showWaysToUseDialog();
        }
        if (this.okWays == null) {
            return true;
        }
        return this.okWays.size() <= 0 || this.okWays.get(way.getId()) != null;
    }

    protected boolean okToShowParam(StormParam param) {
        if (this.okParams == null) {
            return true;
        }
        return this.okParams.size() <= 0 || this.okParams.get(param.getName()) != null;
    }

    public StormDisplayState getCurrentStormDisplayState() {
        if (this.localStormDisplayState != null) {
            return this.localStormDisplayState;
        }
        if (this.treePanel == null) {
            return null;
        }
        Component comp = this.treePanel.getVisibleComponent();
        if (comp == null) {
            return null;
        }
        for (int i = this.stormInfos.size() - 1; i >= 0; --i) {
            StormInfo stormInfo = this.stormInfos.get(i);
            StormDisplayState stormDisplayState = this.getStormDisplayState(stormInfo);
            if (stormDisplayState.getContents() != comp) continue;
            return stormDisplayState;
        }
        return null;
    }

    @Override
    protected void resetData() throws VisADException, RemoteException {
        this.reloadStormTracks();
    }

    private List<StormDisplayState> getStormDisplays() {
        ArrayList<StormDisplayState> states = new ArrayList<StormDisplayState>();
        for (int i = this.stormInfos.size() - 1; i >= 0; --i) {
            StormInfo stormInfo = this.stormInfos.get(i);
            states.add(this.getStormDisplayState(stormInfo));
        }
        return states;
    }

    private void reloadStormTracks() {
        for (StormDisplayState stormDisplayState : this.getActiveStorms()) {
            stormDisplayState.reload();
        }
    }

    private void onlyShowTheseWays(List<Way> ways, boolean writeAsPreference) {
        this.okWays = new Hashtable();
        for (Way way : ways) {
            this.okWays.put(way.getId(), new Boolean(true));
        }
        if (writeAsPreference) {
            this.putPreference(this.getPref(PREF_OKWAYS), this.okWays);
        }
    }

    private void onlyShowTheseParams(List<StormParam> params, boolean writeAsPreference) {
        this.okParams = new Hashtable();
        for (StormParam param : params) {
            this.okParams.put(param.getName(), new Boolean(true));
        }
        if (writeAsPreference) {
            this.putPreference(this.getPref(PREF_OKPARAMS), this.okParams);
        }
    }

    public StormDataSource getStormDataSource() {
        return this.stormDataSource;
    }

    public void viewStorm(StormDisplayState stormDisplayState) {
        if (this.treePanel != null) {
            this.treePanel.show(stormDisplayState.getContents());
        }
    }

    public void unloadAllTracks() {
        for (StormDisplayState stormDisplayState : this.getActiveStorms()) {
            stormDisplayState.deactivate();
        }
    }

    protected boolean canHandleEvents() {
        if (!this.editMode || !this.getHaveInitialized() || this.getMakeWindow() && !this.getWindowVisible()) {
            return false;
        }
        return this.isGuiShown();
    }

    @Override
    public void handleDisplayChanged(DisplayEvent event) {
        StormDisplayState current = this.getCurrentStormDisplayState();
        if (current == null || !current.getActive()) {
            return;
        }
        int id = event.getId();
        if (id == 21) {
            return;
        }
        if (!this.canHandleEvents()) {
            return;
        }
        InputEvent inputEvent = event.getInputEvent();
        try {
            current.handleEvent(event);
        }
        catch (Exception exc) {
            StormTrackControl.logException("Error handling edit", exc);
        }
    }

    @Override
    protected void getSaveMenuItems(List items, boolean forMenuBar) {
        StormDisplayState current = this.getCurrentStormDisplayState();
        if (current != null && current.getActive()) {
            items.add(GuiUtils.makeMenuItem("Save Storm Display as Preference", this, "saveStormDisplayState"));
            if (this.getPreferences().get(this.getPref(PREF_STORMDISPLAYSTATE)) != null) {
                items.add(GuiUtils.makeMenuItem("Remove Storm Display Preference", this, "deleteStormDisplayState"));
            }
            items.add("separator");
            items.add(GuiUtils.makeMenuItem("Export to Data File", current, "writeToDataFile"));
        }
        items.add(GuiUtils.makeMenuItem("Export to Google Earth", this, "writeToKml"));
        super.getSaveMenuItems(items, forMenuBar);
    }

    @Override
    protected void getEditMenuItems(List items, boolean forMenuBar) {
        items.add(MenuUtil.makeCheckboxMenuItem("Edit Mode", this, "editMode", null));
        StormDisplayState current = this.getCurrentStormDisplayState();
        if (current != null && current.getActive()) {
            items.add(GuiUtils.makeMenuItem("Add Forecast Time Chart", current, "addForecastTimeChart"));
            items.add(GuiUtils.makeMenuItem("Add Forecast Hour Chart", current, "addForecastHourChart"));
        }
        super.getEditMenuItems(items, forMenuBar);
    }

    @Override
    protected void getViewMenuItems(List items, boolean forMenuBar) {
        try {
            ArrayList<JMenu> subMenus = new ArrayList<JMenu>();
            GregorianCalendar cal = new GregorianCalendar(DateUtil.TIMEZONE_GMT);
            Hashtable<String, JMenu> menus = new Hashtable<String, JMenu>();
            ArrayList<Object> activeItems = new ArrayList<Object>();
            for (int i = this.stormInfos.size() - 1; i >= 0; --i) {
                StormDisplayState stormDisplayState;
                StormInfo stormInfo = this.stormInfos.get(i);
                cal.setTime(Util.makeDate(stormInfo.getStartTime()));
                int year = cal.get(1);
                JMenu yearMenu = (JMenu)menus.get("" + year);
                if (yearMenu == null) {
                    yearMenu = new JMenu("" + year);
                    menus.put("" + year, yearMenu);
                    subMenus.add(yearMenu);
                }
                if ((stormDisplayState = this.getStormDisplayState(stormInfo)).getActive()) {
                    activeItems.add(MenuUtil.makeMenuItem(stormInfo.toString(), this, "viewStorm", stormDisplayState));
                }
                if (stormInfo.getBasin() != null) {
                    JMenu basinMenu = (JMenu)menus.get(year + "Basin:" + stormInfo.getBasin());
                    if (basinMenu == null) {
                        basinMenu = new JMenu("Basin:" + stormInfo.getBasin());
                        menus.put(year + "Basin:" + stormInfo.getBasin(), basinMenu);
                        yearMenu.add(basinMenu);
                    }
                    yearMenu = basinMenu;
                }
                yearMenu.add(GuiUtils.makeMenuItem(stormInfo.toString(), this, "viewStorm", stormDisplayState));
            }
            JMenu trackMenu = GuiUtils.makeMenu("Storm Tracks", subMenus);
            GuiUtils.limitMenuSize(trackMenu, "Tracks:", 30);
            if (activeItems.size() > 0) {
                activeItems.add(0, "separator");
                activeItems.add(0, GuiUtils.makeMenuItem("Unload all tracks", this, "unloadAllTracks", null));
                trackMenu.insert(GuiUtils.makeMenu("Active Tracks", activeItems), 0);
            }
            items.add(trackMenu);
            super.getViewMenuItems(items, forMenuBar);
        }
        catch (Exception exc) {
            StormTrackControl.logException("Making track menu", exc);
        }
    }

    public String getWayName() {
        return this.stormDataSource.getWayName();
    }

    public String getWaysName() {
        return this.stormDataSource.getWaysName();
    }

    @Override
    protected String getDataProjectionLabel() {
        return "Use Projection From Tracks";
    }

    @Override
    public MapProjection getDataProjection() {
        return null;
    }

    @Override
    public boolean hasMapProjection() {
        return true;
    }

    @Override
    public MapProjection getDataProjectionForMenu() {
        try {
            double minLon = Double.POSITIVE_INFINITY;
            double maxLon = Double.NEGATIVE_INFINITY;
            double minLat = Double.POSITIVE_INFINITY;
            double maxLat = Double.NEGATIVE_INFINITY;
            List<StormDisplayState> stormDisplayStates = this.getStormDisplayStates();
            boolean didone = false;
            for (StormDisplayState stormDisplayState : this.getActiveStorms()) {
                LatLonRect bbox = stormDisplayState.getBoundingBox();
                if (bbox == null) continue;
                minLon = Math.min(minLon, bbox.getLonMin());
                maxLon = Math.max(maxLon, bbox.getLonMax());
                minLat = Math.min(minLat, bbox.getLatMin());
                maxLat = Math.max(maxLat, bbox.getLatMax());
                didone = true;
            }
            for (YearDisplayState yearDisplayState : this.getYearDisplayStates()) {
                if (!yearDisplayState.getActive()) continue;
                List<StormTrack> yearTracks = yearDisplayState.getStormTracks();
                for (StormTrack track : yearTracks) {
                    LatLonRect bbox = track.getBoundingBox();
                    if (bbox == null) continue;
                    minLon = Math.min(minLon, bbox.getLonMin());
                    maxLon = Math.max(maxLon, bbox.getLonMax());
                    minLat = Math.min(minLat, bbox.getLatMin());
                    maxLat = Math.max(maxLat, bbox.getLatMax());
                    didone = true;
                }
            }
            if (!didone) {
                return null;
            }
            return Util.makeMapProjection(minLat, minLon, maxLat, maxLon);
        }
        catch (Exception exc) {
            StormTrackControl.logException("Error making projection from tracks", exc);
            return null;
        }
    }

    private List<StormDisplayState> getActiveStorms() {
        if (this.activeStorms == null) {
            ArrayList<StormDisplayState> tmpList = new ArrayList<StormDisplayState>();
            List<StormDisplayState> stormDisplayStates = this.getStormDisplayStates();
            for (StormDisplayState stormDisplayState : stormDisplayStates) {
                if (!stormDisplayState.getActive()) continue;
                tmpList.add(stormDisplayState);
            }
            this.activeStorms = tmpList;
        }
        return this.activeStorms;
    }

    private Hashtable getPreferences() {
        if (this.preferences == null) {
            String path = this.stormDataSource.getClass().getName() + ".StormTrackControl.xml";
            this.preferences = (Hashtable)this.getIdv().getStore().getEncodedFile(path);
            if (this.preferences == null) {
                this.preferences = new Hashtable();
            }
        }
        return this.preferences;
    }

    public void deleteStormDisplayState() {
        String template = (String)this.getPreferences().get(this.getPref(PREF_STORMDISPLAYSTATE));
        if (template != null) {
            this.getPreferences().remove(this.getPref(PREF_STORMDISPLAYSTATE));
            this.writePreferences();
        }
    }

    public void saveStormDisplayState() {
        try {
            StormDisplayState current = this.getCurrentStormDisplayState();
            if (current == null) {
                return;
            }
            boolean wasActive = current.getActive();
            current.setActive(false);
            current.setStormTrackControl(null);
            String xml = this.getIdv().encodeObject(current, false);
            current.setStormTrackControl(this);
            current.setActive(wasActive);
            this.putPreference(this.getPref(PREF_STORMDISPLAYSTATE), xml);
            StormTrackControl.userMessage("<html>Preference saved. <br>Note: This will take effect for new display controls</html>");
        }
        catch (Exception exc) {
            StormTrackControl.logException("Saving storm display", exc);
        }
    }

    private void writePreferences() {
        String path = this.stormDataSource.getClass().getName() + ".StormTrackControl.xml";
        this.getIdv().getStore().putEncodedFile(path, this.preferences);
    }

    private void putPreference(String key, Object object) {
        this.getPreferences().put(key, object);
        this.writePreferences();
    }

    private StormDisplayState getStormDisplayState(StormInfo stormInfo) {
        StormDisplayState stormDisplayState = this.stormDisplayStateMap.get(stormInfo);
        try {
            String template;
            if (stormDisplayState == null && (template = (String)this.getPreferences().get(this.getPref(PREF_STORMDISPLAYSTATE))) != null) {
                try {
                    stormDisplayState = (StormDisplayState)this.getIdv().decodeObject(template);
                    stormDisplayState.setStormInfo(stormInfo);
                }
                catch (Exception exc) {
                    StormTrackControl.logException("Creating storm display", exc);
                    System.err.println("Error decoding preference:" + exc);
                }
            }
            if (stormDisplayState == null) {
                stormDisplayState = new StormDisplayState(stormInfo);
            }
            stormDisplayState.setStormTrackControl(this);
            this.stormDisplayStateMap.put(stormInfo, stormDisplayState);
        }
        catch (Exception exc) {
            StormTrackControl.logException("Creating storm display", exc);
        }
        return stormDisplayState;
    }

    @Override
    public void initDone() {
        super.initDone();
        try {
            Enumeration<StormInfo> keys = this.stormDisplayStateMap.keys();
            while (keys.hasMoreElements()) {
                MapViewManager mvm;
                StormInfo key = keys.nextElement();
                StormDisplayState stormDisplayState = this.stormDisplayStateMap.get(key);
                stormDisplayState.setStormTrackControl(this);
                stormDisplayState.initDone();
                MapProjection mapProjection = this.getDataProjectionForMenu();
                if (mapProjection == null || (mvm = this.getMapViewManager()) == null) continue;
                mvm.setMapProjection(mapProjection, true, this.getDisplayConventions().getMapProjectionLabel(mapProjection, this), true);
            }
        }
        catch (Exception exc) {
            StormTrackControl.logException("Setting new storm info", exc);
        }
        Misc.run(this, "initYears");
        this.getControlContext().getStationModelManager().addPropertyChangeListener(this);
    }

    @Override
    public void doRemove() throws VisADException, RemoteException {
        this.getControlContext().getStationModelManager().removePropertyChangeListener(this);
        super.doRemove();
    }

    public void initYears() {
        List<YearDisplayState> ydss = this.getYearDisplayStates();
        for (YearDisplayState yds : ydss) {
            if (!yds.getActive()) continue;
            try {
                yds.setState(1);
                this.loadYearInner(yds);
            }
            catch (Exception exc) {
                StormTrackControl.logException("Loading year", exc);
                return;
            }
        }
        this.loadYearPointData();
    }

    private void loadYearPointData() {
        try {
            if (this.yearLabels == null) {
                this.yearLabels = new StationModelDisplayable("storm year labels");
                this.yearLabels.setScale(this.getDisplayScale());
                StationModelManager smm = this.getControlContext().getStationModelManager();
                StationModel model = smm.getStationModel("Label");
                this.yearLabels.setStationModel(model);
                this.addDisplayable(this.yearLabels);
            }
            ArrayList allPointObs = new ArrayList();
            List<YearDisplayState> ydss = this.getYearDisplayStates();
            for (YearDisplayState yds : ydss) {
                List tmp;
                if (!yds.getActive() || (tmp = yds.getPointObs()) == null) continue;
                allPointObs.addAll(tmp);
            }
            if (allPointObs.size() == 0) {
                this.removeDisplayable(this.yearLabels);
                this.yearLabels = null;
            } else {
                this.yearLabels.setStationData(PointObFactory.makeTimeSequenceOfPointObs(allPointObs, -1, -1));
            }
        }
        catch (Exception exc) {
            StormTrackControl.logException("Loading year", exc);
        }
    }

    public void unloadYear(YearDisplayState yds) {
        Misc.run(new Runnable(){

            @Override
            public void run() {
                try {
                    StormTrackControl.this.loadYearPointData();
                }
                catch (Exception exc) {
                    DisplayControlBase.logException("Loading year", exc);
                }
            }
        });
    }

    public void loadYear(final YearDisplayState yds) {
        Misc.run(new Runnable(){

            @Override
            public void run() {
                try {
                    yds.setState(1);
                    StormTrackControl.this.loadYearInner(yds);
                    StormTrackControl.this.loadYearPointData();
                }
                catch (Exception exc) {
                    DisplayControlBase.logException("Loading year", exc);
                }
            }
        });
    }

    public void loadYearInner(YearDisplayState yds) throws Exception {
        TextType textType = TextType.getTextType("ID");
        ArrayList<FieldImpl> fields = new ArrayList<FieldImpl>();
        ArrayList<DateTime> times = new ArrayList<DateTime>();
        ArrayList<StormTrack> obsTracks = new ArrayList<StormTrack>();
        ArrayList<PointOb> pointObs = new ArrayList<PointOb>();
        Window errorWindow = null;
        JLabel errorLabel = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
        sdf.setTimeZone(DateUtil.TIMEZONE_GMT);
        GregorianCalendar cal = new GregorianCalendar(DateUtil.TIMEZONE_GMT);
        Hashtable<String, Boolean> obsWays = new Hashtable<String, Boolean>();
        obsWays.put(Way.OBSERVATION.toString(), new Boolean(true));
        String currentMessage = "";
        String errors = "";
        boolean doYearTime = this.yearTimeMode == 0;
        for (int i = this.stormInfos.size() - 1; i >= 0; --i) {
            if (yds.getState() != 1) {
                yds.setState(0);
                yds.setStatus("");
                if (errorWindow != null) {
                    errorWindow.setVisible(false);
                }
                return;
            }
            StormInfo stormInfo = this.stormInfos.get(i);
            cal.setTime(Util.makeDate(stormInfo.getStartTime()));
            int stormYear = cal.get(1);
            if (stormYear != yds.getYear()) continue;
            String key = yds.getYear() + "_" + stormInfo.getStormId();
            StormTrack obsTrack = (StormTrack)this.yearData.get(key);
            if (obsTrack == null) {
                yds.setStatus("Loading " + stormInfo + "...");
                currentMessage = "Loading " + stormInfo;
                try {
                    StormTrackCollection tracks = this.stormDataSource.getTrackCollection(stormInfo, obsWays, this.observationWay);
                    obsTrack = tracks.getObsTrack();
                    if (obsTrack == null) continue;
                    obsTrack = new StormTrack(obsTrack);
                    obsTrack.setWay(new Way(obsTrack.getWay() + "_year" + yds.getYear()));
                    this.yearData.put(key, obsTrack);
                }
                catch (BadDataException bde) {
                    if (errorWindow == null) {
                        Window parent = GuiUtils.getWindow(yds.getButton());
                        errorWindow = new JWindow(parent);
                        errorLabel = new JLabel(" ");
                        ((JWindow)errorWindow).getContentPane().add(errorLabel);
                        errorLabel.setBorder(BorderFactory.createBevelBorder(0));
                        errorWindow.pack();
                        try {
                            Point loc = yds.getButton().getLocationOnScreen();
                            errorWindow.setLocation((int)loc.getX(), (int)(loc.getY() + (double)yds.getButton().bounds().height));
                        }
                        catch (Exception loc) {
                            // empty catch block
                        }
                        errorWindow.setVisible(true);
                    }
                    errors = errors + "Error " + currentMessage + "<br>";
                    yds.setStatus("Error:" + currentMessage);
                    errorLabel.setText("<html><i>" + errors + "</i></html>");
                    errorWindow.pack();
                }
            }
            if (obsTrack == null) continue;
            FieldImpl field = this.makeTrackField(obsTrack, null);
            StormTrackPoint stp = obsTrack.getTrackPoints().get(0);
            DateTime dttm = new DateTime(sdf.parse("" + yds.getYear()));
            if (!doYearTime) {
                dttm = stormInfo.getStartTime();
            }
            obsTracks.add(obsTrack);
            times.add(dttm);
            fields.add(field);
            Tuple tuple = new Tuple(new Data[]{new Text(textType, stormInfo.toString())});
            pointObs.add(PointObFactory.makePointOb(stp.getLocation(), dttm, tuple));
        }
        if (errorWindow != null) {
            errorWindow.setVisible(false);
        }
        if (times.size() == 0) {
            yds.setStatus("No observation track found");
            yds.setState(0);
        } else {
            yds.setData(doYearTime, obsTracks, times, fields, pointObs);
            yds.setState(2);
            yds.setStatus("");
        }
    }

    public void writeToKml() {
        if (this.obsCbx == null) {
            this.obsCbx = new JCheckBox("Observation", true);
            this.forecastCbx = new JCheckBox("Forecast", true);
            this.mostRecentCbx = new JCheckBox("Most Recent Forecasts", false);
        }
        JPanel accessory = GuiUtils.top(GuiUtils.vbox(this.obsCbx, this.forecastCbx, this.mostRecentCbx));
        String filename = FileManager.getWriteFile(Misc.newList(FileManager.FILTER_KML), ".kml", (JComponent)accessory);
        if (filename == null) {
            return;
        }
        try {
            this.writeToKml(filename, this.obsCbx.isSelected(), this.forecastCbx.isSelected(), this.mostRecentCbx.isSelected());
        }
        catch (Exception exc) {
            StormTrackControl.logException("Writing KML", exc);
        }
    }

    public void writeToKml(String filename, boolean doObs, boolean doForecast, boolean mostRecent) throws VisADException, RemoteException {
        try {
            Element kmlNode = KmlUtil.kml("");
            Element docNode = KmlUtil.document(kmlNode, "");
            KmlUtil.iconstyle(docNode, "hurricaneicon", "http://www.unidata.ucar.edu/software/idv/kml/images/hurricane.png");
            Hashtable state = new Hashtable();
            for (StormDisplayState stormDisplayState : this.getActiveStorms()) {
                stormDisplayState.writeToKml(docNode, state, doObs, doForecast, mostRecent);
            }
            List<YearDisplayState> ydss = this.getYearDisplayStates();
            for (YearDisplayState yds : ydss) {
                if (!yds.getActive()) continue;
                Element yearNode = KmlUtil.folder(docNode, "Year:" + yds.getYear());
                for (StormTrack track : yds.getStormTracks()) {
                    this.writeToGE(docNode, state, yearNode, track, yds.getColor());
                }
            }
            FileOutputStream fileOutputStream = new FileOutputStream(filename);
            IOUtil.writeBytes(new File(filename), XmlUtil.toString(kmlNode).getBytes());
        }
        catch (Exception exc) {
            StormTrackControl.logException("Writing KML", exc);
        }
    }

    protected void writeToGE(Element docNode, Hashtable state, Element parent, StormTrack track, Color color) throws Exception {
        Element placemark = KmlUtil.placemark(parent, "Track", "<html>" + this.getWayName() + ":" + track.getWay() + "<br>" + "" + track.getStartTime() + "</html>");
        boolean cnt = false;
        String dateString = track.getStartTime().formattedString("yyyy-MM-dd hhmm", DateUtil.TIMEZONE_GMT);
        String sheetName = track.getWay() + " - " + dateString;
        boolean rowCnt = false;
        List<StormParam> params = track.getParams();
        StringBuffer sb = new StringBuffer();
        for (StormTrackPoint stp : track.getTrackPoints()) {
            EarthLocation el = stp.getLocation();
            if (track.getWay().isObservation()) {
                Element icon = KmlUtil.placemark(parent, "Time:" + stp.getTime(), "<html><table>" + this.formatStormTrackPoint(track, stp) + "</table></html>", el.getLatitude().getValue(CommonUnit.degree), el.getLongitude().getValue(CommonUnit.degree), el.getAltitude() != null ? el.getAltitude().getValue() : 0.0, "#hurricaneicon");
                KmlUtil.timestamp(icon, Util.makeDate(stp.getTime()));
            }
            sb.append(el.getLongitude().getValue());
            sb.append(",");
            sb.append(el.getLatitude().getValue());
            sb.append(",");
            sb.append(el.getAltitude().getValue());
            sb.append("\n");
        }
        String styleUrl = "linestyle" + track.getWay();
        if (state.get(styleUrl) == null) {
            Element style = KmlUtil.linestyle(docNode, styleUrl, color, track.getWay().isObservation() ? 3 : 2);
            state.put(styleUrl, style);
        }
        KmlUtil.styleurl(placemark, "#" + styleUrl);
        Element linestring = KmlUtil.linestring(placemark, false, false, sb.toString());
        if (!track.getWay().isObservation()) {
            KmlUtil.timestamp(placemark, Util.makeDate(track.getStartTime()));
        }
    }

    @Override
    protected Container doMakeContents() throws VisADException, RemoteException {
        this.stormInfos = Misc.sort(this.stormDataSource.getStormInfos());
        if (this.stormInfos.size() == 1) {
            try {
                if (this.localStormDisplayState == null) {
                    this.localStormDisplayState = new StormDisplayState(this.stormInfos.get(0));
                }
                this.stormDisplayStateMap = new Hashtable();
                this.localStormDisplayState.setStormTrackControl(this);
                this.stormDisplayStateMap.put(this.stormInfos.get(0), this.localStormDisplayState);
                this.localStormDisplayState.setIsOnlyChild(true);
                JComponent comp = this.localStormDisplayState.getContents();
                this.localStormDisplayState.loadStorm();
                return comp;
            }
            catch (Exception exc) {
                StormTrackControl.logException("Creating storm display", exc);
                return new JLabel("Error");
            }
        }
        this.localStormDisplayState = null;
        this.treePanel = new TreePanel(true, 150);
        Hashtable<Integer, String> years = new Hashtable<Integer, String>();
        JComponent firstComponent = null;
        JComponent firstSelectedComponent = null;
        GregorianCalendar cal = new GregorianCalendar(DateUtil.TIMEZONE_GMT);
        ArrayList<JPanel> yearPanels = new ArrayList<JPanel>();
        ArrayList<JComponent> yearComps = new ArrayList<JComponent>();
        for (int i = this.stormInfos.size() - 1; i >= 0; --i) {
            StormInfo stormInfo = this.stormInfos.get(i);
            cal.setTime(Util.makeDate(stormInfo.getStartTime()));
            int year = cal.get(1);
            if (years.get(new Integer(year)) != null) continue;
            YearDisplayState yds = this.getYearDisplayState(year);
            yearComps.add(new JLabel("" + year));
            yearComps.add(yds.getButton());
            yearComps.add(GuiUtils.wrap(yds.getColorSwatch()));
            yearComps.add(yds.getLabel());
            years.put(new Integer(year), "");
            if (yearComps.size() <= 20) continue;
            GuiUtils.tmpInsets = GuiUtils.INSETS_5;
            yearPanels.add(GuiUtils.doLayout(yearComps, 4, GuiUtils.WT_NNNY, GuiUtils.WT_N));
            yearComps = new ArrayList();
        }
        GuiUtils.tmpInsets = GuiUtils.INSETS_5;
        yearPanels.add(GuiUtils.doLayout(yearComps, 4, GuiUtils.WT_NNNY, GuiUtils.WT_N));
        JComponent yearComponent = GuiUtils.vbox(yearPanels);
        if (yearPanels.size() > 0) {
            int width = 300;
            int height = 400;
            JScrollPane scroller = GuiUtils.makeScrollPane(GuiUtils.top(yearComponent), width, height);
            scroller.setBorder(BorderFactory.createLoweredBevelBorder());
            scroller.setPreferredSize(new Dimension(width, height));
            scroller.setMinimumSize(new Dimension(width, height));
            yearComponent = scroller;
        }
        this.timeModeBox = new JComboBox(new Vector(Misc.newList("Start Year", "Storm Date")));
        this.timeModeBox.setSelectedIndex(this.yearTimeMode);
        this.timeModeBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                StormTrackControl.this.yearTimeMode = StormTrackControl.this.timeModeBox.getSelectedIndex();
                Misc.run(StormTrackControl.this, "initYears");
            }
        });
        JPanel yearTopComp = GuiUtils.inset((Component)GuiUtils.left(GuiUtils.label("Time Mode: ", this.timeModeBox)), 5);
        this.treePanel.addComponent(GuiUtils.topCenter(yearTopComp, yearComponent), null, "Yearly Tracks", null);
        years = new Hashtable();
        for (int i = this.stormInfos.size() - 1; i >= 0; --i) {
            StormInfo stormInfo = this.stormInfos.get(i);
            cal.setTime(Util.makeDate(stormInfo.getStartTime()));
            int year = cal.get(1);
            StormDisplayState stormDisplayState = this.getStormDisplayState(stormInfo);
            String category = "" + year;
            JComponent panelContents = stormDisplayState.getContents();
            if (stormInfo.getBasin() != null) {
                category = category + ">" + "Basin:" + stormInfo.getBasin();
            }
            this.treePanel.addComponent(panelContents, category, stormInfo.toString(), stormDisplayState.getActive() ? this.ICON_ON : this.ICON_OFF);
            if (stormDisplayState.getActive() && firstSelectedComponent == null) {
                firstSelectedComponent = panelContents;
            }
            if (firstComponent != null) continue;
            firstComponent = panelContents;
        }
        if (firstSelectedComponent != null) {
            this.treePanel.show(firstSelectedComponent);
        } else if (firstComponent != null) {
            this.treePanel.show(firstComponent);
        }
        TreePanel contents = this.treePanel;
        if (this.startTime != null && this.endTime != null) {
            try {
                Date[] range = DateUtil.getDateRange(this.startTime, this.endTime, new Date());
                double fromDate = range[0].getTime();
                double toDate = range[1].getTime();
                for (StormInfo stormInfo : this.stormInfos) {
                    double date = Util.makeDate(stormInfo.getStartTime()).getTime();
                    StormDisplayState stormDisplayState = this.getStormDisplayState(stormInfo);
                    if (date >= fromDate && date <= toDate) {
                        stormDisplayState.loadStorm();
                        continue;
                    }
                    if (!stormDisplayState.getActive()) continue;
                    stormDisplayState.deactivate();
                }
            }
            catch (ParseException pe) {
                StormTrackControl.logException("Error parsing start/end dates:" + this.startTime + " " + this.endTime, pe);
            }
        }
        return contents;
    }

    public void stormChanged(StormDisplayState stormDisplayState) {
        this.activeStorms = null;
        if (this.treePanel != null) {
            this.treePanel.setIcon(stormDisplayState.getContents(), stormDisplayState.getActive() ? this.ICON_ON : this.ICON_OFF);
        }
    }

    @Override
    protected void timeChanged(Real time) {
        try {
            List<StormDisplayState> active = this.getActiveStorms();
            for (StormDisplayState stormDisplayState : active) {
                stormDisplayState.timeChanged(time);
            }
        }
        catch (Exception exc) {
            StormTrackControl.logException("changePosition", exc);
        }
        super.timeChanged(time);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("prop.resourcechange")) {
            StationModel changedModel = (StationModel)evt.getNewValue();
            this.handleChangedStationModel(changedModel.getName());
        } else if (evt.getPropertyName().equals("prop.resourceremove")) {
            StationModel changedModel = (StationModel)evt.getOldValue();
            this.handleChangedStationModel(changedModel.getName());
        }
        super.propertyChange(evt);
    }

    private void handleChangedStationModel(String name) {
        for (int i = this.stormInfos.size() - 1; i >= 0; --i) {
            StormInfo stormInfo = this.stormInfos.get(i);
            StormDisplayState stormDisplayState = this.getStormDisplayState(stormInfo);
            if (!stormDisplayState.getActive()) continue;
            stormDisplayState.handleChangedStationModel(name);
        }
    }

    public void setStormDisplayStates(List<StormDisplayState> value) {
        if (value != null) {
            for (StormDisplayState stormDisplayState : value) {
                this.stormDisplayStateMap.put(stormDisplayState.getStormInfo(), stormDisplayState);
            }
        }
    }

    public List<StormDisplayState> getStormDisplayStates() {
        ArrayList<StormDisplayState> stormDisplayStates = new ArrayList<StormDisplayState>();
        Enumeration<StormInfo> keys = this.stormDisplayStateMap.keys();
        while (keys.hasMoreElements()) {
            StormInfo key = keys.nextElement();
            StormDisplayState stormDisplayState = this.stormDisplayStateMap.get(key);
            if (!stormDisplayState.getActive()) continue;
            stormDisplayStates.add(stormDisplayState);
        }
        return stormDisplayStates;
    }

    public YearDisplayState getYearDisplayState(int year) {
        YearDisplayState yearDisplayState = this.yearDisplayStateMap.get(new Integer(year));
        if (yearDisplayState == null) {
            yearDisplayState = new YearDisplayState(this, year);
            this.yearDisplayStateMap.put(new Integer(year), yearDisplayState);
        }
        return yearDisplayState;
    }

    public void setYearDisplayStates(List<YearDisplayState> value) {
        if (value != null) {
            this.yearDisplayStateMap = new Hashtable();
            for (YearDisplayState yearDisplayState : value) {
                this.yearDisplayStateMap.put(new Integer(yearDisplayState.getYear()), yearDisplayState);
            }
        }
    }

    public List<YearDisplayState> getYearDisplayStates() {
        ArrayList<YearDisplayState> yearDisplayStates = new ArrayList<YearDisplayState>();
        Enumeration<Integer> keys = this.yearDisplayStateMap.keys();
        while (keys.hasMoreElements()) {
            Integer key = keys.nextElement();
            YearDisplayState yearDisplayState = this.yearDisplayStateMap.get(key);
            if (!yearDisplayState.getActive()) continue;
            yearDisplayStates.add(yearDisplayState);
        }
        return yearDisplayStates;
    }

    @Override
    protected List getCursorReadoutInner(EarthLocation el, Real animationValue, int animationStep, List<ReadoutInfo> samples) throws Exception {
        Object[] pair;
        Object ob = null;
        ArrayList<String> result = new ArrayList<String>();
        List<StormDisplayState> theStormStates = this.getStormDisplayStates();
        if (theStormStates != null && (pair = this.findClosestPoint(el, theStormStates, animationValue, 20)) != null) {
            StormTrack closestTrack = (StormTrack)pair[0];
            StormTrackPoint closestOb = (StormTrackPoint)pair[1];
            result.add("<tr><td>Way: " + closestTrack.getWay() + "</td></tr> " + this.formatStormTrackPoint(closestTrack, closestOb));
        }
        return result;
    }

    protected String formatStormTrackPoint(StormTrack stormTrack, StormTrackPoint stp) throws VisADException, RemoteException {
        Unit displayUnit = this.getDisplayUnit();
        if (stp == null) {
            return "";
        }
        List<StormParam> params = stormTrack.getParams();
        String result = "<tr><td>Track Point Time:</td><td align=right>" + stp.getTime() + "</td></tr>";
        for (StormParam param : params) {
            Real r = stp.getAttribute(param);
            if (r == null) continue;
            Unit unit = param.getUnit();
            result = result + "<tr><td>" + param.toString() + ":</td><td align=right>" + Misc.format(r.getValue()) + (unit != null ? "[" + unit + "]" : "") + "</td></tr>";
        }
        int length = result.length();
        return StringUtil.padLeft(result, 5 * (20 - length), "&nbsp;");
    }

    protected Object[] findClosestPoint(EarthLocation el, List<StormDisplayState> theStates, Real animationValue, int distanceThresholdPixels) throws Exception {
        if (el == null || theStates == null) {
            return null;
        }
        int numStates = theStates.size();
        StormTrackPoint closestOb = null;
        StormTrack closestTrack = null;
        int[] clickPt = this.boxToScreen(this.earthToBox(el));
        double minDistance = distanceThresholdPixels;
        for (int i = 0; i < numStates; ++i) {
            StormTrackCollection trackCollection;
            StormDisplayState sds = theStates.get(i);
            if (sds == null || (trackCollection = sds.getTrackCollection()) == null) continue;
            StormInfo sinfo = sds.getStormInfo();
            HashMap<Way, List> wayToTracksMap = trackCollection.getWayToTracksHashMap();
            java.util.Set<Way> ways = wayToTracksMap.keySet();
            for (Way way : ways) {
                StormTrack track = null;
                if (way.equals(Way.OBSERVATION)) {
                    List tracks = wayToTracksMap.get(way);
                    if (tracks.size() > 0) {
                        track = (StormTrack)tracks.get(0);
                    }
                } else {
                    WayDisplayState trackWDS = sds.getWayDisplayState(way);
                    boolean visible = this.checkTracksVisible(animationValue, trackWDS);
                    if (visible) {
                        List tracks = wayToTracksMap.get(way);
                        track = this.getClosestTimeForecastTrack(tracks, animationValue);
                    }
                }
                if (track == null) continue;
                List<StormTrackPoint> stpList = track.getTrackPoints();
                int size = stpList.size();
                for (int j = 0; j < size; ++j) {
                    StormTrackPoint stp = stpList.get(j);
                    EarthLocation stpLoc = stp.getLocation();
                    int[] obScreen = this.boxToScreen(this.earthToBox(stpLoc));
                    double distance = GuiUtils.distance(obScreen, clickPt);
                    if (!(distance < minDistance)) continue;
                    closestOb = stp;
                    minDistance = distance;
                    closestTrack = track;
                }
            }
        }
        if (closestOb != null) {
            return new Object[]{closestTrack, closestOb};
        }
        return null;
    }

    private boolean checkTracksVisible(Real currentAnimationTime, WayDisplayState wds) throws Exception {
        if (currentAnimationTime == null || currentAnimationTime.isMissing()) {
            return false;
        }
        boolean visible = false;
        if (wds.shouldShowTrack() && wds.hasTrackDisplay()) {
            FieldImpl field = (FieldImpl)wds.getTrackDisplay().getData();
            if (field == null) {
                return false;
            }
            Set timeSet = GridUtil.getTimeSet(field);
            if (timeSet == null) {
                return false;
            }
            if (timeSet.getLength() == 1) {
                return true;
            }
            float timeValueFloat = (float)currentAnimationTime.getValue(timeSet.getSetUnits()[0]);
            float[][] value = new float[][]{{timeValueFloat}};
            int[] index = timeSet.valueToIndex(value);
            visible = index[0] >= 0;
            return visible;
        }
        return visible;
    }

    private StormTrack getClosestTimeForecastTrack(List<StormTrack> tracks, Real pTime) throws VisADException {
        DateTime dt = new DateTime(pTime);
        double timeToLookFor = dt.getValue();
        int numPoints = tracks.size();
        double lastTime = -1.0;
        for (int i = 0; i < numPoints; ++i) {
            StormTrack st = tracks.get(i);
            double currentTime = st.getStartTime().getValue();
            if (timeToLookFor == currentTime) {
                return st;
            }
            if (timeToLookFor < currentTime) {
                if (i == 0) {
                    return null;
                }
                if (timeToLookFor > lastTime) {
                    return tracks.get(i - 1);
                }
            }
            lastTime = currentTime;
        }
        return null;
    }

    public void setOkWays(Hashtable<String, Boolean> value) {
        this.okWays = value;
    }

    public void setObservationWay(Way value) {
        this.observationWay = value;
    }

    public Hashtable<String, Boolean> getOkWays() {
        return this.okWays;
    }

    public Way getObservationWay() {
        return this.observationWay;
    }

    public void setOkParams(Hashtable<String, Boolean> value) {
        this.okParams = value;
    }

    public Hashtable<String, Boolean> getOkParams() {
        return this.okParams;
    }

    public void setStartTime(String value) {
        this.startTime = value;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public void setEndTime(String value) {
        this.endTime = value;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public void setLocalStormDisplayState(StormDisplayState value) {
        this.localStormDisplayState = value;
    }

    public StormDisplayState getLocalStormDisplayState() {
        return this.localStormDisplayState;
    }

    public void setYearTimeMode(int value) {
        this.yearTimeMode = value;
    }

    public int getYearTimeMode() {
        return this.yearTimeMode;
    }

    public void setEditMode(boolean value) {
        this.editMode = value;
    }

    public boolean getEditMode() {
        return this.editMode;
    }

    @Override
    protected void applyRange() throws VisADException, RemoteException {
        for (StormDisplayState sds : this.getActiveStorms()) {
            sds.colorRangeChanged();
        }
    }
}

