/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control.storm;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import ucar.unidata.data.storm.StormDataSource;
import ucar.unidata.data.storm.StormParam;
import ucar.unidata.data.storm.StormTrack;
import ucar.unidata.data.storm.StormTrackPoint;
import ucar.unidata.data.storm.Way;
import ucar.unidata.idv.control.chart.LineState;
import ucar.unidata.idv.control.chart.TimeSeriesChart;
import ucar.unidata.idv.control.storm.StormDisplayState;
import ucar.unidata.idv.control.storm.StormTrackControl;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.Misc;
import ucar.unidata.util.Range;
import ucar.unidata.util.TwoFacedObject;
import visad.DateTime;
import visad.Real;
import visad.RealType;
import visad.Unit;

public class StormTrackChart {
    public static final int MODE_FORECASTTIME = 0;
    public static final int MODE_FORECASTHOUR = 1;
    private StormDisplayState stormDisplayState;
    private int mode;
    private TimeSeriesChart timeSeries;
    private JPanel chartLeft;
    private JPanel chartTop;
    private boolean madeChart = false;
    private List<DateTime> forecastTimes;
    private List<Integer> forecastHours;
    private List<StormParam> chartParams = new ArrayList<StormParam>();
    private List<Way> chartWays = new ArrayList<Way>();
    private boolean chartDifference = false;
    private JList chartTimeBox;
    private boolean ignoreChartTimeChanges = false;
    private JComponent contents;
    private String name;

    public StormTrackChart() {
    }

    public StormTrackChart(StormDisplayState stormDisplayState, String name) {
        this(stormDisplayState, name, 0);
    }

    public StormTrackChart(StormDisplayState stormDisplayState, String name, int mode) {
        this.stormDisplayState = stormDisplayState;
        this.name = name;
        this.mode = mode;
    }

    protected boolean isHourly() {
        return this.mode == 1;
    }

    public void deactivate() {
        this.madeChart = false;
        this.contents = null;
    }

    protected JComponent getContents() {
        if (this.contents == null) {
            this.contents = this.doMakeContents();
        }
        return this.contents;
    }

    private JComponent doMakeContents() {
        this.chartTop = new JPanel(new BorderLayout());
        this.chartLeft = new JPanel(new BorderLayout());
        JPanel chartComp = GuiUtils.leftCenter(this.chartLeft, GuiUtils.topCenter(this.chartTop, this.getChart().getContents()));
        return chartComp;
    }

    public TimeSeriesChart getChart() {
        if (this.timeSeries == null) {
            this.timeSeries = new TimeSeriesChart(this.stormDisplayState.getStormTrackControl(), "Track Charts"){

                @Override
                protected void makeInitialChart() {
                }
            };
            this.timeSeries.showAnimationTime(true);
            this.timeSeries.setDateFormat("MM/dd HH:mm z");
        }
        return this.timeSeries;
    }

    protected void timeChanged(Real time) {
        this.getChart().timeChanged();
    }

    private List<DateTime> findForecastTimes() {
        ArrayList<DateTime> forecastTimes = new ArrayList<DateTime>();
        Hashtable<DateTime, DateTime> seenForecastTime = new Hashtable<DateTime, DateTime>();
        for (StormTrack track : this.stormDisplayState.getTrackCollection().getTracks()) {
            DateTime dttm;
            if (track.getWay().isObservation() || !this.chartWays.contains(track.getWay()) || seenForecastTime.get(dttm = track.getStartTime()) != null) continue;
            seenForecastTime.put(dttm, dttm);
            forecastTimes.add(dttm);
        }
        return Misc.sort(forecastTimes);
    }

    private List<Integer> findForecastHours() {
        ArrayList<Integer> forecastHours = new ArrayList<Integer>();
        Hashtable<Integer, Integer> seenForecastHour = new Hashtable<Integer, Integer>();
        Hashtable seen = new Hashtable();
        for (StormTrack track : this.stormDisplayState.getTrackCollection().getTracks()) {
            if (track.getWay().isObservation() || !this.chartWays.contains(track.getWay())) continue;
            for (StormTrackPoint stormTrackPoint : track.getTrackPoints()) {
                Integer forecastHour = new Integer(stormTrackPoint.getForecastHour());
                if (seenForecastHour.get(forecastHour) != null) continue;
                seenForecastHour.put(forecastHour, forecastHour);
                forecastHours.add(forecastHour);
            }
        }
        return Misc.sort(forecastHours);
    }

    protected void createChart() {
        Object cbx;
        if (this.madeChart) {
            return;
        }
        this.madeChart = true;
        final JCheckBox chartDiffCbx = new JCheckBox("Use Difference", this.chartDifference);
        chartDiffCbx.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                StormTrackChart.this.chartDifference = chartDiffCbx.isSelected();
                StormTrackChart.this.updateChart();
            }
        });
        this.chartTimeBox = new JList();
        this.chartTimeBox.setVisibleRowCount(3);
        this.chartTimeBox.setSelectionMode(2);
        this.chartTimeBox.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (StormTrackChart.this.ignoreChartTimeChanges) {
                    return;
                }
                StormTrackChart.this.updateChart();
            }
        });
        List params = this.getStormTrackParams();
        Insets inset = new Insets(3, 7, 7, 0);
        ArrayList<JComponent> chartComps = new ArrayList<JComponent>();
        List ways = Misc.sort(this.stormDisplayState.getTrackCollection().getWayList());
        ArrayList<JCheckBox> wayComps = new ArrayList<JCheckBox>();
        Iterator iterator = ways.iterator();
        while (iterator.hasNext()) {
            Way way;
            Way theWay = way = (Way)iterator.next();
            if (way.isObservation() && !this.chartWays.contains(way)) {
                this.chartWays.add(way);
            }
            cbx = new JCheckBox(way.toString(), this.chartWays.contains(theWay));
            ((AbstractButton)cbx).addActionListener(new ActionListener((JCheckBox)cbx, theWay){
                final /* synthetic */ JCheckBox val$cbx;
                final /* synthetic */ Way val$theWay;
                {
                    this.val$cbx = jCheckBox;
                    this.val$theWay = way;
                }

                @Override
                public void actionPerformed(ActionEvent ae) {
                    if (this.val$cbx.isSelected()) {
                        StormTrackChart.this.addChartWay(this.val$theWay);
                    } else {
                        StormTrackChart.this.removeChartWay(this.val$theWay);
                    }
                }
            });
            if (!way.isObservation()) {
                wayComps.add((JCheckBox)cbx);
                continue;
            }
            wayComps.add(0, (JCheckBox)cbx);
        }
        chartComps.add(new JLabel(this.stormDisplayState.getStormTrackControl().getWaysName() + ":"));
        JComponent chartWayComp = GuiUtils.vbox(wayComps);
        if (wayComps.size() > 6) {
            chartWayComp = this.makeScroller(chartWayComp, 100, 150);
        }
        chartComps.add(GuiUtils.inset((Component)chartWayComp, inset));
        chartComps.add(GuiUtils.lLabel(this.isHourly() ? "Forecast Hour:" : "Forecast Time:"));
        JScrollPane sp = new JScrollPane(this.chartTimeBox);
        chartComps.add(GuiUtils.inset((Component)sp, inset));
        ArrayList<JCheckBox> paramComps = new ArrayList<JCheckBox>();
        cbx = params.iterator();
        while (cbx.hasNext()) {
            StormParam param;
            final StormParam theParam = param = (StormParam)cbx.next();
            boolean useChartParam = this.chartParams.contains(theParam);
            final JCheckBox cbx2 = new JCheckBox(param.toString(), useChartParam);
            cbx2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    if (cbx2.isSelected()) {
                        StormTrackChart.this.addChartParam(theParam);
                    } else {
                        StormTrackChart.this.removeChartParam(theParam);
                    }
                }
            });
            paramComps.add(cbx2);
        }
        chartComps.add(new JLabel("Parameters:"));
        JComponent paramComp = GuiUtils.vbox(paramComps);
        if (paramComps.size() > 6) {
            paramComp = this.makeScroller(paramComp, 100, 150);
        }
        chartComps.add(GuiUtils.inset((Component)paramComp, inset));
        chartComps.add(chartDiffCbx);
        JButton removeBtn = GuiUtils.makeButton("Remove Chart", this, "removeChart");
        chartComps.add(GuiUtils.filler(5, 10));
        chartComps.add(removeBtn);
        JPanel left = GuiUtils.doLayout(chartComps, 1, GuiUtils.WT_N, new double[]{0.0, 1.0, 0.0, 1.0, 0.0});
        this.chartLeft.add("Center", GuiUtils.inset((Component)left, 5));
        this.chartLeft.invalidate();
        this.chartLeft.validate();
        this.chartLeft.repaint();
    }

    protected List getStormTrackParams() {
        List<StormParam> params = this.stormDisplayState.getStormChartParams();
        if (params == null || params.size() == 0) {
            StormTrack obsTrack;
            for (StormTrack track : this.stormDisplayState.getTrackCollection().getTracks()) {
                if (track == null || track.isObservation()) continue;
                params = track.getParams();
                break;
            }
            if (params.size() == 0 && (obsTrack = this.stormDisplayState.getTrackCollection().getObsTrack()) != null) {
                params = obsTrack.getParams();
            }
        }
        return params;
    }

    public void removeChart() {
        if (GuiUtils.askOkCancel("Remove Chart", "Do you want to remove this chart?")) {
            this.stormDisplayState.removeChart(this);
        }
    }

    JScrollPane makeScroller(JComponent comp, int width, int height) {
        JScrollPane scroller = GuiUtils.makeScrollPane(comp, width, height);
        scroller.setBorder(BorderFactory.createLoweredBevelBorder());
        scroller.setPreferredSize(new Dimension(width, height));
        scroller.setMinimumSize(new Dimension(width, height));
        return scroller;
    }

    protected LineState makeLine(StormTrack stormTrack, StormParam param) {
        ArrayList<Real> values = new ArrayList<Real>();
        List<DateTime> times = stormTrack.getTrackTimes();
        List<StormTrackPoint> trackPoints = stormTrack.getTrackPoints();
        double min = 0.0;
        double max = 0.0;
        Unit unit = null;
        for (int pointIdx = 0; pointIdx < times.size(); ++pointIdx) {
            Real value = trackPoints.get(pointIdx).getAttribute(param);
            if (value == null) continue;
            if (unit == null) {
                unit = ((RealType)value.getType()).getDefaultUnit();
            }
            values.add(value);
            double dvalue = value.getValue();
            if (pointIdx == 0 || dvalue > max) {
                max = dvalue;
            }
            if (pointIdx != 0 && !(dvalue < min)) continue;
            min = dvalue;
        }
        if (values.size() == 0) {
            return null;
        }
        String paramLabel = param.toString();
        String label = stormTrack.getWay().toString();
        LineState lineState = new LineState();
        lineState.setRangeIncludesZero(true);
        if (stormTrack.getWay().isObservation()) {
            lineState.setWidth(2.0f);
        } else {
            lineState.setWidth(1.0f);
        }
        lineState.setRange(new Range(min, max));
        lineState.setChartName(paramLabel);
        lineState.setAxisLabel("[" + unit + "]");
        if (Misc.equals(param, StormDataSource.PARAM_STORMCATEGORY)) {
            lineState.setLineType(6);
            lineState.setLineType(4);
        } else {
            lineState.setLineType(3);
            lineState.setShape(4);
        }
        lineState.setColor(this.stormDisplayState.getWayDisplayState(stormTrack.getWay()).getColor());
        lineState.setName(label);
        lineState.setTrack(times, values);
        return lineState;
    }

    private void removeChartParam(StormParam param) {
        while (this.chartParams.contains(param)) {
            this.chartParams.remove(param);
        }
        this.updateChart();
    }

    private void addChartParam(StormParam param) {
        if (!this.chartParams.contains(param)) {
            this.chartParams.add(param);
        }
        this.updateChart();
    }

    private void removeChartWay(Way way) {
        while (this.chartWays.contains(way)) {
            this.chartWays.remove(way);
        }
        this.updateChart();
    }

    private void addChartWay(Way way) {
        if (!this.chartWays.contains(way)) {
            this.chartWays.add(way);
        }
        this.updateChart();
    }

    private void getSelectedTimes() {
        if (this.isHourly()) {
            Object[] selects = this.chartTimeBox.getSelectedValues();
            if (this.forecastHours == null) {
                this.forecastHours = new ArrayList<Integer>();
            }
            for (int i = 0; i < selects.length; ++i) {
                Object select = selects[i];
                TwoFacedObject tfo = (TwoFacedObject)select;
                Integer hour = (Integer)tfo.getId();
                this.forecastHours.add(hour);
            }
        } else {
            this.forecastTimes = Misc.toList(this.chartTimeBox.getSelectedValues());
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void updateChart() {
        try {
            List tracksFromWay;
            if (!this.madeChart) {
                this.createChart();
            }
            this.ignoreChartTimeChanges = true;
            if (this.isHourly()) {
                List<Integer> fHours = this.findForecastHours();
                ArrayList<TwoFacedObject> tfos = new ArrayList<TwoFacedObject>();
                for (Integer n : fHours) {
                    tfos.add(new TwoFacedObject((Object)(n + "H"), n));
                }
                Object[] objectArray = this.chartTimeBox.getSelectedValues();
                this.chartTimeBox.setListData(new Vector(tfos));
                GuiUtils.setSelectedItems(this.chartTimeBox, Misc.toList(objectArray));
                if (objectArray == null && tfos.size() > 0) {
                    TwoFacedObject twoFacedObject = (TwoFacedObject)tfos.get(0);
                    this.forecastHours.add((Integer)twoFacedObject.getId());
                }
            } else {
                List<DateTime> fTimes = this.findForecastTimes();
                Object[] selected = this.chartTimeBox.getSelectedValues();
                this.chartTimeBox.setListData(new Vector<DateTime>(fTimes));
                GuiUtils.setSelectedItems(this.chartTimeBox, Misc.toList(selected));
                if (selected == null && fTimes.size() > 0) {
                    DateTime dateTime = fTimes.get(0);
                    this.forecastTimes.add(dateTime);
                }
            }
            this.ignoreChartTimeChanges = false;
            this.getSelectedTimes();
            this.chartTimeBox.repaint();
            Hashtable wayToTracks = new Hashtable();
            for (Way way : this.chartWays) {
                wayToTracks.put(way, new ArrayList());
            }
            ArrayList<StormTrack> tracksToUse = new ArrayList<StormTrack>();
            for (StormTrack stormTrack : this.stormDisplayState.getTrackCollection().getTracks()) {
                List trackList = (List)wayToTracks.get(stormTrack.getWay());
                if (trackList == null) continue;
                if (stormTrack.getWay().isObservation()) {
                    tracksToUse.add(stormTrack);
                    continue;
                }
                trackList.add(stormTrack);
            }
            StormTrack stormTrack = this.stormDisplayState.getTrackCollection().getObsTrack();
            if (this.isHourly()) {
                for (Way way : this.chartWays) {
                    tracksFromWay = (List)wayToTracks.get(way);
                    for (Integer fHour : this.forecastHours) {
                        Object points = new ArrayList();
                        for (StormTrack track : tracksFromWay) {
                            StormTrackPoint stp = track.findPointWithForecastHour(fHour);
                            if (stp == null) continue;
                            points.add(stp);
                        }
                        if (points.size() <= 0) continue;
                        points = Misc.sort((Collection)points);
                        tracksToUse.add(new StormTrack(this.stormDisplayState.getStormInfo(), way, (List<StormTrackPoint>)points, null));
                    }
                }
            } else {
                for (Way way : this.chartWays) {
                    tracksFromWay = (List)wayToTracks.get(way);
                    for (StormTrack track : tracksFromWay) {
                        for (DateTime dateTime : this.forecastTimes) {
                            if (!Misc.equals(dateTime, track.getStartTime())) continue;
                            tracksToUse.add(track);
                        }
                    }
                }
            }
            ArrayList<LineState> arrayList = new ArrayList<LineState>();
            for (StormParam param : this.chartParams) {
                Hashtable<Way, String> seenWays = new Hashtable<Way, String>();
                ArrayList<LineState> linesForParam = new ArrayList<LineState>();
                for (StormTrack stormTrack2 : tracksToUse) {
                    void var10_35;
                    LineState lineState = null;
                    if (this.chartDifference && param.getCanDoDifference()) {
                        if (stormTrack2.getWay().isObservation()) continue;
                        StormTrack stormTrack3 = StormDataSource.difference(stormTrack, stormTrack2, param);
                        if (stormTrack3 != null) {
                            lineState = this.makeLine(stormTrack3, param);
                        }
                    } else {
                        lineState = this.makeLine(stormTrack2, param);
                    }
                    if (lineState == null || lineState.getRange().getMin() != lineState.getRange().getMin()) continue;
                    if (seenWays.get(var10_35.getWay()) != null) {
                        lineState.setVisibleInLegend(false);
                    } else {
                        seenWays.put(var10_35.getWay(), "");
                    }
                    linesForParam.add(lineState);
                }
                double max = Double.NEGATIVE_INFINITY;
                double min = Double.POSITIVE_INFINITY;
                for (LineState lineState : linesForParam) {
                    Range r = lineState.getRange();
                    min = Math.min(min, r.getMin());
                    max = Math.max(max, r.getMax());
                }
                boolean first = true;
                for (LineState lineState : linesForParam) {
                    lineState.setAxisVisible(first);
                    first = false;
                    lineState.setRange(new Range(min, max));
                }
                arrayList.addAll(linesForParam);
            }
            this.getChart().setTracks(arrayList);
        }
        catch (Exception exc) {
            this.stormDisplayState.getStormTrackControl();
            StormTrackControl.logException("Updating chart", exc);
        }
    }

    public void setChartParams(List<StormParam> value) {
        this.chartParams = value;
    }

    public List<StormParam> getChartParams() {
        return this.chartParams;
    }

    public void setChartWays(List<Way> value) {
        this.chartWays = value;
    }

    public List<Way> getChartWays() {
        return this.chartWays;
    }

    public void setForecastTime(DateTime value) {
        this.forecastTimes = Misc.newList(value);
    }

    public void setForecastTimes(List<DateTime> value) {
        this.forecastTimes = value;
    }

    public List<DateTime> getForecastTimes() {
        return this.forecastTimes;
    }

    public void setChartDifference(boolean value) {
        this.chartDifference = value;
    }

    public boolean getChartDifference() {
        return this.chartDifference;
    }

    public void setName(String value) {
        this.name = value;
    }

    public String getName() {
        return this.name;
    }

    public void setStormDisplayState(StormDisplayState value) {
        this.stormDisplayState = value;
    }

    public StormDisplayState getStormDisplayState() {
        return this.stormDisplayState;
    }

    public void setMode(int value) {
        this.mode = value;
    }

    public int getMode() {
        return this.mode;
    }

    public void setForecastHour(int value) {
        this.forecastHours = Misc.newList(new Integer(value));
    }

    public void setForecastHours(List<Integer> value) {
        this.forecastHours = value;
    }

    public List<Integer> getForecastHours() {
        return this.forecastHours;
    }
}

