/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control.storm;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.JTableHeader;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.w3c.dom.Element;
import ucar.unidata.data.gis.KmlUtil;
import ucar.unidata.data.storm.StormInfo;
import ucar.unidata.data.storm.StormParam;
import ucar.unidata.data.storm.StormTrack;
import ucar.unidata.data.storm.StormTrackCollection;
import ucar.unidata.data.storm.StormTrackPoint;
import ucar.unidata.data.storm.Way;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.idv.control.ColorTableWidget;
import ucar.unidata.idv.control.LayoutModelWidget;
import ucar.unidata.idv.control.storm.DisplayState;
import ucar.unidata.idv.control.storm.StormTrackChart;
import ucar.unidata.idv.control.storm.StormTrackControl;
import ucar.unidata.idv.control.storm.StormTrackTableModel;
import ucar.unidata.idv.control.storm.WayDisplayState;
import ucar.unidata.idv.flythrough.FlythroughPoint;
import ucar.unidata.ui.Command;
import ucar.unidata.ui.CommandManager;
import ucar.unidata.ui.TableSorter;
import ucar.unidata.ui.TreePanel;
import ucar.unidata.ui.colortable.ColorTableCanvas;
import ucar.unidata.ui.symbol.ShapeSymbol;
import ucar.unidata.ui.symbol.StationModel;
import ucar.unidata.ui.symbol.StationModelManager;
import ucar.unidata.util.ColorTable;
import ucar.unidata.util.DateUtil;
import ucar.unidata.util.FileManager;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.PatternFileFilter;
import ucar.unidata.util.Range;
import ucar.visad.Util;
import ucar.visad.display.Animation;
import ucar.visad.display.CompositeDisplayable;
import ucar.visad.display.DisplayMaster;
import ucar.visad.display.Displayable;
import ucar.visad.display.DisplayableData;
import ucar.visad.display.LineDrawing;
import visad.CommonUnit;
import visad.Data;
import visad.DisplayEvent;
import visad.Real;
import visad.RealType;
import visad.Set;
import visad.Unit;
import visad.VisADException;
import visad.georef.EarthLocation;
import visad.georef.EarthLocationLite;
import visad.georef.LatLonPoint;

public class StormDisplayState {
    public static final String PROP_TRACK_TABLE = "prop.track.table";
    private static String ID_OBS_CONE = "id.obs.cone";
    private static String ID_OBS_RINGS = "id.obs.rings";
    private static String ID_OBS_LAYOUTMODEL = "id.obs.layoutmodel";
    private static String ID_FORECAST_CONE = "id.forecast.cone";
    private static String ID_FORECAST_RINGS = "id.forecast.rings";
    private static String ID_FORECAST_COLOR = "id.forecast.color";
    private static String ID_FORECAST_LAYOUTMODEL = "id.forecast.layoutmodel";
    private static String ID_OBS_COLOR = "id.obs.color";
    private static Color[] colors = new Color[]{Color.RED, Color.PINK, Color.MAGENTA, Color.ORANGE, Color.YELLOW, Color.GREEN, Color.BLUE, Color.CYAN, Color.GRAY, Color.LIGHT_GRAY};
    private boolean hasBeenEdited = false;
    private boolean colorRangeChanged = false;
    private static int[] nextColor = new int[]{0};
    private JLabel obsColorTableLabel;
    private JLabel forecastColorTableLabel;
    private List<StormTrackChart> charts = new ArrayList<StormTrackChart>();
    private List<StormTrackTableModel> tableModels = new ArrayList<StormTrackTableModel>();
    private TreePanel tableTreePanel;
    private Object MUTEX = new Object();
    private static final Data DUMMY_DATA = new Real(0.0);
    private CompositeDisplayable holder;
    private boolean isOnlyChild = false;
    private StormInfo stormInfo;
    private WayDisplayState forecastState;
    private boolean haveLoadedForecasts = false;
    private boolean changed = false;
    private boolean active = false;
    private StormTrackCollection trackCollection;
    private StormTrackControl stormTrackControl;
    private WayDisplayState obsDisplayState;
    private String obsLayoutModelName = "Storm>Hurricane";
    private String obsPointLayoutModelName = "Storm>Forecast Hour";
    private String forecastLayoutModelName = "Storm>Forecast Hour";
    private DisplayableData timesHolder = null;
    private JComponent mainContents;
    private JTabbedPane tabbedPane;
    private JComponent originalContents;
    private Hashtable params = new Hashtable();
    private static final int FORECAST_TIME_MODE = 0;
    private int forecastAnimationMode = 0;
    private JComboBox timeModeBox;
    private Hashtable<Way, WayDisplayState> wayDisplayStateMap = new Hashtable();
    private CommandManager commandManager;
    private int wayCnt = -1;
    private StormTrack editedStormTrack;
    private StormTrackPoint editedStormTrackPoint;
    static int xcnt = 0;
    public static final PatternFileFilter FILTER_DAT = new PatternFileFilter(".+\\.dat", "Diamond Format (*.dat)", ".dat");
    JCheckBox obsCbx = new JCheckBox("Observation", true);
    JCheckBox forecastCbx = new JCheckBox("Forecast", true);
    JCheckBox mostRecentCbx = new JCheckBox("Most Recent Forecasts", false);
    JCheckBox editedCbx = new JCheckBox("Edited Tracks", false);

    public StormDisplayState() {
    }

    public StormDisplayState(StormInfo stormInfo) throws Exception {
        this.stormInfo = stormInfo;
        this.forecastState = new WayDisplayState(this, new Way("forecaststate"));
        this.forecastState.getWayState().setVisible(true);
        this.forecastState.getConeState().setVisible(true);
        this.forecastState.getTrackState().setVisible(true);
        this.forecastState.getRingsState().setVisible(true);
    }

    private CommandManager getCommandManager() {
        if (this.commandManager == null) {
            this.commandManager = new CommandManager(100);
        }
        return this.commandManager;
    }

    private void checkVisibility() {
        List<WayDisplayState> wayDisplayStates = this.getWayDisplayStates();
        Color bgcolor = Color.lightGray;
        boolean rowOk = this.forecastState.getWayState().getVisible();
        this.forecastState.getRingsState().setBackground(rowOk ? null : bgcolor);
        this.forecastState.getConeState().setBackground(rowOk ? null : bgcolor);
        this.forecastState.getTrackState().setBackground(rowOk ? null : bgcolor);
        for (WayDisplayState wds : wayDisplayStates) {
            rowOk = wds.getWayState().getVisible();
            if (wds.getWay().isObservation()) {
                wds.getRingsState().setBackground(rowOk ? null : bgcolor);
                wds.getConeState().setBackground(rowOk ? null : bgcolor);
                wds.getTrackState().setBackground(rowOk ? null : bgcolor);
                continue;
            }
            rowOk = rowOk && this.forecastState.getWayState().getVisible();
            wds.getWayState().setBackground(this.forecastState.getWayState().getVisible() ? null : bgcolor);
            wds.getRingsState().setBackground((Color)(rowOk && this.forecastState.getRingsState().getVisible() ? null : bgcolor));
            wds.getConeState().setBackground((Color)(rowOk && this.forecastState.getConeState().getVisible() ? null : bgcolor));
            wds.getTrackState().setBackground((Color)(rowOk && this.forecastState.getTrackState().getVisible() ? null : bgcolor));
        }
    }

    public void colorTableChanged() {
        try {
            this.updateDisplays();
        }
        catch (Exception exc) {
            StormTrackControl.logException("Changing color table", exc);
        }
    }

    public void handleEvent(DisplayEvent event) throws Exception {
        int id = event.getId();
        InputEvent inputEvent = event.getInputEvent();
        if (inputEvent instanceof KeyEvent) {
            KeyEvent keyEvent = (KeyEvent)inputEvent;
            if (keyEvent.getKeyCode() == 90 && keyEvent.isControlDown()) {
                this.getCommandManager().undo();
                return;
            }
            if (keyEvent.getKeyCode() == 89 && keyEvent.isControlDown()) {
                this.getCommandManager().redo();
                return;
            }
        }
        EarthLocation el = this.stormTrackControl.toEarth(event);
        LatLonPoint llp = el.getLatLonPoint();
        if (id == 1) {
            ArrayList<StormDisplayState> me = new ArrayList<StormDisplayState>();
            me.add(this);
            Real animationTime = null;
            Animation animation = this.stormTrackControl.getViewAnimation();
            if (animation != null) {
                animationTime = animation.getAniValue();
            }
            if (animationTime == null) {
                return;
            }
            Object[] tuple = this.stormTrackControl.findClosestPoint(el, me, animationTime, 50);
            if (tuple == null) {
                return;
            }
            this.editedStormTrack = (StormTrack)tuple[0];
            this.editedStormTrackPoint = (StormTrackPoint)tuple[1];
        }
        if (id == 18) {
            if (this.editedStormTrackPoint == null) {
                return;
            }
            this.handleMouseDrag(event, el);
        }
        if (id == 7) {
            this.editedStormTrackPoint = null;
            this.editedStormTrack = null;
        }
    }

    private void handleMouseDrag(DisplayEvent event, EarthLocation newPt) throws Exception {
        List<StormTrackPoint> points = this.editedStormTrack.getTrackPoints();
        ArrayList<StormTrackPoint> originalPoints = new ArrayList<StormTrackPoint>();
        for (StormTrackPoint stp : points) {
            originalPoints.add(new StormTrackPoint(stp));
        }
        int stretchIndex = this.editedStormTrack.indexOf(this.editedStormTrackPoint);
        if (stretchIndex < 0) {
            throw new IllegalStateException("Cannot find track point");
        }
        EarthLocation oldPt = points.get(stretchIndex).getLocation();
        double deltaY = oldPt.getLatitude().getValue(CommonUnit.degree) - newPt.getLatitude().getValue(CommonUnit.degree);
        double deltaX = LatLonPointImpl.lonNormal(oldPt.getLongitude().getValue(CommonUnit.degree)) - LatLonPointImpl.lonNormal(newPt.getLongitude().getValue(CommonUnit.degree));
        if ((event.getModifiers() & 2) != 0) {
            EarthLocation newEl;
            EarthLocation pt;
            int i;
            this.editedStormTrackPoint.setLocation(newPt);
            int startPts = stretchIndex - 1;
            int endPts = points.size() - stretchIndex;
            double percent = 1.0;
            for (i = stretchIndex - 1; i >= 0 && !((percent -= 1.0 / (double)startPts) <= 0.05); --i) {
                pt = points.get(i).getLocation();
                newEl = this.makePoint(pt.getLatitude().getValue(CommonUnit.degree) - deltaY * percent, LatLonPointImpl.lonNormal(pt.getLongitude().getValue(CommonUnit.degree)) - deltaX * percent);
                points.get(i).setLocation(newEl);
            }
            percent = 1.0;
            for (i = stretchIndex + 1; i < points.size() && !((percent -= 1.0 / (double)endPts) <= 0.05); ++i) {
                pt = points.get(i).getLocation();
                newEl = this.makePoint(pt.getLatitude().getValue(CommonUnit.degree) - deltaY * percent, LatLonPointImpl.lonNormal(pt.getLongitude().getValue(CommonUnit.degree)) - deltaX * percent);
                points.get(i).setLocation(newEl);
            }
        } else if ((event.getModifiers() & 1) != 0) {
            for (StormTrackPoint stp : points) {
                EarthLocation pt = stp.getLocation();
                EarthLocation newEl = this.makePoint(pt.getLatitude().getValue(CommonUnit.degree) - deltaY, LatLonPointImpl.lonNormal(pt.getLongitude().getValue(CommonUnit.degree)) - deltaX);
                stp.setLocation(newEl);
            }
        } else {
            this.editedStormTrackPoint.setLocation(newPt);
        }
        this.getCommandManager().add(new PointEditCommand(this.editedStormTrack, originalPoints, this.editedStormTrack.getTrackPoints()));
        this.updateDisplays(this.editedStormTrack);
    }

    protected EarthLocation makePoint(double latitude, double longitude) throws VisADException, RemoteException {
        Real altReal = new Real(RealType.Altitude, 0.0);
        return new EarthLocationLite(new Real(RealType.Latitude, latitude), new Real(RealType.Longitude, longitude), altReal);
    }

    protected boolean okToShowWay(Way way) {
        if (this.wayCnt == -1) {
            if (this.trackCollection == null) {
                return true;
            }
            List<StormTrack> tracks = this.trackCollection.getTracks();
            Hashtable<Way, String> ways = new Hashtable<Way, String>();
            this.wayCnt = 0;
            for (StormTrack track : tracks) {
                if (ways.get(track.getWay()) != null) continue;
                ++this.wayCnt;
                ways.put(track.getWay(), "");
            }
        }
        if (this.wayCnt <= 1) {
            return true;
        }
        return this.stormTrackControl.okToShowWay(way);
    }

    public LatLonRect getBoundingBox() {
        if (this.trackCollection == null) {
            return null;
        }
        double minLon = Double.POSITIVE_INFINITY;
        double maxLon = Double.NEGATIVE_INFINITY;
        double minLat = Double.POSITIVE_INFINITY;
        double maxLat = Double.NEGATIVE_INFINITY;
        boolean didone = false;
        List<StormTrack> tracks = this.trackCollection.getTracks();
        for (StormTrack track : tracks) {
            LatLonRect bbox;
            if (!this.okToShowWay(track.getWay()) || (bbox = track.getBoundingBox()) == null) continue;
            minLon = Math.min(minLon, bbox.getLonMin());
            maxLon = Math.max(maxLon, bbox.getLonMax());
            minLat = Math.min(minLat, bbox.getLatMin());
            maxLat = Math.max(maxLat, bbox.getLatMax());
            didone = true;
        }
        if (!didone) {
            return null;
        }
        return new LatLonRect(new LatLonPointImpl(maxLat, minLon), new LatLonPointImpl(minLat, maxLon));
    }

    protected void setIsOnlyChild(boolean isOnlyChild) {
        this.isOnlyChild = isOnlyChild;
    }

    public JComponent getContents() {
        if (this.mainContents == null) {
            this.mainContents = this.doMakeContents();
        }
        return this.mainContents;
    }

    protected List<WayDisplayState> getWayDisplayStates() {
        return Misc.toList(this.wayDisplayStateMap.elements());
    }

    protected WayDisplayState getWayDisplayState(Way way) {
        WayDisplayState wayState = this.wayDisplayStateMap.get(way);
        if (wayState == null) {
            wayState = new WayDisplayState(this, way);
            this.wayDisplayStateMap.put(way, wayState);
            if (wayState.getColor() == null) {
                wayState.setColor(StormDisplayState.getNextColor(nextColor));
            }
        }
        return wayState;
    }

    protected void reload() {
        if (!this.active) {
            return;
        }
        this.deactivate();
        this.loadStorm();
    }

    public void loadStorm() {
        if (this.active) {
            return;
        }
        this.active = true;
        this.showStorm();
    }

    protected void reloadChart() {
        for (StormTrackChart stormTrackChart : this.charts) {
            stormTrackChart.updateChart();
        }
    }

    protected StormTrackCollection getTrackCollection() {
        return this.trackCollection;
    }

    public void setObsLayoutModel(StationModel sm) {
        this.obsLayoutModelName = sm == null ? null : sm.getName();
        this.updateLayoutModel(true);
    }

    public void setObsPointLayoutModel(StationModel sm) {
        this.obsPointLayoutModelName = sm == null ? null : sm.getName();
        this.updateLayoutModel(true);
    }

    public void setForecastLayoutModel(StationModel sm) {
        this.forecastLayoutModelName = sm == null ? null : sm.getName();
        this.updateLayoutModel(false);
    }

    protected void handleChangedStationModel(String name) {
        if (Misc.equals(this.obsLayoutModelName, name)) {
            this.updateLayoutModel(true);
        }
        if (Misc.equals(this.forecastLayoutModelName, name)) {
            this.updateLayoutModel(false);
        }
    }

    public void updateLayoutModel(boolean forObs) {
        List<WayDisplayState> wayDisplayStates = this.getWayDisplayStates();
        try {
            for (WayDisplayState wds : wayDisplayStates) {
                if (wds.getWay().isObservation() && !forObs) continue;
                wds.updateLayoutModel();
            }
        }
        catch (Exception exc) {
            StormTrackControl.logException("Updating layout models", exc);
        }
    }

    public void deactivate() {
        try {
            for (StormTrackChart stormTrackChart : this.charts) {
                stormTrackChart.deactivate();
            }
            this.trackCollection = null;
            this.active = false;
            this.colorRangeChanged = false;
            this.stormTrackControl.removeDisplayable(this.holder);
            this.holder = null;
            if (this.mainContents != null) {
                this.mainContents.removeAll();
                this.mainContents.add("North", this.originalContents);
                List<WayDisplayState> wayDisplayStates = this.getWayDisplayStates();
                for (WayDisplayState wayDisplayState : wayDisplayStates) {
                    wayDisplayState.deactivate();
                }
                this.mainContents.repaint(1L);
            }
            this.stormTrackControl.stormChanged(this);
        }
        catch (Exception exc) {
            StormTrackControl.logException("Deactivating storm", exc);
        }
    }

    private JComponent doMakeContents() {
        JButton loadBtn = new JButton("Load Tracks:");
        JLabel topLabel = GuiUtils.cLabel("  " + this.stormInfo);
        loadBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                StormDisplayState.this.loadStorm();
            }
        });
        JPanel top = GuiUtils.hbox(loadBtn, topLabel);
        this.originalContents = GuiUtils.inset((Component)top, 5);
        JPanel contents = GuiUtils.top(this.originalContents);
        int cnt = xcnt++;
        contents = new JPanel(new BorderLayout());
        contents.add("North", this.originalContents);
        return contents;
    }

    public void initDone() {
        if (this.getActive()) {
            this.showStorm();
        }
    }

    public boolean getForecastVisible() {
        return this.forecastState.getWayState().getVisible();
    }

    private JComponent makeList(List stormParams, final Object id) {
        if (stormParams == null || stormParams.size() == 0) {
            return GuiUtils.filler(2, 10);
        }
        final JList list = new JList(new Vector(stormParams));
        list.setVisibleRowCount(3);
        list.setSelectionMode(2);
        list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ArrayList selected = new ArrayList();
                selected.addAll(Misc.toList(list.getSelectedValues()));
                try {
                    StormDisplayState.this.params.put(id, selected);
                    StormDisplayState.this.updateDisplays();
                }
                catch (Exception exc) {
                    StormDisplayState.this.stormTrackControl;
                    StormTrackControl.logException("setting cones", exc);
                }
            }
        });
        list.setToolTipText("<html>Parameter used for cone<br>Control-click for multiple select</html>");
        List selected = (List)this.params.get(id);
        if (selected != null && selected.size() > 0) {
            int[] indices = new int[selected.size()];
            for (int i = 0; i < selected.size(); ++i) {
                indices[i] = stormParams.indexOf(selected.get(i));
            }
            list.setSelectedIndices(indices);
        }
        JScrollPane sp = new JScrollPane(list);
        return sp;
    }

    private JComponent makeBox(List stormParams, final Object id, String tooltip) {
        if (stormParams == null || stormParams.size() == 0) {
            return GuiUtils.filler(2, 10);
        }
        final JComboBox box = new JComboBox(new Vector(stormParams));
        box.setToolTipText(tooltip);
        StormParam stormParam = (StormParam)this.params.get(id);
        if (stormParam != null) {
            box.setSelectedItem(stormParam);
        }
        box.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                Object selected = box.getSelectedItem();
                if (selected == null || selected instanceof String) {
                    StormDisplayState.this.params.remove(id);
                } else {
                    StormDisplayState.this.params.put(id, selected);
                }
                try {
                    StormDisplayState.this.colorRangeChanged = false;
                    StormDisplayState.this.updateDisplays();
                }
                catch (Exception exc) {
                    StormDisplayState.this.stormTrackControl;
                    StormTrackControl.logException("setting cones", exc);
                }
            }
        });
        return box;
    }

    private List<StormParam> getDistanceParams(List<StormParam> params) {
        if (params == null || params.size() == 0) {
            return null;
        }
        ArrayList<StormParam> attrNames = new ArrayList<StormParam>();
        for (StormParam param : params) {
            if (!Unit.canConvert(param.getUnit(), CommonUnit.meter)) continue;
            attrNames.add(param);
        }
        if (attrNames.size() == 0) {
            return null;
        }
        return attrNames;
    }

    StormParam getFixedParam() {
        RealType rtype = RealType.getRealType("Fixed");
        if (rtype == null) {
            try {
                rtype = new RealType("Fixed");
            }
            catch (VisADException visADException) {
                // empty catch block
            }
        }
        return new StormParam(rtype, false, false);
    }

    private void initCenterContents() {
        if (this.mainContents == null) {
            return;
        }
        this.mainContents.removeAll();
        JButton unloadBtn = GuiUtils.makeImageButton("/auxdata/ui/icons/Cut16.gif", this, "deactivate");
        unloadBtn.setToolTipText("Remove this storm");
        String label = "Storm: " + this.stormInfo.toString() + "   " + this.stormInfo.getStartTime().formattedString("yyyy-MM-dd", DateUtil.TIMEZONE_GMT);
        JPanel top = GuiUtils.inset((Component)GuiUtils.leftRight(GuiUtils.lLabel(label), unloadBtn), new Insets(0, 0, 0, 0));
        ArrayList<StormParam> forecastParams = new ArrayList<StormParam>();
        Hashtable<StormParam, StormParam> seenParams = new Hashtable<StormParam, StormParam>();
        ArrayList<StormParam> obsParams = new ArrayList<StormParam>();
        Hashtable seenWays = new Hashtable();
        for (StormTrack track : this.trackCollection.getTracks()) {
            List<StormParam> trackParams = track.getParams();
            if (track.getWay().isObservation()) {
                obsParams.addAll(trackParams);
                continue;
            }
            for (StormParam param : trackParams) {
                if (seenParams.get(param) != null) continue;
                seenParams.put(param, param);
                forecastParams.add(param);
            }
        }
        List<StormParam> forecastRadiusParams = this.getDistanceParams(forecastParams);
        List<StormParam> obsRadiusParams = this.getDistanceParams(obsParams);
        if (obsRadiusParams != null) {
            if (this.params.get(ID_OBS_RINGS) == null) {
                this.params.put(ID_OBS_RINGS, obsRadiusParams.get(0));
            }
            if (this.params.get(ID_OBS_CONE) == null) {
                this.params.put(ID_OBS_CONE, Misc.newList(obsRadiusParams.get(0)));
            }
        }
        if (forecastRadiusParams != null) {
            if (this.params.get(ID_FORECAST_RINGS) == null) {
                this.params.put(ID_FORECAST_RINGS, forecastRadiusParams.get(0));
            }
            if (this.params.get(ID_FORECAST_CONE) == null) {
                this.params.put(ID_FORECAST_CONE, Misc.newList(forecastRadiusParams.get(0)));
            }
        }
        List ways = Misc.sort(this.trackCollection.getWayList());
        boolean haveDoneForecast = false;
        List colLabels = Misc.newList("", "Show", "Track");
        if (forecastRadiusParams != null || obsRadiusParams != null) {
            colLabels.add("Rings");
            colLabels.add("Cone");
        }
        int numCols = colLabels.size();
        ArrayList<StormParam> obsColorParams = new ArrayList<StormParam>(obsParams);
        ArrayList<StormParam> forecastColorParams = new ArrayList<StormParam>(forecastParams);
        obsColorParams.add(0, this.getFixedParam());
        forecastColorParams.add(0, this.getFixedParam());
        LayoutModelWidget obsLayoutComp = new LayoutModelWidget(this.stormTrackControl, (Object)this, "setObsLayoutModel", this.getObsLayoutModel(), true);
        LayoutModelWidget obsPointLayoutComp = new LayoutModelWidget(this.stormTrackControl, (Object)this, "setObsPointLayoutModel", this.getObsPointLayoutModel(), true);
        LayoutModelWidget forecastLayoutComp = new LayoutModelWidget(this.stormTrackControl, (Object)this, "setForecastLayoutModel", this.getForecastLayoutModel(), true);
        JComponent obsColorByBox = this.makeBox(obsColorParams, ID_OBS_COLOR, "Parameter used for coloring observation track");
        JComponent forecastColorByBox = this.makeBox(forecastColorParams, ID_FORECAST_COLOR, "Parameter used for coloring forecast tracks");
        JComponent obsConeComp = obsRadiusParams != null ? this.makeList(obsRadiusParams, ID_OBS_CONE) : (JComponent)GuiUtils.filler();
        JComponent obsRingComp = obsRadiusParams != null ? this.makeBox(obsRadiusParams, ID_OBS_RINGS, "Parameter used for observation rings") : (JComponent)GuiUtils.filler();
        JComponent forecastConeComp = forecastRadiusParams != null ? this.makeList(forecastRadiusParams, ID_FORECAST_CONE) : (JComponent)GuiUtils.filler();
        JComponent forecastRingComp = forecastRadiusParams != null ? this.makeBox(forecastRadiusParams, ID_FORECAST_RINGS, "Parameter used for forecast rings") : (JComponent)GuiUtils.filler();
        ArrayList<JComponent> topComps = new ArrayList<JComponent>();
        this.timeModeBox = new JComboBox(new Vector(Misc.newList("On", "Off")));
        this.timeModeBox.setSelectedIndex(this.forecastAnimationMode);
        this.timeModeBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                StormDisplayState.this.forecastAnimationMode = StormDisplayState.this.timeModeBox.getSelectedIndex();
                try {
                    StormDisplayState.this.updateDisplays();
                }
                catch (Exception exc) {
                    StormDisplayState.this.stormTrackControl;
                    StormTrackControl.logException("change forecast animation mode", exc);
                }
            }
        });
        this.timeModeBox.setToolTipText("Animate tracks or show all tracks.");
        JPanel forecastModeComp = GuiUtils.inset((Component)GuiUtils.left(GuiUtils.label("Animation Mode: ", this.timeModeBox)), 5);
        topComps.add(new JLabel(""));
        topComps.add(GuiUtils.cLabel("<html><u><i>Observation</i></u></html>"));
        topComps.add(GuiUtils.cLabel("<html><u><i>Forecast</i></u></html>"));
        topComps.add(GuiUtils.rLabel("Points:"));
        topComps.add(obsPointLayoutComp);
        topComps.add(forecastLayoutComp);
        topComps.add(GuiUtils.rLabel("Animation:"));
        topComps.add(obsLayoutComp);
        topComps.add(forecastModeComp);
        this.forecastColorTableLabel = new JLabel(" ");
        this.forecastColorTableLabel.setToolTipText("Color table preview");
        this.obsColorTableLabel = new JLabel(" ");
        this.obsColorTableLabel.setToolTipText("Color table preview");
        topComps.add(GuiUtils.rLabel("Color By:"));
        topComps.add(GuiUtils.vbox(obsColorByBox, this.obsColorTableLabel));
        topComps.add(GuiUtils.vbox(forecastColorByBox, this.forecastColorTableLabel));
        if (forecastRadiusParams != null || obsRadiusParams != null) {
            topComps.add(GuiUtils.rLabel("Rings:"));
            topComps.add(obsRingComp);
            topComps.add(forecastRingComp);
            topComps.add(GuiUtils.rLabel("Cone:"));
            topComps.add(obsConeComp);
            topComps.add(forecastConeComp);
        }
        GuiUtils.tmpInsets = new Insets(4, 4, 2, 2);
        JPanel paramComp = GuiUtils.doLayout(topComps, 3, GuiUtils.WT_N, GuiUtils.WT_N);
        ArrayList<Component> comps = new ArrayList<Component>();
        for (Way way : ways) {
            WayDisplayState wds = this.getWayDisplayState(way);
            if (!this.okToShowWay(wds.getWay())) continue;
            JCheckBox jbc = wds.getWayState().getCheckBox();
            if (way.isObservation()) {
                jbc.setSelected(true);
                wds.getWayState().setVisible(true);
            }
            JPanel labelComp = GuiUtils.hbox(jbc, new JLabel(" " + way.toString()));
            JPanel swatch = GuiUtils.wrap(wds.getColorSwatch());
            if (way.isObservation()) {
                int col = 0;
                comps.add(col++, swatch);
                comps.add(col++, labelComp);
                comps.add(col++, GuiUtils.wrap(wds.getTrackState().getCheckBox()));
                if (obsRadiusParams == null) continue;
                comps.add(col++, GuiUtils.wrap(wds.getRingsState().getCheckBox()));
                comps.add(col++, GuiUtils.wrap(wds.getConeState().getCheckBox()));
                continue;
            }
            if (!haveDoneForecast) {
                haveDoneForecast = true;
                for (int colIdx = 0; colIdx < numCols; ++colIdx) {
                    comps.add(GuiUtils.filler());
                }
                comps.add(GuiUtils.filler());
                comps.add(GuiUtils.hbox(this.forecastState.getWayState().getCheckBox(), GuiUtils.lLabel("<html><u><i>Forecasts:</i></u></html>")));
                comps.add(GuiUtils.wrap(this.forecastState.getTrackState().getCheckBox()));
                if (forecastRadiusParams != null) {
                    comps.add(GuiUtils.wrap(this.forecastState.getRingsState().getCheckBox()));
                    comps.add(GuiUtils.wrap(this.forecastState.getConeState().getCheckBox()));
                }
            }
            comps.add(swatch);
            comps.add(labelComp);
            comps.add(GuiUtils.wrap(wds.getTrackState().getCheckBox()));
            if (forecastRadiusParams == null) continue;
            comps.add(GuiUtils.wrap(wds.getRingsState().getCheckBox()));
            comps.add(GuiUtils.wrap(wds.getConeState().getCheckBox()));
        }
        for (int colIdx = 0; colIdx < numCols; ++colIdx) {
            String s = (String)colLabels.get(colIdx);
            if (s.length() > 0) {
                comps.add(colIdx, new JLabel("<html><u><i>" + s + "</i></u></html>"));
                continue;
            }
            comps.add(colIdx, new JLabel(""));
        }
        GuiUtils.tmpInsets = new Insets(2, 2, 0, 2);
        JComponent wayComp = GuiUtils.topLeft(GuiUtils.doLayout(comps, numCols, GuiUtils.WT_N, GuiUtils.WT_N));
        if (ways.size() > 6) {
            int width = 300;
            int height = 200;
            JScrollPane scroller = GuiUtils.makeScrollPane(wayComp, width, height);
            scroller.setBorder(BorderFactory.createLoweredBevelBorder());
            scroller.setPreferredSize(new Dimension(width, height));
            scroller.setMinimumSize(new Dimension(width, height));
            wayComp = scroller;
        }
        wayComp = GuiUtils.left(GuiUtils.doLayout(new Component[]{GuiUtils.left(paramComp), GuiUtils.filler(2, 10), GuiUtils.left(wayComp)}, 1, GuiUtils.WT_N, GuiUtils.WT_NNY));
        wayComp = GuiUtils.inset((Component)wayComp, new Insets(0, 5, 0, 0));
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addTab("Tracks", wayComp);
        this.tabbedPane.addTab("Table", this.getTrackTable());
        if (this.charts.size() == 0) {
            this.charts.add(new StormTrackChart(this, "Storm Chart", 0));
        }
        for (StormTrackChart stormTrackChart : this.charts) {
            this.tabbedPane.addTab(stormTrackChart.getName(), stormTrackChart.getContents());
        }
        JPanel inner = GuiUtils.topCenter(top, this.tabbedPane);
        inner = GuiUtils.inset((Component)inner, 5);
        this.mainContents.add("Center", inner);
        this.mainContents.invalidate();
        this.mainContents.validate();
        this.mainContents.repaint();
        this.checkVisibility();
    }

    protected void timeChanged(Real time) {
        for (StormTrackChart stormTrackChart : this.charts) {
            stormTrackChart.timeChanged(time);
        }
    }

    protected boolean canShowWay(Way way) {
        return this.getWayDisplayState(way).getWayState().getVisible();
    }

    protected void setStormTrackControl(StormTrackControl stormTrackControl) {
        this.stormTrackControl = stormTrackControl;
    }

    protected void showStorm() {
        Misc.run(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                DisplayMaster displayMaster = StormDisplayState.this.stormTrackControl.getDisplayMaster();
                boolean wasActive = displayMaster.ensureInactive();
                try {
                    Object object = StormDisplayState.this.MUTEX;
                    synchronized (object) {
                        StormDisplayState.this.stormTrackControl.showWaitCursor();
                        StormDisplayState.this.showStormInner();
                        StormDisplayState.this.stormTrackControl.stormChanged(StormDisplayState.this);
                    }
                }
                catch (Exception exc) {
                    StormDisplayState.this.stormTrackControl;
                    StormTrackControl.logException("Showing storm", exc);
                }
                finally {
                    StormDisplayState.this.stormTrackControl.showNormalCursor();
                    if (wasActive) {
                        try {
                            displayMaster.setActive(true);
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        });
    }

    protected void addDisplayable(Displayable displayable) throws VisADException, RemoteException {
        if (this.holder != null) {
            this.holder.addDisplayable(displayable);
        }
    }

    protected StormTrackControl getStormTrackControl() {
        return this.stormTrackControl;
    }

    private void showStormInner() throws Exception {
        long t1 = System.currentTimeMillis();
        if (this.trackCollection == null) {
            if (this.mainContents != null) {
                this.mainContents.removeAll();
                this.mainContents.add(GuiUtils.top(GuiUtils.inset((Component)new JLabel("Loading Tracks..."), 5)));
                this.mainContents.invalidate();
                this.mainContents.validate();
                this.mainContents.repaint();
            }
            this.trackCollection = this.stormTrackControl.getStormDataSource().getTrackCollection(this.stormInfo, this.stormTrackControl.getOkWays(), this.stormTrackControl.getObservationWay());
            this.initCenterContents();
            this.holder = new CompositeDisplayable();
            this.stormTrackControl.addDisplayable(this.holder);
            for (StormTrack track : this.trackCollection.getTracks()) {
                WayDisplayState wayDisplayState = this.getWayDisplayState(track.getWay());
                wayDisplayState.addTrack(track);
            }
            this.obsDisplayState = this.getWayDisplayState(Way.OBSERVATION);
            StormTrack obsTrack = this.trackCollection.getObsTrack();
            List<Object> times = new ArrayList();
            if (obsTrack != null) {
                times = obsTrack.getTrackTimes();
            } else {
                for (StormTrack track : this.trackCollection.getTracks()) {
                    times.add(track.getStartTime());
                }
            }
            if (times.size() > 0) {
                times = Misc.sort(Misc.makeUnique(times));
                this.timesHolder = new LineDrawing("track_time" + this.stormInfo.getStormId());
                this.timesHolder.setManipulable(false);
                this.timesHolder.setVisible(false);
                Set timeSet = Util.makeTimeSet(times);
                this.timesHolder.setData(timeSet);
                this.holder.addDisplayable(this.timesHolder);
            }
        }
        this.updateDisplays();
        this.updateCharts();
        long t2 = System.currentTimeMillis();
    }

    protected List<StormParam> getParams(Object id) {
        ArrayList l = (ArrayList)this.params.get(id);
        if (l == null) {
            l = new ArrayList();
            this.params.put(id, l);
        }
        return l;
    }

    protected List<StormParam> getConeParams(WayDisplayState way) {
        if (way.getWay().isObservation()) {
            return this.getParams(ID_OBS_CONE);
        }
        return this.getParams(ID_FORECAST_CONE);
    }

    protected StormParam getRingsParam(WayDisplayState way) {
        if (way.getWay().isObservation()) {
            return (StormParam)this.params.get(ID_OBS_RINGS);
        }
        return (StormParam)this.params.get(ID_FORECAST_RINGS);
    }

    protected StormParam getColorParam(WayDisplayState way) {
        return this.getColorParam(way.getWay().isObservation());
    }

    protected StormParam getColorParam(boolean forObs) {
        if (forObs) {
            StormParam sp = (StormParam)this.params.get(ID_OBS_COLOR);
            if (sp == null) {
                sp = this.getFixedParam();
            }
            return sp;
        }
        return (StormParam)this.params.get(ID_FORECAST_COLOR);
    }

    protected void updateCharts() throws Exception {
        if (this.mainContents == null) {
            return;
        }
        for (StormTrackChart stormTrackChart : this.charts) {
            stormTrackChart.updateChart();
        }
    }

    protected void displayStateChanged(DisplayState displayState) throws Exception {
        this.updateDisplays();
        this.checkVisibility();
    }

    protected void updateDisplays(StormTrack track) throws Exception {
        Way way = track.getWay();
        WayDisplayState wds = this.wayDisplayStateMap.get(way);
        if (wds != null) {
            wds.updateDisplay(true);
            for (StormTrackTableModel trackModel : this.tableModels) {
                if (!trackModel.getStormTrack().equals(track)) continue;
                trackModel.fireTableStructureChanged();
                Component comp = (Component)track.getTemporaryProperty(PROP_TRACK_TABLE);
                track.setIsEdited(true);
                if (comp == null) break;
                this.tableTreePanel.show(comp);
                this.tableTreePanel.showPath(comp);
                break;
            }
        }
    }

    protected void updateDisplays() throws Exception {
        this.updateDisplays(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateDisplays(boolean force) throws Exception {
        ColorTable ct;
        DisplayMaster displayMaster = this.stormTrackControl.getDisplayMaster();
        boolean wasActive = displayMaster.ensureInactive();
        try {
            List<WayDisplayState> wayDisplayStates = this.getWayDisplayStates();
            for (WayDisplayState wds : wayDisplayStates) {
                if (!this.okToShowWay(wds.getWay())) continue;
                wds.updateDisplay(force);
            }
        }
        finally {
            if (wasActive) {
                try {
                    displayMaster.setActive(true);
                }
                catch (Exception wayDisplayStates) {}
            }
        }
        if (this.obsColorTableLabel != null) {
            ct = null;
            ct = this.getColorTable(this.getColorParam(true));
            this.obsColorTableLabel.setIcon(ct != null ? ColorTableCanvas.getIcon(ct) : null);
            this.obsColorTableLabel.setToolTipText(this.getColorTableToolTip(true));
        }
        if (this.forecastColorTableLabel != null) {
            ct = null;
            ct = this.getColorTable(this.getColorParam(false));
            this.forecastColorTableLabel.setIcon(ct != null ? ColorTableCanvas.getIcon(ct) : null);
            this.forecastColorTableLabel.setToolTipText(this.getColorTableToolTip(false));
        }
    }

    protected String getColorTableToolTip(boolean forObs) {
        StormParam param = this.getColorParam(forObs);
        if (param == null) {
            return "Color table preview";
        }
        Range range = this.getStormTrackControl().getIdv().getParamDefaultsEditor().getParamRange(param.getName());
        if (range == null) {
            return "Color table preview";
        }
        Unit displayUnit = this.getStormTrackControl().getIdv().getParamDefaultsEditor().getParamDisplayUnit(param.getName());
        String unit = displayUnit != null ? "[" + displayUnit + "]" : "";
        return "Range: " + range.getMin() + unit + " - " + range.getMax() + unit;
    }

    protected ColorTable getColorTable(StormParam param) {
        if (param == null) {
            return null;
        }
        if (param.getName().equalsIgnoreCase("Fixed")) {
            try {
                this.getStormTrackControl().getColorTableWidget(new Range(1.0, 1.0));
            }
            catch (VisADException visADException) {
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            return null;
        }
        Range range = this.getStormTrackControl().getIdv().getParamDefaultsEditor().getParamRange(param.getName());
        if (range == null) {
            range = new Range(1.0, 100.0);
        }
        ColorTableWidget ctw = null;
        try {
            if (this.colorRangeChanged) {
                range = this.getStormTrackControl().getRangeForColorTable();
            }
            ctw = this.getStormTrackControl().getColorTableWidget(range);
        }
        catch (VisADException visADException) {
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        ColorTable ct = ctw.getColorTable();
        if (ct == null) {
            ct = this.getStormTrackControl().getColorTable();
        }
        return ct;
    }

    protected StationModel getObsLayoutModel() {
        if (this.obsLayoutModelName == null || this.obsLayoutModelName.equals("none")) {
            return null;
        }
        StationModelManager smm = this.stormTrackControl.getControlContext().getStationModelManager();
        return smm.getStationModel(this.obsLayoutModelName);
    }

    protected StationModel getObsPointLayoutModel() {
        if (this.obsPointLayoutModelName == null || this.obsPointLayoutModelName.equals("none")) {
            return null;
        }
        StationModelManager smm = this.stormTrackControl.getControlContext().getStationModelManager();
        return smm.getStationModel(this.obsPointLayoutModelName);
    }

    protected StationModel getForecastLayoutModel() {
        if (this.forecastLayoutModelName == null || this.forecastLayoutModelName.equals("none")) {
            return null;
        }
        StationModelManager smm = this.stormTrackControl.getControlContext().getStationModelManager();
        StationModel sm = smm.getStationModel(this.forecastLayoutModelName);
        if (sm != null) {
            return sm;
        }
        StationModel model = new StationModel("TrackLocation");
        ShapeSymbol shapeSymbol = new ShapeSymbol(0, 0);
        shapeSymbol.setScale(0.3f);
        shapeSymbol.setShape("CIRCLE");
        shapeSymbol.bounds = new Rectangle(-15, -15, 30, 30);
        shapeSymbol.setRectPoint("MM");
        model.addSymbol(shapeSymbol);
        return model;
    }

    protected void removeChart(StormTrackChart stormTrackChart) {
        this.charts.remove(stormTrackChart);
        this.tabbedPane.remove(stormTrackChart.getContents());
    }

    public void addForecastTimeChart() {
        this.addForecastChart(0);
    }

    public void addForecastHourChart() {
        this.addForecastChart(1);
    }

    public void addForecastChart(int mode) {
        String chartName = GuiUtils.getInput("Please enter a chart name", "Chart Name: ", "Storm Chart");
        if (chartName == null) {
            return;
        }
        StormTrackChart stormTrackChart = new StormTrackChart(this, chartName, mode);
        this.charts.add(stormTrackChart);
        this.tabbedPane.addTab(stormTrackChart.getName(), stormTrackChart.getContents());
        stormTrackChart.updateChart();
    }

    public List<StormParam> getStormChartParams() {
        Hashtable<String, Boolean> s1 = this.stormTrackControl.getOkParams();
        List<StormParam> allParams = this.stormTrackControl.getTrackParams();
        ArrayList<StormParam> params = new ArrayList<StormParam>();
        for (StormParam sp : allParams) {
            Boolean v = s1.get(sp.getName());
            if (v == null || !v.booleanValue()) continue;
            params.add(sp);
        }
        return params;
    }

    private JComponent getTrackTable() {
        final Font boldFont = new Font("Dialog", 1, 10);
        final Font plainFont = new Font("Dialog", 0, 10);
        this.tableTreePanel = new TreePanel(true, 150){

            @Override
            public DefaultTreeCellRenderer doMakeTreeCellRenderer() {
                return new DefaultTreeCellRenderer(){

                    @Override
                    public Component getTreeCellRendererComponent(JTree theTree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                        super.getTreeCellRendererComponent(theTree, value, sel, expanded, leaf, row, hasFocus);
                        if (!(value instanceof TreePanel.MyTreeNode)) {
                            return this;
                        }
                        TreePanel.MyTreeNode node = (TreePanel.MyTreeNode)value;
                        StormTrack track = (StormTrack)node.getObject();
                        if (track.getIsEdited()) {
                            this.setFont(boldFont);
                            this.setForeground(Color.red);
                        } else {
                            this.setFont(plainFont);
                            this.setForeground(Color.black);
                        }
                        return this;
                    }
                };
            }
        };
        int width = 400;
        int height = 400;
        Iterator<StormTrack> iterator = this.trackCollection.getTracks().iterator();
        while (iterator.hasNext()) {
            StormTrack track;
            StormTrack theTrack = track = iterator.next();
            StormTrackTableModel tableModel = new StormTrackTableModel(this, track);
            this.tableModels.add(tableModel);
            TableSorter sorter = new TableSorter(tableModel);
            JTable trackTable = new JTable(sorter);
            JTableHeader header = trackTable.getTableHeader();
            header.setToolTipText("Click to sort");
            sorter.setTableHeader(trackTable.getTableHeader());
            JScrollPane scroller = GuiUtils.makeScrollPane(trackTable, width, height);
            scroller.setBorder(BorderFactory.createLoweredBevelBorder());
            JComponent contents = scroller;
            if (!track.getWay().isObservation()) {
                contents = GuiUtils.topCenter(GuiUtils.left(GuiUtils.inset((Component)new JLabel(track.getStartTime().toString()), 5)), contents);
            }
            track.putTemporaryProperty(PROP_TRACK_TABLE, contents);
            JButton flythroughBtn = GuiUtils.makeButton("Fly through", this, "flythroughTrack", track);
            contents = GuiUtils.centerBottom(contents, GuiUtils.right(flythroughBtn));
            this.tableTreePanel.addComponent(contents, track.getWay().toString(), track.getStartTime().toString(), null, track);
        }
        return this.tableTreePanel;
    }

    public void flythroughTrack(StormTrack track) {
        try {
            ArrayList<FlythroughPoint> points = new ArrayList<FlythroughPoint>();
            for (StormTrackPoint stp : track.getTrackPoints()) {
                EarthLocation newLoc = this.makePoint(stp.getLocation().getLatitude().getValue(CommonUnit.degree), stp.getLocation().getLongitude().getValue(CommonUnit.degree));
                points.add(new FlythroughPoint(newLoc, stp.getTime()));
            }
            this.stormTrackControl.getMapViewManager().flythrough(points);
        }
        catch (Exception exc) {
            StormTrackControl.logException("Doing flythrough", exc);
        }
    }

    public void writeToDataFile() {
        try {
            JPanel accessory = GuiUtils.top(GuiUtils.vbox(this.obsCbx, this.forecastCbx, this.mostRecentCbx, this.editedCbx));
            String filename = FileManager.getWriteFile(Misc.newList(FileManager.FILTER_XLS, FILTER_DAT), ".xls", (JComponent)accessory);
            if (filename == null) {
                return;
            }
            ArrayList<StormTrack> tracksToWrite = new ArrayList<StormTrack>();
            List waysToUse = new ArrayList<Way>();
            Hashtable<Way, ArrayList<StormTrack>> trackMap = new Hashtable<Way, ArrayList<StormTrack>>();
            for (StormTrack track : this.trackCollection.getTracks()) {
                ArrayList<StormTrack> tracks = (ArrayList<StormTrack>)trackMap.get(track.getWay());
                if (tracks == null) {
                    tracks = new ArrayList<StormTrack>();
                    trackMap.put(track.getWay(), tracks);
                    waysToUse.add(track.getWay());
                }
                tracks.add(track);
                if (this.editedCbx.isSelected()) {
                    if (!track.getIsEdited()) continue;
                    tracksToWrite.add(track);
                    continue;
                }
                if (track.getWay().isObservation()) {
                    if (!this.obsCbx.isSelected()) continue;
                    tracksToWrite.add(track);
                    continue;
                }
                if (!this.forecastCbx.isSelected()) continue;
                tracksToWrite.add(track);
            }
            if (filename.endsWith(".dat")) {
                StringBuffer sb = StormTrack.toDiamond7(tracksToWrite, this.stormInfo.getStormId());
                IOUtil.writeFile(filename, sb.toString());
                return;
            }
            Hashtable sheetNames = new Hashtable();
            HSSFWorkbook wb = new HSSFWorkbook();
            StormTrack obsTrack = this.trackCollection.getObsTrack();
            if (obsTrack != null && this.obsCbx.isSelected()) {
                this.write(wb, obsTrack, sheetNames);
            }
            if (this.forecastCbx.isSelected()) {
                waysToUse = Misc.sort(waysToUse);
                for (Way way : waysToUse) {
                    if (way.isObservation()) continue;
                    List tracks = Misc.sort((Collection)trackMap.get(way));
                    if (this.mostRecentCbx.isSelected()) {
                        this.write(wb, (StormTrack)tracks.get(tracks.size() - 1), sheetNames);
                        continue;
                    }
                    for (StormTrack track : tracks) {
                        this.write(wb, track, sheetNames);
                    }
                }
            }
            FileOutputStream fileOut = new FileOutputStream(filename);
            wb.write((OutputStream)fileOut);
            fileOut.close();
        }
        catch (Exception exc) {
            StormTrackControl.logException("Writing spreadsheet", exc);
        }
    }

    protected void write(HSSFWorkbook wb, StormTrack track, Hashtable sheetNames) {
        int cnt = 0;
        String dateString = track.getStartTime().formattedString("yyyy-MM-dd hhmm", DateUtil.TIMEZONE_GMT);
        String sheetName = track.getWay() + " - " + dateString;
        if (sheetName.length() > 30) {
            sheetName = sheetName.substring(0, 29);
        }
        while (sheetNames.get(sheetName) != null) {
            if ((sheetName = cnt++ + " " + sheetName).length() <= 30) continue;
            sheetName = sheetName.substring(0, 29);
        }
        sheetNames.put(sheetName, sheetName);
        HSSFSheet sheet = wb.createSheet(sheetName);
        int rowCnt = 0;
        List<StormParam> params = track.getParams();
        for (StormTrackPoint stp : track.getTrackPoints()) {
            int colIdx;
            HSSFRow row;
            if (rowCnt == 0) {
                row = sheet.createRow((int)((short)rowCnt++));
                row.createCell((short)0).setCellValue("Time");
                row.createCell((short)1).setCellValue("Latitude");
                row.createCell((short)2).setCellValue("Longitude");
                for (colIdx = 0; colIdx < params.size(); ++colIdx) {
                    row.createCell((short)(colIdx + 3)).setCellValue(params.get(colIdx).toString());
                }
            }
            row = sheet.createRow((int)((short)rowCnt++));
            row.createCell((short)0).setCellValue(stp.getTime().toString());
            row.createCell((short)1).setCellValue(stp.getLocation().getLatitude().getValue());
            row.createCell((short)2).setCellValue(stp.getLocation().getLongitude().getValue());
            for (colIdx = 0; colIdx < params.size(); ++colIdx) {
                Real r = stp.getAttribute(params.get(colIdx));
                HSSFCell cell = row.createCell((short)(colIdx + 3));
                cell.setCellValue(r.getValue());
            }
        }
    }

    public void writeToKml(Element docNode, Hashtable state, boolean doObs, boolean doForecast, boolean mostRecent) throws VisADException, RemoteException {
        try {
            List waysToUse = new ArrayList<Way>();
            Hashtable<Way, ArrayList<StormTrack>> trackMap = new Hashtable<Way, ArrayList<StormTrack>>();
            for (StormTrack track : this.trackCollection.getTracks()) {
                ArrayList<StormTrack> tracks = (ArrayList<StormTrack>)trackMap.get(track.getWay());
                if (tracks == null) {
                    tracks = new ArrayList<StormTrack>();
                    trackMap.put(track.getWay(), tracks);
                    waysToUse.add(track.getWay());
                }
                tracks.add(track);
            }
            Element topFolder = KmlUtil.folder(docNode, "Storm: " + this.stormInfo.toString() + "   " + this.stormInfo.getStartTime().formattedString("yyyy-MM-dd", DateUtil.TIMEZONE_GMT));
            StormTrack obsTrack = this.trackCollection.getObsTrack();
            if (obsTrack != null && doObs) {
                Element obsFolder = KmlUtil.folder(topFolder, "Observation");
                this.stormTrackControl.writeToGE(docNode, state, obsFolder, obsTrack, this.getWayDisplayState(obsTrack.getWay()).getColor());
            }
            if (doForecast) {
                waysToUse = Misc.sort(waysToUse);
                for (Way way : waysToUse) {
                    if (way.isObservation()) continue;
                    Element wayNode = KmlUtil.folder(topFolder, this.stormTrackControl.getWayName() + ": " + way);
                    List tracks = Misc.sort((Collection)trackMap.get(way));
                    if (mostRecent) {
                        StormTrack recent = (StormTrack)tracks.get(tracks.size() - 1);
                        this.stormTrackControl.writeToGE(docNode, state, wayNode, recent, this.getWayDisplayState(recent.getWay()).getColor());
                        continue;
                    }
                    for (StormTrack track : tracks) {
                        this.stormTrackControl.writeToGE(docNode, state, wayNode, track, this.getWayDisplayState(track.getWay()).getColor());
                    }
                }
            }
        }
        catch (Exception exc) {
            StormTrackControl.logException("Writing KML", exc);
        }
    }

    public void setStormInfo(StormInfo value) {
        this.stormInfo = value;
    }

    public StormInfo getStormInfo() {
        return this.stormInfo;
    }

    public void setChanged(boolean value) {
        this.changed = value;
    }

    public boolean getChanged() {
        return this.changed;
    }

    public void setActive(boolean value) {
        this.active = value;
    }

    public boolean getActive() {
        return this.active;
    }

    public void setWayDisplayStateMap(Hashtable<Way, WayDisplayState> value) {
        this.wayDisplayStateMap = value;
    }

    public Hashtable<Way, WayDisplayState> getWayDisplayStateMap() {
        return this.wayDisplayStateMap;
    }

    public void setForecastState(WayDisplayState value) {
        this.forecastState = value;
    }

    public WayDisplayState getObservationState() {
        return this.obsDisplayState;
    }

    public void setObservationState(WayDisplayState value) {
        this.obsDisplayState = value;
    }

    public WayDisplayState getForecastState() {
        return this.forecastState;
    }

    public static Color getNextColor(int[] nextColor) {
        if (nextColor[0] >= colors.length) {
            nextColor[0] = 0;
        }
        int n = nextColor[0];
        nextColor[0] = n + 1;
        return colors[n];
    }

    public void setCharts(List<StormTrackChart> value) {
        this.charts = value;
    }

    public List<StormTrackChart> getCharts() {
        return this.charts;
    }

    public void setParams(Hashtable value) {
        this.params = value;
    }

    public Hashtable getParams() {
        return this.params;
    }

    public void setObsLayoutModelName(String value) {
        this.obsLayoutModelName = value;
    }

    public String getObsLayoutModelName() {
        return this.obsLayoutModelName;
    }

    public void setObsPointLayoutModelName(String value) {
        this.obsPointLayoutModelName = value;
    }

    public String getObsPointLayoutModelName() {
        return this.obsPointLayoutModelName;
    }

    public void setForecastLayoutModelName(String value) {
        this.forecastLayoutModelName = value;
    }

    public String getForecastLayoutModelName() {
        return this.forecastLayoutModelName;
    }

    public int getForecastAnimationMode() {
        return this.forecastAnimationMode;
    }

    public void setForecastAnimationMode(int value) {
        this.forecastAnimationMode = value;
    }

    public void markHasBeenEdited() {
        this.hasBeenEdited = true;
    }

    public void colorRangeChanged() {
        if (this.stormTrackControl == null) {
            return;
        }
        DisplayMaster displayMaster = this.stormTrackControl.getDisplayMaster();
        this.colorRangeChanged = true;
        boolean wasActive = displayMaster.ensureInactive();
        try {
            this.stormTrackControl.stormChanged(this);
            this.updateDisplays();
        }
        catch (Exception exc) {
            StormTrackControl.logException("Changing color table", exc);
        }
    }

    public boolean isColorRangeChanged() {
        return this.colorRangeChanged;
    }

    public void setColorRangeChanged(boolean value) {
        this.colorRangeChanged = value;
    }

    public boolean getColorRangeChanged() {
        return this.colorRangeChanged;
    }

    private static class ParamSelector {
        List<StormParam> params;
        JList list;

        public ParamSelector(List<StormParam> types) {
        }
    }

    private class PointEditCommand
    extends Command {
        StormTrack stormTrack;
        List<StormTrackPoint> originalPoints;
        List<StormTrackPoint> newPoints;

        public PointEditCommand(StormTrack stormTrack, List<StormTrackPoint> originalPoints, List<StormTrackPoint> newPoints) {
            this.stormTrack = stormTrack;
            this.originalPoints = originalPoints;
            this.newPoints = newPoints;
        }

        @Override
        public void redoCommand() {
            try {
                this.stormTrack.setTrackPoints(this.newPoints);
                StormDisplayState.this.updateDisplays(this.stormTrack);
            }
            catch (Exception exp) {
                StormDisplayState.this.stormTrackControl;
                StormTrackControl.logException("undoing edit command", exp);
            }
        }

        @Override
        public void undoCommand() {
            try {
                this.stormTrack.setTrackPoints(this.originalPoints);
                StormDisplayState.this.updateDisplays(this.stormTrack);
            }
            catch (Exception exp) {
                StormDisplayState.this.stormTrackControl;
                StormTrackControl.logException("undoing edit command", exp);
            }
        }
    }
}

