/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control.storm;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import ucar.unidata.idv.control.storm.WayDisplayState;
import ucar.unidata.util.LogUtil;

public class DisplayState {
    private WayDisplayState wayDisplayState;
    private JCheckBox cbx;
    private boolean visible;
    private String name;

    public DisplayState() {
    }

    public DisplayState(WayDisplayState wayDisplayState, String name, boolean visible) {
        this.wayDisplayState = wayDisplayState;
        this.name = name;
        this.visible = visible;
    }

    protected void setBackground(Color c) {
        this.getCheckBox().setBackground(c);
    }

    public JCheckBox getCheckBox() {
        if (this.cbx == null) {
            this.cbx = new JCheckBox("", this.getVisible());
            this.cbx.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            this.cbx.setToolTipText(this.name);
            this.cbx.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    try {
                        DisplayState.this.setVisible(DisplayState.this.cbx.isSelected());
                        DisplayState.this.wayDisplayState.getStormDisplayState().displayStateChanged(DisplayState.this);
                    }
                    catch (Exception exc) {
                        LogUtil.logException("Toggling way visible", exc);
                    }
                }
            });
        }
        return this.cbx;
    }

    public void setVisible(boolean value) {
        this.visible = value;
    }

    public boolean getVisible() {
        return this.visible;
    }

    public void setName(String value) {
        this.name = value;
    }

    public String getName() {
        return this.name;
    }

    public void setWayDisplayState(WayDisplayState value) {
        this.wayDisplayState = value;
    }

    public WayDisplayState getWayDisplayState() {
        return this.wayDisplayState;
    }
}

