/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control.multi;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.beans.PropertyVetoException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import ucar.unidata.data.DataCategory;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataSource;
import ucar.unidata.idv.ControlContext;
import ucar.unidata.idv.ControlDescriptor;
import ucar.unidata.idv.DisplayConventions;
import ucar.unidata.idv.ViewDescriptor;
import ucar.unidata.idv.ViewManager;
import ucar.unidata.idv.control.DisplayControlImpl;
import ucar.unidata.idv.control.chart.ChartWrapper;
import ucar.unidata.idv.control.multi.DisplayComponent;
import ucar.unidata.idv.control.multi.DisplayControlWrapper;
import ucar.unidata.idv.control.multi.DisplayGroup;
import ucar.unidata.idv.control.multi.DisplayTree;
import ucar.unidata.idv.control.multi.FieldSelectorWrapper;
import ucar.unidata.idv.control.multi.ViewWrapper;
import ucar.unidata.idv.ui.IdvWindow;
import ucar.unidata.metdata.NamedStationTable;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.ObjectListener;
import ucar.visad.display.Animation;
import ucar.visad.display.Displayable;
import visad.DateTime;
import visad.Real;
import visad.VisADException;

public class MultiDisplayHolder
extends DisplayControlImpl {
    private static final String CONTROL_PREFIX = "control:";
    private static final String ID_VIEW = "id.mapview";
    private static final String ID_GLOBE = "id.globe";
    private static final String ID_TRANSECT = "id.transect";
    private static final String ID_FIELDSELECTOR = "id.fieldselector";
    private static final String ID_GROUP = "id.group";
    private static final String[] TYPES = new String[]{"TimeSeriesChartWrapper", "ScatterPlotChartWrapper", "HistogramWrapper", "StatisticsChartWrapper", "TableChartWrapper", "ReadoutTable"};
    private List prototypes;
    private String initialComponentClass = null;
    private List dataList;
    JTabbedPane tabbedPane = new JTabbedPane();
    JDesktopPane desktopPane = new JDesktopPane();
    JPanel container;
    List displayGroups = new ArrayList();
    private boolean useDesktop = false;
    private int frameLocation = 0;
    private DisplayTree displayTree;
    private List controlDescriptors = new ArrayList();
    private List dataCategories = new ArrayList();
    private List lastDataSources;

    @Override
    public void initDone() {
        DisplayGroup displayGroup;
        int groupIdx;
        super.initDone();
        for (groupIdx = 0; groupIdx < this.displayGroups.size(); ++groupIdx) {
            displayGroup = (DisplayGroup)this.displayGroups.get(groupIdx);
            displayGroup.initDone();
        }
        this.loadData();
        for (groupIdx = 0; groupIdx < this.displayGroups.size(); ++groupIdx) {
            displayGroup = (DisplayGroup)this.displayGroups.get(groupIdx);
            this.insertGroup(displayGroup);
            displayGroup.setLabelShown(false);
        }
    }

    @Override
    public boolean init(List choices) throws VisADException, RemoteException {
        for (int groupIdx = 0; groupIdx < this.displayGroups.size(); ++groupIdx) {
            DisplayGroup displayGroup = (DisplayGroup)this.displayGroups.get(groupIdx);
            displayGroup.setDisplayControl(this);
        }
        if (this.displayGroups.size() == 0) {
            DisplayComponent displayComponent;
            DisplayGroup displayGroup = this.createDisplayGroup("Default Group");
            if (this.initialComponentClass != null && (displayComponent = this.createDisplayComponent(this.initialComponentClass, choices, displayGroup)) == null) {
                return false;
            }
        }
        this.setDataChoices(new ArrayList());
        return true;
    }

    @Override
    public void initAfterUnPersistence(ControlContext vc, Hashtable properties) {
        this.controlContext = vc;
        for (int i = 0; i < this.displayGroups.size(); ++i) {
            DisplayGroup displayGroup = (DisplayGroup)this.displayGroups.get(i);
            displayGroup.initAfterUnPersistence(this, vc, properties);
        }
        super.initAfterUnPersistence(vc, properties);
    }

    public void componentChanged() {
        if (this.displayTree != null) {
            this.displayTree.loadComponents();
        }
    }

    public void showDisplayTree() {
        if (this.displayTree == null) {
            this.displayTree = new DisplayTree(this);
        }
        this.displayTree.show(this.getContents());
    }

    protected DisplayTree getDisplayTree() {
        return this.displayTree;
    }

    @Override
    public void getLegendLabels(List labels, int legendType) {
        super.getLegendLabels(labels, legendType);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.displayGroups.size(); ++i) {
            DisplayGroup displayGroup = (DisplayGroup)this.displayGroups.get(i);
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(displayGroup.getName());
        }
        labels.add(sb.toString());
    }

    protected JInternalFrame findFrameForGroup(DisplayGroup displayGroup) {
        JInternalFrame[] frames = this.desktopPane.getAllFrames();
        for (int i = 0; i < frames.length; ++i) {
            MyInternalFrame myFrame = (MyInternalFrame)frames[i];
            if (myFrame.displayGroup != displayGroup) continue;
            return myFrame;
        }
        return null;
    }

    protected int findIdxForGroup(DisplayGroup displayGroup) {
        if (this.tabbedPane.getTabCount() > 0) {
            return this.tabbedPane.indexOfComponent(displayGroup.getContents());
        }
        return -1;
    }

    public String formatValue(double v) {
        DisplayConventions dc = this.getDisplayConventions();
        return dc.format(v);
    }

    public void newName(DisplayGroup displayGroup, String oldName) {
        if (this.useDesktop) {
            JInternalFrame frame = this.findFrameForGroup(displayGroup);
            if (frame != null) {
                frame.setTitle(displayGroup.getName());
            }
        } else {
            int idx = this.findIdxForGroup(displayGroup);
            if (idx >= 0) {
                this.tabbedPane.setTitleAt(idx, displayGroup.getName());
            }
        }
    }

    public void toggleUI() {
        if (this.useDesktop) {
            this.saveGroupLocations();
        }
        this.frameLocation = 0;
        this.useDesktop = !this.useDesktop;
        this.container.removeAll();
        this.tabbedPane.removeAll();
        this.desktopPane.removeAll();
        for (int i = 0; i < this.displayGroups.size(); ++i) {
            DisplayGroup displayGroup = (DisplayGroup)this.displayGroups.get(i);
            this.insertGroup(displayGroup);
        }
        if (this.useDesktop) {
            this.container.add("Center", this.desktopPane);
        } else {
            this.container.add("Center", this.tabbedPane);
        }
        this.container.validate();
        this.container.repaint();
    }

    @Override
    protected void getViewMenuItems(List items, boolean forMenuBar) {
        items.add(GuiUtils.makeMenuItem(this.useDesktop ? "Show tabs" : "Show desktop", this, "toggleUI"));
        super.getViewMenuItems(items, forMenuBar);
    }

    @Override
    protected void getEditMenuItems(List items, boolean forMenuBar) {
        items.add(GuiUtils.makeMenuItem("Manage Displays...", this, "showDisplayTree"));
        super.getEditMenuItems(items, forMenuBar);
    }

    private List flattenChoices(List theChoices) {
        if (theChoices == null) {
            return null;
        }
        if (theChoices.size() == 0) {
            return theChoices;
        }
        if (theChoices.get(0) instanceof List) {
            ArrayList flatChoices = new ArrayList();
            for (int i = 0; i < theChoices.size(); ++i) {
                flatChoices.addAll((List)theChoices.get(i));
            }
            theChoices = flatChoices;
        }
        return theChoices;
    }

    private List selectDataChoices(List titles, boolean multiples, List selectedDataChoices, List categories) {
        return null;
    }

    public void createComponentIn(Object[] args) {
        this.createComponent((String)args[0], (DisplayGroup)args[1]);
    }

    protected String getLowerComponentName() {
        return this.useDesktop ? "frame" : "tab";
    }

    protected String getUpperComponentName() {
        return this.useDesktop ? "Frame" : "Tab";
    }

    public void createComponentInNewTab(String type) {
        String groupName = GuiUtils.getInput("Please enter " + this.getLowerComponentName() + " name", this.getUpperComponentName() + " name: ", "");
        if (groupName == null) {
            return;
        }
        this.createComponent(type, this.createDisplayGroup(groupName));
    }

    public void createDisplayGroup() {
        String groupName = GuiUtils.getInput("Please enter " + this.getLowerComponentName() + " name", this.getUpperComponentName() + " name: ", "");
        if (groupName == null) {
            return;
        }
        this.showDisplayComponent(this.createDisplayGroup(groupName));
        this.componentChanged();
    }

    public void createComponentInCurrentTab(String type) {
        this.createComponent(type, this.getCurrentDisplayGroup());
    }

    protected void createComponent(String type, DisplayGroup displayGroup) {
        if (type.equals(ID_GROUP)) {
            this.addGroup(displayGroup);
            return;
        }
        DisplayComponent displayComponent = this.createDisplayComponent(type, null, displayGroup);
        if (displayComponent == null) {
            return;
        }
        try {
            displayComponent.loadData();
        }
        catch (Exception excp) {
            MultiDisplayHolder.logException("loading data ", excp);
        }
        this.showDisplayComponent(displayComponent);
        this.componentChanged();
    }

    private List getCategories(ChartWrapper chartWrapper) {
        List categories = chartWrapper.getCategories();
        if (categories == null) {
            categories = Misc.newList(this.getCategories());
        }
        return categories;
    }

    public void addFieldToChartWrapper(ChartWrapper chartWrapper) {
        this.showDisplayComponent(chartWrapper);
        List choices = this.selectDataChoices(chartWrapper.getFieldSelectionLabels(), chartWrapper.doMultipleAddFields(), null, this.getCategories(chartWrapper));
        if (choices == null) {
            return;
        }
        try {
            chartWrapper.addDataChoices(choices);
        }
        catch (Exception excp) {
            MultiDisplayHolder.logException("loading data ", excp);
        }
    }

    public List getPrototypes() {
        if (this.prototypes == null) {
            this.prototypes = new ArrayList();
            for (int i = 0; i < TYPES.length; ++i) {
                try {
                    Class c = this.findChartClass(TYPES[i]);
                    this.prototypes.add(c.newInstance());
                    continue;
                }
                catch (Throwable thr) {
                    LogUtil.userErrorMessage("Unable to find chart:" + TYPES[i]);
                }
            }
        }
        return this.prototypes;
    }

    protected void addControlsToMenu(JMenu newMenu, final DisplayGroup displayGroup) {
        List dataSources = this.getIdv().getDataSources();
        if (!Misc.equals(dataSources, this.lastDataSources)) {
            Hashtable<String, String> seen = new Hashtable<String, String>();
            this.lastDataSources = new ArrayList(dataSources);
            this.dataCategories = new ArrayList();
            long t1 = System.currentTimeMillis();
            for (int dataSourceIdx = 0; dataSourceIdx < dataSources.size(); ++dataSourceIdx) {
                DataSource dataSource = (DataSource)dataSources.get(dataSourceIdx);
                List dataChoices = dataSource.getDataChoices();
                for (int dataChoiceIdx = 0; dataChoiceIdx < dataChoices.size(); ++dataChoiceIdx) {
                    DataChoice dataChoice = (DataChoice)dataChoices.get(dataChoiceIdx);
                    List categories = dataChoice.getCategories();
                    for (int catIdx = 0; catIdx < categories.size(); ++catIdx) {
                        DataCategory dataCategory = (DataCategory)categories.get(catIdx);
                        String string = dataCategory.toString();
                        if (seen.get(string) != null) continue;
                        seen.put(string, string);
                        this.dataCategories.add(dataCategory);
                    }
                }
            }
            long t2 = System.currentTimeMillis();
            this.controlDescriptors = ControlDescriptor.getApplicableControlDescriptors(this.dataCategories, this.getIdv().getControlDescriptors(), true, false);
            long l = System.currentTimeMillis();
        }
        final JMenu controlsMenu = new JMenu("Controls");
        newMenu.add(controlsMenu);
        controlsMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent e) {
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuSelected(MenuEvent e) {
                MultiDisplayHolder.this.makeControlsMenu(controlsMenu, displayGroup);
            }
        });
        final JMenu locationsMenu = new JMenu("Locations");
        newMenu.add(locationsMenu);
        locationsMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent e) {
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuSelected(MenuEvent e) {
                MultiDisplayHolder.this.makeLocationsMenu(locationsMenu, displayGroup);
            }
        });
    }

    public void makeControlsMenu(JMenu controlsMenu, DisplayGroup displayGroup) {
        if (controlsMenu.getItemCount() > 0) {
            return;
        }
        Hashtable<String, JMenu> map = new Hashtable<String, JMenu>();
        for (int i = 0; i < this.controlDescriptors.size(); ++i) {
            ControlDescriptor cd = (ControlDescriptor)this.controlDescriptors.get(i);
            String displayCategory = cd.getDisplayCategory();
            JMenu catMenu = (JMenu)map.get(displayCategory);
            if (catMenu == null) {
                catMenu = new JMenu(displayCategory);
                map.put(displayCategory, catMenu);
                controlsMenu.add(catMenu);
            }
            if (displayGroup != null) {
                catMenu.add(GuiUtils.makeMenuItem(cd.getLabel(), this, "createComponentIn", new Object[]{CONTROL_PREFIX + cd.getControlId(), displayGroup}));
                continue;
            }
            catMenu.add(GuiUtils.makeMenuItem(cd.getLabel(), this, "createComponentInCurrentTab", CONTROL_PREFIX + cd.getControlId()));
        }
    }

    public void makeLocationsMenu(JMenu locationsMenu, final DisplayGroup displayGroup) {
        if (locationsMenu.getItemCount() > 0) {
            return;
        }
        List stations = this.getIdv().getLocationList();
        ObjectListener listener = new ObjectListener(this.getIdv().getControlDescriptor("locationcontrol")){

            @Override
            public void actionPerformed(ActionEvent ae, Object obj) {
                MultiDisplayHolder.this.addStationDisplay((NamedStationTable)obj, (ControlDescriptor)this.theObject, displayGroup);
            }
        };
        List<JMenuItem> menuItems = NamedStationTable.makeMenuItems(stations, listener);
        GuiUtils.makeMenu(locationsMenu, menuItems);
    }

    @Override
    protected IdvWindow createIdvWindow() {
        return new IdvWindow(this.getTitle(), this.getIdv(), true);
    }

    @Override
    public void initWindow(IdvWindow window) {
        JPanel status = this.getControlContext().getIdv().getIdvUIManager().doMakeStatusBar(window);
        JPanel contents = GuiUtils.centerBottom(window.getContents(), status);
        window.setContents(contents);
        super.initWindow(window);
    }

    @Override
    protected void handleWindowClosing() {
    }

    public void addStationDisplay(NamedStationTable stationTable, ControlDescriptor cd, DisplayGroup displayGroup) {
        if (displayGroup == null) {
            displayGroup = this.getCurrentDisplayGroup();
        }
        if (displayGroup == null) {
            return;
        }
        String properties = "stationTableName=" + stationTable.getFullName() + ";makeWindow=false;showInLegend=true;";
        DisplayControlImpl displayControl = (DisplayControlImpl)this.getIdv().doMakeControl(new ArrayList(), cd, properties, null, false);
        if (displayControl == null) {
            return;
        }
        DisplayControlWrapper displayWrapper = new DisplayControlWrapper(displayControl);
        displayWrapper.setDisplayControl(this);
        displayGroup.addDisplayComponent(displayWrapper);
    }

    @Override
    protected void getFileMenuItems(List items, boolean forMenuBar) {
        JMenu newMenu = new JMenu("New");
        items.add(newMenu);
        newMenu.add(GuiUtils.makeMenuItem(this.getUpperComponentName(), this, "createDisplayGroup"));
        newMenu.add(GuiUtils.makeMenuItem("Group", this, "createComponentInCurrentTab", ID_GROUP));
        newMenu.addSeparator();
        newMenu.add(GuiUtils.makeMenuItem("Map Display", this, "createComponentInCurrentTab", ID_VIEW));
        newMenu.add(GuiUtils.makeMenuItem("Transect Display", this, "createComponentInCurrentTab", ID_TRANSECT));
        newMenu.add(GuiUtils.makeMenuItem("Globe Display", this, "createComponentInCurrentTab", ID_GLOBE));
        newMenu.addSeparator();
        newMenu.add(GuiUtils.makeMenuItem("Field Selector", this, "createComponentInCurrentTab", ID_FIELDSELECTOR));
        newMenu.addSeparator();
        this.addControlsToMenu(newMenu, null);
        newMenu.addSeparator();
        JMenu chartMenu = new JMenu("Charts");
        newMenu.add(chartMenu);
        List prototypes = this.getPrototypes();
        for (int i = 0; i < prototypes.size(); ++i) {
            ChartWrapper prototype = (ChartWrapper)prototypes.get(i);
            chartMenu.add(GuiUtils.makeMenuItem(prototype.getTypeName(), this, "createComponentInCurrentTab", prototype.getClass().getName()));
        }
        List displayControls = this.getIdv().getDisplayControls();
        JMenu importMenu = null;
        for (int i = 0; i < displayControls.size(); ++i) {
            DisplayControlImpl displayControl = (DisplayControlImpl)displayControls.get(i);
            if (!displayControl.getMakeWindow() || displayControl == this) continue;
            if (importMenu == null) {
                importMenu = new JMenu("Import");
                items.add(importMenu);
            }
            importMenu.add(GuiUtils.makeMenuItem(displayControl.toString(), this, "importDisplayControl", displayControl));
        }
        super.getFileMenuItems(items, forMenuBar);
    }

    public void importDisplayControl(DisplayControlImpl displayControl) {
        displayControl.guiImported();
        DisplayGroup displayGroup = this.getCurrentDisplayGroup();
        DisplayControlWrapper displayWrapper = new DisplayControlWrapper(displayControl);
        displayWrapper.setDisplayControl(this);
        if (displayGroup != null) {
            displayGroup.addDisplayComponent(displayWrapper);
        }
    }

    public DisplayGroup getCurrentDisplayGroup() {
        if (this.useDesktop) {
            MyInternalFrame myFrame;
            JInternalFrame[] frames = this.desktopPane.getAllFrames();
            if (frames.length > 0 && (myFrame = (MyInternalFrame)this.desktopPane.getSelectedFrame()) != null) {
                return myFrame.displayGroup;
            }
        } else if (this.tabbedPane.getTabCount() > 0) {
            JComponent panel = (JComponent)this.tabbedPane.getSelectedComponent();
            for (int i = 0; i < this.displayGroups.size(); ++i) {
                DisplayGroup displayGroup = (DisplayGroup)this.displayGroups.get(i);
                if (panel != displayGroup.getContents()) continue;
                return displayGroup;
            }
        }
        return this.createDisplayGroup("Default Group");
    }

    public void showDisplayComponent(DisplayComponent displayComponent) {
        int idx;
        if (displayComponent.getDisplayGroup() != null) {
            GuiUtils.showComponentInTabs(displayComponent.getContents(), false);
            this.showDisplayComponent(displayComponent.getDisplayGroup());
            return;
        }
        if (!(displayComponent instanceof DisplayGroup)) {
            return;
        }
        if (this.useDesktop) {
            JInternalFrame frame = this.findFrameForGroup((DisplayGroup)displayComponent);
            if (frame != null) {
                this.desktopPane.setSelectedFrame(frame);
            }
        } else if (this.tabbedPane.getTabCount() > 0 && (idx = this.findIdxForGroup((DisplayGroup)displayComponent)) >= 0) {
            this.tabbedPane.setSelectedIndex(idx);
        }
    }

    private Class findChartClass(String name) throws ClassNotFoundException {
        Class c = null;
        try {
            c = Misc.findClass(name);
        }
        catch (Throwable cnfe) {
            c = Misc.findClass("ucar.unidata.idv.control.chart." + name);
        }
        return c;
    }

    public void addGroupNewMenu(DisplayGroup displayGroup, JMenu newMenu) {
        newMenu.add(GuiUtils.makeMenuItem("Group", this, "addGroup", displayGroup));
        newMenu.addSeparator();
        newMenu.add(GuiUtils.makeMenuItem("Map Display", this, "createComponentIn", new Object[]{ID_VIEW, displayGroup}));
        newMenu.add(GuiUtils.makeMenuItem("Transect Display", this, "createComponentIn", new Object[]{ID_TRANSECT, displayGroup}));
        newMenu.add(GuiUtils.makeMenuItem("Globe Display", this, "createComponentIn", new Object[]{ID_GLOBE, displayGroup}));
        newMenu.addSeparator();
        newMenu.add(GuiUtils.makeMenuItem("Field Selector", this, "createComponentIn", new Object[]{ID_FIELDSELECTOR, displayGroup}));
        newMenu.addSeparator();
        this.addControlsToMenu(newMenu, displayGroup);
        newMenu.addSeparator();
        JMenu chartMenu = new JMenu("Charts");
        newMenu.add(chartMenu);
        List prototypes = this.getPrototypes();
        for (int i = 0; i < prototypes.size(); ++i) {
            ChartWrapper prototype = (ChartWrapper)prototypes.get(i);
            chartMenu.add(GuiUtils.makeMenuItem(prototype.getTypeName(), this, "createComponentIn", new Object[]{prototype.getClass().getName(), displayGroup}));
        }
    }

    @Override
    protected JMenuBar doMakeMenuBar() {
        List menus = this.doMakeMenuBarMenus(new ArrayList());
        JMenuBar menuBar = this.getIdv().getIdvUIManager().doMakeMenuBar();
        JMenu displayMenu = GuiUtils.makeMenu("Multi Display", menus);
        menuBar.add(displayMenu);
        return menuBar;
    }

    public DisplayComponent createDisplayComponent(String addType, List dataChoices, DisplayGroup displayGroup) {
        if (addType == null) {
            return null;
        }
        try {
            if (addType.equals(ID_VIEW) || addType.equals(ID_TRANSECT) || addType.equals(ID_GLOBE)) {
                String properties = "";
                ViewDescriptor vd = new ViewDescriptor();
                if (addType.equals(ID_GLOBE) || addType.equals(ID_VIEW)) {
                    vd.setClassNames(Misc.newList("ucar.unidata.idv.MapViewManager"));
                } else if (addType.equals(ID_TRANSECT)) {
                    vd.setClassNames(Misc.newList("ucar.unidata.idv.TransectViewManager"));
                }
                if (addType.equals(ID_GLOBE)) {
                    properties = "useGlobeDisplay=true;initialMapResources=/auxdata/maps/globemaps.xml;";
                }
                ViewManager vm = this.getIdv().getVMManager().createViewManager(vd, properties);
                vm.setInitialSplitPaneLocation(1.0);
                this.getIdv().getVMManager().setLastActiveViewManager(vm);
                ViewWrapper viewWrapper = new ViewWrapper(vm);
                viewWrapper.setDisplayControl(this);
                if (displayGroup != null) {
                    displayGroup.addDisplayComponent(viewWrapper);
                }
                return viewWrapper;
            }
            if (addType.equals(ID_FIELDSELECTOR)) {
                FieldSelectorWrapper fieldSelectorWrapper = new FieldSelectorWrapper();
                fieldSelectorWrapper.setDisplayControl(this);
                if (displayGroup != null) {
                    displayGroup.addDisplayComponent(fieldSelectorWrapper);
                }
                return fieldSelectorWrapper;
            }
            if (addType.startsWith(CONTROL_PREFIX)) {
                addType = addType.substring(8);
                ControlDescriptor controlDescriptor = this.getControlContext().getIdv().getControlDescriptor(addType);
                if (controlDescriptor == null) {
                    return null;
                }
                List fieldNames = Misc.newList("Please select a field");
                if (controlDescriptor.canStandAlone()) {
                    dataChoices = new ArrayList();
                } else if ((dataChoices = this.selectDataChoices(fieldNames, false, dataChoices, Misc.newList(controlDescriptor.getCategories()))) == null) {
                    return null;
                }
                DisplayControlImpl displayControl = (DisplayControlImpl)this.getControlContext().getIdv().doMakeControl(dataChoices, controlDescriptor, "makeWindow=false;showInLegend=true;", null, false);
                if (displayControl == null) {
                    return null;
                }
                DisplayControlWrapper displayWrapper = new DisplayControlWrapper(displayControl);
                displayWrapper.setDisplayControl(this);
                if (displayGroup != null) {
                    displayGroup.addDisplayComponent(displayWrapper);
                }
                return displayWrapper;
            }
            Class c = this.findChartClass(addType);
            ChartWrapper chartWrapper = (ChartWrapper)c.newInstance();
            if (dataChoices == null) {
                dataChoices = new ArrayList();
            }
            List fieldNames = chartWrapper.getFieldSelectionLabels();
            if (dataChoices.size() < fieldNames.size() && (dataChoices = this.selectDataChoices(fieldNames, chartWrapper.doMultipleAddFields(), dataChoices, this.getCategories(chartWrapper))) == null) {
                return null;
            }
            chartWrapper.init(this, dataChoices);
            if (displayGroup != null) {
                displayGroup.addDisplayComponent(chartWrapper);
            }
            return chartWrapper;
        }
        catch (Exception exc) {
            LogUtil.logException("Error: Unable to load class: " + addType, exc);
            return null;
        }
    }

    public void addGroup(DisplayGroup displayGroup) {
        String name = GuiUtils.getInput("Please enter group name", "Group name: ", "");
        if (name != null) {
            displayGroup.addDisplayComponent(new DisplayGroup(name));
            this.componentChanged();
        }
    }

    public DisplayGroup createDisplayGroup(String groupName) {
        DisplayGroup displayGroup = new DisplayGroup(groupName);
        displayGroup.setDisplayControl(this);
        this.displayGroups.add(displayGroup);
        this.insertGroup(displayGroup);
        displayGroup.setLabelShown(false);
        return displayGroup;
    }

    public DisplayGroup getDisplayGroup(String groupName) {
        for (int groupIdx = 0; groupIdx < this.displayGroups.size(); ++groupIdx) {
            DisplayGroup displayGroup = (DisplayGroup)this.displayGroups.get(groupIdx);
            if (!displayGroup.getName().equals(groupName)) continue;
            return displayGroup;
        }
        return null;
    }

    private void insertGroup(DisplayGroup displayGroup) {
        block7: {
            if (this.useDesktop) {
                MyInternalFrame internalFrame = new MyInternalFrame(displayGroup);
                internalFrame.getContentPane().add(displayGroup.getContents());
                this.desktopPane.add(internalFrame);
                internalFrame.pack();
                Rectangle lastPosition = displayGroup.getLastPosition();
                if (lastPosition != null) {
                    internalFrame.setBounds(lastPosition);
                } else {
                    internalFrame.setSize(new Dimension(500, 400));
                    internalFrame.setLocation(this.frameLocation, this.frameLocation);
                    this.frameLocation += 10;
                }
                internalFrame.show();
                try {
                    if (displayGroup.getIconified()) {
                        internalFrame.setIcon(true);
                        break block7;
                    }
                    internalFrame.setSelected(true);
                }
                catch (PropertyVetoException propertyVetoException) {}
            } else {
                this.tabbedPane.add(displayGroup.getName(), displayGroup.getContents());
            }
        }
        this.updateLegendLabel();
    }

    @Override
    protected boolean shouldAddAnimationListener() {
        return true;
    }

    @Override
    protected void timeChanged(Real time) {
        super.timeChanged(time);
        if (time.isMissing()) {
            return;
        }
        for (int i = 0; i < this.displayGroups.size(); ++i) {
            ((DisplayGroup)this.displayGroups.get(i)).animationTimeChanged(time);
        }
    }

    public void setTimeInMainDisplay(double timeValue) {
        try {
            Animation anime = this.getSomeAnimation();
            if (anime.getNumSteps() <= 1) {
                return;
            }
            DateTime dttm = new DateTime(timeValue /= 1000.0);
            anime.setAniValue(dttm);
        }
        catch (Exception excp) {
            MultiDisplayHolder.logException("setting time", excp);
        }
    }

    @Override
    protected Container doMakeContents() throws VisADException, RemoteException {
        if (this.useDesktop) {
            this.desktopPane.validate();
            this.container = GuiUtils.center(this.desktopPane);
        } else {
            this.tabbedPane.validate();
            this.container = GuiUtils.center(this.tabbedPane);
        }
        JComponent toolbar = this.getIdv().getIdvUIManager().getToolbarUI();
        JPanel filler = new JPanel();
        filler.setMinimumSize(new Dimension(1, 200));
        filler.setPreferredSize(new Dimension(1, 200));
        return GuiUtils.topCenter(toolbar, GuiUtils.leftCenter(filler, this.container));
    }

    @Override
    public void viewManagerDestroyed(ViewManager viewManager) throws VisADException, RemoteException {
        this.defaultViewManager = null;
        this.defaultView = null;
    }

    @Override
    public void doRemove() throws RemoteException, VisADException {
        if (!this.getActive()) {
            return;
        }
        if (this.displayTree != null) {
            this.displayTree.close();
            this.displayTree = null;
        }
        for (int i = 0; i < this.displayGroups.size(); ++i) {
            DisplayGroup displayGroup = (DisplayGroup)this.displayGroups.get(i);
            displayGroup.doRemove();
        }
        super.doRemove();
    }

    public void removeDisplayComponent(DisplayComponent displayComponent) {
        try {
            if (displayComponent instanceof DisplayGroup) {
                this.removeDisplayGroup((DisplayGroup)displayComponent);
            }
            displayComponent.doRemove();
            this.updateLegendLabel();
            this.componentChanged();
        }
        catch (Exception excp) {
            MultiDisplayHolder.logException("removing component ", excp);
        }
    }

    public void removeDisplayables(List displayables) {
        try {
            for (int i = 0; i < displayables.size(); ++i) {
                Displayable d = (Displayable)displayables.get(i);
                this.removeDisplayable(d);
            }
        }
        catch (Exception excp) {
            MultiDisplayHolder.logException("removing displayables ", excp);
        }
    }

    public void removeDisplayGroup(DisplayGroup displayGroup) {
        this.displayGroups.remove(displayGroup);
        if (this.useDesktop) {
            JInternalFrame frame = this.findFrameForGroup(displayGroup);
            if (frame != null) {
                this.desktopPane.remove(frame);
                this.desktopPane.repaint();
            }
        } else {
            int idx = this.findIdxForGroup(displayGroup);
            if (idx >= 0) {
                this.tabbedPane.remove(idx);
                this.tabbedPane.repaint();
            }
        }
    }

    protected void loadData() {
        try {
            for (int i = 0; i < this.displayGroups.size(); ++i) {
                ((DisplayGroup)this.displayGroups.get(i)).loadData();
            }
        }
        catch (Exception excp) {
            MultiDisplayHolder.logException("loading data ", excp);
        }
    }

    public void setDisplayGroups(List value) {
        this.displayGroups = value;
    }

    public List getDisplayGroups() {
        this.saveGroupLocations();
        return this.displayGroups;
    }

    private void saveGroupLocations() {
        if (this.useDesktop) {
            for (int groupIdx = 0; groupIdx < this.displayGroups.size(); ++groupIdx) {
                DisplayGroup displayGroup = (DisplayGroup)this.displayGroups.get(groupIdx);
                JInternalFrame frame = this.findFrameForGroup(displayGroup);
                if (frame == null) continue;
                displayGroup.setLastPosition(frame.getBounds());
                displayGroup.setIconified(frame.isIcon());
            }
        }
    }

    @Override
    public void setTitle(String title) {
        super.setTitle(title);
    }

    public void setInitialComponentClass(String value) {
        this.initialComponentClass = value;
    }

    public String getInitialComponentClass() {
        return this.initialComponentClass;
    }

    public void setUseDesktop(boolean value) {
        this.useDesktop = value;
    }

    public boolean getUseDesktop() {
        return this.useDesktop;
    }

    protected boolean shouldShowInDisplayList() {
        return false;
    }

    private static class MyInternalFrame
    extends JInternalFrame {
        DisplayGroup displayGroup;

        public MyInternalFrame(DisplayGroup displayGroup) {
            super(displayGroup.getName(), true, false, true, true);
            this.displayGroup = displayGroup;
        }
    }
}

