/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control.multi;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import ucar.unidata.idv.control.multi.DisplayComponent;
import ucar.unidata.idv.control.multi.DisplayGroup;
import ucar.unidata.idv.control.multi.MultiDisplayHolder;
import ucar.unidata.ui.DndTree;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;

public class DisplayTree
extends DndTree
implements ActionListener {
    private JFrame frame;
    private MyTreeNode treeRoot;
    private DefaultTreeModel treeModel;
    private Hashtable nodeToData;
    private MultiDisplayHolder displayControl;
    private ImageIcon groupIcon;
    private ImageIcon leafIcon;

    public DisplayTree(MultiDisplayHolder displayControl) {
        this.displayControl = displayControl;
        this.groupIcon = GuiUtils.getImageIcon("/auxdata/ui/icons/Folder.gif", this.getClass());
        this.leafIcon = GuiUtils.getImageIcon("/auxdata/ui/icons/File.gif", this.getClass());
        this.setToolTipText("<html>Right click to show popup menu.<br>Drag to move groups or harts</html>");
        this.treeRoot = new MyTreeNode();
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.treeModel = new DefaultTreeModel(this.treeRoot);
        this.setModel(this.treeModel);
        DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree theTree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                super.getTreeCellRendererComponent(theTree, value, sel, expanded, leaf, row, hasFocus);
                if (DisplayTree.this.nodeToData == null || value == null) {
                    return this;
                }
                Object data = DisplayTree.this.nodeToData.get(value);
                if (data == null) {
                    this.setIcon(DisplayTree.this.groupIcon);
                    return this;
                }
                this.setToolTipText("<html>Right click to show component menu.<br>Drag to move</html>");
                if (!(data instanceof DisplayGroup)) {
                    this.setIcon(this.leafIcon);
                } else {
                    this.setIcon(DisplayTree.this.groupIcon);
                }
                return this;
            }
        };
        this.setCellRenderer(renderer);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (GuiUtils.isDeleteEvent(e)) {
                    DisplayTree.this.deleteSelected();
                }
            }
        });
        this.getSelectionModel().setSelectionMode(4);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                TreePath path = DisplayTree.this.getPathForLocation(event.getX(), event.getY());
                DisplayComponent comp = DisplayTree.this.findCompAtPath(path);
                if (comp == null) {
                    return;
                }
                DisplayTree.this.getDisplayControl().showDisplayComponent(comp);
                DisplayTree.this.frame.toFront();
                if (event.getClickCount() > 1) {
                    comp.showProperties();
                    return;
                }
                if (!SwingUtilities.isRightMouseButton(event)) {
                    return;
                }
                DisplayTree.this.clearSelection();
                DisplayTree.this.addSelectionPath(path);
                comp.showPopup((JComponent)event.getSource(), event.getX(), event.getY());
            }
        });
        this.loadComponents();
        String title = displayControl.toString();
        Dimension defaultDimension = new Dimension(300, 400);
        JScrollPane sp = GuiUtils.makeScrollPane(this, (int)defaultDimension.getWidth(), (int)defaultDimension.getHeight());
        sp.setPreferredSize(defaultDimension);
        JPanel buttons = GuiUtils.makeButtons(this, new String[]{GuiUtils.CMD_CLOSE});
        JPanel contents = GuiUtils.centerBottom(sp, buttons);
        this.frame = GuiUtils.createFrame(title);
        this.frame.getContentPane().add(contents);
        this.frame.pack();
    }

    public MultiDisplayHolder getDisplayControl() {
        return this.displayControl;
    }

    public void close() {
        if (this.frame != null) {
            this.frame.dispose();
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String cmd = ae.getActionCommand();
        if (cmd.equals(GuiUtils.CMD_CLOSE)) {
            this.close();
        }
    }

    public void show(Component src) {
        this.loadComponents();
        GuiUtils.showDialogNearSrc(src, this.frame);
    }

    @Override
    protected boolean okToDrag(DefaultMutableTreeNode sourceNode) {
        return sourceNode.getParent() != null;
    }

    @Override
    protected boolean okToDrop(DefaultMutableTreeNode sourceNode, DefaultMutableTreeNode destNode, boolean isOn) {
        MyTreeNode source = (MyTreeNode)sourceNode;
        MyTreeNode dest = (MyTreeNode)destNode;
        if (destNode == sourceNode.getParent()) {
            // empty if block
        }
        while (dest != null) {
            if (dest == sourceNode) {
                return false;
            }
            dest = (MyTreeNode)dest.getParent();
        }
        return true;
    }

    @Override
    protected void doDrop(DefaultMutableTreeNode sourceNode, DefaultMutableTreeNode destNode, boolean isOn) {
        try {
            MyTreeNode source = (MyTreeNode)sourceNode;
            MyTreeNode dest = (MyTreeNode)destNode;
            DisplayGroup oldGroup = source.comp.getDisplayGroup();
            if (oldGroup != null) {
                oldGroup.removeDisplayComponent(source.comp);
            } else if (source.comp instanceof DisplayGroup) {
                this.displayControl.removeDisplayGroup((DisplayGroup)source.comp);
            }
            DisplayGroup target = null;
            int index = -1;
            if (!dest.isGroup() || !isOn) {
                target = dest.comp.getDisplayGroup();
                if (target == null) {
                    index = 0;
                    target = (DisplayGroup)dest.comp;
                } else {
                    index = target.indexOf(dest.comp);
                    ++index;
                }
                target.addDisplayComponent(source.comp, index);
            } else if (isOn) {
                target = (DisplayGroup)dest.comp;
                target.addDisplayComponent(source.comp);
            } else {
                target = dest.comp.getDisplayGroup();
                if (target == null) {
                    // empty if block
                }
            }
            this.loadComponents();
            this.displayControl.showDisplayComponent(dest.comp);
        }
        catch (Exception exc) {
            LogUtil.logException("An error has occurred", exc);
        }
    }

    public void deleteSelected() {
        TreePath[] paths = this.getSelectionModel().getSelectionPaths();
        if (paths == null || paths.length == 0) {
            return;
        }
        DisplayComponent comp = this.findCompAtPath(paths[0]);
        if (comp == null) {
            return;
        }
        this.displayControl.removeDisplayComponent(comp);
    }

    protected void recurse(DisplayGroup displayGroup, MyTreeNode treeNode) {
        List displayComponents = displayGroup.getDisplayComponents();
        for (int i = 0; i < displayComponents.size(); ++i) {
            DisplayComponent displayComponent = (DisplayComponent)displayComponents.get(i);
            MyTreeNode childNode = new MyTreeNode(displayComponent);
            this.nodeToData.put(childNode, displayComponent);
            treeNode.add(childNode);
            if (!(displayComponent instanceof DisplayGroup)) continue;
            this.recurse((DisplayGroup)displayComponent, childNode);
        }
    }

    protected void loadComponents() {
        Enumeration<TreePath> paths = this.getExpandedDescendants(new TreePath(this.treeRoot.getPath()));
        Hashtable expandedState = GuiUtils.initializeExpandedPathsBeforeChange(this, this.treeRoot);
        this.nodeToData = new Hashtable();
        this.treeRoot.removeAllChildren();
        this.treeModel.nodeStructureChanged(this.treeRoot);
        List displayGroups = this.displayControl.getDisplayGroups();
        for (int groupIdx = 0; groupIdx < displayGroups.size(); ++groupIdx) {
            DisplayGroup displayGroup = (DisplayGroup)displayGroups.get(groupIdx);
            MyTreeNode treeNode = new MyTreeNode(displayGroup);
            this.nodeToData.put(treeNode, displayGroup);
            this.treeRoot.add(treeNode);
            this.recurse(displayGroup, treeNode);
        }
        this.treeModel.nodeStructureChanged(this.treeRoot);
        GuiUtils.expandPathsAfterChange(this, expandedState, this.treeRoot);
    }

    private DisplayComponent findCompAtPath(TreePath path) {
        if (path == null) {
            return null;
        }
        MyTreeNode last = (MyTreeNode)path.getLastPathComponent();
        if (last == null) {
            return null;
        }
        return last.comp;
    }

    private static class MyTreeNode
    extends DefaultMutableTreeNode {
        DisplayComponent comp;

        public MyTreeNode(DisplayComponent comp) {
            super(comp.getName());
            this.comp = comp;
        }

        public MyTreeNode() {
            super("");
        }

        public boolean isGroup() {
            return this.comp != null && this.comp instanceof DisplayGroup;
        }

        public boolean isComponent() {
            return this.comp != null;
        }
    }
}

