/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control.multi;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import ucar.unidata.idv.ControlContext;
import ucar.unidata.idv.control.multi.DisplayComponent;
import ucar.unidata.idv.control.multi.MultiDisplayHolder;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import visad.Real;
import visad.VisADException;

public class DisplayGroup
extends DisplayComponent {
    public static final int LAYOUT_GRIDBAG = 0;
    public static final int LAYOUT_GRID = 1;
    public static final int LAYOUT_TABS = 2;
    public static final int LAYOUT_HSPLIT = 3;
    public static final int LAYOUT_VSPLIT = 4;
    private int layout = 1;
    protected JComponent container;
    protected JComponent outerContainer;
    private List displayComponents = new ArrayList();
    private JTabbedPane tabbedPane;
    private int gridColumns = 1;
    private int numRows = 0;
    private int numColumns = 1;
    private Rectangle lastPosition;
    private boolean iconified = false;
    private Vector propertiesList;
    private JTextField dimFld;
    private JTextField colFld;
    private JRadioButton tabLayoutBtn;
    private JRadioButton hsplitLayoutBtn;
    private JRadioButton vsplitLayoutBtn;
    private JRadioButton gridLayoutBtn;
    private JRadioButton gridbagLayoutBtn;
    private JRadioButton rowBtn;
    private JList displayList;
    private boolean displayOrderChanged;

    public DisplayGroup() {
    }

    public DisplayGroup(String name) {
        super(name);
    }

    @Override
    public String getTypeName() {
        return "Group";
    }

    @Override
    public void initDone() {
        for (int i = 0; i < this.displayComponents.size(); ++i) {
            ((DisplayComponent)this.displayComponents.get(i)).initDone();
        }
    }

    @Override
    public void initAfterUnPersistence(MultiDisplayHolder displayControl, ControlContext vc, Hashtable properties) {
        super.initAfterUnPersistence(displayControl, vc, properties);
        for (int i = 0; i < this.displayComponents.size(); ++i) {
            ((DisplayComponent)this.displayComponents.get(i)).initAfterUnPersistence(displayControl, vc, properties);
        }
    }

    @Override
    public JComponent doMakeContents() {
        this.tabbedPane = new JTabbedPane();
        this.container = new JPanel(new GridLayout(this.numRows, this.numColumns, 5, 5));
        JLabel label = this.getDisplayLabel();
        label.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (!SwingUtilities.isRightMouseButton(e)) {
                    return;
                }
                DisplayGroup.this.showPopup(DisplayGroup.this.getDisplayLabel(), e.getX(), e.getY());
            }
        });
        this.outerContainer = GuiUtils.topCenter(label, this.container);
        if (this.displayComponents.size() == 0) {
            // empty if block
        }
        this.redoLayout();
        this.setName(this.getName());
        return this.outerContainer;
    }

    public DisplayGroup getAncestorGroup() {
        if (this.getDisplayGroup() == null) {
            return this;
        }
        return this.getDisplayGroup().getAncestorGroup();
    }

    public List findDisplayComponents(Class compClass) {
        ArrayList<DisplayComponent> comps = new ArrayList<DisplayComponent>();
        for (int i = 0; i < this.displayComponents.size(); ++i) {
            DisplayComponent displayComponent = (DisplayComponent)this.displayComponents.get(i);
            if (compClass.isAssignableFrom(displayComponent.getClass())) {
                comps.add(displayComponent);
            }
            if (!(displayComponent instanceof DisplayGroup)) continue;
            comps.addAll(((DisplayGroup)displayComponent).findDisplayComponents(compClass));
        }
        return comps;
    }

    private void redoLayout() {
        this.tabbedPane.removeAll();
        this.container.removeAll();
        if (this.layout == 1) {
            this.container.setLayout(new GridLayout(this.numRows, this.numColumns, 5, 5));
        } else {
            this.container.setLayout(new BorderLayout());
        }
        ArrayList<JComponent> comps = new ArrayList<JComponent>();
        for (int i = 0; i < this.displayComponents.size(); ++i) {
            DisplayComponent displayComponent = (DisplayComponent)this.displayComponents.get(i);
            JComponent comp = displayComponent.getContents();
            if (this.layout == 2) {
                this.tabbedPane.add(displayComponent.getName(), comp);
                continue;
            }
            if (this.layout == 1) {
                this.container.add(comp);
                continue;
            }
            comps.add(comp);
        }
        if (this.layout == 2) {
            this.container.add("Center", this.tabbedPane);
        } else if (this.layout != 1) {
            if (this.layout == 3) {
                if (comps.size() > 0) {
                    this.container.add("Center", GuiUtils.doMultiSplitPane(comps, true));
                }
            } else if (this.layout == 4) {
                if (comps.size() > 0) {
                    this.container.add("Center", GuiUtils.doMultiSplitPane(comps, false));
                }
            } else {
                this.container.add("Center", GuiUtils.doLayout(comps, this.gridColumns, GuiUtils.WT_Y, GuiUtils.WT_Y));
            }
        }
        this.container.validate();
    }

    public void addDisplayComponent(DisplayComponent displayComponent) {
        this.addDisplayComponent(displayComponent, -1);
    }

    public int indexOf(DisplayComponent displayComponent) {
        return this.displayComponents.indexOf(displayComponent);
    }

    public void addDisplayComponent(DisplayComponent displayComponent, int index) {
        displayComponent.setDisplayControl(this.getDisplayControl());
        if (index >= 0) {
            this.displayComponents.add(index, displayComponent);
        } else {
            this.displayComponents.add(displayComponent);
        }
        displayComponent.setDisplayGroup(this);
        this.redoLayout();
    }

    @Override
    public void setDisplayControl(MultiDisplayHolder displayControl) {
        super.setDisplayControl(displayControl);
        for (int i = 0; i < this.displayComponents.size(); ++i) {
            ((DisplayComponent)this.displayComponents.get(i)).setDisplayControl(displayControl);
        }
    }

    @Override
    protected boolean applyProperties() {
        String oldName = this.getName();
        boolean result = super.applyProperties();
        if (!result) {
            return false;
        }
        try {
            if (this.displayComponents.size() != this.propertiesList.size()) {
                for (int i = 0; i < this.displayComponents.size(); ++i) {
                    DisplayComponent displayComponent = (DisplayComponent)this.displayComponents.get(i);
                }
            }
            if (this.displayOrderChanged) {
                this.displayComponents = new ArrayList(this.propertiesList);
            }
            if (this.hsplitLayoutBtn.isSelected()) {
                this.layout = 3;
            }
            if (this.vsplitLayoutBtn.isSelected()) {
                this.layout = 4;
            }
            if (this.tabLayoutBtn.isSelected()) {
                this.layout = 2;
            }
            if (this.gridLayoutBtn.isSelected()) {
                this.layout = 1;
            }
            if (this.gridbagLayoutBtn.isSelected()) {
                this.layout = 0;
            }
            if (this.rowBtn.isSelected()) {
                this.setRowsColumns(new Integer(this.dimFld.getText().trim()), 0);
            } else {
                this.setRowsColumns(0, new Integer(this.dimFld.getText().trim()));
            }
            this.setGridColumns(new Integer(this.colFld.getText().trim()));
            this.redoLayout();
        }
        catch (NumberFormatException nfe) {
            LogUtil.userErrorMessage("Bad number format " + nfe);
            return false;
        }
        String newName = this.getName();
        if (!newName.equals(oldName)) {
            this.getDisplayControl().newName(this, oldName);
        }
        return result;
    }

    @Override
    protected void getPropertiesComponents(List comps, int tabIdx) {
        super.getPropertiesComponents(comps, tabIdx);
        ButtonGroup bg = new ButtonGroup();
        boolean fixedRows = this.getNumRows() != 0;
        this.displayOrderChanged = false;
        this.propertiesList = new Vector(this.displayComponents);
        this.displayList = new JList(this.propertiesList);
        this.displayList.setToolTipText("Press 'delete' to remove selected display");
        JComponent displayPanel = GuiUtils.makeScrollPane(this.displayList, 300, 100);
        this.displayList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                DisplayComponent comp;
                if (event.getClickCount() > 1 && (comp = (DisplayComponent)DisplayGroup.this.displayList.getSelectedValue()) != null) {
                    comp.showProperties();
                }
            }
        });
        this.displayList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (GuiUtils.isDeleteEvent(e) && DisplayGroup.this.displayList.getSelectedIndex() >= 0) {
                    DisplayGroup.this.displayOrderChanged = true;
                    DisplayGroup.this.propertiesList.remove(DisplayGroup.this.displayList.getSelectedIndex());
                    DisplayGroup.this.displayList.setListData(new Vector(DisplayGroup.this.propertiesList));
                }
            }
        });
        JButton upButton = GuiUtils.getImageButton("/auxdata/ui/icons/Up16.gif", this.getClass());
        upButton.setActionCommand("up");
        upButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                int selectedIndex = DisplayGroup.this.displayList.getSelectedIndex();
                if (selectedIndex > 0) {
                    DisplayGroup.this.displayOrderChanged = true;
                    Object o = DisplayGroup.this.propertiesList.remove(selectedIndex);
                    DisplayGroup.this.propertiesList.add(selectedIndex - 1, o);
                    DisplayGroup.this.displayList.setListData(new Vector(DisplayGroup.this.propertiesList));
                    DisplayGroup.this.displayList.setSelectedIndex(DisplayGroup.this.propertiesList.indexOf(o));
                }
            }
        });
        JButton downButton = GuiUtils.getImageButton("/auxdata/ui/icons/Down16.gif", this.getClass());
        downButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                int selectedIndex = DisplayGroup.this.displayList.getSelectedIndex();
                if (selectedIndex < DisplayGroup.this.propertiesList.size() - 1) {
                    DisplayGroup.this.displayOrderChanged = true;
                    Object o = DisplayGroup.this.propertiesList.remove(selectedIndex);
                    DisplayGroup.this.propertiesList.add(selectedIndex + 1, o);
                    DisplayGroup.this.displayList.setListData(new Vector(DisplayGroup.this.propertiesList));
                    DisplayGroup.this.displayList.setSelectedIndex(DisplayGroup.this.propertiesList.indexOf(o));
                }
            }
        });
        displayPanel = GuiUtils.centerRight(displayPanel, GuiUtils.top(GuiUtils.vbox(upButton, downButton)));
        this.rowBtn = new JRadioButton("Rows", fixedRows);
        JRadioButton colBtn = new JRadioButton("Columns", !fixedRows);
        bg.add(this.rowBtn);
        bg.add(colBtn);
        this.hsplitLayoutBtn = new JRadioButton("Horizontal Split Pane ", this.layout == 3);
        this.vsplitLayoutBtn = new JRadioButton("Vertical Split Pane ", this.layout == 4);
        this.tabLayoutBtn = new JRadioButton("Tabs ", this.layout == 2);
        this.gridLayoutBtn = new JRadioButton("Grid ", this.layout == 1);
        this.gridbagLayoutBtn = new JRadioButton("Columns ", this.layout == 0);
        ButtonGroup group = GuiUtils.buttonGroup(this.tabLayoutBtn, this.gridLayoutBtn);
        group.add(this.gridbagLayoutBtn);
        group.add(this.hsplitLayoutBtn);
        group.add(this.vsplitLayoutBtn);
        this.dimFld = new JTextField((fixedRows ? this.getNumRows() : this.getNumColumns()) + "", 5);
        this.colFld = new JTextField(this.getGridColumns() + "", 5);
        comps.add(GuiUtils.rLabel("Layout: "));
        comps.add(GuiUtils.left(GuiUtils.hbox((Component)this.tabLayoutBtn, (Component)this.hsplitLayoutBtn, this.vsplitLayoutBtn)));
        comps.add(GuiUtils.filler());
        comps.add(GuiUtils.left(GuiUtils.hbox((Component)this.gridLayoutBtn, (Component)new JLabel("  Dimension: "), (Component)this.dimFld, GuiUtils.hbox(colBtn, this.rowBtn))));
        comps.add(GuiUtils.filler());
        comps.add(GuiUtils.left(GuiUtils.hbox((Component)this.gridbagLayoutBtn, (Component)new JLabel("  # Columns: "), this.colFld)));
        comps.add(GuiUtils.top(GuiUtils.rLabel("Displays: ")));
        comps.add(displayPanel);
    }

    @Override
    public void animationTimeChanged(Real time) {
        super.animationTimeChanged(time);
        for (int i = 0; i < this.displayComponents.size(); ++i) {
            ((DisplayComponent)this.displayComponents.get(i)).animationTimeChanged(time);
        }
    }

    public void removeDisplayComponent(DisplayComponent displayComponent) {
        this.displayComponents.remove(displayComponent);
        displayComponent.setDisplayGroup(null);
        this.getContents();
        this.redoLayout();
        this.container.validate();
        this.getContents().repaint();
    }

    @Override
    public void doRemove() {
        super.doRemove();
        for (int i = 0; i < this.displayComponents.size(); ++i) {
            ((DisplayComponent)this.displayComponents.get(i)).doRemove();
        }
    }

    @Override
    public void loadData() throws RemoteException, VisADException {
        super.loadData();
        for (int i = 0; i < this.displayComponents.size(); ++i) {
            ((DisplayComponent)this.displayComponents.get(i)).loadData();
        }
    }

    @Override
    protected List getPopupMenuItems(List items) {
        super.getPopupMenuItems(items);
        items.add("separator");
        items.add(GuiUtils.makeMenuItem("Save Image...", this, "doSaveImage"));
        items.add(GuiUtils.makeMenuItem("Save Movie...", this, "doSaveMovie"));
        items.add("separator");
        JMenu newMenu = new JMenu("New");
        items.add(newMenu);
        this.getDisplayControl().addGroupNewMenu(this, newMenu);
        return items;
    }

    public void setDisplayComponents(List value) {
        this.displayComponents = value;
    }

    public List getDisplayComponents() {
        return this.displayComponents;
    }

    public void setRowsColumns(int rows, int cols) {
        this.numRows = rows;
        this.numColumns = cols;
    }

    public void setNumRows(int value) {
        this.numRows = value;
    }

    public int getNumRows() {
        return this.numRows;
    }

    public void setNumColumns(int value) {
        this.numColumns = value;
    }

    public int getNumColumns() {
        return this.numColumns;
    }

    @Override
    public String toString() {
        return "Group: " + this.getName();
    }

    public void setLastPosition(Rectangle value) {
        this.lastPosition = value;
    }

    public Rectangle getLastPosition() {
        return this.lastPosition;
    }

    public void setIconified(boolean value) {
        this.iconified = value;
    }

    public boolean getIconified() {
        return this.iconified;
    }

    public void setLayout(int value) {
        this.layout = value;
    }

    public int getLayout() {
        return this.layout;
    }

    public void setGridColumns(int value) {
        this.gridColumns = value;
    }

    public int getGridColumns() {
        return this.gridColumns;
    }
}

