/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control.multi;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JMenu;
import ucar.unidata.idv.ControlContext;
import ucar.unidata.idv.control.DisplayControlImpl;
import ucar.unidata.idv.control.multi.DisplayComponent;
import ucar.unidata.idv.control.multi.DisplayGroup;
import ucar.unidata.idv.control.multi.MultiDisplayHolder;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;

public class DisplayControlWrapper
extends DisplayComponent {
    public static final int DECORATION_NONE = 0;
    public static final int DECORATION_BORDER = 1;
    public static final int DECORATION_TITLEDBORDER = 2;
    public static final int[] DECORATIONS = new int[]{0, 1, 2};
    public static final String[] DECORATION_NAMES = new String[]{"None", "Border", "Titled Border"};
    private int decoration = 2;
    DisplayControlImpl myDisplayControl;
    JComponent myWrapper;
    private JComboBox decorationBox;

    public DisplayControlWrapper() {
    }

    public DisplayControlWrapper(DisplayControlImpl myDisplayControl) {
        this.myDisplayControl = myDisplayControl;
        this.myDisplayControl.addPropertyChangeListener(this);
        this.setName(myDisplayControl.getLabel());
    }

    @Override
    public void initAfterUnPersistence(MultiDisplayHolder displayControl, ControlContext vc, Hashtable properties) {
        super.initAfterUnPersistence(displayControl, vc, properties);
        if (this.myDisplayControl != null) {
            this.myDisplayControl.initAfterUnPersistence(vc, properties);
            this.myDisplayControl.addPropertyChangeListener(this);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (event.getPropertyName().equals("prop.removed")) {
            if (this.myDisplayControl != null) {
                this.myDisplayControl = null;
                DisplayGroup displayGroup = this.getDisplayGroup();
                if (displayGroup != null) {
                    displayGroup.removeDisplayComponent(this);
                }
                this.getDisplayControl().removeDisplayComponent(this);
            }
        } else {
            super.propertyChange(event);
        }
    }

    @Override
    protected void getPropertiesComponents(List comps, int tabIdx) {
        super.getPropertiesComponents(comps, tabIdx);
        if (tabIdx == 0) {
            this.decorationBox = GuiUtils.makeComboBox(DECORATIONS, DECORATION_NAMES, this.decoration);
            comps.add(GuiUtils.rLabel("Decoration: "));
            comps.add(this.decorationBox);
        }
    }

    @Override
    protected boolean applyProperties() {
        if (!super.applyProperties()) {
            return false;
        }
        this.decoration = GuiUtils.getValueFromBox(this.decorationBox);
        this.applyDecoration();
        return true;
    }

    private void applyDecoration() {
        if (this.decoration == 2) {
            this.myWrapper.setBorder(BorderFactory.createTitledBorder(this.getName()));
        } else if (this.decoration == 1) {
            this.myWrapper.setBorder(BorderFactory.createEtchedBorder());
        } else {
            this.myWrapper.setBorder(BorderFactory.createEmptyBorder());
        }
    }

    @Override
    protected List getPopupMenuItems(List items) {
        JMenu menu = new JMenu("File");
        items.add(menu);
        GuiUtils.makeMenu(menu, this.myDisplayControl.getFileMenuItems(new ArrayList()));
        menu = new JMenu("Edit");
        items.add(menu);
        GuiUtils.makeMenu(menu, this.myDisplayControl.getEditMenuItems(new ArrayList()));
        menu = new JMenu("View");
        items.add(menu);
        GuiUtils.makeMenu(menu, this.myDisplayControl.getViewMenuItems(new ArrayList()));
        items.add("separator");
        super.getPopupMenuItems(items);
        return items;
    }

    @Override
    public String getTypeName() {
        return "Display";
    }

    @Override
    public void doRemove() {
        if (this.myDisplayControl != null) {
            try {
                this.myDisplayControl.removePropertyChangeListener(this);
                DisplayControlImpl tmp = this.myDisplayControl;
                this.myDisplayControl = null;
                tmp.doRemove();
            }
            catch (Exception exc) {
                LogUtil.logException("Removing display", exc);
            }
        }
        super.doRemove();
    }

    @Override
    protected JComponent doMakeContents() {
        if (this.myWrapper == null) {
            JComponent innerComp = this.myDisplayControl.getMainPanel();
            this.myWrapper = GuiUtils.center(innerComp);
            this.applyDecoration();
        }
        return this.myWrapper;
    }

    @Override
    public String toString() {
        return this.myDisplayControl.toString();
    }

    public void setMyDisplayControl(DisplayControlImpl value) {
        this.myDisplayControl = value;
    }

    public DisplayControlImpl getMyDisplayControl() {
        return this.myDisplayControl;
    }

    public void setDecoration(int value) {
        this.decoration = value;
    }

    public int getDecoration() {
        return this.decoration;
    }
}

