/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control.multi;

import java.awt.Color;
import java.awt.Font;
import java.beans.PropertyChangeListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import ucar.unidata.collab.PropertiedThing;
import ucar.unidata.idv.ControlContext;
import ucar.unidata.idv.control.multi.DisplayGroup;
import ucar.unidata.idv.control.multi.MultiDisplayHolder;
import ucar.unidata.idv.ui.ImageSequenceGrabber;
import ucar.unidata.ui.ImageUtils;
import ucar.unidata.util.FileManager;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import visad.Real;
import visad.VisADException;

public abstract class DisplayComponent
extends PropertiedThing
implements PropertyChangeListener {
    public static final String PROP_REMOVED = "prop.removed";
    public boolean isRemoved = false;
    protected boolean hasBeenInitialized = false;
    public static final String CMD_SAVEIMAGE = "Save As...";
    public static final String CMD_SAVEMOVIE = "Save As Movie...";
    private DisplayGroup displayGroup;
    private JTextField propertiesNameFld;
    private JCheckBox labelShownCbx;
    protected JLabel displayLabel;
    private boolean labelShown = true;
    private String name = null;
    private JComponent contents;
    private Color backgroundColor = Color.white;
    protected MultiDisplayHolder displayControl;

    public DisplayComponent() {
    }

    public DisplayComponent(String name) {
        this.name = name;
    }

    public void initDone() {
        this.hasBeenInitialized = true;
    }

    public void initAfterUnPersistence(MultiDisplayHolder displayControl, ControlContext vc, Hashtable properties) {
        this.displayControl = displayControl;
        this.hasBeenInitialized = true;
    }

    protected abstract JComponent doMakeContents();

    public JComponent getContents() {
        if (this.contents == null) {
            this.contents = this.doMakeContents();
        }
        return this.contents;
    }

    public void setDisplayControl(MultiDisplayHolder displayControl) {
        this.displayControl = displayControl;
    }

    protected MultiDisplayHolder getDisplayControl() {
        return this.displayControl;
    }

    public void animationTimeChanged(Real time) {
    }

    public void loadData() throws RemoteException, VisADException {
    }

    public void doSaveMovie() {
        ImageSequenceGrabber isg = new ImageSequenceGrabber(this.getDisplayControl().getViewManager(), this.getContents());
    }

    public void doSaveImage() {
        String filename = FileManager.getWriteFile(FileManager.FILTER_IMAGEWRITE, ".jpg");
        if (filename != null) {
            try {
                ImageUtils.writeImageToFile(this.getContents(), filename);
            }
            catch (Exception exc) {
                LogUtil.logException("Error writing image", exc);
            }
        }
    }

    protected List addGroupMenuItems(List items) {
        if (this.displayGroup != null) {
            items.add("separator");
            items.add(GuiUtils.makeMenu("Parent " + this.displayGroup.toString(), this.displayGroup.getPopupMenuItems(new ArrayList())));
        }
        return items;
    }

    public List getDisplayables() {
        return new ArrayList();
    }

    public boolean removeDisplayComponent() {
        if (GuiUtils.askYesNo("Remove Display", "Are you sure you want to remove: " + this.toString())) {
            DisplayGroup displayGroup = this.getDisplayGroup();
            if (displayGroup != null) {
                displayGroup.removeDisplayComponent(this);
            }
            this.getDisplayControl().removeDisplayComponent(this);
            return true;
        }
        return false;
    }

    @Override
    protected boolean doApplyProperties() {
        if (!super.doApplyProperties()) {
            return false;
        }
        this.getDisplayControl().componentChanged();
        return true;
    }

    public void doRemove() {
        this.isRemoved = true;
        List displayables = this.getDisplayables();
        if (displayables.size() > 0) {
            this.getDisplayControl().removeDisplayables(displayables);
        }
        this.firePropertyChange(PROP_REMOVED, null, this);
    }

    public void setName(String value) {
        this.name = value;
        if (this.displayLabel != null) {
            this.displayLabel.setText(value);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setDisplayGroup(DisplayGroup value) {
        this.displayGroup = value;
    }

    public DisplayGroup getDisplayGroup() {
        return this.displayGroup;
    }

    public String toString() {
        return this.name;
    }

    public void setBackgroundColor(Color value) {
        this.backgroundColor = value;
        if (this.contents != null) {
            // empty if block
        }
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public String getTypeName() {
        return "";
    }

    @Override
    protected void getPropertiesComponents(List comps, int tabIdx) {
        super.getPropertiesComponents(comps, tabIdx);
        if (tabIdx != 0) {
            return;
        }
        this.propertiesNameFld = new JTextField(this.getName());
        this.labelShownCbx = new JCheckBox("Label Shown", this.getLabelShown());
        comps.add(GuiUtils.rLabel("Name: "));
        comps.add(GuiUtils.centerRight(this.propertiesNameFld, this.labelShownCbx));
    }

    @Override
    protected boolean applyProperties() {
        if (!super.applyProperties()) {
            return false;
        }
        this.setLabelShown(this.labelShownCbx.isSelected());
        this.setName(this.propertiesNameFld.getText().trim());
        return true;
    }

    protected List getPopupMenuItems(List items) {
        items.add(GuiUtils.makeMenuItem("Remove " + this.getTypeName(), this, "removeDisplayComponent"));
        return items;
    }

    @Override
    public boolean showProperties() {
        return this.showProperties(this.displayControl.getDisplayTree(), 0, 0);
    }

    public void showPopup(JComponent where, int x, int y) {
        ArrayList<Object> items = new ArrayList<Object>();
        this.getPopupMenuItems(items);
        items.add("separator");
        items.add(GuiUtils.makeMenuItem("Properties...", this, "showProperties"));
        if (items.size() == 0) {
            return;
        }
        GuiUtils.makePopupMenu(items).show(where, x, y);
    }

    protected JLabel getDisplayLabel() {
        return this.doMakeDisplayLabel();
    }

    protected JLabel doMakeDisplayLabel() {
        if (this.displayLabel == null) {
            this.displayLabel = GuiUtils.cLabel(this.getName());
            Font f = this.displayLabel.getFont();
            f = f.deriveFont(18.0f);
            this.displayLabel.setFont(f);
            if (!this.labelShown) {
                this.displayLabel.setVisible(false);
            }
        }
        return this.displayLabel;
    }

    public void setLabelShown(boolean value) {
        this.labelShown = value;
        if (this.displayLabel != null) {
            this.displayLabel.setVisible(value);
        }
    }

    public boolean getLabelShown() {
        return this.labelShown;
    }

    public void setIsRemoved(boolean value) {
        this.isRemoved = value;
    }

    public boolean getIsRemoved() {
        return this.isRemoved;
    }
}

